mod abos;
mod bos;

pub use crate::abos::Abos;
pub use crate::bos::Bos;

use std::{
    ffi::{CStr, OsStr},
    path::Path,
};

pub type AStr<'a> = Abos<'a, str>;

pub type Str<'a> = Bos<'a, str>;

#[cfg(feature = "unstable")]
pub type StaticAStr = Abos<'static, str>;

#[cfg(feature = "unstable")]
pub type StaticStr = Bos<'static, str>;

pub type AbosOsStr<'a> = Abos<'a, OsStr>;

pub type BosOsStr<'a> = Bos<'a, OsStr>;

pub type AbosCStr<'a> = Abos<'a, CStr>;

pub type BosCStr<'a> = Bos<'a, CStr>;

pub type AbosPath<'a> = Abos<'a, Path>;

pub type BosPath<'a> = Bos<'a, Path>;
