macro_rules! shared_impls {
    () => {
        impl<'b, T> Deref for Borrowned<'b, T> {
            type Target = T;

            fn deref(&self) -> &Self::Target {
                self.inner_ref()
            }
        }

        impl<'b, T> Borrow<T> for Borrowned<'b, T> {
            fn borrow(&self) -> &T {
                self.inner_ref()
            }
        }

        impl<'b, T> AsRef<T> for Borrowned<'b, T> {
            fn as_ref(&self) -> &T {
                self.inner_ref()
            }
        }

        impl<'b, T: Clone> Clone for Borrowned<'b, T> {
            fn clone(&self) -> Self {
                match self {
                    Borrowned::Owned(owned) => Borrowned::Owned(owned.clone()),
                    Borrowned::Borrowed(borrowed) => {
                        let borrowed = *borrowed as &T;
                        Borrowned::Owned(borrowed.clone())
                    }
                }
            }
        }

        impl<'b, T: PartialEq> PartialEq for Borrowned<'b, T> {
            fn eq(&self, other: &Self) -> bool {
                let b_self = self.inner_ref();
                let b_other = other.inner_ref();

                b_self.eq(b_other)
            }
        }

        impl<'b, T: PartialEq> PartialEq<T> for Borrowned<'b, T> {
            fn eq(&self, other: &T) -> bool {
                let b_self = self.inner_ref();

                b_self.eq(other)
            }
        }

        impl<'b, T: PartialOrd> PartialOrd for Borrowned<'b, T> {
            fn partial_cmp(&self, other: &Self) -> Option<Ordering> {
                let b_self = self.inner_ref();
                let b_other = other.inner_ref();

                b_self.partial_cmp(b_other)
            }
        }

        impl<'b, T: PartialOrd> PartialOrd<T> for Borrowned<'b, T> {
            fn partial_cmp(&self, other: &T) -> Option<Ordering> {
                let b_self = self.inner_ref();

                b_self.partial_cmp(other)
            }
        }

        impl<'b, T: Default> Default for Borrowned<'b, T> {
            fn default() -> Self {
                Self::Owned(T::default())
            }
        }

        impl<'i, 'b, T> IntoIterator for &'i Borrowned<'b, T>
        where
            &'i T: IntoIterator,
        {
            type Item = <&'i T as IntoIterator>::Item;

            type IntoIter = <&'i T as IntoIterator>::IntoIter;

            fn into_iter(self) -> Self::IntoIter {
                self.inner_ref().into_iter()
            }
        }

        impl<'b, T: Display> Display for Borrowned<'b, T> {
            fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                self.inner_ref().fmt(f)
            }
        }
    };
}
