use boostvoronoi::builder as VB;
use boostvoronoi::diagram as VD;
use boostvoronoi::file_reader as FR;
use boostvoronoi::BvError;
use std::io::{BufReader, Cursor};

type I = i32;
type F = f64;

#[allow(dead_code)]
fn almost_equal(x1: F, x2: F, y1: F, y2: F) -> bool {
    let delta = 0.000001;
    assert!(F::abs(x1 - x2) < delta, "{} != {}", x1, x2);
    assert!(F::abs(y1 - y2) < delta, "{} != {}", y1, y2);

    (F::abs(x1 - x2) < delta) && (F::abs(y1 - y2) < delta)
}

#[test]
fn sample_polygon_001() -> Result<(), BvError> {
    let output = {
        let input = r#"0
8
0 0 -3 5
-3 5 2 10
2 10 4 6
4 6 10 12
10 12 13 6
13 6 11 1
11 1 5 1
5 1 0 0
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 16);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 20);
    assert_eq!(output.edges().len(), 70);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), -3.0000000, v.y(), 5.0000000));
    assert_eq!(v.get_incident_edge()?.0, 5);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), 2.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 17);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), 6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 23);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 1.1169631, v.y(), 4.5584816));
    assert_eq!(v.get_incident_edge()?.0, 25);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 1.1068348, v.y(), 4.4944255));
    assert_eq!(v.get_incident_edge()?.0, 27);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), 1.6345790, v.y(), 3.6950503));
    assert_eq!(v.get_incident_edge()?.0, 29);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 4.5000000, v.y(), 3.5000000));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 3.6000000));
    assert_eq!(v.get_incident_edge()?.0, 39);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 4.8830369, v.y(), 11.4415184));
    assert_eq!(v.get_incident_edge()?.0, 41);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), 6.0710678, v.y(), 3.9289322));
    assert_eq!(v.get_incident_edge()?.0, 43);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 49);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), 11.0000000, v.y(), 1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 55);
    let v = output.vertices()[14].get();
    assert!(almost_equal(v.x(), 8.3718060, v.y(), 4.8819292));
    assert_eq!(v.get_incident_edge()?.0, 57);
    let v = output.vertices()[15].get();
    assert!(almost_equal(v.x(), 4.3333333, v.y(), 17.6666667));
    assert_eq!(v.get_incident_edge()?.0, 59);
    let v = output.vertices()[16].get();
    assert!(almost_equal(v.x(), 8.9993300, v.y(), 5.8335938));
    assert_eq!(v.get_incident_edge()?.0, 61);
    let v = output.vertices()[17].get();
    assert!(almost_equal(v.x(), 13.0000000, v.y(), 6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 65);
    let v = output.vertices()[18].get();
    assert!(almost_equal(v.x(), 10.0990195, v.y(), -50.4950976));
    assert_eq!(v.get_incident_edge()?.0, 67);
    let v = output.vertices()[19].get();
    assert!(almost_equal(v.x(), 11.0000000, v.y(), -60.0000000));
    assert_eq!(v.get_incident_edge()?.0, 69);
    Ok(())
}

#[test]
fn sample_polygon_002() -> Result<(), BvError> {
    let output = {
        let input = r#"0
14
0 0 -3 5
-3 5 2 10
2 10 4 6
4 6 10 12
10 12 13 6
13 6 11 1
11 1 5 1
5 1 0 0
1 2 0 5
0 5 5 2
5 2 1 2
10 3 8 6
8 6 10 8
10 8 10 3
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 28);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[16].get();
    assert_eq!(cell.id().0, 16);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[17].get();
    assert_eq!(cell.id().0, 17);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[18].get();
    assert_eq!(cell.id().0, 18);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[19].get();
    assert_eq!(cell.id().0, 19);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[20].get();
    assert_eq!(cell.id().0, 20);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[21].get();
    assert_eq!(cell.id().0, 21);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[22].get();
    assert_eq!(cell.id().0, 22);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[23].get();
    assert_eq!(cell.id().0, 23);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[24].get();
    assert_eq!(cell.id().0, 24);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[25].get();
    assert_eq!(cell.id().0, 25);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[26].get();
    assert_eq!(cell.id().0, 26);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[27].get();
    assert_eq!(cell.id().0, 27);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 43);
    assert_eq!(output.edges().len(), 140);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), -3.0000000, v.y(), 5.0000000));
    assert_eq!(v.get_incident_edge()?.0, 5);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 13);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), -0.0000000, v.y(), 5.0000000));
    assert_eq!(v.get_incident_edge()?.0, 19);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), -1.3189096, v.y(), 4.7930483));
    assert_eq!(v.get_incident_edge()?.0, 21);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), -1.2349376, v.y(), 4.5883541));
    assert_eq!(v.get_incident_edge()?.0, 23);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 1.0000000, v.y(), 2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 29);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), 0.0943791, v.y(), 1.6981264));
    assert_eq!(v.get_incident_edge()?.0, 31);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), 0.4984229, v.y(), 1.1267106));
    assert_eq!(v.get_incident_edge()?.0, 33);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 1.0000000, v.y(), 1.1088244));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), 2.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 41);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 0.8783735, v.y(), 6.4639558));
    assert_eq!(v.get_incident_edge()?.0, 43);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), 1.6656629, v.y(), 2.9235579));
    assert_eq!(v.get_incident_edge()?.0, 45);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), 1.4373458, v.y(), 6.5327684));
    assert_eq!(v.get_incident_edge()?.0, 47);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), 6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 53);
    let v = output.vertices()[14].get();
    assert!(almost_equal(v.x(), 2.5855967, v.y(), 5.2927983));
    assert_eq!(v.get_incident_edge()?.0, 55);
    let v = output.vertices()[15].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 61);
    let v = output.vertices()[16].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 65);
    let v = output.vertices()[17].get();
    assert!(almost_equal(v.x(), 4.9009805, v.y(), 1.4950976));
    assert_eq!(v.get_incident_edge()?.0, 67);
    let v = output.vertices()[18].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 1.5000000));
    assert_eq!(v.get_incident_edge()?.0, 69);
    let v = output.vertices()[19].get();
    assert!(almost_equal(v.x(), 8.0000000, v.y(), 6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 77);
    let v = output.vertices()[20].get();
    assert!(almost_equal(v.x(), 5.6591499, v.y(), 4.3408501));
    assert_eq!(v.get_incident_edge()?.0, 79);
    let v = output.vertices()[21].get();
    assert!(almost_equal(v.x(), 4.8830369, v.y(), 11.4415184));
    assert_eq!(v.get_incident_edge()?.0, 81);
    let v = output.vertices()[22].get();
    assert!(almost_equal(v.x(), 6.0324706, v.y(), 4.6883138));
    assert_eq!(v.get_incident_edge()?.0, 83);
    let v = output.vertices()[23].get();
    assert!(almost_equal(v.x(), 7.0000000, v.y(), 7.0000000));
    assert_eq!(v.get_incident_edge()?.0, 85);
    let v = output.vertices()[24].get();
    assert!(almost_equal(v.x(), 6.0022473, v.y(), 4.3830874));
    assert_eq!(v.get_incident_edge()?.0, 87);
    let v = output.vertices()[25].get();
    assert!(almost_equal(v.x(), 6.2742420, v.y(), 4.1237366));
    assert_eq!(v.get_incident_edge()?.0, 89);
    let v = output.vertices()[26].get();
    assert!(almost_equal(v.x(), 6.9276228, v.y(), 3.3578647));
    assert_eq!(v.get_incident_edge()?.0, 91);
    let v = output.vertices()[27].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 3.0000000));
    assert_eq!(v.get_incident_edge()?.0, 97);
    let v = output.vertices()[28].get();
    assert!(almost_equal(v.x(), 9.1254138, v.y(), 5.8885621));
    assert_eq!(v.get_incident_edge()?.0, 99);
    let v = output.vertices()[29].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 103);
    let v = output.vertices()[30].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 109);
    let v = output.vertices()[31].get();
    assert!(almost_equal(v.x(), 8.9296325, v.y(), 2.2864217));
    assert_eq!(v.get_incident_edge()?.0, 111);
    let v = output.vertices()[32].get();
    assert!(almost_equal(v.x(), 9.0000000, v.y(), 9.0000000));
    assert_eq!(v.get_incident_edge()?.0, 113);
    let v = output.vertices()[33].get();
    assert!(almost_equal(v.x(), 11.0000000, v.y(), 1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 119);
    let v = output.vertices()[34].get();
    assert!(almost_equal(v.x(), 9.5864741, v.y(), 9.4517384));
    assert_eq!(v.get_incident_edge()?.0, 121);
    let v = output.vertices()[35].get();
    assert!(almost_equal(v.x(), 10.3070132, v.y(), 2.0235643));
    assert_eq!(v.get_incident_edge()?.0, 123);
    let v = output.vertices()[36].get();
    assert!(almost_equal(v.x(), 10.8666208, v.y(), 3.0000000));
    assert_eq!(v.get_incident_edge()?.0, 125);
    let v = output.vertices()[37].get();
    assert!(almost_equal(v.x(), 10.9442719, v.y(), 8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 127);
    let v = output.vertices()[38].get();
    assert!(almost_equal(v.x(), 4.3333333, v.y(), 17.6666667));
    assert_eq!(v.get_incident_edge()?.0, 129);
    let v = output.vertices()[39].get();
    assert!(almost_equal(v.x(), 11.4318062, v.y(), 5.9347716));
    assert_eq!(v.get_incident_edge()?.0, 131);
    let v = output.vertices()[40].get();
    assert!(almost_equal(v.x(), 13.0000000, v.y(), 6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 135);
    let v = output.vertices()[41].get();
    assert!(almost_equal(v.x(), 10.0990195, v.y(), -50.4950976));
    assert_eq!(v.get_incident_edge()?.0, 137);
    let v = output.vertices()[42].get();
    assert!(almost_equal(v.x(), 11.0000000, v.y(), -60.0000000));
    assert_eq!(v.get_incident_edge()?.0, 139);
    Ok(())
}

#[test]
fn sample_polygon_003() -> Result<(), BvError> {
    let output = {
        let input = r#"0
8
0 0 0 8
0 8 4 12
4 12 9 13
9 13 13 13
13 13 13 4
13 4 10 0
10 0 5 -1
5 -1 0 0
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 16);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 14);
    assert_eq!(output.edges().len(), 58);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 7);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), -0.0000000, v.y(), 8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), 12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 17);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), -1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 23);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 9.0000000, v.y(), 13.0000000));
    assert_eq!(v.get_incident_edge()?.0, 29);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 4.0990195));
    assert_eq!(v.get_incident_edge()?.0, 31);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), -0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), 6.1198856, v.y(), 5.4650604));
    assert_eq!(v.get_incident_edge()?.0, 39);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 6.4458560, v.y(), 5.6395144));
    assert_eq!(v.get_incident_edge()?.0, 41);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), 13.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 47);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 6.8126625, v.y(), 6.0624458));
    assert_eq!(v.get_incident_edge()?.0, 49);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), 6.9719175, v.y(), 6.4469214));
    assert_eq!(v.get_incident_edge()?.0, 51);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), 9.3603922, v.y(), 9.3603922));
    assert_eq!(v.get_incident_edge()?.0, 53);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), 13.0000000, v.y(), 13.0000000));
    assert_eq!(v.get_incident_edge()?.0, 57);
    Ok(())
}

#[test]
fn sample_polygon_004() -> Result<(), BvError> {
    let output = {
        let input = r#"0
8
0 0 0 8
0 8 4 12
4 12 9 13
9 13 7 7
7 7 13 4
13 4 10 0
10 0 5 -1
5 -1 0 0
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 16);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 17);
    assert_eq!(output.edges().len(), 64);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 7);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), -0.0000000, v.y(), 8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), 12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 17);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), -1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 23);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 7.0000000, v.y(), 7.0000000));
    assert_eq!(v.get_incident_edge()?.0, 31);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 3.5148459, v.y(), 6.5441032));
    assert_eq!(v.get_incident_edge()?.0, 33);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), 4.1671843, v.y(), 7.9442719));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), 5.2408359, v.y(), 9.6814768));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 4.3444660, v.y(), 3.5616102));
    assert_eq!(v.get_incident_edge()?.0, 39);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), 9.0000000, v.y(), 13.0000000));
    assert_eq!(v.get_incident_edge()?.0, 43);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 3.2943300));
    assert_eq!(v.get_incident_edge()?.0, 45);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), 5.1374151, v.y(), 3.2748301));
    assert_eq!(v.get_incident_edge()?.0, 47);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), -0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 53);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), 8.1941104, v.y(), 2.8654834));
    assert_eq!(v.get_incident_edge()?.0, 55);
    let v = output.vertices()[14].get();
    assert!(almost_equal(v.x(), 13.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 59);
    let v = output.vertices()[15].get();
    assert!(almost_equal(v.x(), 15.9180581, v.y(), 10.6939806));
    assert_eq!(v.get_incident_edge()?.0, 61);
    let v = output.vertices()[16].get();
    assert!(almost_equal(v.x(), 16.4642857, v.y(), 10.9285714));
    assert_eq!(v.get_incident_edge()?.0, 63);
    Ok(())
}

#[test]
fn sample_polygon_005() -> Result<(), BvError> {
    let output = {
        let input = r#"0
6
0 0 10 0
10 0 16 -6
16 -6 22 0
22 0 22 -12
22 -12 10 -12
10 -12 0 0
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 12);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 11);
    assert_eq!(output.edges().len(), 44);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 5);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), -12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 13);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), -0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 17);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 8.3751585, v.y(), -3.9227144));
    assert_eq!(v.get_incident_edge()?.0, 19);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 16.0000000, v.y(), -6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 25);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 11.9498098, v.y(), -7.8370749));
    assert_eq!(v.get_incident_edge()?.0, 27);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), 13.5147186, v.y(), -8.4852814));
    assert_eq!(v.get_incident_edge()?.0, 29);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), 22.0000000, v.y(), -12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 18.4852814, v.y(), -8.4852814));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), 22.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 41);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 16.0000000, v.y(), 6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 43);
    Ok(())
}

#[test]
fn sample_polygon_006() -> Result<(), BvError> {
    let output = {
        let input = r#"0
7
0 0 0 10
0 10 6 10
6 10 10 7
10 7 14 10
14 10 20 10
20 10 20 0
20 0 0 0
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 14);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 14);
    assert_eq!(output.edges().len(), 54);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 7);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), -0.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), 6.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 17);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 4.5000000, v.y(), 5.5000000));
    assert_eq!(v.get_incident_edge()?.0, 19);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 4.8333333, v.y(), 4.8333333));
    assert_eq!(v.get_incident_edge()?.0, 21);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 7.0000000));
    assert_eq!(v.get_incident_edge()?.0, 27);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), 7.6666667, v.y(), 3.8888889));
    assert_eq!(v.get_incident_edge()?.0, 29);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), 14.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 12.3333333, v.y(), 3.8888889));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 15.3333333));
    assert_eq!(v.get_incident_edge()?.0, 39);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 20.0000000, v.y(), -0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 45);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), 15.1666667, v.y(), 4.8333333));
    assert_eq!(v.get_incident_edge()?.0, 47);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), 15.5000000, v.y(), 5.5000000));
    assert_eq!(v.get_incident_edge()?.0, 49);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), 20.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 53);
    Ok(())
}

#[test]
fn sample_polygon_007() -> Result<(), BvError> {
    let output = {
        let input = r#"0
12
0 0 8 3
8 3 10 13
10 13 16 6
16 6 16 15
16 15 25 10
25 10 15 1
15 1 27 -1
27 -1 14 -4
14 -4 13 3
13 3 11 -5
11 -5 10 0
10 0 0 0
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 24);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[16].get();
    assert_eq!(cell.id().0, 16);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[17].get();
    assert_eq!(cell.id().0, 17);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[18].get();
    assert_eq!(cell.id().0, 18);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[19].get();
    assert_eq!(cell.id().0, 19);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[20].get();
    assert_eq!(cell.id().0, 20);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[21].get();
    assert_eq!(cell.id().0, 21);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[22].get();
    assert_eq!(cell.id().0, 22);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[23].get();
    assert_eq!(cell.id().0, 23);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 39);
    assert_eq!(output.edges().len(), 124);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 5);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), 8.0000000, v.y(), 3.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), -5.3972466, v.y(), 14.3926577));
    assert_eq!(v.get_incident_edge()?.0, 13);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), -0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 21);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 13.0000000));
    assert_eq!(v.get_incident_edge()?.0, 25);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 8.5440037, v.y(), 1.5493233));
    assert_eq!(v.get_incident_edge()?.0, 27);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), -8.1756757, v.y(), 16.6351351));
    assert_eq!(v.get_incident_edge()?.0, 29);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), 11.0000000, v.y(), -5.0000000));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 4.9009805, v.y(), -6.2198039));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 2.1666667));
    assert_eq!(v.get_incident_edge()?.0, 39);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 11.1243311, v.y(), 0.2248662));
    assert_eq!(v.get_incident_edge()?.0, 41);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), 10.3499812, v.y(), 2.3999875));
    assert_eq!(v.get_incident_edge()?.0, 43);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), 10.3796042, v.y(), 2.5240792));
    assert_eq!(v.get_incident_edge()?.0, 45);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), 13.0000000, v.y(), 3.0000000));
    assert_eq!(v.get_incident_edge()?.0, 51);
    let v = output.vertices()[14].get();
    assert!(almost_equal(v.x(), 10.6203958, v.y(), 3.5949010));
    assert_eq!(v.get_incident_edge()?.0, 53);
    let v = output.vertices()[15].get();
    assert!(almost_equal(v.x(), 14.0000000, v.y(), -4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 59);
    let v = output.vertices()[16].get();
    assert!(almost_equal(v.x(), 12.6287894, v.y(), -4.1958872));
    assert_eq!(v.get_incident_edge()?.0, 61);
    let v = output.vertices()[17].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), -14.6000000));
    assert_eq!(v.get_incident_edge()?.0, 63);
    let v = output.vertices()[18].get();
    assert!(almost_equal(v.x(), 12.8181818, v.y(), -5.4545455));
    assert_eq!(v.get_incident_edge()?.0, 65);
    let v = output.vertices()[19].get();
    assert!(almost_equal(v.x(), 15.0000000, v.y(), 1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 73);
    let v = output.vertices()[20].get();
    assert!(almost_equal(v.x(), 11.8388155, v.y(), 5.9636818));
    assert_eq!(v.get_incident_edge()?.0, 75);
    let v = output.vertices()[21].get();
    assert!(almost_equal(v.x(), 14.2709180, v.y(), 1.8100911));
    assert_eq!(v.get_incident_edge()?.0, 77);
    let v = output.vertices()[22].get();
    assert!(almost_equal(v.x(), 16.0000000, v.y(), 6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 83);
    let v = output.vertices()[23].get();
    assert!(almost_equal(v.x(), 12.6706833, v.y(), 15.0000000));
    assert_eq!(v.get_incident_edge()?.0, 87);
    let v = output.vertices()[24].get();
    assert!(almost_equal(v.x(), 16.0000000, v.y(), 15.0000000));
    assert_eq!(v.get_incident_edge()?.0, 91);
    let v = output.vertices()[25].get();
    assert!(almost_equal(v.x(), 12.5925926, v.y(), 15.2222222));
    assert_eq!(v.get_incident_edge()?.0, 93);
    let v = output.vertices()[26].get();
    assert!(almost_equal(v.x(), 14.7857588, v.y(), -0.2854474));
    assert_eq!(v.get_incident_edge()?.0, 95);
    let v = output.vertices()[27].get();
    assert!(almost_equal(v.x(), 14.3846154, v.y(), 4.6153846));
    assert_eq!(v.get_incident_edge()?.0, 97);
    let v = output.vertices()[28].get();
    assert!(almost_equal(v.x(), 14.7957019, v.y(), 3.2565288));
    assert_eq!(v.get_incident_edge()?.0, 99);
    let v = output.vertices()[29].get();
    assert!(almost_equal(v.x(), 14.9966711, v.y(), 4.0033289));
    assert_eq!(v.get_incident_edge()?.0, 101);
    let v = output.vertices()[30].get();
    assert!(almost_equal(v.x(), 15.8206765, v.y(), -1.3447128));
    assert_eq!(v.get_incident_edge()?.0, 103);
    let v = output.vertices()[31].get();
    assert!(almost_equal(v.x(), 17.8259859, v.y(), 6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 105);
    let v = output.vertices()[32].get();
    assert!(almost_equal(v.x(), 19.3207627, v.y(), 9.3563158));
    assert_eq!(v.get_incident_edge()?.0, 107);
    let v = output.vertices()[33].get();
    assert!(almost_equal(v.x(), 25.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 111);
    let v = output.vertices()[34].get();
    assert!(almost_equal(v.x(), 27.0000000, v.y(), -1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 115);
    let v = output.vertices()[35].get();
    assert!(almost_equal(v.x(), 27.9636000, v.y(), 4.7816000));
    assert_eq!(v.get_incident_edge()?.0, 117);
    let v = output.vertices()[36].get();
    assert!(almost_equal(v.x(), 17.7500000, v.y(), -20.2500000));
    assert_eq!(v.get_incident_edge()?.0, 119);
    let v = output.vertices()[37].get();
    assert!(almost_equal(v.x(), 29.3945312, v.y(), 5.1171875));
    assert_eq!(v.get_incident_edge()?.0, 121);
    let v = output.vertices()[38].get();
    assert!(almost_equal(v.x(), 129.0000000, v.y(), -443.0000000));
    assert_eq!(v.get_incident_edge()?.0, 123);
    Ok(())
}

#[test]
fn sample_polygon_008() -> Result<(), BvError> {
    let output = {
        let input = r#"0
10
0 0 1 8
1 8 10 7
10 7 20 10
20 10 25 9
25 9 28 5
28 5 23 -2
23 -2 24 -7
24 -7 13 -9
13 -9 10 -3
10 -3 0 0
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 20);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[16].get();
    assert_eq!(cell.id().0, 16);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[17].get();
    assert_eq!(cell.id().0, 17);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[18].get();
    assert_eq!(cell.id().0, 18);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[19].get();
    assert_eq!(cell.id().0, 19);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 26);
    assert_eq!(output.edges().len(), 90);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 5);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), 1.0000000, v.y(), 8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), 4.8287081, v.y(), 3.1463387));
    assert_eq!(v.get_incident_edge()?.0, 13);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), -3.0000000));
    assert_eq!(v.get_incident_edge()?.0, 21);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 7.0000000));
    assert_eq!(v.get_incident_edge()?.0, 25);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 13.0000000, v.y(), -9.0000000));
    assert_eq!(v.get_incident_edge()?.0, 31);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), 9.4667833, v.y(), 2.2010493));
    assert_eq!(v.get_incident_edge()?.0, 33);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), -0.8865536, v.y(), -15.9432768));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 11.5000000, v.y(), 2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), -7.3529412, v.y(), -24.5098039));
    assert_eq!(v.get_incident_edge()?.0, 39);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 20.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 45);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), 23.0000000, v.y(), -2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 53);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), 16.5865390, v.y(), -1.8269220));
    assert_eq!(v.get_incident_edge()?.0, 55);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), 18.0869499, v.y(), -2.9826100));
    assert_eq!(v.get_incident_edge()?.0, 57);
    let v = output.vertices()[14].get();
    assert!(almost_equal(v.x(), 16.2962963, v.y(), 0.1481481));
    assert_eq!(v.get_incident_edge()?.0, 59);
    let v = output.vertices()[15].get();
    assert!(almost_equal(v.x(), 16.2237557, v.y(), 1.0911758));
    assert_eq!(v.get_incident_edge()?.0, 61);
    let v = output.vertices()[16].get();
    assert!(almost_equal(v.x(), 24.0000000, v.y(), -7.0000000));
    assert_eq!(v.get_incident_edge()?.0, 65);
    let v = output.vertices()[17].get();
    assert!(almost_equal(v.x(), 17.3847094, v.y(), 2.0109218));
    assert_eq!(v.get_incident_edge()?.0, 67);
    let v = output.vertices()[18].get();
    assert!(almost_equal(v.x(), 25.0000000, v.y(), 9.0000000));
    assert_eq!(v.get_incident_edge()?.0, 73);
    let v = output.vertices()[19].get();
    assert!(almost_equal(v.x(), 20.2785677, v.y(), 4.0812532));
    assert_eq!(v.get_incident_edge()?.0, 75);
    let v = output.vertices()[20].get();
    assert!(almost_equal(v.x(), 22.4383624, v.y(), 4.9353385));
    assert_eq!(v.get_incident_edge()?.0, 77);
    let v = output.vertices()[21].get();
    assert!(almost_equal(v.x(), 28.0000000, v.y(), 5.0000000));
    assert_eq!(v.get_incident_edge()?.0, 81);
    let v = output.vertices()[22].get();
    assert!(almost_equal(v.x(), 35.5411601, v.y(), -4.6917680));
    assert_eq!(v.get_incident_edge()?.0, 83);
    let v = output.vertices()[23].get();
    assert!(almost_equal(v.x(), 5.9065134, v.y(), 52.1586207));
    assert_eq!(v.get_incident_edge()?.0, 85);
    let v = output.vertices()[24].get();
    assert!(almost_equal(v.x(), 5.2027027, v.y(), 59.3243243));
    assert_eq!(v.get_incident_edge()?.0, 87);
    let v = output.vertices()[25].get();
    assert!(almost_equal(v.x(), 45.5000000, v.y(), -7.5000000));
    assert_eq!(v.get_incident_edge()?.0, 89);
    Ok(())
}

#[test]
fn sample_polygon_009() -> Result<(), BvError> {
    let output = {
        let input = r#"0
4
0 0 0 10
0 10 30 10
30 10 30 0
30 0 0 0
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 8);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 6);
    assert_eq!(output.edges().len(), 26);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 7);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), -0.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 5.0000000));
    assert_eq!(v.get_incident_edge()?.0, 13);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 30.0000000, v.y(), -0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 19);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 25.0000000, v.y(), 5.0000000));
    assert_eq!(v.get_incident_edge()?.0, 21);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 30.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 25);
    Ok(())
}

//#[ignore]
#[test]
fn sample_polygon_010() -> Result<(), BvError> {
    let output = {
        let input = r#"0
23
-12 4 -12 -4
-12 -4 -8 -4
-8 -4 -8 -1
-8 -1 -9 0
-9 0 -8 1
-8 1 -8 4
-8 4 -12 4
-4 4 -4 -4
-4 -4 0 -4
0 -4 0 4
0 4 -4 4
4 4 4 -4
4 -4 8 -4
8 -4 8 4
8 4 4 4
-4 -8 -8 -8
-8 -8 -8 -12
-8 -12 -4 -12
-4 -12 -4 -16
-4 -16 -8 -16
0 -8 2 -8
2 -8 4 -8
2 -8 2 -16
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 48);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[16].get();
    assert_eq!(cell.id().0, 16);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[17].get();
    assert_eq!(cell.id().0, 17);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[18].get();
    assert_eq!(cell.id().0, 18);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[19].get();
    assert_eq!(cell.id().0, 19);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[20].get();
    assert_eq!(cell.id().0, 20);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[21].get();
    assert_eq!(cell.id().0, 21);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[22].get();
    assert_eq!(cell.id().0, 22);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[23].get();
    assert_eq!(cell.id().0, 23);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[24].get();
    assert_eq!(cell.id().0, 24);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[25].get();
    assert_eq!(cell.id().0, 25);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[26].get();
    assert_eq!(cell.id().0, 26);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[27].get();
    assert_eq!(cell.id().0, 27);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[28].get();
    assert_eq!(cell.id().0, 28);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[29].get();
    assert_eq!(cell.id().0, 29);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[30].get();
    assert_eq!(cell.id().0, 30);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[31].get();
    assert_eq!(cell.id().0, 31);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[32].get();
    assert_eq!(cell.id().0, 32);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[33].get();
    assert_eq!(cell.id().0, 33);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[34].get();
    assert_eq!(cell.id().0, 34);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[35].get();
    assert_eq!(cell.id().0, 35);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[36].get();
    assert_eq!(cell.id().0, 36);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[37].get();
    assert_eq!(cell.id().0, 37);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[38].get();
    assert_eq!(cell.id().0, 38);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[39].get();
    assert_eq!(cell.id().0, 39);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[40].get();
    assert_eq!(cell.id().0, 40);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[41].get();
    assert_eq!(cell.id().0, 41);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[42].get();
    assert_eq!(cell.id().0, 42);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[43].get();
    assert_eq!(cell.id().0, 43);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[44].get();
    assert_eq!(cell.id().0, 44);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[45].get();
    assert_eq!(cell.id().0, 45);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[46].get();
    assert_eq!(cell.id().0, 46);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[47].get();
    assert_eq!(cell.id().0, 47);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 61);
    assert_eq!(output.edges().len(), 216);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), -12.0000000, v.y(), -4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 7);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), -12.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), -9.0000000, v.y(), -0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 19);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), -10.2426407, v.y(), -1.2426407));
    assert_eq!(v.get_incident_edge()?.0, 21);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), -10.2426407, v.y(), 1.2426407));
    assert_eq!(v.get_incident_edge()?.0, 23);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), -18.0000000, v.y(), -12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 31);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), -12.0000000, v.y(), -8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), -8.0000000, v.y(), -4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 41);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), -10.0000000, v.y(), -2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 43);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), -10.0000000, v.y(), -1.8284271));
    assert_eq!(v.get_incident_edge()?.0, 45);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), -8.0000000, v.y(), -1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 49);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), -8.0000000, v.y(), 1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 55);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), -10.0000000, v.y(), 1.8284271));
    assert_eq!(v.get_incident_edge()?.0, 57);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), -10.0000000, v.y(), 2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 59);
    let v = output.vertices()[14].get();
    assert!(almost_equal(v.x(), -8.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 63);
    let v = output.vertices()[15].get();
    assert!(almost_equal(v.x(), -8.0000000, v.y(), -12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 69);
    let v = output.vertices()[16].get();
    assert!(almost_equal(v.x(), -8.0000000, v.y(), -8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 73);
    let v = output.vertices()[17].get();
    assert!(almost_equal(v.x(), -22.0000000, v.y(), -14.0000000));
    assert_eq!(v.get_incident_edge()?.0, 75);
    let v = output.vertices()[18].get();
    assert!(almost_equal(v.x(), -8.0000000, v.y(), -14.0000000));
    assert_eq!(v.get_incident_edge()?.0, 77);
    let v = output.vertices()[19].get();
    assert!(almost_equal(v.x(), -8.0000000, v.y(), -6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 79);
    let v = output.vertices()[20].get();
    assert!(almost_equal(v.x(), -7.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 81);
    let v = output.vertices()[21].get();
    assert!(almost_equal(v.x(), -6.0000000, v.y(), -10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 83);
    let v = output.vertices()[22].get();
    assert!(almost_equal(v.x(), -4.0000000, v.y(), -16.0000000));
    assert_eq!(v.get_incident_edge()?.0, 89);
    let v = output.vertices()[23].get();
    assert!(almost_equal(v.x(), -6.0000000, v.y(), -14.0000000));
    assert_eq!(v.get_incident_edge()?.0, 91);
    let v = output.vertices()[24].get();
    assert!(almost_equal(v.x(), -4.0000000, v.y(), -12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 95);
    let v = output.vertices()[25].get();
    assert!(almost_equal(v.x(), -6.0000000, v.y(), -4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 103);
    let v = output.vertices()[26].get();
    assert!(almost_equal(v.x(), -6.0000000, v.y(), -1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 105);
    let v = output.vertices()[27].get();
    assert!(almost_equal(v.x(), -6.1250000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 107);
    let v = output.vertices()[28].get();
    assert!(almost_equal(v.x(), -6.0000000, v.y(), 1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 109);
    let v = output.vertices()[29].get();
    assert!(almost_equal(v.x(), -6.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 113);
    let v = output.vertices()[30].get();
    assert!(almost_equal(v.x(), -4.0000000, v.y(), -4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 117);
    let v = output.vertices()[31].get();
    assert!(almost_equal(v.x(), -4.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 121);
    let v = output.vertices()[32].get();
    assert!(almost_equal(v.x(), -6.0000000, v.y(), -5.5000000));
    assert_eq!(v.get_incident_edge()?.0, 123);
    let v = output.vertices()[33].get();
    assert!(almost_equal(v.x(), -4.0000000, v.y(), -10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 125);
    let v = output.vertices()[34].get();
    assert!(almost_equal(v.x(), -4.0000000, v.y(), -6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 127);
    let v = output.vertices()[35].get();
    assert!(almost_equal(v.x(), -0.0000000, v.y(), -4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 135);
    let v = output.vertices()[36].get();
    assert!(almost_equal(v.x(), -2.0000000, v.y(), -2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 137);
    let v = output.vertices()[37].get();
    assert!(almost_equal(v.x(), -2.0000000, v.y(), 2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 139);
    let v = output.vertices()[38].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 143);
    let v = output.vertices()[39].get();
    assert!(almost_equal(v.x(), -2.0000000, v.y(), -6.5000000));
    assert_eq!(v.get_incident_edge()?.0, 147);
    let v = output.vertices()[40].get();
    assert!(almost_equal(v.x(), -2.0000000, v.y(), -10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 149);
    let v = output.vertices()[41].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), -6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 151);
    let v = output.vertices()[42].get();
    assert!(almost_equal(v.x(), -1.0000000, v.y(), -16.0000000));
    assert_eq!(v.get_incident_edge()?.0, 157);
    let v = output.vertices()[43].get();
    assert!(almost_equal(v.x(), -1.0000000, v.y(), -12.0000000));
    assert_eq!(v.get_incident_edge()?.0, 159);
    let v = output.vertices()[44].get();
    assert!(almost_equal(v.x(), -1.1010205, v.y(), -10.8989795));
    assert_eq!(v.get_incident_edge()?.0, 161);
    let v = output.vertices()[45].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), -10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 163);
    let v = output.vertices()[46].get();
    assert!(almost_equal(v.x(), 2.0000000, v.y(), -8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 169);
    let v = output.vertices()[47].get();
    assert!(almost_equal(v.x(), 2.0000000, v.y(), -4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 177);
    let v = output.vertices()[48].get();
    assert!(almost_equal(v.x(), 2.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 181);
    let v = output.vertices()[49].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), -4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 185);
    let v = output.vertices()[50].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 189);
    let v = output.vertices()[51].get();
    assert!(almost_equal(v.x(), 2.0000000, v.y(), -5.5000000));
    assert_eq!(v.get_incident_edge()?.0, 191);
    let v = output.vertices()[52].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), -10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 193);
    let v = output.vertices()[53].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), -6.0000000));
    assert_eq!(v.get_incident_edge()?.0, 195);
    let v = output.vertices()[54].get();
    assert!(almost_equal(v.x(), 8.0000000, v.y(), -4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 201);
    let v = output.vertices()[55].get();
    assert!(almost_equal(v.x(), 6.0000000, v.y(), -2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 203);
    let v = output.vertices()[56].get();
    assert!(almost_equal(v.x(), 6.0000000, v.y(), 2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 205);
    let v = output.vertices()[57].get();
    assert!(almost_equal(v.x(), 8.0000000, v.y(), 4.0000000));
    assert_eq!(v.get_incident_edge()?.0, 209);
    let v = output.vertices()[58].get();
    assert!(almost_equal(v.x(), 8.0000000, v.y(), -8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 211);
    let v = output.vertices()[59].get();
    assert!(almost_equal(v.x(), 14.8989795, v.y(), -14.8989795));
    assert_eq!(v.get_incident_edge()?.0, 213);
    let v = output.vertices()[60].get();
    assert!(almost_equal(v.x(), 17.0000000, v.y(), -16.0000000));
    assert_eq!(v.get_incident_edge()?.0, 215);
    Ok(())
}

#[test]
fn sample_polygon_011() -> Result<(), BvError> {
    let output = {
        let input = r#"0
9
0 0 1 10
1 10 4 9
4 9 4 2
4 2 0 0
5 5 6 8
6 8 10 10
10 10 9 1
9 1 6 2
6 2 5 5
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 18);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[16].get();
    assert_eq!(cell.id().0, 16);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[17].get();
    assert_eq!(cell.id().0, 17);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 28);
    assert_eq!(output.edges().len(), 90);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 5);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), 1.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), 2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 17);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 2.1614009, v.y(), 3.1363167));
    assert_eq!(v.get_incident_edge()?.0, 19);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 2.3962019, v.y(), 7.8440477));
    assert_eq!(v.get_incident_edge()?.0, 21);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 4.0000000, v.y(), 9.0000000));
    assert_eq!(v.get_incident_edge()?.0, 25);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 5.0000000));
    assert_eq!(v.get_incident_edge()?.0, 33);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), 4.5131670, v.y(), 4.8377223));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 4.5131670, v.y(), 5.1622777));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), 4.9736660, v.y(), 2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 39);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 6.0000000, v.y(), 2.0000000));
    assert_eq!(v.get_incident_edge()?.0, 47);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), 6.0000000, v.y(), 8.0000000));
    assert_eq!(v.get_incident_edge()?.0, 51);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), 5.0263340, v.y(), 8.3245553));
    assert_eq!(v.get_incident_edge()?.0, 53);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), 1.6666667));
    assert_eq!(v.get_incident_edge()?.0, 55);
    let v = output.vertices()[14].get();
    assert!(almost_equal(v.x(), 5.2500000, v.y(), 9.0000000));
    assert_eq!(v.get_incident_edge()?.0, 57);
    let v = output.vertices()[15].get();
    assert!(almost_equal(v.x(), 5.3750000, v.y(), 9.2500000));
    assert_eq!(v.get_incident_edge()?.0, 59);
    let v = output.vertices()[16].get();
    assert!(almost_equal(v.x(), 5.0000000, v.y(), -0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 61);
    let v = output.vertices()[17].get();
    assert!(almost_equal(v.x(), 5.0343146, v.y(), -0.8970563));
    assert_eq!(v.get_incident_edge()?.0, 63);
    let v = output.vertices()[18].get();
    assert!(almost_equal(v.x(), 9.0000000, v.y(), 1.0000000));
    assert_eq!(v.get_incident_edge()?.0, 69);
    let v = output.vertices()[19].get();
    assert!(almost_equal(v.x(), 7.4392737, v.y(), 3.4392737));
    assert_eq!(v.get_incident_edge()?.0, 71);
    let v = output.vertices()[20].get();
    assert!(almost_equal(v.x(), 7.2739298, v.y(), 5.0000000));
    assert_eq!(v.get_incident_edge()?.0, 73);
    let v = output.vertices()[21].get();
    assert!(almost_equal(v.x(), 7.6235670, v.y(), 6.5918878));
    assert_eq!(v.get_incident_edge()?.0, 75);
    let v = output.vertices()[22].get();
    assert!(almost_equal(v.x(), 10.0000000, v.y(), 10.0000000));
    assert_eq!(v.get_incident_edge()?.0, 79);
    let v = output.vertices()[23].get();
    assert!(almost_equal(v.x(), 5.9313708, v.y(), 14.7941125));
    assert_eq!(v.get_incident_edge()?.0, 81);
    let v = output.vertices()[24].get();
    assert!(almost_equal(v.x(), 5.6544156, v.y(), 18.6911688));
    assert_eq!(v.get_incident_edge()?.0, 83);
    let v = output.vertices()[25].get();
    assert!(almost_equal(v.x(), 5.6201010, v.y(), -9.1396970));
    assert_eq!(v.get_incident_edge()?.0, 85);
    let v = output.vertices()[26].get();
    assert!(almost_equal(v.x(), 5.8571429, v.y(), -11.7142857));
    assert_eq!(v.get_incident_edge()?.0, 87);
    let v = output.vertices()[27].get();
    assert!(almost_equal(v.x(), 5.5000000, v.y(), 23.5000000));
    assert_eq!(v.get_incident_edge()?.0, 89);
    Ok(())
}

#[test]
fn sample_polygon_012() -> Result<(), BvError> {
    let output = {
        let input = r#"0
12
0 0 100 0
100 0 100 100
100 100 0 100
0 100 0 0
15 15 60 20
60 20 87 23
60 20 57 47
15 85 30 80
30 80 25 65
30 80 60 70
60 70 75 65
60 70 65 85
"#;
        let mut vb = VB::Builder::<I, F>::default();
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = FR::read_boost_input_buffer::<I, _>(br)?;
        vb.with_vertices(points.iter())?;
        vb.with_segments(segments.iter())?;
        vb.build()?
    };
    assert_eq!(output.cells().len(), 26);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[16].get();
    assert_eq!(cell.id().0, 16);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[17].get();
    assert_eq!(cell.id().0, 17);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[18].get();
    assert_eq!(cell.id().0, 18);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[19].get();
    assert_eq!(cell.id().0, 19);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[20].get();
    assert_eq!(cell.id().0, 20);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[21].get();
    assert_eq!(cell.id().0, 21);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[22].get();
    assert_eq!(cell.id().0, 22);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[23].get();
    assert_eq!(cell.id().0, 23);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[24].get();
    assert_eq!(cell.id().0, 24);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, VD::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[25].get();
    assert_eq!(cell.id().0, 25);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 35);
    assert_eq!(output.edges().len(), 120);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), 0.0000000, v.y(), 0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 7);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), -0.0000000, v.y(), 100.0000000));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), 8.7867966, v.y(), 8.7867966));
    assert_eq!(v.get_incident_edge()?.0, 21);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), 8.7867966, v.y(), 91.2132034));
    assert_eq!(v.get_incident_edge()?.0, 23);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), 11.3962039, v.y(), 74.1886117));
    assert_eq!(v.get_incident_edge()?.0, 25);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), 15.8307771, v.y(), 7.5230064));
    assert_eq!(v.get_incident_edge()?.0, 27);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), 17.4341649, v.y(), 92.3024947));
    assert_eq!(v.get_incident_edge()?.0, 33);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), 12.8291755, v.y(), 69.0569415));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), 13.2455532, v.y(), 71.6227766));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), 13.5082620, v.y(), 28.4256419));
    assert_eq!(v.get_incident_edge()?.0, 39);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), 30.0000000, v.y(), 80.0000000));
    assert_eq!(v.get_incident_edge()?.0, 45);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), 33.2455532, v.y(), 89.7366596));
    assert_eq!(v.get_incident_edge()?.0, 47);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), 24.4059656, v.y(), 40.6012648));
    assert_eq!(v.get_incident_edge()?.0, 49);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), 40.0000000, v.y(), 60.0000000));
    assert_eq!(v.get_incident_edge()?.0, 51);
    let v = output.vertices()[14].get();
    assert!(almost_equal(v.x(), 34.5333333, v.y(), 44.5037037));
    assert_eq!(v.get_incident_edge()?.0, 57);
    let v = output.vertices()[15].get();
    assert!(almost_equal(v.x(), 32.8588176, v.y(), 41.7129459));
    assert_eq!(v.get_incident_edge()?.0, 59);
    let v = output.vertices()[16].get();
    assert!(almost_equal(v.x(), 41.4538727, v.y(), 56.8068847));
    assert_eq!(v.get_incident_edge()?.0, 61);
    let v = output.vertices()[17].get();
    assert!(almost_equal(v.x(), 60.0000000, v.y(), 20.0000000));
    assert_eq!(v.get_incident_edge()?.0, 69);
    let v = output.vertices()[18].get();
    assert!(almost_equal(v.x(), 60.0000000, v.y(), 70.0000000));
    assert_eq!(v.get_incident_edge()?.0, 75);
    let v = output.vertices()[19].get();
    assert!(almost_equal(v.x(), 51.6227766, v.y(), 86.7544468));
    assert_eq!(v.get_incident_edge()?.0, 77);
    let v = output.vertices()[20].get();
    assert!(almost_equal(v.x(), 54.1886117, v.y(), 88.6037961));
    assert_eq!(v.get_incident_edge()?.0, 81);
    let v = output.vertices()[21].get();
    assert!(almost_equal(v.x(), 56.2638889, v.y(), 58.7916667));
    assert_eq!(v.get_incident_edge()?.0, 83);
    let v = output.vertices()[22].get();
    assert!(almost_equal(v.x(), 61.1077028, v.y(), 10.0306751));
    assert_eq!(v.get_incident_edge()?.0, 85);
    let v = output.vertices()[23].get();
    assert!(almost_equal(v.x(), 70.5000000, v.y(), 51.5000000));
    assert_eq!(v.get_incident_edge()?.0, 89);
    let v = output.vertices()[24].get();
    assert!(almost_equal(v.x(), 73.2000000, v.y(), 48.8000000));
    assert_eq!(v.get_incident_edge()?.0, 93);
    let v = output.vertices()[25].get();
    assert!(almost_equal(v.x(), 80.0000000, v.y(), 80.0000000));
    assert_eq!(v.get_incident_edge()?.0, 95);
    let v = output.vertices()[26].get();
    assert!(almost_equal(v.x(), 88.2738582, v.y(), 11.5352764));
    assert_eq!(v.get_incident_edge()?.0, 97);
    let v = output.vertices()[27].get();
    assert!(almost_equal(v.x(), 100.0000000, v.y(), -0.0000000));
    assert_eq!(v.get_incident_edge()?.0, 103);
    let v = output.vertices()[28].get();
    assert!(almost_equal(v.x(), 88.4540385, v.y(), 11.5459615));
    assert_eq!(v.get_incident_edge()?.0, 105);
    let v = output.vertices()[29].get();
    assert!(almost_equal(v.x(), 85.3861728, v.y(), 37.5244452));
    assert_eq!(v.get_incident_edge()?.0, 107);
    let v = output.vertices()[30].get();
    assert!(almost_equal(v.x(), 78.7624025, v.y(), 43.4530031));
    assert_eq!(v.get_incident_edge()?.0, 109);
    let v = output.vertices()[31].get();
    assert!(almost_equal(v.x(), 78.7288796, v.y(), 44.0582709));
    assert_eq!(v.get_incident_edge()?.0, 111);
    let v = output.vertices()[32].get();
    assert!(almost_equal(v.x(), 82.2875656, v.y(), 81.1437828));
    assert_eq!(v.get_incident_edge()?.0, 113);
    let v = output.vertices()[33].get();
    assert!(almost_equal(v.x(), 82.4037035, v.y(), 82.4037035));
    assert_eq!(v.get_incident_edge()?.0, 115);
    let v = output.vertices()[34].get();
    assert!(almost_equal(v.x(), 100.0000000, v.y(), 100.0000000));
    assert_eq!(v.get_incident_edge()?.0, 119);
    Ok(())
}
