use boostvoronoi as BV;
use boostvoronoi::prelude::*;
use std::io::{BufReader, Cursor};

mod common;
use common::almost_equal;

type I = i32;
type F = f64;

#[test]
fn sample_primary_065() -> Result<(), BvError> {
    let output = {
        let input = r#"0
87
-50061 -49176 -49997 -49195
-50024 -49880 -49980 -49904
-50001 -49559 -49983 -49632
-49990 -49437 -49931 -49440
-49971 -49300 -49894 -49240
-49938 -49762 -49923 -49826
-49938 -49133 -49864 -49064
-49923 -49874 -49852 -49836
-49897 -49640 -49866 -49683
-49895 -49859 -49840 -49829
-49889 -49210 -49828 -49159
-49857 -49380 -49795 -49428
-49841 -49551 -49836 -49502
-49833 -49320 -49791 -49333
-49828 -49707 -49779 -49627
-49821 -49526 -49800 -49565
-49817 -49714 -49729 -49752
-49806 -49111 -49733 -49060
-49796 -49803 -49787 -49787
-49761 -49652 -49679 -49721
-49756 -49266 -49727 -49249
-49754 -49465 -49656 -49532
-49740 -49146 -49706 -49152
-49726 -49236 -49710 -49163
-49717 -49215 -49617 -49303
-49702 -49809 -49680 -49735
-49702 -49370 -49678 -49415
-49677 -49849 -49636 -49917
-49641 -49057 -49560 -49083
-49632 -49692 -49548 -49776
-49627 -49640 -49627 -49572
-49626 -49932 -49565 -49834
-49605 -49426 -49547 -49466
-49597 -49185 -49526 -49250
-49542 -49652 -49454 -49751
-49540 -49283 -49471 -49298
-49537 -49845 -49500 -49927
-49527 -49420 -49473 -49518
-49519 -49092 -49483 -49162
-49517 -49235 -49442 -49292
-49511 -49972 -49504 -49938
-49504 -49827 -49458 -49784
-49494 -49323 -49485 -49413
-49481 -49509 -49443 -49578
-49461 -49606 -49427 -49598
-49435 -49153 -49403 -49183
-49419 -49762 -49376 -49792
-49417 -49832 -49334 -49899
-49408 -49887 -49398 -49973
-49388 -49221 -49365 -49277
-49381 -49444 -49374 -49522
-49379 -49434 -49336 -49457
-49373 -49220 -49367 -49171
-49369 -49140 -49317 -49239
-49367 -49538 -49291 -49562
-49364 -49102 -49293 -49109
-49346 -49652 -49332 -49605
-49343 -49810 -49295 -49850
-49337 -49198 -49292 -49238
-49322 -49092 -49309 -49041
-49317 -49349 -49315 -49396
-49312 -49203 -49294 -49126
-49297 -49988 -49256 -49977
-49295 -49580 -49213 -49491
-49291 -49641 -49278 -49656
-49286 -49601 -49250 -49672
-49283 -49914 -49281 -49847
-49281 -49590 -49250 -49601
-49273 -49379 -49232 -49312
-49257 -49616 -49231 -49621
-49245 -49884 -49202 -49841
-49234 -49059 -49156 -49135
-49225 -49336 -49164 -49360
-49207 -49354 -49204 -49372
-49188 -49136 -49160 -49168
-49171 -49946 -49108 -49855
-49169 -49415 -49101 -49453
-49158 -49164 -49136 -49122
-49130 -49925 -49097 -49841
-49127 -49675 -49047 -49676
-49109 -49435 -49011 -49528
-49104 -49909 -49084 -49859
-49082 -49602 -48992 -49566
-49073 -49130 -49002 -49081
-49064 -49936 -49025 -49978
-49044 -49020 -49028 -49012
-49010 -49234 -48949 -49210
"#;
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = BV::read_boost_input_buffer::<I, _>(br)?;
        let output = Builder::<I, F>::default()
            .with_vertices(points.iter())?
            .with_segments(segments.iter())?
            .build()?;
        #[cfg(feature = "geo")]
        common::diagram_sanity_check(&output, &points, &segments, 0.0001)?;
        output
    };
    assert_eq!(output.cells().len(), 261);
    let cell = output.cells()[0].get();
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1].get();
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2].get();
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[3].get();
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[4].get();
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[5].get();
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[6].get();
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[7].get();
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[8].get();
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9].get();
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10].get();
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[11].get();
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12].get();
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[13].get();
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[14].get();
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[15].get();
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[16].get();
    assert_eq!(cell.id().0, 16);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[17].get();
    assert_eq!(cell.id().0, 17);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[18].get();
    assert_eq!(cell.id().0, 18);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[19].get();
    assert_eq!(cell.id().0, 19);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[20].get();
    assert_eq!(cell.id().0, 20);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[21].get();
    assert_eq!(cell.id().0, 21);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[22].get();
    assert_eq!(cell.id().0, 22);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[23].get();
    assert_eq!(cell.id().0, 23);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[24].get();
    assert_eq!(cell.id().0, 24);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[25].get();
    assert_eq!(cell.id().0, 25);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[26].get();
    assert_eq!(cell.id().0, 26);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[27].get();
    assert_eq!(cell.id().0, 27);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[28].get();
    assert_eq!(cell.id().0, 28);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[29].get();
    assert_eq!(cell.id().0, 29);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[30].get();
    assert_eq!(cell.id().0, 30);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[31].get();
    assert_eq!(cell.id().0, 31);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[32].get();
    assert_eq!(cell.id().0, 32);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[33].get();
    assert_eq!(cell.id().0, 33);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[34].get();
    assert_eq!(cell.id().0, 34);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[35].get();
    assert_eq!(cell.id().0, 35);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[36].get();
    assert_eq!(cell.id().0, 36);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[37].get();
    assert_eq!(cell.id().0, 37);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[38].get();
    assert_eq!(cell.id().0, 38);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[39].get();
    assert_eq!(cell.id().0, 39);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[40].get();
    assert_eq!(cell.id().0, 40);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[41].get();
    assert_eq!(cell.id().0, 41);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[42].get();
    assert_eq!(cell.id().0, 42);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[43].get();
    assert_eq!(cell.id().0, 43);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[44].get();
    assert_eq!(cell.id().0, 44);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[45].get();
    assert_eq!(cell.id().0, 45);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[46].get();
    assert_eq!(cell.id().0, 46);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[47].get();
    assert_eq!(cell.id().0, 47);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[48].get();
    assert_eq!(cell.id().0, 48);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[49].get();
    assert_eq!(cell.id().0, 49);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[50].get();
    assert_eq!(cell.id().0, 50);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[51].get();
    assert_eq!(cell.id().0, 51);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[52].get();
    assert_eq!(cell.id().0, 52);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[53].get();
    assert_eq!(cell.id().0, 53);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[54].get();
    assert_eq!(cell.id().0, 54);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[55].get();
    assert_eq!(cell.id().0, 55);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[56].get();
    assert_eq!(cell.id().0, 56);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[57].get();
    assert_eq!(cell.id().0, 57);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[58].get();
    assert_eq!(cell.id().0, 58);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[59].get();
    assert_eq!(cell.id().0, 59);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[60].get();
    assert_eq!(cell.id().0, 60);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[61].get();
    assert_eq!(cell.id().0, 61);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[62].get();
    assert_eq!(cell.id().0, 62);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[63].get();
    assert_eq!(cell.id().0, 63);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[64].get();
    assert_eq!(cell.id().0, 64);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[65].get();
    assert_eq!(cell.id().0, 65);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[66].get();
    assert_eq!(cell.id().0, 66);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[67].get();
    assert_eq!(cell.id().0, 67);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[68].get();
    assert_eq!(cell.id().0, 68);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[69].get();
    assert_eq!(cell.id().0, 69);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[70].get();
    assert_eq!(cell.id().0, 70);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[71].get();
    assert_eq!(cell.id().0, 71);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[72].get();
    assert_eq!(cell.id().0, 72);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[73].get();
    assert_eq!(cell.id().0, 73);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[74].get();
    assert_eq!(cell.id().0, 74);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[75].get();
    assert_eq!(cell.id().0, 75);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[76].get();
    assert_eq!(cell.id().0, 76);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[77].get();
    assert_eq!(cell.id().0, 77);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[78].get();
    assert_eq!(cell.id().0, 78);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[79].get();
    assert_eq!(cell.id().0, 79);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[80].get();
    assert_eq!(cell.id().0, 80);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[81].get();
    assert_eq!(cell.id().0, 81);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[82].get();
    assert_eq!(cell.id().0, 82);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[83].get();
    assert_eq!(cell.id().0, 83);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[84].get();
    assert_eq!(cell.id().0, 84);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[85].get();
    assert_eq!(cell.id().0, 85);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[86].get();
    assert_eq!(cell.id().0, 86);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[87].get();
    assert_eq!(cell.id().0, 87);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[88].get();
    assert_eq!(cell.id().0, 88);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[89].get();
    assert_eq!(cell.id().0, 89);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[90].get();
    assert_eq!(cell.id().0, 90);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[91].get();
    assert_eq!(cell.id().0, 91);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[92].get();
    assert_eq!(cell.id().0, 92);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[93].get();
    assert_eq!(cell.id().0, 93);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[94].get();
    assert_eq!(cell.id().0, 94);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[95].get();
    assert_eq!(cell.id().0, 95);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[96].get();
    assert_eq!(cell.id().0, 96);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[97].get();
    assert_eq!(cell.id().0, 97);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[98].get();
    assert_eq!(cell.id().0, 98);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[99].get();
    assert_eq!(cell.id().0, 99);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[100].get();
    assert_eq!(cell.id().0, 100);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[101].get();
    assert_eq!(cell.id().0, 101);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[102].get();
    assert_eq!(cell.id().0, 102);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[103].get();
    assert_eq!(cell.id().0, 103);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[104].get();
    assert_eq!(cell.id().0, 104);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[105].get();
    assert_eq!(cell.id().0, 105);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[106].get();
    assert_eq!(cell.id().0, 106);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[107].get();
    assert_eq!(cell.id().0, 107);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[108].get();
    assert_eq!(cell.id().0, 108);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[109].get();
    assert_eq!(cell.id().0, 109);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[110].get();
    assert_eq!(cell.id().0, 110);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[111].get();
    assert_eq!(cell.id().0, 111);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[112].get();
    assert_eq!(cell.id().0, 112);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[113].get();
    assert_eq!(cell.id().0, 113);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[114].get();
    assert_eq!(cell.id().0, 114);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[115].get();
    assert_eq!(cell.id().0, 115);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[116].get();
    assert_eq!(cell.id().0, 116);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[117].get();
    assert_eq!(cell.id().0, 117);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[118].get();
    assert_eq!(cell.id().0, 118);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[119].get();
    assert_eq!(cell.id().0, 119);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[120].get();
    assert_eq!(cell.id().0, 120);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[121].get();
    assert_eq!(cell.id().0, 121);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[122].get();
    assert_eq!(cell.id().0, 122);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[123].get();
    assert_eq!(cell.id().0, 123);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[124].get();
    assert_eq!(cell.id().0, 124);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[125].get();
    assert_eq!(cell.id().0, 125);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[126].get();
    assert_eq!(cell.id().0, 126);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[127].get();
    assert_eq!(cell.id().0, 127);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[128].get();
    assert_eq!(cell.id().0, 128);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[129].get();
    assert_eq!(cell.id().0, 129);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[130].get();
    assert_eq!(cell.id().0, 130);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[131].get();
    assert_eq!(cell.id().0, 131);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[132].get();
    assert_eq!(cell.id().0, 132);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[133].get();
    assert_eq!(cell.id().0, 133);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[134].get();
    assert_eq!(cell.id().0, 134);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[135].get();
    assert_eq!(cell.id().0, 135);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[136].get();
    assert_eq!(cell.id().0, 136);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[137].get();
    assert_eq!(cell.id().0, 137);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[138].get();
    assert_eq!(cell.id().0, 138);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[139].get();
    assert_eq!(cell.id().0, 139);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[140].get();
    assert_eq!(cell.id().0, 140);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[141].get();
    assert_eq!(cell.id().0, 141);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[142].get();
    assert_eq!(cell.id().0, 142);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[143].get();
    assert_eq!(cell.id().0, 143);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[144].get();
    assert_eq!(cell.id().0, 144);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[145].get();
    assert_eq!(cell.id().0, 145);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[146].get();
    assert_eq!(cell.id().0, 146);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[147].get();
    assert_eq!(cell.id().0, 147);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[148].get();
    assert_eq!(cell.id().0, 148);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[149].get();
    assert_eq!(cell.id().0, 149);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[150].get();
    assert_eq!(cell.id().0, 150);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[151].get();
    assert_eq!(cell.id().0, 151);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[152].get();
    assert_eq!(cell.id().0, 152);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[153].get();
    assert_eq!(cell.id().0, 153);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[154].get();
    assert_eq!(cell.id().0, 154);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[155].get();
    assert_eq!(cell.id().0, 155);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[156].get();
    assert_eq!(cell.id().0, 156);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[157].get();
    assert_eq!(cell.id().0, 157);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[158].get();
    assert_eq!(cell.id().0, 158);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[159].get();
    assert_eq!(cell.id().0, 159);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[160].get();
    assert_eq!(cell.id().0, 160);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[161].get();
    assert_eq!(cell.id().0, 161);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[162].get();
    assert_eq!(cell.id().0, 162);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[163].get();
    assert_eq!(cell.id().0, 163);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[164].get();
    assert_eq!(cell.id().0, 164);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[165].get();
    assert_eq!(cell.id().0, 165);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[166].get();
    assert_eq!(cell.id().0, 166);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[167].get();
    assert_eq!(cell.id().0, 167);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[168].get();
    assert_eq!(cell.id().0, 168);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[169].get();
    assert_eq!(cell.id().0, 169);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[170].get();
    assert_eq!(cell.id().0, 170);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[171].get();
    assert_eq!(cell.id().0, 171);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[172].get();
    assert_eq!(cell.id().0, 172);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[173].get();
    assert_eq!(cell.id().0, 173);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[174].get();
    assert_eq!(cell.id().0, 174);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[175].get();
    assert_eq!(cell.id().0, 175);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[176].get();
    assert_eq!(cell.id().0, 176);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[177].get();
    assert_eq!(cell.id().0, 177);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[178].get();
    assert_eq!(cell.id().0, 178);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[179].get();
    assert_eq!(cell.id().0, 179);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[180].get();
    assert_eq!(cell.id().0, 180);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[181].get();
    assert_eq!(cell.id().0, 181);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[182].get();
    assert_eq!(cell.id().0, 182);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[183].get();
    assert_eq!(cell.id().0, 183);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[184].get();
    assert_eq!(cell.id().0, 184);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[185].get();
    assert_eq!(cell.id().0, 185);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[186].get();
    assert_eq!(cell.id().0, 186);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[187].get();
    assert_eq!(cell.id().0, 187);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[188].get();
    assert_eq!(cell.id().0, 188);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[189].get();
    assert_eq!(cell.id().0, 189);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[190].get();
    assert_eq!(cell.id().0, 190);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[191].get();
    assert_eq!(cell.id().0, 191);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[192].get();
    assert_eq!(cell.id().0, 192);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[193].get();
    assert_eq!(cell.id().0, 193);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[194].get();
    assert_eq!(cell.id().0, 194);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[195].get();
    assert_eq!(cell.id().0, 195);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[196].get();
    assert_eq!(cell.id().0, 196);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[197].get();
    assert_eq!(cell.id().0, 197);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[198].get();
    assert_eq!(cell.id().0, 198);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[199].get();
    assert_eq!(cell.id().0, 199);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[200].get();
    assert_eq!(cell.id().0, 200);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[201].get();
    assert_eq!(cell.id().0, 201);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[202].get();
    assert_eq!(cell.id().0, 202);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[203].get();
    assert_eq!(cell.id().0, 203);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[204].get();
    assert_eq!(cell.id().0, 204);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[205].get();
    assert_eq!(cell.id().0, 205);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[206].get();
    assert_eq!(cell.id().0, 206);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[207].get();
    assert_eq!(cell.id().0, 207);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[208].get();
    assert_eq!(cell.id().0, 208);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[209].get();
    assert_eq!(cell.id().0, 209);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[210].get();
    assert_eq!(cell.id().0, 210);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[211].get();
    assert_eq!(cell.id().0, 211);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[212].get();
    assert_eq!(cell.id().0, 212);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[213].get();
    assert_eq!(cell.id().0, 213);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[214].get();
    assert_eq!(cell.id().0, 214);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[215].get();
    assert_eq!(cell.id().0, 215);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[216].get();
    assert_eq!(cell.id().0, 216);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[217].get();
    assert_eq!(cell.id().0, 217);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[218].get();
    assert_eq!(cell.id().0, 218);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[219].get();
    assert_eq!(cell.id().0, 219);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[220].get();
    assert_eq!(cell.id().0, 220);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[221].get();
    assert_eq!(cell.id().0, 221);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[222].get();
    assert_eq!(cell.id().0, 222);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[223].get();
    assert_eq!(cell.id().0, 223);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[224].get();
    assert_eq!(cell.id().0, 224);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[225].get();
    assert_eq!(cell.id().0, 225);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[226].get();
    assert_eq!(cell.id().0, 226);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[227].get();
    assert_eq!(cell.id().0, 227);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[228].get();
    assert_eq!(cell.id().0, 228);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[229].get();
    assert_eq!(cell.id().0, 229);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[230].get();
    assert_eq!(cell.id().0, 230);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[231].get();
    assert_eq!(cell.id().0, 231);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[232].get();
    assert_eq!(cell.id().0, 232);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[233].get();
    assert_eq!(cell.id().0, 233);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[234].get();
    assert_eq!(cell.id().0, 234);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[235].get();
    assert_eq!(cell.id().0, 235);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[236].get();
    assert_eq!(cell.id().0, 236);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[237].get();
    assert_eq!(cell.id().0, 237);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[238].get();
    assert_eq!(cell.id().0, 238);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[239].get();
    assert_eq!(cell.id().0, 239);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[240].get();
    assert_eq!(cell.id().0, 240);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[241].get();
    assert_eq!(cell.id().0, 241);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[242].get();
    assert_eq!(cell.id().0, 242);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[243].get();
    assert_eq!(cell.id().0, 243);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[244].get();
    assert_eq!(cell.id().0, 244);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[245].get();
    assert_eq!(cell.id().0, 245);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[246].get();
    assert_eq!(cell.id().0, 246);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[247].get();
    assert_eq!(cell.id().0, 247);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[248].get();
    assert_eq!(cell.id().0, 248);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[249].get();
    assert_eq!(cell.id().0, 249);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[250].get();
    assert_eq!(cell.id().0, 250);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[251].get();
    assert_eq!(cell.id().0, 251);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[252].get();
    assert_eq!(cell.id().0, 252);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[253].get();
    assert_eq!(cell.id().0, 253);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[254].get();
    assert_eq!(cell.id().0, 254);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[255].get();
    assert_eq!(cell.id().0, 255);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[256].get();
    assert_eq!(cell.id().0, 256);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[257].get();
    assert_eq!(cell.id().0, 257);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[258].get();
    assert_eq!(cell.id().0, 258);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[259].get();
    assert_eq!(cell.id().0, 259);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[260].get();
    assert_eq!(cell.id().0, 260);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 510);
    assert_eq!(output.edges().len(), 1540);
    let v = output.vertices()[0].get();
    assert!(almost_equal(v.x(), -51566.9638569, v.y(), -49608.1209698));
    assert_eq!(v.get_incident_edge()?.0, 11);
    let v = output.vertices()[1].get();
    assert!(almost_equal(v.x(), -50546.7531865, v.y(), -49448.2968438));
    assert_eq!(v.get_incident_edge()?.0, 19);
    let v = output.vertices()[2].get();
    assert!(almost_equal(v.x(), -50507.9471637, v.y(), -49684.0006705));
    assert_eq!(v.get_incident_edge()?.0, 21);
    let v = output.vertices()[3].get();
    assert!(almost_equal(v.x(), -50292.2735014, v.y(), -49708.2592195));
    assert_eq!(v.get_incident_edge()?.0, 27);
    let v = output.vertices()[4].get();
    assert!(almost_equal(v.x(), -50096.8210729, v.y(), -49296.6604562));
    assert_eq!(v.get_incident_edge()?.0, 33);
    let v = output.vertices()[5].get();
    assert!(almost_equal(v.x(), -50161.2605202, v.y(), -49343.4310227));
    assert_eq!(v.get_incident_edge()?.0, 35);
    let v = output.vertices()[6].get();
    assert!(almost_equal(v.x(), -50014.8540797, v.y(), -49255.1400578));
    assert_eq!(v.get_incident_edge()?.0, 37);
    let v = output.vertices()[7].get();
    assert!(almost_equal(v.x(), -50007.3950233, v.y(), -49253.2930534));
    assert_eq!(v.get_incident_edge()?.0, 39);
    let v = output.vertices()[8].get();
    assert!(almost_equal(v.x(), -50089.7510612, v.y(), -49741.7407520));
    assert_eq!(v.get_incident_edge()?.0, 49);
    let v = output.vertices()[9].get();
    assert!(almost_equal(v.x(), -50031.7915865, v.y(), -49783.9824031));
    assert_eq!(v.get_incident_edge()?.0, 51);
    let v = output.vertices()[10].get();
    assert!(almost_equal(v.x(), -49983.3258990, v.y(), -49148.9398703));
    assert_eq!(v.get_incident_edge()?.0, 53);
    let v = output.vertices()[11].get();
    assert!(almost_equal(v.x(), -49993.1126400, v.y(), -49498.2152538));
    assert_eq!(v.get_incident_edge()?.0, 55);
    let v = output.vertices()[12].get();
    assert!(almost_equal(v.x(), -49992.2045351, v.y(), -49821.7083144));
    assert_eq!(v.get_incident_edge()?.0, 59);
    let v = output.vertices()[13].get();
    assert!(almost_equal(v.x(), -49961.4776786, v.y(), -49870.0424107));
    assert_eq!(v.get_incident_edge()?.0, 67);
    let v = output.vertices()[14].get();
    assert!(almost_equal(v.x(), -49978.9502268, v.y(), -49839.1133344));
    assert_eq!(v.get_incident_edge()?.0, 69);
    let v = output.vertices()[15].get();
    assert!(almost_equal(v.x(), -50029.3059540, v.y(), -49069.2411083));
    assert_eq!(v.get_incident_edge()?.0, 71);
    let v = output.vertices()[16].get();
    assert!(almost_equal(v.x(), -49969.5775194, v.y(), -49850.0000000));
    assert_eq!(v.get_incident_edge()?.0, 73);
    let v = output.vertices()[17].get();
    assert!(almost_equal(v.x(), -49986.4748157, v.y(), -49367.6713759));
    assert_eq!(v.get_incident_edge()?.0, 75);
    let v = output.vertices()[18].get();
    assert!(almost_equal(v.x(), -49935.8450704, v.y(), -49850.0000000));
    assert_eq!(v.get_incident_edge()?.0, 77);
    let v = output.vertices()[19].get();
    assert!(almost_equal(v.x(), -49894.9970268, v.y(), -49859.0054509));
    assert_eq!(v.get_incident_edge()?.0, 87);
    let v = output.vertices()[20].get();
    assert!(almost_equal(v.x(), -49938.6097163, v.y(), -49621.0544506));
    assert_eq!(v.get_incident_edge()?.0, 91);
    let v = output.vertices()[21].get();
    assert!(almost_equal(v.x(), -49943.9386820, v.y(), -49209.2585105));
    assert_eq!(v.get_incident_edge()?.0, 97);
    let v = output.vertices()[22].get();
    assert!(almost_equal(v.x(), -50048.4130066, v.y(), -49014.5860509));
    assert_eq!(v.get_incident_edge()?.0, 99);
    let v = output.vertices()[23].get();
    assert!(almost_equal(v.x(), -49943.4898551, v.y(), -49673.5159420));
    assert_eq!(v.get_incident_edge()?.0, 101);
    let v = output.vertices()[24].get();
    assert!(almost_equal(v.x(), -49907.8059701, v.y(), -49222.2823383));
    assert_eq!(v.get_incident_edge()?.0, 103);
    let v = output.vertices()[25].get();
    assert!(almost_equal(v.x(), -49941.1371191, v.y(), -49189.0872576));
    assert_eq!(v.get_incident_edge()?.0, 105);
    let v = output.vertices()[26].get();
    assert!(almost_equal(v.x(), -49906.0215931, v.y(), -49839.9728669));
    assert_eq!(v.get_incident_edge()?.0, 107);
    let v = output.vertices()[27].get();
    assert!(almost_equal(v.x(), -49905.5819209, v.y(), -49839.5998117));
    assert_eq!(v.get_incident_edge()?.0, 109);
    let v = output.vertices()[28].get();
    assert!(almost_equal(v.x(), -49946.2646433, v.y(), -49692.0723765));
    assert_eq!(v.get_incident_edge()?.0, 111);
    let v = output.vertices()[29].get();
    assert!(almost_equal(v.x(), -49918.5184825, v.y(), -49174.6935798));
    assert_eq!(v.get_incident_edge()?.0, 113);
    let v = output.vertices()[30].get();
    assert!(almost_equal(v.x(), -49907.1173577, v.y(), -49166.1205149));
    assert_eq!(v.get_incident_edge()?.0, 119);
    let v = output.vertices()[31].get();
    assert!(almost_equal(v.x(), -49934.9540174, v.y(), -49517.7623427));
    assert_eq!(v.get_incident_edge()?.0, 121);
    let v = output.vertices()[32].get();
    assert!(almost_equal(v.x(), -49890.4060845, v.y(), -49818.3608011));
    assert_eq!(v.get_incident_edge()?.0, 127);
    let v = output.vertices()[33].get();
    assert!(almost_equal(v.x(), -49927.3811802, v.y(), -49368.8298777));
    assert_eq!(v.get_incident_edge()?.0, 129);
    let v = output.vertices()[34].get();
    assert!(almost_equal(v.x(), -49910.2989179, v.y(), -49714.9364292));
    assert_eq!(v.get_incident_edge()?.0, 131);
    let v = output.vertices()[35].get();
    assert!(almost_equal(v.x(), -49931.0067240, v.y(), -49364.2345817));
    assert_eq!(v.get_incident_edge()?.0, 133);
    let v = output.vertices()[36].get();
    assert!(almost_equal(v.x(), -49926.2400000, v.y(), -49357.4420000));
    assert_eq!(v.get_incident_edge()?.0, 135);
    let v = output.vertices()[37].get();
    assert!(almost_equal(v.x(), -49852.0941511, v.y(), -49835.8240860));
    assert_eq!(v.get_incident_edge()?.0, 139);
    let v = output.vertices()[38].get();
    assert!(almost_equal(v.x(), -49874.0238095, v.y(), -49227.9126984));
    assert_eq!(v.get_incident_edge()?.0, 141);
    let v = output.vertices()[39].get();
    assert!(almost_equal(v.x(), -49921.5778272, v.y(), -49542.7777727));
    assert_eq!(v.get_incident_edge()?.0, 147);
    let v = output.vertices()[40].get();
    assert!(almost_equal(v.x(), -49921.8096041, v.y(), -49539.4736010));
    assert_eq!(v.get_incident_edge()?.0, 149);
    let v = output.vertices()[41].get();
    assert!(almost_equal(v.x(), -49918.6041839, v.y(), -49564.2883786));
    assert_eq!(v.get_incident_edge()?.0, 153);
    let v = output.vertices()[42].get();
    assert!(almost_equal(v.x(), -49923.5394854, v.y(), -49524.4767733));
    assert_eq!(v.get_incident_edge()?.0, 155);
    let v = output.vertices()[43].get();
    assert!(almost_equal(v.x(), -49886.9537954, v.y(), -49418.6903190));
    assert_eq!(v.get_incident_edge()?.0, 157);
    let v = output.vertices()[44].get();
    assert!(almost_equal(v.x(), -49899.5026183, v.y(), -49495.5201410));
    assert_eq!(v.get_incident_edge()?.0, 161);
    let v = output.vertices()[45].get();
    assert!(almost_equal(v.x(), -49899.0664064, v.y(), -49328.3734374));
    assert_eq!(v.get_incident_edge()?.0, 167);
    let v = output.vertices()[46].get();
    assert!(almost_equal(v.x(), -49847.1650854, v.y(), -49695.2613852));
    assert_eq!(v.get_incident_edge()?.0, 175);
    let v = output.vertices()[47].get();
    assert!(almost_equal(v.x(), -49829.3619644, v.y(), -49530.5025962));
    assert_eq!(v.get_incident_edge()?.0, 181);
    let v = output.vertices()[48].get();
    assert!(almost_equal(v.x(), -49822.4399019, v.y(), -49710.4055601));
    assert_eq!(v.get_incident_edge()?.0, 187);
    let v = output.vertices()[49].get();
    assert!(almost_equal(v.x(), -49878.1162791, v.y(), -49744.2674419));
    assert_eq!(v.get_incident_edge()?.0, 189);
    let v = output.vertices()[50].get();
    assert!(almost_equal(v.x(), -49876.4615385, v.y(), -49747.5769231));
    assert_eq!(v.get_incident_edge()?.0, 191);
    let v = output.vertices()[51].get();
    assert!(almost_equal(v.x(), -49863.0804481, v.y(), -49279.6800916));
    assert_eq!(v.get_incident_edge()?.0, 193);
    let v = output.vertices()[52].get();
    assert!(almost_equal(v.x(), -49858.1791865, v.y(), -49122.9033259));
    assert_eq!(v.get_incident_edge()?.0, 195);
    let v = output.vertices()[53].get();
    assert!(almost_equal(v.x(), -49842.5847458, v.y(), -49350.9661017));
    assert_eq!(v.get_incident_edge()?.0, 197);
    let v = output.vertices()[54].get();
    assert!(almost_equal(v.x(), -49824.9644380, v.y(), -49552.6362818));
    assert_eq!(v.get_incident_edge()?.0, 199);
    let v = output.vertices()[55].get();
    assert!(almost_equal(v.x(), -49839.7035414, v.y(), -49664.0420880));
    assert_eq!(v.get_incident_edge()?.0, 201);
    let v = output.vertices()[56].get();
    assert!(almost_equal(v.x(), -49870.3093490, v.y(), -49773.4328602));
    assert_eq!(v.get_incident_edge()?.0, 203);
    let v = output.vertices()[57].get();
    assert!(almost_equal(v.x(), -49869.3415335, v.y(), -49449.3055755));
    assert_eq!(v.get_incident_edge()?.0, 205);
    let v = output.vertices()[58].get();
    assert!(almost_equal(v.x(), -49852.8796081, v.y(), -49118.5551796));
    assert_eq!(v.get_incident_edge()?.0, 211);
    let v = output.vertices()[59].get();
    assert!(almost_equal(v.x(), -49836.6360629, v.y(), -49353.6965812));
    assert_eq!(v.get_incident_edge()?.0, 213);
    let v = output.vertices()[60].get();
    assert!(almost_equal(v.x(), -49812.4723202, v.y(), -49703.5148467));
    assert_eq!(v.get_incident_edge()?.0, 215);
    let v = output.vertices()[61].get();
    assert!(almost_equal(v.x(), -49838.2956551, v.y(), -49091.5669786));
    assert_eq!(v.get_incident_edge()?.0, 217);
    let v = output.vertices()[62].get();
    assert!(almost_equal(v.x(), -49866.1642748, v.y(), -49764.8363008));
    assert_eq!(v.get_incident_edge()?.0, 221);
    let v = output.vertices()[63].get();
    assert!(almost_equal(v.x(), -49828.0471264, v.y(), -49580.1022989));
    assert_eq!(v.get_incident_edge()?.0, 223);
    let v = output.vertices()[64].get();
    assert!(almost_equal(v.x(), -49850.9915812, v.y(), -49606.8311399));
    assert_eq!(v.get_incident_edge()?.0, 231);
    let v = output.vertices()[65].get();
    assert!(almost_equal(v.x(), -49857.6129032, v.y(), -49765.6774194));
    assert_eq!(v.get_incident_edge()?.0, 233);
    let v = output.vertices()[66].get();
    assert!(almost_equal(v.x(), -49813.0473684, v.y(), -49504.3421053));
    assert_eq!(v.get_incident_edge()?.0, 237);
    let v = output.vertices()[67].get();
    assert!(almost_equal(v.x(), -49840.4595745, v.y(), -49777.9914894));
    assert_eq!(v.get_incident_edge()?.0, 239);
    let v = output.vertices()[68].get();
    assert!(almost_equal(v.x(), -49828.2431523, v.y(), -49079.1617624));
    assert_eq!(v.get_incident_edge()?.0, 241);
    let v = output.vertices()[69].get();
    assert!(almost_equal(v.x(), -49846.8352098, v.y(), -49767.8329580));
    assert_eq!(v.get_incident_edge()?.0, 245);
    let v = output.vertices()[70].get();
    assert!(almost_equal(v.x(), -49839.2293502, v.y(), -49765.4784953));
    assert_eq!(v.get_incident_edge()?.0, 247);
    let v = output.vertices()[71].get();
    assert!(almost_equal(v.x(), -49830.4976204, v.y(), -49762.5325885));
    assert_eq!(v.get_incident_edge()?.0, 249);
    let v = output.vertices()[72].get();
    assert!(almost_equal(v.x(), -49841.6516431, v.y(), -49612.1692659));
    assert_eq!(v.get_incident_edge()?.0, 251);
    let v = output.vertices()[73].get();
    assert!(almost_equal(v.x(), -49838.3534956, v.y(), -49610.2852371));
    assert_eq!(v.get_incident_edge()?.0, 253);
    let v = output.vertices()[74].get();
    assert!(almost_equal(v.x(), -49821.2001220, v.y(), -49461.8418243));
    assert_eq!(v.get_incident_edge()?.0, 257);
    let v = output.vertices()[75].get();
    assert!(almost_equal(v.x(), -49815.3289529, v.y(), -49604.7485163));
    assert_eq!(v.get_incident_edge()?.0, 259);
    let v = output.vertices()[76].get();
    assert!(almost_equal(v.x(), -49802.8445081, v.y(), -49371.2668723));
    assert_eq!(v.get_incident_edge()?.0, 261);
    let v = output.vertices()[77].get();
    assert!(almost_equal(v.x(), -49815.4128174, v.y(), -49263.1798715));
    assert_eq!(v.get_incident_edge()?.0, 271);
    let v = output.vertices()[78].get();
    assert!(almost_equal(v.x(), -49824.4815951, v.y(), -49250.2484663));
    assert_eq!(v.get_incident_edge()?.0, 273);
    let v = output.vertices()[79].get();
    assert!(almost_equal(v.x(), -49823.9512061, v.y(), -49247.4333247));
    assert_eq!(v.get_incident_edge()?.0, 279);
    let v = output.vertices()[80].get();
    assert!(almost_equal(v.x(), -49799.2967480, v.y(), -49473.9774775));
    assert_eq!(v.get_incident_edge()?.0, 281);
    let v = output.vertices()[81].get();
    assert!(almost_equal(v.x(), -49776.9127479, v.y(), -49670.9108019));
    assert_eq!(v.get_incident_edge()?.0, 283);
    let v = output.vertices()[82].get();
    assert!(almost_equal(v.x(), -49764.7560976, v.y(), -49635.7243902));
    assert_eq!(v.get_incident_edge()?.0, 285);
    let v = output.vertices()[83].get();
    assert!(almost_equal(v.x(), -49791.6343639, v.y(), -49490.9589774));
    assert_eq!(v.get_incident_edge()?.0, 287);
    let v = output.vertices()[84].get();
    assert!(almost_equal(v.x(), -49779.6384215, v.y(), -49296.2933619));
    assert_eq!(v.get_incident_edge()?.0, 289);
    let v = output.vertices()[85].get();
    assert!(almost_equal(v.x(), -49781.9642797, v.y(), -49145.4040703));
    assert_eq!(v.get_incident_edge()?.0, 295);
    let v = output.vertices()[86].get();
    assert!(almost_equal(v.x(), -49784.3763332, v.y(), -49149.9525140));
    assert_eq!(v.get_incident_edge()?.0, 297);
    let v = output.vertices()[87].get();
    assert!(almost_equal(v.x(), -49773.6196027, v.y(), -49691.2060960));
    assert_eq!(v.get_incident_edge()?.0, 299);
    let v = output.vertices()[88].get();
    assert!(almost_equal(v.x(), -49780.2763925, v.y(), -49503.4341263));
    assert_eq!(v.get_incident_edge()?.0, 301);
    let v = output.vertices()[89].get();
    assert!(almost_equal(v.x(), -49779.8883326, v.y(), -49503.8629483));
    assert_eq!(v.get_incident_edge()?.0, 303);
    let v = output.vertices()[90].get();
    assert!(almost_equal(v.x(), -49758.5577806, v.y(), -49228.8640481));
    assert_eq!(v.get_incident_edge()?.0, 315);
    let v = output.vertices()[91].get();
    assert!(almost_equal(v.x(), -49788.6595462, v.y(), -49210.2866564));
    assert_eq!(v.get_incident_edge()?.0, 317);
    let v = output.vertices()[92].get();
    assert!(almost_equal(v.x(), -49731.0138889, v.y(), -49242.1527778));
    assert_eq!(v.get_incident_edge()?.0, 319);
    let v = output.vertices()[93].get();
    assert!(almost_equal(v.x(), -49786.4318492, v.y(), -49208.7187686));
    assert_eq!(v.get_incident_edge()?.0, 321);
    let v = output.vertices()[94].get();
    assert!(almost_equal(v.x(), -49786.3617853, v.y(), -49208.6694219));
    assert_eq!(v.get_incident_edge()?.0, 323);
    let v = output.vertices()[95].get();
    assert!(almost_equal(v.x(), -49778.0785928, v.y(), -49192.5833719));
    assert_eq!(v.get_incident_edge()?.0, 325);
    let v = output.vertices()[96].get();
    assert!(almost_equal(v.x(), -49718.9113723, v.y(), -49217.1720140));
    assert_eq!(v.get_incident_edge()?.0, 331);
    let v = output.vertices()[97].get();
    assert!(almost_equal(v.x(), -49745.4992627, v.y(), -49177.1624885));
    assert_eq!(v.get_incident_edge()?.0, 333);
    let v = output.vertices()[98].get();
    assert!(almost_equal(v.x(), -49720.8161101, v.y(), -49160.6293457));
    assert_eq!(v.get_incident_edge()?.0, 337);
    let v = output.vertices()[99].get();
    assert!(almost_equal(v.x(), -50197.9639020, v.y(), -48705.8358153));
    assert_eq!(v.get_incident_edge()?.0, 339);
    let v = output.vertices()[100].get();
    assert!(almost_equal(v.x(), -49745.5009463, v.y(), -49790.2127176));
    assert_eq!(v.get_incident_edge()?.0, 343);
    let v = output.vertices()[101].get();
    assert!(almost_equal(v.x(), -49711.4945442, v.y(), -49208.7438003));
    assert_eq!(v.get_incident_edge()?.0, 345);
    let v = output.vertices()[102].get();
    assert!(almost_equal(v.x(), -49747.4159178, v.y(), -49809.2660462));
    assert_eq!(v.get_incident_edge()?.0, 355);
    let v = output.vertices()[103].get();
    assert!(almost_equal(v.x(), -49707.0326633, v.y(), -49157.8517588));
    assert_eq!(v.get_incident_edge()?.0, 357);
    let v = output.vertices()[104].get();
    assert!(almost_equal(v.x(), -49759.3235778, v.y(), -49381.9179546));
    assert_eq!(v.get_incident_edge()?.0, 359);
    let v = output.vertices()[105].get();
    assert!(almost_equal(v.x(), -49759.1487272, v.y(), -49381.9253167));
    assert_eq!(v.get_incident_edge()?.0, 361);
    let v = output.vertices()[106].get();
    assert!(almost_equal(v.x(), -49744.1070269, v.y(), -49796.4816947));
    assert_eq!(v.get_incident_edge()?.0, 363);
    let v = output.vertices()[107].get();
    assert!(almost_equal(v.x(), -49743.4246600, v.y(), -49793.6534206));
    assert_eq!(v.get_incident_edge()?.0, 365);
    let v = output.vertices()[108].get();
    assert!(almost_equal(v.x(), -49750.4441592, v.y(), -49828.6251605));
    assert_eq!(v.get_incident_edge()?.0, 367);
    let v = output.vertices()[109].get();
    assert!(almost_equal(v.x(), -49711.7150497, v.y(), -49239.1309480));
    assert_eq!(v.get_incident_edge()?.0, 369);
    let v = output.vertices()[110].get();
    assert!(almost_equal(v.x(), -49750.4655729, v.y(), -49395.8483055));
    assert_eq!(v.get_incident_edge()?.0, 371);
    let v = output.vertices()[111].get();
    assert!(almost_equal(v.x(), -49733.2337893, v.y(), -49107.6581394));
    assert_eq!(v.get_incident_edge()?.0, 373);
    let v = output.vertices()[112].get();
    assert!(almost_equal(v.x(), -49710.5303139, v.y(), -49243.7284374));
    assert_eq!(v.get_incident_edge()?.0, 375);
    let v = output.vertices()[113].get();
    assert!(almost_equal(v.x(), -49749.4028375, v.y(), -49537.7553740));
    assert_eq!(v.get_incident_edge()?.0, 377);
    let v = output.vertices()[114].get();
    assert!(almost_equal(v.x(), -49717.6777533, v.y(), -49725.7800603));
    assert_eq!(v.get_incident_edge()?.0, 379);
    let v = output.vertices()[115].get();
    assert!(almost_equal(v.x(), -49742.5455594, v.y(), -49411.0910252));
    assert_eq!(v.get_incident_edge()?.0, 381);
    let v = output.vertices()[116].get();
    assert!(almost_equal(v.x(), -49801.5574425, v.y(), -48961.8687588));
    assert_eq!(v.get_incident_edge()?.0, 383);
    let v = output.vertices()[117].get();
    assert!(almost_equal(v.x(), -49708.5948117, v.y(), -49732.7549801));
    assert_eq!(v.get_incident_edge()?.0, 385);
    let v = output.vertices()[118].get();
    assert!(almost_equal(v.x(), -49698.1148992, v.y(), -49729.6144894));
    assert_eq!(v.get_incident_edge()?.0, 389);
    let v = output.vertices()[119].get();
    assert!(almost_equal(v.x(), -49726.8982698, v.y(), -49425.3586633));
    assert_eq!(v.get_incident_edge()?.0, 393);
    let v = output.vertices()[120].get();
    assert!(almost_equal(v.x(), -49684.5846343, v.y(), -49727.6368118));
    assert_eq!(v.get_incident_edge()?.0, 401);
    let v = output.vertices()[121].get();
    assert!(almost_equal(v.x(), -49733.5566272, v.y(), -49320.3659410));
    assert_eq!(v.get_incident_edge()?.0, 403);
    let v = output.vertices()[122].get();
    assert!(almost_equal(v.x(), -49753.0013850, v.y(), -49868.6883657));
    assert_eq!(v.get_incident_edge()?.0, 405);
    let v = output.vertices()[123].get();
    assert!(almost_equal(v.x(), -49717.3681655, v.y(), -49435.9963549));
    assert_eq!(v.get_incident_edge()?.0, 407);
    let v = output.vertices()[124].get();
    assert!(almost_equal(v.x(), -49726.3299441, v.y(), -49316.6136248));
    assert_eq!(v.get_incident_edge()?.0, 409);
    let v = output.vertices()[125].get();
    assert!(almost_equal(v.x(), -49766.1746697, v.y(), -49902.7670802));
    assert_eq!(v.get_incident_edge()?.0, 411);
    let v = output.vertices()[126].get();
    assert!(almost_equal(v.x(), -49766.3940590, v.y(), -49903.3331309));
    assert_eq!(v.get_incident_edge()?.0, 413);
    let v = output.vertices()[127].get();
    assert!(almost_equal(v.x(), -49720.4795792, v.y(), -49603.8452970));
    assert_eq!(v.get_incident_edge()?.0, 415);
    let v = output.vertices()[128].get();
    assert!(almost_equal(v.x(), -49703.3289973, v.y(), -49289.3799458));
    assert_eq!(v.get_incident_edge()?.0, 417);
    let v = output.vertices()[129].get();
    assert!(almost_equal(v.x(), -49704.1901811, v.y(), -49101.2375840));
    assert_eq!(v.get_incident_edge()?.0, 421);
    let v = output.vertices()[130].get();
    assert!(almost_equal(v.x(), -49726.0121967, v.y(), -49574.4960666));
    assert_eq!(v.get_incident_edge()?.0, 423);
    let v = output.vertices()[131].get();
    assert!(almost_equal(v.x(), -49696.7016183, v.y(), -49099.3091706));
    assert_eq!(v.get_incident_edge()?.0, 425);
    let v = output.vertices()[132].get();
    assert!(almost_equal(v.x(), -49705.1227287, v.y(), -49308.0621285));
    assert_eq!(v.get_incident_edge()?.0, 427);
    let v = output.vertices()[133].get();
    assert!(almost_equal(v.x(), -49671.8443223, v.y(), -49817.9652015));
    assert_eq!(v.get_incident_edge()?.0, 433);
    let v = output.vertices()[134].get();
    assert!(almost_equal(v.x(), -49775.3061434, v.y(), -49947.6054038));
    assert_eq!(v.get_incident_edge()?.0, 435);
    let v = output.vertices()[135].get();
    assert!(almost_equal(v.x(), -49776.5818302, v.y(), -49952.3166262));
    assert_eq!(v.get_incident_edge()?.0, 437);
    let v = output.vertices()[136].get();
    assert!(almost_equal(v.x(), -49660.2800213, v.y(), -49698.7530688));
    assert_eq!(v.get_incident_edge()?.0, 445);
    let v = output.vertices()[137].get();
    assert!(almost_equal(v.x(), -49780.8083243, v.y(), -49969.0160257));
    assert_eq!(v.get_incident_edge()?.0, 447);
    let v = output.vertices()[138].get();
    assert!(almost_equal(v.x(), -49706.7669519, v.y(), -49593.6623642));
    assert_eq!(v.get_incident_edge()?.0, 449);
    let v = output.vertices()[139].get();
    assert!(almost_equal(v.x(), -49685.0695395, v.y(), -49640.0000000));
    assert_eq!(v.get_incident_edge()?.0, 455);
    let v = output.vertices()[140].get();
    assert!(almost_equal(v.x(), -49706.5675752, v.y(), -49593.8138057));
    assert_eq!(v.get_incident_edge()?.0, 457);
    let v = output.vertices()[141].get();
    assert!(almost_equal(v.x(), -49693.5720730, v.y(), -49586.9561665));
    assert_eq!(v.get_incident_edge()?.0, 459);
    let v = output.vertices()[142].get();
    assert!(almost_equal(v.x(), -49669.0862069, v.y(), -49572.0000000));
    assert_eq!(v.get_incident_edge()?.0, 463);
    let v = output.vertices()[143].get();
    assert!(almost_equal(v.x(), -49685.7738444, v.y(), -49096.1021065));
    assert_eq!(v.get_incident_edge()?.0, 465);
    let v = output.vertices()[144].get();
    assert!(almost_equal(v.x(), -49634.4036939, v.y(), -49926.7691293));
    assert_eq!(v.get_incident_edge()?.0, 471);
    let v = output.vertices()[145].get();
    assert!(almost_equal(v.x(), -49652.0657895, v.y(), -49712.0657895));
    assert_eq!(v.get_incident_edge()?.0, 473);
    let v = output.vertices()[146].get();
    assert!(almost_equal(v.x(), -49666.8922414, v.y(), -49172.4482759));
    assert_eq!(v.get_incident_edge()?.0, 475);
    let v = output.vertices()[147].get();
    assert!(almost_equal(v.x(), -49671.7653273, v.y(), -49661.9360262));
    assert_eq!(v.get_incident_edge()?.0, 477);
    let v = output.vertices()[148].get();
    assert!(almost_equal(v.x(), -49626.3323014, v.y(), -49911.1709464));
    assert_eq!(v.get_incident_edge()?.0, 481);
    let v = output.vertices()[149].get();
    assert!(almost_equal(v.x(), -49792.4454652, v.y(), -50011.3274129));
    assert_eq!(v.get_incident_edge()?.0, 483);
    let v = output.vertices()[150].get();
    assert!(almost_equal(v.x(), -49644.3302376, v.y(), -49730.5121259));
    assert_eq!(v.get_incident_edge()?.0, 485);
    let v = output.vertices()[151].get();
    assert!(almost_equal(v.x(), -49659.3537560, v.y(), -49114.1790091));
    assert_eq!(v.get_incident_edge()?.0, 491);
    let v = output.vertices()[152].get();
    assert!(almost_equal(v.x(), -49653.4883333, v.y(), -49344.1271111));
    assert_eq!(v.get_incident_edge()?.0, 493);
    let v = output.vertices()[153].get();
    assert!(almost_equal(v.x(), -49653.3479422, v.y(), -49344.3044798));
    assert_eq!(v.get_incident_edge()?.0, 495);
    let v = output.vertices()[154].get();
    assert!(almost_equal(v.x(), -49798.6969165, v.y(), -50036.2979443));
    assert_eq!(v.get_incident_edge()?.0, 501);
    let v = output.vertices()[155].get();
    assert!(almost_equal(v.x(), -49655.6826612, v.y(), -49190.4532805));
    assert_eq!(v.get_incident_edge()?.0, 503);
    let v = output.vertices()[156].get();
    assert!(almost_equal(v.x(), -49654.0681623, v.y(), -49176.9827180));
    assert_eq!(v.get_incident_edge()?.0, 505);
    let v = output.vertices()[157].get();
    assert!(almost_equal(v.x(), -49638.2202995, v.y(), -49747.4209920));
    assert_eq!(v.get_incident_edge()?.0, 507);
    let v = output.vertices()[158].get();
    assert!(almost_equal(v.x(), -49637.4091360, v.y(), -49393.3515392));
    assert_eq!(v.get_incident_edge()?.0, 509);
    let v = output.vertices()[159].get();
    assert!(almost_equal(v.x(), -49648.3391794, v.y(), -49465.8872814));
    assert_eq!(v.get_incident_edge()?.0, 511);
    let v = output.vertices()[160].get();
    assert!(almost_equal(v.x(), -49631.3726551, v.y(), -49222.5455155));
    assert_eq!(v.get_incident_edge()?.0, 513);
    let v = output.vertices()[161].get();
    assert!(almost_equal(v.x(), -49638.0103849, v.y(), -49473.8650581));
    assert_eq!(v.get_incident_edge()?.0, 515);
    let v = output.vertices()[162].get();
    assert!(almost_equal(v.x(), -49608.0614035, v.y(), -49668.0614035));
    assert_eq!(v.get_incident_edge()?.0, 517);
    let v = output.vertices()[163].get();
    assert!(almost_equal(v.x(), -49810.0496624, v.y(), -50085.0387886));
    assert_eq!(v.get_incident_edge()?.0, 519);
    let v = output.vertices()[164].get();
    assert!(almost_equal(v.x(), -49639.9478605, v.y(), -49130.3429332));
    assert_eq!(v.get_incident_edge()?.0, 521);
    let v = output.vertices()[165].get();
    assert!(almost_equal(v.x(), -49625.6719179, v.y(), -49818.0521858));
    assert_eq!(v.get_incident_edge()?.0, 523);
    let v = output.vertices()[166].get();
    assert!(almost_equal(v.x(), -49630.4654540, v.y(), -49366.3990687));
    assert_eq!(v.get_incident_edge()?.0, 525);
    let v = output.vertices()[167].get();
    assert!(almost_equal(v.x(), -49623.2050614, v.y(), -49484.0312838));
    assert_eq!(v.get_incident_edge()?.0, 527);
    let v = output.vertices()[168].get();
    assert!(almost_equal(v.x(), -49626.5568695, v.y(), -49800.5860283));
    assert_eq!(v.get_incident_edge()?.0, 533);
    let v = output.vertices()[169].get();
    assert!(almost_equal(v.x(), -49625.3985922, v.y(), -49798.0121829));
    assert_eq!(v.get_incident_edge()?.0, 535);
    let v = output.vertices()[170].get();
    assert!(almost_equal(v.x(), -49623.2186162, v.y(), -49797.7618817));
    assert_eq!(v.get_incident_edge()?.0, 537);
    let v = output.vertices()[171].get();
    assert!(almost_equal(v.x(), -49583.6529412, v.y(), -49640.0000000));
    assert_eq!(v.get_incident_edge()?.0, 547);
    let v = output.vertices()[172].get();
    assert!(almost_equal(v.x(), -49587.6093058, v.y(), -49668.0242498));
    assert_eq!(v.get_incident_edge()?.0, 553);
    let v = output.vertices()[173].get();
    assert!(almost_equal(v.x(), -49572.3533333, v.y(), -49800.3533333));
    assert_eq!(v.get_incident_edge()?.0, 555);
    let v = output.vertices()[174].get();
    assert!(almost_equal(v.x(), -49585.2684594, v.y(), -49266.9414312));
    assert_eq!(v.get_incident_edge()?.0, 557);
    let v = output.vertices()[175].get();
    assert!(almost_equal(v.x(), -49820.4071709, v.y(), -50138.0763752));
    assert_eq!(v.get_incident_edge()?.0, 559);
    let v = output.vertices()[176].get();
    assert!(almost_equal(v.x(), -49552.0146413, v.y(), -49842.0827233));
    assert_eq!(v.get_incident_edge()?.0, 565);
    let v = output.vertices()[177].get();
    assert!(almost_equal(v.x(), -49586.2000457, v.y(), -49263.0919951));
    assert_eq!(v.get_incident_edge()?.0, 567);
    let v = output.vertices()[178].get();
    assert!(almost_equal(v.x(), -49554.3247654, v.y(), -49852.8172722));
    assert_eq!(v.get_incident_edge()?.0, 569);
    let v = output.vertices()[179].get();
    assert!(almost_equal(v.x(), -49576.3820481, v.y(), -49682.5618206));
    assert_eq!(v.get_incident_edge()?.0, 571);
    let v = output.vertices()[180].get();
    assert!(almost_equal(v.x(), -49591.6283125, v.y(), -49515.8430266));
    assert_eq!(v.get_incident_edge()?.0, 579);
    let v = output.vertices()[181].get();
    assert!(almost_equal(v.x(), -49549.7554767, v.y(), -49432.5387320));
    assert_eq!(v.get_incident_edge()?.0, 581);
    let v = output.vertices()[182].get();
    assert!(almost_equal(v.x(), -49576.5924761, v.y(), -49134.6919449));
    assert_eq!(v.get_incident_edge()?.0, 583);
    let v = output.vertices()[183].get();
    assert!(almost_equal(v.x(), -49538.8381494, v.y(), -49264.0232093));
    assert_eq!(v.get_incident_edge()?.0, 585);
    let v = output.vertices()[184].get();
    assert!(almost_equal(v.x(), -49584.7321352, v.y(), -49520.7115961));
    assert_eq!(v.get_incident_edge()?.0, 591);
    let v = output.vertices()[185].get();
    assert!(almost_equal(v.x(), -49536.1248492, v.y(), -49265.1743064));
    assert_eq!(v.get_incident_edge()?.0, 593);
    let v = output.vertices()[186].get();
    assert!(almost_equal(v.x(), -49543.2223095, v.y(), -49104.4571877));
    assert_eq!(v.get_incident_edge()?.0, 599);
    let v = output.vertices()[187].get();
    assert!(almost_equal(v.x(), -49535.0981406, v.y(), -49448.7423039));
    assert_eq!(v.get_incident_edge()?.0, 601);
    let v = output.vertices()[188].get();
    assert!(almost_equal(v.x(), -49522.1967407, v.y(), -49241.8378167));
    assert_eq!(v.get_incident_edge()?.0, 603);
    let v = output.vertices()[189].get();
    assert!(almost_equal(v.x(), -49520.1169911, v.y(), -49243.5739442));
    assert_eq!(v.get_incident_edge()?.0, 605);
    let v = output.vertices()[190].get();
    assert!(almost_equal(v.x(), -49573.0149526, v.y(), -49964.9804887));
    assert_eq!(v.get_incident_edge()?.0, 611);
    let v = output.vertices()[191].get();
    assert!(almost_equal(v.x(), -49571.0226225, v.y(), -49959.6424013));
    assert_eq!(v.get_incident_edge()?.0, 613);
    let v = output.vertices()[192].get();
    assert!(almost_equal(v.x(), -49569.7058824, v.y(), -49374.8235294));
    assert_eq!(v.get_incident_edge()?.0, 615);
    let v = output.vertices()[193].get();
    assert!(almost_equal(v.x(), -49539.4138597, v.y(), -49810.0080066));
    assert_eq!(v.get_incident_edge()?.0, 617);
    let v = output.vertices()[194].get();
    assert!(almost_equal(v.x(), -49559.5158401, v.y(), -49930.8251162));
    assert_eq!(v.get_incident_edge()?.0, 625);
    let v = output.vertices()[195].get();
    assert!(almost_equal(v.x(), -49546.0827760, v.y(), -49929.3358991));
    assert_eq!(v.get_incident_edge()?.0, 627);
    let v = output.vertices()[196].get();
    assert!(almost_equal(v.x(), -49559.0607060, v.y(), -49141.0515086));
    assert_eq!(v.get_incident_edge()?.0, 629);
    let v = output.vertices()[197].get();
    assert!(almost_equal(v.x(), -49519.8193950, v.y(), -49837.2477758));
    assert_eq!(v.get_incident_edge()?.0, 631);
    let v = output.vertices()[198].get();
    assert!(almost_equal(v.x(), -49558.0081799, v.y(), -49142.4089350));
    assert_eq!(v.get_incident_edge()?.0, 633);
    let v = output.vertices()[199].get();
    assert!(almost_equal(v.x(), -49535.0563636, v.y(), -49809.3133333));
    assert_eq!(v.get_incident_edge()?.0, 637);
    let v = output.vertices()[200].get();
    assert!(almost_equal(v.x(), -49507.6421769, v.y(), -49930.4482993));
    assert_eq!(v.get_incident_edge()?.0, 639);
    let v = output.vertices()[201].get();
    assert!(almost_equal(v.x(), -49570.8016760, v.y(), -49360.5782123));
    assert_eq!(v.get_incident_edge()?.0, 641);
    let v = output.vertices()[202].get();
    assert!(almost_equal(v.x(), -49536.1899704, v.y(), -49327.2189970));
    assert_eq!(v.get_incident_edge()?.0, 647);
    let v = output.vertices()[203].get();
    assert!(almost_equal(v.x(), -49527.0168712, v.y(), -49802.3773006));
    assert_eq!(v.get_incident_edge()?.0, 649);
    let v = output.vertices()[204].get();
    assert!(almost_equal(v.x(), -49552.8404258, v.y(), -49342.0659586));
    assert_eq!(v.get_incident_edge()?.0, 651);
    let v = output.vertices()[205].get();
    assert!(almost_equal(v.x(), -49563.4473944, v.y(), -49350.9525316));
    assert_eq!(v.get_incident_edge()?.0, 653);
    let v = output.vertices()[206].get();
    assert!(almost_equal(v.x(), -49565.3195482, v.y(), -49356.3611909));
    assert_eq!(v.get_incident_edge()?.0, 655);
    let v = output.vertices()[207].get();
    assert!(almost_equal(v.x(), -49511.6648418, v.y(), -49266.6645165));
    assert_eq!(v.get_incident_edge()?.0, 657);
    let v = output.vertices()[208].get();
    assert!(almost_equal(v.x(), -49507.6134678, v.y(), -49409.3176251));
    assert_eq!(v.get_incident_edge()?.0, 659);
    let v = output.vertices()[209].get();
    assert!(almost_equal(v.x(), -49505.8199292, v.y(), -49415.0819929));
    assert_eq!(v.get_incident_edge()?.0, 663);
    let v = output.vertices()[210].get();
    assert!(almost_equal(v.x(), -49534.7593855, v.y(), -49519.3632429));
    assert_eq!(v.get_incident_edge()?.0, 671);
    let v = output.vertices()[211].get();
    assert!(almost_equal(v.x(), -49479.8335603, v.y(), -49508.3576129));
    assert_eq!(v.get_incident_edge()?.0, 673);
    let v = output.vertices()[212].get();
    assert!(almost_equal(v.x(), -49526.1115280, v.y(), -49184.1716430));
    assert_eq!(v.get_incident_edge()?.0, 675);
    let v = output.vertices()[213].get();
    assert!(almost_equal(v.x(), -49523.3473452, v.y(), -49187.6258940));
    assert_eq!(v.get_incident_edge()?.0, 677);
    let v = output.vertices()[214].get();
    assert!(almost_equal(v.x(), -49517.2618612, v.y(), -49745.2618612));
    assert_eq!(v.get_incident_edge()?.0, 679);
    let v = output.vertices()[215].get();
    assert!(almost_equal(v.x(), -49474.1674608, v.y(), -49518.6432948));
    assert_eq!(v.get_incident_edge()?.0, 683);
    let v = output.vertices()[216].get();
    assert!(almost_equal(v.x(), -49551.8207167, v.y(), -49545.5504025));
    assert_eq!(v.get_incident_edge()?.0, 685);
    let v = output.vertices()[217].get();
    assert!(almost_equal(v.x(), -49550.9657122, v.y(), -49547.5318415));
    assert_eq!(v.get_incident_edge()?.0, 687);
    let v = output.vertices()[218].get();
    assert!(almost_equal(v.x(), -49546.8529412, v.y(), -49572.0000000));
    assert_eq!(v.get_incident_edge()?.0, 691);
    let v = output.vertices()[219].get();
    assert!(almost_equal(v.x(), -49543.5642228, v.y(), -49568.5057368));
    assert_eq!(v.get_incident_edge()?.0, 697);
    let v = output.vertices()[220].get();
    assert!(almost_equal(v.x(), -49506.4061076, v.y(), -49620.3609845));
    assert_eq!(v.get_incident_edge()?.0, 699);
    let v = output.vertices()[221].get();
    assert!(almost_equal(v.x(), -49503.7539425, v.y(), -49764.0228536));
    assert_eq!(v.get_incident_edge()?.0, 703);
    let v = output.vertices()[222].get();
    assert!(almost_equal(v.x(), -49468.5125671, v.y(), -49286.5578085));
    assert_eq!(v.get_incident_edge()?.0, 705);
    let v = output.vertices()[223].get();
    assert!(almost_equal(v.x(), -49475.1811594, v.y(), -49317.2333333));
    assert_eq!(v.get_incident_edge()?.0, 707);
    let v = output.vertices()[224].get();
    assert!(almost_equal(v.x(), -49531.5574476, v.y(), -49576.0727553));
    assert_eq!(v.get_incident_edge()?.0, 709);
    let v = output.vertices()[225].get();
    assert!(almost_equal(v.x(), -49492.0677863, v.y(), -49202.1944557));
    assert_eq!(v.get_incident_edge()?.0, 713);
    let v = output.vertices()[226].get();
    assert!(almost_equal(v.x(), -49475.4503995, v.y(), -49765.3321307));
    assert_eq!(v.get_incident_edge()?.0, 715);
    let v = output.vertices()[227].get();
    assert!(almost_equal(v.x(), -49471.3725490, v.y(), -49320.7372549));
    assert_eq!(v.get_incident_edge()?.0, 717);
    let v = output.vertices()[228].get();
    assert!(almost_equal(v.x(), -49470.5750000, v.y(), -49765.7333333));
    assert_eq!(v.get_incident_edge()?.0, 719);
    let v = output.vertices()[229].get();
    assert!(almost_equal(v.x(), -49466.2838683, v.y(), -49583.5435596));
    assert_eq!(v.get_incident_edge()?.0, 721);
    let v = output.vertices()[230].get();
    assert!(almost_equal(v.x(), -49458.9684642, v.y(), -49586.7942267));
    assert_eq!(v.get_incident_edge()?.0, 727);
    let v = output.vertices()[231].get();
    assert!(almost_equal(v.x(), -49460.3412052, v.y(), -49150.3469055));
    assert_eq!(v.get_incident_edge()?.0, 733);
    let v = output.vertices()[232].get();
    assert!(almost_equal(v.x(), -49453.8851641, v.y(), -49307.6383738));
    assert_eq!(v.get_incident_edge()?.0, 735);
    let v = output.vertices()[233].get();
    assert!(almost_equal(v.x(), -49455.7031250, v.y(), -49175.0833333));
    assert_eq!(v.get_incident_edge()?.0, 739);
    let v = output.vertices()[234].get();
    assert!(almost_equal(v.x(), -49464.5254237, v.y(), -49946.1271186));
    assert_eq!(v.get_incident_edge()?.0, 741);
    let v = output.vertices()[235].get();
    assert!(almost_equal(v.x(), -49440.5458716, v.y(), -49769.3732277));
    assert_eq!(v.get_incident_edge()?.0, 747);
    let v = output.vertices()[236].get();
    assert!(almost_equal(v.x(), -49430.2475248, v.y(), -49584.1980198));
    assert_eq!(v.get_incident_edge()?.0, 753);
    let v = output.vertices()[237].get();
    assert!(almost_equal(v.x(), -49466.2474366, v.y(), -49867.3864632));
    assert_eq!(v.get_incident_edge()?.0, 755);
    let v = output.vertices()[238].get();
    assert!(almost_equal(v.x(), -49433.2131380, v.y(), -49782.3721645));
    assert_eq!(v.get_incident_edge()?.0, 757);
    let v = output.vertices()[239].get();
    assert!(almost_equal(v.x(), -49459.0206504, v.y(), -49892.9326338));
    assert_eq!(v.get_incident_edge()?.0, 763);
    let v = output.vertices()[240].get();
    assert!(almost_equal(v.x(), -49455.1907330, v.y(), -49906.7811844));
    assert_eq!(v.get_incident_edge()?.0, 765);
    let v = output.vertices()[241].get();
    assert!(almost_equal(v.x(), -49436.4242005, v.y(), -49807.0810879));
    assert_eq!(v.get_incident_edge()?.0, 767);
    let v = output.vertices()[242].get();
    assert!(almost_equal(v.x(), -49462.8908918, v.y(), -49868.0585306));
    assert_eq!(v.get_incident_edge()?.0, 769);
    let v = output.vertices()[243].get();
    assert!(almost_equal(v.x(), -49462.6628190, v.y(), -49867.7084613));
    assert_eq!(v.get_incident_edge()?.0, 771);
    let v = output.vertices()[244].get();
    assert!(almost_equal(v.x(), -49448.0048083, v.y(), -49336.0600931));
    assert_eq!(v.get_incident_edge()?.0, 773);
    let v = output.vertices()[245].get();
    assert!(almost_equal(v.x(), -49443.2622413, v.y(), -49864.5338213));
    assert_eq!(v.get_incident_edge()?.0, 777);
    let v = output.vertices()[246].get();
    assert!(almost_equal(v.x(), -49453.2064568, v.y(), -49950.1222552));
    assert_eq!(v.get_incident_edge()?.0, 779);
    let v = output.vertices()[247].get();
    assert!(almost_equal(v.x(), -49455.3873314, v.y(), -49211.0863835));
    assert_eq!(v.get_incident_edge()?.0, 781);
    let v = output.vertices()[248].get();
    assert!(almost_equal(v.x(), -49454.4924126, v.y(), -49979.5688852));
    assert_eq!(v.get_incident_edge()?.0, 785);
    let v = output.vertices()[249].get();
    assert!(almost_equal(v.x(), -49454.5983372, v.y(), -49983.6121070));
    assert_eq!(v.get_incident_edge()?.0, 787);
    let v = output.vertices()[250].get();
    assert!(almost_equal(v.x(), -49426.7254070, v.y(), -49798.7967018));
    assert_eq!(v.get_incident_edge()?.0, 789);
    let v = output.vertices()[251].get();
    assert!(almost_equal(v.x(), -49427.3171806, v.y(), -49727.2819383));
    assert_eq!(v.get_incident_edge()?.0, 791);
    let v = output.vertices()[252].get();
    assert!(almost_equal(v.x(), -49443.5177188, v.y(), -49221.1147155));
    assert_eq!(v.get_incident_edge()?.0, 797);
    let v = output.vertices()[253].get();
    assert!(almost_equal(v.x(), -49435.6827676, v.y(), -49217.8616188));
    assert_eq!(v.get_incident_edge()?.0, 799);
    let v = output.vertices()[254].get();
    assert!(almost_equal(v.x(), -49446.8587282, v.y(), -49666.1004053));
    assert_eq!(v.get_incident_edge()?.0, 801);
    let v = output.vertices()[255].get();
    assert!(almost_equal(v.x(), -49432.3099700, v.y(), -49239.1987377));
    assert_eq!(v.get_incident_edge()?.0, 803);
    let v = output.vertices()[256].get();
    assert!(almost_equal(v.x(), -49439.1764408, v.y(), -49449.2209626));
    assert_eq!(v.get_incident_edge()?.0, 809);
    let v = output.vertices()[257].get();
    assert!(almost_equal(v.x(), -49440.3717450, v.y(), -49453.0136916));
    assert_eq!(v.get_incident_edge()?.0, 811);
    let v = output.vertices()[258].get();
    assert!(almost_equal(v.x(), -49432.9718693, v.y(), -49428.4056261));
    assert_eq!(v.get_incident_edge()?.0, 817);
    let v = output.vertices()[259].get();
    assert!(almost_equal(v.x(), -49428.0774597, v.y(), -49493.2467635));
    assert_eq!(v.get_incident_edge()?.0, 819);
    let v = output.vertices()[260].get();
    assert!(almost_equal(v.x(), -49381.5126050, v.y(), -49438.6974790));
    assert_eq!(v.get_incident_edge()?.0, 821);
    let v = output.vertices()[261].get();
    assert!(almost_equal(v.x(), -49417.0045961, v.y(), -49259.1113107));
    assert_eq!(v.get_incident_edge()?.0, 825);
    let v = output.vertices()[262].get();
    assert!(almost_equal(v.x(), -49424.5239685, v.y(), -49509.5427121));
    assert_eq!(v.get_incident_edge()?.0, 827);
    let v = output.vertices()[263].get();
    assert!(almost_equal(v.x(), -49419.4723514, v.y(), -49526.0808520));
    assert_eq!(v.get_incident_edge()?.0, 831);
    let v = output.vertices()[264].get();
    assert!(almost_equal(v.x(), -49380.5585668, v.y(), -49219.0744612));
    assert_eq!(v.get_incident_edge()?.0, 837);
    let v = output.vertices()[265].get();
    assert!(almost_equal(v.x(), -49380.7029363, v.y(), -49218.0029917));
    assert_eq!(v.get_incident_edge()?.0, 839);
    let v = output.vertices()[266].get();
    assert!(almost_equal(v.x(), -49428.8065448, v.y(), -49407.3806545));
    assert_eq!(v.get_incident_edge()?.0, 841);
    let v = output.vertices()[267].get();
    assert!(almost_equal(v.x(), -49399.3079504, v.y(), -49810.0829833));
    assert_eq!(v.get_incident_edge()?.0, 843);
    let v = output.vertices()[268].get();
    assert!(almost_equal(v.x(), -49391.6134603, v.y(), -49200.4658396));
    assert_eq!(v.get_incident_edge()?.0, 845);
    let v = output.vertices()[269].get();
    assert!(almost_equal(v.x(), -49374.7219479, v.y(), -49443.4365851));
    assert_eq!(v.get_incident_edge()?.0, 851);
    let v = output.vertices()[270].get();
    assert!(almost_equal(v.x(), -49387.8510638, v.y(), -49168.4468085));
    assert_eq!(v.get_incident_edge()?.0, 859);
    let v = output.vertices()[271].get();
    assert!(almost_equal(v.x(), -49388.2459016, v.y(), -49167.2622951));
    assert_eq!(v.get_incident_edge()?.0, 861);
    let v = output.vertices()[272].get();
    assert!(almost_equal(v.x(), -49409.8771012, v.y(), -49547.2274818));
    assert_eq!(v.get_incident_edge()?.0, 863);
    let v = output.vertices()[273].get();
    assert!(almost_equal(v.x(), -49393.8665994, v.y(), -49153.0612441));
    assert_eq!(v.get_incident_edge()?.0, 865);
    let v = output.vertices()[274].get();
    assert!(almost_equal(v.x(), -49406.6715359, v.y(), -49122.7829716));
    assert_eq!(v.get_incident_edge()?.0, 867);
    let v = output.vertices()[275].get();
    assert!(almost_equal(v.x(), -49386.4717867, v.y(), -49884.4967194));
    assert_eq!(v.get_incident_edge()?.0, 871);
    let v = output.vertices()[276].get();
    assert!(almost_equal(v.x(), -49392.2920817, v.y(), -49815.3519838));
    assert_eq!(v.get_incident_edge()?.0, 877);
    let v = output.vertices()[277].get();
    assert!(almost_equal(v.x(), -49390.5437062, v.y(), -49157.4264495));
    assert_eq!(v.get_incident_edge()?.0, 879);
    let v = output.vertices()[278].get();
    assert!(almost_equal(v.x(), -49405.3784743, v.y(), -49557.2808989));
    assert_eq!(v.get_incident_edge()?.0, 881);
    let v = output.vertices()[279].get();
    assert!(almost_equal(v.x(), -49402.0006442, v.y(), -49292.1966932));
    assert_eq!(v.get_incident_edge()?.0, 883);
    let v = output.vertices()[280].get();
    assert!(almost_equal(v.x(), -49408.1009005, v.y(), -49115.5261973));
    assert_eq!(v.get_incident_edge()?.0, 885);
    let v = output.vertices()[281].get();
    assert!(almost_equal(v.x(), -49402.7777778, v.y(), -49562.2222222));
    assert_eq!(v.get_incident_edge()?.0, 887);
    let v = output.vertices()[282].get();
    assert!(almost_equal(v.x(), -49438.6849731, v.y(), -49072.9483708));
    assert_eq!(v.get_incident_edge()?.0, 889);
    let v = output.vertices()[283].get();
    assert!(almost_equal(v.x(), -49360.1123047, v.y(), -49171.8433913));
    assert_eq!(v.get_incident_edge()?.0, 891);
    let v = output.vertices()[284].get();
    assert!(almost_equal(v.x(), -49363.5076336, v.y(), -49526.9408397));
    assert_eq!(v.get_incident_edge()?.0, 893);
    let v = output.vertices()[285].get();
    assert!(almost_equal(v.x(), -49438.5066730, v.y(), -49050.6034318));
    assert_eq!(v.get_incident_edge()?.0, 895);
    let v = output.vertices()[286].get();
    assert!(almost_equal(v.x(), -49365.8812660, v.y(), -49121.0814124));
    assert_eq!(v.get_incident_edge()?.0, 897);
    let v = output.vertices()[287].get();
    assert!(almost_equal(v.x(), -49411.7391304, v.y(), -49662.8586957));
    assert_eq!(v.get_incident_edge()?.0, 903);
    let v = output.vertices()[288].get();
    assert!(almost_equal(v.x(), -49394.8076923, v.y(), -49637.4615385));
    assert_eq!(v.get_incident_edge()?.0, 905);
    let v = output.vertices()[289].get();
    assert!(almost_equal(v.x(), -49419.1378775, v.y(), -49674.8742626));
    assert_eq!(v.get_incident_edge()?.0, 911);
    let v = output.vertices()[290].get();
    assert!(almost_equal(v.x(), -49372.6347034, v.y(), -49825.0802896));
    assert_eq!(v.get_incident_edge()?.0, 913);
    let v = output.vertices()[291].get();
    assert!(almost_equal(v.x(), -49337.4665152, v.y(), -49198.5248296));
    assert_eq!(v.get_incident_edge()?.0, 919);
    let v = output.vertices()[292].get();
    assert!(almost_equal(v.x(), -49410.5214539, v.y(), -49688.4039442));
    assert_eq!(v.get_incident_edge()?.0, 921);
    let v = output.vertices()[293].get();
    assert!(almost_equal(v.x(), -49411.8636983, v.y(), -49363.6050211));
    assert_eq!(v.get_incident_edge()?.0, 925);
    let v = output.vertices()[294].get();
    assert!(almost_equal(v.x(), -49381.4000000, v.y(), -49583.6000000));
    assert_eq!(v.get_incident_edge()?.0, 929);
    let v = output.vertices()[295].get();
    assert!(almost_equal(v.x(), -49363.3589045, v.y(), -49834.4306854));
    assert_eq!(v.get_incident_edge()?.0, 933);
    let v = output.vertices()[296].get();
    assert!(almost_equal(v.x(), -49352.6988515, v.y(), -49520.0883585));
    assert_eq!(v.get_incident_edge()?.0, 935);
    let v = output.vertices()[297].get();
    assert!(almost_equal(v.x(), -49378.7321937, v.y(), -49591.0797721));
    assert_eq!(v.get_incident_edge()?.0, 937);
    let v = output.vertices()[298].get();
    assert!(almost_equal(v.x(), -49378.4101642, v.y(), -49586.7093715));
    assert_eq!(v.get_incident_edge()?.0, 939);
    let v = output.vertices()[299].get();
    assert!(almost_equal(v.x(), -49350.8073977, v.y(), -49222.7174615));
    assert_eq!(v.get_incident_edge()?.0, 941);
    let v = output.vertices()[300].get();
    assert!(almost_equal(v.x(), -49347.1149961, v.y(), -49128.5048464));
    assert_eq!(v.get_incident_edge()?.0, 943);
    let v = output.vertices()[301].get();
    assert!(almost_equal(v.x(), -49350.2239412, v.y(), -49237.4515998));
    assert_eq!(v.get_incident_edge()?.0, 949);
    let v = output.vertices()[302].get();
    assert!(almost_equal(v.x(), -49338.0569301, v.y(), -49087.9070570));
    assert_eq!(v.get_incident_edge()?.0, 951);
    let v = output.vertices()[303].get();
    assert!(almost_equal(v.x(), -49349.2968968, v.y(), -49481.8594158));
    assert_eq!(v.get_incident_edge()?.0, 953);
    let v = output.vertices()[304].get();
    assert!(almost_equal(v.x(), -49360.4321665, v.y(), -49931.7443257));
    assert_eq!(v.get_incident_edge()?.0, 955);
    let v = output.vertices()[305].get();
    assert!(almost_equal(v.x(), -49391.4022989, v.y(), -49346.6015326));
    assert_eq!(v.get_incident_edge()?.0, 963);
    let v = output.vertices()[306].get();
    assert!(almost_equal(v.x(), -49393.9899323, v.y(), -49352.2761673));
    assert_eq!(v.get_incident_edge()?.0, 965);
    let v = output.vertices()[307].get();
    assert!(almost_equal(v.x(), -49396.0218233, v.y(), -49356.5765836));
    assert_eq!(v.get_incident_edge()?.0, 967);
    let v = output.vertices()[308].get();
    assert!(almost_equal(v.x(), -49381.2203757, v.y(), -49707.8492052));
    assert_eq!(v.get_incident_edge()?.0, 969);
    let v = output.vertices()[309].get();
    assert!(almost_equal(v.x(), -49358.5054459, v.y(), -49395.6840946));
    assert_eq!(v.get_incident_edge()?.0, 971);
    let v = output.vertices()[310].get();
    assert!(almost_equal(v.x(), -49357.1789318, v.y(), -49397.7948482));
    assert_eq!(v.get_incident_edge()?.0, 975);
    let v = output.vertices()[311].get();
    assert!(almost_equal(v.x(), -49359.5834348, v.y(), -49057.2034103));
    assert_eq!(v.get_incident_edge()?.0, 977);
    let v = output.vertices()[312].get();
    assert!(almost_equal(v.x(), -49343.1022946, v.y(), -49252.7102962));
    assert_eq!(v.get_incident_edge()?.0, 979);
    let v = output.vertices()[313].get();
    assert!(almost_equal(v.x(), -49320.4874124, v.y(), -49201.0159296));
    assert_eq!(v.get_incident_edge()?.0, 985);
    let v = output.vertices()[314].get();
    assert!(almost_equal(v.x(), -49325.5364820, v.y(), -49185.1035422));
    assert_eq!(v.get_incident_edge()?.0, 989);
    let v = output.vertices()[315].get();
    assert!(almost_equal(v.x(), -49325.7571885, v.y(), -49184.4285199));
    assert_eq!(v.get_incident_edge()?.0, 991);
    let v = output.vertices()[316].get();
    assert!(almost_equal(v.x(), -49394.4985089, v.y(), -49019.2062624));
    assert_eq!(v.get_incident_edge()?.0, 993);
    let v = output.vertices()[317].get();
    assert!(almost_equal(v.x(), -49335.5379001, v.y(), -49264.8994947));
    assert_eq!(v.get_incident_edge()?.0, 995);
    let v = output.vertices()[318].get();
    assert!(almost_equal(v.x(), -49309.0619527, v.y(), -49234.8305206));
    assert_eq!(v.get_incident_edge()?.0, 997);
    let v = output.vertices()[319].get();
    assert!(almost_equal(v.x(), -49331.5603429, v.y(), -49138.9807743));
    assert_eq!(v.get_incident_edge()?.0, 999);
    let v = output.vertices()[320].get();
    assert!(almost_equal(v.x(), -49310.1497005, v.y(), -49095.0206646));
    assert_eq!(v.get_incident_edge()?.0, 1001);
    let v = output.vertices()[321].get();
    assert!(almost_equal(v.x(), -49434.1731634, v.y(), -48983.4340330));
    assert_eq!(v.get_incident_edge()?.0, 1007);
    let v = output.vertices()[322].get();
    assert!(almost_equal(v.x(), -49321.7257506, v.y(), -49580.3258891));
    assert_eq!(v.get_incident_edge()?.0, 1015);
    let v = output.vertices()[323].get();
    assert!(almost_equal(v.x(), -49308.6503221, v.y(), -49122.5752494));
    assert_eq!(v.get_incident_edge()?.0, 1019);
    let v = output.vertices()[324].get();
    assert!(almost_equal(v.x(), -49345.4791471, v.y(), -49966.8929241));
    assert_eq!(v.get_incident_edge()?.0, 1023);
    let v = output.vertices()[325].get();
    assert!(almost_equal(v.x(), -49304.4823145, v.y(), -49571.2634855));
    assert_eq!(v.get_incident_edge()?.0, 1027);
    let v = output.vertices()[326].get();
    assert!(almost_equal(v.x(), -49320.5901481, v.y(), -49428.1902769));
    assert_eq!(v.get_incident_edge()?.0, 1035);
    let v = output.vertices()[327].get();
    assert!(almost_equal(v.x(), -49292.9561968, v.y(), -49568.1946231));
    assert_eq!(v.get_incident_edge()?.0, 1037);
    let v = output.vertices()[328].get();
    assert!(almost_equal(v.x(), -49343.0413823, v.y(), -49954.9497882));
    assert_eq!(v.get_incident_edge()?.0, 1039);
    let v = output.vertices()[329].get();
    assert!(almost_equal(v.x(), -49303.9808612, v.y(), -49251.4784689));
    assert_eq!(v.get_incident_edge()?.0, 1045);
    let v = output.vertices()[330].get();
    assert!(almost_equal(v.x(), -49309.3832335, v.y(), -49598.5928144));
    assert_eq!(v.get_incident_edge()?.0, 1047);
    let v = output.vertices()[331].get();
    assert!(almost_equal(v.x(), -49293.8360791, v.y(), -49117.4802306));
    assert_eq!(v.get_incident_edge()?.0, 1049);
    let v = output.vertices()[332].get();
    assert!(almost_equal(v.x(), -49330.2243536, v.y(), -49502.0175513));
    assert_eq!(v.get_incident_edge()?.0, 1051);
    let v = output.vertices()[333].get();
    assert!(almost_equal(v.x(), -49315.5882353, v.y(), -49661.0588235));
    assert_eq!(v.get_incident_edge()?.0, 1053);
    let v = output.vertices()[334].get();
    assert!(almost_equal(v.x(), -49315.0467987, v.y(), -49874.0561584));
    assert_eq!(v.get_incident_edge()?.0, 1055);
    let v = output.vertices()[335].get();
    assert!(almost_equal(v.x(), -49308.2098765, v.y(), -49612.0864198));
    assert_eq!(v.get_incident_edge()?.0, 1057);
    let v = output.vertices()[336].get();
    assert!(almost_equal(v.x(), -49308.1950539, v.y(), -49612.2538301));
    assert_eq!(v.get_incident_edge()?.0, 1059);
    let v = output.vertices()[337].get();
    assert!(almost_equal(v.x(), -49315.3750000, v.y(), -49662.1250000));
    assert_eq!(v.get_incident_edge()?.0, 1061);
    let v = output.vertices()[338].get();
    assert!(almost_equal(v.x(), -49314.3312874, v.y(), -49874.6342814));
    assert_eq!(v.get_incident_edge()?.0, 1063);
    let v = output.vertices()[339].get();
    assert!(almost_equal(v.x(), -49310.4647520, v.y(), -49913.1801567));
    assert_eq!(v.get_incident_edge()?.0, 1069);
    let v = output.vertices()[340].get();
    assert!(almost_equal(v.x(), -49313.2208399, v.y(), -49875.5181070));
    assert_eq!(v.get_incident_edge()?.0, 1071);
    let v = output.vertices()[341].get();
    assert!(almost_equal(v.x(), -49288.3685622, v.y(), -49846.7800429));
    assert_eq!(v.get_incident_edge()?.0, 1079);
    let v = output.vertices()[342].get();
    assert!(almost_equal(v.x(), -49292.5588235, v.y(), -49591.3823529));
    assert_eq!(v.get_incident_edge()?.0, 1081);
    let v = output.vertices()[343].get();
    assert!(almost_equal(v.x(), -49307.5753819, v.y(), -49619.1296204));
    assert_eq!(v.get_incident_edge()?.0, 1083);
    let v = output.vertices()[344].get();
    assert!(almost_equal(v.x(), -49289.1761364, v.y(), -49843.0113636));
    assert_eq!(v.get_incident_edge()?.0, 1085);
    let v = output.vertices()[345].get();
    assert!(almost_equal(v.x(), -49288.6243950, v.y(), -49585.8741530));
    assert_eq!(v.get_incident_edge()?.0, 1087);
    let v = output.vertices()[346].get();
    assert!(almost_equal(v.x(), -49283.0277778, v.y(), -49595.7146465));
    assert_eq!(v.get_incident_edge()?.0, 1091);
    let v = output.vertices()[347].get();
    assert!(almost_equal(v.x(), -49279.7734712, v.y(), -49597.8428868));
    assert_eq!(v.get_incident_edge()?.0, 1097);
    let v = output.vertices()[348].get();
    assert!(almost_equal(v.x(), -49319.9231928, v.y(), -49945.3388554));
    assert_eq!(v.get_incident_edge()?.0, 1099);
    let v = output.vertices()[349].get();
    assert!(almost_equal(v.x(), -49282.3511194, v.y(), -49633.5043034));
    assert_eq!(v.get_incident_edge()?.0, 1101);
    let v = output.vertices()[350].get();
    assert!(almost_equal(v.x(), -49286.1558394, v.y(), -49546.6601580));
    assert_eq!(v.get_incident_edge()?.0, 1103);
    let v = output.vertices()[351].get();
    assert!(almost_equal(v.x(), -49492.0296736, v.y(), -48871.2462908));
    assert_eq!(v.get_incident_edge()?.0, 1105);
    let v = output.vertices()[352].get();
    assert!(almost_equal(v.x(), -49292.8954170, v.y(), -49366.8251926));
    assert_eq!(v.get_incident_edge()?.0, 1107);
    let v = output.vertices()[353].get();
    assert!(almost_equal(v.x(), -49290.9733566, v.y(), -49394.9775896));
    assert_eq!(v.get_incident_edge()?.0, 1109);
    let v = output.vertices()[354].get();
    assert!(almost_equal(v.x(), -49313.9504132, v.y(), -49687.1570248));
    assert_eq!(v.get_incident_edge()?.0, 1111);
    let v = output.vertices()[355].get();
    assert!(almost_equal(v.x(), -49307.8319444, v.y(), -49947.6263889));
    assert_eq!(v.get_incident_edge()?.0, 1113);
    let v = output.vertices()[356].get();
    assert!(almost_equal(v.x(), -49276.9005642, v.y(), -49578.4470444));
    assert_eq!(v.get_incident_edge()?.0, 1115);
    let v = output.vertices()[357].get();
    assert!(almost_equal(v.x(), -49288.0437616, v.y(), -49208.6001596));
    assert_eq!(v.get_incident_edge()?.0, 1117);
    let v = output.vertices()[358].get();
    assert!(almost_equal(v.x(), -49271.1965351, v.y(), -49650.1036638));
    assert_eq!(v.get_incident_edge()?.0, 1119);
    let v = output.vertices()[359].get();
    assert!(almost_equal(v.x(), -49290.2459463, v.y(), -49081.0660271));
    assert_eq!(v.get_incident_edge()?.0, 1121);
    let v = output.vertices()[360].get();
    assert!(almost_equal(v.x(), -49287.9610554, v.y(), -49347.7643002));
    assert_eq!(v.get_incident_edge()?.0, 1123);
    let v = output.vertices()[361].get();
    assert!(almost_equal(v.x(), -49312.5000000, v.y(), -49294.0000000));
    assert_eq!(v.get_incident_edge()?.0, 1125);
    let v = output.vertices()[362].get();
    assert!(almost_equal(v.x(), -49267.6220398, v.y(), -49608.5275254));
    assert_eq!(v.get_incident_edge()?.0, 1133);
    let v = output.vertices()[363].get();
    assert!(almost_equal(v.x(), -49331.5635838, v.y(), -49728.3078035));
    assert_eq!(v.get_incident_edge()?.0, 1135);
    let v = output.vertices()[364].get();
    assert!(almost_equal(v.x(), -49259.2347033, v.y(), -49627.6204571));
    assert_eq!(v.get_incident_edge()?.0, 1141);
    let v = output.vertices()[365].get();
    assert!(almost_equal(v.x(), -49255.4352524, v.y(), -49607.8633125));
    assert_eq!(v.get_incident_edge()?.0, 1143);
    let v = output.vertices()[366].get();
    assert!(almost_equal(v.x(), -49276.1473088, v.y(), -49685.2577904));
    assert_eq!(v.get_incident_edge()?.0, 1145);
    let v = output.vertices()[367].get();
    assert!(almost_equal(v.x(), -49302.2800000, v.y(), -49294.0000000));
    assert_eq!(v.get_incident_edge()?.0, 1147);
    let v = output.vertices()[368].get();
    assert!(almost_equal(v.x(), -49252.6993339, v.y(), -49608.6072138));
    assert_eq!(v.get_incident_edge()?.0, 1153);
    let v = output.vertices()[369].get();
    assert!(almost_equal(v.x(), -49298.6033163, v.y(), -49499.9095812));
    assert_eq!(v.get_incident_edge()?.0, 1155);
    let v = output.vertices()[370].get();
    assert!(almost_equal(v.x(), -49260.1775534, v.y(), -49868.8224466));
    assert_eq!(v.get_incident_edge()?.0, 1157);
    let v = output.vertices()[371].get();
    assert!(almost_equal(v.x(), -49321.0755814, v.y(), -49730.5552326));
    assert_eq!(v.get_incident_edge()?.0, 1159);
    let v = output.vertices()[372].get();
    assert!(almost_equal(v.x(), -49271.6263858, v.y(), -49050.5266075));
    assert_eq!(v.get_incident_edge()?.0, 1165);
    let v = output.vertices()[373].get();
    assert!(almost_equal(v.x(), -49316.4981364, v.y(), -49730.4683190));
    assert_eq!(v.get_incident_edge()?.0, 1167);
    let v = output.vertices()[374].get();
    assert!(almost_equal(v.x(), -49291.1276984, v.y(), -49296.5117796));
    assert_eq!(v.get_incident_edge()?.0, 1169);
    let v = output.vertices()[375].get();
    assert!(almost_equal(v.x(), -49273.7494856, v.y(), -49071.9056070));
    assert_eq!(v.get_incident_edge()?.0, 1173);
    let v = output.vertices()[376].get();
    assert!(almost_equal(v.x(), -49264.9718750, v.y(), -49943.5593750));
    assert_eq!(v.get_incident_edge()?.0, 1177);
    let v = output.vertices()[377].get();
    assert!(almost_equal(v.x(), -49275.1026368, v.y(), -49285.6237596));
    assert_eq!(v.get_incident_edge()?.0, 1183);
    let v = output.vertices()[378].get();
    assert!(almost_equal(v.x(), -49261.1085401, v.y(), -49086.8219227));
    assert_eq!(v.get_incident_edge()?.0, 1185);
    let v = output.vertices()[379].get();
    assert!(almost_equal(v.x(), -49251.1394152, v.y(), -49847.8913607));
    assert_eq!(v.get_incident_edge()?.0, 1187);
    let v = output.vertices()[380].get();
    assert!(almost_equal(v.x(), -49304.8026906, v.y(), -49735.4047085));
    assert_eq!(v.get_incident_edge()?.0, 1189);
    let v = output.vertices()[381].get();
    assert!(almost_equal(v.x(), -49251.4135157, v.y(), -49914.9428801));
    assert_eq!(v.get_incident_edge()?.0, 1191);
    let v = output.vertices()[382].get();
    assert!(almost_equal(v.x(), -49235.6856682, v.y(), -49645.3654745));
    assert_eq!(v.get_incident_edge()?.0, 1195);
    let v = output.vertices()[383].get();
    assert!(almost_equal(v.x(), -49233.1935550, v.y(), -49356.8252856));
    assert_eq!(v.get_incident_edge()?.0, 1197);
    let v = output.vertices()[384].get();
    assert!(almost_equal(v.x(), -49227.6261931, v.y(), -49357.4376989));
    assert_eq!(v.get_incident_edge()?.0, 1203);
    let v = output.vertices()[385].get();
    assert!(almost_equal(v.x(), -49231.8438556, v.y(), -49360.8522129));
    assert_eq!(v.get_incident_edge()?.0, 1205);
    let v = output.vertices()[386].get();
    assert!(almost_equal(v.x(), -49289.4559165, v.y(), -49745.7470998));
    assert_eq!(v.get_incident_edge()?.0, 1207);
    let v = output.vertices()[387].get();
    assert!(almost_equal(v.x(), -49257.1545623, v.y(), -49198.7988826));
    assert_eq!(v.get_incident_edge()?.0, 1209);
    let v = output.vertices()[388].get();
    assert!(almost_equal(v.x(), -49238.6362686, v.y(), -49568.9749388));
    assert_eq!(v.get_incident_edge()?.0, 1211);
    let v = output.vertices()[389].get();
    assert!(almost_equal(v.x(), -49270.5585034, v.y(), -49445.4142857));
    assert_eq!(v.get_incident_edge()?.0, 1213);
    let v = output.vertices()[390].get();
    assert!(almost_equal(v.x(), -49235.0158467, v.y(), -49377.1693078));
    assert_eq!(v.get_incident_edge()?.0, 1217);
    let v = output.vertices()[391].get();
    assert!(almost_equal(v.x(), -49219.2284280, v.y(), -49321.3305878));
    assert_eq!(v.get_incident_edge()?.0, 1219);
    let v = output.vertices()[392].get();
    assert!(almost_equal(v.x(), -49226.5235294, v.y(), -49597.7223529));
    assert_eq!(v.get_incident_edge()?.0, 1221);
    let v = output.vertices()[393].get();
    assert!(almost_equal(v.x(), -49217.6286666, v.y(), -49320.7943981));
    assert_eq!(v.get_incident_edge()?.0, 1225);
    let v = output.vertices()[394].get();
    assert!(almost_equal(v.x(), -49267.4113629, v.y(), -49447.9562069));
    assert_eq!(v.get_incident_edge()?.0, 1227);
    let v = output.vertices()[395].get();
    assert!(almost_equal(v.x(), -49262.4635087, v.y(), -49445.4268796));
    assert_eq!(v.get_incident_edge()?.0, 1229);
    let v = output.vertices()[396].get();
    assert!(almost_equal(v.x(), -49200.3811938, v.y(), -49352.8968656));
    assert_eq!(v.get_incident_edge()?.0, 1231);
    let v = output.vertices()[397].get();
    assert!(almost_equal(v.x(), -49243.6030395, v.y(), -49120.4351153));
    assert_eq!(v.get_incident_edge()?.0, 1233);
    let v = output.vertices()[398].get();
    assert!(almost_equal(v.x(), -49235.8378690, v.y(), -49401.7410055));
    assert_eq!(v.get_incident_edge()?.0, 1235);
    let v = output.vertices()[399].get();
    assert!(almost_equal(v.x(), -49237.9606742, v.y(), -49931.9831461));
    assert_eq!(v.get_incident_edge()?.0, 1237);
    let v = output.vertices()[400].get();
    assert!(almost_equal(v.x(), -49477.2737691, v.y(), -48805.9609509));
    assert_eq!(v.get_incident_edge()?.0, 1239);
    let v = output.vertices()[401].get();
    assert!(almost_equal(v.x(), -49241.6820906, v.y(), -49138.2301606));
    assert_eq!(v.get_incident_edge()?.0, 1245);
    let v = output.vertices()[402].get();
    assert!(almost_equal(v.x(), -49240.6294012, v.y(), -49127.0716525));
    assert_eq!(v.get_incident_edge()?.0, 1247);
    let v = output.vertices()[403].get();
    assert!(almost_equal(v.x(), -49244.9931507, v.y(), -49798.0068493));
    assert_eq!(v.get_incident_edge()?.0, 1249);
    let v = output.vertices()[404].get();
    assert!(almost_equal(v.x(), -49216.9855573, v.y(), -49655.2602826));
    assert_eq!(v.get_incident_edge()?.0, 1251);
    let v = output.vertices()[405].get();
    assert!(almost_equal(v.x(), -49264.5923050, v.y(), -49759.6607917));
    assert_eq!(v.get_incident_edge()?.0, 1253);
    let v = output.vertices()[406].get();
    assert!(almost_equal(v.x(), -49238.1552514, v.y(), -49179.8858450));
    assert_eq!(v.get_incident_edge()?.0, 1255);
    let v = output.vertices()[407].get();
    assert!(almost_equal(v.x(), -49187.1846544, v.y(), -49369.1974424));
    assert_eq!(v.get_incident_edge()?.0, 1261);
    let v = output.vertices()[408].get();
    assert!(almost_equal(v.x(), -49223.6475410, v.y(), -49933.6760973));
    assert_eq!(v.get_incident_edge()?.0, 1263);
    let v = output.vertices()[409].get();
    assert!(almost_equal(v.x(), -49233.0068729, v.y(), -49429.6465390));
    assert_eq!(v.get_incident_edge()?.0, 1269);
    let v = output.vertices()[410].get();
    assert!(almost_equal(v.x(), -49179.3136069, v.y(), -49128.3994060));
    assert_eq!(v.get_incident_edge()?.0, 1271);
    let v = output.vertices()[411].get();
    assert!(almost_equal(v.x(), -49231.0869947, v.y(), -49429.7917399));
    assert_eq!(v.get_incident_edge()?.0, 1273);
    let v = output.vertices()[412].get();
    assert!(almost_equal(v.x(), -49210.8552632, v.y(), -49918.4078947));
    assert_eq!(v.get_incident_edge()?.0, 1277);
    let v = output.vertices()[413].get();
    assert!(almost_equal(v.x(), -49210.7354214, v.y(), -49918.2645786));
    assert_eq!(v.get_incident_edge()?.0, 1279);
    let v = output.vertices()[414].get();
    assert!(almost_equal(v.x(), -49234.9106068, v.y(), -49192.8856861));
    assert_eq!(v.get_incident_edge()?.0, 1281);
    let v = output.vertices()[415].get();
    assert!(almost_equal(v.x(), -49160.6938464, v.y(), -49162.5889376));
    assert_eq!(v.get_incident_edge()?.0, 1289);
    let v = output.vertices()[416].get();
    assert!(almost_equal(v.x(), -49247.6779456, v.y(), -49762.6570496));
    assert_eq!(v.get_incident_edge()?.0, 1291);
    let v = output.vertices()[417].get();
    assert!(almost_equal(v.x(), -49158.1818182, v.y(), -49166.4090909));
    assert_eq!(v.get_incident_edge()?.0, 1295);
    let v = output.vertices()[418].get();
    assert!(almost_equal(v.x(), -49164.6465949, v.y(), -49143.8741369));
    assert_eq!(v.get_incident_edge()?.0, 1297);
    let v = output.vertices()[419].get();
    assert!(almost_equal(v.x(), -49162.6961496, v.y(), -49145.7219440));
    assert_eq!(v.get_incident_edge()?.0, 1299);
    let v = output.vertices()[420].get();
    assert!(almost_equal(v.x(), -49177.9675921, v.y(), -49386.5550169));
    assert_eq!(v.get_incident_edge()?.0, 1301);
    let v = output.vertices()[421].get();
    assert!(almost_equal(v.x(), -49190.4222222, v.y(), -49453.3345029));
    assert_eq!(v.get_incident_edge()?.0, 1303);
    let v = output.vertices()[422].get();
    assert!(almost_equal(v.x(), -49174.5323741, v.y(), -49386.7697842));
    assert_eq!(v.get_incident_edge()?.0, 1305);
    let v = output.vertices()[423].get();
    assert!(almost_equal(v.x(), -49217.7593790, v.y(), -49218.5394567));
    assert_eq!(v.get_incident_edge()?.0, 1307);
    let v = output.vertices()[424].get();
    assert!(almost_equal(v.x(), -49149.6585168, v.y(), -49128.4916357));
    assert_eq!(v.get_incident_edge()?.0, 1309);
    let v = output.vertices()[425].get();
    assert!(almost_equal(v.x(), -49152.0296260, v.y(), -49113.6035292));
    assert_eq!(v.get_incident_edge()?.0, 1313);
    let v = output.vertices()[426].get();
    assert!(almost_equal(v.x(), -49140.2614645, v.y(), -49920.9687104));
    assert_eq!(v.get_incident_edge()?.0, 1319);
    let v = output.vertices()[427].get();
    assert!(almost_equal(v.x(), -49194.2009598, v.y(), -49567.0159118));
    assert_eq!(v.get_incident_edge()?.0, 1321);
    let v = output.vertices()[428].get();
    assert!(almost_equal(v.x(), -49171.6127290, v.y(), -49871.3872710));
    assert_eq!(v.get_incident_edge()?.0, 1323);
    let v = output.vertices()[429].get();
    assert!(almost_equal(v.x(), -49210.1237113, v.y(), -49232.9381443));
    assert_eq!(v.get_incident_edge()?.0, 1325);
    let v = output.vertices()[430].get();
    assert!(almost_equal(v.x(), -49188.3156398, v.y(), -49665.9412322));
    assert_eq!(v.get_incident_edge()?.0, 1331);
    let v = output.vertices()[431].get();
    assert!(almost_equal(v.x(), -49154.2544529, v.y(), -49388.6132316));
    assert_eq!(v.get_incident_edge()?.0, 1333);
    let v = output.vertices()[432].get();
    assert!(almost_equal(v.x(), -49113.1289013, v.y(), -49439.3508852));
    assert_eq!(v.get_incident_edge()?.0, 1341);
    let v = output.vertices()[433].get();
    assert!(almost_equal(v.x(), -49112.5184374, v.y(), -49905.5926251));
    assert_eq!(v.get_incident_edge()?.0, 1347);
    let v = output.vertices()[434].get();
    assert!(almost_equal(v.x(), -49105.8671665, v.y(), -49856.4765770));
    assert_eq!(v.get_incident_edge()?.0, 1349);
    let v = output.vertices()[435].get();
    assert!(almost_equal(v.x(), -49151.5519288, v.y(), -49824.8486647));
    assert_eq!(v.get_incident_edge()?.0, 1353);
    let v = output.vertices()[436].get();
    assert!(almost_equal(v.x(), -49099.1295440, v.y(), -49449.6528683));
    assert_eq!(v.get_incident_edge()?.0, 1357);
    let v = output.vertices()[437].get();
    assert!(almost_equal(v.x(), -49190.2769220, v.y(), -49746.3538003));
    assert_eq!(v.get_incident_edge()?.0, 1359);
    let v = output.vertices()[438].get();
    assert!(almost_equal(v.x(), -49125.8181818, v.y(), -49829.6785714));
    assert_eq!(v.get_incident_edge()?.0, 1361);
    let v = output.vertices()[439].get();
    assert!(almost_equal(v.x(), -49149.5000000, v.y(), -49811.0714286));
    assert_eq!(v.get_incident_edge()?.0, 1363);
    let v = output.vertices()[440].get();
    assert!(almost_equal(v.x(), -49092.6727569, v.y(), -49855.5308972));
    assert_eq!(v.get_incident_edge()?.0, 1367);
    let v = output.vertices()[441].get();
    assert!(almost_equal(v.x(), -49130.9040698, v.y(), -49973.7587209));
    assert_eq!(v.get_incident_edge()?.0, 1369);
    let v = output.vertices()[442].get();
    assert!(almost_equal(v.x(), -49157.1995610, v.y(), -49606.0139693));
    assert_eq!(v.get_incident_edge()?.0, 1375);
    let v = output.vertices()[443].get();
    assert!(almost_equal(v.x(), -49106.3623188, v.y(), -49934.2862319));
    assert_eq!(v.get_incident_edge()?.0, 1377);
    let v = output.vertices()[444].get();
    assert!(almost_equal(v.x(), -49126.3751912, v.y(), -49625.0152931));
    assert_eq!(v.get_incident_edge()?.0, 1379);
    let v = output.vertices()[445].get();
    assert!(almost_equal(v.x(), -49162.3120718, v.y(), -49565.9211208));
    assert_eq!(v.get_incident_edge()?.0, 1381);
    let v = output.vertices()[446].get();
    assert!(almost_equal(v.x(), -49105.9883062, v.y(), -49137.7204111));
    assert_eq!(v.get_incident_edge()?.0, 1387);
    let v = output.vertices()[447].get();
    assert!(almost_equal(v.x(), -49084.7188612, v.y(), -49845.8247331));
    assert_eq!(v.get_incident_edge()?.0, 1389);
    let v = output.vertices()[448].get();
    assert!(almost_equal(v.x(), -49118.2484069, v.y(), -49384.1154984));
    assert_eq!(v.get_incident_edge()?.0, 1391);
    let v = output.vertices()[449].get();
    assert!(almost_equal(v.x(), -49149.8070421, v.y(), -49549.2227253));
    assert_eq!(v.get_incident_edge()?.0, 1397);
    let v = output.vertices()[450].get();
    assert!(almost_equal(v.x(), -49099.4918033, v.y(), -49945.4508197));
    assert_eq!(v.get_incident_edge()?.0, 1399);
    let v = output.vertices()[451].get();
    assert!(almost_equal(v.x(), -49139.8555556, v.y(), -49522.5309942));
    assert_eq!(v.get_incident_edge()?.0, 1401);
    let v = output.vertices()[452].get();
    assert!(almost_equal(v.x(), -49149.5000000, v.y(), -49764.7771084));
    assert_eq!(v.get_incident_edge()?.0, 1403);
    let v = output.vertices()[453].get();
    assert!(almost_equal(v.x(), -49081.0767717, v.y(), -49918.1692913));
    assert_eq!(v.get_incident_edge()?.0, 1405);
    let v = output.vertices()[454].get();
    assert!(almost_equal(v.x(), -49150.1916986, v.y(), -49262.9041507));
    assert_eq!(v.get_incident_edge()?.0, 1407);
    let v = output.vertices()[455].get();
    assert!(almost_equal(v.x(), -49100.0337893, v.y(), -49090.8285910));
    assert_eq!(v.get_incident_edge()?.0, 1409);
    let v = output.vertices()[456].get();
    assert!(almost_equal(v.x(), -49104.1267606, v.y(), -49973.2605634));
    assert_eq!(v.get_incident_edge()?.0, 1411);
    let v = output.vertices()[457].get();
    assert!(almost_equal(v.x(), -49136.2342332, v.y(), -49533.2043653));
    assert_eq!(v.get_incident_edge()?.0, 1413);
    let v = output.vertices()[458].get();
    assert!(almost_equal(v.x(), -49128.2409830, v.y(), -49532.1850918));
    assert_eq!(v.get_incident_edge()?.0, 1417);
    let v = output.vertices()[459].get();
    assert!(almost_equal(v.x(), -49132.8189421, v.y(), -49032.3789934));
    assert_eq!(v.get_incident_edge()?.0, 1423);
    let v = output.vertices()[460].get();
    assert!(almost_equal(v.x(), -49128.0738113, v.y(), -49760.9049057));
    assert_eq!(v.get_incident_edge()?.0, 1425);
    let v = output.vertices()[461].get();
    assert!(almost_equal(v.x(), -49108.8623454, v.y(), -49534.8441366));
    assert_eq!(v.get_incident_edge()?.0, 1427);
    let v = output.vertices()[462].get();
    assert!(almost_equal(v.x(), -49152.2245738, v.y(), -48975.0725889));
    assert_eq!(v.get_incident_edge()?.0, 1429);
    let v = output.vertices()[463].get();
    assert!(almost_equal(v.x(), -49067.7995477, v.y(), -49637.5011307));
    assert_eq!(v.get_incident_edge()?.0, 1431);
    let v = output.vertices()[464].get();
    assert!(almost_equal(v.x(), -49098.7535491, v.y(), -49063.1046420));
    assert_eq!(v.get_incident_edge()?.0, 1433);
    let v = output.vertices()[465].get();
    assert!(almost_equal(v.x(), -49113.0247666, v.y(), -50008.6659319));
    assert_eq!(v.get_incident_edge()?.0, 1437);
    let v = output.vertices()[466].get();
    assert!(almost_equal(v.x(), -49095.6325301, v.y(), -49196.6686747));
    assert_eq!(v.get_incident_edge()?.0, 1439);
    let v = output.vertices()[467].get();
    assert!(almost_equal(v.x(), -49126.5203252, v.y(), -49264.7391599));
    assert_eq!(v.get_incident_edge()?.0, 1443);
    let v = output.vertices()[468].get();
    assert!(almost_equal(v.x(), -49095.1250000, v.y(), -49197.9375000));
    assert_eq!(v.get_incident_edge()?.0, 1445);
    let v = output.vertices()[469].get();
    assert!(almost_equal(v.x(), -49496.3344077, v.y(), -48606.3110395));
    assert_eq!(v.get_incident_edge()?.0, 1447);
    let v = output.vertices()[470].get();
    assert!(almost_equal(v.x(), -49089.4098060, v.y(), -49211.0222863));
    assert_eq!(v.get_incident_edge()?.0, 1455);
    let v = output.vertices()[471].get();
    assert!(almost_equal(v.x(), -49113.1676301, v.y(), -49265.0173410));
    assert_eq!(v.get_incident_edge()?.0, 1457);
    let v = output.vertices()[472].get();
    assert!(almost_equal(v.x(), -49046.4691420, v.y(), -49633.5313577));
    assert_eq!(v.get_incident_edge()?.0, 1459);
    let v = output.vertices()[473].get();
    assert!(almost_equal(v.x(), -49031.5553653, v.y(), -49549.6604924));
    assert_eq!(v.get_incident_edge()?.0, 1463);
    let v = output.vertices()[474].get();
    assert!(almost_equal(v.x(), -49027.3575991, v.y(), -49053.2848017));
    assert_eq!(v.get_incident_edge()?.0, 1467);
    let v = output.vertices()[475].get();
    assert!(almost_equal(v.x(), -49121.0565111, v.y(), -50067.1953317));
    assert_eq!(v.get_incident_edge()?.0, 1469);
    let v = output.vertices()[476].get();
    assert!(almost_equal(v.x(), -49022.9325925, v.y(), -49050.6691007));
    assert_eq!(v.get_incident_edge()?.0, 1471);
    let v = output.vertices()[477].get();
    assert!(almost_equal(v.x(), -48999.9166667, v.y(), -49546.2083333));
    assert_eq!(v.get_incident_edge()?.0, 1473);
    let v = output.vertices()[478].get();
    assert!(almost_equal(v.x(), -49038.4061217, v.y(), -49180.1258237));
    assert_eq!(v.get_incident_edge()?.0, 1475);
    let v = output.vertices()[479].get();
    assert!(almost_equal(v.x(), -49011.4237805, v.y(), -49045.1524390));
    assert_eq!(v.get_incident_edge()?.0, 1477);
    let v = output.vertices()[480].get();
    assert!(almost_equal(v.x(), -49032.5143787, v.y(), -49176.7759541));
    assert_eq!(v.get_incident_edge()?.0, 1479);
    let v = output.vertices()[481].get();
    assert!(almost_equal(v.x(), -49048.1216981, v.y(), -49765.7358491));
    assert_eq!(v.get_incident_edge()?.0, 1481);
    let v = output.vertices()[482].get();
    assert!(almost_equal(v.x(), -49021.7066929, v.y(), -49883.9173228));
    assert_eq!(v.get_incident_edge()?.0, 1483);
    let v = output.vertices()[483].get();
    assert!(almost_equal(v.x(), -49054.1704545, v.y(), -49337.1250000));
    assert_eq!(v.get_incident_edge()?.0, 1487);
    let v = output.vertices()[484].get();
    assert!(almost_equal(v.x(), -49875.5018282, v.y(), -50834.6302559));
    assert_eq!(v.get_incident_edge()?.0, 1489);
    let v = output.vertices()[485].get();
    assert!(almost_equal(v.x(), -49141.2878830, v.y(), -50159.5009661));
    assert_eq!(v.get_incident_edge()?.0, 1491);
    let v = output.vertices()[486].get();
    assert!(almost_equal(v.x(), -49002.5533981, v.y(), -49878.9424411));
    assert_eq!(v.get_incident_edge()?.0, 1493);
    let v = output.vertices()[487].get();
    assert!(almost_equal(v.x(), -49028.2391282, v.y(), -49349.8971458));
    assert_eq!(v.get_incident_edge()?.0, 1495);
    let v = output.vertices()[488].get();
    assert!(almost_equal(v.x(), -48974.2773408, v.y(), -49145.7534254));
    assert_eq!(v.get_incident_edge()?.0, 1497);
    let v = output.vertices()[489].get();
    assert!(almost_equal(v.x(), -48961.4653794, v.y(), -49139.7338380));
    assert_eq!(v.get_incident_edge()?.0, 1499);
    let v = output.vertices()[490].get();
    assert!(almost_equal(v.x(), -49198.9198582, v.y(), -48747.5827423));
    assert_eq!(v.get_incident_edge()?.0, 1501);
    let v = output.vertices()[491].get();
    assert!(almost_equal(v.x(), -48995.7857143, v.y(), -49781.5952381));
    assert_eq!(v.get_incident_edge()?.0, 1503);
    let v = output.vertices()[492].get();
    assert!(almost_equal(v.x(), -48957.6250000, v.y(), -49651.9375000));
    assert_eq!(v.get_incident_edge()?.0, 1505);
    let v = output.vertices()[493].get();
    assert!(almost_equal(v.x(), -49202.4439462, v.y(), -48703.1121076));
    assert_eq!(v.get_incident_edge()?.0, 1507);
    let v = output.vertices()[494].get();
    assert!(almost_equal(v.x(), -49206.9282511, v.y(), -48654.1434978));
    assert_eq!(v.get_incident_edge()?.0, 1509);
    let v = output.vertices()[495].get();
    assert!(almost_equal(v.x(), -48954.9526813, v.y(), -49373.9119349));
    assert_eq!(v.get_incident_edge()?.0, 1511);
    let v = output.vertices()[496].get();
    assert!(almost_equal(v.x(), -49142.3319132, v.y(), -50400.6719597));
    assert_eq!(v.get_incident_edge()?.0, 1513);
    let v = output.vertices()[497].get();
    assert!(almost_equal(v.x(), -48878.8307309, v.y(), -49388.7248562));
    assert_eq!(v.get_incident_edge()?.0, 1515);
    let v = output.vertices()[498].get();
    assert!(almost_equal(v.x(), -48878.6696817, v.y(), -49388.7562256));
    assert_eq!(v.get_incident_edge()?.0, 1517);
    let v = output.vertices()[499].get();
    assert!(almost_equal(v.x(), -49461.3550816, v.y(), -50747.1242158));
    assert_eq!(v.get_incident_edge()?.0, 1519);
    let v = output.vertices()[500].get();
    assert!(almost_equal(v.x(), -48853.7184466, v.y(), -49818.9528433));
    assert_eq!(v.get_incident_edge()?.0, 1521);
    let v = output.vertices()[501].get();
    assert!(almost_equal(v.x(), -48841.3490789, v.y(), -49812.8201316));
    assert_eq!(v.get_incident_edge()?.0, 1523);
    let v = output.vertices()[502].get();
    assert!(almost_equal(v.x(), -49139.1913246, v.y(), -50576.1959721));
    assert_eq!(v.get_incident_edge()?.0, 1525);
    let v = output.vertices()[503].get();
    assert!(almost_equal(v.x(), -48739.3416290, v.y(), -49415.9208145));
    assert_eq!(v.get_incident_edge()?.0, 1527);
    let v = output.vertices()[504].get();
    assert!(almost_equal(v.x(), -48661.9913295, v.y(), -49799.7543353));
    assert_eq!(v.get_incident_edge()?.0, 1529);
    let v = output.vertices()[505].get();
    assert!(almost_equal(v.x(), -49745.5502728, v.y(), -43435.0818394));
    assert_eq!(v.get_incident_edge()?.0, 1531);
    let v = output.vertices()[506].get();
    assert!(almost_equal(v.x(), -45630.0148515, v.y(), -47770.9983498));
    assert_eq!(v.get_incident_edge()?.0, 1533);
    let v = output.vertices()[507].get();
    assert!(almost_equal(v.x(), -49970.1323338, v.y(), -40375.7750978));
    assert_eq!(v.get_incident_edge()?.0, 1535);
    let v = output.vertices()[508].get();
    assert!(almost_equal(v.x(), -50139.8356401, v.y(), -37883.2577855));
    assert_eq!(v.get_incident_edge()?.0, 1537);
    let v = output.vertices()[509].get();
    assert!(almost_equal(v.x(), -39458.3565684, v.y(), -50536.9386729));
    assert_eq!(v.get_incident_edge()?.0, 1539);
    Ok(())
}
