use boostvoronoi as BV;
use boostvoronoi::prelude::*;
use std::io::{BufReader, Cursor};

mod common;
use common::almost_equal;

type I = i32;
type F = f64;

#[test]
fn sample_primary_067() -> Result<(), BvError> {
    let output = {
        let input = r#"0
191
-50042 -49987 -49958 -49945
-50038 -49880 -49984 -49840
-50037 -49252 -49945 -49166
-50037 -49056 -49996 -49148
-50032 -49217 -49997 -49201
-50026 -49270 -49960 -49312
-50015 -49525 -49981 -49615
-49999 -49338 -49906 -49318
-49987 -49179 -49967 -49165
-49979 -49752 -49915 -49671
-49969 -49530 -49933 -49592
-49951 -49784 -49879 -49749
-49951 -49221 -49901 -49194
-49946 -49228 -49884 -49303
-49945 -49017 -49892 -49044
-49942 -49455 -49940 -49549
-49935 -49727 -49867 -49646
-49935 -49357 -49857 -49444
-49929 -49561 -49868 -49576
-49927 -49909 -49877 -49866
-49917 -49237 -49913 -49230
-49914 -49291 -49888 -49357
-49911 -49876 -49902 -49845
-49898 -49977 -49854 -49895
-49898 -49495 -49817 -49490
-49894 -50000 -49824 -50069
-49893 -49680 -49865 -49692
-49882 -49217 -49795 -49150
-49873 -49323 -49831 -49278
-49865 -49067 -49777 -49100
-49859 -49115 -49822 -49170
-49856 -49764 -49847 -49787
-49855 -49475 -49796 -49446
-49847 -49503 -49826 -49601
-49847 -49227 -49774 -49288
-49838 -49679 -49810 -49646
-49821 -49704 -49807 -49760
-49818 -49528 -49797 -49532
-49812 -49585 -49753 -49537
-49805 -49866 -49749 -49911
-49803 -49243 -49742 -49282
-49795 -49351 -49763 -49446
-49790 -49322 -49768 -49409
-49788 -49759 -49766 -49695
-49780 -49048 -49765 -49147
-49773 -49459 -49741 -49530
-49764 -49068 -49746 -49104
-49762 -49163 -49758 -49119
-49760 -49208 -49715 -49126
-49756 -49583 -49713 -49539
-49754 -49728 -49690 -49715
-49752 -49643 -49686 -49622
-49748 -49983 -49653 -49989
-49735 -49490 -49710 -49475
-49733 -49426 -49649 -49404
-49730 -49073 -49701 -49052
-49727 -49005 -49681 -48996
-49722 -49757 -49687 -49773
-49702 -49179 -49668 -49222
-49701 -49141 -49666 -49086
-49698 -49353 -49683 -49290
-49696 -49526 -49669 -49525
-49692 -49988 -49637 -50061
-49691 -49859 -49676 -49844
-49690 -49445 -49637 -49414
-49682 -49552 -49675 -49610
-49679 -49853 -49671 -49918
-49677 -49383 -49616 -49389
-49673 -49827 -49666 -49784
-49663 -49990 -49626 -50052
-49661 -49742 -49639 -49842
-49655 -49070 -49627 -48996
-49650 -49495 -49585 -49491
-49649 -49907 -49584 -49945
-49645 -49253 -49640 -49189
-49644 -49285 -49555 -49253
-49643 -49740 -49592 -49686
-49640 -49281 -49602 -49182
-49630 -49389 -49536 -49479
-49622 -49335 -49554 -49292
-49619 -49538 -49606 -49522
-49606 -49039 -49535 -49096
-49602 -49383 -49599 -49328
-49600 -49700 -49596 -49691
-49599 -49612 -49531 -49514
-49599 -49560 -49546 -49483
-49592 -49206 -49563 -49198
-49588 -49783 -49564 -49811
-49575 -49789 -49486 -49772
-49570 -49179 -49482 -49278
-49557 -49225 -49506 -49269
-49552 -49621 -49524 -49654
-49540 -49058 -49532 -49085
-49534 -49873 -49522 -49964
-49532 -49626 -49502 -49607
-49530 -49638 -49432 -49539
-49527 -49420 -49478 -49505
-49526 -49716 -49439 -49744
-49508 -49372 -49498 -49454
-49508 -49301 -49468 -49382
-49507 -49275 -49459 -49371
-49497 -49840 -49422 -49895
-49494 -49252 -49451 -49251
-49480 -49732 -49452 -49803
-49472 -49036 -49460 -49129
-49459 -49831 -49391 -49775
-49456 -49427 -49390 -49409
-49453 -49001 -49452 -48918
-49441 -48971 -49380 -49025
-49438 -49914 -49388 -49964
-49430 -49525 -49342 -49457
-49427 -49116 -49393 -49180
-49424 -49378 -49339 -49293
-49420 -49667 -49378 -49577
-49419 -49208 -49392 -49286
-49417 -49885 -49407 -49797
-49417 -49327 -49345 -49285
-49404 -49689 -49389 -49637
-49399 -49430 -49320 -49375
-49399 -49238 -49370 -49259
-49394 -49946 -49367 -49866
-49388 -49703 -49362 -49664
-49385 -49785 -49311 -49789
-49382 -49166 -49378 -49154
-49375 -49211 -49344 -49286
-49374 -49997 -49313 -50051
-49367 -49941 -49348 -49969
-49364 -49787 -49340 -49887
-49359 -49232 -49315 -49203
-49351 -49957 -49323 -49869
-49349 -48969 -49303 -49026
-49344 -49030 -49342 -49116
-49333 -49248 -49326 -49316
-49304 -49695 -49210 -49737
-49301 -49643 -49244 -49656
-49300 -49907 -49242 -49908
-49295 -49272 -49231 -49194
-49293 -49026 -49291 -48987
-49290 -49992 -49244 -49950
-49287 -49539 -49265 -49542
-49278 -49142 -49261 -49117
-49277 -49304 -49216 -49313
-49272 -49800 -49251 -49769
-49270 -49894 -49239 -49809
-49269 -49397 -49196 -49319
-49268 -49911 -49171 -49902
-49257 -49050 -49208 -49086
-49250 -49780 -49178 -49731
-49239 -49113 -49166 -49120
-49237 -49247 -49203 -49166
-49230 -49019 -49194 -49061
-49217 -49465 -49215 -49528
-49213 -49605 -49116 -49548
-49212 -49846 -49211 -49815
-49209 -49912 -49171 -49955
-49203 -49685 -49188 -49672
-49203 -49234 -49147 -49333
-49201 -49854 -49116 -49916
-49200 -49087 -49190 -49045
-49188 -49258 -49133 -49220
-49179 -49615 -49150 -49581
-49179 -49568 -49137 -49507
-49168 -49326 -49114 -49385
-49164 -50078 -49090 -49990
-49164 -49498 -49157 -49409
-49160 -49807 -49085 -49875
-49158 -49601 -49136 -49624
-49156 -49015 -49063 -49081
-49155 -49894 -49135 -49907
-49150 -49949 -49107 -49930
-49150 -49143 -49147 -49210
-49149 -49896 -49076 -49946
-49147 -49219 -49094 -49155
-49132 -49474 -49113 -49509
-49129 -49400 -49052 -49347
-49114 -49721 -49082 -49630
-49113 -49663 -49106 -49585
-49109 -49241 -49091 -49330
-49107 -49230 -49067 -49179
-49106 -49585 -49097 -49487
-49104 -49006 -49077 -49043
-49083 -49910 -49080 -49941
-49069 -49028 -49010 -48971
-49068 -49800 -49050 -49796
-49045 -49223 -49029 -49273
-49043 -49598 -48998 -49619
-49037 -49738 -49031 -49678
-49037 -49062 -49024 -49129
-49033 -49407 -49023 -49483
-49008 -49795 -48973 -49798
-49003 -49428 -48993 -49376
"#;
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = BV::read_boost_input_buffer::<I, _>(br)?;
        Builder::<I, F>::default()
            .with_vertices(points.iter())?
            .with_segments(segments.iter())?
            .build()?
    };

    // A full test would take 7200+ loc
    assert_eq!(output.cells().len(), 572);
    assert_eq!(output.vertices().len(), 1132);
    assert_eq!(output.edges().len(), 3406);

    let v = output.vertices()[125].get();
    assert!(almost_equal(v.x(), -49914.3108808, v.y(), -49097.5388601));
    assert_eq!(v.get_incident_edge().unwrap().0, 421);

    let v = output.vertices()[956].get();
    assert!(almost_equal(v.x(), -49143.5540387, v.y(), -49221.8536867));
    assert_eq!(v.get_incident_edge().unwrap().0, 2923);

    let v = output.vertices()[1128].get();
    assert!(almost_equal(v.x(), -48066.2582575, v.y(), -49134.2429392));
    assert_eq!(v.get_incident_edge().unwrap().0, 3399);

    Ok(())
}
