use boostvoronoi as BV;
use boostvoronoi::prelude::*;
use std::io::{BufReader, Cursor};

mod common;
use common::almost_equal;

type I = i32;
type F = f64;

//#[ignore]
#[test]
fn sample_primary_068() -> Result<(), BvError> {
    let output: BV::SyncDiagram<F> = {
        let input = r#"0
87
-50021 -49808 -49940 -49833
-50019 -49363 -49964 -49351
-49963 -49703 -49912 -49721
-49948 -49289 -49940 -49212
-49916 -49137 -49870 -49141
-49906 -49419 -49873 -49349
-49903 -49328 -49899 -49307
-49897 -49741 -49852 -49675
-49895 -49638 -49828 -49568
-49893 -49251 -49855 -49313
-49871 -49502 -49801 -49551
-49866 -49431 -49834 -49524
-49861 -49122 -49812 -49030
-49852 -49901 -49814 -49872
-49815 -49601 -49716 -49652
-49799 -49916 -49785 -49916
-49766 -49501 -49745 -49523
-49765 -49266 -49672 -49282
-49763 -49207 -49681 -49170
-49756 -49650 -49744 -49699
-49748 -49703 -49663 -49657
-49736 -49581 -49683 -49534
-49736 -49463 -49700 -49534
-49732 -49049 -49674 -49119
-49722 -49992 -49694 -49963
-49710 -49415 -49648 -49378
-49710 -49298 -49670 -49339
-49688 -49985 -49652 -50004
-49684 -49416 -49634 -49459
-49659 -49561 -49573 -49550
-49654 -49211 -49613 -49161
-49638 -49058 -49576 -49104
-49624 -49012 -49543 -49051
-49621 -49341 -49619 -49317
-49608 -49406 -49593 -49379
-49599 -49228 -49538 -49293
-49598 -49634 -49527 -49534
-49594 -49713 -49523 -49729
-49586 -49735 -49580 -49724
-49564 -49184 -49531 -49109
-49560 -49651 -49528 -49579
-49552 -49739 -49457 -49829
-49549 -49938 -49543 -49953
-49517 -49670 -49480 -49763
-49508 -49076 -49493 -49008
-49507 -49467 -49451 -49459
-49478 -49308 -49439 -49383
-49477 -48995 -49393 -49025
-49468 -49237 -49401 -49183
-49464 -49517 -49393 -49532
-49453 -49670 -49395 -49751
-49448 -49430 -49367 -49380
-49434 -49371 -49403 -49302
-49422 -49836 -49384 -49882
-49408 -49095 -49396 -49110
-49387 -49237 -49366 -49277
-49368 -49766 -49365 -49777
-49366 -49860 -49280 -49911
-49359 -49526 -49355 -49554
-49352 -49281 -49275 -49187
-49346 -49424 -49327 -49370
-49346 -48957 -49257 -49045
-49344 -49529 -49311 -49595
-49344 -49131 -49270 -49077
-49331 -49505 -49276 -49470
-49275 -49446 -49269 -49529
-49274 -48994 -49239 -49083
-49269 -49530 -49266 -49579
-49268 -49916 -49229 -49923
-49254 -49830 -49233 -49777
-49214 -49820 -49168 -49806
-49214 -49246 -49207 -49200
-49209 -49470 -49159 -49503
-49203 -49239 -49121 -49256
-49186 -49302 -49156 -49306
-49185 -49612 -49130 -49664
-49158 -49718 -49100 -49653
-49155 -49271 -49056 -49347
-49138 -49437 -49061 -49374
-49137 -49475 -49136 -49540
-49126 -49059 -49069 -49056
-49113 -49751 -49072 -49794
-49102 -49977 -49024 -49998
-49070 -49161 -49052 -49212
-49053 -49902 -49030 -49948
-49048 -49413 -49004 -49497
-49021 -49751 -49015 -49668
"#;
        let br = BufReader::new(Cursor::new(input));
        let (points, segments) = BV::read_boost_input_buffer::<I, _>(br)?;
        Builder::<I, F>::default()
            .with_vertices(points.iter())?
            .with_segments(segments.iter())?
            .build()?
            .into()
    };
    assert_eq!(output.cells().len(), 261);
    let cell = output.cells()[0];
    assert_eq!(cell.id().0, 0);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[1];
    assert_eq!(cell.id().0, 1);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[2];
    assert_eq!(cell.id().0, 2);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[3];
    assert_eq!(cell.id().0, 3);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[4];
    assert_eq!(cell.id().0, 4);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[5];
    assert_eq!(cell.id().0, 5);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[6];
    assert_eq!(cell.id().0, 6);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[7];
    assert_eq!(cell.id().0, 7);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[8];
    assert_eq!(cell.id().0, 8);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[9];
    assert_eq!(cell.id().0, 9);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[10];
    assert_eq!(cell.id().0, 10);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[11];
    assert_eq!(cell.id().0, 11);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[12];
    assert_eq!(cell.id().0, 12);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[13];
    assert_eq!(cell.id().0, 13);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[14];
    assert_eq!(cell.id().0, 14);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[15];
    assert_eq!(cell.id().0, 15);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[16];
    assert_eq!(cell.id().0, 16);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[17];
    assert_eq!(cell.id().0, 17);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[18];
    assert_eq!(cell.id().0, 18);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[19];
    assert_eq!(cell.id().0, 19);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[20];
    assert_eq!(cell.id().0, 20);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[21];
    assert_eq!(cell.id().0, 21);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[22];
    assert_eq!(cell.id().0, 22);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[23];
    assert_eq!(cell.id().0, 23);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[24];
    assert_eq!(cell.id().0, 24);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[25];
    assert_eq!(cell.id().0, 25);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[26];
    assert_eq!(cell.id().0, 26);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[27];
    assert_eq!(cell.id().0, 27);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[28];
    assert_eq!(cell.id().0, 28);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[29];
    assert_eq!(cell.id().0, 29);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[30];
    assert_eq!(cell.id().0, 30);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[31];
    assert_eq!(cell.id().0, 31);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[32];
    assert_eq!(cell.id().0, 32);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[33];
    assert_eq!(cell.id().0, 33);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[34];
    assert_eq!(cell.id().0, 34);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[35];
    assert_eq!(cell.id().0, 35);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[36];
    assert_eq!(cell.id().0, 36);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[37];
    assert_eq!(cell.id().0, 37);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[38];
    assert_eq!(cell.id().0, 38);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[39];
    assert_eq!(cell.id().0, 39);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[40];
    assert_eq!(cell.id().0, 40);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[41];
    assert_eq!(cell.id().0, 41);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[42];
    assert_eq!(cell.id().0, 42);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[43];
    assert_eq!(cell.id().0, 43);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[44];
    assert_eq!(cell.id().0, 44);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[45];
    assert_eq!(cell.id().0, 45);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[46];
    assert_eq!(cell.id().0, 46);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[47];
    assert_eq!(cell.id().0, 47);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[48];
    assert_eq!(cell.id().0, 48);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[49];
    assert_eq!(cell.id().0, 49);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[50];
    assert_eq!(cell.id().0, 50);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[51];
    assert_eq!(cell.id().0, 51);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[52];
    assert_eq!(cell.id().0, 52);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[53];
    assert_eq!(cell.id().0, 53);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[54];
    assert_eq!(cell.id().0, 54);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[55];
    assert_eq!(cell.id().0, 55);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[56];
    assert_eq!(cell.id().0, 56);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[57];
    assert_eq!(cell.id().0, 57);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[58];
    assert_eq!(cell.id().0, 58);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[59];
    assert_eq!(cell.id().0, 59);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[60];
    assert_eq!(cell.id().0, 60);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[61];
    assert_eq!(cell.id().0, 61);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[62];
    assert_eq!(cell.id().0, 62);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[63];
    assert_eq!(cell.id().0, 63);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[64];
    assert_eq!(cell.id().0, 64);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[65];
    assert_eq!(cell.id().0, 65);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[66];
    assert_eq!(cell.id().0, 66);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[67];
    assert_eq!(cell.id().0, 67);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[68];
    assert_eq!(cell.id().0, 68);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[69];
    assert_eq!(cell.id().0, 69);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[70];
    assert_eq!(cell.id().0, 70);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[71];
    assert_eq!(cell.id().0, 71);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[72];
    assert_eq!(cell.id().0, 72);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[73];
    assert_eq!(cell.id().0, 73);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[74];
    assert_eq!(cell.id().0, 74);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[75];
    assert_eq!(cell.id().0, 75);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[76];
    assert_eq!(cell.id().0, 76);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[77];
    assert_eq!(cell.id().0, 77);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[78];
    assert_eq!(cell.id().0, 78);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[79];
    assert_eq!(cell.id().0, 79);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[80];
    assert_eq!(cell.id().0, 80);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[81];
    assert_eq!(cell.id().0, 81);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[82];
    assert_eq!(cell.id().0, 82);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[83];
    assert_eq!(cell.id().0, 83);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[84];
    assert_eq!(cell.id().0, 84);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[85];
    assert_eq!(cell.id().0, 85);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[86];
    assert_eq!(cell.id().0, 86);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[87];
    assert_eq!(cell.id().0, 87);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[88];
    assert_eq!(cell.id().0, 88);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[89];
    assert_eq!(cell.id().0, 89);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[90];
    assert_eq!(cell.id().0, 90);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[91];
    assert_eq!(cell.id().0, 91);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[92];
    assert_eq!(cell.id().0, 92);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[93];
    assert_eq!(cell.id().0, 93);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[94];
    assert_eq!(cell.id().0, 94);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[95];
    assert_eq!(cell.id().0, 95);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[96];
    assert_eq!(cell.id().0, 96);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[97];
    assert_eq!(cell.id().0, 97);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[98];
    assert_eq!(cell.id().0, 98);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[99];
    assert_eq!(cell.id().0, 99);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[100];
    assert_eq!(cell.id().0, 100);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[101];
    assert_eq!(cell.id().0, 101);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[102];
    assert_eq!(cell.id().0, 102);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[103];
    assert_eq!(cell.id().0, 103);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[104];
    assert_eq!(cell.id().0, 104);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[105];
    assert_eq!(cell.id().0, 105);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[106];
    assert_eq!(cell.id().0, 106);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[107];
    assert_eq!(cell.id().0, 107);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[108];
    assert_eq!(cell.id().0, 108);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[109];
    assert_eq!(cell.id().0, 109);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[110];
    assert_eq!(cell.id().0, 110);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[111];
    assert_eq!(cell.id().0, 111);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[112];
    assert_eq!(cell.id().0, 112);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[113];
    assert_eq!(cell.id().0, 113);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[114];
    assert_eq!(cell.id().0, 114);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[115];
    assert_eq!(cell.id().0, 115);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[116];
    assert_eq!(cell.id().0, 116);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[117];
    assert_eq!(cell.id().0, 117);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[118];
    assert_eq!(cell.id().0, 118);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[119];
    assert_eq!(cell.id().0, 119);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[120];
    assert_eq!(cell.id().0, 120);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[121];
    assert_eq!(cell.id().0, 121);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[122];
    assert_eq!(cell.id().0, 122);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[123];
    assert_eq!(cell.id().0, 123);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[124];
    assert_eq!(cell.id().0, 124);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[125];
    assert_eq!(cell.id().0, 125);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[126];
    assert_eq!(cell.id().0, 126);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[127];
    assert_eq!(cell.id().0, 127);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[128];
    assert_eq!(cell.id().0, 128);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[129];
    assert_eq!(cell.id().0, 129);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[130];
    assert_eq!(cell.id().0, 130);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[131];
    assert_eq!(cell.id().0, 131);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[132];
    assert_eq!(cell.id().0, 132);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[133];
    assert_eq!(cell.id().0, 133);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[134];
    assert_eq!(cell.id().0, 134);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[135];
    assert_eq!(cell.id().0, 135);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[136];
    assert_eq!(cell.id().0, 136);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[137];
    assert_eq!(cell.id().0, 137);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[138];
    assert_eq!(cell.id().0, 138);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[139];
    assert_eq!(cell.id().0, 139);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[140];
    assert_eq!(cell.id().0, 140);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[141];
    assert_eq!(cell.id().0, 141);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[142];
    assert_eq!(cell.id().0, 142);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[143];
    assert_eq!(cell.id().0, 143);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[144];
    assert_eq!(cell.id().0, 144);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[145];
    assert_eq!(cell.id().0, 145);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[146];
    assert_eq!(cell.id().0, 146);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[147];
    assert_eq!(cell.id().0, 147);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[148];
    assert_eq!(cell.id().0, 148);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[149];
    assert_eq!(cell.id().0, 149);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[150];
    assert_eq!(cell.id().0, 150);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[151];
    assert_eq!(cell.id().0, 151);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[152];
    assert_eq!(cell.id().0, 152);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[153];
    assert_eq!(cell.id().0, 153);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[154];
    assert_eq!(cell.id().0, 154);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[155];
    assert_eq!(cell.id().0, 155);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[156];
    assert_eq!(cell.id().0, 156);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[157];
    assert_eq!(cell.id().0, 157);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[158];
    assert_eq!(cell.id().0, 158);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[159];
    assert_eq!(cell.id().0, 159);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[160];
    assert_eq!(cell.id().0, 160);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[161];
    assert_eq!(cell.id().0, 161);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[162];
    assert_eq!(cell.id().0, 162);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[163];
    assert_eq!(cell.id().0, 163);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[164];
    assert_eq!(cell.id().0, 164);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[165];
    assert_eq!(cell.id().0, 165);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[166];
    assert_eq!(cell.id().0, 166);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[167];
    assert_eq!(cell.id().0, 167);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[168];
    assert_eq!(cell.id().0, 168);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[169];
    assert_eq!(cell.id().0, 169);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[170];
    assert_eq!(cell.id().0, 170);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[171];
    assert_eq!(cell.id().0, 171);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[172];
    assert_eq!(cell.id().0, 172);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[173];
    assert_eq!(cell.id().0, 173);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[174];
    assert_eq!(cell.id().0, 174);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[175];
    assert_eq!(cell.id().0, 175);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[176];
    assert_eq!(cell.id().0, 176);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[177];
    assert_eq!(cell.id().0, 177);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[178];
    assert_eq!(cell.id().0, 178);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[179];
    assert_eq!(cell.id().0, 179);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[180];
    assert_eq!(cell.id().0, 180);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[181];
    assert_eq!(cell.id().0, 181);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[182];
    assert_eq!(cell.id().0, 182);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[183];
    assert_eq!(cell.id().0, 183);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[184];
    assert_eq!(cell.id().0, 184);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[185];
    assert_eq!(cell.id().0, 185);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[186];
    assert_eq!(cell.id().0, 186);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[187];
    assert_eq!(cell.id().0, 187);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[188];
    assert_eq!(cell.id().0, 188);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[189];
    assert_eq!(cell.id().0, 189);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[190];
    assert_eq!(cell.id().0, 190);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[191];
    assert_eq!(cell.id().0, 191);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[192];
    assert_eq!(cell.id().0, 192);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[193];
    assert_eq!(cell.id().0, 193);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[194];
    assert_eq!(cell.id().0, 194);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[195];
    assert_eq!(cell.id().0, 195);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[196];
    assert_eq!(cell.id().0, 196);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[197];
    assert_eq!(cell.id().0, 197);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[198];
    assert_eq!(cell.id().0, 198);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[199];
    assert_eq!(cell.id().0, 199);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[200];
    assert_eq!(cell.id().0, 200);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[201];
    assert_eq!(cell.id().0, 201);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[202];
    assert_eq!(cell.id().0, 202);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[203];
    assert_eq!(cell.id().0, 203);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[204];
    assert_eq!(cell.id().0, 204);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[205];
    assert_eq!(cell.id().0, 205);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[206];
    assert_eq!(cell.id().0, 206);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[207];
    assert_eq!(cell.id().0, 207);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[208];
    assert_eq!(cell.id().0, 208);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[209];
    assert_eq!(cell.id().0, 209);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[210];
    assert_eq!(cell.id().0, 210);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[211];
    assert_eq!(cell.id().0, 211);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[212];
    assert_eq!(cell.id().0, 212);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[213];
    assert_eq!(cell.id().0, 213);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[214];
    assert_eq!(cell.id().0, 214);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[215];
    assert_eq!(cell.id().0, 215);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[216];
    assert_eq!(cell.id().0, 216);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[217];
    assert_eq!(cell.id().0, 217);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[218];
    assert_eq!(cell.id().0, 218);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[219];
    assert_eq!(cell.id().0, 219);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[220];
    assert_eq!(cell.id().0, 220);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[221];
    assert_eq!(cell.id().0, 221);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[222];
    assert_eq!(cell.id().0, 222);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[223];
    assert_eq!(cell.id().0, 223);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[224];
    assert_eq!(cell.id().0, 224);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[225];
    assert_eq!(cell.id().0, 225);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[226];
    assert_eq!(cell.id().0, 226);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[227];
    assert_eq!(cell.id().0, 227);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[228];
    assert_eq!(cell.id().0, 228);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[229];
    assert_eq!(cell.id().0, 229);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[230];
    assert_eq!(cell.id().0, 230);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[231];
    assert_eq!(cell.id().0, 231);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[232];
    assert_eq!(cell.id().0, 232);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[233];
    assert_eq!(cell.id().0, 233);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[234];
    assert_eq!(cell.id().0, 234);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[235];
    assert_eq!(cell.id().0, 235);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[236];
    assert_eq!(cell.id().0, 236);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[237];
    assert_eq!(cell.id().0, 237);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[238];
    assert_eq!(cell.id().0, 238);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[239];
    assert_eq!(cell.id().0, 239);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[240];
    assert_eq!(cell.id().0, 240);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[241];
    assert_eq!(cell.id().0, 241);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[242];
    assert_eq!(cell.id().0, 242);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[243];
    assert_eq!(cell.id().0, 243);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[244];
    assert_eq!(cell.id().0, 244);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[245];
    assert_eq!(cell.id().0, 245);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[246];
    assert_eq!(cell.id().0, 246);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[247];
    assert_eq!(cell.id().0, 247);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[248];
    assert_eq!(cell.id().0, 248);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[249];
    assert_eq!(cell.id().0, 249);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[250];
    assert_eq!(cell.id().0, 250);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[251];
    assert_eq!(cell.id().0, 251);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[252];
    assert_eq!(cell.id().0, 252);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[253];
    assert_eq!(cell.id().0, 253);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[254];
    assert_eq!(cell.id().0, 254);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[255];
    assert_eq!(cell.id().0, 255);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[256];
    assert_eq!(cell.id().0, 256);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[257];
    assert_eq!(cell.id().0, 257);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[258];
    assert_eq!(cell.id().0, 258);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(_cat, BV::SourceCategory::Segment);
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), false);
    assert_eq!(cell.contains_segment(), true);
    let cell = output.cells()[259];
    assert_eq!(cell.id().0, 259);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    let cell = output.cells()[260];
    assert_eq!(cell.id().0, 260);
    let (_source_index, _cat) = cell.source_index_2();
    assert_eq!(cell.is_degenerate(), false);
    assert_eq!(cell.contains_point(), true);
    assert_eq!(cell.contains_segment(), false);
    assert_eq!(output.vertices().len(), 510);
    assert_eq!(output.edges().len(), 1540);
    let v = output.vertices()[0];
    assert!(almost_equal(v.x(), -50030.7619556, v.y(), -49280.4013553));
    assert_eq!(v.get_incident_edge().unwrap().0, 17);
    let v = output.vertices()[1];
    assert!(almost_equal(v.x(), -50038.5393380, v.y(), -49273.4447009));
    assert_eq!(v.get_incident_edge().unwrap().0, 19);
    let v = output.vertices()[2];
    assert!(almost_equal(v.x(), -50302.0535156, v.y(), -49584.2323438));
    assert_eq!(v.get_incident_edge().unwrap().0, 21);
    let v = output.vertices()[3];
    assert!(almost_equal(v.x(), -50002.9324460, v.y(), -49749.4611251));
    assert_eq!(v.get_incident_edge().unwrap().0, 23);
    let v = output.vertices()[4];
    assert!(almost_equal(v.x(), -50169.3573333, v.y(), -49188.1706667));
    assert_eq!(v.get_incident_edge().unwrap().0, 29);
    let v = output.vertices()[5];
    assert!(almost_equal(v.x(), -49971.6444997, v.y(), -49315.9627098));
    assert_eq!(v.get_incident_edge().unwrap().0, 31);
    let v = output.vertices()[6];
    assert!(almost_equal(v.x(), -49982.5501603, v.y(), -49758.3921208));
    assert_eq!(v.get_incident_edge().unwrap().0, 33);
    let v = output.vertices()[7];
    assert!(almost_equal(v.x(), -49939.2196837, v.y(), -49324.3304042));
    assert_eq!(v.get_incident_edge().unwrap().0, 49);
    let v = output.vertices()[8];
    assert!(almost_equal(v.x(), -49953.1956718, v.y(), -49400.5198377));
    assert_eq!(v.get_incident_edge().unwrap().0, 51);
    let v = output.vertices()[9];
    assert!(almost_equal(v.x(), -49936.8174387, v.y(), -49321.5585831));
    assert_eq!(v.get_incident_edge().unwrap().0, 53);
    let v = output.vertices()[10];
    assert!(almost_equal(v.x(), -49950.3496193, v.y(), -49398.0923223));
    assert_eq!(v.get_incident_edge().unwrap().0, 55);
    let v = output.vertices()[11];
    assert!(almost_equal(v.x(), -49924.9877384, v.y(), -49302.0499546));
    assert_eq!(v.get_incident_edge().unwrap().0, 59);
    let v = output.vertices()[12];
    assert!(almost_equal(v.x(), -49919.5000000, v.y(), -49742.2500000));
    assert_eq!(v.get_incident_edge().unwrap().0, 65);
    let v = output.vertices()[13];
    assert!(almost_equal(v.x(), -49997.4873760, v.y(), -49461.5995266));
    assert_eq!(v.get_incident_edge().unwrap().0, 67);
    let v = output.vertices()[14];
    assert!(almost_equal(v.x(), -49907.9126984, v.y(), -49733.5595238));
    assert_eq!(v.get_incident_edge().unwrap().0, 73);
    let v = output.vertices()[15];
    assert!(almost_equal(v.x(), -49921.2161093, v.y(), -49291.7827419));
    assert_eq!(v.get_incident_edge().unwrap().0, 75);
    let v = output.vertices()[16];
    assert!(almost_equal(v.x(), -49945.4540648, v.y(), -49653.2865169));
    assert_eq!(v.get_incident_edge().unwrap().0, 81);
    let v = output.vertices()[17];
    assert!(almost_equal(v.x(), -50616.7711864, v.y(), -48954.0932203));
    assert_eq!(v.get_incident_edge().unwrap().0, 83);
    let v = output.vertices()[18];
    assert!(almost_equal(v.x(), -49947.1748124, v.y(), -49770.0888152));
    assert_eq!(v.get_incident_edge().unwrap().0, 85);
    let v = output.vertices()[19];
    assert!(almost_equal(v.x(), -49917.1321465, v.y(), -49265.7906704));
    assert_eq!(v.get_incident_edge().unwrap().0, 87);
    let v = output.vertices()[20];
    assert!(almost_equal(v.x(), -49924.7484277, v.y(), -49362.7106918));
    assert_eq!(v.get_incident_edge().unwrap().0, 89);
    let v = output.vertices()[21];
    assert!(almost_equal(v.x(), -49914.2760499, v.y(), -49278.3756835));
    assert_eq!(v.get_incident_edge().unwrap().0, 91);
    let v = output.vertices()[22];
    assert!(almost_equal(v.x(), -49919.4974619, v.y(), -49177.2208122));
    assert_eq!(v.get_incident_edge().unwrap().0, 93);
    let v = output.vertices()[23];
    assert!(almost_equal(v.x(), -49924.8818459, v.y(), -49784.0171807));
    assert_eq!(v.get_incident_edge().unwrap().0, 95);
    let v = output.vertices()[24];
    assert!(almost_equal(v.x(), -49889.8045113, v.y(), -49341.0778733));
    assert_eq!(v.get_incident_edge().unwrap().0, 99);
    let v = output.vertices()[25];
    assert!(almost_equal(v.x(), -50025.5915218, v.y(), -49518.3096779));
    assert_eq!(v.get_incident_edge().unwrap().0, 105);
    let v = output.vertices()[26];
    assert!(almost_equal(v.x(), -49901.4125370, v.y(), -49691.0021882));
    assert_eq!(v.get_incident_edge().unwrap().0, 109);
    let v = output.vertices()[27];
    assert!(almost_equal(v.x(), -50050.9891629, v.y(), -49542.8805680));
    assert_eq!(v.get_incident_edge().unwrap().0, 111);
    let v = output.vertices()[28];
    assert!(almost_equal(v.x(), -49903.4685831, v.y(), -49215.7954719));
    assert_eq!(v.get_incident_edge().unwrap().0, 113);
    let v = output.vertices()[29];
    assert!(almost_equal(v.x(), -50046.9633481, v.y(), -49541.0652915));
    assert_eq!(v.get_incident_edge().unwrap().0, 115);
    let v = output.vertices()[30];
    assert!(almost_equal(v.x(), -49886.9011264, v.y(), -49428.0037547));
    assert_eq!(v.get_incident_edge().unwrap().0, 121);
    let v = output.vertices()[31];
    assert!(almost_equal(v.x(), -49890.3093525, v.y(), -49439.3645084));
    assert_eq!(v.get_incident_edge().unwrap().0, 123);
    let v = output.vertices()[32];
    assert!(almost_equal(v.x(), -49905.4321405, v.y(), -49678.7307061));
    assert_eq!(v.get_incident_edge().unwrap().0, 125);
    let v = output.vertices()[33];
    assert!(almost_equal(v.x(), -49883.2794118, v.y(), -49331.7563025));
    assert_eq!(v.get_incident_edge().unwrap().0, 127);
    let v = output.vertices()[34];
    assert!(almost_equal(v.x(), -49984.8170075, v.y(), -49552.0322928));
    assert_eq!(v.get_incident_edge().unwrap().0, 133);
    let v = output.vertices()[35];
    assert!(almost_equal(v.x(), -49879.5882455, v.y(), -49310.6974770));
    assert_eq!(v.get_incident_edge().unwrap().0, 135);
    let v = output.vertices()[36];
    assert!(almost_equal(v.x(), -49869.0285714, v.y(), -49129.8285714));
    assert_eq!(v.get_incident_edge().unwrap().0, 137);
    let v = output.vertices()[37];
    assert!(almost_equal(v.x(), -49889.6034658, v.y(), -49106.7655454));
    assert_eq!(v.get_incident_edge().unwrap().0, 139);
    let v = output.vertices()[38];
    assert!(almost_equal(v.x(), -49904.6036714, v.y(), -49467.2907048));
    assert_eq!(v.get_incident_edge().unwrap().0, 141);
    let v = output.vertices()[39];
    assert!(almost_equal(v.x(), -49877.0632734, v.y(), -49324.5092896));
    assert_eq!(v.get_incident_edge().unwrap().0, 145);
    let v = output.vertices()[40];
    assert!(almost_equal(v.x(), -49875.2173913, v.y(), -49325.3913043));
    assert_eq!(v.get_incident_edge().unwrap().0, 153);
    let v = output.vertices()[41];
    assert!(almost_equal(v.x(), -49875.5829447, v.y(), -49658.9207195));
    assert_eq!(v.get_incident_edge().unwrap().0, 155);
    let v = output.vertices()[42];
    assert!(almost_equal(v.x(), -49862.1771964, v.y(), -49489.3959949));
    assert_eq!(v.get_incident_edge().unwrap().0, 157);
    let v = output.vertices()[43];
    assert!(almost_equal(v.x(), -49874.4807797, v.y(), -49657.6398251));
    assert_eq!(v.get_incident_edge().unwrap().0, 159);
    let v = output.vertices()[44];
    assert!(almost_equal(v.x(), -49909.1749963, v.y(), -49556.5357090));
    assert_eq!(v.get_incident_edge().unwrap().0, 161);
    let v = output.vertices()[45];
    assert!(almost_equal(v.x(), -49910.0893459, v.y(), -49069.0274782));
    assert_eq!(v.get_incident_edge().unwrap().0, 163);
    let v = output.vertices()[46];
    assert!(almost_equal(v.x(), -49835.6702494, v.y(), -49524.5747095));
    assert_eq!(v.get_incident_edge().unwrap().0, 167);
    let v = output.vertices()[47];
    assert!(almost_equal(v.x(), -49886.6773352, v.y(), -49195.5598655));
    assert_eq!(v.get_incident_edge().unwrap().0, 169);
    let v = output.vertices()[48];
    assert!(almost_equal(v.x(), -49886.9174455, v.y(), -49855.2461059));
    assert_eq!(v.get_incident_edge().unwrap().0, 171);
    let v = output.vertices()[49];
    assert!(almost_equal(v.x(), -49986.7351874, v.y(), -49984.4220073));
    assert_eq!(v.get_incident_edge().unwrap().0, 173);
    let v = output.vertices()[50];
    assert!(almost_equal(v.x(), -49846.4402902, v.y(), -49550.3500079));
    assert_eq!(v.get_incident_edge().unwrap().0, 177);
    let v = output.vertices()[51];
    assert!(almost_equal(v.x(), -49874.9025621, v.y(), -49197.3794643));
    assert_eq!(v.get_incident_edge().unwrap().0, 179);
    let v = output.vertices()[52];
    assert!(almost_equal(v.x(), -49818.1982793, v.y(), -49518.5628488));
    assert_eq!(v.get_incident_edge().unwrap().0, 189);
    let v = output.vertices()[53];
    assert!(almost_equal(v.x(), -49831.1205505, v.y(), -49928.3592786));
    assert_eq!(v.get_incident_edge().unwrap().0, 197);
    let v = output.vertices()[54];
    assert!(almost_equal(v.x(), -49836.2586237, v.y(), -49636.6206882));
    assert_eq!(v.get_incident_edge().unwrap().0, 199);
    let v = output.vertices()[55];
    assert!(almost_equal(v.x(), -49813.8923422, v.y(), -49581.5030439));
    assert_eq!(v.get_incident_edge().unwrap().0, 201);
    let v = output.vertices()[56];
    assert!(almost_equal(v.x(), -49810.9247911, v.y(), -49565.1782730));
    assert_eq!(v.get_incident_edge().unwrap().0, 203);
    let v = output.vertices()[57];
    assert!(almost_equal(v.x(), -49833.9457831, v.y(), -49637.7771084));
    assert_eq!(v.get_incident_edge().unwrap().0, 205);
    let v = output.vertices()[58];
    assert!(almost_equal(v.x(), -49864.5871210, v.y(), -49812.1984108));
    assert_eq!(v.get_incident_edge().unwrap().0, 207);
    let v = output.vertices()[59];
    assert!(almost_equal(v.x(), -49861.2207177, v.y(), -49810.1245768));
    assert_eq!(v.get_incident_edge().unwrap().0, 211);
    let v = output.vertices()[60];
    assert!(almost_equal(v.x(), -50048.8069364, v.y(), -48903.8745665));
    assert_eq!(v.get_incident_edge().unwrap().0, 213);
    let v = output.vertices()[61];
    assert!(almost_equal(v.x(), -49803.2787770, v.y(), -49577.3219424));
    assert_eq!(v.get_incident_edge().unwrap().0, 215);
    let v = output.vertices()[62];
    assert!(almost_equal(v.x(), -49802.8622881, v.y(), -49577.4385593));
    assert_eq!(v.get_incident_edge().unwrap().0, 217);
    let v = output.vertices()[63];
    assert!(almost_equal(v.x(), -49799.1283816, v.y(), -49891.4869483));
    assert_eq!(v.get_incident_edge().unwrap().0, 219);
    let v = output.vertices()[64];
    assert!(almost_equal(v.x(), -49799.0000000, v.y(), -49891.4431818));
    assert_eq!(v.get_incident_edge().unwrap().0, 221);
    let v = output.vertices()[65];
    assert!(almost_equal(v.x(), -49801.8264515, v.y(), -49506.2267763));
    assert_eq!(v.get_incident_edge().unwrap().0, 227);
    let v = output.vertices()[66];
    assert!(almost_equal(v.x(), -49835.9453642, v.y(), -49205.5250602));
    assert_eq!(v.get_incident_edge().unwrap().0, 237);
    let v = output.vertices()[67];
    assert!(almost_equal(v.x(), -49833.0004110, v.y(), -49214.2260584));
    assert_eq!(v.get_incident_edge().unwrap().0, 239);
    let v = output.vertices()[68];
    assert!(almost_equal(v.x(), -49811.6143090, v.y(), -49286.4087700));
    assert_eq!(v.get_incident_edge().unwrap().0, 241);
    let v = output.vertices()[69];
    assert!(almost_equal(v.x(), -49788.2918013, v.y(), -49522.2785376));
    assert_eq!(v.get_incident_edge().unwrap().0, 243);
    let v = output.vertices()[70];
    assert!(almost_equal(v.x(), -49824.3295159, v.y(), -49234.4549317));
    assert_eq!(v.get_incident_edge().unwrap().0, 245);
    let v = output.vertices()[71];
    assert!(almost_equal(v.x(), -49802.7390729, v.y(), -49661.4463036));
    assert_eq!(v.get_incident_edge().unwrap().0, 251);
    let v = output.vertices()[72];
    assert!(almost_equal(v.x(), -49804.0148293, v.y(), -49662.4521273));
    assert_eq!(v.get_incident_edge().unwrap().0, 253);
    let v = output.vertices()[73];
    assert!(almost_equal(v.x(), -49783.6725108, v.y(), -49526.2464439));
    assert_eq!(v.get_incident_edge().unwrap().0, 255);
    let v = output.vertices()[74];
    assert!(almost_equal(v.x(), -49785.0000000, v.y(), -49884.4431818));
    assert_eq!(v.get_incident_edge().unwrap().0, 257);
    let v = output.vertices()[75];
    assert!(almost_equal(v.x(), -49804.8803545, v.y(), -49707.1270310));
    assert_eq!(v.get_incident_edge().unwrap().0, 263);
    let v = output.vertices()[76];
    assert!(almost_equal(v.x(), -49801.0764666, v.y(), -49692.9983044));
    assert_eq!(v.get_incident_edge().unwrap().0, 265);
    let v = output.vertices()[77];
    assert!(almost_equal(v.x(), -49751.0820428, v.y(), -49697.3049209));
    assert_eq!(v.get_incident_edge().unwrap().0, 269);
    let v = output.vertices()[78];
    assert!(almost_equal(v.x(), -49746.0989964, v.y(), -49699.5140399));
    assert_eq!(v.get_incident_edge().unwrap().0, 273);
    let v = output.vertices()[79];
    assert!(almost_equal(v.x(), -49827.2163018, v.y(), -49788.5797942));
    assert_eq!(v.get_incident_edge().unwrap().0, 275);
    let v = output.vertices()[80];
    assert!(almost_equal(v.x(), -49807.2921584, v.y(), -49159.0721355));
    assert_eq!(v.get_incident_edge().unwrap().0, 277);
    let v = output.vertices()[81];
    assert!(almost_equal(v.x(), -49742.7488830, v.y(), -49698.6936040));
    assert_eq!(v.get_incident_edge().unwrap().0, 279);
    let v = output.vertices()[82];
    assert!(almost_equal(v.x(), -49746.3001619, v.y(), -49647.6245294));
    assert_eq!(v.get_incident_edge().unwrap().0, 281);
    let v = output.vertices()[83];
    assert!(almost_equal(v.x(), -49768.6923077, v.y(), -49545.6153846));
    assert_eq!(v.get_incident_edge().unwrap().0, 291);
    let v = output.vertices()[84];
    assert!(almost_equal(v.x(), -49774.3628783, v.y(), -49578.7029029));
    assert_eq!(v.get_incident_edge().unwrap().0, 293);
    let v = output.vertices()[85];
    assert!(almost_equal(v.x(), -49802.2689477, v.y(), -49153.2806691));
    assert_eq!(v.get_incident_edge().unwrap().0, 295);
    let v = output.vertices()[86];
    assert!(almost_equal(v.x(), -49795.4209744, v.y(), -49446.9308097));
    assert_eq!(v.get_incident_edge().unwrap().0, 297);
    let v = output.vertices()[87];
    assert!(almost_equal(v.x(), -49759.7884505, v.y(), -49475.0617496));
    assert_eq!(v.get_incident_edge().unwrap().0, 299);
    let v = output.vertices()[88];
    assert!(almost_equal(v.x(), -49774.4887227, v.y(), -49049.9788325));
    assert_eq!(v.get_incident_edge().unwrap().0, 305);
    let v = output.vertices()[89];
    assert!(almost_equal(v.x(), -49759.9483602, v.y(), -49236.6373437));
    assert_eq!(v.get_incident_edge().unwrap().0, 307);
    let v = output.vertices()[90];
    assert!(almost_equal(v.x(), -49749.7614735, v.y(), -49485.4995884));
    assert_eq!(v.get_incident_edge().unwrap().0, 309);
    let v = output.vertices()[91];
    assert!(almost_equal(v.x(), -49763.7000000, v.y(), -49555.6000000));
    assert_eq!(v.get_incident_edge().unwrap().0, 311);
    let v = output.vertices()[92];
    assert!(almost_equal(v.x(), -49759.1505576, v.y(), -49554.8940520));
    assert_eq!(v.get_incident_edge().unwrap().0, 313);
    let v = output.vertices()[93];
    assert!(almost_equal(v.x(), -49799.0000000, v.y(), -49993.0065789));
    assert_eq!(v.get_incident_edge().unwrap().0, 319);
    let v = output.vertices()[94];
    assert!(almost_equal(v.x(), -49792.0310980, v.y(), -49142.6608099));
    assert_eq!(v.get_incident_edge().unwrap().0, 321);
    let v = output.vertices()[95];
    assert!(almost_equal(v.x(), -49785.0000000, v.y(), -49980.1118421));
    assert_eq!(v.get_incident_edge().unwrap().0, 323);
    let v = output.vertices()[96];
    assert!(almost_equal(v.x(), -49776.3922717, v.y(), -49085.7821680));
    assert_eq!(v.get_incident_edge().unwrap().0, 325);
    let v = output.vertices()[97];
    assert!(almost_equal(v.x(), -49749.8453848, v.y(), -49236.1534716));
    assert_eq!(v.get_incident_edge().unwrap().0, 327);
    let v = output.vertices()[98];
    assert!(almost_equal(v.x(), -49798.8275970, v.y(), -49383.9669900));
    assert_eq!(v.get_incident_edge().unwrap().0, 329);
    let v = output.vertices()[99];
    assert!(almost_equal(v.x(), -49732.0063935, v.y(), -49510.5970120));
    assert_eq!(v.get_incident_edge().unwrap().0, 333);
    let v = output.vertices()[100];
    assert!(almost_equal(v.x(), -49806.9436387, v.y(), -49777.3681648));
    assert_eq!(v.get_incident_edge().unwrap().0, 335);
    let v = output.vertices()[101];
    assert!(almost_equal(v.x(), -49790.6822700, v.y(), -49405.0842219));
    assert_eq!(v.get_incident_edge().unwrap().0, 337);
    let v = output.vertices()[102];
    assert!(almost_equal(v.x(), -49790.0859729, v.y(), -49402.6617647));
    assert_eq!(v.get_incident_edge().unwrap().0, 347);
    let v = output.vertices()[103];
    assert!(almost_equal(v.x(), -49729.5354330, v.y(), -49668.8884039));
    assert_eq!(v.get_incident_edge().unwrap().0, 349);
    let v = output.vertices()[104];
    assert!(almost_equal(v.x(), -49757.7275601, v.y(), -49957.5044248));
    assert_eq!(v.get_incident_edge().unwrap().0, 351);
    let v = output.vertices()[105];
    assert!(almost_equal(v.x(), -49724.6746091, v.y(), -49668.8389471));
    assert_eq!(v.get_incident_edge().unwrap().0, 353);
    let v = output.vertices()[106];
    assert!(almost_equal(v.x(), -49869.6855204, v.y(), -50064.6221719));
    assert_eq!(v.get_incident_edge().unwrap().0, 355);
    let v = output.vertices()[107];
    assert!(almost_equal(v.x(), -49792.0626162, v.y(), -49383.3894916));
    assert_eq!(v.get_incident_edge().unwrap().0, 357);
    let v = output.vertices()[108];
    assert!(almost_equal(v.x(), -49725.5813799, v.y(), -49538.5285431));
    assert_eq!(v.get_incident_edge().unwrap().0, 359);
    let v = output.vertices()[109];
    assert!(almost_equal(v.x(), -49713.4746104, v.y(), -49540.8321968));
    assert_eq!(v.get_incident_edge().unwrap().0, 363);
    let v = output.vertices()[110];
    assert!(almost_equal(v.x(), -49786.5331633, v.y(), -49369.7334184));
    assert_eq!(v.get_incident_edge().unwrap().0, 365);
    let v = output.vertices()[111];
    assert!(almost_equal(v.x(), -49779.1923937, v.y(), -49348.4932886));
    assert_eq!(v.get_incident_edge().unwrap().0, 367);
    let v = output.vertices()[112];
    assert!(almost_equal(v.x(), -49772.4738513, v.y(), -49124.3448360));
    assert_eq!(v.get_incident_edge().unwrap().0, 371);
    let v = output.vertices()[113];
    assert!(almost_equal(v.x(), -49777.7659884, v.y(), -49351.2621117));
    assert_eq!(v.get_incident_edge().unwrap().0, 373);
    let v = output.vertices()[114];
    assert!(almost_equal(v.x(), -49701.2142588, v.y(), -49289.4285452));
    assert_eq!(v.get_incident_edge().unwrap().0, 375);
    let v = output.vertices()[115];
    assert!(almost_equal(v.x(), -49777.2241379, v.y(), -49356.5000000));
    assert_eq!(v.get_incident_edge().unwrap().0, 377);
    let v = output.vertices()[116];
    assert!(almost_equal(v.x(), -49769.9625000, v.y(), -49356.5000000));
    assert_eq!(v.get_incident_edge().unwrap().0, 383);
    let v = output.vertices()[117];
    assert!(almost_equal(v.x(), -50161.6061064, v.y(), -50263.5637848));
    assert_eq!(v.get_incident_edge().unwrap().0, 385);
    let v = output.vertices()[118];
    assert!(almost_equal(v.x(), -49691.9739007, v.y(), -49529.9304285));
    assert_eq!(v.get_incident_edge().unwrap().0, 393);
    let v = output.vertices()[119];
    assert!(almost_equal(v.x(), -49732.4589128, v.y(), -49925.8672566));
    assert_eq!(v.get_incident_edge().unwrap().0, 397);
    let v = output.vertices()[120];
    assert!(almost_equal(v.x(), -49691.0260993, v.y(), -49524.9492923));
    assert_eq!(v.get_incident_edge().unwrap().0, 399);
    let v = output.vertices()[121];
    assert!(almost_equal(v.x(), -49743.9617281, v.y(), -49358.0911583));
    assert_eq!(v.get_incident_edge().unwrap().0, 401);
    let v = output.vertices()[122];
    assert!(almost_equal(v.x(), -49697.5381323, v.y(), -49431.7420142));
    assert_eq!(v.get_incident_edge().unwrap().0, 403);
    let v = output.vertices()[123];
    assert!(almost_equal(v.x(), -49697.8503626, v.y(), -49435.3588519));
    assert_eq!(v.get_incident_edge().unwrap().0, 405);
    let v = output.vertices()[124];
    assert!(almost_equal(v.x(), -49700.6782001, v.y(), -50009.0218529));
    assert_eq!(v.get_incident_edge().unwrap().0, 409);
    let v = output.vertices()[125];
    assert!(almost_equal(v.x(), -49706.4001119, v.y(), -49447.9916060));
    assert_eq!(v.get_incident_edge().unwrap().0, 411);
    let v = output.vertices()[126];
    assert!(almost_equal(v.x(), -49684.4556962, v.y(), -49972.2151899));
    assert_eq!(v.get_incident_edge().unwrap().0, 415);
    let v = output.vertices()[127];
    assert!(almost_equal(v.x(), -49709.7007038, v.y(), -49610.6566532));
    assert_eq!(v.get_incident_edge().unwrap().0, 417);
    let v = output.vertices()[128];
    assert!(almost_equal(v.x(), -49700.0036184, v.y(), -50013.2378857));
    assert_eq!(v.get_incident_edge().unwrap().0, 421);
    let v = output.vertices()[129];
    assert!(almost_equal(v.x(), -49676.9778483, v.y(), -49407.8347074));
    assert_eq!(v.get_incident_edge().unwrap().0, 423);
    let v = output.vertices()[130];
    assert!(almost_equal(v.x(), -49700.5476210, v.y(), -49140.9966002));
    assert_eq!(v.get_incident_edge().unwrap().0, 425);
    let v = output.vertices()[131];
    assert!(almost_equal(v.x(), -49680.7138643, v.y(), -49971.1946903));
    assert_eq!(v.get_incident_edge().unwrap().0, 427);
    let v = output.vertices()[132];
    assert!(almost_equal(v.x(), -49700.4163767, v.y(), -49450.9365753));
    assert_eq!(v.get_incident_edge().unwrap().0, 429);
    let v = output.vertices()[133];
    assert!(almost_equal(v.x(), -49693.4968137, v.y(), -49142.3043589));
    assert_eq!(v.get_incident_edge().unwrap().0, 431);
    let v = output.vertices()[134];
    assert!(almost_equal(v.x(), -49695.9894694, v.y(), -49364.3555799));
    assert_eq!(v.get_incident_edge().unwrap().0, 435);
    let v = output.vertices()[135];
    assert!(almost_equal(v.x(), -49675.5954308, v.y(), -49302.8984418));
    assert_eq!(v.get_incident_edge().unwrap().0, 441);
    let v = output.vertices()[136];
    assert!(almost_equal(v.x(), -49671.0158265, v.y(), -49547.5140680));
    assert_eq!(v.get_incident_edge().unwrap().0, 447);
    let v = output.vertices()[137];
    assert!(almost_equal(v.x(), -49697.6335590, v.y(), -49229.5001526));
    assert_eq!(v.get_incident_edge().unwrap().0, 451);
    let v = output.vertices()[138];
    assert!(almost_equal(v.x(), -49673.7707058, v.y(), -49194.7880212));
    assert_eq!(v.get_incident_edge().unwrap().0, 453);
    let v = output.vertices()[139];
    assert!(almost_equal(v.x(), -49670.8315737, v.y(), -49192.5354312));
    assert_eq!(v.get_incident_edge().unwrap().0, 457);
    let v = output.vertices()[140];
    assert!(almost_equal(v.x(), -49693.6648322, v.y(), -49608.6434978));
    assert_eq!(v.get_incident_edge().unwrap().0, 459);
    let v = output.vertices()[141];
    assert!(almost_equal(v.x(), -49661.7755220, v.y(), -49539.3004640));
    assert_eq!(v.get_incident_edge().unwrap().0, 461);
    let v = output.vertices()[142];
    assert!(almost_equal(v.x(), -49685.7670276, v.y(), -49614.9304925));
    assert_eq!(v.get_incident_edge().unwrap().0, 467);
    let v = output.vertices()[143];
    assert!(almost_equal(v.x(), -49659.4766399, v.y(), -49358.7688738));
    assert_eq!(v.get_incident_edge().unwrap().0, 469);
    let v = output.vertices()[144];
    assert!(almost_equal(v.x(), -49685.2971748, v.y(), -49607.8797916));
    assert_eq!(v.get_incident_edge().unwrap().0, 473);
    let v = output.vertices()[145];
    assert!(almost_equal(v.x(), -49685.1127643, v.y(), -49607.9953015));
    assert_eq!(v.get_incident_edge().unwrap().0, 475);
    let v = output.vertices()[146];
    assert!(almost_equal(v.x(), -49665.7715861, v.y(), -49245.7973444));
    assert_eq!(v.get_incident_edge().unwrap().0, 477);
    let v = output.vertices()[147];
    assert!(almost_equal(v.x(), -49658.1435881, v.y(), -49085.1500536));
    assert_eq!(v.get_incident_edge().unwrap().0, 479);
    let v = output.vertices()[148];
    assert!(almost_equal(v.x(), -49685.0027818, v.y(), -49010.0594478));
    assert_eq!(v.get_incident_edge().unwrap().0, 485);
    let v = output.vertices()[149];
    assert!(almost_equal(v.x(), -49670.5053495, v.y(), -49489.0894167));
    assert_eq!(v.get_incident_edge().unwrap().0, 487);
    let v = output.vertices()[150];
    assert!(almost_equal(v.x(), -49681.2513046, v.y(), -49019.7061247));
    assert_eq!(v.get_incident_edge().unwrap().0, 489);
    let v = output.vertices()[151];
    assert!(almost_equal(v.x(), -49645.4576271, v.y(), -49338.9618644));
    assert_eq!(v.get_incident_edge().unwrap().0, 495);
    let v = output.vertices()[152];
    assert!(almost_equal(v.x(), -49648.8130900, v.y(), -49318.3298439));
    assert_eq!(v.get_incident_edge().unwrap().0, 497);
    let v = output.vertices()[153];
    assert!(almost_equal(v.x(), -49645.9547402, v.y(), -49351.1411355));
    assert_eq!(v.get_incident_edge().unwrap().0, 499);
    let v = output.vertices()[154];
    assert!(almost_equal(v.x(), -49650.2259494, v.y(), -49314.3978375));
    assert_eq!(v.get_incident_edge().unwrap().0, 503);
    let v = output.vertices()[155];
    assert!(almost_equal(v.x(), -49663.4620113, v.y(), -49493.2581526));
    assert_eq!(v.get_incident_edge().unwrap().0, 505);
    let v = output.vertices()[156];
    assert!(almost_equal(v.x(), -49651.8823569, v.y(), -49309.1647119));
    assert_eq!(v.get_incident_edge().unwrap().0, 507);
    let v = output.vertices()[157];
    assert!(almost_equal(v.x(), -49650.7363510, v.y(), -49148.1734420));
    assert_eq!(v.get_incident_edge().unwrap().0, 509);
    let v = output.vertices()[158];
    assert!(almost_equal(v.x(), -49646.4838939, v.y(), -49096.2009406));
    assert_eq!(v.get_incident_edge().unwrap().0, 513);
    let v = output.vertices()[159];
    assert!(almost_equal(v.x(), -49634.5533708, v.y(), -49033.9185393));
    assert_eq!(v.get_incident_edge().unwrap().0, 515);
    let v = output.vertices()[160];
    assert!(almost_equal(v.x(), -49640.0434527, v.y(), -49411.0231389));
    assert_eq!(v.get_incident_edge().unwrap().0, 521);
    let v = output.vertices()[161];
    assert!(almost_equal(v.x(), -49634.2860697, v.y(), -49400.9800995));
    assert_eq!(v.get_incident_edge().unwrap().0, 523);
    let v = output.vertices()[162];
    assert!(almost_equal(v.x(), -49629.4560000, v.y(), -49394.0800000));
    assert_eq!(v.get_incident_edge().unwrap().0, 525);
    let v = output.vertices()[163];
    assert!(almost_equal(v.x(), -49641.7353311, v.y(), -49137.4370285));
    assert_eq!(v.get_incident_edge().unwrap().0, 527);
    let v = output.vertices()[164];
    assert!(almost_equal(v.x(), -49652.8168534, v.y(), -49609.3409644));
    assert_eq!(v.get_incident_edge().unwrap().0, 529);
    let v = output.vertices()[165];
    assert!(almost_equal(v.x(), -49623.7148349, v.y(), -49038.7460819));
    assert_eq!(v.get_incident_edge().unwrap().0, 531);
    let v = output.vertices()[166];
    assert!(almost_equal(v.x(), -49629.9646069, v.y(), -49230.7090223));
    assert_eq!(v.get_incident_edge().unwrap().0, 537);
    let v = output.vertices()[167];
    assert!(almost_equal(v.x(), -49642.9782138, v.y(), -49610.2354828));
    assert_eq!(v.get_incident_edge().unwrap().0, 549);
    let v = output.vertices()[168];
    assert!(almost_equal(v.x(), -49640.1072599, v.y(), -49699.3018024));
    assert_eq!(v.get_incident_edge().unwrap().0, 551);
    let v = output.vertices()[169];
    assert!(almost_equal(v.x(), -49620.5874530, v.y(), -49369.6523992));
    assert_eq!(v.get_incident_edge().unwrap().0, 553);
    let v = output.vertices()[170];
    assert!(almost_equal(v.x(), -49636.8913560, v.y(), -49253.1190929));
    assert_eq!(v.get_incident_edge().unwrap().0, 555);
    let v = output.vertices()[171];
    assert!(almost_equal(v.x(), -49705.3608018, v.y(), -50105.1046771));
    assert_eq!(v.get_incident_edge().unwrap().0, 557);
    let v = output.vertices()[172];
    assert!(almost_equal(v.x(), -49640.2839437, v.y(), -49508.4011568));
    assert_eq!(v.get_incident_edge().unwrap().0, 559);
    let v = output.vertices()[173];
    assert!(almost_equal(v.x(), -49615.6832579, v.y(), -49366.3981900));
    assert_eq!(v.get_incident_edge().unwrap().0, 561);
    let v = output.vertices()[174];
    assert!(almost_equal(v.x(), -49636.9537197, v.y(), -49606.3428590));
    assert_eq!(v.get_incident_edge().unwrap().0, 563);
    let v = output.vertices()[175];
    assert!(almost_equal(v.x(), -49632.3328150, v.y(), -49259.2815649));
    assert_eq!(v.get_incident_edge().unwrap().0, 565);
    let v = output.vertices()[176];
    assert!(almost_equal(v.x(), -49629.5165380, v.y(), -49119.6906862));
    assert_eq!(v.get_incident_edge().unwrap().0, 571);
    let v = output.vertices()[177];
    assert!(almost_equal(v.x(), -49666.0750297, v.y(), -49751.6636472));
    assert_eq!(v.get_incident_edge().unwrap().0, 573);
    let v = output.vertices()[178];
    assert!(almost_equal(v.x(), -49599.7000000, v.y(), -49727.5272727));
    assert_eq!(v.get_incident_edge().unwrap().0, 575);
    let v = output.vertices()[179];
    assert!(almost_equal(v.x(), -49614.1147824, v.y(), -49435.8776539));
    assert_eq!(v.get_incident_edge().unwrap().0, 577);
    let v = output.vertices()[180];
    assert!(almost_equal(v.x(), -49597.0294243, v.y(), -49726.4430702));
    assert_eq!(v.get_incident_edge().unwrap().0, 579);
    let v = output.vertices()[181];
    assert!(almost_equal(v.x(), -49585.2730916, v.y(), -49721.1237682));
    assert_eq!(v.get_incident_edge().unwrap().0, 583);
    let v = output.vertices()[182];
    assert!(almost_equal(v.x(), -49625.7234107, v.y(), -49269.5525934));
    assert_eq!(v.get_incident_edge().unwrap().0, 585);
    let v = output.vertices()[183];
    assert!(almost_equal(v.x(), -49620.1594605, v.y(), -49674.7232638));
    assert_eq!(v.get_incident_edge().unwrap().0, 589);
    let v = output.vertices()[184];
    assert!(almost_equal(v.x(), -49591.4114353, v.y(), -49178.7026230));
    assert_eq!(v.get_incident_edge().unwrap().0, 597);
    let v = output.vertices()[185];
    assert!(almost_equal(v.x(), -49596.3511238, v.y(), -49194.1866060));
    assert_eq!(v.get_incident_edge().unwrap().0, 599);
    let v = output.vertices()[186];
    assert!(almost_equal(v.x(), -49596.2853323, v.y(), -49131.3411001));
    assert_eq!(v.get_incident_edge().unwrap().0, 601);
    let v = output.vertices()[187];
    assert!(almost_equal(v.x(), -49588.7801083, v.y(), -49173.0967524));
    assert_eq!(v.get_incident_edge().unwrap().0, 603);
    let v = output.vertices()[188];
    assert!(almost_equal(v.x(), -49570.7438314, v.y(), -49729.0488192));
    assert_eq!(v.get_incident_edge().unwrap().0, 605);
    let v = output.vertices()[189];
    assert!(almost_equal(v.x(), -49580.6942281, v.y(), -49646.2870981));
    assert_eq!(v.get_incident_edge().unwrap().0, 611);
    let v = output.vertices()[190];
    assert!(almost_equal(v.x(), -49691.1517617, v.y(), -49822.5886611));
    assert_eq!(v.get_incident_edge().unwrap().0, 613);
    let v = output.vertices()[191];
    assert!(almost_equal(v.x(), -49578.8399825, v.y(), -49642.6266744));
    assert_eq!(v.get_incident_edge().unwrap().0, 615);
    let v = output.vertices()[192];
    assert!(almost_equal(v.x(), -49686.3440818, v.y(), -49816.9294141));
    assert_eq!(v.get_incident_edge().unwrap().0, 617);
    let v = output.vertices()[193];
    assert!(almost_equal(v.x(), -49732.2523943, v.y(), -48872.1416600));
    assert_eq!(v.get_incident_edge().unwrap().0, 619);
    let v = output.vertices()[194];
    assert!(almost_equal(v.x(), -49570.8640200, v.y(), -49566.6994804));
    assert_eq!(v.get_incident_edge().unwrap().0, 621);
    let v = output.vertices()[195];
    assert!(almost_equal(v.x(), -49592.7958419, v.y(), -49673.3377641));
    assert_eq!(v.get_incident_edge().unwrap().0, 623);
    let v = output.vertices()[196];
    assert!(almost_equal(v.x(), -49687.5843654, v.y(), -49823.2083497));
    assert_eq!(v.get_incident_edge().unwrap().0, 625);
    let v = output.vertices()[197];
    assert!(almost_equal(v.x(), -49567.8213473, v.y(), -49735.5078801));
    assert_eq!(v.get_incident_edge().unwrap().0, 631);
    let v = output.vertices()[198];
    assert!(almost_equal(v.x(), -49569.8040201, v.y(), -49743.8341709));
    assert_eq!(v.get_incident_edge().unwrap().0, 633);
    let v = output.vertices()[199];
    assert!(almost_equal(v.x(), -49578.2836257, v.y(), -49208.5584795));
    assert_eq!(v.get_incident_edge().unwrap().0, 635);
    let v = output.vertices()[200];
    assert!(almost_equal(v.x(), -49585.2566845, v.y(), -49343.9786096));
    assert_eq!(v.get_incident_edge().unwrap().0, 637);
    let v = output.vertices()[201];
    assert!(almost_equal(v.x(), -49585.9126567, v.y(), -49677.1124141));
    assert_eq!(v.get_incident_edge().unwrap().0, 639);
    let v = output.vertices()[202];
    assert!(almost_equal(v.x(), -49619.1895915, v.y(), -49941.8329102));
    assert_eq!(v.get_incident_edge().unwrap().0, 645);
    let v = output.vertices()[203];
    assert!(almost_equal(v.x(), -49624.5366018, v.y(), -49932.8877097));
    assert_eq!(v.get_incident_edge().unwrap().0, 647);
    let v = output.vertices()[204];
    assert!(almost_equal(v.x(), -49682.3880112, v.y(), -49828.9214684));
    assert_eq!(v.get_incident_edge().unwrap().0, 649);
    let v = output.vertices()[205];
    assert!(almost_equal(v.x(), -49583.9422646, v.y(), -49139.3532669));
    assert_eq!(v.get_incident_edge().unwrap().0, 651);
    let v = output.vertices()[206];
    assert!(almost_equal(v.x(), -49606.8245750, v.y(), -49961.1298300));
    assert_eq!(v.get_incident_edge().unwrap().0, 653);
    let v = output.vertices()[207];
    assert!(almost_equal(v.x(), -49571.6791045, v.y(), -49759.7723881));
    assert_eq!(v.get_incident_edge().unwrap().0, 655);
    let v = output.vertices()[208];
    assert!(almost_equal(v.x(), -49598.9582689, v.y(), -49975.3833076));
    assert_eq!(v.get_incident_edge().unwrap().0, 661);
    let v = output.vertices()[209];
    assert!(almost_equal(v.x(), -49546.0336227, v.y(), -49732.7021573));
    assert_eq!(v.get_incident_edge().unwrap().0, 665);
    let v = output.vertices()[210];
    assert!(almost_equal(v.x(), -49552.7161017, v.y(), -49099.4449153));
    assert_eq!(v.get_incident_edge().unwrap().0, 669);
    let v = output.vertices()[211];
    assert!(almost_equal(v.x(), -49573.9495824, v.y(), -49320.7542015));
    assert_eq!(v.get_incident_edge().unwrap().0, 671);
    let v = output.vertices()[212];
    assert!(almost_equal(v.x(), -49539.6456453, v.y(), -49573.8241577));
    assert_eq!(v.get_incident_edge().unwrap().0, 677);
    let v = output.vertices()[213];
    assert!(almost_equal(v.x(), -49557.3410063, v.y(), -49078.8509215));
    assert_eq!(v.get_incident_edge().unwrap().0, 679);
    let v = output.vertices()[214];
    assert!(almost_equal(v.x(), -49572.3786438, v.y(), -49325.2630350));
    assert_eq!(v.get_incident_edge().unwrap().0, 681);
    let v = output.vertices()[215];
    assert!(almost_equal(v.x(), -49556.6220430, v.y(), -49079.2919355));
    assert_eq!(v.get_incident_edge().unwrap().0, 683);
    let v = output.vertices()[216];
    assert!(almost_equal(v.x(), -49580.7687419, v.y(), -49489.2625633));
    assert_eq!(v.get_incident_edge().unwrap().0, 687);
    let v = output.vertices()[217];
    assert!(almost_equal(v.x(), -49561.2378753, v.y(), -49509.6911085));
    assert_eq!(v.get_incident_edge().unwrap().0, 689);
    let v = output.vertices()[218];
    assert!(almost_equal(v.x(), -49550.8745098, v.y(), -49082.8705882));
    assert_eq!(v.get_incident_edge().unwrap().0, 691);
    let v = output.vertices()[219];
    assert!(almost_equal(v.x(), -49569.0076908, v.y(), -49333.7567093));
    assert_eq!(v.get_incident_edge().unwrap().0, 693);
    let v = output.vertices()[220];
    assert!(almost_equal(v.x(), -49538.5205184, v.y(), -49660.5464363));
    assert_eq!(v.get_incident_edge().unwrap().0, 699);
    let v = output.vertices()[221];
    assert!(almost_equal(v.x(), -49548.1787015, v.y(), -49682.4044296));
    assert_eq!(v.get_incident_edge().unwrap().0, 701);
    let v = output.vertices()[222];
    assert!(almost_equal(v.x(), -49549.7520822, v.y(), -49685.7919723));
    assert_eq!(v.get_incident_edge().unwrap().0, 703);
    let v = output.vertices()[223];
    assert!(almost_equal(v.x(), -49638.9110672, v.y(), -49849.5158103));
    assert_eq!(v.get_incident_edge().unwrap().0, 705);
    let v = output.vertices()[224];
    assert!(almost_equal(v.x(), -49526.2164002, v.y(), -49743.2727761));
    assert_eq!(v.get_incident_edge().unwrap().0, 707);
    let v = output.vertices()[225];
    assert!(almost_equal(v.x(), -49537.3352601, v.y(), -49080.0693642));
    assert_eq!(v.get_incident_edge().unwrap().0, 713);
    let v = output.vertices()[226];
    assert!(almost_equal(v.x(), -49530.8312160, v.y(), -49070.9637024));
    assert_eq!(v.get_incident_edge().unwrap().0, 715);
    let v = output.vertices()[227];
    assert!(almost_equal(v.x(), -49570.1500937, v.y(), -49457.4452371));
    assert_eq!(v.get_incident_edge().unwrap().0, 721);
    let v = output.vertices()[228];
    assert!(almost_equal(v.x(), -49571.7745505, v.y(), -49483.2334899));
    assert_eq!(v.get_incident_edge().unwrap().0, 723);
    let v = output.vertices()[229];
    assert!(almost_equal(v.x(), -49569.9304852, v.y(), -49484.6998552));
    assert_eq!(v.get_incident_edge().unwrap().0, 725);
    let v = output.vertices()[230];
    assert!(almost_equal(v.x(), -49519.1528463, v.y(), -49711.9282554));
    assert_eq!(v.get_incident_edge().unwrap().0, 727);
    let v = output.vertices()[231];
    assert!(almost_equal(v.x(), -49556.3945634, v.y(), -49434.6696870));
    assert_eq!(v.get_incident_edge().unwrap().0, 729);
    let v = output.vertices()[232];
    assert!(almost_equal(v.x(), -49529.0409575, v.y(), -49022.0081425));
    assert_eq!(v.get_incident_edge().unwrap().0, 731);
    let v = output.vertices()[233];
    assert!(almost_equal(v.x(), -49600.4717298, v.y(), -49842.5096256));
    assert_eq!(v.get_incident_edge().unwrap().0, 735);
    let v = output.vertices()[234];
    assert!(almost_equal(v.x(), -49540.9974359, v.y(), -48997.4123303));
    assert_eq!(v.get_incident_edge().unwrap().0, 737);
    let v = output.vertices()[235];
    assert!(almost_equal(v.x(), -49510.3235410, v.y(), -49747.5424077));
    assert_eq!(v.get_incident_edge().unwrap().0, 739);
    let v = output.vertices()[236];
    assert!(almost_equal(v.x(), -49495.6346161, v.y(), -49769.2202236));
    assert_eq!(v.get_incident_edge().unwrap().0, 743);
    let v = output.vertices()[237];
    assert!(almost_equal(v.x(), -49514.6379310, v.y(), -49327.0517241));
    assert_eq!(v.get_incident_edge().unwrap().0, 753);
    let v = output.vertices()[238];
    assert!(almost_equal(v.x(), -49536.8797364, v.y(), -49410.1779242));
    assert_eq!(v.get_incident_edge().unwrap().0, 755);
    let v = output.vertices()[239];
    assert!(almost_equal(v.x(), -49481.0553435, v.y(), -49006.3549618));
    assert_eq!(v.get_incident_edge().unwrap().0, 757);
    let v = output.vertices()[240];
    assert!(almost_equal(v.x(), -49523.7949625, v.y(), -49224.6191774));
    assert_eq!(v.get_incident_edge().unwrap().0, 763);
    let v = output.vertices()[241];
    assert!(almost_equal(v.x(), -49501.5556793, v.y(), -49505.1102450));
    assert_eq!(v.get_incident_edge().unwrap().0, 769);
    let v = output.vertices()[242];
    assert!(almost_equal(v.x(), -49500.9527772, v.y(), -49505.2926493));
    assert_eq!(v.get_incident_edge().unwrap().0, 771);
    let v = output.vertices()[243];
    assert!(almost_equal(v.x(), -49477.7098574, v.y(), -49011.3728256));
    assert_eq!(v.get_incident_edge().unwrap().0, 773);
    let v = output.vertices()[244];
    assert!(almost_equal(v.x(), -49505.2144112, v.y(), -49262.2319859));
    assert_eq!(v.get_incident_edge().unwrap().0, 775);
    let v = output.vertices()[245];
    assert!(almost_equal(v.x(), -49527.5503762, v.y(), -49360.2701082));
    assert_eq!(v.get_incident_edge().unwrap().0, 777);
    let v = output.vertices()[246];
    assert!(almost_equal(v.x(), -49513.6102917, v.y(), -49206.1714717));
    assert_eq!(v.get_incident_edge().unwrap().0, 779);
    let v = output.vertices()[247];
    assert!(almost_equal(v.x(), -49500.0476190, v.y(), -49268.6904762));
    assert_eq!(v.get_incident_edge().unwrap().0, 783);
    let v = output.vertices()[248];
    assert!(almost_equal(v.x(), -49494.2697900, v.y(), -49557.2384491));
    assert_eq!(v.get_incident_edge().unwrap().0, 785);
    let v = output.vertices()[249];
    assert!(almost_equal(v.x(), -49485.0000000, v.y(), -49657.2688172));
    assert_eq!(v.get_incident_edge().unwrap().0, 793);
    let v = output.vertices()[250];
    assert!(almost_equal(v.x(), -49477.5344729, v.y(), -49687.5678942));
    assert_eq!(v.get_incident_edge().unwrap().0, 799);
    let v = output.vertices()[251];
    assert!(almost_equal(v.x(), -49504.3014224, v.y(), -49191.9593463));
    assert_eq!(v.get_incident_edge().unwrap().0, 801);
    let v = output.vertices()[252];
    assert!(almost_equal(v.x(), -49518.9084768, v.y(), -49392.6151023));
    assert_eq!(v.get_incident_edge().unwrap().0, 803);
    let v = output.vertices()[253];
    assert!(almost_equal(v.x(), -49517.5259750, v.y(), -49393.3181753));
    assert_eq!(v.get_incident_edge().unwrap().0, 805);
    let v = output.vertices()[254];
    assert!(almost_equal(v.x(), -49486.8914123, v.y(), -49557.4024131));
    assert_eq!(v.get_incident_edge().unwrap().0, 807);
    let v = output.vertices()[255];
    assert!(almost_equal(v.x(), -49508.7105276, v.y(), -49397.8482589));
    assert_eq!(v.get_incident_edge().unwrap().0, 809);
    let v = output.vertices()[256];
    assert!(almost_equal(v.x(), -49561.1189835, v.y(), -48907.8150972));
    assert_eq!(v.get_incident_edge().unwrap().0, 811);
    let v = output.vertices()[257];
    assert!(almost_equal(v.x(), -49453.1250000, v.y(), -49444.1250000));
    assert_eq!(v.get_incident_edge().unwrap().0, 815);
    let v = output.vertices()[258];
    assert!(almost_equal(v.x(), -49506.1293265, v.y(), -49880.8587336));
    assert_eq!(v.get_incident_edge().unwrap().0, 817);
    let v = output.vertices()[259];
    assert!(almost_equal(v.x(), -49473.2404306, v.y(), -49400.8050239));
    assert_eq!(v.get_incident_edge().unwrap().0, 819);
    let v = output.vertices()[260];
    assert!(almost_equal(v.x(), -49439.6143136, v.y(), -49368.4776272));
    assert_eq!(v.get_incident_edge().unwrap().0, 825);
    let v = output.vertices()[261];
    assert!(almost_equal(v.x(), -49465.0539172, v.y(), -49402.3726542));
    assert_eq!(v.get_incident_edge().unwrap().0, 827);
    let v = output.vertices()[262];
    assert!(almost_equal(v.x(), -49458.0761370, v.y(), -49488.9603816));
    assert_eq!(v.get_incident_edge().unwrap().0, 829);
    let v = output.vertices()[263];
    assert!(almost_equal(v.x(), -49485.0000000, v.y(), -49622.7531153));
    assert_eq!(v.get_incident_edge().unwrap().0, 831);
    let v = output.vertices()[264];
    assert!(almost_equal(v.x(), -49563.9421941, v.y(), -48887.2645570));
    assert_eq!(v.get_incident_edge().unwrap().0, 833);
    let v = output.vertices()[265];
    assert!(almost_equal(v.x(), -49431.4822064, v.y(), -49379.0907473));
    assert_eq!(v.get_incident_edge().unwrap().0, 835);
    let v = output.vertices()[266];
    assert!(almost_equal(v.x(), -49475.1059306, v.y(), -49569.5680716));
    assert_eq!(v.get_incident_edge().unwrap().0, 841);
    let v = output.vertices()[267];
    assert!(almost_equal(v.x(), -49438.3365166, v.y(), -49445.6548431));
    assert_eq!(v.get_incident_edge().unwrap().0, 843);
    let v = output.vertices()[268];
    assert!(almost_equal(v.x(), -49446.6658827, v.y(), -49489.3388209));
    assert_eq!(v.get_incident_edge().unwrap().0, 845);
    let v = output.vertices()[269];
    assert!(almost_equal(v.x(), -49443.8020833, v.y(), -49854.0104167));
    assert_eq!(v.get_incident_edge().unwrap().0, 847);
    let v = output.vertices()[270];
    assert!(almost_equal(v.x(), -49458.2788991, v.y(), -49086.9678899));
    assert_eq!(v.get_incident_edge().unwrap().0, 853);
    let v = output.vertices()[271];
    assert!(almost_equal(v.x(), -49444.1211730, v.y(), -49748.7256280));
    assert_eq!(v.get_incident_edge().unwrap().0, 855);
    let v = output.vertices()[272];
    assert!(almost_equal(v.x(), -49467.7718961, v.y(), -49605.7680462));
    assert_eq!(v.get_incident_edge().unwrap().0, 859);
    let v = output.vertices()[273];
    assert!(almost_equal(v.x(), -49441.8844055, v.y(), -49289.2198909));
    assert_eq!(v.get_incident_edge().unwrap().0, 861);
    let v = output.vertices()[274];
    assert!(almost_equal(v.x(), -49433.9295775, v.y(), -49804.6478873));
    assert_eq!(v.get_incident_edge().unwrap().0, 865);
    let v = output.vertices()[275];
    assert!(almost_equal(v.x(), -49442.1470235, v.y(), -49284.4122069));
    assert_eq!(v.get_incident_edge().unwrap().0, 867);
    let v = output.vertices()[276];
    assert!(almost_equal(v.x(), -49466.3662028, v.y(), -49129.5326465));
    assert_eq!(v.get_incident_edge().unwrap().0, 869);
    let v = output.vertices()[277];
    assert!(almost_equal(v.x(), -49449.9256928, v.y(), -49061.5932623));
    assert_eq!(v.get_incident_edge().unwrap().0, 871);
    let v = output.vertices()[278];
    assert!(almost_equal(v.x(), -49442.7592593, v.y(), -49276.7592593));
    assert_eq!(v.get_incident_edge().unwrap().0, 875);
    let v = output.vertices()[279];
    assert!(almost_equal(v.x(), -49417.1044259, v.y(), -49385.0814892));
    assert_eq!(v.get_incident_edge().unwrap().0, 877);
    let v = output.vertices()[280];
    assert!(almost_equal(v.x(), -49465.4188634, v.y(), -49137.8557001));
    assert_eq!(v.get_incident_edge().unwrap().0, 881);
    let v = output.vertices()[281];
    assert!(almost_equal(v.x(), -49473.9815634, v.y(), -49907.9926254));
    assert_eq!(v.get_incident_edge().unwrap().0, 883);
    let v = output.vertices()[282];
    assert!(almost_equal(v.x(), -49438.9917355, v.y(), -49272.9917355));
    assert_eq!(v.get_incident_edge().unwrap().0, 889);
    let v = output.vertices()[283];
    assert!(almost_equal(v.x(), -49465.0756324, v.y(), -49140.6605059));
    assert_eq!(v.get_incident_edge().unwrap().0, 891);
    let v = output.vertices()[284];
    assert!(almost_equal(v.x(), -49465.0678773, v.y(), -49140.7197695));
    assert_eq!(v.get_incident_edge().unwrap().0, 893);
    let v = output.vertices()[285];
    assert!(almost_equal(v.x(), -49412.6155655, v.y(), -49380.6074996));
    assert_eq!(v.get_incident_edge().unwrap().0, 895);
    let v = output.vertices()[286];
    assert!(almost_equal(v.x(), -49434.3674317, v.y(), -49779.1890252));
    assert_eq!(v.get_incident_edge().unwrap().0, 901);
    let v = output.vertices()[287];
    assert!(almost_equal(v.x(), -49438.0853320, v.y(), -49143.6682656));
    assert_eq!(v.get_incident_edge().unwrap().0, 903);
    let v = output.vertices()[288];
    assert!(almost_equal(v.x(), -49433.9506258, v.y(), -49782.1414006));
    assert_eq!(v.get_incident_edge().unwrap().0, 905);
    let v = output.vertices()[289];
    assert!(almost_equal(v.x(), -49468.1685680, v.y(), -49912.7032507));
    assert_eq!(v.get_incident_edge().unwrap().0, 909);
    let v = output.vertices()[290];
    assert!(almost_equal(v.x(), -49432.2828392, v.y(), -49144.1861069));
    assert_eq!(v.get_incident_edge().unwrap().0, 911);
    let v = output.vertices()[291];
    assert!(almost_equal(v.x(), -49424.7018424, v.y(), -49256.7934672));
    assert_eq!(v.get_incident_edge().unwrap().0, 913);
    let v = output.vertices()[292];
    assert!(almost_equal(v.x(), -49455.0515717, v.y(), -49595.2842624));
    assert_eq!(v.get_incident_edge().unwrap().0, 915);
    let v = output.vertices()[293];
    assert!(almost_equal(v.x(), -49425.7925544, v.y(), -49262.0527467));
    assert_eq!(v.get_incident_edge().unwrap().0, 917);
    let v = output.vertices()[294];
    assert!(almost_equal(v.x(), -49429.2690397, v.y(), -49786.9027756));
    assert_eq!(v.get_incident_edge().unwrap().0, 919);
    let v = output.vertices()[295];
    assert!(almost_equal(v.x(), -49463.1989217, v.y(), -49921.0795687));
    assert_eq!(v.get_incident_edge().unwrap().0, 921);
    let v = output.vertices()[296];
    assert!(almost_equal(v.x(), -49405.1445498, v.y(), -49059.0047393));
    assert_eq!(v.get_incident_edge().unwrap().0, 923);
    let v = output.vertices()[297];
    assert!(almost_equal(v.x(), -49388.8214286, v.y(), -49771.6785714));
    assert_eq!(v.get_incident_edge().unwrap().0, 929);
    let v = output.vertices()[298];
    assert!(almost_equal(v.x(), -49399.3968254, v.y(), -49786.3809524));
    assert_eq!(v.get_incident_edge().unwrap().0, 941);
    let v = output.vertices()[299];
    assert!(almost_equal(v.x(), -49385.8902743, v.y(), -49287.4423940));
    assert_eq!(v.get_incident_edge().unwrap().0, 943);
    let v = output.vertices()[300];
    assert!(almost_equal(v.x(), -49453.6570116, v.y(), -49939.5427487));
    assert_eq!(v.get_incident_edge().unwrap().0, 945);
    let v = output.vertices()[301];
    assert!(almost_equal(v.x(), -49406.1998770, v.y(), -49794.2306273));
    assert_eq!(v.get_incident_edge().unwrap().0, 947);
    let v = output.vertices()[302];
    assert!(almost_equal(v.x(), -49373.3287009, v.y(), -49872.3582015));
    assert_eq!(v.get_incident_edge().unwrap().0, 953);
    let v = output.vertices()[303];
    assert!(almost_equal(v.x(), -49376.0983607, v.y(), -49528.4426230));
    assert_eq!(v.get_incident_edge().unwrap().0, 955);
    let v = output.vertices()[304];
    assert!(almost_equal(v.x(), -49372.8373412, v.y(), -49872.7786732));
    assert_eq!(v.get_incident_edge().unwrap().0, 957);
    let v = output.vertices()[305];
    assert!(almost_equal(v.x(), -49382.6557377, v.y(), -49557.9508197));
    assert_eq!(v.get_incident_edge().unwrap().0, 961);
    let v = output.vertices()[306];
    assert!(almost_equal(v.x(), -49381.7901235, v.y(), -49206.8344765));
    assert_eq!(v.get_incident_edge().unwrap().0, 967);
    let v = output.vertices()[307];
    assert!(almost_equal(v.x(), -49358.1354680, v.y(), -49275.9741379));
    assert_eq!(v.get_incident_edge().unwrap().0, 969);
    let v = output.vertices()[308];
    assert!(almost_equal(v.x(), -49385.6225130, v.y(), -49349.8315290));
    assert_eq!(v.get_incident_edge().unwrap().0, 971);
    let v = output.vertices()[309];
    assert!(almost_equal(v.x(), -49390.1763980, v.y(), -49809.7109375));
    assert_eq!(v.get_incident_edge().unwrap().0, 973);
    let v = output.vertices()[310];
    assert!(almost_equal(v.x(), -49357.4891038, v.y(), -49272.5317795));
    assert_eq!(v.get_incident_edge().unwrap().0, 975);
    let v = output.vertices()[311];
    assert!(almost_equal(v.x(), -49371.7176860, v.y(), -49414.9511846));
    assert_eq!(v.get_incident_edge().unwrap().0, 985);
    let v = output.vertices()[312];
    assert!(almost_equal(v.x(), -49350.6209285, v.y(), -49532.3104643));
    assert_eq!(v.get_incident_edge().unwrap().0, 995);
    let v = output.vertices()[313];
    assert!(almost_equal(v.x(), -49350.9705882, v.y(), -49524.8529412));
    assert_eq!(v.get_incident_edge().unwrap().0, 997);
    let v = output.vertices()[314];
    assert!(almost_equal(v.x(), -49380.9844912, v.y(), -49147.6996924));
    assert_eq!(v.get_incident_edge().unwrap().0, 999);
    let v = output.vertices()[315];
    assert!(almost_equal(v.x(), -49356.8329076, v.y(), -49396.4706896));
    assert_eq!(v.get_incident_edge().unwrap().0, 1001);
    let v = output.vertices()[316];
    assert!(almost_equal(v.x(), -49383.4487179, v.y(), -49486.7905983));
    assert_eq!(v.get_incident_edge().unwrap().0, 1003);
    let v = output.vertices()[317];
    assert!(almost_equal(v.x(), -49407.5766129, v.y(), -49600.9959677));
    assert_eq!(v.get_incident_edge().unwrap().0, 1005);
    let v = output.vertices()[318];
    assert!(almost_equal(v.x(), -49379.7006568, v.y(), -49818.3289077));
    assert_eq!(v.get_incident_edge().unwrap().0, 1007);
    let v = output.vertices()[319];
    assert!(almost_equal(v.x(), -49378.6086773, v.y(), -48984.7042965));
    assert_eq!(v.get_incident_edge().unwrap().0, 1009);
    let v = output.vertices()[320];
    assert!(almost_equal(v.x(), -49410.6484456, v.y(), -49606.3832098));
    assert_eq!(v.get_incident_edge().unwrap().0, 1011);
    let v = output.vertices()[321];
    assert!(almost_equal(v.x(), -49375.5104044, v.y(), -48986.8457499));
    assert_eq!(v.get_incident_edge().unwrap().0, 1013);
    let v = output.vertices()[322];
    assert!(almost_equal(v.x(), -49344.3221300, v.y(), -49552.4745900));
    assert_eq!(v.get_incident_edge().unwrap().0, 1015);
    let v = output.vertices()[323];
    assert!(almost_equal(v.x(), -49368.6867470, v.y(), -49312.9036145));
    assert_eq!(v.get_incident_edge().unwrap().0, 1017);
    let v = output.vertices()[324];
    assert!(almost_equal(v.x(), -49363.4669876, v.y(), -49104.3230170));
    assert_eq!(v.get_incident_edge().unwrap().0, 1023);
    let v = output.vertices()[325];
    assert!(almost_equal(v.x(), -49348.2368421, v.y(), -49511.1842105));
    assert_eq!(v.get_incident_edge().unwrap().0, 1025);
    let v = output.vertices()[326];
    assert!(almost_equal(v.x(), -49365.6628702, v.y(), -49729.9931663));
    assert_eq!(v.get_incident_edge().unwrap().0, 1027);
    let v = output.vertices()[327];
    assert!(almost_equal(v.x(), -49390.2497958, v.y(), -49466.2506126));
    assert_eq!(v.get_incident_edge().unwrap().0, 1029);
    let v = output.vertices()[328];
    assert!(almost_equal(v.x(), -49389.3511864, v.y(), -49468.9464408));
    assert_eq!(v.get_incident_edge().unwrap().0, 1033);
    let v = output.vertices()[329];
    assert!(almost_equal(v.x(), -49366.4069038, v.y(), -49318.4403766));
    assert_eq!(v.get_incident_edge().unwrap().0, 1035);
    let v = output.vertices()[330];
    assert!(almost_equal(v.x(), -49371.9084507, v.y(), -49066.1267606));
    assert_eq!(v.get_incident_edge().unwrap().0, 1037);
    let v = output.vertices()[331];
    assert!(almost_equal(v.x(), -49350.2994924, v.y(), -49361.8020305));
    assert_eq!(v.get_incident_edge().unwrap().0, 1039);
    let v = output.vertices()[332];
    assert!(almost_equal(v.x(), -49385.8128804, v.y(), -49470.7542407));
    assert_eq!(v.get_incident_edge().unwrap().0, 1041);
    let v = output.vertices()[333];
    assert!(almost_equal(v.x(), -49437.8150800, v.y(), -48885.2822241));
    assert_eq!(v.get_incident_edge().unwrap().0, 1043);
    let v = output.vertices()[334];
    assert!(almost_equal(v.x(), -49377.7926829, v.y(), -49471.7764228));
    assert_eq!(v.get_incident_edge().unwrap().0, 1045);
    let v = output.vertices()[335];
    assert!(almost_equal(v.x(), -49352.0026080, v.y(), -49218.6263692));
    assert_eq!(v.get_incident_edge().unwrap().0, 1047);
    let v = output.vertices()[336];
    assert!(almost_equal(v.x(), -49329.1000000, v.y(), -49521.5500000));
    assert_eq!(v.get_incident_edge().unwrap().0, 1049);
    let v = output.vertices()[337];
    assert!(almost_equal(v.x(), -49389.3200600, v.y(), -49624.4020183));
    assert_eq!(v.get_incident_edge().unwrap().0, 1053);
    let v = output.vertices()[338];
    assert!(almost_equal(v.x(), -49360.8102933, v.y(), -49330.3014707));
    assert_eq!(v.get_incident_edge().unwrap().0, 1055);
    let v = output.vertices()[339];
    assert!(almost_equal(v.x(), -49354.8463855, v.y(), -49467.5271084));
    assert_eq!(v.get_incident_edge().unwrap().0, 1057);
    let v = output.vertices()[340];
    assert!(almost_equal(v.x(), -49358.0708661, v.y(), -49330.7165354));
    assert_eq!(v.get_incident_edge().unwrap().0, 1059);
    let v = output.vertices()[341];
    assert!(almost_equal(v.x(), -49357.0936247, v.y(), -49078.8748998));
    assert_eq!(v.get_incident_edge().unwrap().0, 1061);
    let v = output.vertices()[342];
    assert!(almost_equal(v.x(), -49383.7492493, v.y(), -49628.9030102));
    assert_eq!(v.get_incident_edge().unwrap().0, 1063);
    let v = output.vertices()[343];
    assert!(almost_equal(v.x(), -49382.6043018, v.y(), -49630.8021509));
    assert_eq!(v.get_incident_edge().unwrap().0, 1065);
    let v = output.vertices()[344];
    assert!(almost_equal(v.x(), -49351.7896202, v.y(), -49199.0565682));
    assert_eq!(v.get_incident_edge().unwrap().0, 1067);
    let v = output.vertices()[345];
    assert!(almost_equal(v.x(), -49355.7160440, v.y(), -49068.5647231));
    assert_eq!(v.get_incident_edge().unwrap().0, 1069);
    let v = output.vertices()[346];
    assert!(almost_equal(v.x(), -49341.5605787, v.y(), -49818.7884268));
    assert_eq!(v.get_incident_edge().unwrap().0, 1071);
    let v = output.vertices()[347];
    assert!(almost_equal(v.x(), -49317.6181144, v.y(), -49526.0286774));
    assert_eq!(v.get_incident_edge().unwrap().0, 1073);
    let v = output.vertices()[348];
    assert!(almost_equal(v.x(), -49345.8245389, v.y(), -49186.2404092));
    assert_eq!(v.get_incident_edge().unwrap().0, 1075);
    let v = output.vertices()[349];
    assert!(almost_equal(v.x(), -49337.7748180, v.y(), -49050.9304473));
    assert_eq!(v.get_incident_edge().unwrap().0, 1079);
    let v = output.vertices()[350];
    assert!(almost_equal(v.x(), -49314.4282109, v.y(), -49447.6774078));
    assert_eq!(v.get_incident_edge().unwrap().0, 1089);
    let v = output.vertices()[351];
    assert!(almost_equal(v.x(), -49312.4220507, v.y(), -49448.7052085));
    assert_eq!(v.get_incident_edge().unwrap().0, 1091);
    let v = output.vertices()[352];
    assert!(almost_equal(v.x(), -49310.9165099, v.y(), -49436.3441910));
    assert_eq!(v.get_incident_edge().unwrap().0, 1097);
    let v = output.vertices()[353];
    assert!(almost_equal(v.x(), -49278.7876630, v.y(), -49465.6193868));
    assert_eq!(v.get_incident_edge().unwrap().0, 1099);
    let v = output.vertices()[354];
    assert!(almost_equal(v.x(), -49275.0068822, v.y(), -49471.5606138));
    assert_eq!(v.get_incident_edge().unwrap().0, 1101);
    let v = output.vertices()[355];
    assert!(almost_equal(v.x(), -49285.8179233, v.y(), -48998.6474979));
    assert_eq!(v.get_incident_edge().unwrap().0, 1103);
    let v = output.vertices()[356];
    assert!(almost_equal(v.x(), -49317.3813479, v.y(), -49167.4774122));
    assert_eq!(v.get_incident_edge().unwrap().0, 1105);
    let v = output.vertices()[357];
    assert!(almost_equal(v.x(), -49304.2587999, v.y(), -49529.7289933));
    assert_eq!(v.get_incident_edge().unwrap().0, 1109);
    let v = output.vertices()[358];
    assert!(almost_equal(v.x(), -49304.1066968, v.y(), -49530.2830937));
    assert_eq!(v.get_incident_edge().unwrap().0, 1117);
    let v = output.vertices()[359];
    assert!(almost_equal(v.x(), -49275.9166667, v.y(), -49529.5000000));
    assert_eq!(v.get_incident_edge().unwrap().0, 1119);
    let v = output.vertices()[360];
    assert!(almost_equal(v.x(), -49303.6392450, v.y(), -49532.1207701));
    assert_eq!(v.get_incident_edge().unwrap().0, 1121);
    let v = output.vertices()[361];
    assert!(almost_equal(v.x(), -49290.6426844, v.y(), -49580.5087358));
    assert_eq!(v.get_incident_edge().unwrap().0, 1129);
    let v = output.vertices()[362];
    assert!(almost_equal(v.x(), -49289.4811321, v.y(), -49584.2405660));
    assert_eq!(v.get_incident_edge().unwrap().0, 1131);
    let v = output.vertices()[363];
    assert!(almost_equal(v.x(), -49308.7715943, v.y(), -49159.3360344));
    assert_eq!(v.get_incident_edge().unwrap().0, 1133);
    let v = output.vertices()[364];
    assert!(almost_equal(v.x(), -49286.2085708, v.y(), -49054.7882549));
    assert_eq!(v.get_incident_edge().unwrap().0, 1135);
    let v = output.vertices()[365];
    assert!(almost_equal(v.x(), -49255.9555184, v.y(), -49043.9436493));
    assert_eq!(v.get_incident_edge().unwrap().0, 1139);
    let v = output.vertices()[366];
    assert!(almost_equal(v.x(), -49260.8333333, v.y(), -49529.5000000));
    assert_eq!(v.get_incident_edge().unwrap().0, 1145);
    let v = output.vertices()[367];
    assert!(almost_equal(v.x(), -49315.6727298, v.y(), -49816.4277926));
    assert_eq!(v.get_incident_edge().unwrap().0, 1147);
    let v = output.vertices()[368];
    assert!(almost_equal(v.x(), -49308.3553189, v.y(), -49316.7514941));
    assert_eq!(v.get_incident_edge().unwrap().0, 1149);
    let v = output.vertices()[369];
    assert!(almost_equal(v.x(), -49270.1492986, v.y(), -49058.2987224));
    assert_eq!(v.get_incident_edge().unwrap().0, 1151);
    let v = output.vertices()[370];
    assert!(almost_equal(v.x(), -49311.3106061, v.y(), -49807.2920240));
    assert_eq!(v.get_incident_edge().unwrap().0, 1153);
    let v = output.vertices()[371];
    assert!(almost_equal(v.x(), -49267.3566639, v.y(), -49059.4332303));
    assert_eq!(v.get_incident_edge().unwrap().0, 1155);
    let v = output.vertices()[372];
    assert!(almost_equal(v.x(), -49332.6409185, v.y(), -49682.7863605));
    assert_eq!(v.get_incident_edge().unwrap().0, 1157);
    let v = output.vertices()[373];
    assert!(almost_equal(v.x(), -49256.4054531, v.y(), -49089.8448411));
    assert_eq!(v.get_incident_edge().unwrap().0, 1161);
    let v = output.vertices()[374];
    assert!(almost_equal(v.x(), -49257.2903683, v.y(), -49094.4169027));
    assert_eq!(v.get_incident_edge().unwrap().0, 1163);
    let v = output.vertices()[375];
    assert!(almost_equal(v.x(), -49262.6711712, v.y(), -49886.3108108));
    assert_eq!(v.get_incident_edge().unwrap().0, 1167);
    let v = output.vertices()[376];
    assert!(almost_equal(v.x(), -49299.2256410, v.y(), -49759.0615385));
    assert_eq!(v.get_incident_edge().unwrap().0, 1169);
    let v = output.vertices()[377];
    assert!(almost_equal(v.x(), -49298.7743590, v.y(), -49750.9384615));
    assert_eq!(v.get_incident_edge().unwrap().0, 1173);
    let v = output.vertices()[378];
    assert!(almost_equal(v.x(), -49298.5075758, v.y(), -49747.0475207));
    assert_eq!(v.get_incident_edge().unwrap().0, 1175);
    let v = output.vertices()[379];
    assert!(almost_equal(v.x(), -49273.1523989, v.y(), -49388.9463782));
    assert_eq!(v.get_incident_edge().unwrap().0, 1177);
    let v = output.vertices()[380];
    assert!(almost_equal(v.x(), -49257.7443922, v.y(), -49873.4709358));
    assert_eq!(v.get_incident_edge().unwrap().0, 1179);
    let v = output.vertices()[381];
    assert!(almost_equal(v.x(), -49257.6375149, v.y(), -49873.5052421));
    assert_eq!(v.get_incident_edge().unwrap().0, 1189);
    let v = output.vertices()[382];
    assert!(almost_equal(v.x(), -49258.9508346, v.y(), -49239.1596556));
    assert_eq!(v.get_incident_edge().unwrap().0, 1191);
    let v = output.vertices()[383];
    assert!(almost_equal(v.x(), -49246.2285068, v.y(), -49210.5681380));
    assert_eq!(v.get_incident_edge().unwrap().0, 1193);
    let v = output.vertices()[384];
    assert!(almost_equal(v.x(), -49241.2463498, v.y(), -49194.7885989));
    assert_eq!(v.get_incident_edge().unwrap().0, 1201);
    let v = output.vertices()[385];
    assert!(almost_equal(v.x(), -49230.4136126, v.y(), -49839.3455497));
    assert_eq!(v.get_incident_edge().unwrap().0, 1203);
    let v = output.vertices()[386];
    assert!(almost_equal(v.x(), -49256.4064151, v.y(), -49135.2054717));
    assert_eq!(v.get_incident_edge().unwrap().0, 1209);
    let v = output.vertices()[387];
    assert!(almost_equal(v.x(), -49220.0101129, v.y(), -49800.2524860));
    assert_eq!(v.get_incident_edge().unwrap().0, 1211);
    let v = output.vertices()[388];
    assert!(almost_equal(v.x(), -49236.6276715, v.y(), -49443.2260967));
    assert_eq!(v.get_incident_edge().unwrap().0, 1213);
    let v = output.vertices()[389];
    assert!(almost_equal(v.x(), -49205.4442013, v.y(), -49247.3019694));
    assert_eq!(v.get_incident_edge().unwrap().0, 1215);
    let v = output.vertices()[390];
    assert!(almost_equal(v.x(), -49204.8988173, v.y(), -49248.1590013));
    assert_eq!(v.get_incident_edge().unwrap().0, 1217);
    let v = output.vertices()[391];
    assert!(almost_equal(v.x(), -49294.3125000, v.y(), -49695.5625000));
    assert_eq!(v.get_incident_edge().unwrap().0, 1219);
    let v = output.vertices()[392];
    assert!(almost_equal(v.x(), -49230.9359521, v.y(), -49503.2362910));
    assert_eq!(v.get_incident_edge().unwrap().0, 1221);
    let v = output.vertices()[393];
    assert!(almost_equal(v.x(), -49200.8937554, v.y(), -49228.8404674));
    assert_eq!(v.get_incident_edge().unwrap().0, 1223);
    let v = output.vertices()[394];
    assert!(almost_equal(v.x(), -49267.9140545, v.y(), -49307.9570272));
    assert_eq!(v.get_incident_edge().unwrap().0, 1229);
    let v = output.vertices()[395];
    assert!(almost_equal(v.x(), -49268.7368987, v.y(), -49310.6264306));
    assert_eq!(v.get_incident_edge().unwrap().0, 1231);
    let v = output.vertices()[396];
    assert!(almost_equal(v.x(), -49385.7841637, v.y(), -50089.3811388));
    assert_eq!(v.get_incident_edge().unwrap().0, 1237);
    let v = output.vertices()[397];
    assert!(almost_equal(v.x(), -49206.2687078, v.y(), -49787.5916441));
    assert_eq!(v.get_incident_edge().unwrap().0, 1239);
    let v = output.vertices()[398];
    assert!(almost_equal(v.x(), -49386.1546895, v.y(), -50090.7099208));
    assert_eq!(v.get_incident_edge().unwrap().0, 1241);
    let v = output.vertices()[399];
    assert!(almost_equal(v.x(), -49222.4168932, v.y(), -49871.3324273));
    assert_eq!(v.get_incident_edge().unwrap().0, 1243);
    let v = output.vertices()[400];
    assert!(almost_equal(v.x(), -49231.5034483, v.y(), -49143.8257294));
    assert_eq!(v.get_incident_edge().unwrap().0, 1245);
    let v = output.vertices()[401];
    assert!(almost_equal(v.x(), -49217.5697674, v.y(), -49576.0348837));
    assert_eq!(v.get_incident_edge().unwrap().0, 1247);
    let v = output.vertices()[402];
    assert!(almost_equal(v.x(), -49219.8008248, v.y(), -49871.7474527));
    assert_eq!(v.get_incident_edge().unwrap().0, 1251);
    let v = output.vertices()[403];
    assert!(almost_equal(v.x(), -49218.0065319, v.y(), -49525.3137252));
    assert_eq!(v.get_incident_edge().unwrap().0, 1253);
    let v = output.vertices()[404];
    assert!(almost_equal(v.x(), -49196.8767265, v.y(), -49272.4383632));
    assert_eq!(v.get_incident_edge().unwrap().0, 1255);
    let v = output.vertices()[405];
    assert!(almost_equal(v.x(), -49216.3079817, v.y(), -49528.3158002));
    assert_eq!(v.get_incident_edge().unwrap().0, 1257);
    let v = output.vertices()[406];
    assert!(almost_equal(v.x(), -49257.5269687, v.y(), -49674.1116505));
    assert_eq!(v.get_incident_edge().unwrap().0, 1259);
    let v = output.vertices()[407];
    assert!(almost_equal(v.x(), -49258.3411552, v.y(), -49680.1462094));
    assert_eq!(v.get_incident_edge().unwrap().0, 1263);
    let v = output.vertices()[408];
    assert!(almost_equal(v.x(), -49241.4323604, v.y(), -49367.2431939));
    assert_eq!(v.get_incident_edge().unwrap().0, 1271);
    let v = output.vertices()[409];
    assert!(almost_equal(v.x(), -49184.2142454, v.y(), -49272.7857546));
    assert_eq!(v.get_incident_edge().unwrap().0, 1277);
    let v = output.vertices()[410];
    assert!(almost_equal(v.x(), -49251.3515686, v.y(), -49682.1795437));
    assert_eq!(v.get_incident_edge().unwrap().0, 1279);
    let v = output.vertices()[411];
    assert!(almost_equal(v.x(), -49182.3529412, v.y(), -49274.6470588));
    assert_eq!(v.get_incident_edge().unwrap().0, 1281);
    let v = output.vertices()[412];
    assert!(almost_equal(v.x(), -49245.4659752, v.y(), -49683.9839298));
    assert_eq!(v.get_incident_edge().unwrap().0, 1283);
    let v = output.vertices()[413];
    assert!(almost_equal(v.x(), -49166.3600603, v.y(), -49285.7979732));
    assert_eq!(v.get_incident_edge().unwrap().0, 1285);
    let v = output.vertices()[414];
    assert!(almost_equal(v.x(), -49202.9253232, v.y(), -49677.9127885));
    assert_eq!(v.get_incident_edge().unwrap().0, 1287);
    let v = output.vertices()[415];
    assert!(almost_equal(v.x(), -49197.2513251, v.y(), -49875.0313604));
    assert_eq!(v.get_incident_edge().unwrap().0, 1289);
    let v = output.vertices()[416];
    assert!(almost_equal(v.x(), -49203.4544943, v.y(), -49550.5434158));
    assert_eq!(v.get_incident_edge().unwrap().0, 1291);
    let v = output.vertices()[417];
    assert!(almost_equal(v.x(), -49153.9913126, v.y(), -49290.9348447));
    assert_eq!(v.get_incident_edge().unwrap().0, 1293);
    let v = output.vertices()[418];
    assert!(almost_equal(v.x(), -49183.6694215, v.y(), -49431.6203356));
    assert_eq!(v.get_incident_edge().unwrap().0, 1299);
    let v = output.vertices()[419];
    assert!(almost_equal(v.x(), -49159.6931681, v.y(), -49475.3491257));
    assert_eq!(v.get_incident_edge().unwrap().0, 1305);
    let v = output.vertices()[420];
    assert!(almost_equal(v.x(), -49151.0988560, v.y(), -49491.0285697));
    assert_eq!(v.get_incident_edge().unwrap().0, 1307);
    let v = output.vertices()[421];
    assert!(almost_equal(v.x(), -49148.0818182, v.y(), -49261.9881579));
    assert_eq!(v.get_incident_edge().unwrap().0, 1309);
    let v = output.vertices()[422];
    assert!(almost_equal(v.x(), -49186.2365158, v.y(), -49759.2756155));
    assert_eq!(v.get_incident_edge().unwrap().0, 1311);
    let v = output.vertices()[423];
    assert!(almost_equal(v.x(), -49178.3079561, v.y(), -49540.6508916));
    assert_eq!(v.get_incident_edge().unwrap().0, 1315);
    let v = output.vertices()[424];
    assert!(almost_equal(v.x(), -49187.7048579, v.y(), -49546.4922090));
    assert_eq!(v.get_incident_edge().unwrap().0, 1317);
    let v = output.vertices()[425];
    assert!(almost_equal(v.x(), -49195.9845407, v.y(), -49551.8507987));
    assert_eq!(v.get_incident_edge().unwrap().0, 1319);
    let v = output.vertices()[426];
    assert!(almost_equal(v.x(), -49182.0501535, v.y(), -49759.8352098));
    assert_eq!(v.get_incident_edge().unwrap().0, 1321);
    let v = output.vertices()[427];
    assert!(almost_equal(v.x(), -49166.3413706, v.y(), -49456.7589834));
    assert_eq!(v.get_incident_edge().unwrap().0, 1323);
    let v = output.vertices()[428];
    assert!(almost_equal(v.x(), -49167.9657496, v.y(), -49205.9399946));
    assert_eq!(v.get_incident_edge().unwrap().0, 1327);
    let v = output.vertices()[429];
    assert!(almost_equal(v.x(), -49214.9494845, v.y(), -49383.6110825));
    assert_eq!(v.get_incident_edge().unwrap().0, 1329);
    let v = output.vertices()[430];
    assert!(almost_equal(v.x(), -49184.5031201, v.y(), -49061.5686427));
    assert_eq!(v.get_incident_edge().unwrap().0, 1335);
    let v = output.vertices()[431];
    assert!(almost_equal(v.x(), -49140.6537775, v.y(), -49675.2684185));
    assert_eq!(v.get_incident_edge().unwrap().0, 1337);
    let v = output.vertices()[432];
    assert!(almost_equal(v.x(), -49205.3742949, v.y(), -49384.9219715));
    assert_eq!(v.get_incident_edge().unwrap().0, 1341);
    let v = output.vertices()[433];
    assert!(almost_equal(v.x(), -49251.2474532, v.y(), -48861.1707197));
    assert_eq!(v.get_incident_edge().unwrap().0, 1343);
    let v = output.vertices()[434];
    assert!(almost_equal(v.x(), -49196.6423017, v.y(), -49381.8172628));
    assert_eq!(v.get_incident_edge().unwrap().0, 1345);
    let v = output.vertices()[435];
    assert!(almost_equal(v.x(), -49375.5379329, v.y(), -50157.1910390));
    assert_eq!(v.get_incident_edge().unwrap().0, 1351);
    let v = output.vertices()[436];
    assert!(almost_equal(v.x(), -49156.2307692, v.y(), -49762.7692308));
    assert_eq!(v.get_incident_edge().unwrap().0, 1353);
    let v = output.vertices()[437];
    assert!(almost_equal(v.x(), -49154.6972956, v.y(), -49579.9490627));
    assert_eq!(v.get_incident_edge().unwrap().0, 1355);
    let v = output.vertices()[438];
    assert!(almost_equal(v.x(), -49185.9484003, v.y(), -49378.3963997));
    assert_eq!(v.get_incident_edge().unwrap().0, 1357);
    let v = output.vertices()[439];
    assert!(almost_equal(v.x(), -49137.0855549, v.y(), -49736.6621203));
    assert_eq!(v.get_incident_edge().unwrap().0, 1359);
    let v = output.vertices()[440];
    assert!(almost_equal(v.x(), -49124.4827040, v.y(), -49272.7989252));
    assert_eq!(v.get_incident_edge().unwrap().0, 1361);
    let v = output.vertices()[441];
    assert!(almost_equal(v.x(), -49119.9430078, v.y(), -49653.3627968));
    assert_eq!(v.get_incident_edge().unwrap().0, 1363);
    let v = output.vertices()[442];
    assert!(almost_equal(v.x(), -49141.1547619, v.y(), -49777.8452381));
    assert_eq!(v.get_incident_edge().unwrap().0, 1365);
    let v = output.vertices()[443];
    assert!(almost_equal(v.x(), -49122.7716628, v.y(), -49455.6124122));
    assert_eq!(v.get_incident_edge().unwrap().0, 1373);
    let v = output.vertices()[444];
    assert!(almost_equal(v.x(), -49164.8544768, v.y(), -49372.4085758));
    assert_eq!(v.get_incident_edge().unwrap().0, 1375);
    let v = output.vertices()[445];
    assert!(almost_equal(v.x(), -49120.7444627, v.y(), -49634.4895564));
    assert_eq!(v.get_incident_edge().unwrap().0, 1377);
    let v = output.vertices()[446];
    assert!(almost_equal(v.x(), -49170.5720566, v.y(), -49127.1607334));
    assert_eq!(v.get_incident_edge().unwrap().0, 1379);
    let v = output.vertices()[447];
    assert!(almost_equal(v.x(), -50722.7727273, v.y(), -51283.3181818));
    assert_eq!(v.get_incident_edge().unwrap().0, 1381);
    let v = output.vertices()[448];
    assert!(almost_equal(v.x(), -49134.4448310, v.y(), -49359.5301795));
    assert_eq!(v.get_incident_edge().unwrap().0, 1383);
    let v = output.vertices()[449];
    assert!(almost_equal(v.x(), -49138.7633880, v.y(), -49179.5747651));
    assert_eq!(v.get_incident_edge().unwrap().0, 1393);
    let v = output.vertices()[450];
    assert!(almost_equal(v.x(), -49150.3824731, v.y(), -49138.7590048));
    assert_eq!(v.get_incident_edge().unwrap().0, 1395);
    let v = output.vertices()[451];
    assert!(almost_equal(v.x(), -49134.2460131, v.y(), -49183.6750635));
    assert_eq!(v.get_incident_edge().unwrap().0, 1397);
    let v = output.vertices()[452];
    assert!(almost_equal(v.x(), -49122.6048144, v.y(), -49123.5085256));
    assert_eq!(v.get_incident_edge().unwrap().0, 1401);
    let v = output.vertices()[453];
    assert!(almost_equal(v.x(), -49110.3356219, v.y(), -49204.5600588));
    assert_eq!(v.get_incident_edge().unwrap().0, 1403);
    let v = output.vertices()[454];
    assert!(almost_equal(v.x(), -49115.7664839, v.y(), -49595.7884374));
    assert_eq!(v.get_incident_edge().unwrap().0, 1405);
    let v = output.vertices()[455];
    assert!(almost_equal(v.x(), -49115.5584416, v.y(), -49835.5324675));
    assert_eq!(v.get_incident_edge().unwrap().0, 1409);
    let v = output.vertices()[456];
    assert!(almost_equal(v.x(), -49073.6107643, v.y(), -49358.5868436));
    assert_eq!(v.get_incident_edge().unwrap().0, 1411);
    let v = output.vertices()[457];
    assert!(almost_equal(v.x(), -49142.8746611, v.y(), -49896.7885548));
    assert_eq!(v.get_incident_edge().unwrap().0, 1417);
    let v = output.vertices()[458];
    assert!(almost_equal(v.x(), -49167.2971919, v.y(), -48952.0382215));
    assert_eq!(v.get_incident_edge().unwrap().0, 1419);
    let v = output.vertices()[459];
    assert!(almost_equal(v.x(), -49143.2911943, v.y(), -49893.2976099));
    assert_eq!(v.get_incident_edge().unwrap().0, 1421);
    let v = output.vertices()[460];
    assert!(almost_equal(v.x(), -49141.9317956, v.y(), -49891.6526718));
    assert_eq!(v.get_incident_edge().unwrap().0, 1423);
    let v = output.vertices()[461];
    assert!(almost_equal(v.x(), -49065.3848673, v.y(), -49359.2250246));
    assert_eq!(v.get_incident_edge().unwrap().0, 1427);
    let v = output.vertices()[462];
    assert!(almost_equal(v.x(), -49091.6134308, v.y(), -49225.9812109));
    assert_eq!(v.get_incident_edge().unwrap().0, 1429);
    let v = output.vertices()[463];
    assert!(almost_equal(v.x(), -49099.3930636, v.y(), -49925.1965318));
    assert_eq!(v.get_incident_edge().unwrap().0, 1435);
    let v = output.vertices()[464];
    assert!(almost_equal(v.x(), -49076.3157795, v.y(), -49427.8320750));
    assert_eq!(v.get_incident_edge().unwrap().0, 1437);
    let v = output.vertices()[465];
    assert!(almost_equal(v.x(), -49089.9151332, v.y(), -49932.1133521));
    assert_eq!(v.get_incident_edge().unwrap().0, 1439);
    let v = output.vertices()[466];
    assert!(almost_equal(v.x(), -49112.8918460, v.y(), -49856.8652322));
    assert_eq!(v.get_incident_edge().unwrap().0, 1441);
    let v = output.vertices()[467];
    assert!(almost_equal(v.x(), -49083.5294735, v.y(), -49463.1864562));
    assert_eq!(v.get_incident_edge().unwrap().0, 1445);
    let v = output.vertices()[468];
    assert!(almost_equal(v.x(), -49055.1077826, v.y(), -49960.5538913));
    assert_eq!(v.get_incident_edge().unwrap().0, 1447);
    let v = output.vertices()[469];
    assert!(almost_equal(v.x(), -49047.0714286, v.y(), -49391.0238095));
    assert_eq!(v.get_incident_edge().unwrap().0, 1449);
    let v = output.vertices()[470];
    assert!(almost_equal(v.x(), -49080.1577321, v.y(), -49474.1255036));
    assert_eq!(v.get_incident_edge().unwrap().0, 1453);
    let v = output.vertices()[471];
    assert!(almost_equal(v.x(), -49060.7168875, v.y(), -49748.1288997));
    assert_eq!(v.get_incident_edge().unwrap().0, 1459);
    let v = output.vertices()[472];
    assert!(almost_equal(v.x(), -49073.2831125, v.y(), -49713.1304096));
    assert_eq!(v.get_incident_edge().unwrap().0, 1461);
    let v = output.vertices()[473];
    assert!(almost_equal(v.x(), -49074.6592497, v.y(), -49709.4823869));
    assert_eq!(v.get_incident_edge().unwrap().0, 1463);
    let v = output.vertices()[474];
    assert!(almost_equal(v.x(), -49064.2541071, v.y(), -49684.8963352));
    assert_eq!(v.get_incident_edge().unwrap().0, 1465);
    let v = output.vertices()[475];
    assert!(almost_equal(v.x(), -49058.2715185, v.y(), -49664.8719384));
    assert_eq!(v.get_incident_edge().unwrap().0, 1469);
    let v = output.vertices()[476];
    assert!(almost_equal(v.x(), -49047.8152174, v.y(), -49770.9400910));
    assert_eq!(v.get_incident_edge().unwrap().0, 1471);
    let v = output.vertices()[477];
    assert!(almost_equal(v.x(), -49066.2352056, v.y(), -49108.5310933));
    assert_eq!(v.get_incident_edge().unwrap().0, 1473);
    let v = output.vertices()[478];
    assert!(almost_equal(v.x(), -49064.8983647, v.y(), -49267.8752918));
    assert_eq!(v.get_incident_edge().unwrap().0, 1475);
    let v = output.vertices()[479];
    assert!(almost_equal(v.x(), -49066.0762199, v.y(), -49529.5161152));
    assert_eq!(v.get_incident_edge().unwrap().0, 1479);
    let v = output.vertices()[480];
    assert!(almost_equal(v.x(), -49063.3602575, v.y(), -49538.8824655));
    assert_eq!(v.get_incident_edge().unwrap().0, 1481);
    let v = output.vertices()[481];
    assert!(almost_equal(v.x(), -49016.9443561, v.y(), -49971.7933227));
    assert_eq!(v.get_incident_edge().unwrap().0, 1483);
    let v = output.vertices()[482];
    assert!(almost_equal(v.x(), -49283.7719803, v.y(), -50228.1581758));
    assert_eq!(v.get_incident_edge().unwrap().0, 1485);
    let v = output.vertices()[483];
    assert!(almost_equal(v.x(), -49051.4930758, v.y(), -49575.3119534));
    assert_eq!(v.get_incident_edge().unwrap().0, 1487);
    let v = output.vertices()[484];
    assert!(almost_equal(v.x(), -49135.4464931, v.y(), -48879.5166305));
    assert_eq!(v.get_incident_edge().unwrap().0, 1489);
    let v = output.vertices()[485];
    assert!(almost_equal(v.x(), -49043.3510204, v.y(), -49580.3224490));
    assert_eq!(v.get_incident_edge().unwrap().0, 1491);
    let v = output.vertices()[486];
    assert!(almost_equal(v.x(), -48992.2857143, v.y(), -49372.7619048));
    assert_eq!(v.get_incident_edge().unwrap().0, 1493);
    let v = output.vertices()[487];
    assert!(almost_equal(v.x(), -49005.2897798, v.y(), -49280.9432658));
    assert_eq!(v.get_incident_edge().unwrap().0, 1495);
    let v = output.vertices()[488];
    assert!(almost_equal(v.x(), -48993.1324111, v.y(), -49835.7964427));
    assert_eq!(v.get_incident_edge().unwrap().0, 1497);
    let v = output.vertices()[489];
    assert!(almost_equal(v.x(), -49348.0115796, v.y(), -50361.7788005));
    assert_eq!(v.get_incident_edge().unwrap().0, 1499);
    let v = output.vertices()[490];
    assert!(almost_equal(v.x(), -49345.2436630, v.y(), -50382.9148068));
    assert_eq!(v.get_incident_edge().unwrap().0, 1501);
    let v = output.vertices()[491];
    assert!(almost_equal(v.x(), -48964.8279570, v.y(), -49369.4336918));
    assert_eq!(v.get_incident_edge().unwrap().0, 1503);
    let v = output.vertices()[492];
    assert!(almost_equal(v.x(), -48942.1860465, v.y(), -49846.5930233));
    assert_eq!(v.get_incident_edge().unwrap().0, 1505);
    let v = output.vertices()[493];
    assert!(almost_equal(v.x(), -49647.9450729, v.y(), -48160.8867222));
    assert_eq!(v.get_incident_edge().unwrap().0, 1507);
    let v = output.vertices()[494];
    assert!(almost_equal(v.x(), -48925.1452859, v.y(), -49109.8748068));
    assert_eq!(v.get_incident_edge().unwrap().0, 1509);
    let v = output.vertices()[495];
    assert!(almost_equal(v.x(), -49085.5831526, v.y(), -48740.9201012));
    assert_eq!(v.get_incident_edge().unwrap().0, 1511);
    let v = output.vertices()[496];
    assert!(almost_equal(v.x(), -49351.8115068, v.y(), -50503.5989366));
    assert_eq!(v.get_incident_edge().unwrap().0, 1513);
    let v = output.vertices()[497];
    assert!(almost_equal(v.x(), -48849.1162791, v.y(), -49857.5581395));
    assert_eq!(v.get_incident_edge().unwrap().0, 1515);
    let v = output.vertices()[498];
    assert!(almost_equal(v.x(), -49335.1505931, v.y(), -50842.9879174));
    assert_eq!(v.get_incident_edge().unwrap().0, 1517);
    let v = output.vertices()[499];
    assert!(almost_equal(v.x(), -48728.4876352, v.y(), -49097.8191654));
    assert_eq!(v.get_incident_edge().unwrap().0, 1519);
    let v = output.vertices()[500];
    assert!(almost_equal(v.x(), -48657.2384420, v.y(), -49291.2558980));
    assert_eq!(v.get_incident_edge().unwrap().0, 1521);
    let v = output.vertices()[501];
    assert!(almost_equal(v.x(), -49327.2666960, v.y(), -51124.4191564));
    assert_eq!(v.get_incident_edge().unwrap().0, 1523);
    let v = output.vertices()[502];
    assert!(almost_equal(v.x(), -48591.6565585, v.y(), -49281.0105783));
    assert_eq!(v.get_incident_edge().unwrap().0, 1525);
    let v = output.vertices()[503];
    assert!(almost_equal(v.x(), -48937.0184236, v.y(), -48249.6980135));
    assert_eq!(v.get_incident_edge().unwrap().0, 1527);
    let v = output.vertices()[504];
    assert!(almost_equal(v.x(), -49943.2749250, v.y(), -46668.1285607));
    assert_eq!(v.get_incident_edge().unwrap().0, 1529);
    let v = output.vertices()[505];
    assert!(almost_equal(v.x(), -48281.1973039, v.y(), -49883.5036765));
    assert_eq!(v.get_incident_edge().unwrap().0, 1531);
    let v = output.vertices()[506];
    assert!(almost_equal(v.x(), -46967.2716951, v.y(), -49899.4622871));
    assert_eq!(v.get_incident_edge().unwrap().0, 1533);
    let v = output.vertices()[507];
    assert!(almost_equal(v.x(), -45346.9452555, v.y(), -49933.1605839));
    assert_eq!(v.get_incident_edge().unwrap().0, 1535);
    let v = output.vertices()[508];
    assert!(almost_equal(v.x(), -45259.2173666, v.y(), -48719.7576617));
    assert_eq!(v.get_incident_edge().unwrap().0, 1537);
    let v = output.vertices()[509];
    assert!(almost_equal(v.x(), -42241.8744620, v.y(), -50017.8443329));
    assert_eq!(v.get_incident_edge().unwrap().0, 1539);
    Ok(())
}
