BonsaiDb's networked database implementation.

This crate implements BonsaiDb's networked database implementation. The
[`Server`](crate::Server) and [`CustomServer<Backend>`](crate::CustomServer)
types provide their most common functionality by implementing the
[`StorageConnection`](::bonsaidb_core::connection::StorageConnection).

This crate supports two methods for exposing a BonsaiDb server: QUIC and
WebSockets.

QUIC is a new protocol built atop UDP. It is designed to operate more
reliably than TCP, and features TLS built-in at the protocol level.
WebSockets are an established protocol built atop TCP and HTTP.

Our user's guide has a section covering [setting up and accessing a BonsaiDb
server](https://dev.bonsaidb.io/v0.4.0/guide/integration/server.html).

## Minimum Supported Rust Version (MSRV)

While this project is alpha, we are actively adopting the current version of
Rust. The current minimum version is `1.58`, and we plan on updating the MSRV to
implement [namespaced
Features](https://github.com/khonsulabs/bonsaidb/issues/178) as soon as the
feature is released.
