Bonnie has full support for infinitely nestable subcommands, which can take their own arguments and operate entirely like normal subcommands. This page will handle _unordered subcommands_, as opposed to _ordered subcommands_ (see [Getting Started with Bones](./Getting-Started-with-Bones)).

```toml
version = "0.3.2"
env_vars = [ ".env" ]

[scripts]
test.cmd = "echo Parent"
test.subcommands.first = "echo First"
test.subcommands.second.cmd = "echo \"This is the second command, %name. The message is '%%' and the environment variable says '%GREETING'.\""
test.subcommands.second.args = [ "name" ]
test.subcommands.second.env_vars = [ "GREETING" ]
```

```
# .env
GREETING=Hello
```

```
bonnie test					# Parent
bonnie test first				# First
bonnie test second Bonnie foo bar	# This is the second command, Bonnie. The message is 'foo bar' and the environment variable says 'Hello'.
```

The above example, while quite complex, shows the power of subcommands. Each subcommand is defined under `.subcommands`, and is a fully-fledged script in its own right that can interpolate arguments and environment variables.

An alias with subcommands can also have a top-level parent command specified under `.cmd`, which can interpolate arguments and environment variables as usual.

Further, subcommands can be infinitely nested, allowing for extremely complex build systems that allow building individual components atomically for example!

Note that _ordered subcommands_ are quite different from all that's been described above, and are much more complex. You should read [this page](./Getting-Started-with-Bones) to learn more about them. Another thing to note about _unordered subcommands_ (what's been described above) is that they can become very complex to process if they nest deeply enough. In cases where you have more than 2 or three levels of nesting, or if running Bonnie commands becomes sluggish, you should try caching your configuration, which you can read more about [here](./Caching).
