Bonnie configurations can get *extremely* complex, especially when nested ordered subcommands get involved! Parsing this into a format that Bonnie can understand is usually extremely quick, though it can be slow on very complex files. To circumvent these problems, Bonnie supports *caching*, whereby your configuration is parsed into the form Bonnie uses internally and then written to a file as JSON. That way, when you run a command, Bonnie can use a pre-parsed configuration!

Caching is done with `bonnie -c`, which will parse your configuration and write it to `.bonnie.cache.json`. On any future runs of any command in that folder, Bonnie will use that cache!

Please note, the Bonnie cache **does not update automatically**! You must manually run `bonnie -c` whenever you change something in the configuration! This is because otherwise we'd have to check the file for changes, which takes more time often than parsing, so it's a trade-off between convenience and efficiency. In this case, we chose the latter.

If you want to use a different cache file, you can set the `BONNIE_CACHE` environment variable to an absolute or relative path, which will be used instead.

Committing Bonnie caches to version control is a personal choice, as they retain the atomicity and portability of the configurations from which they're derived, so either way is fine. Community convention hasn't really been set on this yet. Personally, I exclude them by adding the following to my `.gitignore`:

```
.bonnie.cache.json
```

Also, Bonnie caches store the list of environment variable files and the version of the original configuration file as well, so they're resilient to differences in program versions, and will still load the necessary environment variable files.
