Any Bonnie alias can accept arguments from the user, which can be inserted by name into the command itself. This allows you to build powerful aliases that easily adapt to their circumstances.

There are two main types of argument interpolation (fancy word for insertion) in Bonnie: _specific_ and _generic_.

## Specific Argument Interpolation

```toml
version = "0.3.2"

[scripts]
test.cmd = "echo \"Greetings, %name!\""
test.args = [ "name" ]
```

```
bonnie test Bonnie	# Greetings, Bonnie!
```

Specific argument interpolation allows you to define an array of arguments that can be inserted into their command by name. With this syntax, you'll need to define the aliased command under the `.cmd` property, rather than directly. This syntax expands as necessary, allowing you to use the most powerful features of Bonnie. Then, an array of arguments is defined under `.args`, though we just use one here `name`. The user can execute this by running `bonnie test <name>`, where `<name>` is required. If the required number of arguments is not given, Bonnie will throw an error and not execute your command. If you give too many, no problem.

You can insert arguments by typing `%argument-name` anywhere in the command, provided that `argument-name` corresponds to an entry in the `.args` array. Bonnie will do a simple search and replace operation for the '%' sign followed by the name of each argument, inserting the given value for that argument. This means that if you have `%blah` in your command, but `blah` is not listed in `.args`, it will be left alone. Because of that, **there's no need to escape the '%' sign**.

However, some surprising behavior will occur if you have one argument called `arg` and another called `arg1`. Note that the first of those is a _substring_ of the second, meaning the second one contains the first one. If this is the case with any of your arguments, particularly if they contain another argument from the beginning (as is the case with `arg` and `arg1`), this will happen:

```
echo %arg %arg1 -> echo ARGVALUE ARGVALUE1
```

The `%arg` in `%arg1` has been replaced with the value of `arg`, and `%arg1` won't be found! If your arguments have to be like this, make sure you list the _superstring_ (`arg1`) **before** the substring so that it will be inserted first! This is not a bug, this is expected behavior, though it can be a little confusing when it happens!

## Generic Argument Interpolation

```toml
version = "0.3.2"

[scripts]
test = "echo %%"
```

```
bonnie test foo bar foo bar	# foo bar foo bar
```

There are many cases where you may want to insert _all_ given arguments in one place, and this can be done with the `%%` operator. Wherever that is placed, all the arguments given, 0 or 1000, will be interpolated there. Note that this can use simple key-value syntax, you don't need to put things under `.cmd` (but you certainly can).

A real-life use-case of this is with a command like `docker-compose`, which can take a file of environment variables that will be inserted into its configuration. If you're have to write `--env-file .env` before every invocation of `docker-compose`, you're going to get pretty tired of that. With Bonnie, you can define a command like this to do the work for you!

```toml
version = "0.3.2"

[scripts]
dc = "docker-compose --env-file .env %%"
```

Now you can run `bonnie dc ...` instead of `docker-compose --env-file .env ...`!

There may be some instances though where you need to type `%%` but you don't want to insert all arguments there, say if you actually want to print `%%`. You can easily escape it by typing `\\%%` (one backslash to escape `%%`, another to escape the special character `\%`!), which will be evaluated to `%%` when the command is run.

## Working Together

You can easily use both specific and generic argument interpolation in the same command from Bonnie v0.3.0. All arguments after the named ones will be inserted at `%%`.

```toml
version = "0.3.2"

[scripts]
test.cmd = "echo \"Hello there %name! The message says: '%%'. Also, \\%%.\""
test.args = [ "name" ]
```

```
bonnie test Bonnie this is the message	# Hello there Bonnie! The message says: 'this is the message'. Also, %%.
```
