# SecondMarketItem

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **String** | Item unique identifier | [optional] [default to null]
**loan_status_active_from** | **String** | Loan status active from | [optional] [default to null]
**latest_debt_management_stage_type** | **i32** | Latest debt management stage type | [optional] [default to null]
**latest_debt_management_date** | **String** | Latest debt management date | [optional] [default to null]
**price** | **f64** | Outstanding principal balance +/- discount or mark-up | [optional] [default to null]
**fee** | **f64** | Secondary market purchase fee paid to Bondora | [optional] [default to null]
**total_cost** | **f64** | Total amount paid for purchase | [optional] [default to null]
**outstanding_payments** | **f64** | Total amount still to be repaid by the borrower. This includes the principal balance, accrued interest and late charges as well as any future scheduled interest payments | [optional] [default to null]
**desired_discount_rate** | **f64** | Discount rate percent | [optional] [default to null]
**xirr** | **f64** | XIRR (extended internal rate of return) is a methodology to calculate the net return using the loan issued date and amount,   loan repayment dates and amounts and the principal balance according to the original repayment date.   All overdue principal payments are written off immediately. No provisions for future losses are made and only received (not accrued or scheduled)   interest payments are taken into account. | [optional] [default to null]
**listed_on_date** | **String** | Date when item was published | [optional] [default to null]
**debt_managment_events** | [**Vec<crate::models::DebtManagementEvent>**](DebtManagementEvent.md) | Webhook only:  Debt managment event collection | [optional] [default to null]
**loan_transfers** | [**Vec<crate::models::LoanTransfer>**](LoanTransfer.md) | Webhook only:  Collection of all loan payments | [optional] [default to null]
**scheduled_payments** | [**Vec<crate::models::ScheduledPayment>**](ScheduledPayment.md) | Webhook only:  Collection of all loan scheduled payments.   Contains previous period values before rescheduling was made | [optional] [default to null]
**loan_part_id** | **String** | LoanPart unique identifier | [optional] [default to null]
**amount** | **f64** | Investment amount | [optional] [default to null]
**auction_id** | **String** | Auction unique identifier | [optional] [default to null]
**auction_name** | **String** | Auction name | [optional] [default to null]
**auction_number** | **i32** | Auction number | [optional] [default to null]
**auction_bid_number** | **i32** | Auction bid number | [optional] [default to null]
**investment_number** | **String** | Auction number + Auction bid number combined | [optional] [default to null]
**country** | **String** | Residency of the borrower | [optional] [default to null]
**credit_score** | **f64** | &lt;para&gt;    1000 No previous payments problems&lt;/para&gt;  &lt;para&gt;    900 Payments problems finished 24-36 months ago&lt;/para&gt;  &lt;para&gt;    800 Payments problems finished 12-24 months ago&lt;/para&gt;  &lt;para&gt;    700 Payments problems finished 6-12 months ago&lt;/para&gt;  &lt;para&gt;    600 Payment problems finished &amp;lt;6 months ago&lt;/para&gt;  &lt;para&gt;    500 Active payment problems&lt;/para&gt; | [optional] [default to null]
**rating** | **String** | Bondora Rating issued by the Rating model | [optional] [default to null]
**interest** | **f64** | Current interest rate | [optional] [default to null]
**use_of_loan** | **i32** | Use of loan | [optional] [default to null]
**income_verification_status** | **i32** | Income verification type | [optional] [default to null]
**loan_status_code** | **i32** | Loan status code  &lt;para&gt;0 Reserved&lt;/para&gt;&lt;para&gt;2 Current&lt;/para&gt;&lt;para&gt;3 Cancelled&lt;/para&gt;&lt;para&gt;100 Overdue&lt;/para&gt;&lt;para&gt;5 60+ days overdue&lt;/para&gt;&lt;para&gt;4 Repaid&lt;/para&gt;&lt;para&gt;8 Released&lt;/para&gt; | [optional] [default to null]
**user_name** | **String** | Borrower&#39;s username | [optional] [default to null]
**gender** | **i32** | Borrower&#39;s Gender | [optional] [default to null]
**date_of_birth** | **String** | Borrower&#39;s date of birth | [optional] [default to null]
**signed_date** | **String** | Loan issued date | [optional] [default to null]
**re_scheduled_on** | **String** | Last rescheduling date | [optional] [default to null]
**debt_occured_on** | **String** | Date and time when the principal part of the payment is overdue (PrincipalLateAmount is greater than zero). | [optional] [default to null]
**debt_occured_on_for_secondary** | **String** | Date and time when loan part payment is overdue (principal, interest or penalty) aka when the dept occured for the loan part (LateAmountTotal is greater than zero). | [optional] [default to null]
**next_payment_nr** | **i32** | Next scheduled payment number | [optional] [default to null]
**next_payment_date** | **String** | Next scheduled payment date | [optional] [default to null]
**next_payment_sum** | **f64** | Next scheduled payment amount | [optional] [default to null]
**nr_of_scheduled_payments** | **i32** | Total number of scheduled payments | [optional] [default to null]
**last_payment_date** | **String** | Last payment date | [optional] [default to null]
**principal_repaid** | **f64** | Total principal repaid amount | [optional] [default to null]
**interest_repaid** | **f64** | Total interest repaid amount | [optional] [default to null]
**late_amount_paid** | **f64** | Total late charges paid amount | [optional] [default to null]
**principal_remaining** | **f64** | Remaining principal amount | [optional] [default to null]
**principal_late_amount** | **f64** | Principal debt amount | [optional] [default to null]
**interest_late_amount** | **f64** | Interest debt amount | [optional] [default to null]
**penalty_late_amount** | **f64** | Late charges debt amount | [optional] [default to null]
**late_amount_total** | **f64** | Late amount total | [optional] [default to null]
**principal_write_off_amount** | **f64** | Total amount of principal written off | [optional] [default to null]
**interest_write_off_amount** | **f64** | Total amount of interest written off | [optional] [default to null]
**penalty_write_off_amount** | **f64** | Total amount of penalty written off | [optional] [default to null]
**debt_servicing_cost_main_amount** | **f64** | Total amount of principal debt servicing cost | [optional] [default to null]
**debt_servicing_cost_interest_amount** | **f64** | Total amount of interest debt servicing cost | [optional] [default to null]
**debt_servicing_cost_penalty_amount** | **f64** | Total amount of penalty debt servicing cost | [optional] [default to null]

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


