# PublicDatasetItem

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**loan_id** | **String** | A unique ID given to a loan | [optional] [default to null]
**loan_number** | **i32** | A unique loan number displayed in Bondora&#39;s system | [optional] [default to null]
**listed_on_utc** | **String** | Date when the loan application appeared on Primary Market | [optional] [default to null]
**bidding_started_on** | **String** | Date when the auction bidding started on | [optional] [default to null]
**bids_portfolio_manager** | **f64** | The amount of investment offers made by Portfolio Managers | [optional] [default to null]
**bids_api** | **f64** | The amount of investment offers made via Api | [optional] [default to null]
**bids_manual** | **f64** | The amount of investment offers made manually | [optional] [default to null]
**user_name** | **String** | Customer&#39;s Bondora username | [optional] [default to null]
**new_credit_customer** | **bool** | &lt;para&gt;Did the customer have prior credit history in Bondora&lt;/para&gt;  &lt;para&gt;    false Customer had at least 3 months of credit history in Bondora&lt;/para&gt;  &lt;para&gt;    true No prior credit history in Bondora&lt;/para&gt; | [optional] [default to null]
**loan_application_started_date** | **String** | Date when the loan application was started | [optional] [default to null]
**loan_date** | **String** | Date when the loan was issued | [optional] [default to null]
**contract_end_date** | **String** | Date when the loan contract ended | [optional] [default to null]
**first_payment_date** | **String** | First payment date according to initial loan schedule | [optional] [default to null]
**maturity_date_original** | **String** | Loan maturity date according to the original loan schedule | [optional] [default to null]
**maturity_date_last** | **String** | Loan maturity date as of the report generation date | [optional] [default to null]
**application_signed_hour** | **i32** | Hour of signing the loan application | [optional] [default to null]
**application_signed_weekday** | **i32** | Weekday of signing the loan application | [optional] [default to null]
**verification_type** | **i32** | Method used for loan application data verification | [optional] [default to null]
**language_code** | **i32** | Customer two letter language code | [optional] [default to null]
**age** | **i32** | Age of the borrower (years) | [optional] [default to null]
**date_of_birth** | **String** | DateOfBirth of the borrower | [optional] [default to null]
**gender** | **i32** | Borrower gender | [optional] [default to null]
**country** | **String** | Residency of the borrower | [optional] [default to null]
**county** | **String** | County of the borrower | [optional] [default to null]
**city** | **String** | City of the borrower | [optional] [default to null]
**applied_amount** | **f64** | Amount applied | [optional] [default to null]
**amount** | **f64** | Amount the borrower received | [optional] [default to null]
**interest** | **f64** | Interest rate | [optional] [default to null]
**loan_duration** | **i32** | The loan term | [optional] [default to null]
**monthly_payment** | **i32** | Estimated amount the borrower has to pay every month | [optional] [default to null]
**use_of_loan** | **i32** | Use of loan | [optional] [default to null]
**education** | **i32** | Education | [optional] [default to null]
**marital_status** | **i32** | Marital status | [optional] [default to null]
**nr_of_dependants** | **String** | Number of children or other dependants | [optional] [default to null]
**employment_status** | **i32** | Employment status | [optional] [default to null]
**employment_duration_current_employer** | **String** | Employment time with the current employer | [optional] [default to null]
**employment_position** | **String** | Employment position with the current employer | [optional] [default to null]
**work_experience** | **String** | Work experience in total | [optional] [default to null]
**occupation_area** | **i32** | Occupation area | [optional] [default to null]
**home_ownership_type** | **i32** | Home ownership type | [optional] [default to null]
**income_from_principal_employer** | **f64** | Salary | [optional] [default to null]
**income_from_pension** | **f64** | Pension | [optional] [default to null]
**income_from_family_allowance** | **f64** | Family allowance | [optional] [default to null]
**income_from_social_welfare** | **f64** | Social welfare | [optional] [default to null]
**income_from_leave_pay** | **f64** | Leave pay | [optional] [default to null]
**income_from_child_support** | **f64** | Child support | [optional] [default to null]
**income_other** | **f64** | Other income | [optional] [default to null]
**income_total** | **f64** | Total income | [optional] [default to null]
**existing_liabilities** | **i32** | Borrower&#39;s number of existing liabilities | [optional] [default to null]
**refinance_liabilities** | **i32** | The total amount of liabilities after refinancing | [optional] [default to null]
**liabilities_total** | **f64** | Total monthly liabilities | [optional] [default to null]
**debt_to_income** | **f64** | Debt to income ratio | [optional] [default to null]
**free_cash** | **f64** | Discretionary income after monthly liabilities | [optional] [default to null]
**monthly_payment_day** | **i32** | The day of the month the loan payments are scheduled for The actual date is adjusted for weekends and bank holidays (e.g. if 10th is Sunday then the payment will be made on the 11th in that month) | [optional] [default to null]
**active_schedule_first_payment_reached** | **bool** | Whether the first payment date has been reached according to the active schedule | [optional] [default to null]
**planned_principal_till_date** | **f64** | According to active schedule the amount of principal the investment should have received | [optional] [default to null]
**planned_interest_till_date** | **f64** | According to active schedule the amount of interest the investment should have received | [optional] [default to null]
**last_payment_on** | **String** | The date of the current last payment received from the borrower | [optional] [default to null]
**current_debt_days_primary** | **i32** | How long the loan has been in Principal Debt | [optional] [default to null]
**debt_occured_on** | **String** | The date when Principal Debt occurred | [optional] [default to null]
**current_debt_days_secondary** | **i32** | How long the loan has been in Interest Debt | [optional] [default to null]
**debt_occured_on_for_secondary** | **String** | The date when Interest Debt occurred | [optional] [default to null]
**expected_loss** | **f64** | Expected Loss calculated by the current Rating model | [optional] [default to null]
**loss_given_default** | **f64** | Gives the percentage of outstanding exposure at the time of default that an investor is likely to lose if a loan actually defaults.  This means the proportion of funds lost for the investor after all expected recovery and accounting for the time value of the money recovered.  In general, LGD parameter is intended to be estimated based on the historical recoveries.  However, in new markets where limited experience does not allow us more precise loss given default estimates, a LGD of 90% is assumed. | [optional] [default to null]
**expected_return** | **f64** | Expected Return calculated by the current Rating model | [optional] [default to null]
**probability_of_default** | **f64** | Probability of Default, refers to a loan’s probability of default within one year horizon. | [optional] [default to null]
**default_date** | **String** | The date when loan went into defaulted state and collection process was started | [optional] [default to null]
**principal_overdue_by_schedule** | **f64** | According to the current schedule, principal that is overdue | [optional] [default to null]
**planned_principal_post_default** | **f64** | The amount of principal that was planned to be received after the default occurred | [optional] [default to null]
**planned_interest_post_default** | **f64** | The amount of interest that was planned to be received after the default occurred | [optional] [default to null]
**ead1** | **f64** | Exposure at default, outstanding principal at default | [optional] [default to null]
**ead2** | **f64** | Exposure at default, loan amount less all payments prior to default | [optional] [default to null]
**principal_recovery** | **f64** | Principal recovered due to collection process from in debt loans | [optional] [default to null]
**interest_recovery** | **f64** | Interest recovered due to collection process from in debt loans | [optional] [default to null]
**recovery_stage** | **i32** | Current stage according to the recovery model 1 Collection 2 Recovery 3 Write Off | [optional] [default to null]
**stage_active_since** | **String** | How long the current recovery stage has been active | [optional] [default to null]
**model_version** | **i32** | The version of the Rating model used for issuing the Bondora Rating | [optional] [default to null]
**rating** | **String** | Bondora Rating issued by the Rating model | [optional] [default to null]
**el_v0** | **f64** | Expected loss calculated by the specified version of Rating model | [optional] [default to null]
**rating_v0** | **String** | Bondora Rating issued by version 0 of the Rating model | [optional] [default to null]
**el_v1** | **f64** | Expected loss calculated by the specified version of Rating model | [optional] [default to null]
**rating_v1** | **String** | Bondora Rating issued by version 1 of the Rating model | [optional] [default to null]
**el_v2** | **f64** | Expected loss calculated by the specified version of Rating model | [optional] [default to null]
**rating_v2** | **String** | Bondora Rating issued by version 2 of the Rating model | [optional] [default to null]
**loan_cancelled** | **bool** | If Loan was cancelled | [optional] [default to null]
**status** | **String** | The current status of the loan application | [optional] [default to null]
**restructured** | **bool** | The original maturity date of the loan has been increased by more than 60 days | [optional] [default to null]
**active_late_category** | **String** | When a loan is in Principal Debt then it will be categorized by Principal Debt days | [optional] [default to null]
**worse_late_category** | **String** | Displays the last longest period of days when the loan was in Principal Debt | [optional] [default to null]
**credit_score_es_micro_l** | **String** | A score that is specifically designed for risk classifying subprime borrowers (defined by Equifax as borrowers that do not have access to bank loans).  A measure of the probability of default one month ahead.  &lt;para&gt;The score is given on a 10-grade scale, from the best score to the worst:&lt;/para&gt;&lt;para&gt;M1, M2, M3, M4, M5, M6, M7, M8, M9, M10&lt;/para&gt; | [optional] [default to null]
**credit_score_es_equifax_risk** | **String** | Generic score for the loan applicants that do not have active past due operations in ASNEF.  A measure of the probability of default one year ahead.  The score is given on a 6-grade scale.  &lt;para&gt;AAA Very low&lt;/para&gt;&lt;para&gt;AA Low&lt;/para&gt;&lt;para&gt;A Average&lt;/para&gt;&lt;para&gt;B Average High&lt;/para&gt;&lt;para&gt;C High&lt;/para&gt;&lt;para&gt;D Very High&lt;/para&gt; | [optional] [default to null]
**credit_score_fi_asiakas_tieto_risk_grade** | **String** | Credit Scoring model for Finnish Asiakastieto  &lt;para&gt;RL1 Very low risk 01-20&lt;/para&gt;&lt;para&gt;RL2 Low risk 21-40&lt;/para&gt;&lt;para&gt;RL3 Average risk 41-60&lt;/para&gt;&lt;para&gt;RL4 Big risk 61-80&lt;/para&gt;&lt;para&gt;RL5 Huge risk 81-100&lt;/para&gt; | [optional] [default to null]
**credit_score_ee_mini** | **String** | Credit scoring for Estonian loans  &lt;para&gt;1000 No previous payments problems&lt;/para&gt;&lt;para&gt;900 Payments problems finished 24-36 months ago&lt;/para&gt;&lt;para&gt;800 Payments problems finished 12-24 months ago&lt;/para&gt;&lt;para&gt;700 Payments problems finished 6-12 months ago&lt;/para&gt;&lt;para&gt;600 Payment problems finished &amp;lt;6 months ago&lt;/para&gt;&lt;para&gt;500 Active payment problems&lt;/para&gt; | [optional] [default to null]
**principal_payments_made** | **f64** | Note owner received loan transfers principal amount | [optional] [default to null]
**interest_and_penalty_payments_made** | **f64** | Note owner received loan transfers earned interest, penalties total amount | [optional] [default to null]
**principal_write_offs** | **f64** | Principal that was written off on the investment | [optional] [default to null]
**interest_and_penalty_write_offs** | **f64** | Interest that was written off on the investment | [optional] [default to null]
**principal_debt_servicing_cost** | **f64** | Service cost related to the recovery of the debt based on the principal of the investment | [optional] [default to null]
**interest_and_penalty_debt_servicing_cost** | **f64** | Service cost related to the recovery of the debt based on the interest and penalties of the investment | [optional] [default to null]
**principal_balance** | **f64** | Principal that still needs to be paid by the borrower | [optional] [default to null]
**interest_and_penalty_balance** | **f64** | Unpaid interest and penalties | [optional] [default to null]
**no_of_previous_loans_before_loan** | **i32** | Number of previous loans | [optional] [default to null]
**amount_of_previous_loans_before_loan** | **f64** | Value of previous loans | [optional] [default to null]
**previous_repayments_before_loan** | **f64** | How much the borrower had repaid before the loan | [optional] [default to null]
**previous_early_repayments_before_loan** | **f64** | Previous early repaid amount before this loan | [optional] [default to null]
**previous_early_repayments_count_before_loan** | **i32** | Previous early repaid loans before this loan | [optional] [default to null]
**grace_period_start** | **String** | Date of the beginning of Grace period | [optional] [default to null]
**grace_period_end** | **String** | Date of the end of Grace period | [optional] [default to null]
**next_payment_date** | **String** | According to schedule the next date for borrower to make their payment | [optional] [default to null]
**next_payment_nr** | **i32** | According to schedule the number of the next payment | [optional] [default to null]
**nr_of_scheduled_payments** | **i32** | According to schedule the count of scheduled payments | [optional] [default to null]
**re_scheduled_on** | **String** | The date when the a new schedule was assigned to the borrower | [optional] [default to null]

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


