# Auction

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**loan_id** | **String** | Unique loan identificator | [optional] [default to null]
**auction_id** | **String** | Unique auction identificator | [optional] [default to null]
**loan_number** | **i32** | Number of the loan | [optional] [default to null]
**user_name** | **String** | Customer&#39;s Bondora username | [optional] [default to null]
**new_credit_customer** | **i32** | Did the customer have prior credit history in Bondora  &lt;para&gt;0 Customer had at least 3 months of credit history in Bondora&lt;/para&gt;&lt;para&gt;1 No prior credit history in Bondora&lt;/para&gt; | [optional] [default to null]
**loan_application_started_date** | **String** | Date when the loan application was started | [optional] [default to null]
**planned_close_date** | **String** | Date and time when the auction is closed, if it&#39;s not funded 100% before that.  Auction will be closed before that, if auction is funded 100%. | [optional] [default to null]
**application_signed_hour** | **i32** | Hour of signing the loan application | [optional] [default to null]
**application_signed_weekday** | **i32** | Weekday of signing the loan application | [optional] [default to null]
**verification_type** | **i32** | Verification type | [optional] [default to null]
**language_code** | **i32** | Two letter language code | [optional] [default to null]
**age** | **i32** | Age of the borrower (years) | [optional] [default to null]
**date_of_birth** | **String** | Borrower&#39;s date of birth | [optional] [default to null]
**gender** | **i32** | Gender | [optional] [default to null]
**country** | **String** | Residency of the borrower | [optional] [default to null]
**credit_score_es_micro_l** | **String** | A score that is specifically designed for risk classifying subprime borrowers (defined by Equifax as borrowers that do not have access to bank loans).   A measure of the probability of default one month ahead.  &lt;para&gt;The score is given on a 10-grade scale, from the best score to the worst:&lt;/para&gt;&lt;para&gt;M1, M2, M3, M4, M5, M6, M7, M8, M9, M10&lt;/para&gt; | [optional] [default to null]
**credit_score_es_equifax_risk** | **String** | Generic score for the loan applicants that do not have active past due operations in ASNEF.  A measure of the probability of default one year ahead.   The score is given on a 6-grade scale.  &lt;para&gt;AAA Very low&lt;/para&gt;&lt;para&gt;AA Low&lt;/para&gt;&lt;para&gt;A Average&lt;/para&gt;&lt;para&gt;B Average High&lt;/para&gt;&lt;para&gt;C High&lt;/para&gt;&lt;para&gt;D Very High&lt;/para&gt; | [optional] [default to null]
**credit_score_fi_asiakas_tieto_risk_grade** | **String** | Credit Scoring model for Finnish Asiakastieto  &lt;para&gt;RL1 Very low risk 01-20&lt;/para&gt;&lt;para&gt;RL2 Low risk 21-40&lt;/para&gt;&lt;para&gt;RL3 Average risk 41-60&lt;/para&gt;&lt;para&gt;RL4 Big risk 61-80&lt;/para&gt;&lt;para&gt;RL5 Huge risk 81-100&lt;/para&gt; | [optional] [default to null]
**credit_score_ee_mini** | **String** | Credit scoring for Estonian loans  &lt;para&gt;1000 No previous payments problems&lt;/para&gt;&lt;para&gt;900 Payments problems finished 24-36 months ago&lt;/para&gt;&lt;para&gt;800 Payments problems finished 12-24 months ago&lt;/para&gt;&lt;para&gt;700 Payments problems finished 6-12 months ago&lt;/para&gt;&lt;para&gt;600 Payment problems finished &amp;lt;6 months ago&lt;/para&gt;&lt;para&gt;500 Active payment problems&lt;/para&gt; | [optional] [default to null]
**applied_amount** | **f64** | The amount borrower applied for originally | [optional] [default to null]
**interest** | **f64** | Maximum interest rate accepted in the loan application | [optional] [default to null]
**loan_duration** | **i32** | The loan term | [optional] [default to null]
**county** | **String** | County of the borrower | [optional] [default to null]
**city** | **String** | City of the borrower | [optional] [default to null]
**education** | **i32** | Education | [optional] [default to null]
**employment_duration_current_employer** | **String** | Employment time with the current employer | [optional] [default to null]
**home_ownership_type** | **i32** | Type of home ownership | [optional] [default to null]
**income_total** | **f64** | Total income | [optional] [default to null]
**monthly_payment** | **f64** | Loan monthly payment amount. | [optional] [default to null]
**monthly_payment_day** | **i32** | The day of the month the loan payments are scheduled for.  The actual date is adjusted for weekends and bank holidays.  E.g. if 10th is a Sunday then the payment will be made on the 11th in that month. | [optional] [default to null]
**model_version** | **i32** | The version of the Rating model used for issuing the Bondora Rating | [optional] [default to null]
**expected_loss** | **f64** | Expected Loss calculated by the Rating model | [optional] [default to null]
**rating** | **String** | Bondora Rating issued by the Rating model | [optional] [default to null]
**loss_given_default** | **f64** | Gives the percentage of outstanding exposure at the time of default that an investor is likely to lose if a loan actually defaults.   This means the proportion of funds lost for the investor after all expected recovery and accounting for the time value of the money recovered.   In general, LGD parameter is intended to be estimated based on the historical recoveries. However, in new markets where limited experience does not allow us more precise loss given default estimates, a LGD of 90% is assumed. | [optional] [default to null]
**probability_of_default** | **f64** | Probability of Default, refers to a loan’s probability of default within one year horizon. | [optional] [default to null]
**expected_return_alpha** | **f64** | Expected return alpha | [optional] [default to null]
**liabilities_total** | **f64** | Total liabilities | [optional] [default to null]
**listed_on_utc** | **String** | Date when auction was published | [optional] [default to null]
**actual_close_date** | **String** | Date and time when the auction was actually closed. Is null, if auction is active. | [optional] [default to null]
**winning_bids_amount** | **f64** | The amount that auction is fulfilled, taken amount only bids where investors have enough funds.  This is preliminary calculated amount and can change when trying to close auction (auction is closed, when auction is funded 100% or PlannedCloseDate is reached) and specific investor(s) do not have enough funds. | [optional] [default to null]
**remaining_amount** | **f64** | The amount that is remaining to be funded (AppliedAmount - WinningBidsAmount). | [optional] [default to null]
**user_bids** | **i32** | How many bids current user has bidden into the auction | [optional] [default to null]
**user_bid_amount** | **f64** | How much current user has bidden into the auction | [optional] [default to null]
**fullfilled** | **f64** | Precentage, how much the auction is fulfilled. Can be more than 100%, if overfunded. | [optional] [default to null]
**credit_score** | **i32** | &lt;para&gt;    1000 No previous payments problems&lt;/para&gt;  &lt;para&gt;    900 Payments problems finished 24-36 months ago&lt;/para&gt;  &lt;para&gt;    800 Payments problems finished 12-24 months ago&lt;/para&gt;  &lt;para&gt;    700 Payments problems finished 6-12 months ago&lt;/para&gt;  &lt;para&gt;    600 Payment problems finished &amp;lt;6 months ago&lt;/para&gt;  &lt;para&gt;    500 Active payment problems&lt;/para&gt; | [optional] [default to null]
**scoring_date** | **String** | Date when the Rating was calculated for this loan | [optional] [default to null]
**use_of_loan** | **i32** | Use of loan  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is -1 (NotUsed)&lt;/para&gt; | [optional] [default to null]
**marital_status** | **i32** | Marital status  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is -1 (NotUsed)&lt;/para&gt; | [optional] [default to null]
**nr_of_dependants** | **String** | Number of children or other dependants  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is NULL&lt;/para&gt; | [optional] [default to null]
**employment_status** | **i32** | Employment status  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is -1 (NotUsed)&lt;/para&gt; | [optional] [default to null]
**employment_position** | **String** | Employment position  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is NULL&lt;/para&gt; | [optional] [default to null]
**work_experience** | **String** | Work experience in total  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is NULL&lt;/para&gt; | [optional] [default to null]
**occupation_area** | **i32** | Occupation area  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is -1 (NotUsed)&lt;/para&gt; | [optional] [default to null]
**income_from_principal_employer** | **f64** | Salary  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is 0&lt;/para&gt; | [optional] [default to null]
**income_from_pension** | **f64** | Pension  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is 0&lt;/para&gt; | [optional] [default to null]
**income_from_family_allowance** | **f64** | Family allowance  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is 0&lt;/para&gt; | [optional] [default to null]
**income_from_social_welfare** | **f64** | Social welfare  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is 0&lt;/para&gt; | [optional] [default to null]
**income_from_leave_pay** | **f64** | Leave pay  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is 0&lt;/para&gt; | [optional] [default to null]
**income_from_child_support** | **f64** | Child support  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is 0&lt;/para&gt; | [optional] [default to null]
**income_other** | **f64** | Other income  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is 0&lt;/para&gt; | [optional] [default to null]
**free_cash** | **f64** | Discretionary Income  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is 0&lt;/para&gt; | [optional] [default to null]
**debt_to_income** | **f64** | Debt to income ratio  &lt;para&gt;Only Value for new Auctions since 1st of june 2017 is 0&lt;/para&gt; | [optional] [default to null]
**ead_rate** | **f64** | Exposure at Default (expressed as a percentage of the original loan amount), indicates outstanding investor exposure at the time of default, including outstanding principal amount plus accrued but unpaid interests. | [optional] [default to null]
**maturity_factor** | **f64** | Maturity Factor M of 1.3 is assumed for loans with duration exceeding one year. | [optional] [default to null]
**interest_rate_alpha** | **f64** | Interest rate alpha | [optional] [default to null]

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


