#[test]
fn test_u32() {
    use std::time::Duration;
    use std::thread;
    use bombs::*;

    let (fuse, bomb) = Bomb::new();

    let bomb_a = bomb.clone();
    let thread_a = thread::spawn(move || {
        let bomb = bomb_a;

        // Wait for bomb to explode.
        while let None = bomb.exploded() { }

        if let Some(value) = bomb.exploded() {
            println!("Thread A got value: {}", value);
        }
    });

    let bomb_b = bomb.clone();
    let thread_b = thread::spawn(move || {
        let bomb = bomb_b;

        // Wait for bomb to explode.
        while let None = bomb.exploded() { }

        if let Some(value) = bomb.exploded() {
            println!("Thread B got value: {}", value);
        }
    });

    // Sleep current thread for 5 seconds.
    thread::sleep(Duration::from_secs(5));

    // Light fuse.
    fuse.light(24u32);

    thread_a.join().unwrap(); thread_b.join().unwrap();
}

#[test]
fn test_void() {
    use std::time::Duration;
    use std::thread;
    use bombs::*;

    let (fuse, bomb) = Bomb::new();

    let bomb_a = bomb.clone();
    let thread_a = thread::spawn(move || {
        let bomb = bomb_a;

        // Wait for bomb to explode.
        while let None = bomb.exploded() { }

        if let Some(_) = bomb.exploded() {
            println!("Thread A got event");
        }
    });

    let bomb_b = bomb;
    let thread_b = thread::spawn(move || {
        let bomb = bomb_b;

        // Wait for bomb to explode.
        while let None = bomb.exploded() { }

        if let Some(_) = bomb.exploded() {
            println!("Thread B got event");

            // Do some clean up work.
            thread::sleep(Duration::from_secs(3));
        }
    });

    println!("Sleeping...");

    // Sleep current thread for 5 seconds.
    thread::sleep(Duration::from_secs(5));

    // Light fuse.
    let fire = fuse.light(());

    println!("Lit fuse");

    // Wait for bombs to extinguish (drop)
    while !fire.extinguished() { }

    println!("Complete!");

    thread_a.join().unwrap(); thread_b.join().unwrap();
}

#[test]
fn test_multi_u32() {
    use std::time::Duration;
    use std::thread;
    use bombs::*;

    let (mut fuse, bomb) = MultiBomb::new();

    let bomb_a = bomb.clone();
    let thread_a = thread::spawn(move || {
        let mut bomb = bomb_a;
        
        loop { 
            // Wait for bomb to explode.
            match bomb.exploded() {
                None => {},

                Some(5) => {
                    println!("Thread A got special number!");
                    break;
                }

                Some(v) => {
                    println!("Thread A got value: {}", v);

                    // Do some other hard work.
                    thread::sleep(Duration::from_secs(3));
                }
            }
        }
    });

    let bomb_b = bomb;
    let thread_b = thread::spawn(move || {
        let mut bomb = bomb_b;

        loop { 
            // Wait for bomb to explode.
            match bomb.exploded() {
                None => {},

                Some(5) => {
                    println!("Thread B got special number!");
                    break;
                }

                Some(v) => {
                    println!("Thread B got value: {}", v);
                }
            }
        }
    });

    println!("Sleeping...");

    // Sleep current thread for 5 seconds.
    thread::sleep(Duration::from_secs(5));

    // Light fuse twice.
    let fire = fuse.light(3u32);
    let fire2 = fuse.light(7);

    println!("Lit fuse twice");

    // Wait for bombs to extinguish (drop)
    while !fire.extinguished() { }

    println!("Extinguished first time");

    while !fire2.extinguished() { }

    println!("Extinguished second time");

    println!("Sleeping...");

    // Sleep current thread for another 2 seconds.
    thread::sleep(Duration::from_secs(2));

    // Light fuse for the final time.
    let fire = fuse.light(5);

    println!("Lit fuse");

    // Wait for bombs to extinguish (drop)
    while !fire.extinguished() { }

    println!("Extinguished");

    thread_a.join().unwrap(); thread_b.join().unwrap();
}