// This file is automatically generated!

use std::{
    borrow::Cow,
    borrow::{Borrow, BorrowMut},
    cmp::Ordering,
    collections::HashMap,
    ffi::{CStr, CString, OsStr, OsString},
    fmt,
    hash::Hash,
    iter::FromIterator,
    ops::{Add, AddAssign, Deref},
    path::{Path, PathBuf},
    rc::Rc,
    sync::Arc,
};

/// **B**orrowed, **O**wned, **A**rc, **R**c or **S**tatic smart pointer for types implementing the [`ToOwned`] (**T**.**O**.) trait.
pub type BoarsTo<'b, B> = Boars<'b, B, <B as ToOwned>::Owned>;

/// **B**orrowed, **O**wned, **A**rc, **R**c or **S**tatic heap allocating smart pointer.
pub type BoarsBox<'b, T> = Boars<'b, T, Box<T>, T>;

/// **B**orrowed, **O**wned, **A**rc, **R**c or **S**tatic [`Vec`] smart pointer.
pub type BoarsVec<'b, T> = BoarsTo<'b, [T]>;

/// **B**orrowed, **O**wned, **A**rc, **R**c or **S**tatic [`str`] smart pointer.
pub type BoarsStr<'b> = BoarsTo<'b, str>;

/// **B**orrowed, **O**wned, **A**rc, **R**c or **S**tatic smart pointer.
#[non_exhaustive]
pub enum Boars<'b, B, O = B, S = O>
where
    B: ?Sized,
    B: 'static,
    S: ?Sized,
{
    Borrowed(&'b B),

    Owned(O),

    // unstable reason:
    // Variant may not be needed.
    // Arc::clone may be good enough.
    // Upgrading and downgrading lifetimes may be used rarely.
    #[cfg(feature = "unstable")]
    BorrowedArc(&'b Arc<S>),
    Arc(Arc<S>),
    // unstable reason:
    // Variant may not be needed.
    // Rc::clone may be good enough.
    // Upgrading and downgrading lifetimes may be used rarely.
    #[cfg(feature = "unstable")]
    BorrowedRc(&'b Rc<S>),
    Rc(Rc<S>),
    Static(&'static B),
}

impl<'b, B: ?Sized, O, S: ?Sized> Boars<'b, B, O, S> {
    /// Extracts the owned data.
    ///
    /// Clones the data if it is not already owned.
    ///
    /// # Examples
    ///
    /// Calling `into_owned` on a `Boars::Borrowed` clones the inner data.
    /// ```
    /// use boar::BoarsTo;
    /// use std::collections::HashMap;
    ///
    /// let map = HashMap::from([(1, 4), (2, 8)]);
    /// let boars = BoarsTo::Borrowed(&map);
    /// let owned: HashMap<_, _> = boars.into_owned();
    /// assert_eq!(owned, map);
    /// ```
    ///
    /// Calling `into_owned` on a `Boars::Owned` doesn't clone anything.
    /// ```
    /// use boar::BoarsTo;
    /// use std::collections::HashMap;
    ///
    /// let boars = BoarsTo::<HashMap<_, _>>::Owned(HashMap::from([(1, 4)]));
    /// let owned: HashMap<_, _> = boars.into_owned();
    /// assert_eq!(owned, HashMap::from([(1, 4)]));
    /// ```
    #[inline]
    pub fn into_owned(self) -> O
    where
        B: ToOwned<Owned = O>,
        S: Clone + Into<O>,
    {
        match self {
            Self::Borrowed(x) => x.to_owned(),
            Self::Static(x) => x.to_owned(),
            Self::Owned(x) => x,
            #[cfg(feature = "unstable")]
            Self::BorrowedArc(x) => x.deref().clone().into(),
            Self::Arc(x) => Arc::try_unwrap(x)
                .unwrap_or_else(|x| x.deref().clone())
                .into(),
            #[cfg(feature = "unstable")]
            Self::BorrowedRc(x) => x.deref().clone().into(),
            Self::Rc(x) => Rc::try_unwrap(x)
                .unwrap_or_else(|x| x.deref().clone())
                .into(),
        }
    }

    /// Acquires a mutable reference to the owned form of the data.
    ///
    /// Clones the data if it is not already owned.
    ///
    /// # Examples
    ///
    /// Calling `to_mut` on a `Boars::Borrowed` clones the inner data.
    /// ```
    /// use boar::BoarsTo;
    /// use std::collections::HashMap;
    ///
    /// let map = HashMap::from([(1, 4), (2, 8)]);
    /// let mut boars = BoarsTo::Borrowed(&map);
    /// boars.to_mut().remove(&1);
    /// assert_eq!(boars, HashMap::from([(2, 8)]));
    /// ```
    ///
    /// Calling `to_mut` on a `Boars::Owned` doesn't clone anything.
    /// ```
    /// use boar::BoarsTo;
    /// use std::collections::HashMap;
    ///
    /// let mut boars = BoarsTo::Owned(HashMap::from([(1, 4), (2, 8)]));
    /// boars.to_mut().remove(&1);
    /// assert_eq!(boars, HashMap::from([(2, 8)]));
    /// ```
    #[inline]
    pub fn to_mut(&mut self) -> &mut O
    where
        B: ToOwned<Owned = O>,
        S: Clone + BorrowMut<O>,
    {
        match self {
            Self::Borrowed(x) => {
                *self = Self::Owned(x.to_owned());
                self.to_mut()
            }
            Self::Static(x) => {
                *self = Self::Owned(x.to_owned());
                self.to_mut()
            }
            Self::Owned(x) => x,
            #[cfg(feature = "unstable")]
            Self::BorrowedArc(x) => {
                // avoid changing the reference count by immediately cloning S
                *self = Self::Arc(S::clone(x).into());
                self.to_mut()
            }
            Self::Arc(x) => Arc::make_mut(x).borrow_mut(),
            #[cfg(feature = "unstable")]
            Self::BorrowedRc(x) => {
                // avoid changing the reference count by immediately cloning S
                *self = Self::Rc(S::clone(x).into());
                self.to_mut()
            }
            Self::Rc(x) => Rc::make_mut(x).borrow_mut(),
        }
    }

    /**
    Convert borrowed variants so that the new `Boars` has a `'static` lifetime.

    # Examples

    ```rust
    use boar::{Boars, BoarsTo};
    use std::collections::HashMap;

    let map = HashMap::from([(1, 3), (2, 6)]);
    let b = BoarsTo::Borrowed(&map);
    let s = b.into_static();
    assert_eq!(s, map);
    assert_matches::assert_matches!(s, Boars::Owned(_));
    ```
    */
    #[inline]
    pub fn into_static(self) -> Boars<'static, B, O, S>
    where
        B: ToOwned<Owned = O>,
    {
        match self {
            Self::Borrowed(x) => Boars::Owned(x.to_owned()),
            Self::Owned(x) => Boars::Owned(x),
            #[cfg(feature = "unstable")]
            Self::BorrowedArc(x) => Boars::Arc(x.clone()),
            Self::Arc(x) => Boars::Arc(x),
            #[cfg(feature = "unstable")]
            Self::BorrowedRc(x) => Boars::Rc(x.clone()),
            Self::Rc(x) => Boars::Rc(x),
            Self::Static(x) => Boars::Static(x),
        }
    }

    /**
    Convert to a new `Boars` that borrows from `self`.

    # Compatibility

    The variants returned by this function are an implementation detail
    and may change with any new minor version.
    So for example your code should not rely on this function
    returning a [`Boars::Borrowed`] variant
    when it is called on a [`Boars::Owned`] variant.

    # Examples

    ```rust
    use boar::{Boars, BoarsTo};
    use std::collections::HashMap;

    let map = HashMap::from([(1, 3), (2, 6)]);
    let o: Boars<_> = BoarsTo::Owned(map.clone());
    let b: Boars<_> = o.to_borrowed(); // does not clone the map
    assert_eq!(o, map);
    assert_eq!(b, map);
    ```
    */
    #[inline]
    pub fn to_borrowed(&self) -> Boars<'_, B, O, S>
    where
        O: Borrow<B>,
    {
        match self {
            Self::Borrowed(x) => Boars::Borrowed(x),
            Self::Owned(x) => Boars::Borrowed(x.borrow()),
            #[cfg(feature = "unstable")]
            Self::BorrowedArc(x) => Boars::BorrowedArc(x),
            #[cfg(feature = "unstable")]
            Self::Arc(x) => Boars::BorrowedArc(x),
            #[cfg(not(feature = "unstable"))]
            Self::Arc(x) => Boars::Arc(x.clone()),
            #[cfg(feature = "unstable")]
            Self::BorrowedRc(x) => Boars::BorrowedRc(x),
            #[cfg(feature = "unstable")]
            Self::Rc(x) => Boars::BorrowedRc(x),
            #[cfg(not(feature = "unstable"))]
            Self::Rc(x) => Boars::Rc(x.clone()),
            Self::Static(x) => Boars::Static(x),
        }
    }

    /**
    Convert [`Boars::Owned`] into [`Boars::Rc`].

    # Examples

    ```rust
    use boar::{Boars, BoarsTo};
    use std::collections::HashMap;

    let map = HashMap::from([(1, 3)]);
    let o = BoarsTo::Owned(map.clone());
    let s = o.into_shared();
    assert_eq!(s, map);
    assert_matches::assert_matches!(s, Boars::Rc(_));
    ```
    */
    #[inline]
    pub fn into_shared(self) -> Self
    where
        O: Into<Rc<S>>,
    {
        match self {
            Self::Owned(x) => Self::Rc(x.into()),
            _ => self,
        }
    }

    /// This is **unstable** and only available with the `unstable` feature.
    #[cfg(feature = "unstable")] // reason: unclear if actually needed; `make_shared` and `clone` can be used instead.
    #[inline]
    pub fn clone_shared(&mut self) -> Self
    where
        O: Default + Clone + Into<Rc<S>>,
    {
        self.internal_make_shared();
        self.clone()
    }

    /**
    Change [`Boars::Owned`] into [`Boars::Rc`].

    # Examples

    ```rust
    use boar::{Boars, BoarsTo};
    use std::collections::HashMap;

    let map = HashMap::from([(1, 3), (2, 6)]);
    let mut boars = BoarsTo::Owned(map.clone());
    boars.make_shared();
    assert_eq!(boars, map);
    assert_matches::assert_matches!(boars, Boars::Rc(_));
    ```
    */
    #[inline]
    pub fn make_shared(&mut self)
    where
        O: Default + Into<Rc<S>>,
    {
        self.internal_make_shared()
    }

    #[inline]
    fn internal_make_shared(&mut self)
    where
        O: Default + Into<Rc<S>>,
    {
        if let Self::Owned(x) = self {
            let x = std::mem::take(x);
            *self = Self::Rc(x.into());
        }
    }

    #[inline]
    fn internal_borrow(&self) -> &B
    where
        O: Borrow<B>,
        S: Borrow<B>,
    {
        match self {
            Self::Borrowed(x) => x,
            Self::Static(x) => x,
            Self::Owned(x) => x.borrow(),
            #[cfg(feature = "unstable")]
            Self::BorrowedArc(x) => x.deref().deref().borrow(),
            Self::Arc(x) => x.deref().borrow(),
            #[cfg(feature = "unstable")]
            Self::BorrowedRc(x) => x.deref().deref().borrow(),
            Self::Rc(x) => x.deref().borrow(),
        }
    }
}

impl<B: ?Sized, O, S: ?Sized> Boars<'static, B, O, S> {
    /// Upgrades [`Boars::Borrowed`] to [`Boars::Static`]
    ///
    /// # Examples
    /// ```rust
    /// use boar::{Boars, BoarsStr};
    ///
    /// let string = "Hello";
    /// let mut boars = BoarsStr::Borrowed(string);
    /// boars.ensure_static();
    /// assert_matches::assert_matches!(boars, Boars::Static(_));
    /// ```
    pub fn ensure_static(&mut self) {
        if let Self::Borrowed(x) = *self {
            *self = Self::Static(x);
        }
    }

    /// Upgrades [`Boars::Borrowed`] into [`Boars::Static`]
    ///
    /// # Examples
    /// ```rust
    /// use boar::{Boars, BoarsStr};
    ///
    /// let string = "Hello";
    /// let boars = BoarsStr::Borrowed(string);
    /// assert_matches::assert_matches!(
    ///     boars.into_ensured_static(),
    ///     Boars::Static(_)
    /// );
    /// ```
    pub fn into_ensured_static(mut self) -> Self {
        self.ensure_static();
        self
    }
}

impl<'b, B: ?Sized, O, S: ?Sized, Rhs> Add<Rhs> for Boars<'b, B, O, S>
where
    O: Add<Rhs>,
    B: ToOwned<Owned = O>,
    S: Clone + Into<O>,
{
    type Output = <O as Add<Rhs>>::Output;

    #[inline]
    fn add(self, rhs: Rhs) -> <O as Add<Rhs>>::Output {
        self.into_owned() + rhs
    }
}

impl<'b, B: ?Sized, O, S: ?Sized, Rhs> AddAssign<Rhs> for Boars<'b, B, O, S>
where
    O: AddAssign<Rhs>,
    B: ToOwned<Owned = O>,
    S: Clone + BorrowMut<O>,
{
    #[inline]
    fn add_assign(&mut self, rhs: Rhs) {
        *self.to_mut() += rhs;
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> AsRef<B> for Boars<'b, B, O, S>
where
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn as_ref(&self) -> &B {
        self.internal_borrow()
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> Borrow<B> for Boars<'b, B, O, S>
where
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn borrow(&self) -> &B {
        self.internal_borrow()
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> Deref for Boars<'b, B, O, S>
where
    O: Borrow<B>,
    S: Borrow<B>,
{
    type Target = B;

    #[inline]
    fn deref(&self) -> &Self::Target {
        self.internal_borrow()
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> Clone for Boars<'b, B, O, S>
where
    O: Clone,
{
    #[inline]
    fn clone(&self) -> Self {
        match self {
            Self::Borrowed(x) => Self::Borrowed(x),
            Self::Static(x) => Self::Static(x),
            Self::Owned(x) => Self::Owned(x.clone()),
            #[cfg(feature = "unstable")]
            Self::BorrowedArc(x) => Self::BorrowedArc(x),
            Self::Arc(x) => Self::Arc(x.clone()),
            #[cfg(feature = "unstable")]
            Self::BorrowedRc(x) => Self::BorrowedRc(x),
            Self::Rc(x) => Self::Rc(x.clone()),
        }
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> Default for Boars<'b, B, O, S>
where
    O: Default,
{
    /// Creates an owned Boars with the default value for the contained owned type.
    #[inline]
    fn default() -> Self {
        Self::Owned(O::default())
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> fmt::Debug for Boars<'b, B, O, S>
where
    B: fmt::Debug,
    O: fmt::Debug,
    S: fmt::Debug,
{
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self {
            Boars::Borrowed(x) => f.debug_tuple("Boars::Borrowed").field(x).finish(),
            Boars::Owned(x) => f.debug_tuple("Boars::Owned").field(x).finish(),
            #[cfg(feature = "unstable")]
            Boars::BorrowedArc(x) => f.debug_tuple("Boars::BorrowedArc").field(x).finish(),
            Boars::Arc(x) => f.debug_tuple("Boars::Arc").field(x).finish(),
            #[cfg(feature = "unstable")]
            Boars::BorrowedRc(x) => f.debug_tuple("Boars::BorrowedRc").field(x).finish(),
            Boars::Rc(x) => f.debug_tuple("Boars::Rc").field(x).finish(),
            Boars::Static(x) => f.debug_tuple("Boars::Static").field(x).finish(),
        }
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> fmt::Display for Boars<'b, B, O, S>
where
    B: fmt::Display,
    O: fmt::Display,
    S: fmt::Display,
{
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self {
            Self::Borrowed(x) => fmt::Display::fmt(x, f),
            Self::Owned(x) => fmt::Display::fmt(x, f),
            #[cfg(feature = "unstable")]
            Self::BorrowedArc(x) => fmt::Display::fmt(x, f),
            Self::Arc(x) => fmt::Display::fmt(x, f),
            #[cfg(feature = "unstable")]
            Self::BorrowedRc(x) => fmt::Display::fmt(x, f),
            Self::Rc(x) => fmt::Display::fmt(x, f),
            Self::Static(x) => fmt::Display::fmt(x, f),
        }
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> Hash for Boars<'b, B, O, S>
where
    B: Hash,
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn hash<H: std::hash::Hasher>(&self, state: &mut H) {
        self.internal_borrow().hash(state)
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> PartialEq<&B> for Boars<'b, B, O, S>
where
    B: PartialEq,
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn eq(&self, other: &&B) -> bool {
        self.internal_borrow() == *other
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> PartialEq<B> for Boars<'b, B, O, S>
where
    B: PartialEq,
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn eq(&self, other: &B) -> bool {
        self.internal_borrow() == other
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> PartialEq for Boars<'b, B, O, S>
where
    B: PartialEq,
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn eq(&self, other: &Self) -> bool {
        self.internal_borrow() == other.internal_borrow()
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> Eq for Boars<'b, B, O, S>
where
    B: Eq,
    O: Borrow<B>,
    S: Borrow<B>,
{
}

impl<'b, B: ?Sized, O, S: ?Sized> PartialOrd<&B> for Boars<'b, B, O, S>
where
    B: PartialOrd,
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn partial_cmp(&self, other: &&B) -> Option<Ordering> {
        self.internal_borrow().partial_cmp(*other)
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> PartialOrd<B> for Boars<'b, B, O, S>
where
    B: PartialOrd,
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn partial_cmp(&self, other: &B) -> Option<Ordering> {
        self.internal_borrow().partial_cmp(other)
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> PartialOrd for Boars<'b, B, O, S>
where
    B: PartialOrd,
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn partial_cmp(&self, other: &Self) -> Option<Ordering> {
        self.internal_borrow().partial_cmp(other.internal_borrow())
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> Ord for Boars<'b, B, O, S>
where
    B: Ord,
    O: Borrow<B>,
    S: Borrow<B>,
{
    #[inline]
    fn cmp(&self, other: &Self) -> Ordering {
        self.internal_borrow().cmp(other.internal_borrow())
    }
}

impl<'b, A, B: ?Sized, O, S: ?Sized> FromIterator<A> for Boars<'b, B, O, S>
where
    O: FromIterator<A>,
{
    #[inline]
    fn from_iter<T: IntoIterator<Item = A>>(iter: T) -> Self {
        Self::Owned(iter.into_iter().collect())
    }
}

impl<'b, B: ToOwned + ?Sized + 'b> From<Cow<'b, B>> for Boars<'b, B, B::Owned, B::Owned> {
    #[inline]
    fn from(p: Cow<'b, B>) -> Self {
        match p {
            Cow::Borrowed(x) => Self::Borrowed(x),
            Cow::Owned(x) => Self::Owned(x),
        }
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> From<&'b B> for Boars<'b, B, O, S> {
    #[inline]
    fn from(x: &'b B) -> Self {
        Self::Borrowed(x)
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> From<Arc<S>> for Boars<'b, B, O, S> {
    #[inline]
    fn from(x: Arc<S>) -> Self {
        Self::Arc(x)
    }
}

impl<'b, B: ?Sized, O, S: ?Sized> From<Rc<S>> for Boars<'b, B, O, S> {
    #[inline]
    fn from(x: Rc<S>) -> Self {
        Self::Rc(x)
    }
}

impl<'b, T> From<Vec<T>> for Boars<'b, [T], Vec<T>> {
    #[inline]
    fn from(x: Vec<T>) -> Self {
        Self::Owned(x)
    }
}

impl<'b, T> From<Boars<'b, [T], Vec<T>>> for Vec<T>
where
    T: Clone,
    [T]: ToOwned<Owned = Vec<T>>,
    Vec<T>: Clone,
{
    #[inline]
    fn from(x: Boars<'b, [T], Vec<T>>) -> Self {
        x.into_owned()
    }
}

impl<'b, K, V, S> From<HashMap<K, V, S>> for Boars<'b, HashMap<K, V, S>> {
    #[inline]
    fn from(x: HashMap<K, V, S>) -> Self {
        Self::Owned(x)
    }
}

impl<'b> From<String> for Boars<'b, str, String> {
    #[inline]
    fn from(x: String) -> Self {
        Self::Owned(x)
    }
}

impl<'b> From<Boars<'b, str, String>> for String {
    #[inline]
    fn from(x: Boars<'b, str, String>) -> Self {
        x.into_owned()
    }
}

impl<'b> From<CString> for Boars<'b, CStr, CString> {
    #[inline]
    fn from(x: CString) -> Self {
        Self::Owned(x)
    }
}

impl<'b> From<Boars<'b, CStr, CString>> for CString {
    #[inline]
    fn from(x: Boars<'b, CStr, CString>) -> Self {
        x.into_owned()
    }
}

impl<'b> From<OsString> for Boars<'b, OsStr, OsString> {
    #[inline]
    fn from(x: OsString) -> Self {
        Self::Owned(x)
    }
}

impl<'b> From<Boars<'b, OsStr, OsString>> for OsString {
    #[inline]
    fn from(x: Boars<'b, OsStr, OsString>) -> Self {
        x.into_owned()
    }
}

impl<'b> From<PathBuf> for Boars<'b, Path, PathBuf> {
    #[inline]
    fn from(x: PathBuf) -> Self {
        Self::Owned(x)
    }
}

impl<'b> From<Boars<'b, Path, PathBuf>> for PathBuf {
    #[inline]
    fn from(x: Boars<'b, Path, PathBuf>) -> Self {
        x.into_owned()
    }
}

impl<'b, B, O, S, T, const N: usize> From<[T; N]> for Boars<'b, B, O, S>
where
    B: ?Sized,
    O: From<[T; N]>,
    S: ?Sized,
{
    #[inline]
    fn from(x: [T; N]) -> Self {
        Self::Owned(x.into())
    }
}
