# boa-unicode

`boa-unicode` defines the trait to provide methods for querying properties or classes for Unicode identifiers. These properties are used to determine if a code point (char) is valid for being the start/part of an identifier in lexer and parser.

Current version: Unicode 13.0.0

## Development

The Unicode character tables used to query properties are generated by `build_tables.js`. This script depends on [Node.js](https://nodejs.org/en/) and [rustfmt](https://github.com/rust-lang/rustfmt). You can run the script with:

```
$ node build_tables.js
```

or with [npm](https://www.npmjs.com/):

```
$ npm run build-tables
```

The configurations are defined as constants in the script. Please check the comments in `build_tables.js` for more information.

## More Info

- [Unicode® Standard Annex #31 - UNICODE IDENTIFIER AND PATTERN SYNTAX](https://unicode.org/reports/tr31/)
- [Unicode® Standard Annex #44 - UNICODE CHARACTER DATABASE](https://unicode.org/reports/tr44/)
