use std::fmt;
//pub const ERR_CHANNEL_BROKEN: &str = "channel broken";

// use tokio::time::timeout instead
//#[macro_export]
//macro_rules! safe_await {
//($fut: expr, $timeout: expr) => {{
//let (tx, mut rx) = tokio::sync::mpsc::channel(2);
//let txg = tx.clone();
//let f = task::spawn(async move {
//let result = $fut.await;
//let _ = tx.send(Some(result)).await;
//});
//let guard = tokio::task::spawn(async move {
//tokio::time::sleep($timeout).await;
//let _ = txg.send(None).await;
//});
//let result = rx.recv().await;
//f.abort();
//guard.abort();
//match result {
//Some(v) => match v {
//Some(v) => Ok(v),
//None => Err(bmart::Error::timeout()),
//},
//None => Err(bmart::Error::internal(bmart::ERR_CHANNEL_BROKEN)),
//}
//}};
//}

#[macro_export]
macro_rules! worker {
    ($target: expr, $($arg:tt)+) => {{
        let trigger = std::sync::Arc::new(tokio::sync::Notify::new());
        let tc = trigger.clone();
        let fut = tokio::task::spawn(async move {
            loop {
                tc.notified().await;
                $target($($arg)+).await;
            }
        });
        (trigger, fut)
    }};
    ($target: expr) => {{
        let trigger = std::sync::Arc::new(tokio::sync::Notify::new());
        let tc = trigger.clone();
        let fut = tokio::task::spawn(async move {
        loop {
        tc.notified().await;
        $target().await;
        }
        });
        (trigger, fut)
        }};
}

#[derive(Debug, Eq, PartialEq)]
pub enum ErrorKind {
    Duplicate,
    NotFound,
    Timeout,
    InternalError,
}

#[derive(Debug)]
pub struct Error {
    pub kind: ErrorKind,
    pub message: Option<String>,
}

#[allow(clippy::must_use_candidate)]
impl Error {
    pub fn duplicate<T: fmt::Display>(message: T) -> Self {
        Self {
            kind: ErrorKind::Duplicate,
            message: Some(message.to_string()),
        }
    }
    pub fn not_found<T: fmt::Display>(message: T) -> Self {
        Self {
            kind: ErrorKind::NotFound,
            message: Some(message.to_string()),
        }
    }
    pub fn timeout() -> Self {
        Self {
            kind: ErrorKind::Timeout,
            message: None,
        }
    }
    pub fn internal<T: fmt::Display>(message: T) -> Self {
        Self {
            kind: ErrorKind::InternalError,
            message: Some(message.to_string()),
        }
    }
}

#[path = "mpsc.rs"]
pub mod mpsc;
#[path = "process.rs"]
pub mod process;
#[path = "sync.rs"]
pub mod sync;
#[path = "workers.rs"]
pub mod workers;
