
# BluOS API wrappers for Rust

These are ergonomic wrappers around the [BluOS semi-documented API](https://bluos.net/wp-content/uploads/2021/03/Custom-Integration-API-v1.0_March-2021.pdf). It ships with discovery using mDNS so you do not have to mess with finding out what the IP is for your BluOS device.

Why would you want this in Rust? Doesn't it make more sense to do something like this in Python or Node? Who would ever use this in Rust? **GOOD QUESTIONS OFTEN LACKS GOOD ANSWERS**

```rust
use anyhow::Result;
use bluos_api_rs::{BluOS, Discovery};

#[tokio::main]
async fn main() -> Result<()> {
    // Find the first device in our network
    let device = Discovery::discover_one().await?;

    // Create a new BluOS device from the discovered address
    let bluos = BluOS::new_from_discovered(device)?;

    // Print the status
    let status = bluos.status().await?;
    dbg!(status);

    // List items in the play queue
    let playlist = bluos.queue(None).await?;
    for n in playlist.entries {
        println!("{}", n.title.unwrap_or_default());
    }

    // Resume playback
    bluos.play().await?;
    
    Ok(())
}
```

If you don't want Discovery & Tokio you can disable the `discover` feature.