#!/bin/sh

set -xe

export RUST_BACKTRACE=1

# Enables additional cpu-specific optimizations.
export RUSTFLAGS="-D warnings -C target-cpu=native"

cargo clippy --tests --examples --benches -- --deny clippy::all
cargo clippy --all-features --tests --examples --benches -- --deny clippy::all
cargo fmt -- --check
cargo test
cargo test --all-features
cargo test --release
cargo test --all-features --release
cargo doc
cargo deadlinks --dir target/doc/blsttc/
cargo audit
