pub struct Point {
  pub x: i32,
  pub y: i32,
}

impl Point {
  pub fn new(x: i32, y: i32) -> Point {
    Point { x: x, y: y }
  }

  pub fn add(&self, other: &Point) -> Point {
    Point {
      x: self.x + other.x,
      y: self.y + other.y,
    }
  }

  pub fn sub(&self, other: &Point) -> Point {
    Point {
      x: self.x - other.x,
      y: self.y - other.y,
    }
  }

  pub fn equals(&self, other: &Point) -> bool {
    self.x == other.x && self.y == other.y
  }
}
