#[derive(Debug, Clone)]
pub struct MiningInfo {
  pub blocks: u32,
  pub difficulty: f64,
  pub networkhashps: u64,
  pub pooledtx: u32,
  pub chain: String,
  pub warnings: String
}

impl MiningInfo {
  pub fn new(json_str: &str) -> MiningInfo {
    let json_val = json::parse(json_str).unwrap();

    return MiningInfo {
      blocks: json_val["blocks"].as_u32().unwrap(),
      difficulty: json_val["difficulty"].as_f64().unwrap(),
      networkhashps: (json_val["networkhashps"].as_number().unwrap())
        .as_parts()
        .1,
      pooledtx: json_val["pooledtx"].as_u32().unwrap(),
      chain: String::from(json_val["chain"].as_str().unwrap()),
      warnings: String::from(json_val["warnings"].as_str().unwrap())
    };
  }
}
