#[derive(Debug, Clone)]
pub struct MempoolInfo {
  pub loaded: bool,
  pub size: u32,
  pub bytes: u32,
  pub usage: u32,
  pub total_fee: f32,
  pub maxmempool: u32,
  pub mempoolminfee: f32,
  pub minrelaytxfee: f32,
  pub unbroadcastcount: u32
}

impl MempoolInfo {
  pub fn new(json_str: &str) -> MempoolInfo {
    let json_val = json::parse(json_str).unwrap();

    return MempoolInfo {
      loaded: json_val["loaded"].as_bool().unwrap(),
      size: json_val["size"].as_u32().unwrap(),
      bytes: json_val["bytes"].as_u32().unwrap(),
      usage: json_val["usage"].as_u32().unwrap(),
      total_fee: if json_val.has_key("total_fee") {
        json_val["total_fee"].as_f32().unwrap()
      } else {
        0.0
      },
      maxmempool: json_val["maxmempool"].as_u32().unwrap(),
      mempoolminfee: json_val["mempoolminfee"].as_f32().unwrap(),
      minrelaytxfee: json_val["minrelaytxfee"].as_f32().unwrap(),
      unbroadcastcount: json_val["unbroadcastcount"].as_u32().unwrap()
    };
  }
}
