#[derive(Debug, Clone)]
pub struct MempoolFees {
  pub base: f32,
  pub modified: f32,
  pub ancestor: f32,
  pub descendant: f32
}

impl MempoolFees {
  pub fn new(base: f32, modified: f32, ancestor: f32, descendant: f32) -> MempoolFees {
    return MempoolFees {
      base: base,
      modified: modified,
      ancestor: ancestor,
      descendant: descendant
    };
  }
}

#[derive(Debug, Clone)]
pub struct MempoolEntry {
  pub fees: MempoolFees,
  pub vsize: u32,
  pub weight: u32,
  pub fee: f32,
  pub modifiedfee: f32,
  pub time: u32,
  pub height: u32,
  pub descendantcount: u32,
  pub descendantsize: u32,
  pub descendantfees: u32,
  pub ancestorcount: u32,
  pub ancestorsize: u32,
  pub ancestorfees: u32,
  pub wtxid: String,
  pub depends: Vec<String>,
  pub spentby: Vec<String>,
  pub bip125replaceable: bool,
  pub unbroadcast: bool
}

impl MempoolEntry {
  pub fn new(json_str: &str) -> MempoolEntry {
    let json_val = json::parse(json_str).unwrap();

    let mempool_fees = MempoolFees::new(
      json_val["fees"]["base"].as_f32().unwrap(),
      json_val["fees"]["modified"].as_f32().unwrap(),
      json_val["fees"]["ancestor"].as_f32().unwrap(),
      json_val["fees"]["descendant"].as_f32().unwrap()
    );

    return MempoolEntry {
      fees: mempool_fees,
      vsize: json_val["vsize"].as_u32().unwrap(),
      weight: json_val["weight"].as_u32().unwrap(),
      fee: json_val["fee"].as_f32().unwrap(),
      modifiedfee: json_val["modifiedfee"].as_f32().unwrap(),
      time: json_val["time"].as_u32().unwrap(),
      height: json_val["height"].as_u32().unwrap(),
      descendantcount: json_val["descendantcount"].as_u32().unwrap(),
      descendantsize: json_val["descendantsize"].as_u32().unwrap(),
      descendantfees: json_val["descendantfees"].as_u32().unwrap(),
      ancestorcount: json_val["ancestorcount"].as_u32().unwrap(),
      ancestorsize: json_val["ancestorsize"].as_u32().unwrap(),
      ancestorfees: json_val["ancestorfees"].as_u32().unwrap(),
      wtxid: String::from(json_val["wtxid"].as_str().unwrap()),
      depends: json_val["depends"]
        .members()
        .map(|x| String::from(x.as_str().unwrap()))
        .collect(),
      spentby: json_val["spentby"]
        .members()
        .map(|x| String::from(x.as_str().unwrap()))
        .collect(),
      bip125replaceable: json_val["bip125-replaceable"].as_bool().unwrap(),
      unbroadcast: json_val["unbroadcast"].as_bool().unwrap()
    };
  }
}
