#[derive(Debug, Clone)]
pub struct ChainTxStats {
  pub time: u32,
  pub txcount: u32,
  pub window_final_block_hash: String,
  pub window_final_block_height: u32,
  pub window_block_count: u32,
  pub window_tx_count: u32,
  pub window_interval: u32,
  pub txrate: u64
}

impl ChainTxStats {
  pub fn new(json_str: &str) -> ChainTxStats {
    let json_val = json::parse(json_str).unwrap();

    return ChainTxStats {
      time: json_val["time"].as_u32().unwrap(),
      txcount: json_val["txcount"].as_u32().unwrap(),
      window_final_block_hash: String::from(json_val["window_final_block_hash"].as_str().unwrap()),
      window_final_block_height: json_val["window_final_block_height"].as_u32().unwrap(),
      window_block_count: json_val["window_block_count"].as_u32().unwrap(),
      window_tx_count: json_val["window_tx_count"].as_u32().unwrap(),
      window_interval: json_val["window_interval"].as_u32().unwrap(),
      txrate: (json_val["txrate"].as_number().unwrap()).as_parts().1
    };
  }
}
