#[derive(Debug, Clone)]
pub struct Bip9 {
  status: String,
  start_time: u32,
  timeout: u32,
  since: u32,
  min_activation_height: u32
}

impl Bip9 {
  pub fn new(json_obj: &json::JsonValue) -> Bip9 {
    if (json_obj.has_key("bip9")) {
      return Bip9 {
        status: String::from(json_obj["bip9"]["status"].as_str().unwrap()),
        start_time: json_obj["bip9"]["start_time"].as_u32().unwrap(),
        timeout: json_obj["bip9"]["timeout"].as_u32().unwrap(),
        since: json_obj["bip9"]["since"].as_u32().unwrap(),
        min_activation_height: json_obj["bip9"]["min_activation_height"].as_u32().unwrap()
      };
    }

    return Bip9 {
      status: String::from(""),
      start_time: 0,
      timeout: 0,
      since: 0,
      min_activation_height: 0
    };
  }
}

#[derive(Debug, Clone)]
pub struct ForkInfo {
  pub fork_type: String,
  pub active: bool,
  pub height: i32,
  pub bip9: Bip9
}

impl ForkInfo {
  pub fn new(json_obj: &json::JsonValue) -> ForkInfo {
    return ForkInfo {
      fork_type: String::from(json_obj["type"].as_str().unwrap()),
      active: json_obj["active"].as_bool().unwrap(),
      height: if (json_obj.has_key("height")) {
        json_obj["height"].as_i32().unwrap()
      } else {
        -1
      },
      bip9: Bip9::new(&json_obj)
    };
  }
}

#[derive(Debug, Clone)]
pub struct SoftForks {
  pub bip34: ForkInfo,
  pub bip66: ForkInfo,
  pub bip65: ForkInfo,
  pub csv: ForkInfo,
  pub segwit: ForkInfo,
  pub taproot: ForkInfo
}

impl SoftForks {
  pub fn new(json_obj: &json::JsonValue) -> SoftForks {
    return SoftForks {
      bip34: ForkInfo::new(&json_obj["bip34"]),
      bip66: ForkInfo::new(&json_obj["bip66"]),
      bip65: ForkInfo::new(&json_obj["bip65"]),
      csv: ForkInfo::new(&json_obj["csv"]),
      segwit: ForkInfo::new(&json_obj["segwit"]),
      taproot: ForkInfo::new(&json_obj["taproot"])
    };
  }
}

#[derive(Debug, Clone)]
pub struct BlockchainInfo {
  pub chain: String,
  pub blocks: u32,
  pub headers: u32,
  pub bestblockhash: String,
  pub difficulty: f64,
  pub mediantime: u32,
  pub verificationprogress: f64,
  pub initialblockdownload: bool,
  pub chainwork: String,
  pub size_on_disk: u64,
  pub pruned: bool,
  pub softforks: SoftForks,
  pub warnings: String
}

impl BlockchainInfo {
  pub fn new(json_str: &str) -> BlockchainInfo {
    let json_val = json::parse(json_str).unwrap();

    return BlockchainInfo {
      chain: String::from(json_val["chain"].as_str().unwrap()),
      blocks: json_val["blocks"].as_u32().unwrap(),
      headers: json_val["headers"].as_u32().unwrap(),
      bestblockhash: String::from(json_val["bestblockhash"].as_str().unwrap()),
      difficulty: json_val["difficulty"].as_f64().unwrap(),
      mediantime: json_val["mediantime"].as_u32().unwrap(),
      verificationprogress: json_val["verificationprogress"].as_f64().unwrap(),
      initialblockdownload: json_val["initialblockdownload"].as_bool().unwrap(),
      chainwork: String::from(json_val["chainwork"].as_str().unwrap()),
      size_on_disk: json_val["size_on_disk"].as_u64().unwrap(),
      pruned: json_val["pruned"].as_bool().unwrap(),
      softforks: SoftForks::new(&json_val["softforks"]),
      warnings: String::from(json_val["warnings"].as_str().unwrap())
    };
  }
}
