#[derive(Debug, Clone)]
pub struct BlockStats {
  pub avgfee: u32,
  pub avgfeerate: u32,
  pub avgtxsize: u32,
  pub blockhash: String,
  pub feerate_percentiles: Vec<u32>,
  pub height: u32,
  pub ins: u32,
  pub maxfee: u32,
  pub maxfeerate: u32,
  pub maxtxsize: u32,
  pub medianfee: u32,
  pub mediantime: u32,
  pub mediantxsize: u32,
  pub minfee: u32,
  pub minfeerate: u32,
  pub mintxsize: u32,
  pub outs: u32,
  pub subsidy: u64,
  pub swtotal_size: u32,
  pub swtotal_weight: u32,
  pub swtxs: u32,
  pub time: u32,
  pub total_out: u64,
  pub total_size: u32,
  pub total_weight: u32,
  pub totalfee: u32,
  pub txs: u32,
  pub utxo_increase: u32,
  pub utxo_size_inc: u32
}

impl BlockStats {
  pub fn new(json_str: &str) -> BlockStats {
    let json_val = json::parse(json_str).unwrap();

    return BlockStats {
      avgfee: json_val["avgfee"].as_u32().unwrap(),
      avgfeerate: json_val["avgfeerate"].as_u32().unwrap(),
      avgtxsize: json_val["avgtxsize"].as_u32().unwrap(),
      blockhash: String::from(json_val["blockhash"].as_str().unwrap()),
      feerate_percentiles: json_val["feerate_percentiles"]
        .members()
        .map(|x| x.as_u32().unwrap())
        .collect(),
      height: json_val["height"].as_u32().unwrap(),
      ins: json_val["ins"].as_u32().unwrap(),
      maxfee: json_val["maxfee"].as_u32().unwrap(),
      maxfeerate: json_val["maxfeerate"].as_u32().unwrap(),
      maxtxsize: json_val["maxtxsize"].as_u32().unwrap(),
      medianfee: json_val["medianfee"].as_u32().unwrap(),
      mediantime: json_val["mediantime"].as_u32().unwrap(),
      mediantxsize: json_val["mediantxsize"].as_u32().unwrap(),
      minfee: json_val["minfee"].as_u32().unwrap(),
      minfeerate: json_val["minfeerate"].as_u32().unwrap(),
      mintxsize: json_val["mintxsize"].as_u32().unwrap(),
      outs: json_val["outs"].as_u32().unwrap(),
      subsidy: json_val["subsidy"].as_u64().unwrap(),
      swtotal_size: json_val["swtotal_size"].as_u32().unwrap(),
      swtotal_weight: json_val["swtotal_weight"].as_u32().unwrap(),
      swtxs: json_val["swtxs"].as_u32().unwrap(),
      time: json_val["time"].as_u32().unwrap(),
      total_out: json_val["total_out"].as_u64().unwrap(),
      total_size: json_val["total_size"].as_u32().unwrap(),
      total_weight: json_val["total_weight"].as_u32().unwrap(),
      totalfee: json_val["totalfee"].as_u32().unwrap(),
      txs: json_val["txs"].as_u32().unwrap(),
      utxo_increase: json_val["utxo_increase"].as_u32().unwrap(),
      utxo_size_inc: json_val["utxo_size_inc"].as_u32().unwrap()
    };
  }
}
