#[derive(Debug, Clone)]
pub struct BlockHeader {
  pub hash: String,
  pub confirmations: i32,
  pub height: u32,
  pub version: u32,
  pub versionHex: String,
  pub merkleroot: String,
  pub time: u32,
  pub mediantime: u32,
  pub nonce: u32,
  pub bits: String,
  pub difficulty: f64,
  pub chainwork: String,
  pub nTx: u32,
  pub previousblockhash: String,
  pub nextblockhash: String
}

impl BlockHeader {
  pub fn new(json_str: &str) -> BlockHeader {
    let json_val = json::parse(json_str).unwrap();

    return BlockHeader {
      hash: String::from(json_val["hash"].as_str().unwrap()),
      confirmations: json_val["confirmations"].as_i32().unwrap(),
      height: json_val["height"].as_u32().unwrap(),
      version: json_val["version"].as_u32().unwrap(),
      versionHex: String::from(json_val["versionHex"].as_str().unwrap()),
      merkleroot: String::from(json_val["merkleroot"].as_str().unwrap()),
      time: json_val["time"].as_u32().unwrap(),
      mediantime: json_val["mediantime"].as_u32().unwrap(),
      nonce: json_val["nonce"].as_u32().unwrap(),
      bits: String::from(json_val["bits"].as_str().unwrap()),
      difficulty: json_val["difficulty"].as_f64().unwrap(),
      chainwork: String::from(json_val["chainwork"].as_str().unwrap()),
      nTx: json_val["nTx"].as_u32().unwrap(),
      previousblockhash: if json_val.has_key("previousblockhash") {
        String::from(json_val["previousblockhash"].as_str().unwrap())
      } else {
        String::from("")
      },
      nextblockhash: if json_val.has_key("nextblockhash") {
        String::from(json_val["nextblockhash"].as_str().unwrap())
      } else {
        String::from("")
      }
    };
  }
}
