#[derive(Debug, Clone)]
pub struct ValidateAddress {
  pub isvalid: bool,
  pub address: String,
  pub scriptPubKey: String,
  pub isscript: bool,
  pub iswitness: bool,
  pub witness_version: u32,
  pub witness_program: String,
  pub error: String
}

impl ValidateAddress {
  pub fn new(json_str: &str) -> ValidateAddress {
    let json_val = json::parse(json_str).unwrap();

    return ValidateAddress {
      isvalid: if json_val.has_key("isvalid") {
        json_val["isvalid"].as_bool().unwrap()
      } else {
        false
      },
      address: if json_val.has_key("address") {
        String::from(json_val["address"].as_str().unwrap())
      } else {
        String::from("")
      },
      scriptPubKey: if json_val.has_key("scriptPubKey") {
        String::from(json_val["scriptPubKey"].as_str().unwrap())
      } else {
        String::from("")
      },
      isscript: if json_val.has_key("iswitness") {
        json_val["iswitness"].as_bool().unwrap()
      } else {
        false
      },
      iswitness: if json_val.has_key("iswitness") {
        json_val["iswitness"].as_bool().unwrap()
      } else {
        false
      },
      witness_version: if json_val.has_key("witness_version") {
        json_val["witness_version"].as_u32().unwrap()
      } else {
        0
      },
      witness_program: if json_val.has_key("witness_program") {
        String::from(json_val["witness_program"].as_str().unwrap())
      } else {
        String::from("")
      },
      error: if json_val.has_key("error") {
        String::from(json_val["error"].as_str().unwrap())
      } else {
        String::from("")
      }
    };
  }
}
