use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize, Debug)]
pub struct Config {
    pub chains: Vec<Chain>,
}

#[derive(Serialize, Deserialize, Debug)]
pub struct Chain {
    name: String,
    http: String,
    port: u32,
}

#[test]
fn test_config_work() {
    let mut config = Config { chains: Vec::new() };
    config.chains.push(Chain{name: "HECO".to_string(), http: "http://heco.com".to_string(), port: 8080});
    config.chains.push(Chain{name: "BSC".to_string(), http: "http://bsc.com".to_string(), port: 8081});
    let t = toml::to_string_pretty(&config).unwrap();
    println!("{}", t);
}