use serde::{Serialize, Deserialize};

#[tokio::main]
async fn main() -> web3::Result {
    let transport = web3::transports::Http::new("http://localhost:8545")?;
    let web3 = web3::Web3::new(transport);
    let accounts = web3.eth().accounts().await?;
    println!("Accounts: {:?}", accounts);

    for account in accounts{
        let balance = web3.eth().balance(account, None).await?;
        println!("Balance of {:?}: {}", account, balance);
    }
    Ok(())
}

#[test]
fn test_serde(){
    #[derive(Serialize, Deserialize, Debug)]
    struct Point{
        x: i32,
        y: i32,
    }

    let point = Point{x:1, y:2};
    // let serialized = serde_json::to_string(&point).unwrap();
    let rst = toml::to_string(&point).unwrap();
    println!("{}", rst);

}