use bliss_audio::Song;
use std::env;

/**
 * Simple utility to print the result or the field of an Analysis.
 *
 * Takes a list of files to analyze and outputs a field // the result of
 * the corresponding Analysis, depending of what you chose to `println!` below.
 */
fn main() {
    let args: Vec<String> = env::args().skip(1).collect();
    println!("path|tempo|centroid|zcc|rolloff|flatness|loudness|is_major|fifth_0|fifth_1");
    for path in &args {
        match Song::new(&path) {
            Ok(song) => println!(
                "{}|{}",
                path,
                song.analysis
                    .iter()
                    .map(|x| x.to_string())
                    .collect::<Vec<String>>()
                    .join("|"),
            ),
            Err(e) => println!("{}: {}", path, e),
        }
    }
}
