use blend_info::{print_pointer, read_dna, use_dna, DnaStrC};
// std
use std::collections::HashMap;
use std::path::PathBuf;

fn main() -> std::io::Result<()> {
    println!("use_dna");
    // .blend file
    let path: PathBuf = PathBuf::from(r"blend/factory_v279.blend");
    println!("Try to read {:?} file ...", path);
    // read DNA
    let mut dna_types_hm: HashMap<String, u16> = HashMap::new();
    let mut dna_structs_hm: HashMap<String, DnaStrC> = HashMap::new();
    let mut dna_pointers_hm: HashMap<usize, usize> = HashMap::new();
    let mut dna_2_type_id: Vec<u16> = Vec::new();
    let mut types: Vec<String> = Vec::new();
    let mut num_bytes_read: usize = 0;
    let print_dna: bool = false;
    let print_pointers: bool = true;
    read_dna(
        print_dna,
        print_pointers,
        &path,
        &mut dna_types_hm,
        &mut dna_structs_hm,
        &mut dna_pointers_hm,
        &mut dna_2_type_id,
        &mut types,
        &mut num_bytes_read,
    )?;
    println!("{} bytes read by read_dna() ...", num_bytes_read);
    // use DNA
    println!(
        "Try to read {:?} file again (camera/lamp centric this time) ...",
        path
    );
    let print_dna: bool = true;
    let names: Vec<String> = vec!["Camera".to_string(), "Lamp".to_string()];
    let mut bytes_read: Vec<u8> = Vec::with_capacity(num_bytes_read);
    let mut structs_read: Vec<String> = Vec::with_capacity(names.len());
    let mut data_read: Vec<u32> = Vec::with_capacity(names.len());
    let mut pointers_read: Vec<(usize, u32)> = Vec::with_capacity(names.len());
    use_dna(
        print_dna,
        &path,
        &dna_types_hm,
        &dna_structs_hm,
        &names,
        &dna_2_type_id,
        &types,
        &mut bytes_read,
        &mut structs_read,
        &mut data_read,
        &mut pointers_read,
    )?;
    println!("bytes_read: {:?}", bytes_read);
    println!("structs_read: {:?}", structs_read);
    println!("data_read: {:?}", data_read);
    println!("pointers_read: {:?}", pointers_read);
    print!("SDNAnr = {}: ", pointers_read[0].1);
    print_pointer(pointers_read[0].0, &names[0], &dna_pointers_hm);
    print!("SDNAnr = {}: ", pointers_read[1].1);
    print_pointer(pointers_read[1].0, &names[1], &dna_pointers_hm);
    Ok(())
}
