use blend_info::{read_dna, DnaStrC};
// std
use std::collections::HashMap;
use std::path::PathBuf;

fn main() -> std::io::Result<()> {
    println!("read_dna");
    // .blend file
    let path: PathBuf = PathBuf::from(r"blend/factory_v279.blend");
    println!("Try to read {:?} file ...", path);
    // read DNA
    let mut dna_types_hm: HashMap<String, u16> = HashMap::new();
    let mut dna_structs_hm: HashMap<String, DnaStrC> = HashMap::new();
    let mut dna_pointers_hm: HashMap<usize, usize> = HashMap::new();
    let mut dna_2_type_id: Vec<u16> = Vec::new();
    let mut types: Vec<String> = Vec::new();
    let mut num_bytes_read: usize = 0;
    let print_dna: bool = false;
    let print_pointers: bool = false;
    read_dna(
        print_dna,
        print_pointers,
        &path,
        &mut dna_types_hm,
        &mut dna_structs_hm,
        &mut dna_pointers_hm,
        &mut dna_2_type_id,
        &mut types,
        &mut num_bytes_read,
    )?;
    println!("{} {:?}", num_bytes_read, &path);
    Ok(())
}
