use clap::{app_from_crate, AppSettings};
use std::process::exit;

fn main() {
    let app = app_from_crate!()
        .global_setting(AppSettings::PropagateVersion)
        .global_setting(AppSettings::UseLongFormatForHelpSubcommand)
        .arg(
            clap::Arg::new("path")
                .long("path")
                .takes_value(true)
                .value_name("URL")
                .help("URL to check")
                .required(true),
        )
        .get_matches();

    match app.value_of("path") {
        Some(path) => {
            match attohttpc::get(path).send() {
                Ok(resp) => {
                    match resp.is_success() {
                        true => exit(0),
                        false => {
                            eprintln!("Recieved status code {}", resp.status());
                            exit(1);
                        }
                    }
                }
                Err(e) => {
                    println!("{}", e);
                    exit(1);
                }
            }
        }
        None => {
            println!("No URL provided");
            exit(1);
        }
    }
}
