#![doc = "Peripheral access API for BL702 microcontrollers (generated using svd2rust v0.19.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[doc = "glb."]
pub struct GLB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GLB {}
impl GLB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const glb::RegisterBlock = 0x4000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const glb::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GLB {
    type Target = glb::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GLB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GLB").finish()
    }
}
#[doc = "glb."]
pub mod glb;
#[doc = "rf."]
pub struct RF {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RF {}
impl RF {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rf::RegisterBlock = 0x4000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rf::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RF {
    type Target = rf::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RF {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RF").finish()
    }
}
#[doc = "rf."]
pub mod rf;
#[doc = "gpip."]
pub struct GPIP {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIP {}
impl GPIP {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpip::RegisterBlock = 0x4000_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpip::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIP {
    type Target = gpip::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIP {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIP").finish()
    }
}
#[doc = "gpip."]
pub mod gpip;
#[doc = "sec_dbg."]
pub struct SEC_DBG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SEC_DBG {}
impl SEC_DBG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sec_dbg::RegisterBlock = 0x4000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sec_dbg::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SEC_DBG {
    type Target = sec_dbg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SEC_DBG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SEC_DBG").finish()
    }
}
#[doc = "sec_dbg."]
pub mod sec_dbg;
#[doc = "sec_eng."]
pub struct SEC_ENG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SEC_ENG {}
impl SEC_ENG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sec_eng::RegisterBlock = 0x4000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sec_eng::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SEC_ENG {
    type Target = sec_eng::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SEC_ENG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SEC_ENG").finish()
    }
}
#[doc = "sec_eng."]
pub mod sec_eng;
#[doc = "tzc_sec."]
pub struct TZC_SEC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TZC_SEC {}
impl TZC_SEC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tzc_sec::RegisterBlock = 0x4000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tzc_sec::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TZC_SEC {
    type Target = tzc_sec::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TZC_SEC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TZC_SEC").finish()
    }
}
#[doc = "tzc_sec."]
pub mod tzc_sec;
#[doc = "tzc_nsec."]
pub struct TZC_NSEC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TZC_NSEC {}
impl TZC_NSEC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tzc_nsec::RegisterBlock = 0x4000_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tzc_nsec::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TZC_NSEC {
    type Target = tzc_nsec::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TZC_NSEC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TZC_NSEC").finish()
    }
}
#[doc = "tzc_nsec."]
pub mod tzc_nsec;
#[doc = "ef_data_0."]
pub struct EF_DATA_0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EF_DATA_0 {}
impl EF_DATA_0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ef_data_0::RegisterBlock = 0x4000_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ef_data_0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EF_DATA_0 {
    type Target = ef_data_0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EF_DATA_0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EF_DATA_0").finish()
    }
}
#[doc = "ef_data_0."]
pub mod ef_data_0;
#[doc = "ef_data_1."]
pub struct EF_DATA_1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EF_DATA_1 {}
impl EF_DATA_1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ef_data_1::RegisterBlock = 0x4000_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ef_data_1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EF_DATA_1 {
    type Target = ef_data_1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EF_DATA_1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EF_DATA_1").finish()
    }
}
#[doc = "ef_data_1."]
pub mod ef_data_1;
#[doc = "ef_ctrl."]
pub struct EF_CTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EF_CTRL {}
impl EF_CTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ef_ctrl::RegisterBlock = 0x4000_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ef_ctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EF_CTRL {
    type Target = ef_ctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EF_CTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EF_CTRL").finish()
    }
}
#[doc = "ef_ctrl."]
pub mod ef_ctrl;
#[doc = "cci."]
pub struct CCI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CCI {}
impl CCI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cci::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cci::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CCI {
    type Target = cci::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CCI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CCI").finish()
    }
}
#[doc = "cci."]
pub mod cci;
#[doc = "l1c."]
pub struct L1C {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for L1C {}
impl L1C {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const l1c::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const l1c::RegisterBlock {
        Self::PTR
    }
}
impl Deref for L1C {
    type Target = l1c::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for L1C {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("L1C").finish()
    }
}
#[doc = "l1c."]
pub mod l1c;
#[doc = "uart."]
pub struct UART {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART {}
impl UART {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart::RegisterBlock = 0x4000_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART {
    type Target = uart::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART").finish()
    }
}
#[doc = "uart."]
pub mod uart;
#[doc = "spi."]
pub struct SPI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI {}
impl SPI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi::RegisterBlock = 0x4000_a200 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI {
    type Target = spi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI").finish()
    }
}
#[doc = "spi."]
pub mod spi;
#[doc = "i2c."]
pub struct I2C {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C {}
impl I2C {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c::RegisterBlock = 0x4000_a300 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C {
    type Target = i2c::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C").finish()
    }
}
#[doc = "i2c."]
pub mod i2c;
#[doc = "pwm."]
pub struct PWM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM {}
impl PWM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm::RegisterBlock = 0x4000_a400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM {
    type Target = pwm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM").finish()
    }
}
#[doc = "pwm."]
pub mod pwm;
#[doc = "timer."]
pub struct TIMER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER {}
impl TIMER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer::RegisterBlock = 0x4000_a500 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER {
    type Target = timer::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER").finish()
    }
}
#[doc = "timer."]
pub mod timer;
#[doc = "ir."]
pub struct IR {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IR {}
impl IR {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ir::RegisterBlock = 0x4000_a600 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ir::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IR {
    type Target = ir::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IR {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IR").finish()
    }
}
#[doc = "ir."]
pub mod ir;
#[doc = "cks."]
pub struct CKS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CKS {}
impl CKS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cks::RegisterBlock = 0x4000_a700 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cks::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CKS {
    type Target = cks::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CKS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CKS").finish()
    }
}
#[doc = "cks."]
pub mod cks;
#[doc = "qdec."]
pub struct QDEC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for QDEC {}
impl QDEC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const qdec::RegisterBlock = 0x4000_a800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const qdec::RegisterBlock {
        Self::PTR
    }
}
impl Deref for QDEC {
    type Target = qdec::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for QDEC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("QDEC").finish()
    }
}
#[doc = "qdec."]
pub mod qdec;
#[doc = "kys."]
pub struct KYS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for KYS {}
impl KYS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const kys::RegisterBlock = 0x4000_ab00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const kys::RegisterBlock {
        Self::PTR
    }
}
impl Deref for KYS {
    type Target = kys::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for KYS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("KYS").finish()
    }
}
#[doc = "kys."]
pub mod kys;
#[doc = "i2s."]
pub struct I2S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S {}
impl I2S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s::RegisterBlock = 0x4000_aa00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S {
    type Target = i2s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S").finish()
    }
}
#[doc = "i2s."]
pub mod i2s;
#[doc = "cam."]
pub struct CAM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CAM {}
impl CAM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cam::RegisterBlock = 0x4000_ad00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cam::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CAM {
    type Target = cam::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CAM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CAM").finish()
    }
}
#[doc = "cam."]
pub mod cam;
#[doc = "mjpeg."]
pub struct MJPEG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MJPEG {}
impl MJPEG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mjpeg::RegisterBlock = 0x4000_ae00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mjpeg::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MJPEG {
    type Target = mjpeg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MJPEG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MJPEG").finish()
    }
}
#[doc = "mjpeg."]
pub mod mjpeg;
#[doc = "sf_ctrl."]
pub struct SF_CTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SF_CTRL {}
impl SF_CTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sf_ctrl::RegisterBlock = 0x4000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sf_ctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SF_CTRL {
    type Target = sf_ctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SF_CTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SF_CTRL").finish()
    }
}
#[doc = "sf_ctrl."]
pub mod sf_ctrl;
#[doc = "dma."]
pub struct DMA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA {}
impl DMA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dma::RegisterBlock = 0x4000_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dma::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMA {
    type Target = dma::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMA").finish()
    }
}
#[doc = "dma."]
pub mod dma;
#[doc = "emac."]
pub struct EMAC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EMAC {}
impl EMAC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const emac::RegisterBlock = 0x4000_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const emac::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EMAC {
    type Target = emac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EMAC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EMAC").finish()
    }
}
#[doc = "emac."]
pub mod emac;
#[doc = "usb."]
pub struct USB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB {}
impl USB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb::RegisterBlock = 0x4000_d800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB {
    type Target = usb::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB").finish()
    }
}
#[doc = "usb."]
pub mod usb;
#[doc = "pds."]
pub struct PDS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PDS {}
impl PDS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pds::RegisterBlock = 0x4000_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pds::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PDS {
    type Target = pds::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PDS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PDS").finish()
    }
}
#[doc = "pds."]
pub mod pds;
#[doc = "HBN."]
pub struct HBN {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for HBN {}
impl HBN {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const hbn::RegisterBlock = 0x4000_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const hbn::RegisterBlock {
        Self::PTR
    }
}
impl Deref for HBN {
    type Target = hbn::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for HBN {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("HBN").finish()
    }
}
#[doc = "HBN."]
pub mod hbn;
#[doc = "AON."]
pub struct AON {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for AON {}
impl AON {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const aon::RegisterBlock = 0x4000_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const aon::RegisterBlock {
        Self::PTR
    }
}
impl Deref for AON {
    type Target = aon::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for AON {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("AON").finish()
    }
}
#[doc = "AON."]
pub mod aon;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "GLB"]
    pub GLB: GLB,
    #[doc = "RF"]
    pub RF: RF,
    #[doc = "GPIP"]
    pub GPIP: GPIP,
    #[doc = "SEC_DBG"]
    pub SEC_DBG: SEC_DBG,
    #[doc = "SEC_ENG"]
    pub SEC_ENG: SEC_ENG,
    #[doc = "TZC_SEC"]
    pub TZC_SEC: TZC_SEC,
    #[doc = "TZC_NSEC"]
    pub TZC_NSEC: TZC_NSEC,
    #[doc = "EF_DATA_0"]
    pub EF_DATA_0: EF_DATA_0,
    #[doc = "EF_DATA_1"]
    pub EF_DATA_1: EF_DATA_1,
    #[doc = "EF_CTRL"]
    pub EF_CTRL: EF_CTRL,
    #[doc = "CCI"]
    pub CCI: CCI,
    #[doc = "L1C"]
    pub L1C: L1C,
    #[doc = "UART"]
    pub UART: UART,
    #[doc = "SPI"]
    pub SPI: SPI,
    #[doc = "I2C"]
    pub I2C: I2C,
    #[doc = "PWM"]
    pub PWM: PWM,
    #[doc = "TIMER"]
    pub TIMER: TIMER,
    #[doc = "IR"]
    pub IR: IR,
    #[doc = "CKS"]
    pub CKS: CKS,
    #[doc = "QDEC"]
    pub QDEC: QDEC,
    #[doc = "KYS"]
    pub KYS: KYS,
    #[doc = "I2S"]
    pub I2S: I2S,
    #[doc = "CAM"]
    pub CAM: CAM,
    #[doc = "MJPEG"]
    pub MJPEG: MJPEG,
    #[doc = "SF_CTRL"]
    pub SF_CTRL: SF_CTRL,
    #[doc = "DMA"]
    pub DMA: DMA,
    #[doc = "EMAC"]
    pub EMAC: EMAC,
    #[doc = "USB"]
    pub USB: USB,
    #[doc = "PDS"]
    pub PDS: PDS,
    #[doc = "HBN"]
    pub HBN: HBN,
    #[doc = "AON"]
    pub AON: AON,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        riscv::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            GLB: GLB {
                _marker: PhantomData,
            },
            RF: RF {
                _marker: PhantomData,
            },
            GPIP: GPIP {
                _marker: PhantomData,
            },
            SEC_DBG: SEC_DBG {
                _marker: PhantomData,
            },
            SEC_ENG: SEC_ENG {
                _marker: PhantomData,
            },
            TZC_SEC: TZC_SEC {
                _marker: PhantomData,
            },
            TZC_NSEC: TZC_NSEC {
                _marker: PhantomData,
            },
            EF_DATA_0: EF_DATA_0 {
                _marker: PhantomData,
            },
            EF_DATA_1: EF_DATA_1 {
                _marker: PhantomData,
            },
            EF_CTRL: EF_CTRL {
                _marker: PhantomData,
            },
            CCI: CCI {
                _marker: PhantomData,
            },
            L1C: L1C {
                _marker: PhantomData,
            },
            UART: UART {
                _marker: PhantomData,
            },
            SPI: SPI {
                _marker: PhantomData,
            },
            I2C: I2C {
                _marker: PhantomData,
            },
            PWM: PWM {
                _marker: PhantomData,
            },
            TIMER: TIMER {
                _marker: PhantomData,
            },
            IR: IR {
                _marker: PhantomData,
            },
            CKS: CKS {
                _marker: PhantomData,
            },
            QDEC: QDEC {
                _marker: PhantomData,
            },
            KYS: KYS {
                _marker: PhantomData,
            },
            I2S: I2S {
                _marker: PhantomData,
            },
            CAM: CAM {
                _marker: PhantomData,
            },
            MJPEG: MJPEG {
                _marker: PhantomData,
            },
            SF_CTRL: SF_CTRL {
                _marker: PhantomData,
            },
            DMA: DMA {
                _marker: PhantomData,
            },
            EMAC: EMAC {
                _marker: PhantomData,
            },
            USB: USB {
                _marker: PhantomData,
            },
            PDS: PDS {
                _marker: PhantomData,
            },
            HBN: HBN {
                _marker: PhantomData,
            },
            AON: AON {
                _marker: PhantomData,
            },
        }
    }
}
