/*
    memory-bl702.x: declares all memory regions in BL702 SoC.
    This .x file is not intended to use alone. You should use together with
    the riscv-rust's `riscv-rt` universal RISC-V bare-metal runtime for Rust.
    To use this file, you may add it to `cargo/config.toml` like `-Tmemory-bl702.x`.
    Or include with `INCLUDE memory-bl702.x` then define your own memory configuration,
    e.g. run program in RAM or other possible values.
*/


_max_hart_id = 0;

MEMORY
{
    // ROM   (rxai!w) : ORIGIN = 0x21015000, LENGTH = 44K

    // it says 8MB flash
    FLASH (rxai!w) : ORIGIN = 0x23000000, LENGTH = 512K
    // ~~FLASH (rxai!w) : ORIGIN = 0x23000000, LENGTH = 2M~~
    // ITCM: 0x22010000 + 16KB, cannot use for RAM??
    // DTCM: 0x22014000 + 48KB, use
    // OCRAM: 0x22020000 + 64KB
    // total: 128KB
    //

    // 0x42018000 to 0x22020000: 32K
    RAM_TCM (wxa) : ORIGIN = 0x42018000, LENGTH = 96K
}

/*
    BL702's memory is remapped into many addresses.
    e.g. TCM is mapped to 0x22008000, 0x32008000, 0x42008000 and 0x52008000.
*/

REGION_ALIAS("REGION_TEXT", FLASH);
REGION_ALIAS("REGION_RODATA", FLASH);
REGION_ALIAS("REGION_DATA", RAM_TCM);
REGION_ALIAS("REGION_BSS", RAM_TCM);
REGION_ALIAS("REGION_HEAP", RAM_TCM);
REGION_ALIAS("REGION_STACK", RAM_TCM);
