/* automatically generated by rust-bindgen 0.58.1 */

use
super::*;

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const UART_UTX_CONFIG_OFFSET: u32 = 0;
pub const UART_CR_UTX_EN_POS: u32 = 0;
pub const UART_CR_UTX_EN_LEN: u32 = 1;
pub const UART_CR_UTX_EN_MSK: u32 = 1;
pub const UART_CR_UTX_EN_UMSK: i32 = -2;
pub const UART_CR_UTX_CTS_EN_POS: u32 = 1;
pub const UART_CR_UTX_CTS_EN_LEN: u32 = 1;
pub const UART_CR_UTX_CTS_EN_MSK: u32 = 2;
pub const UART_CR_UTX_CTS_EN_UMSK: i32 = -3;
pub const UART_CR_UTX_FRM_EN_POS: u32 = 2;
pub const UART_CR_UTX_FRM_EN_LEN: u32 = 1;
pub const UART_CR_UTX_FRM_EN_MSK: u32 = 4;
pub const UART_CR_UTX_FRM_EN_UMSK: i32 = -5;
pub const UART_CR_UTX_PRT_EN_POS: u32 = 4;
pub const UART_CR_UTX_PRT_EN_LEN: u32 = 1;
pub const UART_CR_UTX_PRT_EN_MSK: u32 = 16;
pub const UART_CR_UTX_PRT_EN_UMSK: i32 = -17;
pub const UART_CR_UTX_PRT_SEL_POS: u32 = 5;
pub const UART_CR_UTX_PRT_SEL_LEN: u32 = 1;
pub const UART_CR_UTX_PRT_SEL_MSK: u32 = 32;
pub const UART_CR_UTX_PRT_SEL_UMSK: i32 = -33;
pub const UART_CR_UTX_IR_EN_POS: u32 = 6;
pub const UART_CR_UTX_IR_EN_LEN: u32 = 1;
pub const UART_CR_UTX_IR_EN_MSK: u32 = 64;
pub const UART_CR_UTX_IR_EN_UMSK: i32 = -65;
pub const UART_CR_UTX_IR_INV_POS: u32 = 7;
pub const UART_CR_UTX_IR_INV_LEN: u32 = 1;
pub const UART_CR_UTX_IR_INV_MSK: u32 = 128;
pub const UART_CR_UTX_IR_INV_UMSK: i32 = -129;
pub const UART_CR_UTX_BIT_CNT_D_POS: u32 = 8;
pub const UART_CR_UTX_BIT_CNT_D_LEN: u32 = 3;
pub const UART_CR_UTX_BIT_CNT_D_MSK: u32 = 1792;
pub const UART_CR_UTX_BIT_CNT_D_UMSK: i32 = -1793;
pub const UART_CR_UTX_BIT_CNT_P_POS: u32 = 12;
pub const UART_CR_UTX_BIT_CNT_P_LEN: u32 = 2;
pub const UART_CR_UTX_BIT_CNT_P_MSK: u32 = 12288;
pub const UART_CR_UTX_BIT_CNT_P_UMSK: i32 = -12289;
pub const UART_CR_UTX_LEN_POS: u32 = 16;
pub const UART_CR_UTX_LEN_LEN: u32 = 16;
pub const UART_CR_UTX_LEN_MSK: u32 = 4294901760;
pub const UART_CR_UTX_LEN_UMSK: i64 = -4294901761;
pub const UART_URX_CONFIG_OFFSET: u32 = 4;
pub const UART_CR_URX_EN_POS: u32 = 0;
pub const UART_CR_URX_EN_LEN: u32 = 1;
pub const UART_CR_URX_EN_MSK: u32 = 1;
pub const UART_CR_URX_EN_UMSK: i32 = -2;
pub const UART_CR_URX_RTS_SW_MODE_POS: u32 = 1;
pub const UART_CR_URX_RTS_SW_MODE_LEN: u32 = 1;
pub const UART_CR_URX_RTS_SW_MODE_MSK: u32 = 2;
pub const UART_CR_URX_RTS_SW_MODE_UMSK: i32 = -3;
pub const UART_CR_URX_RTS_SW_VAL_POS: u32 = 2;
pub const UART_CR_URX_RTS_SW_VAL_LEN: u32 = 1;
pub const UART_CR_URX_RTS_SW_VAL_MSK: u32 = 4;
pub const UART_CR_URX_RTS_SW_VAL_UMSK: i32 = -5;
pub const UART_CR_URX_ABR_EN_POS: u32 = 3;
pub const UART_CR_URX_ABR_EN_LEN: u32 = 1;
pub const UART_CR_URX_ABR_EN_MSK: u32 = 8;
pub const UART_CR_URX_ABR_EN_UMSK: i32 = -9;
pub const UART_CR_URX_PRT_EN_POS: u32 = 4;
pub const UART_CR_URX_PRT_EN_LEN: u32 = 1;
pub const UART_CR_URX_PRT_EN_MSK: u32 = 16;
pub const UART_CR_URX_PRT_EN_UMSK: i32 = -17;
pub const UART_CR_URX_PRT_SEL_POS: u32 = 5;
pub const UART_CR_URX_PRT_SEL_LEN: u32 = 1;
pub const UART_CR_URX_PRT_SEL_MSK: u32 = 32;
pub const UART_CR_URX_PRT_SEL_UMSK: i32 = -33;
pub const UART_CR_URX_IR_EN_POS: u32 = 6;
pub const UART_CR_URX_IR_EN_LEN: u32 = 1;
pub const UART_CR_URX_IR_EN_MSK: u32 = 64;
pub const UART_CR_URX_IR_EN_UMSK: i32 = -65;
pub const UART_CR_URX_IR_INV_POS: u32 = 7;
pub const UART_CR_URX_IR_INV_LEN: u32 = 1;
pub const UART_CR_URX_IR_INV_MSK: u32 = 128;
pub const UART_CR_URX_IR_INV_UMSK: i32 = -129;
pub const UART_CR_URX_BIT_CNT_D_POS: u32 = 8;
pub const UART_CR_URX_BIT_CNT_D_LEN: u32 = 3;
pub const UART_CR_URX_BIT_CNT_D_MSK: u32 = 1792;
pub const UART_CR_URX_BIT_CNT_D_UMSK: i32 = -1793;
pub const UART_CR_URX_DEG_EN_POS: u32 = 11;
pub const UART_CR_URX_DEG_EN_LEN: u32 = 1;
pub const UART_CR_URX_DEG_EN_MSK: u32 = 2048;
pub const UART_CR_URX_DEG_EN_UMSK: i32 = -2049;
pub const UART_CR_URX_DEG_CNT_POS: u32 = 12;
pub const UART_CR_URX_DEG_CNT_LEN: u32 = 4;
pub const UART_CR_URX_DEG_CNT_MSK: u32 = 61440;
pub const UART_CR_URX_DEG_CNT_UMSK: i32 = -61441;
pub const UART_CR_URX_LEN_POS: u32 = 16;
pub const UART_CR_URX_LEN_LEN: u32 = 16;
pub const UART_CR_URX_LEN_MSK: u32 = 4294901760;
pub const UART_CR_URX_LEN_UMSK: i64 = -4294901761;
pub const UART_BIT_PRD_OFFSET: u32 = 8;
pub const UART_CR_UTX_BIT_PRD_POS: u32 = 0;
pub const UART_CR_UTX_BIT_PRD_LEN: u32 = 16;
pub const UART_CR_UTX_BIT_PRD_MSK: u32 = 65535;
pub const UART_CR_UTX_BIT_PRD_UMSK: i32 = -65536;
pub const UART_CR_URX_BIT_PRD_POS: u32 = 16;
pub const UART_CR_URX_BIT_PRD_LEN: u32 = 16;
pub const UART_CR_URX_BIT_PRD_MSK: u32 = 4294901760;
pub const UART_CR_URX_BIT_PRD_UMSK: i64 = -4294901761;
pub const UART_DATA_CONFIG_OFFSET: u32 = 12;
pub const UART_CR_UART_BIT_INV_POS: u32 = 0;
pub const UART_CR_UART_BIT_INV_LEN: u32 = 1;
pub const UART_CR_UART_BIT_INV_MSK: u32 = 1;
pub const UART_CR_UART_BIT_INV_UMSK: i32 = -2;
pub const UART_UTX_IR_POSITION_OFFSET: u32 = 16;
pub const UART_CR_UTX_IR_POS_S_POS: u32 = 0;
pub const UART_CR_UTX_IR_POS_S_LEN: u32 = 16;
pub const UART_CR_UTX_IR_POS_S_MSK: u32 = 65535;
pub const UART_CR_UTX_IR_POS_S_UMSK: i32 = -65536;
pub const UART_CR_UTX_IR_POS_P_POS: u32 = 16;
pub const UART_CR_UTX_IR_POS_P_LEN: u32 = 16;
pub const UART_CR_UTX_IR_POS_P_MSK: u32 = 4294901760;
pub const UART_CR_UTX_IR_POS_P_UMSK: i64 = -4294901761;
pub const UART_URX_IR_POSITION_OFFSET: u32 = 20;
pub const UART_CR_URX_IR_POS_S_POS: u32 = 0;
pub const UART_CR_URX_IR_POS_S_LEN: u32 = 16;
pub const UART_CR_URX_IR_POS_S_MSK: u32 = 65535;
pub const UART_CR_URX_IR_POS_S_UMSK: i32 = -65536;
pub const UART_URX_RTO_TIMER_OFFSET: u32 = 24;
pub const UART_CR_URX_RTO_VALUE_POS: u32 = 0;
pub const UART_CR_URX_RTO_VALUE_LEN: u32 = 8;
pub const UART_CR_URX_RTO_VALUE_MSK: u32 = 255;
pub const UART_CR_URX_RTO_VALUE_UMSK: i32 = -256;
pub const UART_INT_STS_OFFSET: u32 = 32;
pub const UART_UTX_END_INT_POS: u32 = 0;
pub const UART_UTX_END_INT_LEN: u32 = 1;
pub const UART_UTX_END_INT_MSK: u32 = 1;
pub const UART_UTX_END_INT_UMSK: i32 = -2;
pub const UART_URX_END_INT_POS: u32 = 1;
pub const UART_URX_END_INT_LEN: u32 = 1;
pub const UART_URX_END_INT_MSK: u32 = 2;
pub const UART_URX_END_INT_UMSK: i32 = -3;
pub const UART_UTX_FIFO_INT_POS: u32 = 2;
pub const UART_UTX_FIFO_INT_LEN: u32 = 1;
pub const UART_UTX_FIFO_INT_MSK: u32 = 4;
pub const UART_UTX_FIFO_INT_UMSK: i32 = -5;
pub const UART_URX_FIFO_INT_POS: u32 = 3;
pub const UART_URX_FIFO_INT_LEN: u32 = 1;
pub const UART_URX_FIFO_INT_MSK: u32 = 8;
pub const UART_URX_FIFO_INT_UMSK: i32 = -9;
pub const UART_URX_RTO_INT_POS: u32 = 4;
pub const UART_URX_RTO_INT_LEN: u32 = 1;
pub const UART_URX_RTO_INT_MSK: u32 = 16;
pub const UART_URX_RTO_INT_UMSK: i32 = -17;
pub const UART_URX_PCE_INT_POS: u32 = 5;
pub const UART_URX_PCE_INT_LEN: u32 = 1;
pub const UART_URX_PCE_INT_MSK: u32 = 32;
pub const UART_URX_PCE_INT_UMSK: i32 = -33;
pub const UART_UTX_FER_INT_POS: u32 = 6;
pub const UART_UTX_FER_INT_LEN: u32 = 1;
pub const UART_UTX_FER_INT_MSK: u32 = 64;
pub const UART_UTX_FER_INT_UMSK: i32 = -65;
pub const UART_URX_FER_INT_POS: u32 = 7;
pub const UART_URX_FER_INT_LEN: u32 = 1;
pub const UART_URX_FER_INT_MSK: u32 = 128;
pub const UART_URX_FER_INT_UMSK: i32 = -129;
pub const UART_INT_MASK_OFFSET: u32 = 36;
pub const UART_CR_UTX_END_MASK_POS: u32 = 0;
pub const UART_CR_UTX_END_MASK_LEN: u32 = 1;
pub const UART_CR_UTX_END_MASK_MSK: u32 = 1;
pub const UART_CR_UTX_END_MASK_UMSK: i32 = -2;
pub const UART_CR_URX_END_MASK_POS: u32 = 1;
pub const UART_CR_URX_END_MASK_LEN: u32 = 1;
pub const UART_CR_URX_END_MASK_MSK: u32 = 2;
pub const UART_CR_URX_END_MASK_UMSK: i32 = -3;
pub const UART_CR_UTX_FIFO_MASK_POS: u32 = 2;
pub const UART_CR_UTX_FIFO_MASK_LEN: u32 = 1;
pub const UART_CR_UTX_FIFO_MASK_MSK: u32 = 4;
pub const UART_CR_UTX_FIFO_MASK_UMSK: i32 = -5;
pub const UART_CR_URX_FIFO_MASK_POS: u32 = 3;
pub const UART_CR_URX_FIFO_MASK_LEN: u32 = 1;
pub const UART_CR_URX_FIFO_MASK_MSK: u32 = 8;
pub const UART_CR_URX_FIFO_MASK_UMSK: i32 = -9;
pub const UART_CR_URX_RTO_MASK_POS: u32 = 4;
pub const UART_CR_URX_RTO_MASK_LEN: u32 = 1;
pub const UART_CR_URX_RTO_MASK_MSK: u32 = 16;
pub const UART_CR_URX_RTO_MASK_UMSK: i32 = -17;
pub const UART_CR_URX_PCE_MASK_POS: u32 = 5;
pub const UART_CR_URX_PCE_MASK_LEN: u32 = 1;
pub const UART_CR_URX_PCE_MASK_MSK: u32 = 32;
pub const UART_CR_URX_PCE_MASK_UMSK: i32 = -33;
pub const UART_CR_UTX_FER_MASK_POS: u32 = 6;
pub const UART_CR_UTX_FER_MASK_LEN: u32 = 1;
pub const UART_CR_UTX_FER_MASK_MSK: u32 = 64;
pub const UART_CR_UTX_FER_MASK_UMSK: i32 = -65;
pub const UART_CR_URX_FER_MASK_POS: u32 = 7;
pub const UART_CR_URX_FER_MASK_LEN: u32 = 1;
pub const UART_CR_URX_FER_MASK_MSK: u32 = 128;
pub const UART_CR_URX_FER_MASK_UMSK: i32 = -129;
pub const UART_INT_CLEAR_OFFSET: u32 = 40;
pub const UART_CR_UTX_END_CLR_POS: u32 = 0;
pub const UART_CR_UTX_END_CLR_LEN: u32 = 1;
pub const UART_CR_UTX_END_CLR_MSK: u32 = 1;
pub const UART_CR_UTX_END_CLR_UMSK: i32 = -2;
pub const UART_CR_URX_END_CLR_POS: u32 = 1;
pub const UART_CR_URX_END_CLR_LEN: u32 = 1;
pub const UART_CR_URX_END_CLR_MSK: u32 = 2;
pub const UART_CR_URX_END_CLR_UMSK: i32 = -3;
pub const UART_CR_URX_RTO_CLR_POS: u32 = 4;
pub const UART_CR_URX_RTO_CLR_LEN: u32 = 1;
pub const UART_CR_URX_RTO_CLR_MSK: u32 = 16;
pub const UART_CR_URX_RTO_CLR_UMSK: i32 = -17;
pub const UART_CR_URX_PCE_CLR_POS: u32 = 5;
pub const UART_CR_URX_PCE_CLR_LEN: u32 = 1;
pub const UART_CR_URX_PCE_CLR_MSK: u32 = 32;
pub const UART_CR_URX_PCE_CLR_UMSK: i32 = -33;
pub const UART_INT_EN_OFFSET: u32 = 44;
pub const UART_CR_UTX_END_EN_POS: u32 = 0;
pub const UART_CR_UTX_END_EN_LEN: u32 = 1;
pub const UART_CR_UTX_END_EN_MSK: u32 = 1;
pub const UART_CR_UTX_END_EN_UMSK: i32 = -2;
pub const UART_CR_URX_END_EN_POS: u32 = 1;
pub const UART_CR_URX_END_EN_LEN: u32 = 1;
pub const UART_CR_URX_END_EN_MSK: u32 = 2;
pub const UART_CR_URX_END_EN_UMSK: i32 = -3;
pub const UART_CR_UTX_FIFO_EN_POS: u32 = 2;
pub const UART_CR_UTX_FIFO_EN_LEN: u32 = 1;
pub const UART_CR_UTX_FIFO_EN_MSK: u32 = 4;
pub const UART_CR_UTX_FIFO_EN_UMSK: i32 = -5;
pub const UART_CR_URX_FIFO_EN_POS: u32 = 3;
pub const UART_CR_URX_FIFO_EN_LEN: u32 = 1;
pub const UART_CR_URX_FIFO_EN_MSK: u32 = 8;
pub const UART_CR_URX_FIFO_EN_UMSK: i32 = -9;
pub const UART_CR_URX_RTO_EN_POS: u32 = 4;
pub const UART_CR_URX_RTO_EN_LEN: u32 = 1;
pub const UART_CR_URX_RTO_EN_MSK: u32 = 16;
pub const UART_CR_URX_RTO_EN_UMSK: i32 = -17;
pub const UART_CR_URX_PCE_EN_POS: u32 = 5;
pub const UART_CR_URX_PCE_EN_LEN: u32 = 1;
pub const UART_CR_URX_PCE_EN_MSK: u32 = 32;
pub const UART_CR_URX_PCE_EN_UMSK: i32 = -33;
pub const UART_CR_UTX_FER_EN_POS: u32 = 6;
pub const UART_CR_UTX_FER_EN_LEN: u32 = 1;
pub const UART_CR_UTX_FER_EN_MSK: u32 = 64;
pub const UART_CR_UTX_FER_EN_UMSK: i32 = -65;
pub const UART_CR_URX_FER_EN_POS: u32 = 7;
pub const UART_CR_URX_FER_EN_LEN: u32 = 1;
pub const UART_CR_URX_FER_EN_MSK: u32 = 128;
pub const UART_CR_URX_FER_EN_UMSK: i32 = -129;
pub const UART_STATUS_OFFSET: u32 = 48;
pub const UART_STS_UTX_BUS_BUSY_POS: u32 = 0;
pub const UART_STS_UTX_BUS_BUSY_LEN: u32 = 1;
pub const UART_STS_UTX_BUS_BUSY_MSK: u32 = 1;
pub const UART_STS_UTX_BUS_BUSY_UMSK: i32 = -2;
pub const UART_STS_URX_BUS_BUSY_POS: u32 = 1;
pub const UART_STS_URX_BUS_BUSY_LEN: u32 = 1;
pub const UART_STS_URX_BUS_BUSY_MSK: u32 = 2;
pub const UART_STS_URX_BUS_BUSY_UMSK: i32 = -3;
pub const UART_STS_URX_ABR_PRD_OFFSET: u32 = 52;
pub const UART_STS_URX_ABR_PRD_START_POS: u32 = 0;
pub const UART_STS_URX_ABR_PRD_START_LEN: u32 = 16;
pub const UART_STS_URX_ABR_PRD_START_MSK: u32 = 65535;
pub const UART_STS_URX_ABR_PRD_START_UMSK: i32 = -65536;
pub const UART_STS_URX_ABR_PRD_0X55_POS: u32 = 16;
pub const UART_STS_URX_ABR_PRD_0X55_LEN: u32 = 16;
pub const UART_STS_URX_ABR_PRD_0X55_MSK: u32 = 4294901760;
pub const UART_STS_URX_ABR_PRD_0X55_UMSK: i64 = -4294901761;
pub const UART_FIFO_CONFIG_0_OFFSET: u32 = 128;
pub const UART_DMA_TX_EN_POS: u32 = 0;
pub const UART_DMA_TX_EN_LEN: u32 = 1;
pub const UART_DMA_TX_EN_MSK: u32 = 1;
pub const UART_DMA_TX_EN_UMSK: i32 = -2;
pub const UART_DMA_RX_EN_POS: u32 = 1;
pub const UART_DMA_RX_EN_LEN: u32 = 1;
pub const UART_DMA_RX_EN_MSK: u32 = 2;
pub const UART_DMA_RX_EN_UMSK: i32 = -3;
pub const UART_TX_FIFO_CLR_POS: u32 = 2;
pub const UART_TX_FIFO_CLR_LEN: u32 = 1;
pub const UART_TX_FIFO_CLR_MSK: u32 = 4;
pub const UART_TX_FIFO_CLR_UMSK: i32 = -5;
pub const UART_RX_FIFO_CLR_POS: u32 = 3;
pub const UART_RX_FIFO_CLR_LEN: u32 = 1;
pub const UART_RX_FIFO_CLR_MSK: u32 = 8;
pub const UART_RX_FIFO_CLR_UMSK: i32 = -9;
pub const UART_TX_FIFO_OVERFLOW_POS: u32 = 4;
pub const UART_TX_FIFO_OVERFLOW_LEN: u32 = 1;
pub const UART_TX_FIFO_OVERFLOW_MSK: u32 = 16;
pub const UART_TX_FIFO_OVERFLOW_UMSK: i32 = -17;
pub const UART_TX_FIFO_UNDERFLOW_POS: u32 = 5;
pub const UART_TX_FIFO_UNDERFLOW_LEN: u32 = 1;
pub const UART_TX_FIFO_UNDERFLOW_MSK: u32 = 32;
pub const UART_TX_FIFO_UNDERFLOW_UMSK: i32 = -33;
pub const UART_RX_FIFO_OVERFLOW_POS: u32 = 6;
pub const UART_RX_FIFO_OVERFLOW_LEN: u32 = 1;
pub const UART_RX_FIFO_OVERFLOW_MSK: u32 = 64;
pub const UART_RX_FIFO_OVERFLOW_UMSK: i32 = -65;
pub const UART_RX_FIFO_UNDERFLOW_POS: u32 = 7;
pub const UART_RX_FIFO_UNDERFLOW_LEN: u32 = 1;
pub const UART_RX_FIFO_UNDERFLOW_MSK: u32 = 128;
pub const UART_RX_FIFO_UNDERFLOW_UMSK: i32 = -129;
pub const UART_FIFO_CONFIG_1_OFFSET: u32 = 132;
pub const UART_TX_FIFO_CNT_POS: u32 = 0;
pub const UART_TX_FIFO_CNT_LEN: u32 = 6;
pub const UART_TX_FIFO_CNT_MSK: u32 = 63;
pub const UART_TX_FIFO_CNT_UMSK: i32 = -64;
pub const UART_RX_FIFO_CNT_POS: u32 = 8;
pub const UART_RX_FIFO_CNT_LEN: u32 = 6;
pub const UART_RX_FIFO_CNT_MSK: u32 = 16128;
pub const UART_RX_FIFO_CNT_UMSK: i32 = -16129;
pub const UART_TX_FIFO_TH_POS: u32 = 16;
pub const UART_TX_FIFO_TH_LEN: u32 = 5;
pub const UART_TX_FIFO_TH_MSK: u32 = 2031616;
pub const UART_TX_FIFO_TH_UMSK: i32 = -2031617;
pub const UART_RX_FIFO_TH_POS: u32 = 24;
pub const UART_RX_FIFO_TH_LEN: u32 = 5;
pub const UART_RX_FIFO_TH_MSK: u32 = 520093696;
pub const UART_RX_FIFO_TH_UMSK: i32 = -520093697;
pub const UART_FIFO_WDATA_OFFSET: u32 = 136;
pub const UART_FIFO_WDATA_POS: u32 = 0;
pub const UART_FIFO_WDATA_LEN: u32 = 8;
pub const UART_FIFO_WDATA_MSK: u32 = 255;
pub const UART_FIFO_WDATA_UMSK: i32 = -256;
pub const UART_FIFO_RDATA_OFFSET: u32 = 140;
pub const UART_FIFO_RDATA_POS: u32 = 0;
pub const UART_FIFO_RDATA_LEN: u32 = 8;
pub const UART_FIFO_RDATA_MSK: u32 = 255;
pub const UART_FIFO_RDATA_UMSK: i32 = -256;
pub const UART_RX_FIFO_SIZE: u32 = 32;
pub const UART_TX_FIFO_SIZE: u32 = 32;
pub const UART_DEFAULT_RECV_TIMEOUT: u32 = 80;
pub const BL_UART_BUFFER_SIZE_MIN: u32 = 128;
pub const BL_UART_BUFFER_SIZE_MASK: u32 = 127;
pub type __uint8_t = ::cty::c_uchar;
pub type __uint16_t = ::cty::c_ushort;
pub type __uint32_t = ::cty::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct uart_reg {
    pub utx_config: uart_reg__bindgen_ty_1,
    pub urx_config: uart_reg__bindgen_ty_2,
    pub uart_bit_prd: uart_reg__bindgen_ty_3,
    pub data_config: uart_reg__bindgen_ty_4,
    pub utx_ir_position: uart_reg__bindgen_ty_5,
    pub urx_ir_position: uart_reg__bindgen_ty_6,
    pub urx_rto_timer: uart_reg__bindgen_ty_7,
    pub RESERVED0x1c: [u8; 4usize],
    pub uart_int_sts: uart_reg__bindgen_ty_8,
    pub uart_int_mask: uart_reg__bindgen_ty_9,
    pub uart_int_clear: uart_reg__bindgen_ty_10,
    pub uart_int_en: uart_reg__bindgen_ty_11,
    pub uart_status: uart_reg__bindgen_ty_12,
    pub sts_urx_abr_prd: uart_reg__bindgen_ty_13,
    pub RESERVED0x38: [u8; 72usize],
    pub uart_fifo_config_0: uart_reg__bindgen_ty_14,
    pub uart_fifo_config_1: uart_reg__bindgen_ty_15,
    pub uart_fifo_wdata: uart_reg__bindgen_ty_16,
    pub uart_fifo_rdata: uart_reg__bindgen_ty_17,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_1 {
    pub BF: uart_reg__bindgen_ty_1__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn cr_utx_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_cts_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_cts_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_frm_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_frm_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_3(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_3(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_prt_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_prt_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_prt_sel(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_prt_sel(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_ir_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_ir_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_ir_inv(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_ir_inv(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_bit_cnt_d(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_bit_cnt_d(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_11(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_11(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_bit_cnt_p(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_bit_cnt_p(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_14_15(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_14_15(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_len(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_len(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_utx_en: u32,
        cr_utx_cts_en: u32,
        cr_utx_frm_en: u32,
        reserved_3: u32,
        cr_utx_prt_en: u32,
        cr_utx_prt_sel: u32,
        cr_utx_ir_en: u32,
        cr_utx_ir_inv: u32,
        cr_utx_bit_cnt_d: u32,
        reserved_11: u32,
        cr_utx_bit_cnt_p: u32,
        reserved_14_15: u32,
        cr_utx_len: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let cr_utx_en: u32 = unsafe { ::core::mem::transmute(cr_utx_en) };
            cr_utx_en as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let cr_utx_cts_en: u32 = unsafe { ::core::mem::transmute(cr_utx_cts_en) };
            cr_utx_cts_en as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let cr_utx_frm_en: u32 = unsafe { ::core::mem::transmute(cr_utx_frm_en) };
            cr_utx_frm_en as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let reserved_3: u32 = unsafe { ::core::mem::transmute(reserved_3) };
            reserved_3 as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let cr_utx_prt_en: u32 = unsafe { ::core::mem::transmute(cr_utx_prt_en) };
            cr_utx_prt_en as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let cr_utx_prt_sel: u32 = unsafe { ::core::mem::transmute(cr_utx_prt_sel) };
            cr_utx_prt_sel as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let cr_utx_ir_en: u32 = unsafe { ::core::mem::transmute(cr_utx_ir_en) };
            cr_utx_ir_en as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let cr_utx_ir_inv: u32 = unsafe { ::core::mem::transmute(cr_utx_ir_inv) };
            cr_utx_ir_inv as u64
        });
        __bindgen_bitfield_unit.set(8usize, 3u8, {
            let cr_utx_bit_cnt_d: u32 = unsafe { ::core::mem::transmute(cr_utx_bit_cnt_d) };
            cr_utx_bit_cnt_d as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let reserved_11: u32 = unsafe { ::core::mem::transmute(reserved_11) };
            reserved_11 as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let cr_utx_bit_cnt_p: u32 = unsafe { ::core::mem::transmute(cr_utx_bit_cnt_p) };
            cr_utx_bit_cnt_p as u64
        });
        __bindgen_bitfield_unit.set(14usize, 2u8, {
            let reserved_14_15: u32 = unsafe { ::core::mem::transmute(reserved_14_15) };
            reserved_14_15 as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let cr_utx_len: u32 = unsafe { ::core::mem::transmute(cr_utx_len) };
            cr_utx_len as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_2 {
    pub BF: uart_reg__bindgen_ty_2__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_2__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_2__bindgen_ty_1 {
    #[inline]
    pub fn cr_urx_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_rts_sw_mode(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_rts_sw_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_rts_sw_val(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_rts_sw_val(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_abr_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_abr_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_prt_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_prt_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_prt_sel(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_prt_sel(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_ir_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_ir_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_ir_inv(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_ir_inv(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_bit_cnt_d(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_bit_cnt_d(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_deg_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_deg_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_deg_cnt(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_deg_cnt(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_len(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_len(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_urx_en: u32,
        cr_urx_rts_sw_mode: u32,
        cr_urx_rts_sw_val: u32,
        cr_urx_abr_en: u32,
        cr_urx_prt_en: u32,
        cr_urx_prt_sel: u32,
        cr_urx_ir_en: u32,
        cr_urx_ir_inv: u32,
        cr_urx_bit_cnt_d: u32,
        cr_urx_deg_en: u32,
        cr_urx_deg_cnt: u32,
        cr_urx_len: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let cr_urx_en: u32 = unsafe { ::core::mem::transmute(cr_urx_en) };
            cr_urx_en as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let cr_urx_rts_sw_mode: u32 = unsafe { ::core::mem::transmute(cr_urx_rts_sw_mode) };
            cr_urx_rts_sw_mode as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let cr_urx_rts_sw_val: u32 = unsafe { ::core::mem::transmute(cr_urx_rts_sw_val) };
            cr_urx_rts_sw_val as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let cr_urx_abr_en: u32 = unsafe { ::core::mem::transmute(cr_urx_abr_en) };
            cr_urx_abr_en as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let cr_urx_prt_en: u32 = unsafe { ::core::mem::transmute(cr_urx_prt_en) };
            cr_urx_prt_en as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let cr_urx_prt_sel: u32 = unsafe { ::core::mem::transmute(cr_urx_prt_sel) };
            cr_urx_prt_sel as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let cr_urx_ir_en: u32 = unsafe { ::core::mem::transmute(cr_urx_ir_en) };
            cr_urx_ir_en as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let cr_urx_ir_inv: u32 = unsafe { ::core::mem::transmute(cr_urx_ir_inv) };
            cr_urx_ir_inv as u64
        });
        __bindgen_bitfield_unit.set(8usize, 3u8, {
            let cr_urx_bit_cnt_d: u32 = unsafe { ::core::mem::transmute(cr_urx_bit_cnt_d) };
            cr_urx_bit_cnt_d as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let cr_urx_deg_en: u32 = unsafe { ::core::mem::transmute(cr_urx_deg_en) };
            cr_urx_deg_en as u64
        });
        __bindgen_bitfield_unit.set(12usize, 4u8, {
            let cr_urx_deg_cnt: u32 = unsafe { ::core::mem::transmute(cr_urx_deg_cnt) };
            cr_urx_deg_cnt as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let cr_urx_len: u32 = unsafe { ::core::mem::transmute(cr_urx_len) };
            cr_urx_len as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_3 {
    pub BF: uart_reg__bindgen_ty_3__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_3__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_3__bindgen_ty_1 {
    #[inline]
    pub fn cr_utx_bit_prd(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_bit_prd(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_bit_prd(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_bit_prd(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_utx_bit_prd: u32,
        cr_urx_bit_prd: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let cr_utx_bit_prd: u32 = unsafe { ::core::mem::transmute(cr_utx_bit_prd) };
            cr_utx_bit_prd as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let cr_urx_bit_prd: u32 = unsafe { ::core::mem::transmute(cr_urx_bit_prd) };
            cr_urx_bit_prd as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_3 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_4 {
    pub BF: uart_reg__bindgen_ty_4__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_4__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_4__bindgen_ty_1 {
    #[inline]
    pub fn cr_uart_bit_inv(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_uart_bit_inv(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_1_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_1_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_uart_bit_inv: u32,
        reserved_1_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let cr_uart_bit_inv: u32 = unsafe { ::core::mem::transmute(cr_uart_bit_inv) };
            cr_uart_bit_inv as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let reserved_1_31: u32 = unsafe { ::core::mem::transmute(reserved_1_31) };
            reserved_1_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_4 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_5 {
    pub BF: uart_reg__bindgen_ty_5__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_5__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_5__bindgen_ty_1 {
    #[inline]
    pub fn cr_utx_ir_pos_s(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_ir_pos_s(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_ir_pos_p(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_ir_pos_p(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_utx_ir_pos_s: u32,
        cr_utx_ir_pos_p: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let cr_utx_ir_pos_s: u32 = unsafe { ::core::mem::transmute(cr_utx_ir_pos_s) };
            cr_utx_ir_pos_s as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let cr_utx_ir_pos_p: u32 = unsafe { ::core::mem::transmute(cr_utx_ir_pos_p) };
            cr_utx_ir_pos_p as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_5 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_6 {
    pub BF: uart_reg__bindgen_ty_6__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_6__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_6__bindgen_ty_1 {
    #[inline]
    pub fn cr_urx_ir_pos_s(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_ir_pos_s(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_16_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_16_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_urx_ir_pos_s: u32,
        reserved_16_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let cr_urx_ir_pos_s: u32 = unsafe { ::core::mem::transmute(cr_urx_ir_pos_s) };
            cr_urx_ir_pos_s as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let reserved_16_31: u32 = unsafe { ::core::mem::transmute(reserved_16_31) };
            reserved_16_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_6 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_7 {
    pub BF: uart_reg__bindgen_ty_7__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_7__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_7__bindgen_ty_1 {
    #[inline]
    pub fn cr_urx_rto_value(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_rto_value(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_8_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_8_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_urx_rto_value: u32,
        reserved_8_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let cr_urx_rto_value: u32 = unsafe { ::core::mem::transmute(cr_urx_rto_value) };
            cr_urx_rto_value as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let reserved_8_31: u32 = unsafe { ::core::mem::transmute(reserved_8_31) };
            reserved_8_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_7 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_8 {
    pub BF: uart_reg__bindgen_ty_8__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_8__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_8__bindgen_ty_1 {
    #[inline]
    pub fn utx_end_int(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_utx_end_int(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn urx_end_int(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_urx_end_int(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn utx_fifo_int(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_utx_fifo_int(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn urx_fifo_int(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_urx_fifo_int(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn urx_rto_int(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_urx_rto_int(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn urx_pce_int(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_urx_pce_int(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn utx_fer_int(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_utx_fer_int(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn urx_fer_int(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_urx_fer_int(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_8_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_8_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        utx_end_int: u32,
        urx_end_int: u32,
        utx_fifo_int: u32,
        urx_fifo_int: u32,
        urx_rto_int: u32,
        urx_pce_int: u32,
        utx_fer_int: u32,
        urx_fer_int: u32,
        reserved_8_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let utx_end_int: u32 = unsafe { ::core::mem::transmute(utx_end_int) };
            utx_end_int as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let urx_end_int: u32 = unsafe { ::core::mem::transmute(urx_end_int) };
            urx_end_int as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let utx_fifo_int: u32 = unsafe { ::core::mem::transmute(utx_fifo_int) };
            utx_fifo_int as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let urx_fifo_int: u32 = unsafe { ::core::mem::transmute(urx_fifo_int) };
            urx_fifo_int as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let urx_rto_int: u32 = unsafe { ::core::mem::transmute(urx_rto_int) };
            urx_rto_int as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let urx_pce_int: u32 = unsafe { ::core::mem::transmute(urx_pce_int) };
            urx_pce_int as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let utx_fer_int: u32 = unsafe { ::core::mem::transmute(utx_fer_int) };
            utx_fer_int as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let urx_fer_int: u32 = unsafe { ::core::mem::transmute(urx_fer_int) };
            urx_fer_int as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let reserved_8_31: u32 = unsafe { ::core::mem::transmute(reserved_8_31) };
            reserved_8_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_8 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_9 {
    pub BF: uart_reg__bindgen_ty_9__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_9__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_9__bindgen_ty_1 {
    #[inline]
    pub fn cr_utx_end_mask(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_end_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_end_mask(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_end_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_fifo_mask(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_fifo_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_fifo_mask(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_fifo_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_rto_mask(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_rto_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_pce_mask(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_pce_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_fer_mask(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_fer_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_fer_mask(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_fer_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_8_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_8_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_utx_end_mask: u32,
        cr_urx_end_mask: u32,
        cr_utx_fifo_mask: u32,
        cr_urx_fifo_mask: u32,
        cr_urx_rto_mask: u32,
        cr_urx_pce_mask: u32,
        cr_utx_fer_mask: u32,
        cr_urx_fer_mask: u32,
        reserved_8_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let cr_utx_end_mask: u32 = unsafe { ::core::mem::transmute(cr_utx_end_mask) };
            cr_utx_end_mask as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let cr_urx_end_mask: u32 = unsafe { ::core::mem::transmute(cr_urx_end_mask) };
            cr_urx_end_mask as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let cr_utx_fifo_mask: u32 = unsafe { ::core::mem::transmute(cr_utx_fifo_mask) };
            cr_utx_fifo_mask as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let cr_urx_fifo_mask: u32 = unsafe { ::core::mem::transmute(cr_urx_fifo_mask) };
            cr_urx_fifo_mask as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let cr_urx_rto_mask: u32 = unsafe { ::core::mem::transmute(cr_urx_rto_mask) };
            cr_urx_rto_mask as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let cr_urx_pce_mask: u32 = unsafe { ::core::mem::transmute(cr_urx_pce_mask) };
            cr_urx_pce_mask as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let cr_utx_fer_mask: u32 = unsafe { ::core::mem::transmute(cr_utx_fer_mask) };
            cr_utx_fer_mask as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let cr_urx_fer_mask: u32 = unsafe { ::core::mem::transmute(cr_urx_fer_mask) };
            cr_urx_fer_mask as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let reserved_8_31: u32 = unsafe { ::core::mem::transmute(reserved_8_31) };
            reserved_8_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_9 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_10 {
    pub BF: uart_reg__bindgen_ty_10__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_10__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_10__bindgen_ty_1 {
    #[inline]
    pub fn cr_utx_end_clr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_end_clr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_end_clr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_end_clr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rsvd_2(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_rsvd_2(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rsvd_3(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_rsvd_3(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_rto_clr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_rto_clr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_pce_clr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_pce_clr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rsvd_6(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_rsvd_6(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rsvd_7(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_rsvd_7(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_8_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_8_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_utx_end_clr: u32,
        cr_urx_end_clr: u32,
        rsvd_2: u32,
        rsvd_3: u32,
        cr_urx_rto_clr: u32,
        cr_urx_pce_clr: u32,
        rsvd_6: u32,
        rsvd_7: u32,
        reserved_8_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let cr_utx_end_clr: u32 = unsafe { ::core::mem::transmute(cr_utx_end_clr) };
            cr_utx_end_clr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let cr_urx_end_clr: u32 = unsafe { ::core::mem::transmute(cr_urx_end_clr) };
            cr_urx_end_clr as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let rsvd_2: u32 = unsafe { ::core::mem::transmute(rsvd_2) };
            rsvd_2 as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let rsvd_3: u32 = unsafe { ::core::mem::transmute(rsvd_3) };
            rsvd_3 as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let cr_urx_rto_clr: u32 = unsafe { ::core::mem::transmute(cr_urx_rto_clr) };
            cr_urx_rto_clr as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let cr_urx_pce_clr: u32 = unsafe { ::core::mem::transmute(cr_urx_pce_clr) };
            cr_urx_pce_clr as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let rsvd_6: u32 = unsafe { ::core::mem::transmute(rsvd_6) };
            rsvd_6 as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let rsvd_7: u32 = unsafe { ::core::mem::transmute(rsvd_7) };
            rsvd_7 as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let reserved_8_31: u32 = unsafe { ::core::mem::transmute(reserved_8_31) };
            reserved_8_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_10 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_11 {
    pub BF: uart_reg__bindgen_ty_11__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_11__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_11__bindgen_ty_1 {
    #[inline]
    pub fn cr_utx_end_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_end_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_end_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_end_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_fifo_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_fifo_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_fifo_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_fifo_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_rto_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_rto_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_pce_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_pce_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_utx_fer_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_utx_fer_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cr_urx_fer_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cr_urx_fer_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_8_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_8_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cr_utx_end_en: u32,
        cr_urx_end_en: u32,
        cr_utx_fifo_en: u32,
        cr_urx_fifo_en: u32,
        cr_urx_rto_en: u32,
        cr_urx_pce_en: u32,
        cr_utx_fer_en: u32,
        cr_urx_fer_en: u32,
        reserved_8_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let cr_utx_end_en: u32 = unsafe { ::core::mem::transmute(cr_utx_end_en) };
            cr_utx_end_en as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let cr_urx_end_en: u32 = unsafe { ::core::mem::transmute(cr_urx_end_en) };
            cr_urx_end_en as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let cr_utx_fifo_en: u32 = unsafe { ::core::mem::transmute(cr_utx_fifo_en) };
            cr_utx_fifo_en as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let cr_urx_fifo_en: u32 = unsafe { ::core::mem::transmute(cr_urx_fifo_en) };
            cr_urx_fifo_en as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let cr_urx_rto_en: u32 = unsafe { ::core::mem::transmute(cr_urx_rto_en) };
            cr_urx_rto_en as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let cr_urx_pce_en: u32 = unsafe { ::core::mem::transmute(cr_urx_pce_en) };
            cr_urx_pce_en as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let cr_utx_fer_en: u32 = unsafe { ::core::mem::transmute(cr_utx_fer_en) };
            cr_utx_fer_en as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let cr_urx_fer_en: u32 = unsafe { ::core::mem::transmute(cr_urx_fer_en) };
            cr_urx_fer_en as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let reserved_8_31: u32 = unsafe { ::core::mem::transmute(reserved_8_31) };
            reserved_8_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_11 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_12 {
    pub BF: uart_reg__bindgen_ty_12__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_12__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_12__bindgen_ty_1 {
    #[inline]
    pub fn sts_utx_bus_busy(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sts_utx_bus_busy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sts_urx_bus_busy(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sts_urx_bus_busy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_2_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_2_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sts_utx_bus_busy: u32,
        sts_urx_bus_busy: u32,
        reserved_2_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let sts_utx_bus_busy: u32 = unsafe { ::core::mem::transmute(sts_utx_bus_busy) };
            sts_utx_bus_busy as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let sts_urx_bus_busy: u32 = unsafe { ::core::mem::transmute(sts_urx_bus_busy) };
            sts_urx_bus_busy as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved_2_31: u32 = unsafe { ::core::mem::transmute(reserved_2_31) };
            reserved_2_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_12 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_13 {
    pub BF: uart_reg__bindgen_ty_13__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_13__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_13__bindgen_ty_1 {
    #[inline]
    pub fn sts_urx_abr_prd_start(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_sts_urx_abr_prd_start(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn sts_urx_abr_prd_0x55(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_sts_urx_abr_prd_0x55(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sts_urx_abr_prd_start: u32,
        sts_urx_abr_prd_0x55: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let sts_urx_abr_prd_start: u32 =
                unsafe { ::core::mem::transmute(sts_urx_abr_prd_start) };
            sts_urx_abr_prd_start as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let sts_urx_abr_prd_0x55: u32 = unsafe { ::core::mem::transmute(sts_urx_abr_prd_0x55) };
            sts_urx_abr_prd_0x55 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_13 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_14 {
    pub BF: uart_reg__bindgen_ty_14__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_14__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_14__bindgen_ty_1 {
    #[inline]
    pub fn uart_dma_tx_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uart_dma_tx_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uart_dma_rx_en(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uart_dma_rx_en(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tx_fifo_clr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tx_fifo_clr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rx_fifo_clr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_rx_fifo_clr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tx_fifo_overflow(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tx_fifo_overflow(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tx_fifo_underflow(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tx_fifo_underflow(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rx_fifo_overflow(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_rx_fifo_overflow(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rx_fifo_underflow(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_rx_fifo_underflow(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_8_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_8_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        uart_dma_tx_en: u32,
        uart_dma_rx_en: u32,
        tx_fifo_clr: u32,
        rx_fifo_clr: u32,
        tx_fifo_overflow: u32,
        tx_fifo_underflow: u32,
        rx_fifo_overflow: u32,
        rx_fifo_underflow: u32,
        reserved_8_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let uart_dma_tx_en: u32 = unsafe { ::core::mem::transmute(uart_dma_tx_en) };
            uart_dma_tx_en as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let uart_dma_rx_en: u32 = unsafe { ::core::mem::transmute(uart_dma_rx_en) };
            uart_dma_rx_en as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let tx_fifo_clr: u32 = unsafe { ::core::mem::transmute(tx_fifo_clr) };
            tx_fifo_clr as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let rx_fifo_clr: u32 = unsafe { ::core::mem::transmute(rx_fifo_clr) };
            rx_fifo_clr as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let tx_fifo_overflow: u32 = unsafe { ::core::mem::transmute(tx_fifo_overflow) };
            tx_fifo_overflow as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let tx_fifo_underflow: u32 = unsafe { ::core::mem::transmute(tx_fifo_underflow) };
            tx_fifo_underflow as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let rx_fifo_overflow: u32 = unsafe { ::core::mem::transmute(rx_fifo_overflow) };
            rx_fifo_overflow as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let rx_fifo_underflow: u32 = unsafe { ::core::mem::transmute(rx_fifo_underflow) };
            rx_fifo_underflow as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let reserved_8_31: u32 = unsafe { ::core::mem::transmute(reserved_8_31) };
            reserved_8_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_14 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_15 {
    pub BF: uart_reg__bindgen_ty_15__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_15__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_15__bindgen_ty_1 {
    #[inline]
    pub fn tx_fifo_cnt(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 6u8) as u32) }
    }
    #[inline]
    pub fn set_tx_fifo_cnt(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 6u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_6_7(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_6_7(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn rx_fifo_cnt(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 6u8) as u32) }
    }
    #[inline]
    pub fn set_rx_fifo_cnt(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 6u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_14_15(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_14_15(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn tx_fifo_th(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_tx_fifo_th(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_21_23(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(21usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_21_23(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(21usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn rx_fifo_th(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_rx_fifo_th(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_29_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(29usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_29_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(29usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        tx_fifo_cnt: u32,
        reserved_6_7: u32,
        rx_fifo_cnt: u32,
        reserved_14_15: u32,
        tx_fifo_th: u32,
        reserved_21_23: u32,
        rx_fifo_th: u32,
        reserved_29_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 6u8, {
            let tx_fifo_cnt: u32 = unsafe { ::core::mem::transmute(tx_fifo_cnt) };
            tx_fifo_cnt as u64
        });
        __bindgen_bitfield_unit.set(6usize, 2u8, {
            let reserved_6_7: u32 = unsafe { ::core::mem::transmute(reserved_6_7) };
            reserved_6_7 as u64
        });
        __bindgen_bitfield_unit.set(8usize, 6u8, {
            let rx_fifo_cnt: u32 = unsafe { ::core::mem::transmute(rx_fifo_cnt) };
            rx_fifo_cnt as u64
        });
        __bindgen_bitfield_unit.set(14usize, 2u8, {
            let reserved_14_15: u32 = unsafe { ::core::mem::transmute(reserved_14_15) };
            reserved_14_15 as u64
        });
        __bindgen_bitfield_unit.set(16usize, 5u8, {
            let tx_fifo_th: u32 = unsafe { ::core::mem::transmute(tx_fifo_th) };
            tx_fifo_th as u64
        });
        __bindgen_bitfield_unit.set(21usize, 3u8, {
            let reserved_21_23: u32 = unsafe { ::core::mem::transmute(reserved_21_23) };
            reserved_21_23 as u64
        });
        __bindgen_bitfield_unit.set(24usize, 5u8, {
            let rx_fifo_th: u32 = unsafe { ::core::mem::transmute(rx_fifo_th) };
            rx_fifo_th as u64
        });
        __bindgen_bitfield_unit.set(29usize, 3u8, {
            let reserved_29_31: u32 = unsafe { ::core::mem::transmute(reserved_29_31) };
            reserved_29_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_15 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_16 {
    pub BF: uart_reg__bindgen_ty_16__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_16__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_16__bindgen_ty_1 {
    #[inline]
    pub fn uart_fifo_wdata(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_uart_fifo_wdata(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_8_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_8_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        uart_fifo_wdata: u32,
        reserved_8_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let uart_fifo_wdata: u32 = unsafe { ::core::mem::transmute(uart_fifo_wdata) };
            uart_fifo_wdata as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let reserved_8_31: u32 = unsafe { ::core::mem::transmute(reserved_8_31) };
            reserved_8_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_16 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uart_reg__bindgen_ty_17 {
    pub BF: uart_reg__bindgen_ty_17__bindgen_ty_1,
    pub WORD: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Default, Copy, Clone)]
pub struct uart_reg__bindgen_ty_17__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl uart_reg__bindgen_ty_17__bindgen_ty_1 {
    #[inline]
    pub fn uart_fifo_rdata(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_uart_fifo_rdata(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_8_31(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_8_31(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        uart_fifo_rdata: u32,
        reserved_8_31: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let uart_fifo_rdata: u32 = unsafe { ::core::mem::transmute(uart_fifo_rdata) };
            uart_fifo_rdata as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let reserved_8_31: u32 = unsafe { ::core::mem::transmute(reserved_8_31) };
            reserved_8_31 as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for uart_reg__bindgen_ty_17 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl Default for uart_reg {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub type uart_reg_t = uart_reg;
pub const BL_Err_Type_SUCCESS: BL_Err_Type = 0;
pub const BL_Err_Type_ERROR: BL_Err_Type = 1;
pub const BL_Err_Type_TIMEOUT: BL_Err_Type = 2;
#[doc = " @brief Error type definition"]
pub type BL_Err_Type = ::cty::c_uint;
pub const BL_Fun_Type_DISABLE: BL_Fun_Type = 0;
pub const BL_Fun_Type_ENABLE: BL_Fun_Type = 1;
#[doc = " @brief Functional type definition"]
pub type BL_Fun_Type = ::cty::c_uint;
pub const BL_Sts_Type_RESET: BL_Sts_Type = 0;
pub const BL_Sts_Type_SET: BL_Sts_Type = 1;
#[doc = " @brief Status type definition"]
pub type BL_Sts_Type = ::cty::c_uint;
pub const BL_Mask_Type_UNMASK: BL_Mask_Type = 0;
pub const BL_Mask_Type_MASK: BL_Mask_Type = 1;
#[doc = " @brief Mask type definition"]
pub type BL_Mask_Type = ::cty::c_uint;
#[doc = "  @brief Interrupt callback function type"]
pub type intCallback_Type = ::core::option::Option<unsafe extern "C" fn()>;
#[doc = "< UART0 port define"]
pub const UART_ID_Type_UART0_ID: UART_ID_Type = 0;
#[doc = "< UART1 port define"]
pub const UART_ID_Type_UART1_ID: UART_ID_Type = 1;
#[doc = "< UART MAX ID define"]
pub const UART_ID_Type_UART_ID_MAX: UART_ID_Type = 2;
#[doc = "  @brief UART port type definition"]
pub type UART_ID_Type = ::cty::c_uint;
#[doc = "< UART TX Direction"]
pub const UART_Direction_Type_UART_TX: UART_Direction_Type = 0;
#[doc = "< UART RX Direction"]
pub const UART_Direction_Type_UART_RX: UART_Direction_Type = 1;
#[doc = "< UART TX and RX Direction"]
pub const UART_Direction_Type_UART_TXRX: UART_Direction_Type = 2;
#[doc = "  @brief UART direction type definition"]
pub type UART_Direction_Type = ::cty::c_uint;
#[doc = "< UART parity none define"]
pub const UART_Parity_Type_UART_PARITY_NONE: UART_Parity_Type = 0;
#[doc = "< UART parity odd define"]
pub const UART_Parity_Type_UART_PARITY_ODD: UART_Parity_Type = 1;
#[doc = "< UART parity even define"]
pub const UART_Parity_Type_UART_PARITY_EVEN: UART_Parity_Type = 2;
#[doc = "  @brief UART parity type definition"]
pub type UART_Parity_Type = ::cty::c_uint;
#[doc = "< UART data bits length:5 bits"]
pub const UART_DataBits_Type_UART_DATABITS_5: UART_DataBits_Type = 0;
#[doc = "< UART data bits length:6 bits"]
pub const UART_DataBits_Type_UART_DATABITS_6: UART_DataBits_Type = 1;
#[doc = "< UART data bits length:7 bits"]
pub const UART_DataBits_Type_UART_DATABITS_7: UART_DataBits_Type = 2;
#[doc = "< UART data bits length:8 bits"]
pub const UART_DataBits_Type_UART_DATABITS_8: UART_DataBits_Type = 3;
#[doc = "  @brief UART data bits type definiton"]
pub type UART_DataBits_Type = ::cty::c_uint;
#[doc = "< UART data stop bits length:1 bits"]
pub const UART_StopBits_Type_UART_STOPBITS_1: UART_StopBits_Type = 0;
#[doc = "< UART data stop bits length:1.5 bits"]
pub const UART_StopBits_Type_UART_STOPBITS_1_5: UART_StopBits_Type = 1;
#[doc = "< UART data stop bits length:2 bits"]
pub const UART_StopBits_Type_UART_STOPBITS_2: UART_StopBits_Type = 2;
#[doc = "  @brief UART stop bits type definiton"]
pub type UART_StopBits_Type = ::cty::c_uint;
#[doc = "< UART each byte is send out LSB-first"]
pub const UART_ByteBitInverse_Type_UART_LSB_FIRST: UART_ByteBitInverse_Type = 0;
#[doc = "< UART each byte is send out MSB-first"]
pub const UART_ByteBitInverse_Type_UART_MSB_FIRST: UART_ByteBitInverse_Type = 1;
#[doc = "  @brief UART each data byte is send out LSB-first or MSB-first type definiton"]
pub type UART_ByteBitInverse_Type = ::cty::c_uint;
#[doc = "< UART auto baudrate detection using codeword 0x55"]
pub const UART_AutoBaudDetection_Type_UART_AUTOBAUD_0X55: UART_AutoBaudDetection_Type = 0;
#[doc = "< UART auto baudrate detection using start bit"]
pub const UART_AutoBaudDetection_Type_UART_AUTOBAUD_STARTBIT: UART_AutoBaudDetection_Type = 1;
#[doc = "  @brief UART auto baudrate detection using codeword 0x55 or start bit definiton"]
pub type UART_AutoBaudDetection_Type = ::cty::c_uint;
#[doc = "< UART tx transfer end interrupt"]
pub const UART_INT_Type_UART_INT_TX_END: UART_INT_Type = 0;
#[doc = "< UART rx transfer end interrupt"]
pub const UART_INT_Type_UART_INT_RX_END: UART_INT_Type = 1;
#[doc = "< UART tx fifo interrupt when tx fifo count reaches,auto clear"]
pub const UART_INT_Type_UART_INT_TX_FIFO_REQ: UART_INT_Type = 2;
#[doc = "< UART rx fifo interrupt when rx fifo count reaches,auto clear"]
pub const UART_INT_Type_UART_INT_RX_FIFO_REQ: UART_INT_Type = 3;
#[doc = "< UART rx time-out interrupt"]
pub const UART_INT_Type_UART_INT_RTO: UART_INT_Type = 4;
#[doc = "< UART rx parity check error interrupt"]
pub const UART_INT_Type_UART_INT_PCE: UART_INT_Type = 5;
#[doc = "< UART tx fifo overflow/underflow error interrupt"]
pub const UART_INT_Type_UART_INT_TX_FER: UART_INT_Type = 6;
#[doc = "< UART rx fifo overflow/underflow error interrupt"]
pub const UART_INT_Type_UART_INT_RX_FER: UART_INT_Type = 7;
#[doc = "< All the interrupt"]
pub const UART_INT_Type_UART_INT_ALL: UART_INT_Type = 8;
#[doc = "  @brief UART interrupt type definition"]
pub type UART_INT_Type = ::cty::c_uint;
#[doc = "< UART tx fifo overflow"]
pub const UART_Overflow_Type_UART_TX_OVERFLOW: UART_Overflow_Type = 0;
#[doc = "< UART tx fifo underflow"]
pub const UART_Overflow_Type_UART_TX_UNDERFLOW: UART_Overflow_Type = 1;
#[doc = "< UART rx fifo overflow"]
pub const UART_Overflow_Type_UART_RX_OVERFLOW: UART_Overflow_Type = 2;
#[doc = "< UART rx fifo underflow"]
pub const UART_Overflow_Type_UART_RX_UNDERFLOW: UART_Overflow_Type = 3;
#[doc = "  @brief UART overflow or underflow type definition"]
pub type UART_Overflow_Type = ::cty::c_uint;
#[doc = "  @brief UART configuration structure type definition"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct UART_CFG_Type {
    #[doc = "< Uart module clock"]
    pub uartClk: u32,
    #[doc = "< Uart baudrate"]
    pub baudRate: u32,
    #[doc = "< Uart frame length of data bit"]
    pub dataBits: UART_DataBits_Type,
    #[doc = "< Uart frame length of stop bit"]
    pub stopBits: UART_StopBits_Type,
    #[doc = "< Uart parity check type"]
    pub parity: UART_Parity_Type,
    #[doc = "< Enable or disable tx CTS flow control"]
    pub ctsFlowControl: BL_Fun_Type,
    #[doc = "< Enable or disable rx input de-glitch function"]
    pub rxDeglitch: BL_Fun_Type,
    #[doc = "< Enable or disable rx RTS output SW control mode"]
    pub rtsSoftwareControl: BL_Fun_Type,
    #[doc = "< Uart each data byte is send out LSB-first or MSB-first"]
    pub byteBitInverse: UART_ByteBitInverse_Type,
}
impl Default for UART_CFG_Type {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "  @brief UART FIFO configuration structure type definition"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct UART_FifoCfg_Type {
    #[doc = "< TX FIFO threshold, dma tx request will not be asserted if tx fifo count is less than this value"]
    pub txFifoDmaThreshold: u8,
    #[doc = "< RX FIFO threshold, dma rx request will not be asserted if rx fifo count is less than this value"]
    pub rxFifoDmaThreshold: u8,
    #[doc = "< Enable or disable tx dma req/ack interface"]
    pub txFifoDmaEnable: BL_Fun_Type,
    #[doc = "< Enable or disable rx dma req/ack interface"]
    pub rxFifoDmaEnable: BL_Fun_Type,
}
impl Default for UART_FifoCfg_Type {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "  @brief UART infrared configuration structure type definition"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct UART_IrCfg_Type {
    #[doc = "< Enable or disable uart tx ir mode"]
    pub txIrEnable: BL_Fun_Type,
    #[doc = "< Enable or disable uart rx ir mode"]
    pub rxIrEnable: BL_Fun_Type,
    #[doc = "< Enable or disable inverse signal of uart tx output in ir mode"]
    pub txIrInverse: BL_Fun_Type,
    #[doc = "< Enable or disable inverse signal of uart rx input in ir mode"]
    pub rxIrInverse: BL_Fun_Type,
    #[doc = "< Set start position of uart tx ir pulse"]
    pub txIrPulseStart: u16,
    #[doc = "< Set stop position of uart tx ir pulse"]
    pub txIrPulseStop: u16,
    #[doc = "< Set start position of uart rx pulse recovered from ir signal"]
    pub rxIrPulseStart: u16,
}
impl Default for UART_IrCfg_Type {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_Init(uartId: UART_ID_Type, uartCfg: *mut UART_CFG_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_DeInit(uartId: UART_ID_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_FifoConfig(uartId: UART_ID_Type, fifoCfg: *mut UART_FifoCfg_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_IrConfig(uartId: UART_ID_Type, irCfg: *mut UART_IrCfg_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_Enable(uartId: UART_ID_Type, direct: UART_Direction_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_Disable(uartId: UART_ID_Type, direct: UART_Direction_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_SetTxDataLength(uartId: UART_ID_Type, length: u16) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_SetRxDataLength(uartId: UART_ID_Type, length: u16) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_SetRxTimeoutValue(uartId: UART_ID_Type, time: u8) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_SetDeglitchCount(uartId: UART_ID_Type, deglitchCnt: u8) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_SetBaudrate(
        uartId: UART_ID_Type,
        autoBaudDet: UART_AutoBaudDetection_Type,
    ) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_SetRtsValue(uartId: UART_ID_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_ClrRtsValue(uartId: UART_ID_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_TxFreeRun(uartId: UART_ID_Type, txFreeRun: BL_Fun_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_AutoBaudDetection(uartId: UART_ID_Type, autoBaud: BL_Fun_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_TxFifoClear(uartId: UART_ID_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_RxFifoClear(uartId: UART_ID_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_IntMask(
        uartId: UART_ID_Type,
        intType: UART_INT_Type,
        intMask: BL_Mask_Type,
    ) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_IntClear(uartId: UART_ID_Type, intType: UART_INT_Type) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_Int_Callback_Install(
        uartId: UART_ID_Type,
        intType: UART_INT_Type,
        cbFun: intCallback_Type,
    ) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_SendData(uartId: UART_ID_Type, data: *mut u8, len: u32) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_SendDataBlock(uartId: UART_ID_Type, data: *mut u8, len: u32) -> BL_Err_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_ReceiveData(uartId: UART_ID_Type, data: *mut u8, maxLen: u32) -> u32;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_GetAutoBaudCount(
        uartId: UART_ID_Type,
        autoBaudDet: UART_AutoBaudDetection_Type,
    ) -> u16;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_GetTxFifoCount(uartId: UART_ID_Type) -> u8;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_GetRxFifoCount(uartId: UART_ID_Type) -> u8;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_GetIntStatus(uartId: UART_ID_Type, intType: UART_INT_Type) -> BL_Sts_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_GetTxBusBusyStatus(uartId: UART_ID_Type) -> BL_Sts_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_GetRxBusBusyStatus(uartId: UART_ID_Type) -> BL_Sts_Type;
}
#[safe_wrap(_)] extern "C" {
    pub fn UART_GetOverflowStatus(
        uartId: UART_ID_Type,
        overflow: UART_Overflow_Type,
    ) -> BL_Sts_Type;
}
pub type cb_uart_notify_t = ::core::option::Option<unsafe extern "C" fn(arg: *mut ::cty::c_void)>;
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_gpio_init(
        id: u8,
        tx: u8,
        rx: u8,
        rts: u8,
        cts: u8,
        baudrate: ::cty::c_int,
    ) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_init(
        id: u8,
        tx_pin: u8,
        rx_pin: u8,
        cts_pin: u8,
        rts_pin: u8,
        baudrate: u32,
    ) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_debug_early_init(baudrate: u32) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_early_init(id: u8, tx_pin: u8, baudrate: u32) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_rx_enable(id: u8) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_rx_disable(id: u8) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_tx_enable(id: u8) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_tx_disable(id: u8) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_string_send(id: u8, data: *mut ::cty::c_char) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_flush(id: u8) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_getdefconfig(id: u8, parity: *mut u8);
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_setconfig(id: u8, baudrate: u32, parity: UART_Parity_Type);
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_setbaud(id: u8, baud: u32);
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_data_send(id: u8, data: u8) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_datas_send(id: u8, data: *mut u8, len: ::cty::c_int) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_data_recv(id: u8) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_enable(id: u8) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_disable(id: u8) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_rx_notify_register(
        id: u8,
        cb: cb_uart_notify_t,
        arg: *mut ::cty::c_void,
    ) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_tx_notify_register(
        id: u8,
        cb: cb_uart_notify_t,
        arg: *mut ::cty::c_void,
    ) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_rx_notify_unregister(
        id: u8,
        cb: cb_uart_notify_t,
        arg: *mut ::cty::c_void,
    ) -> ::cty::c_int;
}
#[safe_wrap(_)] extern "C" {
    pub fn bl_uart_int_tx_notify_unregister(
        id: u8,
        cb: cb_uart_notify_t,
        arg: *mut ::cty::c_void,
    ) -> ::cty::c_int;
}
