use std::collections::HashMap;

use anyhow::{Context, Result};
use serde::Deserialize;

use crate::bktypes::grade::GradeSheet;

use super::{HtmlExt, MyBK};

pub struct StInfo<'a> {
    client: &'a reqwest::Client,
    token: String,
}

impl<'a> StInfo<'a> {
    pub async fn from_mybk(mybk: &'a MyBK) -> Result<StInfo<'a>> {
        let client = &mybk.client;
        let res = client
            .get("https://mybk.hcmut.edu.vn/stinfo/")
            .send()
            .await?;

        let html = scraper::Html::parse_document(&res.text().await?);
        let token = html
            .get_named_input("_token")
            .context("token not found in parsed document")?
            .to_owned();

        Ok(Self { client, token })
    }

    pub async fn get_grade_sheet(&self) -> GradeSheet {
        const GRADE_URL: &str = "https://mybk.hcmut.edu.vn/stinfo/grade/ajax_grade";
        let res = self
            .client
            .post(GRADE_URL)
            .form(&[("_token", &self.token)])
            .send()
            .await
            .expect("grade error");

        #[derive(Deserialize, Debug)]
        struct SemesterGrade {
            diem: GradeSheet,
        }

        let map = res.json::<HashMap<String, SemesterGrade>>().await.unwrap();

        map.into_iter().flat_map(|(_, v)| v.diem).collect()
    }
}
