use super::{HtmlExt, MyBK};
use anyhow::Context;

pub struct ELearning<'a> {
    client: &'a reqwest::Client,
    sesskey: String,
}

impl<'a> ELearning<'a> {
    pub async fn from_mybk(mybk: &'a MyBK) -> anyhow::Result<ELearning<'a>> {
        let client = &mybk.client;

        // login to e-learning
        client
            .get("http://e-learning.hcmut.edu.vn/login/index.php?authCAS=CAS")
            .send()
            .await?;

        // get sesskey for api calls
        let res = client
            .get("http://e-learning.hcmut.edu.vn/my/")
            .send()
            .await?;

        let html = scraper::Html::parse_document(&res.text().await?);
        let sesskey = html
            .get_named_input("sesskey")
            .context("sesskey not found in parsed document")?
            .to_owned();

        Ok(Self { client, sesskey })
    }
}
