use anyhow::Result;
use bkrapper::{mybk::MyBK, bktypes::grade::GradeSheet};

#[tokio::main]
async fn main() -> Result<()> {
    dotenv::dotenv().expect("error loading .env");
    let username = std::env::var("USERNAME").expect("username not found");
    let password = std::env::var("PASSWORD").expect("password not found");

    let mybk = MyBK::with_credential(&username, &password).await;

    // dbg!(client.get_courses());

    let stinfo = mybk.get_stinfo().await?;

    let sheet = stinfo.get_grade_sheet().await;
    let sheet_old = GradeSheet::load();

    if sheet != sheet_old {
        println!("Shit happened");
    } else {
        println!("No thing changed");
    }

    sheet.save();

    mybk.logout().await;

    Ok(())
}
