use crate::*;
use crate::game::{RoomType, RoomFormat};

pub mod image {
    use crate::Image;

    pub fn chequers_1() -> Image {
        Image {
            pixels: vec![
                1, 0, 1, 0, 1, 0, 1, 0,
                0, 1, 0, 1, 0, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0,
                0, 1, 0, 1, 0, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0,
                0, 1, 0, 1, 0, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0,
                0, 1, 0, 1, 0, 1, 0, 1,
            ],
        }
    }

    pub fn chequers_2() -> Image {
        Image {
            pixels: vec![
                0, 1, 0, 1, 0, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0,
                0, 1, 0, 1, 0, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0,
                0, 1, 0, 1, 0, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0,
                0, 1, 0, 1, 0, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0,
            ],
        }
    }

    pub fn asymmetrical() -> Image {
        Image { pixels: vec![
            0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,
            0,1,0,0,0,0,0,0,
            1,0,0,0,0,0,0,0,
            1,0,0,0,0,0,0,0,
            0,1,0,0,0,0,0,0,
            0,0,1,0,0,0,0,0,
            0,0,0,1,0,0,0,0,
        ]}
    }

    pub fn animation_frames() -> Vec<Image> {
        vec![
            Image {
                pixels: vec![
                    1,0,0,1,1,0,0,1,
                    0,0,1,1,0,0,1,1,
                    0,1,1,0,0,1,1,0,
                    1,1,0,0,1,1,0,0,
                    1,0,0,1,1,0,0,1,
                    0,0,1,1,0,0,1,1,
                    0,1,1,0,0,1,1,0,
                    1,1,0,0,1,1,0,0,
                ]
            },
            Image {
                pixels: vec![
                    1,1,0,0,1,1,0,0,
                    1,0,0,1,1,0,0,1,
                    0,0,1,1,0,0,1,1,
                    0,1,1,0,0,1,1,0,
                    1,1,0,0,1,1,0,0,
                    1,0,0,1,1,0,0,1,
                    0,0,1,1,0,0,1,1,
                    0,1,1,0,0,1,1,0,
                ]
            },
            Image {
                pixels: vec![
                    0,1,1,0,0,1,1,0,
                    1,1,0,0,1,1,0,0,
                    1,0,0,1,1,0,0,1,
                    0,0,1,1,0,0,1,1,
                    0,1,1,0,0,1,1,0,
                    1,1,0,0,1,1,0,0,
                    1,0,0,1,1,0,0,1,
                    0,0,1,1,0,0,1,1,
                ]
            },
            Image {
                pixels: vec![
                    0,0,1,1,0,0,1,1,
                    0,1,1,0,0,1,1,0,
                    1,1,0,0,1,1,0,0,
                    1,0,0,1,1,0,0,1,
                    0,0,1,1,0,0,1,1,
                    0,1,1,0,0,1,1,0,
                    1,1,0,0,1,1,0,0,
                    1,0,0,1,1,0,0,1,
                ]
            },
        ]
    }
}

pub fn avatar() -> Sprite {
    Sprite {
        id: "0".to_string(),
        animation_frames: vec![
            Image {
                pixels: vec![
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1,
                    1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0,
                ],
            },
            Image {
                pixels: vec![
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1,
                    1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0,
                ],
            },
        ],
        name: None,
        room_id: Some("0".to_string()),
        position: Some(Position { x: 2, y: 5 }),
        colour_id: None,
        dialogue_id: None,
        items: vec![]
    }
}

pub fn tile_default() -> Tile {
    Tile {
        id: "a".to_string(),
        name: Some("block".to_string()),
        wall: None,
        animation_frames: vec![Image {
            pixels: vec![
                1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 1, 1, 0, 0, 1,
                1, 0, 0, 1, 1, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 1,
                1, 0, 0, 0, 0, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1,
            ],
        }],
        colour_id: None,
    }
}

pub fn tile_background() -> Tile {
    Tile {
        id: "0".to_string(),
        name: None,
        wall: None,
        animation_frames: vec![Image {pixels: vec![0; 64]}],
        colour_id: None
    }
}

pub fn sprite() -> Sprite {
    Sprite {
        id: "a".to_string(),
        name: Some("hatch".to_string()),
        animation_frames: vec![Image {
            pixels: vec![
                0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 0, 0, 0,
                0, 1, 0, 0, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 0, 0,
                0, 1, 0, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 1, 0,
                0, 1, 1, 0, 1, 1, 1, 1,
            ],
        }],
        dialogue_id: Some("0".to_string()),
        room_id: Some("4".to_string()),
        position: Some(Position { x: 9, y: 7 }),
        colour_id: None,
        items: vec![]
    }
}

pub mod item {
    use crate::{Image, Item};

    pub fn key() -> Item {
        Item {
            id: "1".to_string(),
            animation_frames: vec![
                Image { pixels: vec![
                    0, 0, 0, 0, 0, 0, 0, 0,
                    0, 0, 1, 1, 1, 1, 0, 0,
                    0, 0, 1, 0, 0, 1, 0, 0,
                    0, 0, 1, 1, 1, 1, 0, 0,
                    0, 0, 0, 1, 0, 0, 0, 0,
                    0, 0, 0, 1, 1, 0, 0, 0,
                    0, 0, 0, 1, 0, 0, 0, 0,
                    0, 0, 0, 1, 1, 0, 0, 0
                ]}
            ],
            name: Some("key".to_string()),
            dialogue_id: Some("2".to_string()),
            colour_id: None
        }
    }
}

pub fn item() -> Item {
    Item {
        id: "6".to_string(),
        animation_frames: vec![Image {
            pixels: vec![
                0, 1, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 1, 0, 0,
                0, 0, 1, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 1, 0,
            ],
        }],
        name: Some("door".to_string()),
        dialogue_id: Some("2".to_string()),
        colour_id: None,
    }
}

pub fn room() -> Room {
    Room {
        id: "a".to_string(),
        palette_id: Some("9".to_string()),
        name: Some("cellar 7".to_string()),
        tiles: vec![
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "1l".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "y".to_string(),
            "x".to_string(),
            "0".to_string(),
            "0".to_string(),
            "1j".to_string(),
            "0".to_string(),
            "0".to_string(),
            "1j".to_string(),
            "1l".to_string(),
            "0".to_string(),
            "1j".to_string(),
            "0".to_string(),
            "0".to_string(),
            "1j".to_string(),
            "0".to_string(),
            "0".to_string(),
            "y".to_string(),
            "y".to_string(),
            "x".to_string(),
            "k".to_string(),
            "k".to_string(),
            "1c".to_string(),
            "1x".to_string(),
            "1y".to_string(),
            "1m".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "y".to_string(),
            "y".to_string(),
            "y".to_string(),
            "x".to_string(),
            "k".to_string(),
            "s".to_string(),
            "s".to_string(),
            "s".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "1g".to_string(),
            "1f".to_string(),
            "k".to_string(),
            "k".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "1i".to_string(),
            "1u".to_string(),
            "1u".to_string(),
            "1u".to_string(),
            "1v".to_string(),
            "11".to_string(),
            "19".to_string(),
            "1b".to_string(),
            "1a".to_string(),
            "1e".to_string(),
            "10".to_string(),
            "k".to_string(),
            "k".to_string(),
            "z".to_string(),
            "z".to_string(),
            "11".to_string(),
            "12".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "10".to_string(),
            "17".to_string(),
            "z".to_string(),
            "18".to_string(),
            "1e".to_string(),
            "12".to_string(),
            "k".to_string(),
            "k".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "1k".to_string(),
            "14".to_string(),
            "15".to_string(),
            "16".to_string(),
            "1h".to_string(),
            "z".to_string(),
            "k".to_string(),
            "k".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "10".to_string(),
            "1d".to_string(),
            "1v".to_string(),
            "1r".to_string(),
            "1s".to_string(),
            "1r".to_string(),
            "1q".to_string(),
            "1z".to_string(),
            "k".to_string(),
            "k".to_string(),
            "z".to_string(),
            "z".to_string(),
            "12".to_string(),
            "10".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "1i".to_string(),
            "1n".to_string(),
            "1o".to_string(),
            "1o".to_string(),
            "1o".to_string(),
            "1p".to_string(),
            "z".to_string(),
            "k".to_string(),
            "k".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "10".to_string(),
            "z".to_string(),
            "z".to_string(),
            "k".to_string(),
            "k".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "11".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "k".to_string(),
            "k".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "z".to_string(),
            "12".to_string(),
            "z".to_string(),
            "z".to_string(),
            "10".to_string(),
            "12".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "k".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
            "0".to_string(),
        ],
        items: vec![
            Instance {
                position: Position { x: 11, y: 5 },
                id: "d".to_string(),
            },
            Instance {
                position: Position { x: 8, y: 3 },
                id: "e".to_string(),
            },
            Instance {
                position: Position { x: 1, y: 0 },
                id: "5".to_string(),
            },
            Instance {
                position: Position { x: 2, y: 1 },
                id: "6".to_string(),
            },
            Instance {
                position: Position { x: 3, y: 2 },
                id: "6".to_string(),
            },
        ],
        exits: vec![ExitInstance {
            position: Position { x: 3, y: 3 },
            exit: Exit {
                room_id: "3".to_string(),
                position: Position { x: 10, y: 6 },
                effect: Transition::None,
            },
            transition: None,
            dialogue_id: None
        }],
        endings: vec![Instance {
            position: Position { x: 8, y: 7 },
            id: "undefined".to_string(),
        }],
        walls: None,
    }
}

pub fn game_default() -> Game {
    Game {
        name: "Write your game's title here".to_string(),
        version: Some(Version { major: 7, minor: 10 }),
        room_format: Some(RoomFormat::CommaSeparated),
        room_type: RoomType::Room,
        font: Font::AsciiSmall,
        custom_font: None,
        text_direction: TextDirection::LeftToRight,
        palettes: vec![Palette {
            id: "0".to_string(),
            name: Some("blueprint".to_string()),
            colours: vec![
                Colour {
                    red: 0,
                    green: 82,
                    blue: 204,
                },
                Colour {
                    red: 128,
                    green: 159,
                    blue: 255,
                },
                Colour {
                    red: 255,
                    green: 255,
                    blue: 255,
                },
            ],
        }],
        rooms: vec![Room {
            id: "0".to_string(),
            palette_id: Some("0".to_string()),
            name: Some("example room".to_string()),
            tiles: vec![
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "a".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
                "0".to_string(),
            ],
            items: vec![],
            exits: vec![],
            endings: vec![],
            walls: None,
        }],
        tiles: vec![self::tile_default()],
        sprites: vec![
            Sprite {
                id: "A".to_string(),
                animation_frames: vec![Image {
                    pixels: vec![
                        0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
                        1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0,
                        0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
                    ],
                }],
                name: None,
                room_id: Some("0".to_string()),
                position: Option::from(Position { x: 4, y: 4 }),
                colour_id: None,
                dialogue_id: None,
                items: vec![]
            },
            Sprite {
                id: "a".to_string(),
                name: Some("cat".to_string()),
                animation_frames: vec![Image {
                    pixels: vec![
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1,
                        1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1,
                        1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
                    ],
                }],
                dialogue_id: Some("0".to_string()),
                room_id: Some("0".to_string()),
                position: Some(Position { x: 8, y: 12 }),
                colour_id: None,
                items: vec![]
            },
        ],
        items: vec![
            Item {
                id: "0".to_string(),
                animation_frames: vec![Image {
                    pixels: vec![
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                        1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1,
                        1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    ],
                }],
                name: Some("tea".to_string()),
                dialogue_id: Some("1".to_string()),
                colour_id: None,
            },
            item::key()
        ],
        dialogues: vec![
            Dialogue {
                id: "0".to_string(),
                contents: "I'm a cat".to_string(),
                name: Some("cat dialog".to_string()),
            },
            Dialogue {
                id: "1".to_string(),
                contents: "You found a nice warm cup of tea".to_string(),
                name: Some("tea dialog".to_string()),
            },
            Dialogue {
                id: "2".to_string(),
                contents: "A key! {wvy}What does it open?{wvy}".to_string(),
                name: Some("key dialog".to_string())
            }
        ],
        endings: vec![],
        variables: vec![Variable {
            id: "a".to_string(),
            initial_value: "42".to_string(),
        }],
        font_data: None,
        line_endings_crlf: false
    }
}
