// @generated

//! [Tamzen font](https://github.com/sunaku/tamzen-font)-based bitmap fonts. The included glyphs
//! are a subset of ISO 8859-1 plus the unicode powerline symbols. Additional symbols might be added
//! in the future. If you are missing a glyph that is included in the Tamzen font, please open an
//! issue.
//!
//! Each font comes with a pixel-double version that can be used with no significant additional flash
//! size cost. You can also adjust the pixel multiplier yourself if you want even bigger fonts, or
//! save even more flash space.
//!
//! | Font | Flash Size (in Byte) | Screenshot | Pixel-double Font | Pixel-double Screenshot |
//! | ---- | --------------------:|:----------:| ----------------- |:-----------------------:|
#![doc = concat!(
	"| [`FONT_5x9`] | 972 | ![Screenshot](",
	font_bmp!(FONT_5x9),
	") | [`FONT_10x18`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_10x18),
	")"
)]
#![doc = concat!(
	"| [`FONT_5x9_BOLD`] | 972 | ![Screenshot](",
	font_bmp!(FONT_5x9_BOLD),
	") | [`FONT_10x18_BOLD`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_10x18_BOLD),
	")"
)]
#![doc = concat!(
	"| [`FONT_6x12`] | 1,584 | ![Screenshot](",
	font_bmp!(FONT_6x12),
	") | [`FONT_12x24`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_12x24),
	")"
)]
#![doc = concat!(
	"| [`FONT_6x12_BOLD`] | 1,584 | ![Screenshot](",
	font_bmp!(FONT_6x12_BOLD),
	") | [`FONT_12x24_BOLD`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_12x24_BOLD),
	")"
)]
#![doc = concat!(
	"| [`FONT_7x13`] | 1,976 | ![Screenshot](",
	font_bmp!(FONT_7x13),
	") | [`FONT_14x26`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_14x26),
	")"
)]
#![doc = concat!(
	"| [`FONT_7x13_BOLD`] | 1,976 | ![Screenshot](",
	font_bmp!(FONT_7x13_BOLD),
	") | [`FONT_14x26_BOLD`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_14x26_BOLD),
	")"
)]
#![doc = concat!(
	"| [`FONT_7x14`] | 2,128 | ![Screenshot](",
	font_bmp!(FONT_7x14),
	") | [`FONT_14x28`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_14x28),
	")"
)]
#![doc = concat!(
	"| [`FONT_7x14_BOLD`] | 2,128 | ![Screenshot](",
	font_bmp!(FONT_7x14_BOLD),
	") | [`FONT_14x28_BOLD`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_14x28_BOLD),
	")"
)]
#![doc = concat!(
	"| [`FONT_8x15`] | 2,640 | ![Screenshot](",
	font_bmp!(FONT_8x15),
	") | [`FONT_16x30`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_16x30),
	")"
)]
#![doc = concat!(
	"| [`FONT_8x15_BOLD`] | 2,640 | ![Screenshot](",
	font_bmp!(FONT_8x15_BOLD),
	") | [`FONT_16x30_BOLD`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_16x30_BOLD),
	")"
)]
#![doc = concat!(
	"| [`FONT_8x16`] | 2,816 | ![Screenshot](",
	font_bmp!(FONT_8x16),
	") | [`FONT_16x32`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_16x32),
	")"
)]
#![doc = concat!(
	"| [`FONT_8x16_BOLD`] | 2,816 | ![Screenshot](",
	font_bmp!(FONT_8x16_BOLD),
	") | [`FONT_16x32_BOLD`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_16x32_BOLD),
	")"
)]
#![doc = concat!(
	"| [`FONT_10x20`] | 4,320 | ![Screenshot](",
	font_bmp!(FONT_10x20),
	") | [`FONT_20x40`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_20x40),
	")"
)]
#![doc = concat!(
	"| [`FONT_10x20_BOLD`] | 4,320 | ![Screenshot](",
	font_bmp!(FONT_10x20_BOLD),
	") | [`FONT_20x40_BOLD`] | ![Pixel-double Screenshot](",
	font_bmp!(FONT_20x40_BOLD),
	")"
)]

macro_rules! font_bmp {
	(FONT_5x9) => {
		"data:image/bmp;base64,Qk0KBAAAAAAAAD4AAAAoAAAAYAAAAK////8BAAEAAAAAAAAAAAABAAAAAQAAAAAAAAAAAAAAAAAAAP///wAAAAAAAAAAAAAAAAACFKJhhBQAAAAAAAACFedqhCIIQAAEYTgCFKgRBEE8QAAEkwQCAUYiwEEZ8HgIkQgAAeFagEEkQAAIkRACAU4bQEEARgGQY7wAAAQAACIAAgAQAAAAAAAAABQABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADjAAAADxPM8xgACAgUmcdzwjIQJKTGE8QlpShKBlOcIxwAIAJFvchLgXhSRIQAE8QEJShKDhOMQxjGCAhEJcdzwAAAAAACAAADgAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADzpOFKEpM4zjvylKSEJEFSHtSlKUCSlKTlvEFiErS5LjCSlJiEpElSEpShKgiSZ6SDpOZL0pMgyXCOZKQAAAAAAAAAYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHA4ACAQAIBgQISCPkQIQBAQAICAQACBREQIoAncY53ncYygiEIIAAJShKiJSITAkEIIAAJShLCJSISgnkEIAAHcY5yHScSQAEEID4AAAAABAAQAAHA4AAAAAAAGABgAAAAAAAAAAAAAAAABgAAAAAAAAAAAGJgAgAAAAAEAAAAAEIjQluM46zvSlKUvEIiwnpSlLCESlJkicI4AkpSlKBESZ5kkEIgB0pM46HjOZ6TPEIgAAAAgIAAAAABAGJgAAAAgIAAAAACAAAAAAAAAAAAAAAAAAQIgBDSiQAEERpRgAIRQDkMURgCIpYCnO97xFOSISRDGMQxKQhCAFES+BgFKUpSvQ5zhDkMIQBPe973qQhCBBPSIQCJSlKUrO97xAAAAQEAAAAAAEAABAAAAADgAAAAAMAABSBEUDUBI1IAICRRABCKACyCUsAAkEoAjznAdwDGAAwDJSBKKBCOIqUpMZJUpSlJThCEJrUpSlIkpSlIiBCEIq0pSlJUpSlIjznOdyTGMYwDGMYwgAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAJoBgAAAgAAIBAAICVZSgAgJSkCUryDkEAABAAQQACEAAjknOc5zvMc5zmMYxiVJSlKUnQpSlCEISTkpSlKUqQxjGCEISSFHOc5zvMc5znOc5gAAAAAAAIAAAAAAAAAAAAAAAYAAAAAAADQAI0AAAAQAAAQgEK0BUtIAICpQUKYQMQCCAAAgkEAAkAcIcjjGMYwDJSlKXJeE9CUpSlJ0pSlKUpfD+CUpSlIEpSlKUpeE9CTGMYwjGMYx3HcIcgAAAAAEAAAAUBYQMQAAAAAAAAABkGQgEI="
	};
	(FONT_10x18) => {
		"data:image/bmp;base64,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"
	};
	(FONT_5x9_BOLD) => {
		"data:image/bmp;base64,Qk0KBAAAAAAAAD4AAAAoAAAAYAAAAK////8BAAEAAAAAAAAAAAABAAAAAQAAAAAAAAAAAAAAAAAAAP///wAAAAAAAAAAAAAAAAADPKJBjDYIAAAAAAADPeJLTGM8wAAGYzgDKKcZjMGYwAAG1wwDAeYzYMG58HgM0xgAAeNjQMGoxgGM0zADAK9LoGMAxgGYZ7wAAAQIADYADAAYAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABjAAAADhvM8xjGGBi2icdzwzsYNrTGM8w2naxrBlucYxwAYAZmrcxrg3jaxozGM8wGPaxrDhuMwxjGGBhmLcdzwAAAAAAMAAADgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADzteNrEtM4zjva1LTGNMNrHta1rWGa1JjmvMNzHva5rjGa15jGtMtrEraxrhma55jDteZr0rMwzXGMRLQAAAAAAAAAYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHA4gEAYAYBgYYbDXmYZwGAYAYDAYADDRmYZQDHcc53nc47RjGMYABLaxazNaYbhmGMYAALaxbjNaYbRnmGYAAHcc5zHa8bQAHG4D4AAAAADAAYAAAAAAAAAAAAGABwAAAAAAAAAAAAAAAADgAAAAAAAAAAAHZxRgAAAAAGAAAAAGYzxmuM47zva1rWvGYyhnta1bDGa1pmmeY8Bmta1bBma55msGYwD2tM47HnMRrTvGYwAAAAwYAAAAABgHZwAAAAwYAAAAADAAAAAAAAAAAAAJqQAAgJABDaAwAECVYDAAQSgDmM0xgCEAAlnO97xmPaYzTHOc5zKYxjAGGa8BgLWta1vY5zhjmMYwDPe973qYxjBhPaYwGLWta1rO97xgAAAwGgAAAAAEAABgAAAADAAAAAAMAACkBIoDUBI1QAIERQgCCUACyCUsAAkIoBD3ve9wDGMAwDNa1rTDGMYrWtaZrWta1rTjGMZr2ta1pmta1pjDGMYq2ta1rWta1pj3ve9yzGMYwDGMYxgAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAARoAAAABAAAQBAAICpajAAgKlICpTzDkEAAFgAQQAEEAAjmnOc5zPOc5zuc5xjXLWta1nYta1mMYyzmrWta1qY5znGMYyzHHOc5zvOc5zve95gAAAAAAAEAAAAAAAAAAAAAAAMAAAAAAADQAI0AAAAQAAAQgEK0BUtQAIEpQmKYQMQCCAABgkIABGAcIcjjGMYwDNa1rXNeE9DWta1r2ta1rWtfD+DWta1oGta1rWteE9DTGMYxjGMYx3HcIcgAAAAAEAAAA2DYQMQAAAAAAAAABmGQgEI="
	};
	(FONT_10x18_BOLD) => {
		"data:image/bmp;base64,Qk1uDwAAAAAAAD4AAAAoAAAAwAAAAF7///8BAAEAAAAAAAAAAAABAAAAAQAAAAAAAAAAAAAAAAAAAP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADw/wzAwwA8DwDzwAwAAAAAAAAAAAAAAADw/wzAwwA8DwDzwAwAAAAAAAAAAAAAAADw/z/AwwzzDwPA8P8PAAAAAAPDwPD8AADw/z/AwwzzDwPA8P8PAAAAAAPDwPD8AADwzAzD8Dw8Dw8APDwPAAAAAAPPM/APAADwzAzD8Dw8Dw8APDwPAAAAAAPPM/APAADwAD/DwPDzwA8APPw/8AP8AA8PMPA8AADwAD/DwPDzwA8APPw/8AP8AA8PMPA8AAAAAD/A88DzAA8APMwPA8AAPA8PMPDwAAAAAD/A88DzAA8APMwPA8AAPA8PMPDwAADwAAzP8wz8wAPA8AAPA8AAPDwDw/z/AADwAAzP8wz8wAPA8AAPA8AAPDwDw/z/AAAAAAADAAwAAADzwAAADwAAADwAAAAAAAAAAAADAAwAAADzwAAADwAAADwAAAAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8DwAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8DwAAAAAAAAD8A8/w8P8PA8DwPAPAA8DPPMDD8D8/D/D8A8/w8P8PA8DwPAPAA8DPPMDD8D8/D/APD88DwA88zzDwPA8P8PAPPMPzzPA8zwAPD88DwA88zzDwPA8P8PAPPMPzzPA8zwA8M8/D8DwPA/AAADwAADw8PMzz8PA8z8A8M8/D8DwPA/AAADwAADw8PMzz8PA8z8APP8DzzPA8wPDwPA8P8PAAPA/zzPA8zwAPP8DzzPA8wPDwPA8P8PAAPA/zzPA8zwD8A8/A8PAPA8DwPAPAA8A8PAzz8D8/D/D8A8/A8PAPA8DwPAPAA8A8PAzz8D8/D/AAAAAAAAAAAAAA8AAAAAAAD8AAAAAAAAAAAAAAAAAAAAAA8AAAAAAAD8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD/D88z/A88zwMM8w8PwPD8D8/zzPMwzzD/D88z/A88zwMM8w8PwPD8D8/zzPMwzzDwPA8w8A88zwP88zzPM8zzPAPDzPMww8DwPA8w8A88zwP88zzPM8zzPAPDzPMww8D8PM/w8A8/DwP8/zzPw8z8DwPDzPM/w8D8PM/w8A8/DwP8/zzPw8z8DwPDzPM/w8DwPM8w8M88zwMMzzzPA8z8A8PDzPw/w8DwPM8w8M88zwMMzzzPA8z8A8PDzPw/w8DwD88z/Dw8z/MMzw8PAPDzPwPA8DAwzzDwD88z/Dw8z/MMzw8PAPDzPwPA8DAwzzAAAAAAAAAAAAAAAAAAADwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAPwAPwMAAMAADwAADwAA8ADwDwDzwAAAAPwAPwMAAMAADwAADwAA8ADwDwDzwDzP8PDwDw/AAPAADwAADwADwADwAAADwDzP8PDwDw/AAPAADwAADwADwADwAAADwDzA8PDwDwzAADwPz8D8Pw/P8Pz8PwPzzDzA8PDwDwzAADwPz8D8Pw/P8Pz8PwPzzA8DwPA8DwAAAAwzzzPAzzPDw8zzDwDz8A8DwPA8DwAAAAwzzzPAzzPDw8zzDwDz8A8PAPA8DwAAAAAzzzPAzz8Dw8zzDwDzzA8PAPA8DwAAAAAzzzPAzz8Dw8zzDwDzzA8P8PAPDwAAAAAPz8D8Pw/DwPzzP8DzzA8P8PAPDwAAAAAPz8D8Pw/DwPzzP8DzzAAAAPwPPwAD/wAAAAAAAAAAADwAAADwAAAAAPwPPwAD/wAAAAAAAAAAADwAAADwAAAAAAAAAAAAAAAAAAAAAAAAAPAAAA/AAAAAAAAAAAAAAAAAAAAAAAAAAPAAAA/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD8AAAAAAAAAAAAAAAAAAAAAAAAPzw/AzD8AAAAAAAAAAAAAAAAAAAAAAAAPzw/AzA8AAAAAAAAAAAAPAAAAAAAAAAAPDwPD/A8AAAAAAAAAAAAPAAAAAAAAAAAPDwPD/A8PM/A8PwPz/D8/zzPM8zzPM/wPDwPDMA8PM/A8PwPz/D8/zzPM8zzPM/wPDwPDMA8P88zzPMzzwDwPDzPM8w8PMPD/DwP8AA8P88zzPMzzwDwPDzPM8w8PMPD/DwP8AA8PM8zzPMzzwA8PDzPw/w8PM8APDwPAAA8PM8zzPMzzwA8PDzPw/w8PM8APDwPAAD/PM8w8PwPzwP8Pw8DA8zzD8/wPDwPAAD/PM8w8PwPzwP8Pw8DA8zzD8/wPDwPAAAAAAAAAPADwAAAAAAAAAAAA8AAPzw/AAAAAAAAAPADwAAAAAAAAAAAA8AAPzw/AAAAAAAAAPADwAAAAAAAAAAADwAAAAAAAAAAAAAAAPADwAAAAAAAAAAADwAAAAAAAAAAAAAAAAAAAAAAAAAAw8zDAAAAAMAAwwAAAAAAAAAAAAAAAAAAw8zDAAAAAMAAwwAAAwDzzAAPAAAAMADDMzwADwAAADADDMAAAwDzzAAPAAAAMADDMzwADwAAADADDMAAD8PA8PMPA8AADAMAAAAMM8Pw/P8/z/AAD8PA8PMPA8AADAMAAAAMM8Pw/P8/z/A8PA/zzDwPDzDwPw/D8Pw/DwzDwPA8DwA8PA/zzDwPDzDwPw/D8Pw/DwzDwPA8DwAAPAPDzP8AA8AAzzPM8zzPM8/zwPw/D8AAPAPDzP8AA8AAzzPM8zzPM8/zwPw/D8A8D8PA8DwPAADw/z/P8/z/P8zDwPA8DwA8D8PA8DwPAADw/z/P8/z/P8zDwPA8DwA8Aw/zzDwPAAPAzzPM8zzPM8zw/P8/z/A8Aw/zzDwPAAPAzzPM8zzPM8zw/P8/z/A8AAAAAAAPAAPMAAAAAAAAAAAAMAAAAAA8AAAAAAAPAAPMAAAAAAAAAAAAMAAAAAA8AAAAAAAAAADwAAAAAAAAAAAA8AAAAAA8AAAAAAAAAADwAAAAAAAAAAAA8AAAAADMMAAwwMwADzMAAwwPMzAAAAwAMDAzAMDMMAAwwMwADzMAAwwPMzAAAAwAMDAzAMAADADDMAAADPDADDMM8AAAAMMAwMwAAwAADADDMAAADPDADDMM8AAAAMMAwMwAAwD/P8/z/P8/AADwPA8AAPAADw8zzPM8zzD/P8/z/P8/AADwPA8AAPAADw8zzPM8zzDwDwPA8DwMzzPM8zzDw8zzPM8zzPM8zzDwDwPA8DwMzzPM8zzDw8zzPM8zzPM8zzD8DwPA8Dw8z/PM8zzPM8w8PM8zzPM8w8D8DwPA8Dw8z/PM8zzPM8w8PM8zzPM8w8DwDwPA8DwMzPPM8zzPM8zzPM8zzPM8w8DwDwPA8DwMzPPM8zzPM8zzPM8zzPM8w8D/P8/z/P8/DPDwPA8DwPAADwPA8DwPA8D/P8/z/P8/DPDwPA8DwPAADwPA8DwPA8AAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADA8wAAAAAAAAAAwAAAAADAAAwAAAAAAADA8wAAAAAAAAAAwAAAAADAAAwAAAAwADMwzzMDwAAAMAAzMMwwADMwzD/AAAAwADMwzzMDwAAAMAAzMMwwADMwzD/DwD8MAMAAAAAM8AAADADAAAAMAMAAAAMDwD8MAMAAAAAM8AAADADAAAAMAMAAAAMD8PMPw/D8Pw/Dw/w/D8Pw/D8/D8Pw/A8D8PMPw/D8Pw/Dw/w/D8Pw/D8/D8Pw/A8DzPwzzPM8zzPM8PzwM8zzPM8PA8DwPDPDzPwzzPM8zzPM8PzwM8zzPM8PA8DwPDPD8PMzzPM8zzPM8zDwPw/D8PwPA8DwPDPD8PMzzPM8zzPM8zDwPw/D8PwPA8DwPDPDwPwPw/D8Pw/D8/w/D8Pw/D8/z/P8/w8DwPwPw/D8Pw/D8/w/D8Pw/D8/z/P8/w8AAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8AAAAAAAAAAAAAAADzAAAAwPMAAAAAAAADAAAAAAADAMAAMAzzAAAAwPMAAAAAAAADAAAAAAADAMAAMAzPMAAzMM8zAAAAwAMMwzAMPAzDwDAA8DDPMAAzMM8zAAAAwAMMwzAMPAzDwDAA8DAADADAAAAAA8AMMAwAAAAwPAAD8AwD8MAADADAAAAAA8AMMAwAAAAwPAAD8AwD8MD8DwPA8DwPAADw8zzPM8zzPw8z/AMP8wD8DwPA8DwPAADw8zzPM8zzPw8z/AMP8wDzPM8zzPM8z/PM8zzPM8zzPM8z/wD//ADzPM8zzPM8z/PM8zzPM8zzPM8z/wD//ADzPM8zzPM8wAPM8zzPM8zzPM8z/AMP8wDzPM8zzPM8wAPM8zzPM8zzPM8z/AMP8wDzDwPA8DwPA8DwPA8DwPA/PwPz8AwD8MDzDwPA8DwPA8DwPA8DwPA/PwPz8AwD8MAAAAAAAAAAAAMAAAAAAAAPPADzwDAA8DAAAAAAAAAAAAMAAAAAAAAPPADzwDAA8DAAAAAAAAAAAAAAAAAAAAA8PAPDAMAAMAwAAAAAAAAAAAAAAAAAAAA8PAPDAMAAMAw="
	};
	(FONT_6x12) => {
		"data:image/bmp;base64,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"
	};
	(FONT_12x24) => {
		"data:image/bmp;base64,Qk3+GAAAAAAAAD4AAAAoAAAAwAAAAPj+//8BAAEAAAAAAAAAAAABAAAAAQAAAAAAAAAAAAAAAAAAAP///wAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMAzAzADAwAwAMADAwAAAAAAAAAAAAAAAMAzAzADAwAwAMADAwAAAAAAAAAAAAAAAMAzAzAPzMDMAMAMAMAAAAAAAAAAADAAAMAzAzAPzMDMAMAMAMAAAAAAAAAAADAAAMAzD/wwDMzMAMAMAMAMAMAAAAAAADAAAMAzD/wwDMzMAMAMAMAMAMAAAAAAADAAAMAAAzAMAzAwAAAwADDMwMAAAAAAAMAAAMAAAzAMAzAwAAAwADDMwMAAAAAAAMAAAMAAAzADAMDMwAAwADA/D/wAD/wAAMAAAMAAAzADAMDMwAAwADA/D/wAD/wAAMAAAAAAD/wAwzDDAAAwADDMwMAAAAAAAwAAAAAAD/wAwzDDAAAwADDMwMAAAAAAAwAAAAAAAzA/DMzDAAAwADAMAMA8AAA8AwAAAAAAAzA/DMzDAAAwADAMAMA8AAA8AwAAAMAAAzAMAMw8wAAMAMAAAAA8AAA8DAAAAMAAAzAMAMw8wAAMAMAAAAA8AAA8DAAAAAAAAAAMADAAAAAMAMAAAAAMAAAADAAAAAAAAAAMADAAAAAMAMAAAAAMAAAADAAAAAAAAAAAAAAAAAADAwAAAAAwAAAAAAAAAAAAAAAAAAAAAAADAwAAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/A/AMA/D/wDD/wPD/w/A/AAAAAAwADADAw/AMA/D/wDD/wPD/w/A/AAAAAAwADADAzAw8DAwAwPDAAwAAzAzAw8A8ADAAAwAAzAw8DAwAwPDAAwAAzAzAw8A8ADAAAwAAzDzMAAwDAzD/DAADDAzAw8A8AMD/wMADDDzMAAwDAzD/DAADDAzAw8A8AMD/wMADDMwMADAPDDAAz/ADA/A/wAAAAwAAADAMDMwMADAPDDAAz/ADA/A/wAAAAwAAADAMDwwMAMAAz/wAzAwMDAwAwAAAAMD/wMAADwwMAMAAz/wAzAwMDAwAwAAAAMD/wMAADAwMAwDAwDDAzAwMDAwDA8A8ADAAAwAADAwMAwDAwDDAzAwMDAwDA8A8ADAAAwAAA/D/z/w/ADA/A/AMA/A8A8A8AAwADAAMA/D/z/w/ADA/A/AMA/A8A8A8AAwADAAMAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAwMD/APz/D/z/wPzAw/AAzAzADAzAw/DAwMD/APz/D/z/wPzAw/AAzAzADAzAw/DAwzDAwwDAzADAAwDAwMAAzDDADzzwzAzAwzDAwwDAzADAAwDAwMAAzDDADzzwzAzDzAzAzADAzADADADAwMAAzMDADMzMzAzDzAzAzADAzADADADAwMAAzMDADMzMzAzMzAz/DADAz/D/DDz/wMAAzwDADMzDzAzMzAz/DADAz/D/DDz/wMAAzwDADMzDzAzPz/zAzADAzADADAzAwMDAzMDADAzAzAzPz/zAzADAzADADAzAwMDAzMDADAzAzAzADAzAwwDDDADAAwzAwMDAzDDADAzAzAzADAzAwwDDDADAAwzAwMDAzDDADAzAzAzADAz/APz8D/zAAPzAw/A/DAz/zAzAw/DADAz/APz8D/zAAPzAw/A/DAz/zAzAw/A/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/AAA/AAAAAAAAAAAAAAAAAAAAAAAAAAA/AAA/AAAAD/A/D/A/z/zAzAzAzAzAz/wwDAADAMAAD/A/D/A/z/zAzAzAzAzAz/wwDAADAMAADAzAzAzAAMDAzAzAzAzAwDAwDAADAzAADAzAzAzAAMDAzAzAzAzAwDAwDAADAzAADAzAzAzAAMDAzAzAwzAzAMAwAwADDAwADAzAzAzAAMDAzAzAwzAzAMAwAwADDAwAD/DAz/A/AMDAwzDMwMAMAMAwAwADAAAAD/DAz/A/AMDAwzDMwMAMAMAwAwADAAAADADAzMAAwMDAwzDMwzAMAwAwAMADAAAADADAzMAAwMDAwzDMwzAMAwAwAMADAAAADADAzDAAwMDAwMDMzAwMAwAwAMADAAAADADAzDAAwMDAwMDMzAwMAwAwAMADAAAADAA/DAz/AMA/AMDzzAwMD/wwADADAAAADAA/DAz/AMA/AMDzzAwMD/wwADADAAAAAAADAAAAAAAAAAAAAAAAAAAwADADAAAAAAADAAAAAAAAAAAAAAAAAAAwADADAAAAAAAAwAAAAAAAAAAAAAAAAAA/AAA/AAD/8AAAwAAAAAAAAAAAAAAAAAA/AAA/AAD/8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAADAAAAAwAAPwADAAMADDAA8AAAAAAAMAADAAAAAwAAPwADAAMADDAA8AAAAAAADAADAAAAAwAAwAADAAAAADAAMAAAAAAADAADAAAAAwAAwAADAAAAADAAMAAAAAAAAA/D/A/w/w/D/w/z/A8APDDAMDzz/A/AAA/D/A/w/w/D/w/z/A8APDDAMDzz/A/AAAAzAzADAzAwwDAzAwMADDMAMDMzAzAwAAAzAzADAzAwwDAzAwMADDMAMDMzAzAwAA/zAzADAz/wwDAzAwMADD8AMDMzAzAwAA/zAzADAz/wwDAzAwMADD8AMDMzAzAwADAzAzADAzAAwDAzAwMADDDAMDMzAzAwADAzAzADAzAAwDAzAwMADDDAMDMzAzAwAA/z/A/w/w/wwA/zAw/ADDAw/DMzAw/AAA/z/A/w/w/wwA/zAw/ADDAw/DMzAw/AAAAAAAAAAAAAAAAwAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAADAAAAAAAAAAAAAAAAAAAAAAAAA/AAAAA8AAAAAAAAAAAAAAAAAAAAAAAAA/AAAAA8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADwADwAAAAAAAAAAAAAAAAAAAAAAAAAAADwADwAAAAAAAAAAAAAAAAAAAAAAAAAAAMAMAMAAAAAAAAAAAAAAAAAAAAAAAAAAAMAMAMAAAAAAAAAAAAAAAAAAAAAAAAAAAMAMAMAwwAAAAAAAAAAAAAAAAAAAAAAAAMAMAMAwwAAAAAAAAAAwAAAAAAAAAAAAAMAMAMDMwMAAAAAAAAAwAAAAAAAAAAAAAMAMAMDMwMD/A/zPw/z/zAzAzAzAzAz/wMAMAMDDAAD/A/zPw/z/zAzAzAzAzAz/wMAMAMDDAADAzAzwDAAwDAzAzAwzDAwDDwAMADwAAADAzAzwDAAwDAzAzAwzDAwDDwAMADwAAADAzAzAA/AwDAzAzMwMAzAMAMAMAMAAAMDAzAzAA/AwDAzAzMwMAzAMAMAMAMAAAMDAzAzAAAwwDAwzDMwzAzAwAMAMAMAAAMDAzAzAAAwwDAwzDMwzAzAwAMAMAMAAAMD/A/zAD/APw/wMDzzAwMD/wMAMAMAAAMD/A/zAD/APw/wMDzzAwMD/wMAMAMAAAMDAAAwAAAAAAAAAAAAAAMAAAMAMAMAAAMDAAAwAAAAAAAAAAAAAAMAAAMAMAMAAAMDAAAwAAAAAAAAAAAAADwAAADwADwAAAMDAAAwAAAAAAAAAAAAADwAAADwADwAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwADAMA8wzAMAAAAAwAAAAAAAAAAAAAAAwADAMA8wzAMAAAAAwAMAAAAAAAMAAAAAMAMAzDPAAAzAAAAAMAMAAAAAAAMAAAAAMAMAzDPAAAzAAAAAMAMAPAADAwMA8AAAAAAAAAAAMAzAPwPwAAMAPAADAwMA8AAAAAAAAAAAMAzAPwPwAA/AwDAwzAMDDAMAMAMAMAMAMAMAPAwD/w/AwDAwzAMDDAMAMAMAMAMAMAMAPAwD/zAAwA/AMAMDDAAAMAMAMAMAzAMAzDADADAAwA/AMAMDDAAAMAMAMAMAzAMAzDADADAD/AzD/wAA8AAAzAzAzAzAzAzAzzAD/DAD/AzD/wAA8AAAzAzAzAzAzAzAzzAD/DAAwA/AMAMAAAMA/A/A/A/A/A/A/DADADAAwA/AMAMAAAMA/A/A/A/A/A/A/DADAA/AwDAz/wMAAAwDAzAzAzAzAzAzDAwDAA/AwDAz/wMAAAwDAzAzAzAzAzAzDAwDAAMD/wAAMAMAADADAzAzAzAzAzAzDwPz/wMD/wAAMAMAADADAzAzAzAzAzAzDwPz/wMAAAAAAAMAADAwAAAAAAAAAAAAAADAAAMAAAAAAAMAADAwAAAAAAAAAAAAAADAAAAAAAAAAAAAAA/AAAAAAAAAAAAAAA8AAAAAAAAAAAAAAA/AAAAAAAAAAAAAAA8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAMAzAwADAMAzAAA8wwADAMA8wzAAAAADAMAzAwADAMAzAAA8wwADAMA8wzAAAAAMAzAAAMAMAzAAAADPAMAMAzDPAAAAAAwMAzAAAMAMAzAAAADPAMAMAzDPAAAAAAwAAAD/wAAAAAA/D/AAAAAAAAAAA/AAA/AAAAD/wAAAAAA/D/AAAAAAAAAAA/AAA/D/z/zAA/A/A/AMAwzAw/A/A/A/DAwADDz/z/zAA/A/A/AMAwzAw/A/A/A/DAwADDzADADAAMAMAMAMAwzwzAzAzAzAzAwwzDzADADAAMAMAMAMAwzwzAzAzAzAzAwwzDz/D/D/AMAMAMAMD8zMzAzAzAzAzAwPDMz/D/D/AMAMAMAMD8zMzAzAzAzAzAwPDMzADADAAMAMAMAMAwzDzAzAzAzAzAwPDwzADADAAMAMAMAMAwzDzAzAzAzAzAwPDwzADADAAMAMAMAMAzDAzAzAzAzAzAwwzwzADADAAMAMAMAMAzDAzAzAzAzAzAwwzwz/z/z/w/A/A/A/D8DAw/A/A/A/A/AAA/D/z/z/w/A/A/A/D8DAw/A/A/A/A/AAA/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwADAMAzADAAAAAAAAAMA8wAAPAAAAAAAwADAMAzADAAAAAAAAAMA8wAAPAAAAAAAMAMAzAAAMAAAAAwADAzDPAAAwwAAAAwAMAMAzAAAMAAAAAwADAzDPAAAwwAAAAwDAzAwADAwADAA/AMAMAAAAAzAPAAAAAMDAzAwADAwADAA/AMAMAAAAAzAPAAAAAMDAzAzAzAzAz/DAwAAAAAAAAAAAAAAAAADAzAzAzAzAz/DAwAAAAAAAAAAAAAAAAADAzAzAzAzAzAzDA/A/A/A/A/A/Dzw/A/DAzAzAzAzAzAzDA/A/A/A/A/A/Dzw/A/DAzAzAzAwzDAzPAAwAwAwAwAwAwMzADAzAzAzAzAwzDAzPAAwAwAwAwAwAwMzADAzAzAzAzAwMDAzAw/w/w/w/w/w/w/zAD/zAzAzAzAwMDAzAw/w/w/w/w/w/w/zAD/zAzAzAzAwMD/DAzAzAzAzAzAzAzMDADADAzAzAzAwMD/DAzAzAzAzAzAzAzMDADAA/A/A/A/AMDADPA/w/w/w/w/w/zzw/A/w/A/A/A/AMDADPA/w/w/w/w/w/zzw/A/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAMAAAMA8wAAAAMA8wAAAAAAAAMAAAAAAAMAAAMA8wAAAAMA8wAAAAAADAzAAAwADAzAAAPzPAwADAzDPAAAAAAADAzAAAwADAzAAAPzPAwADAzDPAAAAAAAMAAAzAMAMAAAzA/AAAMAMAAAAAzAAAAAMAAAzAMAMAAAzA/AAAMAMAAAAAzAAAAAAAAAAAAAAAAAAADAAAAAAAAAAAAAMAAwAAAAAAAAAAAAAADAAAAAAAAAAAAAMAAw/A/A/A8A8A8A8A/z/A/A/A/A/A/AAA/A/A/A/A8A8A8A8A/z/A/A/A/A/A/AAA/DAzAzAwMAMAMAMDAzAzAzAzAzAzAz/zDzAzAzAwMAMAMAMDAzAzAzAzAzAzAz/zDz/z/z/wMAMAMAMDAzAzAzAzAzAzAwADMz/z/z/wMAMAMAMDAzAzAzAzAzAzAwADMzADADAAMAMAMAMDAzAzAzAzAzAzAwMDwzADADAAMAMAMAMDAzAzAzAzAzAzAwMDww/w/w/w/A/A/A/A/DAw/A/A/A/A/AAA/A/w/w/w/A/A/A/A/DAw/A/A/A/A/AAA/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAADADAAAMAMAAAAAAAAAAAAAAMAAAAAAAADADAAAMAMAAAAAAAAAAwADAzAAADAAAADwAwAA8AwAAAAAAAAAAwADAzAAADAAAADwAwAA8AwAAAAAAAAAAMAMAAAzAMDAAzD8AMAD8DAAAAAAAAAAAMAMAAAzAMDAAzD8AMAD8DAAAAAAAAAAAAAAAAAAAADAAAD/ADAP8MAAAAAAAAAAAAAAAAAAAADAAAD/ADAP8MAAAAAAAAAADAzAzAzAzAz/DAz/wAw/8wAAAAAAAAAADAzAzAzAzAz/DAz/wAw/8wAAAAAAAAAADAzAzAzAzAzAzAz/8AP//AAAAAAAAAAADAzAzAzAzAzAzAz/8AP//AAAAAAAAAAADAzAzAzAzAzAzAz/8AP//AAAAAAAAAAADAzAzAzAzAzAzAz/8AP//AAAAAAAAAAADAzAzAzAzAzAzAz/wAw/8wAAAAAAAAAADAzAzAzAzAzAzAz/wAw/8wAAAAAAAAAAA/w/w/w/w/z/A/z/ADAP8MAAAAAAAAAAA/w/w/w/w/z/A/z/ADAP8MAAAAAAAAAAAAAAAAAAAAzAAAz8AMAD8DAAAAAAAAAAAAAAAAAAAAzAAAz8AMAD8DAAAAAAAAAAAAAAAAAAA/DAA/DwAwAA8AwAAAAAAAAAAAAAAAAAA/DAA/DwAwAA8AwAAAAAAAAAAAAAAAAAAAAAAADADAAAMAMAAAAAAAAAAAAAAAAAAAAAAADADAAAMAMAAAAAAAAAA="
	};
	(FONT_6x12_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_12x24_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_7x13) => {
		"data:image/bmp;base64,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"
	};
	(FONT_14x26) => {
		"data:image/bmp;base64,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"
	};
	(FONT_7x13_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_14x26_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_7x14) => {
		"data:image/bmp;base64,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"
	};
	(FONT_14x28) => {
		"data:image/bmp;base64,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"
	};
	(FONT_7x14_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_14x28_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_8x15) => {
		"data:image/bmp;base64,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"
	};
	(FONT_16x30) => {
		"data:image/bmp;base64,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"
	};
	(FONT_8x15_BOLD) => {
		"data:image/bmp;base64,Qk2OCgAAAAAAAD4AAAAoAAAAgAAAAFv///8BAAEAAAAAAAAAAAABAAAAAQAAAAAAAAAAAAAAAAAAAP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAYAAAAAAAAAAAAAAAAGGwAGDg4GAwwAAAAAAAAADxsNj5tbBgYGAAAAAAABgA8bDZgbmwYGBgAGAAAAAYAGGx/YDw4GDAMNhgAAAAMABgANjwIOQAwDBwYAAAADAAAADYGHm0AMAx//wB+ABgAAAB/BjtmADAMHBgAAAAYABgANnxbZgAwDDYYOAA4MAAYADYYDjsAGBgAGDgAODAAAAAAGAAAABgYAAAYAABgAAAAAAAAAAAMMAAAGAAAYAAAAAAAAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8PBg8fgZ+GH48PAAAAAAARmY4ZgYOYDAGZmY4OAYAYAZueAYMHmBgDGZmODgMfjAMbhgMHDZ8fAw8ZgAAGAAYGHYYGAZmBmYYZj4AADAADAB2GDAGfwZmGGYGAAAYfhgAZhhgZgZmZjBmDDg4DAAwGDx+fjwGPDwwPBg4OAYAYBgAAAAAAAAAAAAAABgAAAAAAAAAAAAAAAAAAAAYAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA+AAAAAAAAAAAAAAAAAAAAYxh8Hnh+fh5mfgZjYGNjPGM8ZjBsYGAwZhgGZmB3c2ZvZmZgZmBgYGYYBmxgf3tma2Z8YGZ8fGB+GAZ4YGtvZmt+ZmBmYGBmZhgGeGBjZ2ZvZmZgZmBgZmYYZmxgY2NmYGZmMGxgYDZmGGZmYGNjZmBmfB54fmAeZn48Y35jYzw/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD4AfAAAfDx8Pv9mZmNmZn4wYAwYAGZmZmAYZmZjZmYMMGAMPABmZmZgGGZmY2ZmDDAwDGYAZmZmOBhmZmM8PBgwMAwAAHxmfAwYZmZrPBgYMBgMAABgZmwGGGZmf2YYMDAYDAAAYGZmBhhmPHdmGDAwDAwAAGA8ZnwYPBhjZhh+MAwMAAAADAAAAAAAAAAAADAGDAAAAAYAAAAAAAAAAAA+BnwA/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAGAABgAeAGAYDGB4AAAAGABgAAYAMABgGAxgGAAAAAwAYAAGADAAYAAAYBgAAAAAPHw+Pjx+Pnx4PGwYfnw8AAZmYGZmMGZmGAx4GGtmZgA+ZmBmfjBmZhgMcBhrZmYAZmZgZmAwZmYYDHgYa2ZmAGZmYGZgMGZmGAxsGGtmZgA+fD4+PjA+Zn4MZg5rZjwAAAAAAAAABgAADAAAAAAAAAAAAAAAAAYAAAwAAAAAAAAAAAAAAAA8AAB4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABgAAAAAAAAAAAAAAAAAAA4YcAAAAAAAADAAAAAAAAAYGBg5AAAAAAAwAAAAAAAAGBgYfwB8Pm4+fmZma2NmfhgYGE4YZmZwYDBmZms2ZgwYGBgAGGZmYDgwZmZrHGYYcBgOAABmZmAcMGZmaxxmMBgYGAAAZmZgBjBmPGs2ZmAYGBgAGHw+YHwePhh+Yz5+GBgYABhgBgAAAAAAAAAGABgYGAA8YAYAAAAAAAAABgAOGHAAPGAGAAAAAAAAADwAAAAAABgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAMGDJmPAAAMAAAAAAAAAAYGDx+ZmYAABgMAAAAAAAAAABmTABmAAAADBxjZhg8ABgYAAAYPB8efj42PmYYZgA8PBgYPDw8MGBgMDY8GGYYZmY8PGZmbGBgYDBjfhhmGGZmZmZmZm9gfGB8YxgAPAB+fmZmfn58YGBgMDZ+AAAAZmZ+fmZmbGBgPjA+GBgAGGZmZmZmZmwwYAx+YxgYADBmZmZmZmZvHn4MAAAAGABgAAAAAAAAAAwAAAAAABgAYgAAAAAAAAAMAAAAAAAAADwAAAAAAAAAOAAAAAAAAAAAAAAAAAAAAAAADBhmMAwYZgAyMAYYMmYAABg8ZhgYPGYAfhgMPH5mAAAAZgAAAGYAAEwAAGZMAAACfgB+fn4AfjwAPDwAADwAHmB+YBgYfhg2Y2ZmPDxmADZgYGAYGBgYM3NmZmZmZmZnfGB8GBgYGHt7ZmZmZmY8a2B8YBgYGBgzb2ZmZmZmGGtgYGAYGBgYM2dmZmZmZjxzYGBgGBgYGDZjZmZmZmZmNn5+fn5+fn48Yzw8PDw8ADwAAAAAAAAAAAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAwYZgwAAAAAAAAAHAAAABgYPGYYAAAAABgyADYAAAAAAGYAAAAAMAw8fmY2AAAwZmYAZmZgPBgYZkxmHAAAGGZmZmZmfGYAAAAAAAAAAABmZmZmZmZmPDw8PDw8dj48ZmZmZjxmbAYGBgYGBhtgZmZmZmYYZmY+Pj4+Pj57YH5mZmZmGGZmZmZmZmZm32BgZmZmZhh8ZmZmZmZmZthgYDw8PDwYYGw+Pj4+Pj5vPj4AAAAAAAAAAAAAAAAAAAwAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAYAAAAGAAaMgAAGDIAAAAMPGYwDDxmDH4wDDx+ZgAAGGZmGBhmZjxMGBhmTGYAAAAAAAAAAAAGAAAAAAAAGAI8PDx4eHh4Pnw8PDw8PBg+ZmZmGBgYGGZmZmZmZmYAZ35+fhgYGBhmZmZmZmZmfmtgYGAYGBgYZmZmZmZmZgBrYGBgGBgYGGZmZmZmZmYYcz4+Pn5+fn48Zjw8PDw8GD4AAAAAAAAAAAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgIABAQAAAAAAAAAAAAAAAMBAAwIAAAAAAAAAGAAAAADgIAcEAAAAAAAwDDxmMGBm8BAPCAAAAAAAGBhmZhhgZvgIHxAAAAAAAAAAAAAAYAD8BD8gAAAAAABmZmZmZnxm/gJ/QAAAAAAAZmZmZmZmZv8B/4AAAAAAAGZmZmZmZmb+An9AAAAAAABmZmZmZmZm/AQ/IAAAAAAAZmZmZmZmZvgIHxAAAAAAAD4+Pj4+fD7wEA8IAAAAAAAAAAAABmAG4CAHBAAAAAAAAAAAAAZgBsBAAwIAAAAAAAAAAAA8YDyAgAEBAAAAAAA="
	};
	(FONT_16x30_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_8x16) => {
		"data:image/bmp;base64,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"
	};
	(FONT_16x32) => {
		"data:image/bmp;base64,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"
	};
	(FONT_8x16_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_16x32_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_10x20) => {
		"data:image/bmp;base64,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"
	};
	(FONT_20x40) => {
		"data:image/bmp;base64,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"
	};
	(FONT_10x20_BOLD) => {
		"data:image/bmp;base64,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"
	};
	(FONT_20x40_BOLD) => {
		"data:image/bmp;base64,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"
	};
}

use crate::BitmapFont;
use core::num::NonZeroU8;
use embedded_graphics::{
	geometry::Size,
	image::ImageRaw,
	mono_font::mapping::GlyphMapping
};

struct Mapping;

impl GlyphMapping for Mapping {
	fn index(&self, c: char) -> usize {
		match c {
			' ' ..= '~' => (c as usize - ' ' as usize),
			'¡' ..= '¦' => (c as usize - '¡' as usize) + 95,
			'°' ..= '°' => (c as usize - '°' as usize) + 101,
			'¿' ..= 'ÿ' => (c as usize - '¿' as usize) + 102,
			'' ..= '' => (c as usize - '' as usize) + 167,
			_ => '?' as usize - ' ' as usize
		}
	}
}

const GLYPH_MAPPING: Mapping = Mapping;
const ONE: NonZeroU8 = match NonZeroU8::new(1) {
	Some(one) => one,
	None => unreachable!()
};

/// Tamzen 5x9 Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_5x9),
	")"
)]
///
/// Bitmap Size: 972 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen5x9r.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_5x9: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 96 x 81 (972)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0xa2, 0x61,
			0x84, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x15, 0xe7, 0x6a, 0x84, 0x22, 0x08, 0x40,
			0x00, 0x04, 0x61, 0x38, 0x02, 0x14, 0xa8, 0x11, 0x04, 0x41, 0x3c, 0x40, 0x00, 0x04, 0x93, 0x04,
			0x02, 0x01, 0x46, 0x22, 0xc0, 0x41, 0x19, 0xf0, 0x78, 0x08, 0x91, 0x08, 0x00, 0x01, 0xe1, 0x5a,
			0x80, 0x41, 0x24, 0x40, 0x00, 0x08, 0x91, 0x10, 0x02, 0x01, 0x4e, 0x1b, 0x40, 0x41, 0x00, 0x46,
			0x01, 0x90, 0x63, 0xbc, 0x00, 0x00, 0x04, 0x00, 0x00, 0x22, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e,
			0x30, 0x00, 0x00, 0x00, 0xf1, 0x3c, 0xcf, 0x31, 0x80, 0x00, 0x80, 0x81, 0x49, 0x9c, 0x77, 0x3c,
			0x23, 0x21, 0x02, 0x4a, 0x4c, 0x61, 0x3c, 0x42, 0x5a, 0x52, 0x84, 0xa0, 0x65, 0x39, 0xc2, 0x31,
			0xc0, 0x02, 0x00, 0x24, 0x5b, 0xdc, 0x84, 0xb8, 0x17, 0x85, 0x24, 0x48, 0x40, 0x01, 0x3c, 0x40,
			0x42, 0x52, 0x84, 0xa0, 0xe1, 0x38, 0xc4, 0x31, 0x8c, 0x60, 0x80, 0x84, 0x42, 0x5c, 0x77, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xf3, 0xa4, 0xe1, 0x4a, 0x12, 0x93, 0x38, 0xce, 0x3b, 0xf2, 0x94, 0xa4, 0x84, 0x24, 0x41, 0x52,
			0x1e, 0xd4, 0xa5, 0x29, 0x40, 0x92, 0x94, 0xa4, 0xe5, 0xbc, 0x41, 0x62, 0x12, 0xb4, 0xb9, 0x2e,
			0x30, 0x92, 0x94, 0x98, 0x84, 0xa4, 0x49, 0x52, 0x12, 0x94, 0xa1, 0x2a, 0x08, 0x92, 0x67, 0xa4,
			0x83, 0xa4, 0xe6, 0x4b, 0xd2, 0x93, 0x20, 0xc9, 0x70, 0x8e, 0x64, 0xa4, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x1c, 0x0e, 0x00, 0x08, 0x04, 0x00, 0x20, 0x18, 0x10, 0x21, 0x20, 0x8f, 0x91, 0x02, 0x10,
			0x04, 0x04, 0x00, 0x20, 0x20, 0x10, 0x00, 0x20, 0x51, 0x11, 0x02, 0x28, 0x02, 0x77, 0x18, 0xe7,
			0x79, 0xdc, 0x63, 0x28, 0x22, 0x10, 0x82, 0x00, 0x00, 0x94, 0xa1, 0x2a, 0x22, 0x52, 0x21, 0x30,
			0x24, 0x10, 0x82, 0x00, 0x00, 0x94, 0xa1, 0x2c, 0x22, 0x52, 0x21, 0x28, 0x27, 0x90, 0x42, 0x00,
			0x00, 0x77, 0x18, 0xe7, 0x21, 0xd2, 0x71, 0x24, 0x00, 0x10, 0x42, 0x03, 0xe0, 0x00, 0x00, 0x00,
			0x00, 0x40, 0x01, 0x00, 0x00, 0x1c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x06, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x26, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
			0x00, 0x04, 0x22, 0x34, 0x25, 0xb8, 0xce, 0x3a, 0xce, 0xf4, 0xa5, 0x29, 0x4b, 0xc4, 0x22, 0x2c,
			0x27, 0xa5, 0x29, 0x4b, 0x08, 0x44, 0xa5, 0x26, 0x48, 0x9c, 0x23, 0x80, 0x24, 0xa5, 0x29, 0x4a,
			0x04, 0x44, 0x99, 0xe6, 0x49, 0x04, 0x22, 0x00, 0x74, 0xa4, 0xce, 0x3a, 0x1e, 0x33, 0x99, 0xe9,
			0x33, 0xc4, 0x22, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x10, 0x06, 0x26, 0x00,
			0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x88, 0x01, 0x0d, 0x28, 0x90, 0x00, 0x41, 0x11, 0xa5,
			0x18, 0x00, 0x21, 0x14, 0x03, 0x90, 0xc5, 0x11, 0x80, 0x22, 0x29, 0x60, 0x29, 0xce, 0xf7, 0xbc,
			0x45, 0x39, 0x22, 0x12, 0x44, 0x31, 0x8c, 0x43, 0x12, 0x90, 0x84, 0x20, 0x05, 0x11, 0x2f, 0x81,
			0x80, 0x52, 0x94, 0xa5, 0x2b, 0xd0, 0xe7, 0x38, 0x43, 0x90, 0xc2, 0x10, 0x04, 0xf7, 0xbd, 0xef,
			0x7a, 0x90, 0x84, 0x20, 0x41, 0x3d, 0x22, 0x10, 0x08, 0x94, 0xa5, 0x29, 0x4a, 0xce, 0xf7, 0xbc,
			0x40, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
			0x0e, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x52, 0x04, 0x45, 0x03, 0x50, 0x12, 0x35, 0x20,
			0x02, 0x02, 0x45, 0x10, 0x01, 0x08, 0xa0, 0x02, 0xc8, 0x25, 0x2c, 0x00, 0x09, 0x04, 0xa0, 0x08,
			0xf3, 0x9c, 0x07, 0x70, 0x0c, 0x60, 0x00, 0xc0, 0x32, 0x52, 0x04, 0xa2, 0x81, 0x08, 0xe2, 0x2a,
			0x52, 0x93, 0x19, 0x25, 0x4a, 0x52, 0x94, 0x94, 0xe1, 0x08, 0x42, 0x6b, 0x52, 0x94, 0xa5, 0x22,
			0x4a, 0x52, 0x94, 0x88, 0x81, 0x08, 0x42, 0x2a, 0xd2, 0x94, 0xa5, 0x25, 0x4a, 0x52, 0x94, 0x88,
			0xf3, 0x9c, 0xe7, 0x72, 0x4c, 0x63, 0x18, 0xc0, 0x31, 0x8c, 0x63, 0x08, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x68, 0x06, 0x00, 0x00, 0x02, 0x00, 0x00, 0x20, 0x10,
			0x00, 0x20, 0x25, 0x59, 0x4a, 0x00, 0x20, 0x25, 0x29, 0x02, 0x52, 0xbc, 0x83, 0x90, 0x40, 0x00,
			0x04, 0x00, 0x10, 0x40, 0x00, 0x84, 0x00, 0x08, 0xe4, 0x9c, 0xe7, 0x39, 0xce, 0xf3, 0x1c, 0xe7,
			0x39, 0x8c, 0x63, 0x18, 0x95, 0x25, 0x29, 0x4a, 0x52, 0x74, 0x29, 0x4a, 0x50, 0x84, 0x21, 0x24,
			0xe4, 0xa5, 0x29, 0x4a, 0x52, 0xa4, 0x31, 0x8c, 0x60, 0x84, 0x21, 0x24, 0x85, 0x1c, 0xe7, 0x39,
			0xce, 0xf3, 0x1c, 0xe7, 0x39, 0xce, 0x73, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xd0, 0x00, 0x8d, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x80, 0x42, 0xb4, 0x05, 0x4b, 0x48,
			0x00, 0x80, 0xa9, 0x41, 0x42, 0x98, 0x40, 0xc4, 0x02, 0x08, 0x00, 0x00, 0x82, 0x41, 0x00, 0x02,
			0x40, 0x1c, 0x21, 0xc8, 0xe3, 0x18, 0xc6, 0x30, 0x0c, 0x94, 0xa5, 0x29, 0x72, 0x5e, 0x13, 0xd0,
			0x94, 0xa5, 0x29, 0x49, 0xd2, 0x94, 0xa5, 0x29, 0x4a, 0x5f, 0x0f, 0xe0, 0x94, 0xa5, 0x29, 0x48,
			0x12, 0x94, 0xa5, 0x29, 0x4a, 0x5e, 0x13, 0xd0, 0x93, 0x18, 0xc6, 0x30, 0x8c, 0x63, 0x18, 0xc7,
			0x71, 0xdc, 0x21, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x40, 0x58, 0x40, 0xc4,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x41, 0x90, 0x80, 0x42
		],
		96
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(5, 9),
	pixels: ONE
};

/// Tamzen 5x9 Bold Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_5x9_BOLD),
	")"
)]
///
/// Bitmap Size: 972 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen5x9b.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_5x9_BOLD: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 96 x 81 (972)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3c, 0xa2, 0x41,
			0x8c, 0x36, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3d, 0xe2, 0x4b, 0x4c, 0x63, 0x3c, 0xc0,
			0x00, 0x06, 0x63, 0x38, 0x03, 0x28, 0xa7, 0x19, 0x8c, 0xc1, 0x98, 0xc0, 0x00, 0x06, 0xd7, 0x0c,
			0x03, 0x01, 0xe6, 0x33, 0x60, 0xc1, 0xb9, 0xf0, 0x78, 0x0c, 0xd3, 0x18, 0x00, 0x01, 0xe3, 0x63,
			0x40, 0xc1, 0xa8, 0xc6, 0x01, 0x8c, 0xd3, 0x30, 0x03, 0x00, 0xaf, 0x4b, 0xa0, 0x63, 0x00, 0xc6,
			0x01, 0x98, 0x67, 0xbc, 0x00, 0x00, 0x04, 0x08, 0x00, 0x36, 0x00, 0x0c, 0x00, 0x18, 0x00, 0x00,
			0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
			0x30, 0x00, 0x00, 0x00, 0xe1, 0xbc, 0xcf, 0x31, 0x8c, 0x61, 0x81, 0x8b, 0x68, 0x9c, 0x77, 0x3c,
			0x33, 0xb1, 0x83, 0x6b, 0x4c, 0x63, 0x3c, 0xc3, 0x69, 0xda, 0xc6, 0xb0, 0x65, 0xb9, 0xc6, 0x31,
			0xc0, 0x06, 0x00, 0x66, 0x6a, 0xdc, 0xc6, 0xb8, 0x37, 0x8d, 0xac, 0x68, 0xcc, 0x63, 0x3c, 0xc0,
			0x63, 0xda, 0xc6, 0xb0, 0xe1, 0xb8, 0xcc, 0x31, 0x8c, 0x61, 0x81, 0x86, 0x62, 0xdc, 0x77, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xf3, 0xb5, 0xe3, 0x6b, 0x12, 0xd3, 0x38, 0xce, 0x3b, 0xda, 0xd4, 0xb4, 0xc6, 0x34, 0xc3, 0x6b,
			0x1e, 0xd6, 0xb5, 0xad, 0x61, 0x9a, 0xd4, 0x98, 0xe6, 0xbc, 0xc3, 0x73, 0x1e, 0xf6, 0xb9, 0xae,
			0x31, 0x9a, 0xd7, 0x98, 0xc6, 0xb4, 0xcb, 0x6b, 0x12, 0xb6, 0xb1, 0xae, 0x19, 0x9a, 0xe7, 0x98,
			0xc3, 0xb5, 0xe6, 0x6b, 0xd2, 0xb3, 0x30, 0xcd, 0x71, 0x8c, 0x44, 0xb4, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x1c, 0x0e, 0x20, 0x10, 0x06, 0x00, 0x60, 0x18, 0x18, 0x61, 0xb0, 0xd7, 0x99, 0x86, 0x70,
			0x18, 0x06, 0x00, 0x60, 0x30, 0x18, 0x00, 0x30, 0xd1, 0x99, 0x86, 0x50, 0x0c, 0x77, 0x1c, 0xe7,
			0x79, 0xdc, 0xe3, 0xb4, 0x63, 0x18, 0xc6, 0x00, 0x04, 0xb6, 0xb1, 0x6b, 0x33, 0x5a, 0x61, 0xb8,
			0x66, 0x18, 0xc6, 0x00, 0x00, 0xb6, 0xb1, 0x6e, 0x33, 0x5a, 0x61, 0xb4, 0x67, 0x98, 0x66, 0x00,
			0x00, 0x77, 0x1c, 0xe7, 0x31, 0xda, 0xf1, 0xb4, 0x00, 0x1c, 0x6e, 0x03, 0xe0, 0x00, 0x00, 0x00,
			0x00, 0xc0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x07, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x67, 0x14, 0x60, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00,
			0x00, 0x06, 0x63, 0x3c, 0x66, 0xb8, 0xce, 0x3b, 0xce, 0xf6, 0xb5, 0xad, 0x6b, 0xc6, 0x63, 0x28,
			0x67, 0xb5, 0xad, 0x5b, 0x0c, 0x66, 0xb5, 0xa6, 0x69, 0x9e, 0x63, 0xc0, 0x66, 0xb5, 0xad, 0x5b,
			0x06, 0x66, 0xb9, 0xe6, 0x6b, 0x06, 0x63, 0x00, 0xf6, 0xb4, 0xce, 0x3b, 0x1e, 0x73, 0x11, 0xad,
			0x3b, 0xc6, 0x63, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x07, 0x67, 0x00,
			0x00, 0x00, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x09, 0xa9, 0x00, 0x00, 0x80, 0x90, 0x01, 0x0d, 0xa0, 0x30, 0x00, 0x40, 0x95, 0x60,
			0x30, 0x00, 0x41, 0x28, 0x03, 0x98, 0xcd, 0x31, 0x80, 0x21, 0x00, 0x02, 0x59, 0xce, 0xf7, 0xbc,
			0x66, 0x3d, 0xa6, 0x33, 0x4c, 0x73, 0x9c, 0xe7, 0x32, 0x98, 0xc6, 0x30, 0x06, 0x19, 0xaf, 0x01,
			0x80, 0xb5, 0xad, 0x6b, 0x5b, 0xd8, 0xe7, 0x38, 0x63, 0x98, 0xc6, 0x30, 0x0c, 0xf7, 0xbd, 0xef,
			0x7a, 0x98, 0xc6, 0x30, 0x61, 0x3d, 0xa6, 0x30, 0x18, 0xb5, 0xad, 0x6b, 0x5a, 0xce, 0xf7, 0xbc,
			0x60, 0x00, 0x00, 0x30, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00,
			0x0c, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0xa4, 0x04, 0x8a, 0x03, 0x50, 0x12, 0x35, 0x40,
			0x02, 0x04, 0x45, 0x08, 0x02, 0x09, 0x40, 0x02, 0xc8, 0x25, 0x2c, 0x00, 0x09, 0x08, 0xa0, 0x10,
			0xf7, 0xbd, 0xef, 0x70, 0x0c, 0x63, 0x00, 0xc0, 0x33, 0x5a, 0xd6, 0xb4, 0xc3, 0x18, 0xc6, 0x2b,
			0x5a, 0xd6, 0x99, 0xad, 0x6b, 0x5a, 0xd6, 0xb4, 0xe3, 0x18, 0xc6, 0x6b, 0xda, 0xd6, 0xb5, 0xa6,
			0x6b, 0x5a, 0xd6, 0x98, 0xc3, 0x18, 0xc6, 0x2a, 0xda, 0xd6, 0xb5, 0xad, 0x6b, 0x5a, 0xd6, 0x98,
			0xf7, 0xbd, 0xef, 0x72, 0xcc, 0x63, 0x18, 0xc0, 0x31, 0x8c, 0x63, 0x18, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x68, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x40, 0x10,
			0x00, 0x20, 0x2a, 0x5a, 0x8c, 0x00, 0x20, 0x2a, 0x52, 0x02, 0xa5, 0x3c, 0xc3, 0x90, 0x40, 0x00,
			0x16, 0x00, 0x10, 0x40, 0x01, 0x04, 0x00, 0x08, 0xe6, 0x9c, 0xe7, 0x39, 0xcc, 0xf3, 0x9c, 0xe7,
			0x3b, 0x9c, 0xe7, 0x18, 0xd7, 0x2d, 0x6b, 0x5a, 0xd6, 0x76, 0x2d, 0x6b, 0x59, 0x8c, 0x63, 0x2c,
			0xe6, 0xad, 0x6b, 0x5a, 0xd6, 0xa6, 0x39, 0xce, 0x71, 0x8c, 0x63, 0x2c, 0xc7, 0x1c, 0xe7, 0x39,
			0xce, 0xf3, 0x9c, 0xe7, 0x3b, 0xde, 0xf7, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xd0, 0x00, 0x8d, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x80, 0x42, 0xb4, 0x05, 0x4b, 0x50,
			0x00, 0x81, 0x29, 0x42, 0x62, 0x98, 0x40, 0xc4, 0x02, 0x08, 0x00, 0x01, 0x82, 0x42, 0x00, 0x04,
			0x60, 0x1c, 0x21, 0xc8, 0xe3, 0x18, 0xc6, 0x30, 0x0c, 0xd6, 0xb5, 0xad, 0x73, 0x5e, 0x13, 0xd0,
			0xd6, 0xb5, 0xad, 0x6b, 0xda, 0xd6, 0xb5, 0xad, 0x6b, 0x5f, 0x0f, 0xe0, 0xd6, 0xb5, 0xad, 0x68,
			0x1a, 0xd6, 0xb5, 0xad, 0x6b, 0x5e, 0x13, 0xd0, 0xd3, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc7,
			0x71, 0xdc, 0x21, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x03, 0x60, 0xd8, 0x40, 0xc4,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x61, 0x90, 0x80, 0x42
		],
		96
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(5, 9),
	pixels: ONE
};

/// Tamzen 6x12 Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_6x12),
	")"
)]
///
/// Bitmap Size: 1,584 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen6x12r.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_6x12: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 96 x 132 (1584)
		&[
			0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x85, 0x14, 0x11,
			0x04, 0x08, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x85, 0x14, 0x3a, 0x8a, 0x08, 0x20, 0x80,
			0x00, 0x00, 0x00, 0x04, 0x00, 0x85, 0x3e, 0x42, 0xaa, 0x08, 0x20, 0x82, 0x08, 0x00, 0x00, 0x04,
			0x00, 0x80, 0x14, 0x21, 0x44, 0x00, 0x40, 0x4a, 0x88, 0x00, 0x00, 0x08, 0x00, 0x80, 0x14, 0x10,
			0x8a, 0x80, 0x40, 0x47, 0x3e, 0x03, 0xe0, 0x08, 0x00, 0x00, 0x3e, 0x09, 0x49, 0x00, 0x40, 0x4a,
			0x88, 0x00, 0x00, 0x10, 0x00, 0x00, 0x14, 0x72, 0xa9, 0x00, 0x40, 0x42, 0x08, 0x60, 0x06, 0x10,
			0x00, 0x80, 0x14, 0x20, 0xa6, 0x80, 0x20, 0x80, 0x00, 0x60, 0x06, 0x20, 0x00, 0x00, 0x00, 0x20,
			0x40, 0x00, 0x20, 0x80, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00,
			0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x87, 0x3e, 0x13, 0xe3, 0x3e, 0x71, 0xc0,
			0x00, 0x08, 0x08, 0x22, 0x89, 0x88, 0x82, 0x32, 0x04, 0x02, 0x8a, 0x26, 0x18, 0x10, 0x04, 0x02,
			0x9a, 0x80, 0x84, 0x53, 0xc8, 0x04, 0x8a, 0x26, 0x18, 0x23, 0xe2, 0x04, 0xa8, 0x81, 0x0c, 0x90,
			0x2f, 0x04, 0x71, 0xe0, 0x00, 0x40, 0x01, 0x08, 0xc8, 0x82, 0x02, 0xf8, 0x28, 0x88, 0x88, 0x20,
			0x00, 0x23, 0xe2, 0x00, 0x88, 0x84, 0x22, 0x12, 0x28, 0x88, 0x88, 0x46, 0x18, 0x10, 0x04, 0x00,
			0x73, 0xef, 0x9c, 0x11, 0xc7, 0x08, 0x71, 0x86, 0x18, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x8f, 0x0e, 0xf3, 0xef, 0x8e, 0x89, 0xc0,
			0xa2, 0x82, 0x28, 0x9c, 0x89, 0x48, 0x90, 0x8a, 0x08, 0x10, 0x88, 0x80, 0xa4, 0x83, 0x6c, 0xa2,
			0x9a, 0x28, 0xa0, 0x8a, 0x08, 0x20, 0x88, 0x80, 0xa8, 0x82, 0xaa, 0xa2, 0xaa, 0x2f, 0x20, 0x8b,
			0xcf, 0x26, 0xf8, 0x80, 0xb0, 0x82, 0xa9, 0xa2, 0xbb, 0xe8, 0xa0, 0x8a, 0x08, 0x22, 0x88, 0x88,
			0xa8, 0x82, 0x28, 0xa2, 0x82, 0x28, 0x90, 0x92, 0x08, 0x12, 0x88, 0x88, 0xa4, 0x82, 0x28, 0xa2,
			0x82, 0x2f, 0x0e, 0xe3, 0xe8, 0x0e, 0x89, 0xc7, 0x22, 0xfa, 0x28, 0x9c, 0x78, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x1c, 0x01, 0xc0, 0x00, 0xf1, 0xcf, 0x1e, 0xfa, 0x28, 0xa2, 0x8a, 0x2f,
			0x90, 0x80, 0x42, 0x00, 0x8a, 0x28, 0xa0, 0x22, 0x28, 0xa2, 0x8a, 0x21, 0x10, 0x80, 0x45, 0x00,
			0x8a, 0x28, 0xa0, 0x22, 0x28, 0xa2, 0x51, 0x42, 0x10, 0x40, 0x48, 0x80, 0xf2, 0x2f, 0x1c, 0x22,
			0x25, 0x2a, 0x20, 0x82, 0x10, 0x40, 0x40, 0x00, 0x82, 0x2a, 0x02, 0x22, 0x25, 0x2a, 0x50, 0x84,
			0x10, 0x20, 0x40, 0x00, 0x82, 0x29, 0x02, 0x22, 0x22, 0x2a, 0x88, 0x84, 0x10, 0x20, 0x40, 0x00,
			0x81, 0xc8, 0xbc, 0x21, 0xc2, 0x36, 0x88, 0x8f, 0x90, 0x10, 0x40, 0x00, 0x00, 0x40, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x40, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1c, 0x01, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x08, 0x00, 0x08, 0x03, 0x80, 0x80, 0x81,
			0x20, 0x60, 0x00, 0x00, 0x10, 0x08, 0x00, 0x08, 0x04, 0x00, 0x80, 0x00, 0x20, 0x20, 0x00, 0x00,
			0x01, 0xcf, 0x1e, 0x79, 0xcf, 0x9e, 0xf1, 0x83, 0x24, 0x23, 0x6f, 0x1c, 0x00, 0x28, 0xa0, 0x8a,
			0x24, 0x22, 0x88, 0x81, 0x28, 0x22, 0xa8, 0xa2, 0x01, 0xe8, 0xa0, 0x8b, 0xe4, 0x22, 0x88, 0x81,
			0x38, 0x22, 0xa8, 0xa2, 0x02, 0x28, 0xa0, 0x8a, 0x04, 0x22, 0x88, 0x81, 0x24, 0x22, 0xa8, 0xa2,
			0x01, 0xef, 0x1e, 0x79, 0xe4, 0x1e, 0x89, 0xc1, 0x22, 0x72, 0xa8, 0x9c, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x06,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x20, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x20, 0x84, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x08, 0x20, 0x8a, 0x88,
			0xf1, 0xeb, 0x9e, 0xfa, 0x28, 0xa2, 0x8a, 0x2f, 0x88, 0x20, 0x89, 0x00, 0x8a, 0x2c, 0x20, 0x42,
			0x28, 0xa2, 0x52, 0x21, 0x30, 0x20, 0x60, 0x00, 0x8a, 0x28, 0x1c, 0x42, 0x28, 0xaa, 0x21, 0x42,
			0x08, 0x20, 0x80, 0x08, 0x8a, 0x28, 0x02, 0x42, 0x25, 0x2a, 0x51, 0x44, 0x08, 0x20, 0x80, 0x08,
			0xf1, 0xe8, 0x3c, 0x39, 0xe2, 0x36, 0x88, 0x8f, 0x88, 0x20, 0x80, 0x08, 0x80, 0x20, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x80, 0x08, 0x20, 0x80, 0x08, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
			0x06, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x86, 0x94, 0x20, 0x00, 0x10, 0x20, 0x00, 0x00, 0x20,
			0x00, 0x08, 0x21, 0x4b, 0x00, 0x50, 0x00, 0x08, 0x20, 0xc0, 0x22, 0x21, 0x80, 0x00, 0x00, 0x00,
			0x08, 0x50, 0xe3, 0x80, 0x71, 0x08, 0x94, 0x22, 0x42, 0x08, 0x20, 0x82, 0x08, 0x20, 0xc4, 0x3e,
			0x81, 0x07, 0x08, 0x22, 0x40, 0x08, 0x20, 0x82, 0x14, 0x21, 0x48, 0x20, 0x83, 0xc5, 0x3e, 0x01,
			0x80, 0x14, 0x51, 0x45, 0x14, 0x51, 0x68, 0x3c, 0x81, 0x07, 0x08, 0x20, 0x02, 0x1c, 0x71, 0xc7,
			0x1c, 0x71, 0xc8, 0x20, 0x71, 0x08, 0xbe, 0x20, 0x04, 0x22, 0x8a, 0x28, 0xa2, 0x8a, 0x44, 0x20,
			0x23, 0xe0, 0x08, 0x20, 0x08, 0x22, 0x8a, 0x28, 0xa2, 0x8a, 0x63, 0xbe, 0x20, 0x00, 0x00, 0x20,
			0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x85, 0x10, 0x10, 0x85, 0x00, 0x69, 0x01, 0x08, 0x69, 0x40, 0x00, 0x21, 0x40, 0x08, 0x21,
			0x40, 0x00, 0xb0, 0x82, 0x14, 0xb0, 0x00, 0x02, 0x00, 0x0f, 0x80, 0x00, 0x07, 0x3c, 0x00, 0x00,
			0x00, 0x01, 0xc0, 0x1c, 0xfb, 0xe8, 0x1c, 0x71, 0xc2, 0x12, 0x89, 0xc7, 0x1c, 0x72, 0x20, 0x26,
			0x82, 0x08, 0x08, 0x20, 0x82, 0x12, 0xca, 0x28, 0xa2, 0x8a, 0x24, 0xa6, 0xf3, 0xcf, 0x08, 0x20,
			0x82, 0x3a, 0xaa, 0x28, 0xa2, 0x8a, 0x23, 0x2a, 0x82, 0x08, 0x08, 0x20, 0x82, 0x12, 0x9a, 0x28,
			0xa2, 0x8a, 0x23, 0x32, 0x82, 0x08, 0x08, 0x20, 0x82, 0x14, 0x8a, 0x28, 0xa2, 0x8a, 0x24, 0xb2,
			0xfb, 0xef, 0x9c, 0x71, 0xc7, 0x38, 0x89, 0xc7, 0x1c, 0x71, 0xc0, 0x1c, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x40, 0x42, 0x14, 0x10, 0x00, 0x00, 0x00, 0x86, 0x80, 0x30, 0x00, 0x00, 0x20, 0x85, 0x00, 0x20,
			0x00, 0x10, 0x11, 0x4b, 0x00, 0x48, 0x00, 0x10, 0x8a, 0x20, 0x22, 0x02, 0x07, 0x08, 0x20, 0x00,
			0x14, 0x30, 0x00, 0x08, 0x8a, 0x28, 0xa2, 0x8b, 0xc8, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x8a, 0x28, 0xa2, 0x8a, 0x29, 0x1c, 0x71, 0xc7, 0x1c, 0x73, 0x67, 0x1c, 0x8a, 0x28, 0xa2, 0x52,
			0x2b, 0x02, 0x08, 0x20, 0x82, 0x08, 0xa8, 0x22, 0x8a, 0x28, 0xa2, 0x22, 0x28, 0x9e, 0x79, 0xe7,
			0x9e, 0x79, 0xe8, 0x3e, 0x8a, 0x28, 0xa2, 0x23, 0xc8, 0xa2, 0x8a, 0x28, 0xa2, 0x8a, 0x88, 0x20,
			0x71, 0xc7, 0x1c, 0x22, 0x0b, 0x1e, 0x79, 0xe7, 0x9e, 0x7b, 0x67, 0x1e, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00, 0x80, 0x08, 0x68, 0x00, 0x08, 0x68, 0x00, 0x00, 0x11, 0x40, 0x10, 0x11,
			0x40, 0x0e, 0xb1, 0x01, 0x14, 0xb0, 0x00, 0x00, 0x20, 0x05, 0x08, 0x20, 0x05, 0x1c, 0x00, 0x82,
			0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02,
			0x71, 0xc7, 0x18, 0x61, 0x86, 0x1e, 0xf1, 0xc7, 0x1c, 0x71, 0xc0, 0x1c, 0x8a, 0x28, 0x88, 0x20,
			0x82, 0x22, 0x8a, 0x28, 0xa2, 0x8a, 0x2f, 0xa6, 0xfb, 0xef, 0x88, 0x20, 0x82, 0x22, 0x8a, 0x28,
			0xa2, 0x8a, 0x20, 0x2a, 0x82, 0x08, 0x08, 0x20, 0x82, 0x22, 0x8a, 0x28, 0xa2, 0x8a, 0x22, 0x32,
			0x79, 0xe7, 0x9c, 0x71, 0xc7, 0x1c, 0x89, 0xc7, 0x1c, 0x71, 0xc0, 0x1c, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x02, 0x00, 0x00, 0x00, 0x20, 0x80, 0x10, 0x40, 0x00, 0x00, 0x00, 0x40, 0x45, 0x00, 0x10,
			0x00, 0x30, 0x40, 0x30, 0x80, 0x00, 0x00, 0x00, 0x20, 0x80, 0x14, 0x22, 0x05, 0x38, 0x20, 0x71,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3c, 0x10, 0xf2, 0x00, 0x00, 0x00, 0x00,
			0x8a, 0x28, 0xa2, 0x8b, 0xc8, 0xbe, 0x09, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x28, 0xa2, 0x8a,
			0x28, 0xbf, 0x07, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x28, 0xa2, 0x8a, 0x28, 0xbf, 0x07, 0xf8,
			0x00, 0x00, 0x00, 0x00, 0x8a, 0x28, 0xa2, 0x8a, 0x28, 0xbe, 0x09, 0xf4, 0x00, 0x00, 0x00, 0x00,
			0x79, 0xe7, 0x9e, 0x7b, 0xc7, 0xbc, 0x10, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,
			0x00, 0xb8, 0x20, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x07, 0x30, 0x40, 0x30,
			0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x80, 0x10, 0x40, 0x00, 0x00, 0x00
		],
		96
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(6, 12),
	pixels: ONE
};

/// Tamzen 6x12 Bold Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_6x12_BOLD),
	")"
)]
///
/// Bitmap Size: 1,584 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen6x12b.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_6x12_BOLD: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 96 x 132 (1584)
		&[
			0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8d, 0x94, 0x31,
			0x86, 0x18, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xcd, 0xbe, 0x7a, 0x8d, 0x18, 0x31, 0x80,
			0x00, 0x00, 0x00, 0x06, 0x03, 0xcd, 0x94, 0xc2, 0xad, 0x18, 0x31, 0x82, 0x0c, 0x00, 0x00, 0x06,
			0x01, 0x80, 0x14, 0x63, 0x46, 0x00, 0x60, 0xcf, 0x8c, 0x00, 0x00, 0x0c, 0x01, 0x80, 0x3e, 0x30,
			0x8f, 0xc0, 0x60, 0xc7, 0x3f, 0x03, 0xe0, 0x0c, 0x00, 0x00, 0x3e, 0x19, 0x6d, 0x80, 0x60, 0xcf,
			0x8c, 0x00, 0x00, 0x18, 0x00, 0x00, 0x14, 0xf2, 0xad, 0x80, 0x60, 0xc2, 0x0c, 0x70, 0x07, 0x18,
			0x01, 0x80, 0x14, 0x60, 0xa7, 0xc0, 0x31, 0x80, 0x00, 0x70, 0x07, 0x30, 0x00, 0x00, 0x00, 0x60,
			0xc0, 0x00, 0x31, 0x80, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00,
			0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0xc7, 0x3e, 0x1b, 0xe7, 0x3e, 0x71, 0xc0,
			0x00, 0x18, 0x0c, 0x26, 0xc9, 0xc9, 0x86, 0x3b, 0x0c, 0x06, 0xcb, 0x27, 0x1c, 0x30, 0x06, 0x06,
			0xdb, 0xc1, 0x8c, 0x5b, 0xcf, 0x0c, 0xcb, 0x27, 0x1c, 0x63, 0xe3, 0x0c, 0xe8, 0xc3, 0x1c, 0x98,
			0x6c, 0x8c, 0x73, 0x20, 0x00, 0xc0, 0x01, 0x98, 0xc8, 0xc6, 0x06, 0xfc, 0x6c, 0x98, 0xc9, 0xe0,
			0x00, 0x63, 0xe3, 0x00, 0xf8, 0xcc, 0x06, 0x1a, 0x6c, 0x98, 0xc8, 0x67, 0x1c, 0x30, 0x06, 0x00,
			0x73, 0xff, 0xbc, 0x19, 0xc7, 0x18, 0x71, 0xc7, 0x1c, 0x18, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0x8f, 0x1e, 0xf3, 0xef, 0x9e, 0xc9, 0xe1,
			0xb2, 0xc2, 0x2c, 0x9c, 0xc9, 0xcc, 0xb0, 0xcb, 0x0c, 0x30, 0xc8, 0xc1, 0xb6, 0xc3, 0x6c, 0xb2,
			0xdb, 0x2c, 0xb0, 0xcb, 0x0c, 0x30, 0xc8, 0xc1, 0xbc, 0xc3, 0xee, 0xb2, 0xdb, 0x2f, 0x30, 0xcb,
			0xcf, 0x36, 0xf8, 0xc1, 0xb8, 0xc3, 0xef, 0xb2, 0xdb, 0xec, 0xb0, 0xcb, 0x0c, 0x32, 0xc8, 0xc9,
			0xbc, 0xc2, 0xad, 0xb2, 0xc3, 0x2c, 0xb0, 0xf3, 0x0c, 0x32, 0xc8, 0xc9, 0xb6, 0xc2, 0x2c, 0xb2,
			0xc3, 0x2f, 0x1e, 0xe3, 0xec, 0x1e, 0xc9, 0xe7, 0x32, 0xfa, 0x2c, 0x9c, 0x78, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x1e, 0x03, 0xc0, 0x00, 0xf1, 0xcf, 0x1e, 0xff, 0x2c, 0xa2, 0xcb, 0x2f,
			0x98, 0xc0, 0xc2, 0x00, 0xcb, 0x2c, 0xb0, 0x33, 0x2c, 0xaa, 0xcb, 0x23, 0x18, 0xc0, 0xc7, 0x00,
			0xcb, 0x2c, 0xb0, 0x33, 0x2c, 0xaa, 0x73, 0x23, 0x18, 0x60, 0xcd, 0x80, 0xf3, 0x2f, 0x1c, 0x33,
			0x2c, 0xbe, 0x71, 0xc6, 0x18, 0x60, 0xc8, 0x80, 0xc3, 0x2f, 0x06, 0x33, 0x27, 0x3e, 0x70, 0xc6,
			0x18, 0x30, 0xc0, 0x00, 0xc3, 0x2d, 0x86, 0x33, 0x27, 0x36, 0xc8, 0xcc, 0x18, 0x30, 0xc0, 0x00,
			0xc1, 0xcc, 0xbc, 0x31, 0xc2, 0x36, 0xc8, 0xcf, 0x98, 0x18, 0xc0, 0x00, 0x00, 0x40, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0xc0, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1e, 0x03, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x18, 0x03, 0x80, 0xc0, 0xc3,
			0x30, 0x70, 0x00, 0x00, 0x18, 0x0c, 0x00, 0x18, 0x06, 0x00, 0xc0, 0x00, 0x30, 0x30, 0x00, 0x00,
			0x01, 0xcf, 0x1e, 0x79, 0xcf, 0x9e, 0xf1, 0xc7, 0x36, 0x33, 0x6f, 0x1c, 0x00, 0x6c, 0xb0, 0x9b,
			0x26, 0x26, 0xc8, 0xc3, 0x3c, 0x33, 0xec, 0xb2, 0x01, 0xec, 0xb0, 0x9b, 0xe6, 0x26, 0xc8, 0xc3,
			0x3c, 0x33, 0xec, 0xb2, 0x02, 0x6c, 0xb0, 0x9b, 0x06, 0x26, 0xc8, 0xc3, 0x36, 0x33, 0x2c, 0xb2,
			0x01, 0xef, 0x1e, 0x79, 0xe6, 0x1e, 0xc9, 0xe3, 0x32, 0x7b, 0x2c, 0x9c, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x06, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0c, 0x30, 0xc6, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0xcf, 0x98,
			0xf1, 0xed, 0x9e, 0xfb, 0x2c, 0xa2, 0xcb, 0x2f, 0x8c, 0x30, 0xcb, 0x00, 0xca, 0x6e, 0x30, 0x63,
			0x2c, 0xaa, 0x73, 0x23, 0x38, 0x30, 0x70, 0x00, 0xca, 0x6c, 0x1c, 0x63, 0x27, 0x2a, 0x73, 0x26,
			0x0c, 0x30, 0xc0, 0x18, 0xca, 0x6c, 0x06, 0x63, 0x27, 0x3e, 0x71, 0xcc, 0x0c, 0x30, 0xc0, 0x18,
			0xf1, 0xec, 0x3c, 0x39, 0xc2, 0x3e, 0xc8, 0xcf, 0x8c, 0x30, 0xc0, 0x3c, 0xc0, 0x60, 0x00, 0x00,
			0x00, 0x00, 0x00, 0xc0, 0x0c, 0x30, 0xc0, 0x3c, 0xc0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80,
			0x07, 0x03, 0x80, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x19, 0xc6, 0xb6, 0x70, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30,
			0x00, 0x18, 0x33, 0x6b, 0x36, 0xd8, 0x00, 0x18, 0x30, 0xec, 0xb2, 0x31, 0xc0, 0x00, 0x00, 0x00,
			0x00, 0x70, 0xe7, 0x80, 0x79, 0x87, 0x32, 0x33, 0x23, 0x08, 0x20, 0x82, 0x08, 0x21, 0xcc, 0x3e,
			0xc1, 0x8c, 0x9c, 0x33, 0x20, 0x1c, 0x71, 0xc7, 0x1c, 0x73, 0x4c, 0x30, 0xc3, 0xec, 0xbe, 0x01,
			0xc0, 0x32, 0xcb, 0x2c, 0xb2, 0xcb, 0x6c, 0x3c, 0xc1, 0x87, 0x0c, 0x30, 0x03, 0x3e, 0xfb, 0xef,
			0xbe, 0xfb, 0xcc, 0x30, 0x79, 0x8c, 0xbe, 0x30, 0x06, 0x32, 0xcb, 0x2c, 0xb2, 0xcb, 0x4c, 0x30,
			0x33, 0xe0, 0x0c, 0x30, 0x0c, 0x32, 0xcb, 0x2c, 0xb2, 0xcb, 0x67, 0xbe, 0x30, 0x00, 0x00, 0x30,
			0x0c, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x19, 0xcd, 0x98, 0x19, 0xcd, 0x80, 0x6b, 0x01, 0x9c, 0x6b, 0x60, 0x00, 0x33, 0x6d, 0x8c, 0x33,
			0x6d, 0x80, 0xb1, 0x83, 0x36, 0xb3, 0x60, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x1c, 0xfb, 0xef, 0x9e, 0x79, 0xe7, 0x9a, 0xc9, 0xc7, 0x1c, 0x71, 0xc0, 0x32,
			0xc3, 0x0c, 0x0c, 0x30, 0xc3, 0x1a, 0xeb, 0x2c, 0xb2, 0xcb, 0x2c, 0xb6, 0xf3, 0xcf, 0x0c, 0x30,
			0xc3, 0x3a, 0xfb, 0x2c, 0xb2, 0xcb, 0x27, 0x3a, 0xc3, 0x0c, 0x0c, 0x30, 0xc3, 0x1a, 0xdb, 0x2c,
			0xb2, 0xcb, 0x27, 0x32, 0xc3, 0x0c, 0x0c, 0x30, 0xc3, 0x1c, 0xcb, 0x2c, 0xb2, 0xcb, 0x2c, 0xb2,
			0xfb, 0xef, 0x9e, 0x79, 0xe7, 0xb8, 0xc9, 0xc7, 0x1c, 0x71, 0xc0, 0x1c, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xc0, 0x67, 0x36, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x60, 0xcd, 0xb6, 0x30,
			0x07, 0x30, 0x19, 0xc6, 0xb6, 0xd8, 0x00, 0x30, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x98, 0x33, 0x6b,
			0x36, 0x70, 0x00, 0x18, 0xcb, 0x2c, 0xb2, 0xcb, 0xcc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xcb, 0x2c, 0xb2, 0xcb, 0x2d, 0x1c, 0x71, 0xc7, 0x1c, 0x73, 0x67, 0x1c, 0xcb, 0x2c, 0xb2, 0x73,
			0x2c, 0x86, 0x18, 0x61, 0x86, 0x19, 0xac, 0x32, 0xcb, 0x2c, 0xb2, 0x33, 0x2c, 0x9e, 0x79, 0xe7,
			0x9e, 0x79, 0xec, 0x3e, 0xcb, 0x2c, 0xb2, 0x33, 0xcc, 0xa6, 0x9a, 0x69, 0xa6, 0x9a, 0xcc, 0x30,
			0x71, 0xc7, 0x1c, 0x33, 0x0d, 0x1e, 0x79, 0xe7, 0x9e, 0x7b, 0xe7, 0x1e, 0x00, 0x00, 0x00, 0x00,
			0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xcd, 0x98, 0x19,
			0xcd, 0x8e, 0x6b, 0x01, 0x9c, 0x6b, 0x60, 0x00, 0x33, 0x6d, 0x8c, 0x33, 0x6d, 0x9c, 0xb1, 0x83,
			0x36, 0xb3, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04,
			0x71, 0xc7, 0x1c, 0x71, 0xc7, 0x1e, 0xf1, 0xc7, 0x1c, 0x71, 0xc0, 0x1c, 0xcb, 0x2c, 0x8c, 0x30,
			0xc3, 0x26, 0xcb, 0x2c, 0xb2, 0xcb, 0x2f, 0xf6, 0xfb, 0xef, 0x8c, 0x30, 0xc3, 0x26, 0xcb, 0x2c,
			0xb2, 0xcb, 0x20, 0x3a, 0xc3, 0x0c, 0x0c, 0x30, 0xc3, 0x26, 0xcb, 0x2c, 0xb2, 0xcb, 0x23, 0x32,
			0x79, 0xe7, 0x9e, 0x79, 0xe7, 0x9c, 0xc9, 0xc7, 0x1c, 0x71, 0xc3, 0x1c, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x80, 0x10, 0x40, 0x00, 0x00, 0x00, 0xc0, 0x67, 0x36, 0x18,
			0x0d, 0xb0, 0x40, 0x30, 0x80, 0x00, 0x00, 0x00, 0x60, 0xcd, 0xb6, 0x33, 0x0d, 0xb8, 0x20, 0x71,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x3c, 0x10, 0xf2, 0x00, 0x00, 0x00, 0x00,
			0xcb, 0x2c, 0xb2, 0xcb, 0xcc, 0xbe, 0x09, 0xf4, 0x00, 0x00, 0x00, 0x00, 0xcb, 0x2c, 0xb2, 0xcb,
			0x2c, 0xbf, 0x07, 0xf8, 0x00, 0x00, 0x00, 0x00, 0xcb, 0x2c, 0xb2, 0xcb, 0x2c, 0xbf, 0x07, 0xf8,
			0x00, 0x00, 0x00, 0x00, 0xcb, 0x2c, 0xb2, 0xcb, 0x2c, 0xbe, 0x09, 0xf4, 0x00, 0x00, 0x00, 0x00,
			0x71, 0xc7, 0x1c, 0x7b, 0xc7, 0xbc, 0x10, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b,
			0x01, 0xb8, 0x20, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x07, 0x30, 0x40, 0x30,
			0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x80, 0x10, 0x40, 0x00, 0x00, 0x00
		],
		96
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(6, 12),
	pixels: ONE
};

/// Tamzen 7x13 Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_7x13),
	")"
)]
///
/// Bitmap Size: 1,976 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen7x13r.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_7x13: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 64 x 247 (1976)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
			0x00, 0x20, 0xa1, 0x40, 0x84, 0x08, 0x08, 0x08, 0x00, 0x20, 0xa1, 0x43, 0xca, 0x14, 0x08, 0x10,
			0x00, 0x20, 0xa3, 0xe4, 0x0a, 0x94, 0x08, 0x10, 0x00, 0x20, 0x01, 0x43, 0x05, 0x08, 0x00, 0x20,
			0x00, 0x20, 0x01, 0x40, 0x82, 0x15, 0x00, 0x20, 0x00, 0x00, 0x03, 0xe0, 0x45, 0x12, 0x00, 0x20,
			0x00, 0x00, 0x01, 0x47, 0x8a, 0x92, 0x00, 0x20, 0x00, 0x20, 0x01, 0x41, 0x02, 0x8d, 0x00, 0x10,
			0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1c, 0x10, 0x10, 0x20, 0x40, 0x00, 0x00, 0x02, 0x22, 0x30,
			0x08, 0xa8, 0x40, 0x00, 0x00, 0x04, 0x26, 0x50, 0x08, 0x71, 0xf0, 0x07, 0xc0, 0x04, 0x2a, 0x10,
			0x08, 0xa8, 0x40, 0x00, 0x00, 0x08, 0x32, 0x10, 0x08, 0x20, 0x41, 0x80, 0x06, 0x08, 0x22, 0x10,
			0x10, 0x00, 0x01, 0x80, 0x06, 0x10, 0x1c, 0x7c, 0x10, 0x00, 0x00, 0x80, 0x00, 0x10, 0x00, 0x00,
			0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf8, 0x23, 0xe1, 0x8f, 0x8e, 0x1c, 0x00,
			0x44, 0x08, 0x62, 0x02, 0x00, 0x91, 0x22, 0x30, 0x04, 0x10, 0xa3, 0xc4, 0x01, 0x11, 0x22, 0x30,
			0x08, 0x31, 0x20, 0x27, 0x81, 0x0e, 0x1e, 0x00, 0x10, 0x09, 0xf0, 0x24, 0x42, 0x11, 0x02, 0x00,
			0x20, 0x88, 0x22, 0x24, 0x42, 0x11, 0x04, 0x30, 0x7c, 0x70, 0x21, 0xc3, 0x82, 0x0e, 0x18, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x87, 0x00, 0x00, 0x00,
			0x00, 0x08, 0x02, 0x04, 0x48, 0x84, 0x3c, 0x1c, 0x30, 0x10, 0x01, 0x00, 0x48, 0x8a, 0x22, 0x20,
			0x30, 0x21, 0xf0, 0x80, 0x89, 0x91, 0x22, 0x40, 0x00, 0x40, 0x00, 0x41, 0x0a, 0x91, 0x3c, 0x40,
			0x00, 0x21, 0xf0, 0x80, 0x0b, 0x9f, 0x22, 0x40, 0x30, 0x10, 0x01, 0x00, 0x08, 0x11, 0x22, 0x20,
			0x30, 0x08, 0x02, 0x01, 0x08, 0x11, 0x3c, 0x1c, 0x10, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00,
			0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xf9, 0xf0, 0xe4, 0x4f, 0x81, 0x22, 0x40,
			0x44, 0x81, 0x01, 0x04, 0x42, 0x01, 0x24, 0x40, 0x44, 0x81, 0x02, 0x04, 0x42, 0x01, 0x28, 0x40,
			0x44, 0xf1, 0xe2, 0x67, 0xc2, 0x01, 0x30, 0x40, 0x44, 0x81, 0x02, 0x24, 0x42, 0x11, 0x28, 0x40,
			0x48, 0x81, 0x01, 0x24, 0x42, 0x11, 0x24, 0x40, 0x70, 0xf9, 0x00, 0xe4, 0x4f, 0x8e, 0x22, 0x7c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x44, 0x88, 0xe3, 0xc3, 0x8f, 0x0f, 0x3e, 0x44, 0x6c, 0xc9, 0x12, 0x24, 0x48, 0x90, 0x08, 0x44,
			0x54, 0xa9, 0x12, 0x24, 0x48, 0x90, 0x08, 0x44, 0x54, 0x99, 0x13, 0xc4, 0x4f, 0x0e, 0x08, 0x44,
			0x44, 0x89, 0x12, 0x04, 0x4a, 0x01, 0x08, 0x44, 0x44, 0x89, 0x12, 0x04, 0x49, 0x01, 0x08, 0x44,
			0x44, 0x88, 0xe2, 0x03, 0x88, 0x9e, 0x08, 0x38, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x1c, 0x00, 0x44, 0x89, 0x12, 0x27, 0xc4, 0x10, 0x04, 0x10,
			0x44, 0x89, 0x12, 0x20, 0x84, 0x10, 0x04, 0x28, 0x44, 0x88, 0xa1, 0x41, 0x04, 0x08, 0x04, 0x44,
			0x28, 0xa8, 0x40, 0x81, 0x04, 0x08, 0x04, 0x00, 0x28, 0xa8, 0xa0, 0x82, 0x04, 0x04, 0x04, 0x00,
			0x10, 0xa9, 0x10, 0x82, 0x04, 0x04, 0x04, 0x00, 0x10, 0xd9, 0x10, 0x87, 0xc4, 0x02, 0x04, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x1c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x20, 0x02, 0x00, 0x00, 0x80, 0x0e, 0x00, 0x00, 0x10, 0x02, 0x00, 0x00, 0x80, 0x10, 0x00,
			0x00, 0x00, 0xe3, 0xc3, 0xc7, 0x8e, 0x3e, 0x3c, 0x00, 0x00, 0x12, 0x24, 0x08, 0x91, 0x10, 0x44,
			0x00, 0x00, 0xf2, 0x24, 0x08, 0x9f, 0x10, 0x44, 0x00, 0x01, 0x12, 0x24, 0x08, 0x90, 0x10, 0x44,
			0x00, 0x00, 0xf3, 0xc3, 0xc7, 0x8f, 0x10, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
			0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x22, 0x07, 0x00, 0x00, 0x00, 0x00,
			0x40, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x78, 0xe0, 0xe2, 0x41, 0x0d, 0x9e, 0x1c, 0x78,
			0x44, 0x20, 0x22, 0x81, 0x0a, 0x91, 0x22, 0x44, 0x44, 0x20, 0x23, 0x81, 0x0a, 0x91, 0x22, 0x44,
			0x44, 0x20, 0x22, 0x41, 0x0a, 0x91, 0x22, 0x44, 0x44, 0xf8, 0x22, 0x27, 0xca, 0x91, 0x1c, 0x78,
			0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3c, 0xb8, 0xf3, 0xe4, 0x48, 0x91, 0x22, 0x44, 0x44, 0xc1, 0x01, 0x04, 0x48, 0x91, 0x14, 0x44,
			0x44, 0x80, 0xe1, 0x04, 0x48, 0x95, 0x08, 0x44, 0x44, 0x80, 0x11, 0x04, 0x45, 0x15, 0x14, 0x44,
			0x3c, 0x81, 0xe0, 0xe3, 0xc2, 0x1b, 0x22, 0x3c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x20, 0x40, 0x80, 0x00, 0x04, 0x00, 0x00, 0x00, 0x20, 0x40, 0x82, 0x40, 0x04, 0x0c, 0x00,
			0x00, 0x20, 0x40, 0x85, 0x42, 0x0e, 0x10, 0x44, 0x7c, 0x20, 0x40, 0x84, 0x80, 0x10, 0x10, 0x38,
			0x08, 0xc0, 0x40, 0x60, 0x00, 0x10, 0x3c, 0x28, 0x10, 0x20, 0x40, 0x80, 0x02, 0x10, 0x10, 0x38,
			0x20, 0x20, 0x40, 0x80, 0x02, 0x0e, 0x10, 0x44, 0x7c, 0x20, 0x40, 0x80, 0x02, 0x04, 0x3e, 0x00,
			0x00, 0x20, 0x40, 0x80, 0x02, 0x04, 0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x02, 0x01, 0x04, 0x1a, 0x28, 0x00, 0x20, 0x00, 0x01, 0x02, 0x0a, 0x2c, 0x00,
			0x44, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x21, 0x20, 0x81, 0x02, 0x04, 0x08, 0x10,
			0x10, 0x21, 0x20, 0x01, 0x02, 0x04, 0x08, 0x28, 0x7c, 0x00, 0xc0, 0x02, 0x85, 0x0a, 0x14, 0x28,
			0x10, 0x20, 0x00, 0x83, 0x87, 0x0e, 0x1c, 0x38, 0x7c, 0x20, 0x01, 0x04, 0x48, 0x91, 0x22, 0x44,
			0x10, 0x20, 0x02, 0x04, 0x48, 0x91, 0x22, 0x44, 0x00, 0x20, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00, 0x82, 0x0a, 0x10, 0x08,
			0x28, 0x00, 0x00, 0x81, 0x05, 0x00, 0x08, 0x10, 0x28, 0x38, 0x70, 0x00, 0x00, 0x1f, 0x00, 0x00,
			0x10, 0x30, 0x83, 0xe7, 0xcf, 0x90, 0x1c, 0x38, 0x10, 0x51, 0x02, 0x04, 0x08, 0x10, 0x08, 0x10,
			0x28, 0x59, 0x03, 0xc7, 0x8f, 0x1e, 0x08, 0x10, 0x38, 0x71, 0x02, 0x04, 0x08, 0x10, 0x08, 0x10,
			0x44, 0x90, 0x82, 0x04, 0x08, 0x10, 0x08, 0x10, 0x44, 0x98, 0x73, 0xe7, 0xcf, 0x9f, 0x1c, 0x38,
			0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x50, 0x01, 0xa2, 0x01, 0x04, 0x1a, 0x28, 0x28, 0x00, 0x02, 0xc1, 0x02, 0x0a, 0x2c, 0x00,
			0x00, 0x71, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x20, 0x92, 0x23, 0x87, 0x0e, 0x1c, 0x44,
			0x10, 0x20, 0x93, 0x24, 0x48, 0x91, 0x22, 0x44, 0x10, 0x21, 0xd2, 0xa4, 0x48, 0x91, 0x22, 0x44,
			0x10, 0x20, 0x92, 0x64, 0x48, 0x91, 0x22, 0x44, 0x10, 0x20, 0xa2, 0x24, 0x48, 0x91, 0x22, 0x44,
			0x38, 0x71, 0xc2, 0x23, 0x87, 0x0e, 0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x41, 0x05, 0x02, 0x00, 0x00,
			0x00, 0x08, 0x40, 0x82, 0x80, 0x04, 0x00, 0x00, 0x00, 0x71, 0x12, 0x20, 0x08, 0x80, 0x20, 0x38,
			0x00, 0x99, 0x12, 0x24, 0x48, 0x91, 0x3c, 0x44, 0x24, 0x99, 0x12, 0x24, 0x48, 0x91, 0x22, 0x48,
			0x18, 0xa9, 0x12, 0x24, 0x48, 0x8a, 0x22, 0x58, 0x18, 0xc9, 0x12, 0x24, 0x48, 0x84, 0x22, 0x44,
			0x24, 0xc9, 0x12, 0x24, 0x48, 0x84, 0x3c, 0x44, 0x00, 0x70, 0xe1, 0xc3, 0x87, 0x04, 0x20, 0x58,
			0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x41, 0xa0, 0x03, 0x00, 0x00, 0x00, 0x20, 0x10, 0xa2, 0xc0, 0x04, 0x80, 0x00, 0x20,
			0x10, 0x20, 0x00, 0x02, 0x83, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x38, 0x70, 0xe1, 0xc3, 0x87, 0x1b, 0x1c, 0x38, 0x04, 0x08, 0x10, 0x20, 0x40, 0x85, 0x20, 0x44,
			0x3c, 0x78, 0xf1, 0xe3, 0xc7, 0x8f, 0x20, 0x7c, 0x44, 0x89, 0x12, 0x24, 0x48, 0x94, 0x20, 0x40,
			0x3c, 0x78, 0xf1, 0xe3, 0xc7, 0x9b, 0x1c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x02, 0x00, 0x08, 0x34,
			0x08, 0x50, 0x01, 0x00, 0x85, 0x00, 0x0e, 0x58, 0x10, 0x00, 0xa0, 0x81, 0x00, 0x0a, 0x1c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x38, 0x70, 0xe1, 0x83, 0x06, 0x0c, 0x1e, 0x78,
			0x44, 0x89, 0x10, 0x81, 0x02, 0x04, 0x22, 0x44, 0x7c, 0xf9, 0xf0, 0x81, 0x02, 0x04, 0x22, 0x44,
			0x40, 0x81, 0x00, 0x81, 0x02, 0x04, 0x22, 0x44, 0x3c, 0x78, 0xf1, 0xc3, 0x87, 0x0e, 0x1c, 0x44,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x41, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0xa2, 0xc0, 0x00, 0x00, 0x10, 0x08,
			0x10, 0x20, 0x00, 0x02, 0x80, 0x00, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00,
			0x38, 0x70, 0xe1, 0xc3, 0x80, 0x0e, 0x22, 0x44, 0x44, 0x89, 0x12, 0x24, 0x4f, 0x93, 0x22, 0x44,
			0x44, 0x89, 0x12, 0x24, 0x40, 0x15, 0x22, 0x44, 0x44, 0x89, 0x12, 0x24, 0x42, 0x19, 0x22, 0x44,
			0x38, 0x70, 0xe1, 0xc3, 0x80, 0x0e, 0x1e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x01, 0x02, 0x10, 0x00, 0x00, 0x00, 0x18, 0x10, 0x03, 0x04,
			0x28, 0x00, 0x20, 0x00, 0x1c, 0x08, 0x07, 0x08, 0x00, 0x50, 0x42, 0x02, 0x9e, 0x04, 0x0f, 0x10,
			0x00, 0x00, 0x02, 0x00, 0x1f, 0x02, 0x1f, 0x20, 0x44, 0x89, 0x13, 0xc4, 0x5f, 0x81, 0x3f, 0x40,
			0x44, 0x89, 0x12, 0x24, 0x5f, 0xc0, 0xff, 0x80, 0x44, 0x89, 0x12, 0x24, 0x5f, 0x81, 0x3f, 0x40,
			0x44, 0x89, 0x12, 0x24, 0x5f, 0x02, 0x1f, 0x20, 0x3c, 0x78, 0xf3, 0xc3, 0xde, 0x04, 0x0f, 0x10,
			0x00, 0x00, 0x12, 0x00, 0x5c, 0x08, 0x07, 0x08, 0x00, 0x00, 0xe2, 0x03, 0x98, 0x10, 0x03, 0x04,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x01, 0x02
		],
		64
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(7, 13),
	pixels: ONE
};

/// Tamzen 7x13 Bold Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_7x13_BOLD),
	")"
)]
///
/// Bitmap Size: 1,976 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen7x13b.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_7x13_BOLD: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 64 x 247 (1976)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x41, 0x80, 0x00, 0x00, 0x00,
			0x00, 0x63, 0x62, 0x41, 0x8c, 0x1c, 0x18, 0x18, 0x00, 0xf3, 0x67, 0xe3, 0xda, 0x36, 0x18, 0x30,
			0x00, 0xf3, 0x67, 0xe6, 0x1b, 0xb6, 0x18, 0x30, 0x00, 0x60, 0x02, 0x43, 0x0f, 0x1c, 0x00, 0x60,
			0x00, 0x60, 0x02, 0x41, 0x86, 0x37, 0x80, 0x60, 0x00, 0x00, 0x07, 0xe0, 0xcf, 0x33, 0x00, 0x60,
			0x00, 0x00, 0x07, 0xe7, 0x9e, 0xb3, 0x00, 0x60, 0x00, 0x60, 0x02, 0x43, 0x06, 0x9f, 0x80, 0x30,
			0x00, 0x00, 0x02, 0x43, 0x03, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x3c, 0x30, 0x30, 0xd8, 0xc0, 0x00, 0x00, 0x06, 0x66, 0x70,
			0x18, 0x70, 0xc0, 0x00, 0x00, 0x0c, 0x6e, 0xf0, 0x19, 0xff, 0xf0, 0x0f, 0xc0, 0x0c, 0x76, 0x30,
			0x18, 0x70, 0xc0, 0x00, 0x00, 0x18, 0x76, 0x30, 0x18, 0xd8, 0xc3, 0x80, 0x0e, 0x18, 0x66, 0x30,
			0x30, 0x00, 0x03, 0x80, 0x0e, 0x30, 0x3c, 0xfc, 0x30, 0x00, 0x01, 0x80, 0x00, 0x30, 0x00, 0x00,
			0x60, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xf8, 0x67, 0xe3, 0x9f, 0x9e, 0x3c, 0x00,
			0xcc, 0x18, 0xe6, 0x06, 0x01, 0xb3, 0x66, 0x70, 0x0c, 0x31, 0xe7, 0xcc, 0x03, 0x33, 0x66, 0x70,
			0x18, 0x73, 0x60, 0x6f, 0x83, 0x1e, 0x3e, 0x00, 0x30, 0x1b, 0xf0, 0x6c, 0xc6, 0x33, 0x06, 0x00,
			0x61, 0x98, 0x66, 0x6c, 0xc6, 0x33, 0x0c, 0x70, 0xfc, 0xf0, 0x63, 0xc7, 0x86, 0x1e, 0x38, 0x70,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x8f, 0x00, 0x00, 0x00,
			0x00, 0x18, 0x06, 0x0c, 0xd9, 0x8c, 0x7c, 0x3c, 0x70, 0x30, 0x03, 0x00, 0xd9, 0x9e, 0x66, 0x60,
			0x70, 0x63, 0xf1, 0x81, 0x9b, 0xb3, 0x66, 0xc0, 0x00, 0xc0, 0x00, 0xc3, 0x1b, 0xb3, 0x7c, 0xc0,
			0x00, 0x63, 0xf1, 0x80, 0x1b, 0xbf, 0x66, 0xc0, 0x70, 0x30, 0x03, 0x00, 0x18, 0x33, 0x66, 0x60,
			0x70, 0x18, 0x06, 0x03, 0x18, 0x33, 0x7c, 0x3c, 0x30, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00,
			0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 0xfb, 0xf1, 0xec, 0xdf, 0x83, 0x66, 0xc0,
			0xd9, 0x83, 0x03, 0x0c, 0xc6, 0x03, 0x6c, 0xc0, 0xcd, 0x83, 0x06, 0x0c, 0xc6, 0x03, 0x78, 0xc0,
			0xcd, 0xf3, 0xe6, 0xef, 0xc6, 0x03, 0x70, 0xc0, 0xcd, 0x83, 0x06, 0x6c, 0xc6, 0x33, 0x78, 0xc0,
			0xd9, 0x83, 0x03, 0x6c, 0xc6, 0x33, 0x6c, 0xc0, 0xf1, 0xfb, 0x01, 0xec, 0xdf, 0x9e, 0x66, 0xfc,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xcd, 0x99, 0xe7, 0xc7, 0x9f, 0x1f, 0x7e, 0xcc, 0xfd, 0xdb, 0x36, 0x6c, 0xd9, 0xb0, 0x18, 0xcc,
			0xfd, 0xfb, 0x36, 0x6c, 0xd9, 0xb0, 0x18, 0xcc, 0xcd, 0xbb, 0x37, 0xcc, 0xdf, 0x1e, 0x18, 0xcc,
			0xcd, 0x9b, 0x36, 0x0c, 0xdb, 0x03, 0x18, 0xcc, 0xcd, 0x9b, 0x36, 0x0c, 0xd9, 0x83, 0x18, 0xcc,
			0xcd, 0x99, 0xe6, 0x07, 0x99, 0xbe, 0x18, 0x78, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x3c, 0x00, 0xcd, 0x9b, 0x36, 0x6f, 0xcc, 0x30, 0x0c, 0x30,
			0xcd, 0x9b, 0x36, 0x61, 0x8c, 0x30, 0x0c, 0x78, 0xcd, 0x99, 0xe3, 0xc3, 0x0c, 0x18, 0x0c, 0xcc,
			0xcd, 0x98, 0xc1, 0x83, 0x0c, 0x18, 0x0c, 0x00, 0xcd, 0xf9, 0xe1, 0x86, 0x0c, 0x0c, 0x0c, 0x00,
			0x79, 0xfb, 0x31, 0x86, 0x0c, 0x0c, 0x0c, 0x00, 0x31, 0x9b, 0x31, 0x8f, 0xcc, 0x06, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x3c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x60, 0x06, 0x00, 0x01, 0x80, 0x1e, 0x00, 0x00, 0x30, 0x06, 0x00, 0x01, 0x80, 0x30, 0x00,
			0x00, 0x01, 0xe7, 0xc7, 0xcf, 0x9e, 0x7e, 0x7c, 0x00, 0x00, 0x36, 0x6c, 0x19, 0xb3, 0x30, 0xcc,
			0x00, 0x01, 0xf6, 0x6c, 0x19, 0xbf, 0x30, 0xcc, 0x00, 0x03, 0x36, 0x6c, 0x19, 0xb0, 0x30, 0xcc,
			0x00, 0x01, 0xf7, 0xc7, 0xcf, 0x9f, 0x30, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
			0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x60, 0x66, 0x0f, 0x00, 0x00, 0x00, 0x00,
			0xc0, 0x00, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xe1, 0xe6, 0xc3, 0x1f, 0xbe, 0x3c, 0xf8,
			0xcc, 0x60, 0x67, 0x83, 0x1a, 0xb3, 0x66, 0xcc, 0xcc, 0x60, 0x67, 0x83, 0x1a, 0xb3, 0x66, 0xcc,
			0xcc, 0x60, 0x66, 0xc3, 0x1a, 0xb3, 0x66, 0xcc, 0xcd, 0xf8, 0x66, 0x6f, 0xda, 0xb3, 0x3c, 0xf8,
			0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x7d, 0xb9, 0xf7, 0xec, 0xd9, 0xb1, 0x66, 0xcc, 0xcd, 0xc3, 0x03, 0x0c, 0xd9, 0xb5, 0x3c, 0xcc,
			0xcd, 0x81, 0xe3, 0x0c, 0xd9, 0xb5, 0x18, 0xcc, 0xcd, 0x80, 0x33, 0x0c, 0xcf, 0x3f, 0x3c, 0xcc,
			0x7d, 0x83, 0xe1, 0xe7, 0xc6, 0x3b, 0x66, 0x7c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
			0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x60, 0xc1, 0x80, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x60, 0xc1, 0x86, 0x40, 0x0c, 0x1c, 0x00,
			0x00, 0x60, 0xc1, 0x8f, 0xc6, 0x1e, 0x30, 0xcc, 0xfc, 0x60, 0xc1, 0x89, 0x80, 0x30, 0x30, 0x78,
			0x19, 0xc0, 0xc0, 0xe0, 0x00, 0x30, 0x7c, 0x78, 0x30, 0x60, 0xc1, 0x80, 0x06, 0x30, 0x30, 0x78,
			0x60, 0x60, 0xc1, 0x80, 0x06, 0x1e, 0x30, 0xcc, 0xfc, 0x60, 0xc1, 0x80, 0x06, 0x0c, 0x7e, 0x00,
			0x00, 0x60, 0xc1, 0x80, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x38, 0x07, 0x00, 0x06, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x03, 0x1e, 0x32, 0xcc,
			0x00, 0x00, 0x00, 0x03, 0x06, 0x33, 0x7e, 0xcc, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00,
			0xcc, 0x61, 0xc0, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x78, 0x63, 0x61, 0x87, 0x8f, 0x1e, 0x3c, 0x78,
			0x30, 0x63, 0x60, 0x0c, 0xd9, 0xb3, 0x66, 0xcc, 0xfc, 0x01, 0xc0, 0x0c, 0xd9, 0xb3, 0x66, 0xcc,
			0x30, 0x60, 0x01, 0x8f, 0xdf, 0xbf, 0x7e, 0xfc, 0xfc, 0x60, 0x03, 0x0c, 0xd9, 0xb3, 0x66, 0xcc,
			0x30, 0x60, 0x06, 0x0c, 0xd9, 0xb3, 0x66, 0xcc, 0x00, 0x60, 0x06, 0x20, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x78, 0x00, 0x03, 0x01, 0x8f, 0x33, 0x30, 0x18, 0xcc, 0x00, 0x01, 0x83, 0x19, 0xb3, 0x18, 0x30,
			0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x78, 0xf7, 0xef, 0xdf, 0xbf, 0x3c, 0x78,
			0x78, 0xf1, 0x86, 0x0c, 0x18, 0x30, 0x18, 0x30, 0xcd, 0xb3, 0x06, 0x0c, 0x18, 0x30, 0x18, 0x30,
			0xcd, 0xbb, 0x07, 0xcf, 0x9f, 0x3e, 0x18, 0x30, 0xfd, 0xf3, 0x06, 0x0c, 0x18, 0x30, 0x18, 0x30,
			0xcd, 0xb1, 0x86, 0x0c, 0x18, 0x30, 0x18, 0x30, 0xcd, 0xb8, 0xf7, 0xef, 0xdf, 0xbf, 0x3c, 0x78,
			0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0x98, 0x03, 0x26, 0x03, 0x1e, 0x32, 0xcc,
			0xcd, 0x98, 0x07, 0xe3, 0x06, 0x33, 0x7e, 0xcc, 0x00, 0x00, 0x04, 0xc0, 0x00, 0x00, 0x4c, 0x00,
			0x78, 0xf3, 0xe0, 0x07, 0x8f, 0x1e, 0x00, 0x78, 0x30, 0x61, 0xb6, 0x6c, 0xd9, 0xb3, 0x3c, 0xcc,
			0x30, 0x61, 0xb7, 0x6c, 0xd9, 0xb3, 0x66, 0xcc, 0x30, 0x63, 0xf7, 0xec, 0xd9, 0xb3, 0x66, 0xcc,
			0x30, 0x61, 0xb6, 0xec, 0xd9, 0xb3, 0x66, 0xcc, 0x30, 0x61, 0xe6, 0x6c, 0xd9, 0xb3, 0x66, 0xcc,
			0x78, 0xf3, 0xc6, 0x67, 0x8f, 0x1e, 0x3c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x01, 0x80, 0xc7, 0x99, 0x86, 0x00, 0x00, 0x00, 0x00, 0xc1, 0x8c, 0xd9, 0x8c, 0x00, 0x00,
			0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf3, 0x36, 0x6c, 0xd9, 0xb3, 0x60, 0x78,
			0x01, 0x9b, 0x36, 0x6c, 0xd9, 0xb3, 0x7c, 0xcc, 0x6d, 0xab, 0x36, 0x6c, 0xd9, 0x9e, 0x66, 0xd8,
			0x39, 0xab, 0x36, 0x6c, 0xd9, 0x8c, 0x66, 0xcc, 0x39, 0xcb, 0x36, 0x6c, 0xd9, 0x8c, 0x66, 0xcc,
			0x6d, 0xcb, 0x36, 0x6c, 0xd9, 0x8c, 0x7c, 0xcc, 0x00, 0xf1, 0xe3, 0xc7, 0x8f, 0x0c, 0x60, 0xd8,
			0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x20, 0x07, 0x00, 0x00, 0x00, 0x60, 0x31, 0xe7, 0xec, 0xcd, 0x80, 0x00, 0x60,
			0x30, 0x63, 0x34, 0xcc, 0xc7, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x78, 0xf1, 0xe3, 0xc7, 0x8f, 0x1b, 0x3e, 0x78, 0x0c, 0x18, 0x30, 0x60, 0xc1, 0x8d, 0x60, 0xcc,
			0x7c, 0xf9, 0xf3, 0xe7, 0xcf, 0x9f, 0x60, 0xfc, 0xcd, 0x9b, 0x36, 0x6c, 0xd9, 0xac, 0x60, 0xc0,
			0x7c, 0xf9, 0xf3, 0xe7, 0xcf, 0xb7, 0x3e, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x64,
			0x18, 0xf3, 0x33, 0x01, 0x8f, 0x33, 0x0c, 0xfc, 0x31, 0x9b, 0x31, 0x83, 0x19, 0xb3, 0x3c, 0x98,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x78, 0xf1, 0xe3, 0x87, 0x0e, 0x1c, 0x3e, 0xf8,
			0xcd, 0x9b, 0x31, 0x83, 0x06, 0x0c, 0x66, 0xcc, 0xfd, 0xfb, 0xf1, 0x83, 0x06, 0x0c, 0x66, 0xcc,
			0xc1, 0x83, 0x01, 0x83, 0x06, 0x0c, 0x66, 0xcc, 0x7c, 0xf9, 0xf3, 0xc7, 0x8f, 0x1e, 0x3c, 0xcc,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x20, 0x00, 0x00, 0x00, 0x00, 0x60, 0x31, 0xe7, 0xec, 0xc0, 0x00, 0x30, 0x18,
			0x30, 0x63, 0x34, 0xcc, 0xc6, 0x00, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
			0x78, 0xf1, 0xe3, 0xc7, 0x80, 0x1e, 0x66, 0xcc, 0xcd, 0x9b, 0x36, 0x6c, 0xdf, 0xb3, 0x66, 0xcc,
			0xcd, 0x9b, 0x36, 0x6c, 0xc0, 0x35, 0x66, 0xcc, 0xcd, 0x9b, 0x36, 0x6c, 0xc0, 0x39, 0x66, 0xcc,
			0x78, 0xf1, 0xe3, 0xc7, 0x86, 0x1e, 0x3e, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x03, 0x04,
			0x79, 0x98, 0x60, 0x0c, 0xdc, 0x08, 0x07, 0x08, 0xcd, 0x98, 0xc6, 0x0c, 0xde, 0x04, 0x0f, 0x10,
			0x00, 0x00, 0x06, 0x00, 0x1f, 0x02, 0x1f, 0x20, 0xcd, 0x9b, 0x37, 0xcc, 0xdf, 0x81, 0x3f, 0x40,
			0xcd, 0x9b, 0x36, 0x6c, 0xdf, 0xc0, 0xff, 0x80, 0xcd, 0x9b, 0x36, 0x6c, 0xdf, 0x81, 0x3f, 0x40,
			0xcd, 0x9b, 0x36, 0x6c, 0xdf, 0x02, 0x1f, 0x20, 0x7c, 0xf9, 0xf7, 0xc7, 0xde, 0x04, 0x0f, 0x10,
			0x00, 0x00, 0x36, 0x00, 0xdc, 0x08, 0x07, 0x08, 0x00, 0x01, 0xe6, 0x07, 0x98, 0x10, 0x03, 0x04,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x01, 0x02
		],
		64
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(7, 13),
	pixels: ONE
};

/// Tamzen 7x14 Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_7x14),
	")"
)]
///
/// Bitmap Size: 2,128 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen7x14r.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_7x14: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 64 x 266 (2128)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x20, 0xa0, 0x01, 0x00, 0x08, 0x08, 0x08, 0x00, 0x20, 0xa1, 0x41, 0x08, 0x14, 0x08, 0x10,
			0x00, 0x20, 0xa1, 0x43, 0xd4, 0x94, 0x08, 0x10, 0x00, 0x20, 0xa3, 0xe4, 0x15, 0x14, 0x08, 0x20,
			0x00, 0x20, 0x01, 0x44, 0x0a, 0x09, 0x00, 0x20, 0x00, 0x00, 0x01, 0x43, 0x85, 0x15, 0x00, 0x20,
			0x00, 0x00, 0x03, 0xe0, 0x4a, 0x92, 0x00, 0x20, 0x00, 0x20, 0x01, 0x40, 0x52, 0x93, 0x00, 0x20,
			0x00, 0x20, 0x01, 0x47, 0x81, 0x0c, 0x80, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,
			0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x20, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x01, 0x1c, 0x10,
			0x10, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22, 0x30, 0x08, 0x20, 0x40, 0x00, 0x00, 0x02, 0x26, 0x50,
			0x08, 0xa8, 0x40, 0x00, 0x00, 0x04, 0x2a, 0x10, 0x08, 0x71, 0xf0, 0x07, 0xc0, 0x04, 0x32, 0x10,
			0x08, 0xa8, 0x40, 0x00, 0x00, 0x08, 0x22, 0x10, 0x08, 0x20, 0x41, 0x80, 0x06, 0x08, 0x22, 0x10,
			0x10, 0x00, 0x01, 0x80, 0x06, 0x10, 0x1c, 0x7c, 0x10, 0x00, 0x00, 0x80, 0x00, 0x10, 0x00, 0x00,
			0x20, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf8, 0x23, 0xe1, 0x8f, 0x8e, 0x1c, 0x00,
			0x44, 0x08, 0x62, 0x02, 0x00, 0x91, 0x22, 0x30, 0x04, 0x10, 0xa2, 0x04, 0x01, 0x11, 0x22, 0x30,
			0x08, 0x31, 0x23, 0xc7, 0x81, 0x0e, 0x22, 0x00, 0x10, 0x09, 0xf0, 0x24, 0x42, 0x11, 0x1e, 0x00,
			0x20, 0x08, 0x20, 0x24, 0x42, 0x11, 0x02, 0x00, 0x40, 0x88, 0x22, 0x24, 0x44, 0x11, 0x04, 0x30,
			0x7c, 0x70, 0x21, 0xc3, 0x84, 0x0e, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x47, 0x04, 0x3c, 0x1c,
			0x30, 0x08, 0x02, 0x00, 0x48, 0x8a, 0x22, 0x20, 0x30, 0x11, 0xf1, 0x00, 0x88, 0x91, 0x22, 0x40,
			0x00, 0x20, 0x00, 0x81, 0x09, 0x91, 0x3c, 0x40, 0x00, 0x40, 0x00, 0x40, 0x0a, 0x9f, 0x22, 0x40,
			0x00, 0x21, 0xf0, 0x80, 0x0b, 0x91, 0x22, 0x40, 0x30, 0x10, 0x01, 0x01, 0x08, 0x11, 0x22, 0x20,
			0x30, 0x08, 0x02, 0x01, 0x08, 0x11, 0x3c, 0x1c, 0x10, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00,
			0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xf9, 0xf0, 0xe4, 0x4f, 0x81, 0x22, 0x40,
			0x44, 0x81, 0x01, 0x04, 0x42, 0x01, 0x24, 0x40, 0x44, 0x81, 0x02, 0x04, 0x42, 0x01, 0x28, 0x40,
			0x44, 0xf1, 0xe2, 0x07, 0xc2, 0x01, 0x30, 0x40, 0x44, 0x81, 0x02, 0x64, 0x42, 0x01, 0x30, 0x40,
			0x44, 0x81, 0x02, 0x24, 0x42, 0x11, 0x28, 0x40, 0x48, 0x81, 0x01, 0x24, 0x42, 0x11, 0x24, 0x40,
			0x70, 0xf9, 0x00, 0xe4, 0x4f, 0x8e, 0x22, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x88, 0xe3, 0xc3, 0x8f, 0x0f, 0x3e, 0x44,
			0x6c, 0xc9, 0x12, 0x24, 0x48, 0x90, 0x08, 0x44, 0x54, 0xa9, 0x12, 0x24, 0x48, 0x90, 0x08, 0x44,
			0x54, 0x99, 0x12, 0x24, 0x48, 0x8c, 0x08, 0x44, 0x44, 0x89, 0x13, 0xc4, 0x4f, 0x02, 0x08, 0x44,
			0x44, 0x89, 0x12, 0x04, 0x4a, 0x01, 0x08, 0x44, 0x44, 0x89, 0x12, 0x04, 0x49, 0x01, 0x08, 0x44,
			0x44, 0x88, 0xe2, 0x03, 0x88, 0x9e, 0x08, 0x38, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x07, 0x10, 0x1c, 0x00, 0x44, 0x89, 0x12, 0x27, 0xc4, 0x10, 0x04, 0x10,
			0x44, 0x89, 0x12, 0x20, 0x84, 0x08, 0x04, 0x28, 0x44, 0x88, 0xa1, 0x40, 0x84, 0x08, 0x04, 0x44,
			0x44, 0x88, 0x41, 0x41, 0x04, 0x04, 0x04, 0x00, 0x28, 0xa8, 0x40, 0x81, 0x04, 0x04, 0x04, 0x00,
			0x28, 0xa8, 0xa0, 0x82, 0x04, 0x02, 0x04, 0x00, 0x10, 0xa9, 0x10, 0x82, 0x04, 0x02, 0x04, 0x00,
			0x10, 0xd9, 0x10, 0x87, 0xc4, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x04, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x80, 0x0e, 0x00,
			0x00, 0x10, 0x02, 0x00, 0x00, 0x80, 0x10, 0x00, 0x00, 0x00, 0xe2, 0xc3, 0xc7, 0x8e, 0x3e, 0x3c,
			0x00, 0x00, 0x13, 0x24, 0x08, 0x91, 0x10, 0x44, 0x00, 0x00, 0xf2, 0x24, 0x08, 0x9f, 0x10, 0x44,
			0x00, 0x01, 0x12, 0x24, 0x08, 0x90, 0x10, 0x44, 0x00, 0x01, 0x12, 0x24, 0x08, 0x90, 0x10, 0x44,
			0x00, 0x00, 0xf3, 0xc3, 0xc7, 0x8f, 0x10, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
			0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x40, 0x20, 0x22, 0x07, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x22, 0x01, 0x00, 0x00, 0x00, 0x00,
			0x40, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x58, 0xe0, 0xe2, 0x41, 0x0f, 0x16, 0x1c, 0x58,
			0x64, 0x20, 0x22, 0x81, 0x0a, 0x99, 0x22, 0x64, 0x44, 0x20, 0x23, 0x01, 0x0a, 0x91, 0x22, 0x44,
			0x44, 0x20, 0x22, 0x81, 0x0a, 0x91, 0x22, 0x44, 0x44, 0x20, 0x22, 0x41, 0x0a, 0x91, 0x22, 0x44,
			0x44, 0xf8, 0x22, 0x20, 0xca, 0x91, 0x1c, 0x78, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40,
			0x00, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xb8, 0xf3, 0xe4, 0x48, 0x91, 0x22, 0x44,
			0x44, 0xc1, 0x01, 0x04, 0x48, 0x91, 0x14, 0x44, 0x44, 0x80, 0xc1, 0x04, 0x45, 0x15, 0x08, 0x44,
			0x44, 0x80, 0x21, 0x04, 0x45, 0x15, 0x08, 0x44, 0x4c, 0x80, 0x11, 0x04, 0x42, 0x15, 0x14, 0x4c,
			0x34, 0x81, 0xe0, 0xe3, 0xc2, 0x1b, 0x22, 0x34, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x18, 0x43, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x20, 0x40, 0x82, 0x40, 0x04, 0x0c, 0x00,
			0x00, 0x20, 0x40, 0x85, 0x42, 0x0e, 0x10, 0x44, 0x7c, 0x20, 0x40, 0x84, 0x82, 0x11, 0x10, 0x38,
			0x08, 0x20, 0x40, 0x80, 0x00, 0x10, 0x3c, 0x28, 0x10, 0xc0, 0x40, 0x60, 0x00, 0x10, 0x10, 0x38,
			0x10, 0x20, 0x40, 0x80, 0x02, 0x11, 0x10, 0x44, 0x20, 0x20, 0x40, 0x80, 0x02, 0x0e, 0x10, 0x00,
			0x7c, 0x20, 0x40, 0x80, 0x02, 0x04, 0x3e, 0x00, 0x00, 0x20, 0x40, 0x80, 0x02, 0x04, 0x00, 0x00,
			0x00, 0x18, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x04, 0x1a, 0x28,
			0x00, 0x00, 0x00, 0x01, 0x02, 0x0a, 0x2c, 0x00, 0x44, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x10,
			0x28, 0x21, 0x20, 0x81, 0x02, 0x04, 0x08, 0x10, 0x10, 0x21, 0x20, 0x81, 0x02, 0x04, 0x08, 0x28,
			0x7c, 0x20, 0xc0, 0x02, 0x85, 0x0a, 0x14, 0x28, 0x10, 0x00, 0x00, 0x02, 0x85, 0x0a, 0x14, 0x28,
			0x7c, 0x20, 0x00, 0x87, 0xcf, 0x9f, 0x3e, 0x7c, 0x10, 0x20, 0x01, 0x04, 0x48, 0x91, 0x22, 0x44,
			0x10, 0x20, 0x02, 0x04, 0x48, 0x91, 0x22, 0x44, 0x00, 0x20, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00, 0x82, 0x0a, 0x10, 0x08,
			0x28, 0x00, 0x00, 0x81, 0x05, 0x00, 0x08, 0x10, 0x28, 0x3c, 0x70, 0x00, 0x00, 0x1f, 0x00, 0x00,
			0x10, 0x30, 0x83, 0xe7, 0xcf, 0x90, 0x3e, 0x7c, 0x10, 0x51, 0x02, 0x04, 0x08, 0x10, 0x08, 0x10,
			0x28, 0x5d, 0x02, 0x04, 0x08, 0x1e, 0x08, 0x10, 0x28, 0x51, 0x03, 0xc7, 0x8f, 0x10, 0x08, 0x10,
			0x7c, 0xf1, 0x02, 0x04, 0x08, 0x10, 0x08, 0x10, 0x44, 0x90, 0x82, 0x04, 0x08, 0x10, 0x08, 0x10,
			0x44, 0x9c, 0x73, 0xe7, 0xcf, 0x9f, 0x3e, 0x7c, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x50, 0x01, 0xa2, 0x01, 0x04, 0x1a, 0x28,
			0x28, 0x00, 0x02, 0xc1, 0x02, 0x0a, 0x2c, 0x00, 0x00, 0xf9, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x38,
			0x7c, 0x21, 0x22, 0x23, 0x87, 0x0e, 0x1c, 0x44, 0x10, 0x21, 0x13, 0x24, 0x48, 0x91, 0x22, 0x44,
			0x10, 0x23, 0x92, 0xa4, 0x48, 0x91, 0x22, 0x44, 0x10, 0x21, 0x12, 0x64, 0x48, 0x91, 0x22, 0x44,
			0x10, 0x21, 0x12, 0x24, 0x48, 0x91, 0x22, 0x44, 0x10, 0x21, 0x22, 0x24, 0x48, 0x91, 0x22, 0x44,
			0x7c, 0xf9, 0xc2, 0x23, 0x87, 0x0e, 0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x41, 0x05, 0x02, 0x00, 0x00,
			0x00, 0x08, 0x40, 0x82, 0x80, 0x04, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x08, 0x91, 0x20, 0x38,
			0x00, 0x99, 0x12, 0x24, 0x48, 0x91, 0x3c, 0x44, 0x44, 0x99, 0x12, 0x24, 0x48, 0x8a, 0x22, 0x48,
			0x28, 0xa9, 0x12, 0x24, 0x48, 0x8a, 0x22, 0x58, 0x10, 0xa9, 0x12, 0x24, 0x48, 0x84, 0x22, 0x44,
			0x28, 0xc9, 0x12, 0x24, 0x48, 0x84, 0x22, 0x44, 0x44, 0xc9, 0x12, 0x24, 0x48, 0x84, 0x3c, 0x44,
			0x00, 0x70, 0xe1, 0xc3, 0x87, 0x04, 0x20, 0x58, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x20, 0x10, 0xa1, 0xa0, 0x04, 0x80, 0x00, 0x20, 0x10, 0x20, 0x02, 0xc2, 0x83, 0x00, 0x00, 0x10,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x70, 0xe1, 0xc3, 0x87, 0x1b, 0x1e, 0x38,
			0x04, 0x08, 0x10, 0x20, 0x40, 0x84, 0xa0, 0x44, 0x3c, 0x78, 0xf1, 0xe3, 0xc7, 0x9f, 0xa0, 0x7c,
			0x44, 0x89, 0x12, 0x24, 0x48, 0xa4, 0x20, 0x40, 0x44, 0x89, 0x12, 0x24, 0x48, 0xa4, 0x20, 0x40,
			0x3c, 0x78, 0xf1, 0xe3, 0xc7, 0x9b, 0x9e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x02, 0x00, 0x12, 0x00,
			0x08, 0x50, 0x01, 0x00, 0x85, 0x00, 0x0c, 0x34, 0x10, 0x00, 0xa0, 0x81, 0x00, 0x0a, 0x3c, 0x58,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x38, 0x70, 0xe3, 0x87, 0x0e, 0x1c, 0x1e, 0x78,
			0x44, 0x89, 0x10, 0x81, 0x02, 0x04, 0x22, 0x44, 0x7c, 0xf9, 0xf0, 0x81, 0x02, 0x04, 0x22, 0x44,
			0x40, 0x81, 0x00, 0x81, 0x02, 0x04, 0x22, 0x44, 0x40, 0x81, 0x00, 0x81, 0x02, 0x04, 0x22, 0x44,
			0x3c, 0x78, 0xf3, 0xe7, 0xcf, 0x9f, 0x1c, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x20, 0x10, 0xa1, 0xa0, 0x00, 0x00, 0x10, 0x08, 0x10, 0x20, 0x02, 0xc2, 0x80, 0x00, 0x08, 0x10,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x38, 0x70, 0xe1, 0xc3, 0x82, 0x0e, 0x22, 0x44,
			0x44, 0x89, 0x12, 0x24, 0x40, 0x13, 0x22, 0x44, 0x44, 0x89, 0x12, 0x24, 0x4f, 0x95, 0x22, 0x44,
			0x44, 0x89, 0x12, 0x24, 0x40, 0x15, 0x22, 0x44, 0x44, 0x89, 0x12, 0x24, 0x42, 0x19, 0x22, 0x44,
			0x38, 0x70, 0xe1, 0xc3, 0x82, 0x0e, 0x1e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x01, 0x02, 0x10, 0x00, 0x00, 0x00, 0x18, 0x10, 0x03, 0x04,
			0x28, 0x00, 0x20, 0x00, 0x1c, 0x08, 0x07, 0x08, 0x00, 0x50, 0x42, 0x02, 0x9e, 0x04, 0x0f, 0x10,
			0x00, 0x00, 0x02, 0x00, 0x1f, 0x02, 0x1f, 0x20, 0x44, 0x89, 0x13, 0xc4, 0x5f, 0x81, 0x3f, 0x40,
			0x44, 0x89, 0x12, 0x24, 0x5f, 0xc0, 0xff, 0x80, 0x44, 0x89, 0x12, 0x24, 0x5f, 0xc0, 0xff, 0x80,
			0x44, 0x89, 0x12, 0x24, 0x5f, 0x81, 0x3f, 0x40, 0x44, 0x89, 0x12, 0x24, 0x5f, 0x02, 0x1f, 0x20,
			0x3c, 0x78, 0xf3, 0xc3, 0xde, 0x04, 0x0f, 0x10, 0x00, 0x00, 0x12, 0x00, 0x5c, 0x08, 0x07, 0x08,
			0x00, 0x00, 0xe2, 0x03, 0x98, 0x10, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x01, 0x02
		],
		64
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(7, 14),
	pixels: ONE
};

/// Tamzen 7x14 Bold Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_7x14_BOLD),
	")"
)]
///
/// Bitmap Size: 2,128 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen7x14b.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_7x14_BOLD: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 64 x 266 (2128)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x63, 0x62, 0x43, 0x00, 0x00, 0x18, 0x18, 0x00, 0xf3, 0x62, 0x43, 0x0c, 0x1c, 0x18, 0x30,
			0x00, 0xf3, 0x67, 0xe7, 0xda, 0xb6, 0x18, 0x30, 0x00, 0x63, 0x67, 0xec, 0x1b, 0x36, 0x18, 0x60,
			0x00, 0x60, 0x02, 0x46, 0x0e, 0x1c, 0x00, 0x60, 0x00, 0x00, 0x02, 0x41, 0x87, 0x37, 0x80, 0x60,
			0x00, 0x00, 0x07, 0xe0, 0xce, 0xb3, 0x00, 0x60, 0x00, 0x60, 0x07, 0xef, 0x96, 0xb3, 0x00, 0x60,
			0x00, 0x60, 0x02, 0x43, 0x03, 0x1f, 0x80, 0x30, 0x00, 0x00, 0x02, 0x43, 0x00, 0x00, 0x00, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x60, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3c, 0x30,
			0x30, 0x00, 0x00, 0x00, 0x00, 0x06, 0x66, 0x70, 0x18, 0xd8, 0xc0, 0x00, 0x00, 0x06, 0x6e, 0xf0,
			0x18, 0x70, 0xc0, 0x00, 0x00, 0x0c, 0x6e, 0x30, 0x19, 0xff, 0xf0, 0x0f, 0xc0, 0x0c, 0x76, 0x30,
			0x18, 0x70, 0xc0, 0x00, 0x00, 0x18, 0x76, 0x30, 0x18, 0xd8, 0xc3, 0x80, 0x0e, 0x18, 0x66, 0x30,
			0x30, 0x00, 0x03, 0x80, 0x0e, 0x30, 0x3c, 0xfc, 0x30, 0x00, 0x01, 0x80, 0x00, 0x30, 0x00, 0x00,
			0x60, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xf8, 0x67, 0xe3, 0x9f, 0x9e, 0x3c, 0x00,
			0xcc, 0x18, 0xe6, 0x06, 0x01, 0xb3, 0x66, 0x70, 0x0c, 0x31, 0x66, 0x0c, 0x03, 0x33, 0x66, 0x70,
			0x18, 0x72, 0x67, 0xcf, 0x83, 0x1e, 0x66, 0x00, 0x30, 0x1b, 0xf0, 0x6c, 0xc6, 0x33, 0x3e, 0x00,
			0x60, 0x18, 0x60, 0x6c, 0xc6, 0x33, 0x06, 0x00, 0xc1, 0x98, 0x66, 0x6c, 0xcc, 0x33, 0x0c, 0x70,
			0xfc, 0xf0, 0x63, 0xc7, 0x8c, 0x1e, 0x38, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xcf, 0x0c, 0x7c, 0x3c,
			0x70, 0x18, 0x06, 0x00, 0xd9, 0x9e, 0x66, 0x60, 0x70, 0x33, 0xf3, 0x01, 0x99, 0xb3, 0x66, 0xc0,
			0x00, 0x60, 0x01, 0x83, 0x1b, 0xb3, 0x7c, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x1b, 0xbf, 0x66, 0xc0,
			0x00, 0x63, 0xf1, 0x80, 0x1b, 0xb3, 0x66, 0xc0, 0x70, 0x30, 0x03, 0x03, 0x18, 0x33, 0x66, 0x60,
			0x70, 0x18, 0x06, 0x03, 0x18, 0x33, 0x7c, 0x3c, 0x30, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00,
			0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 0xfb, 0xf1, 0xec, 0xdf, 0x83, 0x66, 0xc0,
			0xd9, 0x83, 0x03, 0x0c, 0xc6, 0x03, 0x6c, 0xc0, 0xcd, 0x83, 0x06, 0x0c, 0xc6, 0x03, 0x78, 0xc0,
			0xcd, 0xf3, 0xe6, 0x6f, 0xc6, 0x03, 0x70, 0xc0, 0xcd, 0x83, 0x06, 0x6c, 0xc6, 0x03, 0x70, 0xc0,
			0xcd, 0x83, 0x06, 0x6c, 0xc6, 0x33, 0x78, 0xc0, 0xd9, 0x83, 0x03, 0x6c, 0xc6, 0x33, 0x6c, 0xc0,
			0xf1, 0xfb, 0x01, 0xec, 0xdf, 0x9e, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcd, 0x99, 0xe7, 0xc7, 0x9f, 0x1f, 0x7e, 0xcc,
			0xfd, 0xdb, 0x36, 0x6c, 0xd9, 0xb0, 0x18, 0xcc, 0xfd, 0xfb, 0x36, 0x6c, 0xd9, 0xb0, 0x18, 0xcc,
			0xfd, 0xbb, 0x36, 0x6c, 0xd9, 0x9c, 0x18, 0xcc, 0xcd, 0x9b, 0x37, 0xcc, 0xdf, 0x06, 0x18, 0xcc,
			0xcd, 0x9b, 0x36, 0x0c, 0xde, 0x03, 0x18, 0xcc, 0xcd, 0x9b, 0x36, 0x0c, 0xdb, 0x03, 0x18, 0xcc,
			0xcd, 0x99, 0xe6, 0x07, 0x99, 0xbe, 0x18, 0x78, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0f, 0x30, 0x3c, 0x00, 0xcd, 0x9b, 0x36, 0x6f, 0xcc, 0x30, 0x0c, 0x30,
			0xcd, 0x9b, 0x36, 0x61, 0x8c, 0x18, 0x0c, 0x78, 0xcd, 0x99, 0xe6, 0x61, 0x8c, 0x18, 0x0c, 0xcc,
			0xcd, 0x98, 0xc3, 0xc3, 0x0c, 0x0c, 0x0c, 0x00, 0xcd, 0xf8, 0xc1, 0x83, 0x0c, 0x0c, 0x0c, 0x00,
			0xcd, 0xf9, 0xe1, 0x86, 0x0c, 0x06, 0x0c, 0x00, 0x79, 0xfb, 0x31, 0x86, 0x0c, 0x06, 0x0c, 0x00,
			0x31, 0x9b, 0x31, 0x8f, 0xcc, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x03, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0xc0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x06, 0x00, 0x01, 0x80, 0x1e, 0x00,
			0x00, 0x30, 0x06, 0x00, 0x01, 0x80, 0x30, 0x00, 0x00, 0x01, 0xe7, 0xc7, 0xcf, 0x9e, 0x7e, 0x7c,
			0x00, 0x00, 0x36, 0x6c, 0x19, 0xb3, 0x30, 0xcc, 0x00, 0x01, 0xf6, 0x6c, 0x19, 0xbf, 0x30, 0xcc,
			0x00, 0x03, 0x36, 0x6c, 0x19, 0xb0, 0x30, 0xcc, 0x00, 0x03, 0x36, 0x6c, 0x19, 0xb0, 0x30, 0xcc,
			0x00, 0x01, 0xf7, 0xc7, 0xcf, 0x9f, 0x30, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
			0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xc0, 0x60, 0x66, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x60, 0x66, 0x03, 0x00, 0x00, 0x00, 0x00,
			0xc0, 0x00, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xe1, 0xe6, 0xc3, 0x1f, 0x3e, 0x3c, 0xf8,
			0xcc, 0x60, 0x67, 0x83, 0x1a, 0xb3, 0x66, 0xcc, 0xcc, 0x60, 0x67, 0x03, 0x1a, 0xb3, 0x66, 0xcc,
			0xcc, 0x60, 0x67, 0x83, 0x1a, 0xb3, 0x66, 0xcc, 0xcc, 0x60, 0x66, 0xc3, 0x1a, 0xb3, 0x66, 0xcc,
			0xcd, 0xf8, 0x66, 0x61, 0xda, 0xb3, 0x3c, 0xf8, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0xc0,
			0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7d, 0xb9, 0xf7, 0xec, 0xd9, 0xb1, 0x66, 0xcc,
			0xcd, 0xc3, 0x03, 0x0c, 0xd9, 0xb1, 0x3c, 0xcc, 0xcd, 0x81, 0xc3, 0x0c, 0xd9, 0xb5, 0x18, 0xcc,
			0xcd, 0x80, 0xe3, 0x0c, 0xd9, 0xbf, 0x18, 0xcc, 0xcd, 0x80, 0x33, 0x0c, 0xcf, 0x3f, 0x3c, 0xcc,
			0x7d, 0x83, 0xe1, 0xe7, 0xc6, 0x3b, 0x66, 0x7c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
			0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x38, 0xc7, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x60, 0xc1, 0x86, 0x40, 0x06, 0x1c, 0xcc,
			0x00, 0x60, 0xc1, 0x8f, 0xc6, 0x1f, 0x36, 0x78, 0xfc, 0x60, 0xc1, 0x89, 0x86, 0x30, 0x30, 0xcc,
			0x18, 0x60, 0xc1, 0x80, 0x00, 0x30, 0x30, 0xcc, 0x31, 0xc0, 0xc0, 0xe0, 0x00, 0x30, 0x7c, 0xcc,
			0x60, 0x60, 0xc1, 0x80, 0x06, 0x30, 0x30, 0x78, 0xc0, 0x60, 0xc1, 0x80, 0x06, 0x1f, 0x30, 0xcc,
			0xfc, 0x60, 0xc1, 0x80, 0x0f, 0x0c, 0x7e, 0x00, 0x00, 0x60, 0xc1, 0x80, 0x0f, 0x0c, 0x00, 0x00,
			0x00, 0x38, 0x07, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x03, 0x1c, 0x3a, 0xcc,
			0x00, 0x00, 0x00, 0x03, 0x06, 0x36, 0x5c, 0xcc, 0xcc, 0x61, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x78, 0x63, 0x61, 0x83, 0x06, 0x0c, 0x18, 0x30, 0x30, 0x63, 0x61, 0x87, 0x8f, 0x1e, 0x3c, 0x78,
			0xfc, 0x61, 0xc0, 0x0c, 0xd9, 0xb3, 0x66, 0xcc, 0x30, 0x00, 0x00, 0x0c, 0xd9, 0xb3, 0x66, 0xcc,
			0xfc, 0x60, 0x01, 0x8f, 0xdf, 0xbf, 0x7e, 0xfc, 0x30, 0x60, 0x03, 0x0c, 0xd9, 0xb3, 0x66, 0xcc,
			0x30, 0x60, 0x06, 0x0c, 0xd9, 0xb3, 0x66, 0xcc, 0x00, 0x60, 0x06, 0x20, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x03, 0x01, 0x8e, 0x33, 0x30, 0x18,
			0xcc, 0x00, 0x01, 0x83, 0x1b, 0x33, 0x18, 0x30, 0x78, 0x78, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x30, 0xf1, 0x87, 0xef, 0xdf, 0xbf, 0x7e, 0xfc, 0x79, 0xb3, 0x06, 0x0c, 0x18, 0x30, 0x18, 0x30,
			0xcd, 0xb3, 0x06, 0x0c, 0x18, 0x30, 0x18, 0x30, 0xcd, 0xfb, 0x07, 0xcf, 0x9f, 0x3e, 0x18, 0x30,
			0xfd, 0xb3, 0x06, 0x0c, 0x18, 0x30, 0x18, 0x30, 0xcd, 0xb1, 0x86, 0x0c, 0x18, 0x30, 0x18, 0x30,
			0xcd, 0xb8, 0xf7, 0xef, 0xdf, 0xbf, 0x7e, 0xfc, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x98, 0x03, 0xa6, 0x03, 0x1c, 0x3a, 0xcc,
			0xd9, 0x98, 0x05, 0xc3, 0x06, 0x36, 0x5c, 0xcc, 0x00, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xfd, 0xf9, 0xb6, 0x67, 0x8f, 0x1e, 0x3c, 0x78, 0x30, 0x61, 0xb7, 0x6c, 0xd9, 0xb3, 0x66, 0xcc,
			0x30, 0x63, 0xb7, 0xec, 0xd9, 0xb3, 0x66, 0xcc, 0x30, 0x61, 0xb6, 0xec, 0xd9, 0xb3, 0x66, 0xcc,
			0x30, 0x61, 0xb6, 0x6c, 0xd9, 0xb3, 0x66, 0xcc, 0x30, 0x61, 0xa6, 0x6c, 0xd9, 0xb3, 0x66, 0xcc,
			0xfd, 0xfb, 0xc6, 0x67, 0x8f, 0x1e, 0x3c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0xc7, 0x19, 0x86, 0x00, 0x00,
			0x00, 0x10, 0xc1, 0x8d, 0x99, 0x8c, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x60, 0x78,
			0x01, 0x9b, 0x36, 0x6c, 0xd9, 0xb3, 0x7c, 0xcc, 0xcd, 0xbb, 0x36, 0x6c, 0xd9, 0xb3, 0x66, 0xcc,
			0x79, 0xbb, 0x36, 0x6c, 0xd9, 0xb3, 0x66, 0xd8, 0x31, 0xdb, 0x36, 0x6c, 0xd9, 0x9e, 0x66, 0xcc,
			0x79, 0xdb, 0x36, 0x6c, 0xd9, 0x8c, 0x66, 0xcc, 0xcd, 0x9b, 0x36, 0x6c, 0xd9, 0x8c, 0x7c, 0xcc,
			0x00, 0xf1, 0xe3, 0xc7, 0x8f, 0x0c, 0x60, 0xd8, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
			0x60, 0x30, 0xe3, 0xa6, 0xcd, 0x80, 0x00, 0x60, 0x30, 0x61, 0xb5, 0xc6, 0xc7, 0x00, 0x00, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xf1, 0xe3, 0xc7, 0x8f, 0x1a, 0x3e, 0x78,
			0x0c, 0x18, 0x30, 0x60, 0xc1, 0x8d, 0x60, 0xcc, 0x7c, 0xf9, 0xf3, 0xe7, 0xcf, 0x9f, 0x60, 0xfc,
			0xcd, 0x9b, 0x36, 0x6c, 0xd9, 0xac, 0x60, 0xc0, 0xcd, 0x9b, 0x36, 0x6c, 0xd9, 0xac, 0x60, 0xc0,
			0x7c, 0xf9, 0xf3, 0xe7, 0xcf, 0x97, 0x3e, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x00,
			0x18, 0xe3, 0x63, 0x01, 0x8e, 0x36, 0x0c, 0x74, 0x31, 0xb3, 0x61, 0x83, 0x1b, 0x36, 0x3c, 0xb8,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x78, 0xf1, 0xe7, 0x8f, 0x1e, 0x3c, 0x3e, 0xf8,
			0xcd, 0x9b, 0x31, 0x83, 0x06, 0x0c, 0x66, 0xcc, 0xfd, 0xfb, 0xf1, 0x83, 0x06, 0x0c, 0x66, 0xcc,
			0xc1, 0x83, 0x01, 0x83, 0x06, 0x0c, 0x66, 0xcc, 0xc1, 0x83, 0x01, 0x83, 0x06, 0x0c, 0x66, 0xcc,
			0x7c, 0xf9, 0xf7, 0xef, 0xdf, 0xbf, 0x3c, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x60, 0x31, 0xc3, 0xa6, 0xc0, 0x00, 0x30, 0x18, 0x30, 0x63, 0x65, 0xc6, 0xc0, 0x00, 0x18, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x06, 0x02, 0x00, 0x00, 0x78, 0xf1, 0xe3, 0xc7, 0x86, 0x1e, 0x66, 0xcc,
			0xcd, 0x9b, 0x36, 0x6c, 0xc0, 0x33, 0x66, 0xcc, 0xcd, 0x9b, 0x36, 0x6c, 0xdf, 0xb7, 0x66, 0xcc,
			0xcd, 0x9b, 0x36, 0x6c, 0xc0, 0x3b, 0x66, 0xcc, 0xcd, 0x9b, 0x36, 0x6c, 0xc6, 0x33, 0x66, 0xcc,
			0x78, 0xf1, 0xe3, 0xc7, 0x86, 0x1e, 0x3e, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x03, 0x04,
			0x70, 0xd8, 0x60, 0x06, 0xdc, 0x08, 0x07, 0x08, 0xd8, 0xd8, 0xc6, 0x06, 0xde, 0x04, 0x0f, 0x10,
			0x00, 0x00, 0x06, 0x00, 0x1f, 0x02, 0x1f, 0x20, 0xcd, 0x9b, 0x37, 0xcc, 0xdf, 0x81, 0x3f, 0x40,
			0xcd, 0x9b, 0x36, 0x6c, 0xdf, 0xc0, 0xff, 0x80, 0xcd, 0x9b, 0x36, 0x6c, 0xdf, 0xc0, 0xff, 0x80,
			0xcd, 0x9b, 0x36, 0x6c, 0xdf, 0x81, 0x3f, 0x40, 0xcd, 0x9b, 0x36, 0x6c, 0xdf, 0x02, 0x1f, 0x20,
			0x7c, 0xf9, 0xf7, 0xc7, 0xde, 0x04, 0x0f, 0x10, 0x00, 0x00, 0x36, 0x00, 0xdc, 0x08, 0x07, 0x08,
			0x00, 0x01, 0xe6, 0x07, 0x98, 0x10, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x01, 0x02
		],
		64
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(7, 14),
	pixels: ONE
};

/// Tamzen 8x15 Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_8x15),
	")"
)]
///
/// Bitmap Size: 2,640 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen8x15r.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_8x15: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 128 x 165 (2640)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x10, 0x24, 0x00, 0x08, 0x30, 0x30, 0x10, 0x04, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x10, 0x24, 0x24, 0x1e, 0x49, 0x48, 0x10, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
			0x00, 0x10, 0x24, 0x24, 0x20, 0x4a, 0x48, 0x10, 0x08, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04,
			0x00, 0x10, 0x24, 0x7e, 0x20, 0x34, 0x30, 0x10, 0x10, 0x08, 0x24, 0x08, 0x00, 0x00, 0x00, 0x08,
			0x00, 0x10, 0x00, 0x24, 0x1c, 0x08, 0x31, 0x00, 0x10, 0x08, 0x18, 0x08, 0x00, 0x00, 0x00, 0x08,
			0x00, 0x00, 0x00, 0x24, 0x02, 0x16, 0x49, 0x00, 0x10, 0x08, 0x7e, 0x7f, 0x00, 0x7e, 0x00, 0x10,
			0x00, 0x00, 0x00, 0x7e, 0x02, 0x29, 0x46, 0x00, 0x10, 0x08, 0x18, 0x08, 0x00, 0x00, 0x00, 0x10,
			0x00, 0x10, 0x00, 0x24, 0x3c, 0x49, 0x46, 0x00, 0x10, 0x08, 0x24, 0x08, 0x18, 0x00, 0x18, 0x20,
			0x00, 0x10, 0x00, 0x24, 0x08, 0x06, 0x39, 0x00, 0x08, 0x10, 0x00, 0x08, 0x18, 0x00, 0x18, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x20, 0x00, 0x00, 0x08, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
			0x3c, 0x08, 0x3c, 0x7e, 0x04, 0x7e, 0x18, 0x7e, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42,
			0x42, 0x18, 0x42, 0x04, 0x0c, 0x40, 0x20, 0x02, 0x42, 0x42, 0x18, 0x18, 0x04, 0x00, 0x20, 0x04,
			0x46, 0x28, 0x02, 0x08, 0x14, 0x40, 0x40, 0x04, 0x42, 0x42, 0x18, 0x18, 0x08, 0x7e, 0x10, 0x08,
			0x4a, 0x08, 0x04, 0x1c, 0x24, 0x7c, 0x7c, 0x04, 0x3c, 0x42, 0x00, 0x00, 0x10, 0x00, 0x08, 0x10,
			0x52, 0x08, 0x08, 0x02, 0x44, 0x02, 0x42, 0x08, 0x42, 0x3e, 0x00, 0x00, 0x20, 0x00, 0x04, 0x00,
			0x62, 0x08, 0x10, 0x02, 0x7e, 0x02, 0x42, 0x08, 0x42, 0x02, 0x00, 0x00, 0x10, 0x7e, 0x08, 0x00,
			0x42, 0x08, 0x20, 0x42, 0x04, 0x42, 0x42, 0x10, 0x42, 0x04, 0x18, 0x18, 0x08, 0x00, 0x10, 0x10,
			0x3c, 0x3e, 0x7e, 0x3c, 0x04, 0x3c, 0x3c, 0x10, 0x3c, 0x18, 0x18, 0x18, 0x04, 0x00, 0x20, 0x10,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x22, 0x18, 0x7c, 0x1e, 0x78, 0x7e, 0x7e, 0x1e, 0x42, 0x3e, 0x02, 0x42, 0x40, 0x41, 0x42, 0x3c,
			0x41, 0x24, 0x42, 0x20, 0x44, 0x40, 0x40, 0x20, 0x42, 0x08, 0x02, 0x44, 0x40, 0x63, 0x62, 0x42,
			0x4f, 0x42, 0x42, 0x40, 0x42, 0x40, 0x40, 0x40, 0x42, 0x08, 0x02, 0x48, 0x40, 0x55, 0x52, 0x42,
			0x51, 0x42, 0x7c, 0x40, 0x42, 0x7c, 0x7c, 0x40, 0x7e, 0x08, 0x02, 0x70, 0x40, 0x49, 0x4a, 0x42,
			0x51, 0x7e, 0x42, 0x40, 0x42, 0x40, 0x40, 0x46, 0x42, 0x08, 0x02, 0x70, 0x40, 0x49, 0x46, 0x42,
			0x53, 0x42, 0x42, 0x40, 0x42, 0x40, 0x40, 0x42, 0x42, 0x08, 0x42, 0x48, 0x40, 0x41, 0x42, 0x42,
			0x4d, 0x42, 0x42, 0x20, 0x44, 0x40, 0x40, 0x22, 0x42, 0x08, 0x42, 0x44, 0x40, 0x41, 0x42, 0x42,
			0x40, 0x42, 0x7c, 0x1e, 0x78, 0x7e, 0x40, 0x1e, 0x42, 0x3e, 0x3c, 0x42, 0x7e, 0x41, 0x42, 0x3c,
			0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x78, 0x00, 0x00,
			0x7c, 0x3c, 0x7c, 0x3e, 0x7f, 0x42, 0x42, 0x41, 0x42, 0x41, 0x7f, 0x10, 0x40, 0x08, 0x10, 0x00,
			0x42, 0x42, 0x42, 0x40, 0x08, 0x42, 0x42, 0x41, 0x42, 0x41, 0x02, 0x10, 0x40, 0x08, 0x28, 0x00,
			0x42, 0x42, 0x42, 0x40, 0x08, 0x42, 0x42, 0x41, 0x24, 0x22, 0x04, 0x10, 0x20, 0x08, 0x44, 0x00,
			0x42, 0x42, 0x42, 0x30, 0x08, 0x42, 0x42, 0x41, 0x18, 0x14, 0x08, 0x10, 0x20, 0x08, 0x00, 0x00,
			0x7c, 0x42, 0x7c, 0x0c, 0x08, 0x42, 0x24, 0x49, 0x18, 0x08, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00,
			0x40, 0x42, 0x48, 0x02, 0x08, 0x42, 0x24, 0x49, 0x24, 0x08, 0x20, 0x10, 0x10, 0x08, 0x00, 0x00,
			0x40, 0x42, 0x44, 0x02, 0x08, 0x42, 0x18, 0x55, 0x42, 0x08, 0x40, 0x10, 0x08, 0x08, 0x00, 0x00,
			0x40, 0x3c, 0x42, 0x7c, 0x08, 0x3c, 0x18, 0x63, 0x42, 0x08, 0x7f, 0x10, 0x08, 0x08, 0x00, 0x00,
			0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x08, 0x00, 0x00,
			0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x04, 0x78, 0x00, 0xff,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x00, 0x40, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x40, 0x08, 0x04, 0x40, 0x70, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x02, 0x00, 0x10, 0x00, 0x40, 0x08, 0x04, 0x40, 0x10, 0x00, 0x00, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x02, 0x00, 0x10, 0x00, 0x40, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00,
			0x00, 0x3c, 0x5c, 0x3c, 0x3e, 0x3c, 0x7e, 0x3e, 0x5c, 0x38, 0x1c, 0x44, 0x10, 0x76, 0x5c, 0x3c,
			0x00, 0x02, 0x62, 0x42, 0x42, 0x42, 0x10, 0x42, 0x62, 0x08, 0x04, 0x48, 0x10, 0x49, 0x62, 0x42,
			0x00, 0x3e, 0x42, 0x40, 0x42, 0x7e, 0x10, 0x42, 0x42, 0x08, 0x04, 0x50, 0x10, 0x49, 0x42, 0x42,
			0x00, 0x42, 0x42, 0x40, 0x42, 0x40, 0x10, 0x42, 0x42, 0x08, 0x04, 0x68, 0x10, 0x49, 0x42, 0x42,
			0x00, 0x42, 0x42, 0x42, 0x46, 0x40, 0x10, 0x42, 0x42, 0x08, 0x04, 0x44, 0x10, 0x49, 0x42, 0x42,
			0x00, 0x3e, 0x7c, 0x3c, 0x3a, 0x3e, 0x10, 0x3e, 0x42, 0x3e, 0x04, 0x42, 0x0e, 0x49, 0x42, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x60, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x31, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x49, 0x00,
			0x5c, 0x3e, 0x5c, 0x3e, 0x7e, 0x42, 0x42, 0x41, 0x42, 0x42, 0x7e, 0x08, 0x08, 0x10, 0x46, 0x10,
			0x62, 0x42, 0x62, 0x40, 0x10, 0x42, 0x42, 0x49, 0x24, 0x42, 0x04, 0x08, 0x08, 0x10, 0x00, 0x10,
			0x42, 0x42, 0x40, 0x30, 0x10, 0x42, 0x24, 0x49, 0x18, 0x42, 0x08, 0x30, 0x08, 0x0c, 0x00, 0x00,
			0x42, 0x42, 0x40, 0x0c, 0x10, 0x42, 0x24, 0x49, 0x18, 0x42, 0x10, 0x08, 0x08, 0x10, 0x00, 0x00,
			0x42, 0x46, 0x40, 0x02, 0x10, 0x46, 0x18, 0x49, 0x24, 0x46, 0x20, 0x08, 0x08, 0x10, 0x00, 0x10,
			0x7c, 0x3a, 0x40, 0x7c, 0x0e, 0x3a, 0x18, 0x36, 0x42, 0x3a, 0x7e, 0x08, 0x08, 0x10, 0x00, 0x10,
			0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x08, 0x08, 0x10, 0x00, 0x10,
			0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x08, 0x60, 0x00, 0x10,
			0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x04, 0x18, 0x32, 0x24, 0x18, 0x00, 0x00, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x24, 0x4c, 0x24, 0x24, 0x00, 0x00, 0x10,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00,
			0x08, 0x0e, 0x00, 0x41, 0x08, 0x38, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1e, 0x7e,
			0x3e, 0x11, 0x42, 0x22, 0x08, 0x44, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x20, 0x40,
			0x49, 0x10, 0x3c, 0x14, 0x08, 0x44, 0x08, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x28, 0x40, 0x40,
			0x48, 0x7c, 0x24, 0x3e, 0x08, 0x44, 0x08, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x2e, 0x40, 0x7c,
			0x48, 0x10, 0x24, 0x08, 0x00, 0x38, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x28, 0x40, 0x40,
			0x49, 0x10, 0x3c, 0x3e, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x78, 0x40, 0x40,
			0x3e, 0x39, 0x42, 0x08, 0x08, 0x00, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x48, 0x20, 0x40,
			0x08, 0x46, 0x00, 0x08, 0x08, 0x00, 0x10, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x4f, 0x1e, 0x7e,
			0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x04, 0x18, 0x24, 0x10, 0x04, 0x08, 0x14, 0x00, 0x32, 0x10, 0x04, 0x08, 0x19, 0x22, 0x00, 0x00,
			0x08, 0x24, 0x24, 0x08, 0x08, 0x14, 0x14, 0x00, 0x4c, 0x08, 0x08, 0x14, 0x26, 0x22, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
			0x7e, 0x7e, 0x7e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3c, 0x42, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x1e,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x22, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x22,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x21, 0x52, 0x41, 0x41, 0x41, 0x41, 0x41, 0x22, 0x45,
			0x7c, 0x7c, 0x7c, 0x08, 0x08, 0x08, 0x08, 0x79, 0x4a, 0x41, 0x41, 0x41, 0x41, 0x41, 0x14, 0x49,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x21, 0x46, 0x41, 0x41, 0x41, 0x41, 0x41, 0x08, 0x49,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x21, 0x42, 0x41, 0x41, 0x41, 0x41, 0x41, 0x14, 0x51,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x22, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
			0x7e, 0x7e, 0x7e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3c, 0x42, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x20, 0x04, 0x18, 0x24, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
			0x10, 0x08, 0x24, 0x24, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x04, 0x18, 0x32, 0x24, 0x24, 0x00, 0x00, 0x20,
			0x42, 0x42, 0x42, 0x42, 0x41, 0x40, 0x3c, 0x10, 0x08, 0x24, 0x4c, 0x24, 0x18, 0x00, 0x00, 0x10,
			0x42, 0x42, 0x42, 0x42, 0x41, 0x7c, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x22, 0x42, 0x44, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x36, 0x3c, 0x3c,
			0x42, 0x42, 0x42, 0x42, 0x14, 0x42, 0x4c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x09, 0x42, 0x42,
			0x42, 0x42, 0x42, 0x42, 0x08, 0x42, 0x42, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3f, 0x40, 0x7e,
			0x42, 0x42, 0x42, 0x42, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x48, 0x40, 0x40,
			0x42, 0x42, 0x42, 0x42, 0x08, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x48, 0x42, 0x40,
			0x3c, 0x3c, 0x3c, 0x3c, 0x08, 0x40, 0x4c, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x37, 0x3c, 0x3e,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x04, 0x18, 0x24, 0x20, 0x04, 0x18, 0x24, 0x0c, 0x32, 0x20, 0x04, 0x18, 0x32, 0x24, 0x00, 0x00,
			0x08, 0x24, 0x24, 0x10, 0x08, 0x24, 0x24, 0x38, 0x4c, 0x10, 0x08, 0x24, 0x4c, 0x24, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x02,
			0x3c, 0x3c, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x3c,
			0x42, 0x42, 0x42, 0x08, 0x08, 0x08, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x46,
			0x7e, 0x7e, 0x7e, 0x08, 0x08, 0x08, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x4a,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x52,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x18, 0x62,
			0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3c, 0x42, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x20, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x20, 0x04, 0x18, 0x24, 0x04, 0x40, 0x24, 0xf0, 0x10, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x08, 0x24, 0x24, 0x08, 0x40, 0x24, 0xf8, 0x08, 0x1f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xfc, 0x04, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x42, 0xfe, 0x02, 0x7f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xff, 0x01, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xfe, 0x02, 0x7f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xfc, 0x04, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xf8, 0x08, 0x1f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x7c, 0x3e, 0xf0, 0x10, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x40, 0x02, 0xe0, 0x20, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x40, 0x02, 0xc0, 0x40, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x3c, 0x40, 0x3c, 0x80, 0x80, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00
		],
		128
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(8, 15),
	pixels: ONE
};

/// Tamzen 8x15 Bold Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_8x15_BOLD),
	")"
)]
///
/// Bitmap Size: 2,640 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen8x15b.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_8x15_BOLD: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 128 x 165 (2640)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x18, 0x6c, 0x00, 0x18, 0x38, 0x38, 0x18, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x3c, 0x6c, 0x36, 0x3e, 0x6d, 0x6c, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
			0x00, 0x3c, 0x6c, 0x36, 0x60, 0x6e, 0x6c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x06,
			0x00, 0x18, 0x6c, 0x7f, 0x60, 0x3c, 0x38, 0x18, 0x30, 0x0c, 0x36, 0x18, 0x00, 0x00, 0x00, 0x0c,
			0x00, 0x18, 0x00, 0x36, 0x3c, 0x08, 0x39, 0x00, 0x30, 0x0c, 0x1c, 0x18, 0x00, 0x00, 0x00, 0x0c,
			0x00, 0x00, 0x00, 0x36, 0x06, 0x1e, 0x6d, 0x00, 0x30, 0x0c, 0x7f, 0xff, 0x00, 0x7e, 0x00, 0x18,
			0x00, 0x00, 0x00, 0x7f, 0x06, 0x3b, 0x66, 0x00, 0x30, 0x0c, 0x1c, 0x18, 0x00, 0x00, 0x00, 0x18,
			0x00, 0x18, 0x00, 0x36, 0x7c, 0x5b, 0x66, 0x00, 0x30, 0x0c, 0x36, 0x18, 0x38, 0x00, 0x38, 0x30,
			0x00, 0x18, 0x00, 0x36, 0x18, 0x0e, 0x3b, 0x00, 0x18, 0x18, 0x00, 0x18, 0x38, 0x00, 0x38, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x60,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x18, 0x00, 0x00, 0x60,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
			0x3c, 0x18, 0x3c, 0x7e, 0x06, 0x7e, 0x18, 0x7e, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46,
			0x66, 0x38, 0x66, 0x06, 0x0e, 0x60, 0x30, 0x06, 0x66, 0x66, 0x38, 0x38, 0x06, 0x00, 0x60, 0x06,
			0x6e, 0x78, 0x06, 0x0c, 0x1e, 0x60, 0x60, 0x0c, 0x66, 0x66, 0x38, 0x38, 0x0c, 0x7e, 0x30, 0x0c,
			0x6e, 0x18, 0x0c, 0x1c, 0x36, 0x7c, 0x7c, 0x0c, 0x3c, 0x66, 0x00, 0x00, 0x18, 0x00, 0x18, 0x18,
			0x76, 0x18, 0x18, 0x06, 0x66, 0x06, 0x66, 0x18, 0x66, 0x3e, 0x00, 0x00, 0x30, 0x00, 0x0c, 0x00,
			0x76, 0x18, 0x30, 0x06, 0x7f, 0x06, 0x66, 0x18, 0x66, 0x06, 0x00, 0x00, 0x18, 0x7e, 0x18, 0x00,
			0x66, 0x18, 0x60, 0x66, 0x06, 0x66, 0x66, 0x30, 0x66, 0x0c, 0x38, 0x38, 0x0c, 0x00, 0x30, 0x18,
			0x3c, 0x7e, 0x7e, 0x3c, 0x06, 0x3c, 0x3c, 0x30, 0x3c, 0x18, 0x38, 0x38, 0x06, 0x00, 0x60, 0x18,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x63, 0x18, 0x7c, 0x1e, 0x78, 0x7e, 0x7e, 0x1e, 0x66, 0x7e, 0x06, 0x63, 0x60, 0x63, 0x63, 0x3c,
			0x63, 0x3c, 0x66, 0x30, 0x6c, 0x60, 0x60, 0x30, 0x66, 0x18, 0x06, 0x66, 0x60, 0x77, 0x73, 0x66,
			0x6f, 0x66, 0x66, 0x60, 0x66, 0x60, 0x60, 0x60, 0x66, 0x18, 0x06, 0x6c, 0x60, 0x7f, 0x7b, 0x66,
			0x6b, 0x66, 0x7c, 0x60, 0x66, 0x7c, 0x7c, 0x60, 0x7e, 0x18, 0x06, 0x78, 0x60, 0x6b, 0x6f, 0x66,
			0x6b, 0x7e, 0x66, 0x60, 0x66, 0x60, 0x60, 0x66, 0x66, 0x18, 0x06, 0x78, 0x60, 0x63, 0x67, 0x66,
			0x6f, 0x66, 0x66, 0x60, 0x66, 0x60, 0x60, 0x66, 0x66, 0x18, 0x66, 0x6c, 0x60, 0x63, 0x63, 0x66,
			0x60, 0x66, 0x66, 0x30, 0x6c, 0x60, 0x60, 0x36, 0x66, 0x18, 0x66, 0x66, 0x60, 0x63, 0x63, 0x66,
			0x60, 0x66, 0x7c, 0x1e, 0x78, 0x7e, 0x60, 0x1e, 0x66, 0x7e, 0x3c, 0x63, 0x7e, 0x63, 0x63, 0x3c,
			0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x7c, 0x00, 0x00,
			0x7c, 0x3c, 0x7c, 0x3e, 0xff, 0x66, 0x66, 0x63, 0x66, 0x66, 0x7e, 0x30, 0x60, 0x0c, 0x18, 0x00,
			0x66, 0x66, 0x66, 0x60, 0x18, 0x66, 0x66, 0x63, 0x66, 0x66, 0x0c, 0x30, 0x60, 0x0c, 0x3c, 0x00,
			0x66, 0x66, 0x66, 0x60, 0x18, 0x66, 0x66, 0x63, 0x66, 0x66, 0x0c, 0x30, 0x30, 0x0c, 0x66, 0x00,
			0x66, 0x66, 0x66, 0x38, 0x18, 0x66, 0x66, 0x63, 0x3c, 0x3c, 0x18, 0x30, 0x30, 0x0c, 0x00, 0x00,
			0x7c, 0x66, 0x7c, 0x0c, 0x18, 0x66, 0x66, 0x6b, 0x3c, 0x18, 0x18, 0x30, 0x18, 0x0c, 0x00, 0x00,
			0x60, 0x66, 0x6c, 0x06, 0x18, 0x66, 0x66, 0x7f, 0x66, 0x18, 0x30, 0x30, 0x18, 0x0c, 0x00, 0x00,
			0x60, 0x66, 0x66, 0x06, 0x18, 0x66, 0x3c, 0x77, 0x66, 0x18, 0x30, 0x30, 0x0c, 0x0c, 0x00, 0x00,
			0x60, 0x3c, 0x66, 0x7c, 0x18, 0x3c, 0x18, 0x63, 0x66, 0x18, 0x7e, 0x30, 0x0c, 0x0c, 0x00, 0x00,
			0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x06, 0x0c, 0x00, 0x00,
			0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x06, 0x7c, 0x00, 0xff,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x30, 0x00, 0x60, 0x00, 0x06, 0x00, 0x1e, 0x00, 0x60, 0x18, 0x0c, 0x60, 0x78, 0x00, 0x00, 0x00,
			0x18, 0x00, 0x60, 0x00, 0x06, 0x00, 0x30, 0x00, 0x60, 0x18, 0x0c, 0x60, 0x18, 0x00, 0x00, 0x00,
			0x0c, 0x00, 0x60, 0x00, 0x06, 0x00, 0x30, 0x00, 0x60, 0x00, 0x00, 0x60, 0x18, 0x00, 0x00, 0x00,
			0x00, 0x3c, 0x7c, 0x3e, 0x3e, 0x3c, 0x7e, 0x3e, 0x7c, 0x78, 0x3c, 0x6c, 0x18, 0x7e, 0x7c, 0x3c,
			0x00, 0x06, 0x66, 0x60, 0x66, 0x66, 0x30, 0x66, 0x66, 0x18, 0x0c, 0x78, 0x18, 0x6b, 0x66, 0x66,
			0x00, 0x3e, 0x66, 0x60, 0x66, 0x7e, 0x30, 0x66, 0x66, 0x18, 0x0c, 0x70, 0x18, 0x6b, 0x66, 0x66,
			0x00, 0x66, 0x66, 0x60, 0x66, 0x60, 0x30, 0x66, 0x66, 0x18, 0x0c, 0x78, 0x18, 0x6b, 0x66, 0x66,
			0x00, 0x66, 0x66, 0x60, 0x66, 0x60, 0x30, 0x66, 0x66, 0x18, 0x0c, 0x6c, 0x18, 0x6b, 0x66, 0x66,
			0x00, 0x3e, 0x7c, 0x3e, 0x3e, 0x3e, 0x30, 0x3e, 0x66, 0x7e, 0x0c, 0x66, 0x0e, 0x6b, 0x66, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x18, 0x70, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x39, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7f, 0x00,
			0x7c, 0x3e, 0x6e, 0x3e, 0x7e, 0x66, 0x66, 0x6b, 0x63, 0x66, 0x7e, 0x18, 0x18, 0x18, 0x4e, 0x18,
			0x66, 0x66, 0x70, 0x60, 0x30, 0x66, 0x66, 0x6b, 0x36, 0x66, 0x0c, 0x18, 0x18, 0x18, 0x00, 0x18,
			0x66, 0x66, 0x60, 0x38, 0x30, 0x66, 0x66, 0x6b, 0x1c, 0x66, 0x18, 0x70, 0x18, 0x0e, 0x00, 0x00,
			0x66, 0x66, 0x60, 0x1c, 0x30, 0x66, 0x66, 0x6b, 0x1c, 0x66, 0x30, 0x18, 0x18, 0x18, 0x00, 0x00,
			0x66, 0x66, 0x60, 0x06, 0x30, 0x66, 0x3c, 0x6b, 0x36, 0x66, 0x60, 0x18, 0x18, 0x18, 0x00, 0x18,
			0x7c, 0x3e, 0x60, 0x7c, 0x1e, 0x3e, 0x18, 0x7e, 0x63, 0x3e, 0x7e, 0x18, 0x18, 0x18, 0x00, 0x18,
			0x60, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x18, 0x18, 0x18, 0x00, 0x3c,
			0x60, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0e, 0x18, 0x70, 0x00, 0x3c,
			0x60, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x18, 0x32, 0x66, 0x3c, 0x00, 0x00, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x7e, 0x66, 0x66, 0x00, 0x00, 0x18,
			0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x4c, 0x00, 0x66, 0x00, 0x00, 0x00,
			0x0c, 0x1c, 0x63, 0x66, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x3c, 0x1f, 0x1e, 0x7e,
			0x3e, 0x36, 0x3e, 0x66, 0x18, 0x66, 0x00, 0x3c, 0x3c, 0x18, 0x18, 0x3c, 0x3c, 0x3c, 0x30, 0x60,
			0x60, 0x30, 0x36, 0x3c, 0x18, 0x66, 0x18, 0x66, 0x66, 0x3c, 0x3c, 0x66, 0x66, 0x6c, 0x60, 0x60,
			0x60, 0x30, 0x63, 0x7e, 0x18, 0x66, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6f, 0x60, 0x7c,
			0x60, 0x7c, 0x63, 0x18, 0x00, 0x3c, 0x00, 0x7e, 0x7e, 0x66, 0x66, 0x7e, 0x7e, 0x7c, 0x60, 0x60,
			0x60, 0x30, 0x36, 0x7e, 0x00, 0x00, 0x00, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x6c, 0x60, 0x60,
			0x3e, 0x30, 0x3e, 0x18, 0x18, 0x00, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0x30, 0x60,
			0x0c, 0x7e, 0x63, 0x18, 0x18, 0x00, 0x30, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6f, 0x1e, 0x7e,
			0x0c, 0x00, 0x00, 0x00, 0x18, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0c, 0x18, 0x66, 0x30, 0x0c, 0x18, 0x66, 0x00, 0x32, 0x30, 0x06, 0x18, 0x32, 0x66, 0x00, 0x00,
			0x18, 0x3c, 0x66, 0x18, 0x18, 0x3c, 0x66, 0x00, 0x7e, 0x18, 0x0c, 0x3c, 0x7e, 0x66, 0x00, 0x00,
			0x00, 0x66, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x66, 0x4c, 0x00, 0x00, 0x02,
			0x7e, 0x00, 0x7e, 0x7e, 0x7e, 0x00, 0x7e, 0x3c, 0x00, 0x3c, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x1e,
			0x60, 0x7e, 0x60, 0x18, 0x18, 0x7e, 0x18, 0x36, 0x63, 0x66, 0x66, 0x3c, 0x3c, 0x66, 0x00, 0x36,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x33, 0x73, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67,
			0x7c, 0x60, 0x7c, 0x18, 0x18, 0x18, 0x18, 0x7b, 0x7b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x6b,
			0x60, 0x7c, 0x60, 0x18, 0x18, 0x18, 0x18, 0x33, 0x6f, 0x66, 0x66, 0x66, 0x66, 0x66, 0x18, 0x6b,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x33, 0x67, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x73,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x36, 0x63, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x36,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x63, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x30, 0x0c, 0x18, 0x66, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
			0x18, 0x18, 0x3c, 0x66, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x32, 0x00, 0x36, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x3c, 0x7e, 0x66, 0x36, 0x00, 0x00, 0x30,
			0x66, 0x66, 0x00, 0x66, 0x66, 0x60, 0x3c, 0x18, 0x18, 0x66, 0x4c, 0x66, 0x1c, 0x00, 0x00, 0x18,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x76, 0x3e, 0x3c,
			0x66, 0x66, 0x66, 0x66, 0x3c, 0x66, 0x6c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1b, 0x60, 0x66,
			0x66, 0x66, 0x66, 0x66, 0x18, 0x66, 0x66, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x7b, 0x60, 0x7e,
			0x66, 0x66, 0x66, 0x66, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xdf, 0x60, 0x60,
			0x66, 0x66, 0x66, 0x66, 0x18, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xd8, 0x60, 0x60,
			0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x60, 0x6c, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x6f, 0x3e, 0x3e,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1a, 0x32, 0x00, 0x00, 0x18, 0x32, 0x00, 0x00, 0x00,
			0x0c, 0x3c, 0x66, 0x30, 0x0c, 0x3c, 0x66, 0x0c, 0x7e, 0x30, 0x0c, 0x3c, 0x7e, 0x66, 0x00, 0x00,
			0x18, 0x66, 0x66, 0x18, 0x18, 0x66, 0x66, 0x3c, 0x4c, 0x18, 0x18, 0x66, 0x4c, 0x66, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x02,
			0x3c, 0x3c, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3e, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x3e,
			0x66, 0x66, 0x66, 0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x67,
			0x7e, 0x7e, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x6b,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x6b,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x18, 0x73,
			0x3e, 0x3e, 0x3e, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x66, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x3e,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x20, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x30, 0x0c, 0x3c, 0x66, 0x30, 0x60, 0x66, 0xf0, 0x10, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x18, 0x18, 0x66, 0x66, 0x18, 0x60, 0x66, 0xf8, 0x08, 0x1f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xfc, 0x04, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x66, 0xfe, 0x02, 0x7f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0x01, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfe, 0x02, 0x7f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x04, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xf8, 0x08, 0x1f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x7c, 0x3e, 0xf0, 0x10, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x06, 0x60, 0x06, 0xe0, 0x20, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x06, 0x60, 0x06, 0xc0, 0x40, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x3c, 0x80, 0x80, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00
		],
		128
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(8, 15),
	pixels: ONE
};

/// Tamzen 8x16 Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_8x16),
	")"
)]
///
/// Bitmap Size: 2,816 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen8x16r.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_8x16: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 128 x 176 (2816)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x10, 0x24, 0x00, 0x08, 0x00, 0x30, 0x10, 0x04, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
			0x00, 0x10, 0x24, 0x24, 0x08, 0x30, 0x48, 0x10, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
			0x00, 0x10, 0x24, 0x24, 0x1e, 0x49, 0x48, 0x10, 0x08, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04,
			0x00, 0x10, 0x00, 0x7e, 0x20, 0x4a, 0x48, 0x00, 0x10, 0x08, 0x24, 0x08, 0x00, 0x00, 0x00, 0x04,
			0x00, 0x10, 0x00, 0x24, 0x20, 0x34, 0x30, 0x00, 0x10, 0x08, 0x18, 0x08, 0x00, 0x00, 0x00, 0x08,
			0x00, 0x10, 0x00, 0x24, 0x1c, 0x08, 0x31, 0x00, 0x10, 0x08, 0x7e, 0x7f, 0x00, 0x7e, 0x00, 0x08,
			0x00, 0x00, 0x00, 0x24, 0x02, 0x16, 0x49, 0x00, 0x10, 0x08, 0x18, 0x08, 0x00, 0x00, 0x00, 0x10,
			0x00, 0x00, 0x00, 0x7e, 0x02, 0x29, 0x46, 0x00, 0x10, 0x08, 0x24, 0x08, 0x00, 0x00, 0x00, 0x10,
			0x00, 0x10, 0x00, 0x24, 0x3c, 0x49, 0x46, 0x00, 0x10, 0x08, 0x00, 0x08, 0x18, 0x00, 0x18, 0x20,
			0x00, 0x10, 0x00, 0x24, 0x08, 0x06, 0x39, 0x00, 0x08, 0x10, 0x00, 0x00, 0x18, 0x00, 0x18, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x20, 0x00, 0x00, 0x08, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
			0x3c, 0x08, 0x3c, 0x7e, 0x04, 0x7e, 0x1c, 0x7e, 0x3c, 0x3c, 0x00, 0x00, 0x04, 0x00, 0x20, 0x42,
			0x42, 0x18, 0x42, 0x04, 0x0c, 0x40, 0x20, 0x02, 0x42, 0x42, 0x00, 0x00, 0x08, 0x00, 0x10, 0x02,
			0x46, 0x28, 0x02, 0x08, 0x14, 0x40, 0x40, 0x04, 0x42, 0x42, 0x18, 0x18, 0x10, 0x00, 0x08, 0x04,
			0x4a, 0x08, 0x02, 0x1c, 0x24, 0x7c, 0x40, 0x04, 0x42, 0x42, 0x18, 0x18, 0x20, 0x7e, 0x04, 0x08,
			0x52, 0x08, 0x04, 0x02, 0x44, 0x02, 0x7c, 0x08, 0x3c, 0x3e, 0x00, 0x00, 0x40, 0x00, 0x02, 0x10,
			0x62, 0x08, 0x08, 0x02, 0x7e, 0x02, 0x42, 0x08, 0x42, 0x02, 0x00, 0x00, 0x20, 0x00, 0x04, 0x00,
			0x42, 0x08, 0x10, 0x02, 0x04, 0x02, 0x42, 0x10, 0x42, 0x02, 0x00, 0x00, 0x10, 0x7e, 0x08, 0x00,
			0x42, 0x08, 0x20, 0x42, 0x04, 0x42, 0x42, 0x10, 0x42, 0x04, 0x18, 0x18, 0x08, 0x00, 0x10, 0x10,
			0x3c, 0x3e, 0x7e, 0x3c, 0x04, 0x3c, 0x3c, 0x10, 0x3c, 0x38, 0x18, 0x18, 0x04, 0x00, 0x20, 0x10,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x22, 0x18, 0x7c, 0x1e, 0x78, 0x7e, 0x7e, 0x1e, 0x42, 0x3e, 0x02, 0x42, 0x40, 0x41, 0x42, 0x00,
			0x41, 0x24, 0x42, 0x20, 0x44, 0x40, 0x40, 0x20, 0x42, 0x08, 0x02, 0x44, 0x40, 0x63, 0x62, 0x3c,
			0x4f, 0x42, 0x42, 0x40, 0x42, 0x40, 0x40, 0x40, 0x42, 0x08, 0x02, 0x48, 0x40, 0x55, 0x52, 0x42,
			0x51, 0x42, 0x42, 0x40, 0x42, 0x40, 0x40, 0x40, 0x42, 0x08, 0x02, 0x50, 0x40, 0x49, 0x4a, 0x42,
			0x51, 0x42, 0x7c, 0x40, 0x42, 0x7c, 0x7c, 0x46, 0x7e, 0x08, 0x02, 0x60, 0x40, 0x49, 0x46, 0x42,
			0x51, 0x7e, 0x42, 0x40, 0x42, 0x40, 0x40, 0x42, 0x42, 0x08, 0x02, 0x50, 0x40, 0x41, 0x42, 0x42,
			0x53, 0x42, 0x42, 0x40, 0x42, 0x40, 0x40, 0x42, 0x42, 0x08, 0x42, 0x48, 0x40, 0x41, 0x42, 0x42,
			0x4d, 0x42, 0x42, 0x20, 0x44, 0x40, 0x40, 0x22, 0x42, 0x08, 0x42, 0x44, 0x40, 0x41, 0x42, 0x42,
			0x40, 0x42, 0x7c, 0x1e, 0x78, 0x7e, 0x40, 0x1e, 0x42, 0x3e, 0x3c, 0x42, 0x7e, 0x41, 0x42, 0x42,
			0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
			0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x40, 0x78, 0x10, 0x00,
			0x7c, 0x00, 0x7c, 0x3e, 0x7f, 0x42, 0x42, 0x41, 0x41, 0x41, 0x7e, 0x10, 0x40, 0x08, 0x28, 0x00,
			0x42, 0x3c, 0x42, 0x40, 0x08, 0x42, 0x42, 0x41, 0x41, 0x41, 0x04, 0x10, 0x20, 0x08, 0x44, 0x00,
			0x42, 0x42, 0x42, 0x40, 0x08, 0x42, 0x42, 0x41, 0x22, 0x22, 0x08, 0x10, 0x20, 0x08, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x20, 0x08, 0x42, 0x42, 0x41, 0x14, 0x14, 0x08, 0x10, 0x10, 0x08, 0x00, 0x00,
			0x7c, 0x42, 0x7c, 0x18, 0x08, 0x42, 0x42, 0x49, 0x08, 0x08, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00,
			0x40, 0x42, 0x48, 0x04, 0x08, 0x42, 0x24, 0x49, 0x14, 0x08, 0x10, 0x10, 0x08, 0x08, 0x00, 0x00,
			0x40, 0x42, 0x44, 0x02, 0x08, 0x42, 0x24, 0x49, 0x22, 0x08, 0x20, 0x10, 0x08, 0x08, 0x00, 0x00,
			0x40, 0x42, 0x42, 0x02, 0x08, 0x42, 0x18, 0x55, 0x41, 0x08, 0x20, 0x10, 0x04, 0x08, 0x00, 0x00,
			0x40, 0x42, 0x42, 0x7c, 0x08, 0x3c, 0x18, 0x63, 0x41, 0x08, 0x7e, 0x10, 0x04, 0x08, 0x00, 0x00,
			0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x02, 0x08, 0x00, 0x00,
			0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x78, 0x00, 0xff,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x08, 0x04, 0x40, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x02, 0x00, 0x10, 0x00, 0x40, 0x08, 0x04, 0x40, 0x70, 0x00, 0x00, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x02, 0x00, 0x10, 0x00, 0x40, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x40, 0x3c, 0x02, 0x3c, 0x7e, 0x00, 0x40, 0x38, 0x1c, 0x44, 0x10, 0x00, 0x00, 0x3c,
			0x00, 0x3c, 0x5c, 0x42, 0x3a, 0x42, 0x10, 0x3e, 0x5c, 0x08, 0x04, 0x48, 0x10, 0x76, 0x5c, 0x42,
			0x00, 0x02, 0x62, 0x40, 0x46, 0x42, 0x10, 0x44, 0x62, 0x08, 0x04, 0x50, 0x10, 0x49, 0x62, 0x42,
			0x00, 0x02, 0x42, 0x40, 0x42, 0x7e, 0x10, 0x44, 0x42, 0x08, 0x04, 0x70, 0x10, 0x49, 0x42, 0x42,
			0x00, 0x3e, 0x42, 0x40, 0x42, 0x40, 0x10, 0x44, 0x42, 0x08, 0x04, 0x48, 0x10, 0x49, 0x42, 0x42,
			0x00, 0x42, 0x42, 0x42, 0x42, 0x40, 0x10, 0x38, 0x42, 0x08, 0x04, 0x44, 0x10, 0x49, 0x42, 0x42,
			0x00, 0x46, 0x62, 0x3c, 0x46, 0x3e, 0x10, 0x40, 0x42, 0x3e, 0x04, 0x42, 0x10, 0x49, 0x42, 0x3c,
			0x00, 0x3a, 0x5c, 0x00, 0x3a, 0x00, 0x00, 0x3c, 0x42, 0x00, 0x04, 0x00, 0x0e, 0x49, 0x42, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x08, 0x70, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x31, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x49, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x46, 0x00,
			0x00, 0x00, 0x00, 0x3e, 0x7e, 0x00, 0x42, 0x00, 0x41, 0x00, 0x7e, 0x10, 0x08, 0x08, 0x00, 0x10,
			0x5c, 0x3a, 0x5c, 0x40, 0x10, 0x42, 0x42, 0x41, 0x22, 0x42, 0x04, 0x10, 0x08, 0x08, 0x00, 0x10,
			0x62, 0x46, 0x62, 0x20, 0x10, 0x42, 0x42, 0x49, 0x14, 0x42, 0x08, 0xe0, 0x08, 0x07, 0x00, 0x00,
			0x42, 0x42, 0x40, 0x18, 0x10, 0x42, 0x24, 0x49, 0x08, 0x42, 0x10, 0x10, 0x08, 0x08, 0x00, 0x00,
			0x42, 0x42, 0x40, 0x04, 0x10, 0x42, 0x24, 0x49, 0x14, 0x42, 0x20, 0x10, 0x08, 0x08, 0x00, 0x10,
			0x42, 0x42, 0x40, 0x02, 0x10, 0x42, 0x18, 0x49, 0x22, 0x42, 0x40, 0x10, 0x08, 0x08, 0x00, 0x10,
			0x62, 0x46, 0x40, 0x7c, 0x0e, 0x46, 0x18, 0x49, 0x41, 0x46, 0x7e, 0x10, 0x08, 0x08, 0x00, 0x10,
			0x5c, 0x3a, 0x40, 0x00, 0x00, 0x3a, 0x00, 0x36, 0x00, 0x3a, 0x00, 0x10, 0x08, 0x08, 0x00, 0x10,
			0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0e, 0x08, 0x70, 0x00, 0x10,
			0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
			0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x04, 0x18, 0x32, 0x24, 0x18, 0x00, 0x00, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x24, 0x4c, 0x24, 0x24, 0x00, 0x00, 0x10,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00,
			0x08, 0x1c, 0x00, 0x41, 0x08, 0x38, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0f, 0x1e, 0x7e,
			0x1c, 0x22, 0x42, 0x22, 0x08, 0x44, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x14, 0x20, 0x40,
			0x22, 0x20, 0x3c, 0x14, 0x08, 0x44, 0x08, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x14, 0x40, 0x40,
			0x40, 0x20, 0x24, 0x08, 0x08, 0x44, 0x08, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x40, 0x40,
			0x40, 0xf8, 0x24, 0x3e, 0x00, 0x38, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x27, 0x40, 0x7c,
			0x40, 0x20, 0x24, 0x08, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x40, 0x40,
			0x22, 0x20, 0x3c, 0x3e, 0x00, 0x00, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x40, 0x40,
			0x1c, 0x72, 0x42, 0x08, 0x08, 0x00, 0x10, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x20, 0x40,
			0x08, 0x8c, 0x00, 0x08, 0x08, 0x00, 0x20, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x47, 0x1e, 0x7e,
			0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x04, 0x18, 0x24, 0x10, 0x04, 0x18, 0x22, 0x00, 0x32, 0x10, 0x04, 0x18, 0x32, 0x24, 0x00, 0x00,
			0x08, 0x24, 0x24, 0x08, 0x08, 0x24, 0x22, 0x00, 0x4c, 0x08, 0x08, 0x24, 0x4c, 0x24, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
			0x7e, 0x7e, 0x7e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3c, 0x42, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x3c,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x22, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x42,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x21, 0x52, 0x41, 0x41, 0x41, 0x41, 0x41, 0x00, 0x46,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x21, 0x4a, 0x41, 0x41, 0x41, 0x41, 0x41, 0x22, 0x4a,
			0x7c, 0x7c, 0x7c, 0x08, 0x08, 0x08, 0x08, 0x79, 0x46, 0x41, 0x41, 0x41, 0x41, 0x41, 0x14, 0x52,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x21, 0x42, 0x41, 0x41, 0x41, 0x41, 0x41, 0x08, 0x62,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x21, 0x42, 0x41, 0x41, 0x41, 0x41, 0x41, 0x14, 0x42,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x22, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x42,
			0x7e, 0x7e, 0x7e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3c, 0x42, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x20, 0x04, 0x18, 0x24, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
			0x10, 0x08, 0x24, 0x24, 0x08, 0x00, 0x00, 0x00, 0x00, 0x18, 0x32, 0x00, 0x24, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x04, 0x24, 0x4c, 0x24, 0x24, 0x00, 0x00, 0x20,
			0x42, 0x42, 0x42, 0x42, 0x41, 0x40, 0x3c, 0x10, 0x08, 0x00, 0x00, 0x24, 0x18, 0x00, 0x00, 0x10,
			0x42, 0x42, 0x42, 0x42, 0x41, 0x40, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x22, 0x7c, 0x44, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x36, 0x3c, 0x3c,
			0x42, 0x42, 0x42, 0x42, 0x14, 0x42, 0x4c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x09, 0x42, 0x42,
			0x42, 0x42, 0x42, 0x42, 0x08, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x39, 0x40, 0x42,
			0x42, 0x42, 0x42, 0x42, 0x08, 0x42, 0x42, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x4f, 0x40, 0x7e,
			0x42, 0x42, 0x42, 0x42, 0x08, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x48, 0x40, 0x40,
			0x42, 0x42, 0x42, 0x42, 0x08, 0x40, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x48, 0x42, 0x40,
			0x3c, 0x3c, 0x3c, 0x3c, 0x08, 0x40, 0x58, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x37, 0x3c, 0x3e,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x09, 0x32, 0x00, 0x00, 0x18, 0x32, 0x00, 0x00, 0x00,
			0x04, 0x24, 0x24, 0x10, 0x04, 0x24, 0x24, 0x06, 0x4c, 0x10, 0x04, 0x24, 0x4c, 0x24, 0x00, 0x00,
			0x08, 0x00, 0x24, 0x08, 0x08, 0x00, 0x24, 0x1a, 0x00, 0x08, 0x08, 0x00, 0x00, 0x24, 0x18, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x02,
			0x3c, 0x3c, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x1d, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x3c,
			0x42, 0x42, 0x42, 0x08, 0x08, 0x08, 0x08, 0x23, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x46,
			0x42, 0x42, 0x42, 0x08, 0x08, 0x08, 0x08, 0x41, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x4a,
			0x7e, 0x7e, 0x7e, 0x08, 0x08, 0x08, 0x08, 0x41, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x52,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x41, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x62,
			0x40, 0x40, 0x40, 0x08, 0x08, 0x08, 0x08, 0x22, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x18, 0x42,
			0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x1c, 0x42, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x20, 0x04, 0x24, 0x24, 0x04, 0x40, 0x24, 0xc0, 0x40, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x08, 0x00, 0x24, 0x08, 0x40, 0x24, 0xe0, 0x20, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xf0, 0x10, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x5c, 0x42, 0xf8, 0x08, 0x1f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x42, 0xfc, 0x04, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x41, 0x42, 0xfe, 0x02, 0x7f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x41, 0x42, 0xff, 0x01, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x41, 0x42, 0xff, 0x01, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x42, 0xfe, 0x02, 0x7f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x5c, 0x3e, 0xfc, 0x04, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x40, 0x02, 0xf8, 0x08, 0x1f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x40, 0x02, 0xf0, 0x10, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x3c, 0x40, 0x3c, 0xe0, 0x20, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00
		],
		128
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(8, 16),
	pixels: ONE
};

/// Tamzen 8x16 Bold Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_8x16_BOLD),
	")"
)]
///
/// Bitmap Size: 2,816 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen8x16b.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_8x16_BOLD: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 128 x 176 (2816)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x18, 0x6c, 0x00, 0x18, 0x00, 0x38, 0x18, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
			0x00, 0x3c, 0x6c, 0x36, 0x18, 0x38, 0x6c, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
			0x00, 0x3c, 0x6c, 0x36, 0x3e, 0x6d, 0x6c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x06,
			0x00, 0x3c, 0x00, 0x7f, 0x60, 0x6e, 0x6c, 0x00, 0x30, 0x0c, 0x36, 0x18, 0x00, 0x00, 0x00, 0x06,
			0x00, 0x18, 0x00, 0x36, 0x60, 0x3c, 0x38, 0x00, 0x30, 0x0c, 0x1c, 0x18, 0x00, 0x00, 0x00, 0x0c,
			0x00, 0x18, 0x00, 0x36, 0x3c, 0x08, 0x39, 0x00, 0x30, 0x0c, 0x7f, 0xff, 0x00, 0x7e, 0x00, 0x0c,
			0x00, 0x00, 0x00, 0x36, 0x06, 0x1e, 0x6d, 0x00, 0x30, 0x0c, 0x1c, 0x18, 0x00, 0x00, 0x00, 0x18,
			0x00, 0x00, 0x00, 0x7f, 0x06, 0x3b, 0x66, 0x00, 0x30, 0x0c, 0x36, 0x18, 0x00, 0x00, 0x00, 0x18,
			0x00, 0x18, 0x00, 0x36, 0x7c, 0x5b, 0x66, 0x00, 0x30, 0x0c, 0x00, 0x18, 0x1c, 0x00, 0x1c, 0x30,
			0x00, 0x18, 0x00, 0x36, 0x18, 0x0e, 0x3b, 0x00, 0x18, 0x18, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x60,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x60,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
			0x3c, 0x18, 0x3c, 0x7e, 0x06, 0x7e, 0x18, 0x7e, 0x3c, 0x3c, 0x00, 0x00, 0x06, 0x00, 0x60, 0x46,
			0x66, 0x38, 0x66, 0x06, 0x0e, 0x60, 0x30, 0x06, 0x66, 0x66, 0x00, 0x00, 0x0c, 0x00, 0x30, 0x06,
			0x6e, 0x78, 0x06, 0x0c, 0x1e, 0x60, 0x60, 0x0c, 0x66, 0x66, 0x1c, 0x1c, 0x18, 0x00, 0x18, 0x06,
			0x6e, 0x18, 0x06, 0x1c, 0x36, 0x7c, 0x7c, 0x0c, 0x66, 0x66, 0x1c, 0x1c, 0x30, 0x7e, 0x0c, 0x0c,
			0x66, 0x18, 0x0c, 0x06, 0x66, 0x06, 0x66, 0x18, 0x3c, 0x66, 0x00, 0x00, 0x60, 0x00, 0x06, 0x18,
			0x76, 0x18, 0x18, 0x06, 0x7f, 0x06, 0x66, 0x18, 0x66, 0x3e, 0x00, 0x00, 0x30, 0x00, 0x0c, 0x00,
			0x76, 0x18, 0x30, 0x06, 0x06, 0x06, 0x66, 0x30, 0x66, 0x06, 0x00, 0x00, 0x18, 0x7e, 0x18, 0x00,
			0x66, 0x18, 0x60, 0x66, 0x06, 0x66, 0x66, 0x30, 0x66, 0x0c, 0x1c, 0x1c, 0x0c, 0x00, 0x30, 0x18,
			0x3c, 0x7e, 0x7e, 0x3c, 0x06, 0x3c, 0x3c, 0x30, 0x3c, 0x18, 0x1c, 0x1c, 0x06, 0x00, 0x60, 0x18,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x63, 0x18, 0x7c, 0x1e, 0x78, 0x7e, 0x7e, 0x1e, 0x66, 0x7e, 0x06, 0x63, 0x60, 0x63, 0x63, 0x00,
			0x63, 0x3c, 0x66, 0x30, 0x6c, 0x60, 0x60, 0x30, 0x66, 0x18, 0x06, 0x66, 0x60, 0x77, 0x73, 0x3c,
			0x6f, 0x66, 0x66, 0x60, 0x66, 0x60, 0x60, 0x60, 0x66, 0x18, 0x06, 0x6c, 0x60, 0x7f, 0x7b, 0x66,
			0x6b, 0x66, 0x66, 0x60, 0x66, 0x60, 0x60, 0x60, 0x66, 0x18, 0x06, 0x78, 0x60, 0x6b, 0x6f, 0x66,
			0x6b, 0x66, 0x7c, 0x60, 0x66, 0x7c, 0x7c, 0x60, 0x7e, 0x18, 0x06, 0x70, 0x60, 0x63, 0x67, 0x66,
			0x6b, 0x7e, 0x66, 0x60, 0x66, 0x60, 0x60, 0x66, 0x66, 0x18, 0x06, 0x78, 0x60, 0x63, 0x63, 0x66,
			0x6f, 0x66, 0x66, 0x60, 0x66, 0x60, 0x60, 0x66, 0x66, 0x18, 0x66, 0x6c, 0x60, 0x63, 0x63, 0x66,
			0x6f, 0x66, 0x66, 0x30, 0x6c, 0x60, 0x60, 0x36, 0x66, 0x18, 0x66, 0x66, 0x60, 0x63, 0x63, 0x66,
			0x60, 0x66, 0x7c, 0x1e, 0x78, 0x7e, 0x60, 0x1e, 0x66, 0x7e, 0x3c, 0x63, 0x7e, 0x63, 0x63, 0x66,
			0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
			0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0x7c, 0x18, 0x00,
			0x7c, 0x00, 0x7c, 0x3e, 0xff, 0x66, 0x66, 0x63, 0x66, 0x66, 0x7e, 0x30, 0x60, 0x0c, 0x3c, 0x00,
			0x66, 0x3c, 0x66, 0x60, 0x18, 0x66, 0x66, 0x63, 0x66, 0x66, 0x0c, 0x30, 0x30, 0x0c, 0x66, 0x00,
			0x66, 0x66, 0x66, 0x60, 0x18, 0x66, 0x66, 0x63, 0x66, 0x66, 0x0c, 0x30, 0x30, 0x0c, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x70, 0x18, 0x66, 0x66, 0x63, 0x3c, 0x3c, 0x18, 0x30, 0x18, 0x0c, 0x00, 0x00,
			0x7c, 0x66, 0x7c, 0x3c, 0x18, 0x66, 0x66, 0x63, 0x18, 0x18, 0x18, 0x30, 0x18, 0x0c, 0x00, 0x00,
			0x60, 0x66, 0x6c, 0x0e, 0x18, 0x66, 0x66, 0x6b, 0x3c, 0x18, 0x30, 0x30, 0x0c, 0x0c, 0x00, 0x00,
			0x60, 0x66, 0x66, 0x06, 0x18, 0x66, 0x66, 0x7f, 0x66, 0x18, 0x30, 0x30, 0x0c, 0x0c, 0x00, 0x00,
			0x60, 0x66, 0x66, 0x06, 0x18, 0x66, 0x3c, 0x77, 0x66, 0x18, 0x60, 0x30, 0x06, 0x0c, 0x00, 0x00,
			0x60, 0x66, 0x66, 0x7c, 0x18, 0x3c, 0x18, 0x63, 0x66, 0x18, 0x7e, 0x30, 0x06, 0x0c, 0x00, 0x00,
			0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x03, 0x0c, 0x00, 0x00,
			0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x03, 0x7c, 0x00, 0xff,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x18, 0x0c, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x0c, 0x00, 0x60, 0x00, 0x06, 0x00, 0x30, 0x00, 0x60, 0x18, 0x0c, 0x60, 0x78, 0x00, 0x00, 0x00,
			0x06, 0x00, 0x60, 0x00, 0x06, 0x00, 0x30, 0x00, 0x60, 0x00, 0x00, 0x60, 0x18, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x60, 0x3e, 0x06, 0x3c, 0x7e, 0x00, 0x60, 0x78, 0x3c, 0x66, 0x18, 0x00, 0x00, 0x3c,
			0x00, 0x3c, 0x7c, 0x60, 0x3e, 0x66, 0x30, 0x3f, 0x7c, 0x18, 0x0c, 0x6c, 0x18, 0x7e, 0x7c, 0x66,
			0x00, 0x06, 0x66, 0x60, 0x66, 0x66, 0x30, 0x66, 0x66, 0x18, 0x0c, 0x78, 0x18, 0x6b, 0x66, 0x66,
			0x00, 0x06, 0x66, 0x60, 0x66, 0x7e, 0x30, 0x66, 0x66, 0x18, 0x0c, 0x78, 0x18, 0x6b, 0x66, 0x66,
			0x00, 0x3e, 0x66, 0x60, 0x66, 0x60, 0x30, 0x66, 0x66, 0x18, 0x0c, 0x6c, 0x18, 0x6b, 0x66, 0x66,
			0x00, 0x66, 0x66, 0x60, 0x66, 0x60, 0x30, 0x3c, 0x66, 0x18, 0x0c, 0x66, 0x18, 0x6b, 0x66, 0x66,
			0x00, 0x66, 0x66, 0x3e, 0x66, 0x3e, 0x30, 0x60, 0x66, 0x7e, 0x0c, 0x63, 0x18, 0x6b, 0x66, 0x3c,
			0x00, 0x3e, 0x7c, 0x00, 0x3e, 0x00, 0x00, 0x3e, 0x66, 0x00, 0x0c, 0x00, 0x0e, 0x6b, 0x66, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x18, 0x70, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x33, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7b, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x6f, 0x00,
			0x00, 0x00, 0x00, 0x3e, 0x7e, 0x00, 0x66, 0x00, 0x66, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x66, 0x18,
			0x7c, 0x3e, 0x6e, 0x60, 0x30, 0x66, 0x66, 0x6b, 0x66, 0x66, 0x06, 0x18, 0x18, 0x18, 0x00, 0x18,
			0x66, 0x66, 0x70, 0x70, 0x30, 0x66, 0x66, 0x6b, 0x3c, 0x66, 0x0c, 0xf0, 0x18, 0x0f, 0x00, 0x00,
			0x66, 0x66, 0x60, 0x3c, 0x30, 0x66, 0x66, 0x6b, 0x18, 0x66, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
			0x66, 0x66, 0x60, 0x0e, 0x30, 0x66, 0x66, 0x6b, 0x3c, 0x66, 0x30, 0x18, 0x18, 0x18, 0x00, 0x18,
			0x66, 0x66, 0x60, 0x06, 0x30, 0x66, 0x3c, 0x6b, 0x66, 0x66, 0x60, 0x18, 0x18, 0x18, 0x00, 0x18,
			0x66, 0x66, 0x60, 0x7c, 0x1e, 0x66, 0x18, 0x6b, 0x66, 0x66, 0x7e, 0x18, 0x18, 0x18, 0x00, 0x3c,
			0x7c, 0x3e, 0x60, 0x00, 0x00, 0x3e, 0x00, 0x7e, 0x00, 0x3e, 0x00, 0x18, 0x18, 0x18, 0x00, 0x3c,
			0x60, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0e, 0x18, 0x70, 0x00, 0x3c,
			0x60, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
			0x60, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x18, 0x32, 0x66, 0x3c, 0x00, 0x00, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x7e, 0x66, 0x66, 0x00, 0x00, 0x18,
			0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x4c, 0x00, 0x66, 0x00, 0x00, 0x00,
			0x18, 0x1c, 0x00, 0x66, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x3c, 0x1f, 0x1e, 0x7e,
			0x3c, 0x36, 0x63, 0x66, 0x18, 0x66, 0x00, 0x3c, 0x3c, 0x18, 0x18, 0x3c, 0x18, 0x3c, 0x30, 0x60,
			0x66, 0x30, 0x3e, 0x3c, 0x18, 0x66, 0x18, 0x66, 0x66, 0x3c, 0x3c, 0x66, 0x3c, 0x6c, 0x60, 0x60,
			0x60, 0x30, 0x36, 0x18, 0x18, 0x66, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0x60, 0x60,
			0x60, 0x7c, 0x63, 0x7e, 0x00, 0x3c, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6f, 0x60, 0x7c,
			0x60, 0x30, 0x63, 0x18, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7c, 0x60, 0x60,
			0x66, 0x30, 0x36, 0x7e, 0x00, 0x00, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0x60, 0x60,
			0x3c, 0x30, 0x3e, 0x18, 0x18, 0x00, 0x30, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0x30, 0x60,
			0x18, 0x7e, 0x63, 0x18, 0x18, 0x00, 0x60, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6e, 0x1e, 0x7e,
			0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0c, 0x18, 0x66, 0x30, 0x0c, 0x18, 0x66, 0x00, 0x31, 0x30, 0x06, 0x18, 0x32, 0x66, 0x00, 0x00,
			0x18, 0x3c, 0x66, 0x18, 0x18, 0x3c, 0x66, 0x00, 0x7f, 0x18, 0x0c, 0x3c, 0x7e, 0x66, 0x00, 0x00,
			0x00, 0x66, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x46, 0x00, 0x00, 0x66, 0x4c, 0x00, 0x00, 0x06,
			0x7e, 0x00, 0x7e, 0x7e, 0x7e, 0x00, 0x7e, 0x3c, 0x00, 0x3c, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x3c,
			0x60, 0x7e, 0x60, 0x18, 0x18, 0x7e, 0x18, 0x36, 0x63, 0x66, 0x66, 0x3c, 0x3c, 0x66, 0x00, 0x66,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x33, 0x73, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x33, 0x7b, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6e,
			0x7c, 0x7c, 0x7c, 0x18, 0x18, 0x18, 0x18, 0x7b, 0x6f, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x76,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x33, 0x67, 0x66, 0x66, 0x66, 0x66, 0x66, 0x18, 0x66,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x33, 0x63, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x66,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x36, 0x63, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x63, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x30, 0x0c, 0x18, 0x66, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
			0x18, 0x18, 0x3c, 0x66, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x32, 0x00, 0x36, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x3c, 0x7e, 0x66, 0x36, 0x00, 0x00, 0x30,
			0x66, 0x66, 0x00, 0x66, 0x66, 0x60, 0x3c, 0x18, 0x18, 0x66, 0x4c, 0x66, 0x1c, 0x00, 0x00, 0x18,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x76, 0x3e, 0x3c,
			0x66, 0x66, 0x66, 0x66, 0x3c, 0x66, 0x6c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1b, 0x60, 0x66,
			0x66, 0x66, 0x66, 0x66, 0x18, 0x66, 0x66, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x7b, 0x60, 0x66,
			0x66, 0x66, 0x66, 0x66, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xdf, 0x60, 0x7e,
			0x66, 0x66, 0x66, 0x66, 0x18, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xd8, 0x60, 0x60,
			0x66, 0x66, 0x66, 0x66, 0x18, 0x60, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xd8, 0x60, 0x60,
			0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x60, 0x6c, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x6f, 0x3e, 0x3e,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x32, 0x32, 0x00, 0x00, 0x18, 0x32, 0x00, 0x00, 0x00,
			0x0c, 0x3c, 0x66, 0x30, 0x0c, 0x3c, 0x66, 0x1c, 0x7e, 0x0c, 0x0c, 0x3c, 0x7e, 0x66, 0x00, 0x00,
			0x18, 0x66, 0x66, 0x18, 0x18, 0x66, 0x66, 0x78, 0x4c, 0x18, 0x18, 0x66, 0x4c, 0x66, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x06,
			0x3c, 0x3c, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3e, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x18, 0x3c,
			0x66, 0x66, 0x66, 0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66,
			0x66, 0x66, 0x66, 0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x6e,
			0x7e, 0x7e, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x76,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x18, 0x66,
			0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x18, 0x66,
			0x3e, 0x3e, 0x3e, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x66, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x3c,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x30, 0x0c, 0x3c, 0x66, 0x0c, 0x60, 0x66, 0xc0, 0x40, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x18, 0x18, 0x66, 0x66, 0x18, 0x60, 0x66, 0xe0, 0x20, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xf0, 0x10, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x66, 0xf8, 0x08, 0x1f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x04, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfe, 0x02, 0x7f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0x01, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0x01, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xfe, 0x02, 0x7f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x7c, 0x3e, 0xfc, 0x04, 0x3f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x06, 0x60, 0x06, 0xf8, 0x08, 0x1f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x06, 0x60, 0x06, 0xf0, 0x10, 0x0f, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x3c, 0xe0, 0x20, 0x07, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00
		],
		128
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(8, 16),
	pixels: ONE
};

/// Tamzen 10x20 Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_10x20),
	")"
)]
///
/// Bitmap Size: 4,320 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen10x20r.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_10x20: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 192 x 180 (4320)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x02, 0x20, 0x44, 0x08, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x20, 0x44, 0x08, 0x00, 0x03,
			0x00, 0x20, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x02, 0x02, 0x20, 0x44, 0x3e, 0x0c, 0x04, 0x80, 0x20, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x08, 0x3e, 0x02, 0x03, 0xe0, 0x00, 0x02, 0x02, 0x21, 0xfe, 0x41, 0x12, 0x24,
			0x80, 0x20, 0x08, 0x01, 0x00, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x08, 0x41, 0x06, 0x04, 0x10,
			0x00, 0x02, 0x00, 0x00, 0x88, 0x40, 0x12, 0x44, 0x80, 0x00, 0x08, 0x01, 0x04, 0x90, 0x20, 0x00,
			0x00, 0x00, 0x00, 0x10, 0x43, 0x0a, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x88, 0x40, 0x0c, 0x83,
			0x00, 0x00, 0x10, 0x00, 0x82, 0xa0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x10, 0x45, 0x12, 0x00, 0x10,
			0x00, 0x02, 0x00, 0x00, 0x88, 0x3e, 0x01, 0x03, 0x00, 0x00, 0x10, 0x00, 0x81, 0xc1, 0xfc, 0x00,
			0x1f, 0xc0, 0x00, 0x20, 0x49, 0x02, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x88, 0x01, 0x02, 0x04,
			0x90, 0x00, 0x10, 0x00, 0x82, 0xa0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x20, 0x51, 0x02, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x03, 0xfc, 0x01, 0x04, 0xc4, 0x50, 0x00, 0x10, 0x00, 0x84, 0x90, 0x20, 0x00,
			0x00, 0x00, 0x00, 0x40, 0x61, 0x02, 0x00, 0x80, 0x00, 0x00, 0x00, 0x01, 0x10, 0x41, 0x09, 0x24,
			0x20, 0x00, 0x10, 0x00, 0x80, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40, 0x41, 0x02, 0x01, 0x00,
			0x00, 0x02, 0x00, 0x01, 0x10, 0x3e, 0x11, 0x24, 0x50, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x18,
			0x00, 0x01, 0x80, 0x80, 0x41, 0x02, 0x02, 0x00, 0x00, 0x02, 0x00, 0x01, 0x10, 0x08, 0x00, 0xc3,
			0x88, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x01, 0x80, 0x80, 0x3e, 0x1f, 0xc7, 0xf0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x08,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
			0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x7f, 0x00, 0x87, 0xf0, 0x70, 0x7f, 0x0f, 0x83, 0xe0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x41,
			0x10, 0x21, 0xc1, 0xf8, 0x1f, 0x1f, 0x07, 0xf0, 0x02, 0x01, 0x84, 0x00, 0x80, 0x01, 0x10, 0x44,
			0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x01, 0x20, 0x22, 0x21, 0x04, 0x20, 0x10, 0x84, 0x00,
			0x04, 0x02, 0x84, 0x01, 0x00, 0x02, 0x10, 0x44, 0x10, 0x60, 0x18, 0x02, 0x07, 0xf0, 0x20, 0x02,
			0x23, 0xa4, 0x11, 0x04, 0x40, 0x10, 0x44, 0x00, 0x08, 0x04, 0x84, 0x01, 0x00, 0x02, 0x10, 0x44,
			0x10, 0x60, 0x18, 0x04, 0x00, 0x00, 0x10, 0x04, 0x24, 0xa4, 0x11, 0x04, 0x40, 0x10, 0x44, 0x00,
			0x1e, 0x08, 0x87, 0xe1, 0xf8, 0x04, 0x0f, 0x84, 0x10, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x08,
			0x24, 0xa4, 0x11, 0xf8, 0x40, 0x10, 0x47, 0xe0, 0x01, 0x10, 0x80, 0x11, 0x04, 0x04, 0x10, 0x43,
			0xf0, 0x00, 0x00, 0x04, 0x00, 0x00, 0x10, 0x00, 0x24, 0xa7, 0xf1, 0x04, 0x40, 0x10, 0x44, 0x00,
			0x01, 0x1f, 0xc0, 0x11, 0x04, 0x08, 0x10, 0x40, 0x10, 0x00, 0x00, 0x02, 0x07, 0xf0, 0x20, 0x00,
			0x24, 0xa4, 0x11, 0x04, 0x40, 0x10, 0x44, 0x00, 0x01, 0x00, 0x80, 0x11, 0x04, 0x08, 0x10, 0x40,
			0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x23, 0x44, 0x11, 0x04, 0x40, 0x10, 0x44, 0x00,
			0x41, 0x00, 0x84, 0x11, 0x04, 0x10, 0x10, 0x40, 0x20, 0x60, 0x18, 0x00, 0x80, 0x00, 0x80, 0x08,
			0x20, 0x04, 0x11, 0x04, 0x20, 0x10, 0x84, 0x00, 0x3e, 0x00, 0x83, 0xe0, 0xf8, 0x10, 0x0f, 0x81,
			0xc0, 0x60, 0x18, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x04, 0x11, 0xf8, 0x1f, 0x1f, 0x07, 0xf0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x7f, 0x07, 0xc4, 0x11, 0xfc, 0x01, 0x10, 0x44, 0x01, 0x04, 0x41, 0x07, 0x87, 0xe0, 0x78, 0x7e,
			0x0f, 0xcf, 0xf9, 0x04, 0x41, 0x10, 0x44, 0x10, 0x40, 0x08, 0x04, 0x10, 0x20, 0x01, 0x10, 0x84,
			0x01, 0x8c, 0x61, 0x08, 0x44, 0x10, 0x84, 0x41, 0x10, 0x00, 0x81, 0x04, 0x41, 0x10, 0x44, 0x10,
			0x40, 0x10, 0x04, 0x10, 0x20, 0x01, 0x11, 0x04, 0x01, 0x54, 0x51, 0x10, 0x24, 0x11, 0x02, 0x41,
			0x10, 0x00, 0x81, 0x04, 0x41, 0x10, 0x42, 0x20, 0x40, 0x10, 0x04, 0x10, 0x20, 0x01, 0x12, 0x04,
			0x01, 0x24, 0x49, 0x10, 0x24, 0x11, 0x02, 0x41, 0x08, 0x00, 0x81, 0x04, 0x41, 0x10, 0x41, 0x40,
			0x7e, 0x10, 0x07, 0xf0, 0x20, 0x01, 0x1c, 0x04, 0x01, 0x24, 0x45, 0x10, 0x24, 0x11, 0x02, 0x41,
			0x06, 0x00, 0x81, 0x04, 0x22, 0x10, 0x40, 0x80, 0x40, 0x11, 0xc4, 0x10, 0x20, 0x01, 0x1c, 0x04,
			0x01, 0x04, 0x43, 0x10, 0x27, 0xe1, 0x02, 0x7e, 0x01, 0x00, 0x81, 0x04, 0x22, 0x12, 0x40, 0x80,
			0x40, 0x10, 0x44, 0x10, 0x20, 0x01, 0x12, 0x04, 0x01, 0x04, 0x41, 0x10, 0x24, 0x01, 0x02, 0x48,
			0x00, 0x80, 0x81, 0x04, 0x14, 0x12, 0x41, 0x40, 0x40, 0x10, 0x44, 0x10, 0x20, 0x41, 0x11, 0x04,
			0x01, 0x04, 0x41, 0x10, 0x24, 0x01, 0x02, 0x44, 0x00, 0x40, 0x81, 0x04, 0x14, 0x12, 0x42, 0x20,
			0x40, 0x08, 0x44, 0x10, 0x20, 0x41, 0x10, 0x84, 0x01, 0x04, 0x41, 0x08, 0x44, 0x00, 0x84, 0x42,
			0x00, 0x40, 0x81, 0x04, 0x08, 0x15, 0x44, 0x10, 0x40, 0x07, 0xc4, 0x11, 0xfc, 0x3e, 0x10, 0x47,
			0xf1, 0x04, 0x41, 0x07, 0x84, 0x00, 0x78, 0x41, 0x1f, 0x80, 0x80, 0xf8, 0x08, 0x18, 0xc4, 0x10,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x03, 0xc0, 0x00, 0x00, 0x08, 0x01, 0x04, 0x00, 0x00, 0x00, 0x03, 0xe1, 0x00, 0x3e, 0x02, 0x00,
			0x00, 0x40, 0x00, 0x10, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x01, 0x00, 0x08, 0x01, 0x04, 0x00,
			0x41, 0x1f, 0xc2, 0x00, 0x80, 0x02, 0x05, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, 0x00, 0x04, 0x00,
			0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x22, 0x00, 0x82, 0x00, 0x80, 0x02, 0x08, 0x80,
			0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00,
			0x22, 0x01, 0x02, 0x00, 0x40, 0x02, 0x10, 0x40, 0x00, 0x00, 0x3e, 0x17, 0x01, 0xe0, 0x7c, 0x1e,
			0x1f, 0xc1, 0xc9, 0x38, 0x78, 0x0f, 0x04, 0x20, 0x14, 0x01, 0x02, 0x00, 0x40, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x18, 0x82, 0x10, 0x84, 0x21, 0x04, 0x02, 0x31, 0x44, 0x08, 0x01, 0x04, 0x40,
			0x14, 0x02, 0x02, 0x00, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x44, 0x01, 0x04, 0x41,
			0x04, 0x04, 0x11, 0x84, 0x08, 0x01, 0x04, 0x80, 0x08, 0x02, 0x02, 0x00, 0x20, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x3f, 0x10, 0x44, 0x01, 0x04, 0x7f, 0x04, 0x04, 0x11, 0x04, 0x08, 0x01, 0x05, 0x00,
			0x08, 0x04, 0x02, 0x00, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x41, 0x10, 0x44, 0x01, 0x04, 0x40,
			0x04, 0x02, 0x21, 0x04, 0x08, 0x01, 0x06, 0x80, 0x08, 0x04, 0x02, 0x00, 0x10, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x41, 0x10, 0x44, 0x01, 0x04, 0x40, 0x04, 0x01, 0xc1, 0x04, 0x08, 0x01, 0x04, 0x40,
			0x08, 0x08, 0x02, 0x00, 0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x43, 0x10, 0x82, 0x10, 0x8c, 0x20,
			0x04, 0x02, 0x01, 0x04, 0x08, 0x01, 0x04, 0x20, 0x08, 0x1f, 0xc2, 0x00, 0x08, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x3d, 0x1f, 0x01, 0xe0, 0x74, 0x1f, 0x04, 0x03, 0xe1, 0x04, 0x7f, 0x01, 0x04, 0x10,
			0x00, 0x00, 0x02, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x04, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x03, 0xe0, 0x00, 0x3e, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x03, 0xe0, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x02, 0x03, 0x08,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x10, 0x08, 0x02, 0x04, 0x88, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x02, 0x04, 0x48,
			0x08, 0x2c, 0xc4, 0xe0, 0x70, 0x5c, 0x07, 0xc4, 0xe0, 0xfc, 0x7f, 0x10, 0x44, 0x12, 0x02, 0x40,
			0x90, 0x47, 0xf0, 0x10, 0x08, 0x02, 0x04, 0x30, 0x08, 0x33, 0x25, 0x10, 0x88, 0x62, 0x08, 0x45,
			0x11, 0x00, 0x10, 0x10, 0x44, 0x12, 0x02, 0x21, 0x10, 0x40, 0x20, 0x10, 0x08, 0x02, 0x00, 0x00,
			0x08, 0x22, 0x26, 0x11, 0x04, 0x41, 0x10, 0x46, 0x00, 0x80, 0x10, 0x10, 0x42, 0x22, 0x22, 0x12,
			0x10, 0x40, 0x40, 0x20, 0x08, 0x01, 0x00, 0x00, 0x08, 0x22, 0x24, 0x11, 0x04, 0x41, 0x10, 0x44,
			0x00, 0x60, 0x10, 0x10, 0x42, 0x22, 0x22, 0x0c, 0x10, 0x40, 0x81, 0xc0, 0x08, 0x00, 0xe0, 0x00,
			0x08, 0x22, 0x24, 0x11, 0x04, 0x41, 0x10, 0x44, 0x00, 0x10, 0x10, 0x10, 0x41, 0x42, 0x22, 0x0c,
			0x10, 0x41, 0x00, 0x20, 0x08, 0x01, 0x00, 0x00, 0x08, 0x22, 0x24, 0x11, 0x04, 0x41, 0x10, 0x44,
			0x00, 0x08, 0x10, 0x10, 0xc1, 0x42, 0x22, 0x12, 0x08, 0xc2, 0x00, 0x10, 0x08, 0x02, 0x00, 0x00,
			0x08, 0x22, 0x24, 0x10, 0x88, 0x42, 0x08, 0xc4, 0x00, 0x04, 0x10, 0x11, 0x40, 0x82, 0x22, 0x21,
			0x07, 0x44, 0x00, 0x10, 0x08, 0x02, 0x00, 0x00, 0x07, 0x22, 0x24, 0x10, 0x70, 0x7c, 0x07, 0x44,
			0x01, 0xf8, 0x0f, 0x0e, 0x40, 0x81, 0xdc, 0x40, 0x80, 0x47, 0xf0, 0x10, 0x08, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x40, 0x00, 0x10, 0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x10, 0x08, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0f, 0x00, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x80, 0x80, 0xc4, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x10, 0x01, 0x01, 0x41, 0x24, 0x22, 0x02, 0x00, 0x00, 0x00, 0x10, 0x01, 0x01, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x02, 0x02, 0x21, 0x18, 0x22,
			0x05, 0x00, 0x00, 0x00, 0x08, 0x02, 0x02, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x02, 0x00, 0xe1, 0x01, 0x41, 0x02, 0x01, 0xc0, 0x00, 0x08, 0x02, 0x00, 0x80, 0x20, 0x08,
			0x02, 0x00, 0xf8, 0x7c, 0x7f, 0x1f, 0xc7, 0xf0, 0x00, 0x07, 0x81, 0x10, 0xba, 0x22, 0x02, 0x02,
			0x20, 0x00, 0x08, 0x02, 0x00, 0x80, 0x20, 0x08, 0x02, 0x00, 0xc0, 0x80, 0x40, 0x10, 0x04, 0x00,
			0x08, 0x0a, 0x41, 0x00, 0x44, 0x14, 0x02, 0x02, 0x20, 0x20, 0x14, 0x05, 0x01, 0x40, 0x50, 0x14,
			0x05, 0x01, 0x41, 0x00, 0x40, 0x10, 0x04, 0x00, 0x08, 0x12, 0x01, 0x00, 0x82, 0x08, 0x02, 0x02,
			0x20, 0x20, 0x14, 0x05, 0x01, 0x40, 0x50, 0x14, 0x05, 0x01, 0x41, 0x00, 0x40, 0x10, 0x04, 0x00,
			0x00, 0x12, 0x07, 0xe0, 0x82, 0x3e, 0x00, 0x01, 0xc0, 0x00, 0x22, 0x08, 0x82, 0x20, 0x88, 0x22,
			0x08, 0x82, 0x79, 0x00, 0x7e, 0x1f, 0x87, 0xe0, 0x00, 0x12, 0x01, 0x00, 0x82, 0x08, 0x00, 0x00,
			0x00, 0x00, 0x22, 0x08, 0x82, 0x20, 0x88, 0x22, 0x08, 0x82, 0x41, 0x00, 0x40, 0x10, 0x04, 0x00,
			0x00, 0x12, 0x01, 0x00, 0x44, 0x08, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x0f, 0x83, 0xe0, 0xf8, 0x3e,
			0x0f, 0x83, 0xc1, 0x00, 0x40, 0x10, 0x04, 0x00, 0x08, 0x0a, 0x41, 0x00, 0xba, 0x3e, 0x02, 0x00,
			0x00, 0x20, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x44, 0x41, 0x00, 0x40, 0x10, 0x04, 0x00,
			0x08, 0x07, 0x83, 0x91, 0x01, 0x08, 0x02, 0x00, 0x00, 0x40, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41,
			0x10, 0x44, 0x40, 0x80, 0x40, 0x10, 0x04, 0x00, 0x08, 0x02, 0x04, 0x60, 0x00, 0x08, 0x02, 0x00,
			0x00, 0x80, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x44, 0x78, 0x7c, 0x7f, 0x1f, 0xc7, 0xf0,
			0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
			0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x08, 0x00, 0x20, 0x20, 0x00, 0x00, 0x03, 0x10, 0x80, 0x02, 0x02, 0x03, 0x10, 0x88, 0x00,
			0x00, 0x02, 0x00, 0x08, 0x08, 0x00, 0x00, 0x20, 0x22, 0x04, 0x00, 0x40, 0x50, 0x22, 0x00, 0x04,
			0x90, 0x40, 0x04, 0x05, 0x04, 0x90, 0x88, 0x00, 0x00, 0x01, 0x00, 0x10, 0x14, 0x08, 0x80, 0x40,
			0x22, 0x02, 0x00, 0x80, 0x88, 0x22, 0x00, 0x04, 0x60, 0x20, 0x08, 0x08, 0x84, 0x60, 0x00, 0x00,
			0x00, 0x00, 0x80, 0x20, 0x22, 0x08, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x7f, 0x1f, 0xc7, 0xf1, 0xfc, 0x7f, 0x0f, 0x84, 0x10, 0x70, 0x1c, 0x07, 0x01, 0xc0, 0x70, 0x00,
			0x07, 0x84, 0x11, 0x04, 0x41, 0x10, 0x44, 0x10, 0x40, 0x02, 0x00, 0x80, 0x20, 0x08, 0x08, 0x46,
			0x10, 0x88, 0x22, 0x08, 0x82, 0x20, 0x88, 0x00, 0x08, 0x84, 0x11, 0x04, 0x41, 0x10, 0x42, 0x20,
			0x40, 0x02, 0x00, 0x80, 0x20, 0x08, 0x08, 0x25, 0x11, 0x04, 0x41, 0x10, 0x44, 0x11, 0x04, 0x00,
			0x11, 0x44, 0x11, 0x04, 0x41, 0x10, 0x42, 0x20, 0x40, 0x02, 0x00, 0x80, 0x20, 0x08, 0x08, 0x24,
			0x91, 0x04, 0x41, 0x10, 0x44, 0x11, 0x04, 0x21, 0x11, 0x44, 0x11, 0x04, 0x41, 0x10, 0x41, 0x40,
			0x7e, 0x02, 0x00, 0x80, 0x20, 0x08, 0x1e, 0x24, 0x51, 0x04, 0x41, 0x10, 0x44, 0x11, 0x04, 0x12,
			0x12, 0x44, 0x11, 0x04, 0x41, 0x10, 0x41, 0x40, 0x40, 0x02, 0x00, 0x80, 0x20, 0x08, 0x08, 0x24,
			0x31, 0x04, 0x41, 0x10, 0x44, 0x11, 0x04, 0x0c, 0x12, 0x44, 0x11, 0x04, 0x41, 0x10, 0x40, 0x80,
			0x40, 0x02, 0x00, 0x80, 0x20, 0x08, 0x08, 0x24, 0x11, 0x04, 0x41, 0x10, 0x44, 0x11, 0x04, 0x0c,
			0x14, 0x44, 0x11, 0x04, 0x41, 0x10, 0x40, 0x80, 0x40, 0x02, 0x00, 0x80, 0x20, 0x08, 0x08, 0x24,
			0x11, 0x04, 0x41, 0x10, 0x44, 0x11, 0x04, 0x12, 0x14, 0x44, 0x11, 0x04, 0x41, 0x10, 0x40, 0x80,
			0x40, 0x02, 0x00, 0x80, 0x20, 0x08, 0x08, 0x44, 0x10, 0x88, 0x22, 0x08, 0x82, 0x20, 0x88, 0x21,
			0x08, 0x82, 0x20, 0x88, 0x22, 0x08, 0x80, 0x80, 0x7f, 0x1f, 0xc7, 0xf1, 0xfc, 0x7f, 0x0f, 0x84,
			0x10, 0x70, 0x1c, 0x07, 0x01, 0xc0, 0x70, 0x00, 0x0f, 0x01, 0xc0, 0x70, 0x1c, 0x07, 0x00, 0x80,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x08, 0x08, 0x0c, 0x40,
			0x00, 0x30, 0x00, 0x00, 0x02, 0x00, 0x04, 0x08, 0x00, 0x02, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x10, 0x14, 0x12, 0x42, 0x20, 0x48, 0x00, 0x00, 0x01, 0x00, 0x08, 0x14,
			0x08, 0x81, 0x00, 0x10, 0x14, 0x08, 0x80, 0x90, 0x00, 0x00, 0x00, 0x80, 0x20, 0x22, 0x11, 0x82,
			0x20, 0x48, 0x00, 0x00, 0x00, 0x80, 0x10, 0x22, 0x08, 0x80, 0x80, 0x20, 0x22, 0x08, 0x80, 0x60,
			0x40, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xa0, 0x40, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
			0x7e, 0x10, 0x43, 0xe0, 0xf8, 0x3e, 0x0f, 0x83, 0xe0, 0xf8, 0x77, 0x0f, 0x83, 0xe0, 0xf8, 0x3e,
			0x0f, 0x87, 0x81, 0xe0, 0x78, 0x1e, 0x01, 0xd0, 0x41, 0x10, 0x80, 0x10, 0x04, 0x01, 0x00, 0x40,
			0x10, 0x04, 0x08, 0x90, 0x44, 0x11, 0x04, 0x41, 0x10, 0x40, 0x80, 0x20, 0x08, 0x02, 0x02, 0x30,
			0x41, 0x11, 0x80, 0x10, 0x04, 0x01, 0x00, 0x40, 0x10, 0x04, 0x08, 0x90, 0x04, 0x11, 0x04, 0x41,
			0x10, 0x40, 0x80, 0x20, 0x08, 0x02, 0x04, 0x10, 0x41, 0x10, 0x43, 0xf0, 0xfc, 0x3f, 0x0f, 0xc3,
			0xf0, 0xfc, 0x7f, 0x90, 0x07, 0xf1, 0xfc, 0x7f, 0x1f, 0xc0, 0x80, 0x20, 0x08, 0x02, 0x04, 0x10,
			0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x44, 0x11, 0x04, 0x88, 0x10, 0x04, 0x01, 0x00, 0x40,
			0x10, 0x00, 0x80, 0x20, 0x08, 0x02, 0x04, 0x10, 0x7e, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x44,
			0x11, 0x04, 0x88, 0x10, 0x04, 0x01, 0x00, 0x40, 0x10, 0x00, 0x80, 0x20, 0x08, 0x02, 0x04, 0x10,
			0x40, 0x10, 0x84, 0x11, 0x04, 0x41, 0x10, 0x44, 0x11, 0x04, 0x88, 0x10, 0x44, 0x01, 0x00, 0x40,
			0x10, 0x00, 0x80, 0x20, 0x08, 0x02, 0x02, 0x20, 0x40, 0x13, 0x03, 0xf0, 0xfc, 0x3f, 0x0f, 0xc3,
			0xf0, 0xfc, 0x77, 0x8f, 0x83, 0xf0, 0xfc, 0x3f, 0x0f, 0xc7, 0xf1, 0xfc, 0x7f, 0x1f, 0xc1, 0xc0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x02, 0x00, 0x80, 0x00, 0x10, 0x04, 0x31, 0x08, 0x00, 0x20, 0x20, 0x31, 0x00, 0x00,
			0x00, 0x00, 0x20, 0x00, 0x80, 0x80, 0x00, 0x02, 0x00, 0x00, 0x03, 0x00, 0x40, 0x00, 0x30, 0x08,
			0x49, 0x04, 0x00, 0x40, 0x50, 0x49, 0x08, 0x80, 0x00, 0x00, 0x10, 0x01, 0x01, 0x40, 0x88, 0x04,
			0x00, 0x02, 0x23, 0x80, 0x20, 0x00, 0x70, 0x10, 0x46, 0x02, 0x00, 0x80, 0x88, 0x46, 0x08, 0x80,
			0x00, 0x00, 0x08, 0x02, 0x02, 0x20, 0x88, 0x08, 0x10, 0x02, 0x23, 0xc0, 0x10, 0x00, 0xf0, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x10, 0x00, 0x03, 0xe0, 0x08, 0x01, 0xf0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x80, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x03, 0xf0, 0x04, 0x03, 0xf0, 0x80,
			0x7e, 0x0f, 0x83, 0xe0, 0xf8, 0x3e, 0x0f, 0x80, 0x00, 0xf8, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41,
			0x17, 0x04, 0x13, 0xf8, 0x02, 0x07, 0xf1, 0x00, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x40,
			0x01, 0x14, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x18, 0x84, 0x13, 0xfc, 0x01, 0x0f, 0xf2, 0x00,
			0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x47, 0xf1, 0x14, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41,
			0x10, 0x44, 0x13, 0xfe, 0x00, 0x9f, 0xf4, 0x00, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x40,
			0x01, 0x24, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x44, 0x13, 0xff, 0x00, 0x7f, 0xf8, 0x00,
			0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x40, 0x01, 0x24, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41,
			0x10, 0x44, 0x13, 0xff, 0x00, 0x7f, 0xf8, 0x00, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x40,
			0x81, 0x44, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x44, 0x13, 0xfe, 0x00, 0x9f, 0xf4, 0x00,
			0x41, 0x10, 0x44, 0x11, 0x04, 0x41, 0x10, 0x40, 0x81, 0x44, 0x41, 0x10, 0x44, 0x11, 0x04, 0x41,
			0x18, 0x84, 0x13, 0xfc, 0x01, 0x0f, 0xf2, 0x00, 0x41, 0x0f, 0x83, 0xe0, 0xf8, 0x3e, 0x0f, 0x80,
			0x00, 0xf8, 0x3f, 0x0f, 0xc3, 0xf0, 0xfc, 0x3f, 0x17, 0x03, 0xf3, 0xf8, 0x02, 0x07, 0xf1, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
			0x10, 0x00, 0x13, 0xf0, 0x04, 0x03, 0xf0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00, 0x13, 0xe0, 0x08, 0x01, 0xf0, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
			0x10, 0x00, 0x13, 0xc0, 0x10, 0x00, 0xf0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x03, 0xe3, 0x80, 0x20, 0x00, 0x70, 0x10,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x00, 0x40, 0x00, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x80, 0x00, 0x10, 0x04
		],
		192
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(10, 20),
	pixels: ONE
};

/// Tamzen 10x20 Bold Font.
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_10x20_BOLD),
	")"
)]
///
/// Bitmap Size: 4,320 Byte <br/>
/// Font Source: <https://github.com/sunaku/tamzen-font/blob/master/bdf/Tamzen10x20b.bdf> <br/>
/// Font License: <https://github.com/sunaku/tamzen-font/blob/master/LICENSE>
#[allow(non_upper_case_globals)]
pub const FONT_10x20_BOLD: BitmapFont<'static> = BitmapFont {
	bitmap: ImageRaw::new_binary(
		// 192 x 180 (4320)
		&[
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x06, 0x60, 0x66, 0x0c, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x60, 0x66, 0x0c, 0x00, 0x07,
			0x00, 0x60, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x0f, 0x06, 0x60, 0x66, 0x3e, 0x1c, 0x0d, 0x80, 0x60, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x0c, 0x3e, 0x03, 0x03, 0xe0, 0x00, 0x0f, 0x06, 0x61, 0xff, 0x63, 0x36, 0x6d,
			0x80, 0x60, 0x18, 0x03, 0x00, 0xc0, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x63, 0x07, 0x06, 0x30,
			0x00, 0x0f, 0x00, 0x00, 0xcc, 0x60, 0x36, 0xcd, 0x80, 0x00, 0x18, 0x03, 0x06, 0xd8, 0x30, 0x00,
			0x00, 0x00, 0x00, 0x18, 0x63, 0x0f, 0x00, 0x30, 0x00, 0x06, 0x00, 0x00, 0xcc, 0x60, 0x1d, 0x87,
			0x00, 0x00, 0x30, 0x01, 0x83, 0xf0, 0x30, 0x00, 0x00, 0x00, 0x00, 0x18, 0x67, 0x1b, 0x00, 0x30,
			0x00, 0x06, 0x00, 0x00, 0xcc, 0x3e, 0x03, 0x07, 0x00, 0x00, 0x30, 0x01, 0x81, 0xe1, 0xfe, 0x00,
			0x1f, 0xe0, 0x00, 0x30, 0x6f, 0x03, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x03, 0x06, 0x0d,
			0xb0, 0x00, 0x30, 0x01, 0x83, 0xf0, 0x30, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7b, 0x03, 0x00, 0xc0,
			0x00, 0x00, 0x00, 0x03, 0xfe, 0x03, 0x0d, 0xcc, 0xf0, 0x00, 0x30, 0x01, 0x86, 0xd8, 0x30, 0x00,
			0x00, 0x00, 0x00, 0x60, 0x73, 0x03, 0x01, 0x80, 0x00, 0x00, 0x00, 0x01, 0x98, 0x63, 0x1b, 0x6c,
			0x60, 0x00, 0x30, 0x01, 0x80, 0xc0, 0x30, 0x00, 0x00, 0x00, 0x00, 0x60, 0x63, 0x03, 0x03, 0x00,
			0x00, 0x06, 0x00, 0x01, 0x98, 0x3e, 0x33, 0x6c, 0xf0, 0x00, 0x30, 0x01, 0x80, 0x00, 0x00, 0x1c,
			0x00, 0x01, 0xc0, 0xc0, 0x63, 0x03, 0x06, 0x00, 0x00, 0x06, 0x00, 0x01, 0x98, 0x18, 0x01, 0xc7,
			0x98, 0x00, 0x18, 0x03, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x01, 0xc0, 0xc0, 0x3e, 0x1f, 0xe7, 0xf0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x00, 0x00, 0x0c,
			0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
			0x00, 0x00, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x38,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x18, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x7f, 0x00, 0xc7, 0xf0, 0x70, 0x7f, 0x0f, 0x83, 0xe0, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x80, 0x61,
			0xb0, 0x61, 0xc1, 0xf8, 0x1f, 0x1f, 0x07, 0xf0, 0x03, 0x01, 0xc6, 0x00, 0xc0, 0x03, 0x18, 0xc6,
			0x30, 0x00, 0x00, 0x01, 0x80, 0x00, 0xc0, 0x01, 0xb0, 0x63, 0xe1, 0x8c, 0x30, 0x19, 0x86, 0x00,
			0x06, 0x03, 0xc6, 0x01, 0x80, 0x06, 0x18, 0xc6, 0x30, 0x70, 0x1c, 0x03, 0x07, 0xf0, 0x60, 0x03,
			0x33, 0xe6, 0x31, 0x8c, 0x60, 0x18, 0xc6, 0x00, 0x0c, 0x06, 0xc6, 0x01, 0x80, 0x06, 0x18, 0xc6,
			0x30, 0x70, 0x1c, 0x06, 0x00, 0x00, 0x30, 0x06, 0x36, 0x66, 0x31, 0x8c, 0x60, 0x18, 0xc6, 0x00,
			0x1e, 0x0c, 0xc7, 0xe1, 0xf8, 0x0c, 0x0f, 0x86, 0x30, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x18, 0x0c,
			0x36, 0x66, 0x31, 0xf8, 0x60, 0x18, 0xc7, 0xe0, 0x03, 0x18, 0xc0, 0x31, 0x8c, 0x0c, 0x18, 0xc3,
			0xf0, 0x00, 0x00, 0x06, 0x00, 0x00, 0x30, 0x00, 0x36, 0x67, 0xf1, 0x8c, 0x60, 0x18, 0xc6, 0x00,
			0x03, 0x1f, 0xe0, 0x31, 0x8c, 0x18, 0x18, 0xc0, 0x30, 0x00, 0x00, 0x03, 0x07, 0xf0, 0x60, 0x00,
			0x36, 0x66, 0x31, 0x8c, 0x60, 0x18, 0xc6, 0x00, 0x03, 0x00, 0xc0, 0x31, 0x8c, 0x18, 0x18, 0xc0,
			0x30, 0x00, 0x00, 0x01, 0x80, 0x00, 0xc0, 0x00, 0x33, 0xe6, 0x31, 0x8c, 0x60, 0x18, 0xc6, 0x00,
			0x63, 0x00, 0xc6, 0x31, 0x8c, 0x30, 0x18, 0xc0, 0x60, 0x70, 0x1c, 0x00, 0xc0, 0x01, 0x80, 0x0c,
			0x30, 0x06, 0x31, 0x8c, 0x30, 0x19, 0x86, 0x00, 0x3e, 0x00, 0xc3, 0xe0, 0xf8, 0x30, 0x0f, 0x81,
			0xc0, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x06, 0x31, 0xf8, 0x1f, 0x1f, 0x07, 0xf0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x7f, 0x07, 0xc6, 0x31, 0xfe, 0x03, 0x18, 0x66, 0x01, 0x86, 0x61, 0x87, 0x87, 0xe0, 0x78, 0x7e,
			0x0f, 0xc7, 0xf9, 0x8c, 0x63, 0x18, 0x66, 0x30, 0x60, 0x0c, 0x06, 0x30, 0x30, 0x03, 0x18, 0xc6,
			0x01, 0xce, 0x71, 0x8c, 0xc6, 0x30, 0xcc, 0x63, 0x18, 0x00, 0xc1, 0x8c, 0x63, 0x18, 0x66, 0x30,
			0x60, 0x18, 0x06, 0x30, 0x30, 0x03, 0x19, 0x86, 0x01, 0xfe, 0x79, 0x98, 0x66, 0x31, 0x86, 0x63,
			0x18, 0x00, 0xc1, 0x8c, 0x63, 0x18, 0x66, 0x30, 0x60, 0x18, 0x06, 0x30, 0x30, 0x03, 0x1b, 0x06,
			0x01, 0xb6, 0x6d, 0x98, 0x66, 0x31, 0x86, 0x63, 0x18, 0x00, 0xc1, 0x8c, 0x63, 0x18, 0x63, 0x60,
			0x7e, 0x18, 0x07, 0xf0, 0x30, 0x03, 0x1e, 0x06, 0x01, 0x86, 0x67, 0x98, 0x66, 0x31, 0x86, 0x63,
			0x0e, 0x00, 0xc1, 0x8c, 0x63, 0x18, 0x61, 0xc0, 0x60, 0x19, 0xc6, 0x30, 0x30, 0x03, 0x1e, 0x06,
			0x01, 0x86, 0x63, 0x98, 0x67, 0xe1, 0x86, 0x7e, 0x03, 0x80, 0xc1, 0x8c, 0x63, 0x1b, 0x61, 0xc0,
			0x60, 0x18, 0xc6, 0x30, 0x30, 0x63, 0x1b, 0x06, 0x01, 0x86, 0x61, 0x98, 0x66, 0x01, 0x86, 0x6c,
			0x00, 0xc0, 0xc1, 0x8c, 0x36, 0x1b, 0x63, 0x60, 0x60, 0x18, 0xc6, 0x30, 0x30, 0x63, 0x19, 0x86,
			0x01, 0x86, 0x61, 0x98, 0x66, 0x01, 0x86, 0x66, 0x00, 0xc0, 0xc1, 0x8c, 0x36, 0x1f, 0xe6, 0x30,
			0x60, 0x0c, 0xc6, 0x30, 0x30, 0x63, 0x18, 0xc6, 0x01, 0x86, 0x61, 0x8c, 0xc6, 0x00, 0xcc, 0x63,
			0x00, 0xc0, 0xc1, 0x8c, 0x1c, 0x1c, 0xe6, 0x30, 0x60, 0x07, 0xc6, 0x31, 0xfe, 0x3e, 0x18, 0x67,
			0xf1, 0x86, 0x61, 0x87, 0x86, 0x00, 0x78, 0x63, 0x1f, 0x80, 0xc0, 0xf8, 0x1c, 0x18, 0x66, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x03, 0xc0, 0x00, 0x00, 0x0c, 0x01, 0x86, 0x00, 0x00, 0x00, 0x03, 0xf1, 0x80, 0x7e, 0x02, 0x00,
			0x00, 0x60, 0x00, 0x18, 0x00, 0x00, 0x06, 0x00, 0x06, 0x00, 0x01, 0x80, 0x0c, 0x01, 0x86, 0x00,
			0x61, 0x9f, 0xc3, 0x00, 0xc0, 0x06, 0x07, 0x00, 0x00, 0x30, 0x00, 0x18, 0x00, 0x00, 0x06, 0x00,
			0x06, 0x00, 0x01, 0x80, 0x00, 0x00, 0x06, 0x00, 0x61, 0x80, 0xc3, 0x00, 0xc0, 0x06, 0x0d, 0x80,
			0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x06, 0x00, 0x06, 0x00, 0x01, 0x80, 0x00, 0x00, 0x06, 0x00,
			0x61, 0x80, 0xc3, 0x00, 0x60, 0x06, 0x18, 0xc0, 0x00, 0x00, 0x3e, 0x1b, 0x81, 0xe0, 0x7e, 0x1e,
			0x1f, 0xc1, 0xed, 0xb8, 0x7c, 0x0f, 0x86, 0x30, 0x33, 0x01, 0x83, 0x00, 0x60, 0x06, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x1c, 0xc3, 0x30, 0xc6, 0x33, 0x06, 0x03, 0x39, 0xcc, 0x0c, 0x01, 0x86, 0x60,
			0x1e, 0x03, 0x03, 0x00, 0x30, 0x06, 0x00, 0x00, 0x00, 0x00, 0x03, 0x18, 0x66, 0x01, 0x86, 0x63,
			0x06, 0x06, 0x19, 0x8c, 0x0c, 0x01, 0x86, 0xc0, 0x0c, 0x06, 0x03, 0x00, 0x30, 0x06, 0x00, 0x00,
			0x00, 0x00, 0x3f, 0x18, 0x66, 0x01, 0x86, 0x7f, 0x06, 0x06, 0x19, 0x8c, 0x0c, 0x01, 0x87, 0x80,
			0x0c, 0x0c, 0x03, 0x00, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x63, 0x18, 0x66, 0x01, 0x86, 0x60,
			0x06, 0x03, 0x31, 0x8c, 0x0c, 0x01, 0x87, 0xc0, 0x0c, 0x18, 0x03, 0x00, 0x18, 0x06, 0x00, 0x00,
			0x00, 0x00, 0x63, 0x18, 0x66, 0x01, 0x86, 0x60, 0x06, 0x01, 0xe1, 0x8c, 0x0c, 0x01, 0x86, 0x60,
			0x0c, 0x18, 0x03, 0x00, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x67, 0x18, 0xc3, 0x30, 0xce, 0x30,
			0x06, 0x03, 0x01, 0x8c, 0x0c, 0x01, 0x86, 0x30, 0x0c, 0x1f, 0xc3, 0x00, 0x0c, 0x06, 0x00, 0x00,
			0x00, 0x00, 0x3b, 0x1f, 0x81, 0xe0, 0x76, 0x1f, 0x06, 0x03, 0xf1, 0x8c, 0x7f, 0x81, 0x86, 0x18,
			0x00, 0x00, 0x03, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x06, 0x18, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x03, 0x00, 0x06, 0x06, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x00, 0x00, 0x03, 0x00, 0x00,
			0x00, 0x00, 0x03, 0xf0, 0x00, 0x7e, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x03, 0xf0, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x03, 0x06, 0x30,
			0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x30, 0x18, 0x03, 0x0f, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x03, 0x0c, 0xf0,
			0x0c, 0x1f, 0xc6, 0xe0, 0x78, 0x6e, 0x07, 0xe6, 0xe0, 0xfc, 0x7f, 0x18, 0xc6, 0x31, 0x86, 0x63,
			0x18, 0xc7, 0xf0, 0x30, 0x18, 0x03, 0x0c, 0x60, 0x0c, 0x1b, 0x67, 0x30, 0xcc, 0x73, 0x0c, 0x67,
			0x31, 0x80, 0x18, 0x18, 0xc6, 0x31, 0x86, 0x63, 0x18, 0xc0, 0x30, 0x30, 0x18, 0x03, 0x00, 0x00,
			0x0c, 0x1b, 0x66, 0x31, 0x86, 0x61, 0x98, 0x66, 0x01, 0x80, 0x18, 0x18, 0xc6, 0x31, 0x86, 0x36,
			0x18, 0xc0, 0x60, 0x60, 0x18, 0x01, 0x80, 0x00, 0x0c, 0x1b, 0x66, 0x31, 0x86, 0x61, 0x98, 0x66,
			0x00, 0xe0, 0x18, 0x18, 0xc6, 0x31, 0xb6, 0x1c, 0x18, 0xc0, 0xc1, 0xc0, 0x18, 0x00, 0xe0, 0x00,
			0x0c, 0x1b, 0x66, 0x31, 0x86, 0x61, 0x98, 0x66, 0x00, 0x38, 0x18, 0x18, 0xc3, 0x61, 0xb6, 0x1c,
			0x18, 0xc1, 0x80, 0x60, 0x18, 0x01, 0x80, 0x00, 0x0c, 0x1b, 0x66, 0x31, 0x86, 0x61, 0x98, 0x66,
			0x00, 0x0c, 0x18, 0x18, 0xc3, 0x61, 0xb6, 0x36, 0x0d, 0xc3, 0x00, 0x30, 0x18, 0x03, 0x00, 0x00,
			0x0c, 0x1b, 0x66, 0x30, 0xcc, 0x63, 0x0c, 0xe6, 0x00, 0x0c, 0x18, 0x19, 0xc1, 0xc1, 0xb6, 0x63,
			0x07, 0xc6, 0x00, 0x30, 0x18, 0x03, 0x00, 0x00, 0x07, 0x9b, 0x66, 0x30, 0x78, 0x7e, 0x07, 0x66,
			0x01, 0xf8, 0x0f, 0x0e, 0xc1, 0xc0, 0xfc, 0x63, 0x00, 0xc7, 0xf0, 0x30, 0x18, 0x03, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0xc0, 0x00, 0x30, 0x18, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x60,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x30, 0x18, 0x03, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x0f, 0x00, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xc0, 0x80, 0xcc, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x30, 0x01, 0x81, 0xc1, 0xac, 0x66, 0x07, 0x00, 0x00, 0x00, 0x30, 0x01, 0x81, 0xc0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x03, 0x03, 0x61, 0x98, 0x66,
			0x0d, 0x80, 0x00, 0x00, 0x18, 0x03, 0x03, 0x60, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x03, 0x01, 0xe0, 0x00, 0x61, 0x86, 0x03, 0xc0, 0x00, 0x1c, 0x07, 0x01, 0xc0, 0x70, 0x1c,
			0x07, 0x01, 0xf8, 0x7c, 0x7f, 0x1f, 0xc7, 0xf0, 0x00, 0x07, 0x83, 0x33, 0x06, 0x33, 0x06, 0x06,
			0x60, 0x00, 0x3e, 0x0f, 0x83, 0xe0, 0xf8, 0x3e, 0x07, 0x03, 0xc0, 0xc0, 0x60, 0x18, 0x06, 0x00,
			0x18, 0x0c, 0xc3, 0x01, 0xfc, 0x1e, 0x06, 0x06, 0x60, 0x30, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63,
			0x0d, 0x86, 0xc1, 0x80, 0x60, 0x18, 0x06, 0x00, 0x18, 0x18, 0x03, 0x00, 0xd8, 0x0c, 0x06, 0x06,
			0x60, 0x30, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xcc, 0xc1, 0x80, 0x60, 0x18, 0x06, 0x00,
			0x00, 0x18, 0x07, 0xc1, 0x8c, 0x3f, 0x00, 0x03, 0xc0, 0x00, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63,
			0x18, 0xcc, 0xf1, 0x80, 0x7e, 0x1f, 0x87, 0xe0, 0x00, 0x18, 0x03, 0x01, 0x8c, 0x0c, 0x00, 0x00,
			0x00, 0x00, 0x7f, 0x1f, 0xc7, 0xf1, 0xfc, 0x7f, 0x18, 0xcc, 0xc1, 0x80, 0x60, 0x18, 0x06, 0x00,
			0x00, 0x18, 0x03, 0x00, 0xd8, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63,
			0x1f, 0xcf, 0xc1, 0x80, 0x60, 0x18, 0x06, 0x00, 0x18, 0x0c, 0xc3, 0x01, 0xfc, 0x3f, 0x06, 0x00,
			0x00, 0x30, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xcc, 0xc1, 0x80, 0x60, 0x18, 0x06, 0x00,
			0x18, 0x07, 0x83, 0xb3, 0x06, 0x0c, 0x06, 0x00, 0x00, 0x60, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63,
			0x18, 0xcc, 0xc0, 0xc0, 0x60, 0x18, 0x06, 0x00, 0x3c, 0x03, 0x06, 0xe0, 0x00, 0x0c, 0x06, 0x00,
			0x00, 0xc0, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xcc, 0xf8, 0x7c, 0x7f, 0x1f, 0xc7, 0xf0,
			0x3c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
			0x01, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00,
			0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x0c, 0x00, 0x30, 0x20, 0x00, 0x00, 0x03, 0x30, 0xc0, 0x03, 0x02, 0x03, 0x30, 0x00, 0x00,
			0x00, 0x06, 0x00, 0x0c, 0x08, 0x00, 0x00, 0x30, 0x66, 0x06, 0x00, 0x60, 0x70, 0x66, 0x00, 0x06,
			0xb0, 0x60, 0x06, 0x07, 0x06, 0xb1, 0x98, 0x00, 0x00, 0x03, 0x00, 0x18, 0x1c, 0x19, 0x80, 0x60,
			0x66, 0x03, 0x00, 0xc0, 0xd8, 0x66, 0x00, 0x06, 0x60, 0x30, 0x0c, 0x0d, 0x86, 0x61, 0x98, 0x00,
			0x00, 0x01, 0x80, 0x30, 0x36, 0x19, 0x80, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x7f, 0x1f, 0xe7, 0xf9, 0xfe, 0x7f, 0x8f, 0x86, 0x18, 0xf8, 0x3e, 0x0f, 0x83, 0xe0, 0xf8, 0x00,
			0x0f, 0x86, 0x31, 0x8c, 0x63, 0x18, 0xc6, 0x18, 0x60, 0x03, 0x00, 0xc0, 0x30, 0x0c, 0x0c, 0xc7,
			0x19, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x00, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc6, 0x18,
			0x60, 0x03, 0x00, 0xc0, 0x30, 0x0c, 0x0c, 0x67, 0x99, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x00,
			0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc6, 0x18, 0x60, 0x03, 0x00, 0xc0, 0x30, 0x0c, 0x0c, 0x66,
			0xd9, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x19, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc3, 0x30,
			0x7e, 0x03, 0x00, 0xc0, 0x30, 0x0c, 0x1e, 0x66, 0x79, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x36,
			0x1b, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc1, 0xe0, 0x60, 0x03, 0x00, 0xc0, 0x30, 0x0c, 0x0c, 0x66,
			0x39, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x1c, 0x1e, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0, 0xc0,
			0x60, 0x03, 0x00, 0xc0, 0x30, 0x0c, 0x0c, 0x66, 0x19, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x1c,
			0x1c, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0, 0xc0, 0x60, 0x03, 0x00, 0xc0, 0x30, 0x0c, 0x0c, 0x66,
			0x19, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x36, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0, 0xc0,
			0x60, 0x03, 0x00, 0xc0, 0x30, 0x0c, 0x0c, 0xc6, 0x19, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63,
			0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0, 0xc0, 0x7f, 0x1f, 0xe7, 0xf9, 0xfe, 0x7f, 0x8f, 0x86,
			0x18, 0xf8, 0x3e, 0x0f, 0x83, 0xe0, 0xf8, 0x00, 0x0f, 0x83, 0xe0, 0xf8, 0x3e, 0x0f, 0x80, 0xc0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0c, 0x08, 0x0c, 0xc0,
			0x00, 0x70, 0x00, 0x00, 0x06, 0x00, 0x0c, 0x08, 0x00, 0x03, 0x00, 0x0c, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x00, 0x18, 0x1c, 0x1a, 0xc3, 0x30, 0xd8, 0x00, 0x00, 0x03, 0x00, 0x18, 0x1c,
			0x0c, 0xc1, 0x80, 0x18, 0x1c, 0x19, 0x81, 0x88, 0x00, 0x00, 0x01, 0x80, 0x30, 0x36, 0x19, 0x83,
			0x30, 0xd8, 0x00, 0x00, 0x01, 0x80, 0x30, 0x36, 0x0c, 0xc0, 0xc0, 0x30, 0x36, 0x19, 0x80, 0xf0,
			0x60, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 0x60, 0x18, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
			0x7e, 0x18, 0xc3, 0xe0, 0xf8, 0x3e, 0x0f, 0x83, 0xe0, 0xf8, 0x7b, 0x8f, 0x83, 0xe0, 0xf8, 0x3e,
			0x0f, 0x87, 0xc1, 0xf0, 0x7c, 0x1f, 0x01, 0xf8, 0x63, 0x19, 0x80, 0x30, 0x0c, 0x03, 0x00, 0xc0,
			0x30, 0x0c, 0x0c, 0xd8, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0, 0xc0, 0x30, 0x0c, 0x03, 0x03, 0x18,
			0x63, 0x1b, 0x80, 0x30, 0x0c, 0x03, 0x00, 0xc0, 0x30, 0x0c, 0x0c, 0xd8, 0x06, 0x31, 0x8c, 0x63,
			0x18, 0xc0, 0xc0, 0x30, 0x0c, 0x03, 0x06, 0x18, 0x63, 0x18, 0xc3, 0xf0, 0xfc, 0x3f, 0x0f, 0xc3,
			0xf0, 0xfc, 0x7f, 0xd8, 0x07, 0xf1, 0xfc, 0x7f, 0x1f, 0xc0, 0xc0, 0x30, 0x0c, 0x03, 0x06, 0x18,
			0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0xcc, 0x18, 0x06, 0x01, 0x80, 0x60,
			0x18, 0x00, 0xc0, 0x30, 0x0c, 0x03, 0x06, 0x18, 0x7e, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc6,
			0x31, 0x8c, 0xcc, 0x18, 0x06, 0x01, 0x80, 0x60, 0x18, 0x00, 0xc0, 0x30, 0x0c, 0x03, 0x06, 0x18,
			0x60, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0xcc, 0x18, 0xc6, 0x01, 0x80, 0x60,
			0x18, 0x00, 0xc0, 0x30, 0x0c, 0x03, 0x03, 0x30, 0x60, 0x19, 0x83, 0xf0, 0xfc, 0x3f, 0x0f, 0xc3,
			0xf0, 0xfc, 0x77, 0xcf, 0x83, 0xf0, 0xfc, 0x3f, 0x0f, 0xc7, 0xf9, 0xfe, 0x7f, 0x9f, 0xe1, 0xe0,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x02, 0x00, 0x80, 0x00, 0x10, 0x04, 0x33, 0x0c, 0x00, 0x30, 0x20, 0x33, 0x00, 0x00,
			0x00, 0x00, 0x60, 0x00, 0xc0, 0x80, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x40, 0x00, 0x30, 0x08,
			0x6b, 0x06, 0x00, 0x60, 0x70, 0x6b, 0x19, 0x80, 0x00, 0x00, 0x30, 0x01, 0x81, 0xc1, 0x98, 0x06,
			0x00, 0x06, 0x63, 0x80, 0x20, 0x00, 0x70, 0x10, 0x66, 0x03, 0x00, 0xc0, 0xd8, 0x66, 0x19, 0x80,
			0x00, 0x00, 0x18, 0x03, 0x03, 0x61, 0x98, 0x0c, 0x18, 0x06, 0x63, 0xc0, 0x10, 0x00, 0xf0, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x18, 0x00, 0x03, 0xe0, 0x08, 0x01, 0xf0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xc0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x03, 0xf0, 0x04, 0x03, 0xf0, 0x80,
			0x7e, 0x0f, 0x83, 0xe0, 0xf8, 0x3e, 0x0f, 0x80, 0x00, 0xf8, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63,
			0x1b, 0x86, 0x33, 0xf8, 0x02, 0x07, 0xf1, 0x00, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0,
			0x01, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x1c, 0xc6, 0x33, 0xfc, 0x01, 0x0f, 0xf2, 0x00,
			0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc7, 0xf9, 0x9c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63,
			0x18, 0x66, 0x33, 0xfe, 0x00, 0x9f, 0xf4, 0x00, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0,
			0x01, 0xbc, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0x66, 0x33, 0xff, 0x00, 0x7f, 0xf8, 0x00,
			0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0, 0x01, 0xec, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63,
			0x18, 0x66, 0x33, 0xff, 0x00, 0x7f, 0xf8, 0x00, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0,
			0xc1, 0xcc, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0x66, 0x33, 0xfe, 0x00, 0x9f, 0xf4, 0x00,
			0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63, 0x18, 0xc0, 0xc1, 0x8c, 0x63, 0x18, 0xc6, 0x31, 0x8c, 0x63,
			0x1c, 0xc6, 0x33, 0xfc, 0x01, 0x0f, 0xf2, 0x00, 0x63, 0x0f, 0x83, 0xe0, 0xf8, 0x3e, 0x0f, 0x80,
			0x00, 0xf8, 0x3f, 0x0f, 0xc3, 0xf0, 0xfc, 0x3f, 0x1b, 0x83, 0xf3, 0xf8, 0x02, 0x07, 0xf1, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
			0x18, 0x00, 0x33, 0xf0, 0x04, 0x03, 0xf0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x18, 0x00, 0x33, 0xe0, 0x08, 0x01, 0xf0, 0x40,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e,
			0x18, 0x03, 0xe3, 0xc0, 0x10, 0x00, 0xf0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x20, 0x00, 0x70, 0x10,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x00, 0x40, 0x00, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x80, 0x00, 0x10, 0x04
		],
		192
	),
	glyph_mapping: &GLYPH_MAPPING,
	size: Size::new(10, 20),
	pixels: ONE
};

/// Pixel-double version of [`FONT_5x9`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_10x18),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_10x18: BitmapFont<'static> = {
	FONT_5x9.pixel_double()
};

/// Pixel-double version of [`FONT_5x9_BOLD`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_10x18_BOLD),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_10x18_BOLD: BitmapFont<'static> = {
	FONT_5x9_BOLD.pixel_double()
};

/// Pixel-double version of [`FONT_6x12`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_12x24),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_12x24: BitmapFont<'static> = {
	FONT_6x12.pixel_double()
};

/// Pixel-double version of [`FONT_6x12_BOLD`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_12x24_BOLD),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_12x24_BOLD: BitmapFont<'static> = {
	FONT_6x12_BOLD.pixel_double()
};

/// Pixel-double version of [`FONT_7x13`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_14x26),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_14x26: BitmapFont<'static> = {
	FONT_7x13.pixel_double()
};

/// Pixel-double version of [`FONT_7x13_BOLD`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_14x26_BOLD),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_14x26_BOLD: BitmapFont<'static> = {
	FONT_7x13_BOLD.pixel_double()
};

/// Pixel-double version of [`FONT_7x14`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_14x28),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_14x28: BitmapFont<'static> = {
	FONT_7x14.pixel_double()
};

/// Pixel-double version of [`FONT_7x14_BOLD`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_14x28_BOLD),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_14x28_BOLD: BitmapFont<'static> = {
	FONT_7x14_BOLD.pixel_double()
};

/// Pixel-double version of [`FONT_8x15`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_16x30),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_16x30: BitmapFont<'static> = {
	FONT_8x15.pixel_double()
};

/// Pixel-double version of [`FONT_8x15_BOLD`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_16x30_BOLD),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_16x30_BOLD: BitmapFont<'static> = {
	FONT_8x15_BOLD.pixel_double()
};

/// Pixel-double version of [`FONT_8x16`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_16x32),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_16x32: BitmapFont<'static> = {
	FONT_8x16.pixel_double()
};

/// Pixel-double version of [`FONT_8x16_BOLD`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_16x32_BOLD),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_16x32_BOLD: BitmapFont<'static> = {
	FONT_8x16_BOLD.pixel_double()
};

/// Pixel-double version of [`FONT_10x20`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_20x40),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_20x40: BitmapFont<'static> = {
	FONT_10x20.pixel_double()
};

/// Pixel-double version of [`FONT_10x20_BOLD`].
///
#[doc = concat!(
	"![Screenshot](",
	font_bmp!(FONT_20x40_BOLD),
	")"
)]
///
/// This font does not store its own bitmap and therefore does not increase the flash size significantly.
#[allow(non_upper_case_globals)]
pub const FONT_20x40_BOLD: BitmapFont<'static> = {
	FONT_10x20_BOLD.pixel_double()
};
