
# 0.9.6 - 2021-05-03

* Re-export `core` as `_export::_core`. This resolves an issue when calling several exported macros with the `std` feature.

# 0.9.5 - 2021-04-28

* Add [`#[repr(transparent)]` to all newtype wrappers](https://github.com/rust-bitcoin/bitcoin_hashes/pull/108/)
* Add [missing `#derive`s](https://github.com/rust-bitcoin/bitcoin_hashes/pull/110/)
* Replace `fuzztarget` feature with [use of `cfg(fuzzing)`](https://github.com/rust-bitcoin/bitcoin_hashes/pull/111/)
* Use [`core` rather than `std`](https://github.com/rust-bitcoin/bitcoin_hashes/pull/118/) and [fix `no_std` compilation](https://github.com/rust-bitcoin/bitcoin_hashes/pull/122/)

Note that we have stopped re-exporting the `core` crate when compiling without `std`. This is technically a breaking change but it is hard to imagine what user might be affected.

# 0.9.4 - 2020-10-23

* Add `Hmac::from_inner_engines`

# 0.9.3 - 2020-10-19

* More serde macro fixes

# 0.9.2 - 2020-10-18

* Fix rustc 1.29.0 downstream issues with serde macros

# 0.9.2 - 2020-10-16

* Fix visibility issue with serde macros

# 0.9.1 - 2020-10-07

* Add `FromStr` impl to `sha256t::Hash`
* Fix `Hash::engine()` implementation for hash newtypes
* Add `sha256t_hash_newtype!` macro for creating tagged hashes

# 0.9.0 - 2020-08-27

* **Update MSRV to 1.29.0**

# 0.8.0 - 2020-08-26

* Add `as_inner` method to `Hash` trait
* Add `n_bytes_hashed` to `HashEngine` trait

# 0.7.6 - 2020-04-05

* Support hash newtypes with reversed hex serialization.

# 0.7.5 - 2020-04-02

* Add `sha256t` module for SHA-256-based tagged hashes.
* Add `FromStr` for hash newtypes.
* Add `from_hash` for hash newtypes.

# 0.7.3 - 2019-12-18

* Add `as_hash(&self) -> <inner>` method to hash newtypes.

# 0.7.2 - 2019-11-29

* Make the inner variable of `sha256::Midstat` public
* Drop the `byteorder` dependency in favor of manual endianness implementations
(later this will be in stdlib so we can drop even that)
* Fix the `hash_newtype` macro, which did not compile before

# 0.7.1 - 2019-08-14

* Add hash_newtype macro that allows third parties to create newtype structs.

# 0.7.0 - 2019-07-19

* Add `hex::Error` type for errors generated by the `hex` module.

# 0.6.0 - 2019-07-10

* Add `no_std` support, rearrange traits to not depend on `io::Write`

# 0.5.0 - 2019-06-28

* Fix panic when parsing hashes that contain multibyte characters
* Add `FromStr` to all hashes which hex-parses them

# 0.4.0 - 2019-06-23

* [Add `from_inner` method](https://github.com/rust-bitcoin/bitcoin_hashes/pull/20) to all hashes
* [Update `FromHex` trait](https://github.com/rust-bitcoin/bitcoin_hashes/pull/40) to require `from_byte_iter` method rather than `from_hex` be implemented
* Make `Hmac` midstate [an actual HMAC midstate](https://github.com/rust-bitcoin/bitcoin_hashes/pull/43)
* Allow `Display` [of truncated hashes](https://github.com/rust-bitcoin/bitcoin_hashes/pull/9)
* Require [using a constructor for `HexIterator`](https://github.com/rust-bitcoin/bitcoin_hashes/pull/44) and then [clean up the internals](https://github.com/rust-bitcoin/bitcoin_hashes/pull/47)
* [Strongly type `sha256::Midstate`](https://github.com/rust-bitcoin/bitcoin_hashes/pull/39) to allow independent serialization
* Add [siphash24 module](https://github.com/rust-bitcoin/bitcoin_hashes/pull/46)

# 0.3.2 - 2019-03-20

* Implement the `FromHex` trait on [many more types](https://github.com/rust-bitcoin/bitcoin_hashes/pull/38)

# 0.3.1 - 2019-03-04

* [Fix serde serialization](https://github.com/rust-bitcoin/bitcoin_hashes/pull/36)

# 0.3.0 - 2019-01-23

* Bump minimum required rustc version to 1.22.0
* Fixed serde deserialization into owned string that previously caused panics
  when doing round-trip (de)serialization
* `HashEngine::block_size()` and `Hash::len()` are now associated constants
  `HashEngine::BLOCK_SIZE` and `Hash::LEN`
* Removed `block_size()` method from `Hash` trait. It is still available as
  `<T as Hash>::Engine::BLOCK_SIZE`

# 0.2.0 - 2019-01-15

* Add a constant-time comparison function
* Simplify `io::Write::write` implementations by having them do only partial writes
* Add fuzzing support
* Allow `Hash`es to be borrowed as `[u8]`
* Replace public `Hash` inners with `into_inner` method

# 0.1.0 - 2018-12-08

* Initial release

