/// Buz-hash maps each byte to a pseudo-random 32-bit number, where each bit
/// has a roughly equal probability of being 1 or 0.
///
/// This particular table is not random. It's the result of taking the CRC-32
/// of a u32 zero (32 zero bits) and then recursively taking the CRC-32 of the
/// result 11_888 times. The next 256 recursive results are this table. That
/// had the benefit of being *not* random -- reproducible and not magic -- but
/// also having a pretty equal bit distribution across both the bits within a
/// u32, and the 256 values for each bit position.
pub const BYTE_TABLE: [u32; 256] = [
    0x9ceb73df, 0x4df75592, 0x0fea503f, 0xd19e1fac, 0x2f95d83a, 0x9aafe057,
    0xe739e2db, 0x4a9d1f2b, 0x13eb4fb7, 0xe313083b, 0x50910354, 0x645c131f,
    0x6b8f32e5, 0x817163bc, 0x90eaa046, 0x12dd0dbf, 0xaba2d899, 0xbfa3b1b1,
    0x9ee223f3, 0xf463b1c1, 0xdf29cc39, 0x66f857bd, 0xdf1bdeb6, 0x2110d2bf,
    0xecf36281, 0xa9df0d21, 0x98b84688, 0xaf768f7c, 0xd5c8fc8c, 0xcf8f2736,
    0x7ec673a1, 0xa8395b86, 0x5f1651ca, 0xb2866c4b, 0x642adf09, 0xff2d8bf2,
    0xed634033, 0x232ba332, 0x744f8014, 0x3f83e2bb, 0xe799f4fc, 0xc1d4eb87,
    0xfd4a9ce2, 0x60a13e15, 0x92d85cdb, 0xe2578b2f, 0x8f8bdcd2, 0x8cfabd6b,
    0x0ab80461, 0x691e2a08, 0x3105d2e6, 0x70f4d4d9, 0xd04de166, 0x542d2ec8,
    0xec42bd1d, 0x2542bec9, 0x6c8a544a, 0x3b30bc9b, 0xe90c611a, 0x2296dc20,
    0xf79ed00e, 0x80095d34, 0x06133560, 0xb04eebc3, 0x459070b2, 0xb5390e58,
    0x90ec1fe2, 0x488c9d46, 0x85c1edbb, 0x053ec4d4, 0x2f7b20bc, 0x29b7f5ba,
    0x09b260ca, 0xdf4c6ec0, 0x5fe0187c, 0xb7328d79, 0x66ebca87, 0xd4a9ac42,
    0x3e40fac3, 0xccf73a5c, 0x404cf6a1, 0x4fcaef87, 0x2402a5c6, 0xa3e4771e,
    0xb5f145df, 0x9f8eae07, 0xaac5acdf, 0x0f9fbb2a, 0x41a60af3, 0x418689ea,
    0x1a601084, 0xc7c6cfdd, 0xf72948fe, 0x5eeb9aa4, 0x22903abc, 0xfb3d8586,
    0x4e0f8cba, 0xad58e35e, 0x7b37c17d, 0x7fac53aa, 0xaf6029dc, 0x59ce718c,
    0x9436c768, 0x3548461d, 0x9933a002, 0x2f8d0427, 0x3e543b18, 0x83612fe6,
    0xe9164859, 0x2c86ac47, 0xa8e448b2, 0x0aa99847, 0x4b97b86e, 0xeefe7441,
    0x9c992384, 0x204ee8f5, 0x6299fad2, 0x1675692f, 0x388fa839, 0xef1558f5,
    0xf5535f7c, 0x3b0ca1b1, 0x418e679c, 0x3f919866, 0x123508ed, 0x5acaa4bf,
    0x008ff342, 0x1bc006a7, 0xb4ea9cb0, 0xa0a2bce1, 0xc92483b6, 0xe97ef031,
    0xb47d3dac, 0x5cd77f4c, 0x038f59f3, 0xf3e8a654, 0x0acdbc79, 0x65b67763,
    0xd62e65cd, 0x8fc89ec1, 0x661c0072, 0xa2d42e3b, 0xe9310989, 0xa14f404c,
    0x562c75ed, 0xec52732d, 0x049aef73, 0x76b3e17a, 0xfb680c01, 0x17a98b26,
    0xb56b59f8, 0x3cf90104, 0x45f5040f, 0x1153c771, 0x9d01b645, 0xdbf82b09,
    0xa530597e, 0xb0337c18, 0xd608e7e4, 0x739d32bf, 0x4e5964ff, 0x4a82309b,
    0xf0d20e6e, 0xfe9027a7, 0xe7befbc4, 0x25d2ce91, 0x4783914d, 0x4cfd9280,
    0xecf297f2, 0x7a418229, 0x477d1620, 0xebf47c68, 0xc5358e8d, 0x9ce373f9,
    0x00772f78, 0xdca0b983, 0x35452140, 0x5862d495, 0x13218385, 0x109168f1,
    0x2cb79f79, 0x58609b5b, 0xcc43b2cf, 0x8036996f, 0xd467a963, 0x757c0ab3,
    0x80f108f7, 0xd4f9f366, 0xcc4bf673, 0x68d8c759, 0x0929b98c, 0x71de344f,
    0xf9e87300, 0x25353a49, 0x0791be1c, 0x0275cad9, 0x5a66d606, 0x3532bd89,
    0xc750dbbc, 0x4887fea8, 0x1a047702, 0x43fd553c, 0xbf09fb84, 0x70f27715,
    0x61b2f467, 0xd93e565e, 0xdc6d8482, 0xdf1e99e5, 0xf00a1df3, 0xe63b4ce0,
    0xfb6042f5, 0xac702014, 0x362dcf01, 0xec9ba672, 0x068e6b5b, 0x35a9638e,
    0x4f25a8ee, 0xce1f6929, 0x0afe2e2e, 0x399049d6, 0x73748d04, 0xc5945cec,
    0x26688f69, 0xf22a5f7a, 0x7efea971, 0x19ecee02, 0xbe91fe1d, 0x78ee2b54,
    0xcf10c984, 0x9c189ecf, 0x8345f380, 0x8220cd74, 0xca5c2b6a, 0x2c78588c,
    0x315a368a, 0x92cca585, 0x5d3e6cb4, 0xa68602a1, 0x857b4c02, 0xa3d4b4a1,
    0xbc4f05f9, 0x69d7e8b7, 0xfc07a203, 0x1247d10c, 0xab589729, 0x37443ce1,
    0x4e5ecabb, 0xc253195c, 0x57945af2, 0x8c22211f, 0x530d3d29, 0x97013768,
    0x8982c443, 0xa392d71e, 0x15ecc6cf, 0x055e93b5,
];
