use bitbag::BitBaggable;
use strum::EnumIter;

#[derive(BitBaggable)]
#[repr(u8)]
#[derive(EnumIter, Clone, Copy)]
enum Flags {
    A = 0b0001,
    B = 0b0010,
    C = 0b0100,
}

#[test]
fn test() {
    let bag = Flags::A | Flags::B;
    assert!(bag.is_set(Flags::A));
    assert!(bag.is_set(Flags::B));
    assert!(!bag.is_set(Flags::C));
}
