// If an async Future goes unused, toss a compile-time error
#![deny(unused_must_use)]

//! `bissel` is an early-stage robotics-focused publish/request middleware
//! for embedded Linux. It uses a star-shaped network topology, with a focus
//! on ease-of-use and transparent design and operation. It is more similar to
//! [ZeroMQ](https://zguide.zeromq.org/docs/chapter1/) than to higher-level frameworks like [ROS/2](https://design.ros2.org/articles/discovery_and_negotiation.html),
//! but uses central coordination process similar to [MOOS-IvP](https://oceanai.mit.edu/ivpman/pmwiki/pmwiki.php?n=Helm.HelmDesignIntro#section2.4).

/// Central coordination process, which stores published data and responds to requests
pub mod host;
/// Message definitions for publish/request functions
pub mod msg;
/// Network-based utility module
pub mod networks;
/// Named objects that publish and request strongly-typed data to named topics on the Host
pub mod node;

// Require that the README examples are valid
// Will fail `cargo test` if not
#[doc = include_str!("../README.md")]
#[cfg(doctest)]
pub struct ReadMeDocTests;

pub use crate::host::*;
pub use crate::msg::*;
pub use crate::networks::*;
pub use crate::node::*;
