for the base case, we have the following input files:

`tests/data/1196175296_mwa_ord/1196175296.metafits`:

```txt                                       
GPSTIME =           1196175296 / [s] GPS time of observation start              
EXPOSURE=                    2 / [s] duration of observation                                    
MJD     =    58088.62127314815 / [days] MJD of observation                      
DATE-OBS= '2017-12-01T14:54:38' / [UT] Date and time of observation             
INTTIME =                  0.5 / [s] Individual integration time               
NSCANS  =                    4 / Number of time instants in correlation products
DATESTRT= '2017-12-01T14:54:38' / [UT] Date and time of correlations start      
```

`tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox01_00.fits`

```txt                        
NAXIS1  =                66048 / length of data axis 1                          
NAXIS2  =                    2 / length of data axis 2                          
TIME    =           1512140080 / Unix time (seconds)                            
MILLITIM=                    0 / Milliseconds since TIME                        
INTTIME =                  0.5 / Integration time (s)                           
```

`tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox02_00.fits`

```txt                   
NAXIS1  =                66048 / length of data axis 1                          
NAXIS2  =                    2 / length of data axis 2                          
TIME    =           1512140080 / Unix time (seconds)                            
MILLITIM=                    0 / Milliseconds since TIME                        
INTTIME =                  0.5 / Integration time (s)                      
```

`tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox01_01.fits`

```txt                        
NAXIS1  =                66048 / length of data axis 1                          
NAXIS2  =                    2 / length of data axis 2                          
TIME    =           1512140081 / Unix time (seconds)                            
MILLITIM=                    0 / Milliseconds since TIME                        
INTTIME =                  0.5 / Integration time (s)  
```

`tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox02_01.fits`

```txt
NAXIS1  =                66048 / length of data axis 1                          
NAXIS2  =                    2 / length of data axis 2                          
TIME    =           1512140081 / Unix time (seconds)                            
MILLITIM=                    0 / Milliseconds since TIME                        
INTTIME =                  0.5 / Integration time (s)     
```

we perform flagging using cotter:

```bash
cotter \
  -m tests/data/1196175296_mwa_ord/1196175296_cotter-friendly.metafits \
  -o "tests/data/1196175296_mwa_ord/FlagfileCotterMWA%%.mwaf" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-2ch-unitary.txt \
  -nostats \
  -sbcount 2 \
  -sbstart 1 \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  tests/data/1196175296_mwa_ord/1196175296_*gpubox*.fits \
  | tee cotter-1196175296-mwa.log
```

```txt
Observation covers 200.32-1.41671e+20 MHz.
Output resolution: 0.5 s / 7680 kHz (time avg: 1x, freq avg: 1x).
The first 0 samples (0 s), last 0 samples (0 s) and 0 edge channels will be flagged.
Read subband passband, using 2 gains to correct for 2 subbands.
Using per-input subband gains. Average gains: 1.42542,1.44653
Subband order: 1,0
Observation's bandwidth is contiguous.
Only flags will be outputted.
All 4 scans fit in memory; no partitioning necessary.
=== Processing chunk 1 of 1 ===
There are 3 HDUs in file tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox02_00.fits
There are 3 HDUs in file tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox01_00.fits
Will stop on HDU 3.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
WARNING: start time according to raw files is 2017-12-01 14:54:40,
but meta files say 2017-12-01 14:54:38 !
Will use start time from raw file, which should be most accurate.
There are 3 HDUs in file tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox02_01.fits
There are 3 HDUs in file tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox01_01.fits
Will stop on HDU 3.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Wall-clock time in reading: 00:00:00.062332 processing: 00:00:00.119622 writing: 00:00:00.030834
```

resulting flag dumps:

`tests/data/1196175296_mwa_ord/adjusted_+1/FlagfileCotterMWA01.mwaf`

```                        
GPSTIME =           1196175296                                                  
NCHANS  =                    2                                                  
NANTENNA=                  128                                                  
NSCANS  =                    4                                                  
NPOLS   =                    1                                                  
GPUBOXNO=                    1                                                  
COTVER  = '4.5     '                                                            
COTVDATE= '2020-08-10'                                                          
 -> num baselines: 8256

FLAG DATA

NAXIS1  =                    1 / width of table in bytes                        
NAXIS2  =                33024 / number of rows in table                            
TFIELDS =                    1 / number of fields in each row                                      
flags shape (33024,)
-> limits: baseline=12, timestep=4
-> bl 0000:
 --> ts 0000: ..
 --> ts 0001: ..
 --> ts 0002: ..
 --> ts 0003: ..
-> bl 0001:
 --> ts 0000: ..
 --> ts 0001: ..
 --> ts 0002: ..
 --> ts 0003: ..
...
```

`tests/data/1196175296_mwa_ord/FlagfileCotterMWA02.mwaf`

```txt
GPSTIME =           1196175296                                                  
NCHANS  =                    2                                                  
NANTENNA=                  128                                                  
NSCANS  =                    4                                                  
NPOLS   =                    1                                                  
GPUBOXNO=                    2                                                  
COTVER  = '4.5     '                                                            
COTVDATE= '2020-08-10'                                                          
 -> num baselines: 8256

FLAG DATA
                 
NAXIS1  =                    1 / width of table in bytes                        
NAXIS2  =                33024 / number of rows in table                        
                   
flags shape (33024,)
-> limits: baseline=12, timestep=4
-> bl 0000:
 --> ts 0000: ..
 --> ts 0001: ..
 --> ts 0002: ..
 --> ts 0003: ..
-> bl 0001:
 --> ts 0000: ..
 --> ts 0001: ..
 --> ts 0002: ..
 --> ts 0003: ..
```

## 1196175296_mwa_ord offset 01_00 by -1

next we create a modified version of scan `01_00` where all times are offset by -1 timesteps

```bash
python3 tests/data/adjust_gpufits.py \
  --in-file=tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox01_00.fits \
  --out-file=tests/data/1196175296_mwa_ord/adjusted_-1/1196175296_20171201145440_gpubox01_00.fits \
  --corr-type=MWA_ORD --timestep-offset=-1
```

`tests/data/1196175296_mwa_ord/adjusted_-1/1196175296_20171201145440_gpubox01_00.fits`

```txt                      
NAXIS1  =                66048 / length of data axis 1                          
NAXIS2  =                    2 / length of data axis 2                          
TIME    =           1512140079 / Unix time (seconds)                            
MILLITIM=                  500 / Milliseconds since TIME                        
INTTIME =                  0.5 / Integration time (s)                           
MARKER  =                23120 / Data offset marker (all channels should match) 
```

and flag this with

```bash
cotter \
  -m tests/data/1196175296_mwa_ord/1196175296_cotter-friendly.metafits \
  -o "tests/data/1196175296_mwa_ord/adjusted_-1/FlagfileCotterMWA%%.mwaf" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-2ch-unitary.txt \
  -nostats \
  -sbcount 2 \
  -sbstart 1 \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  tests/data/1196175296_mwa_ord/adjusted_-1/1196175296_20171201145440_gpubox01_00.fits \
  tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox02_00.fits \
  tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox01_01.fits \
  tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox02_01.fits \
  | tee cotter-1196175296-mwa_-1.log
```

```txt
Observation covers 200.32-1.41671e+20 MHz.
Output resolution: 0.5 s / 7680 kHz (time avg: 1x, freq avg: 1x).
The first 0 samples (0 s), last 0 samples (0 s) and 0 edge channels will be flagged.
Read subband passband, using 2 gains to correct for 2 subbands.
Using per-input subband gains. Average gains: 1.42542,1.44653
Subband order: 1,0
Observation's bandwidth is contiguous.
Only flags will be outputted.
All 4 scans fit in memory; no partitioning necessary.
=== Processing chunk 1 of 1 ===
There are 3 HDUs in file tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox02_00.fits
There are 3 HDUs in file tests/data/1196175296_mwa_ord/adjusted_-1/1196175296_20171201145440_gpubox01_00.fits
WARNING: file number 2 of current time range has different start time!
Current file start time: 1512140079 previous file had: 1512140080.
HDU offsets per file: [0,2]
Will stop on HDU 3.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
WARNING: start time according to raw files is 2017-12-01 14:54:40,
but meta files say 2017-12-01 14:54:38 !
Will use start time from raw file, which should be most accurate.
There are 3 HDUs in file tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox02_01.fits
There are 3 HDUs in file tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox01_01.fits
WARNING! The HDU offsets change over time, this should never happen!
Will stop on HDU 3.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
WARNING: start time according to raw files is 2017-12-01 14:54:41,
but meta files say 2017-12-01 14:54:40 !
Will use start time from raw file, which should be most accurate.
Warning: header specifies 4 scans, but there are only 2 in the data.
Last 2 scan(s) will be flagged.
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Wall-clock time in reading: 00:00:00.052146 processing: 00:00:00.121814 writing: 00:00:00.031581
```

*things to note:*

the INTTIME is 0.5 and the start times are 1512140079.500 and 1512140080.000. 
Cotter seems to ignore MILLITIME when calculating the time difference, and think the difference is 1.000.
However, when it calculates the gpubox offsets, it uses MILLITIME, so it sets the gpubox offsets to [2, 0], even though it should actually be an offset of just [1, 0]. 
This means that cotter will overcorrect for the offset, and the visibilities it will be comparing will be out by 0.500s 

resulting flags:

```txt                                                       
GPSTIME =           1196175296                                                  
NCHANS  =                    2                                                  
NANTENNA=                  128                                                  
NSCANS  =                    4                                                  
NPOLS   =                    1                                                  
GPUBOXNO=                    1                                                  
COTVER  = '4.5     '                                                            
COTVDATE= '2020-08-10'                                                          
 -> num baselines: 8256

FLAG DATA
                  
NAXIS1  =                    1 / width of table in bytes                        
NAXIS2  =                16512 / number of rows in table                        
                 
flags shape (16512,)
num_scans (4) * num_baselines(8256) != rows(16512)
actual num_scans: 2
-> limits: baseline=12, timestep=2
-> bl 0000:
 --> ts 0000: ..
 --> ts 0001: ##
-> bl 0001:
 --> ts 0000: ##
 --> ts 0001: ##
```

## 1196175296_mwa_ord offset 01_00, 01_01 by -1

we create a second offset file for gpubox 01 batch 01

```bash
python3 tests/data/adjust_gpufits.py \
  --in-file=tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox01_01.fits \
  --out-file=tests/data/1196175296_mwa_ord/adjusted_-1/1196175296_20171201145540_gpubox01_01.fits \
  --corr-type=MWA_ORD --timestep-offset=-1
```

flag with

```bash
cotter \
  -m tests/data/1196175296_mwa_ord/1196175296_cotter-friendly.metafits \
  -o "tests/data/1196175296_mwa_ord/adjusted_-1/FlagfileCotterMWA_both%%.mwaf" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-2ch-unitary.txt \
  -nostats \
  -sbcount 2 \
  -sbstart 1 \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  tests/data/1196175296_mwa_ord/adjusted_-1/1196175296_20171201145440_gpubox01_00.fits \
  tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox02_00.fits \
  tests/data/1196175296_mwa_ord/adjusted_-1/1196175296_20171201145540_gpubox01_01.fits \
  tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox02_01.fits \
  | tee cotter-1196175296-mwa_-1_both.log
```

## 1196175296_mwa_ord offset 01_00 by +1

```bash
python3 tests/data/adjust_gpufits.py \
  --in-file=tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox01_00.fits \
  --out-file=tests/data/1196175296_mwa_ord/adjusted_+1/1196175296_20171201145440_gpubox01_00.fits \
  --corr-type=MWA_ORD --timestep-offset=1
```

flag with 

```bash
cotter \
  -m tests/data/1196175296_mwa_ord/1196175296_cotter-friendly.metafits \
  -o "tests/data/1196175296_mwa_ord/adjusted_+1/FlagfileCotterMWA%%.mwaf" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-2ch-unitary.txt \
  -nostats \
  -sbcount 2 \
  -sbstart 1 \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox01_00.fits \
  tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox02_00.fits \
  tests/data/1196175296_mwa_ord/adjusted_+1/1196175296_20171201145540_gpubox01_01.fits \
  tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox02_01.fits \
  | tee cotter-1196175296-mwa_+1.log
```

here, a +0.500s offset has been applied to the first batch, but not the second.
This means that the last hdu of the first batch overlaps with the first hdu of the second batch
Cotter processes these anyway.



## 1196175296_mwa_ord offset 01_00, 01_01 by +1

we create a second offset file for gpubox 01 batch 01

```bash
python3 tests/data/adjust_gpufits.py \
  --in-file=tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox01_01.fits \
  --out-file=tests/data/1196175296_mwa_ord/adjusted_+1/1196175296_20171201145540_gpubox01_01.fits \
  --corr-type=MWA_ORD --timestep-offset=1
```

`tests/data/1196175296_mwa_ord/adjusted_+1/1196175296_20171201145440_gpubox01_00.fits`

```txt                        
NAXIS1  =                66048 / length of data axis 1                          
NAXIS2  =                    2 / length of data axis 2                          
TIME    =           1512140080 / Unix time (seconds)                            
MILLITIM=                  500 / Milliseconds since TIME                        
INTTIME =                  0.5 / Integration time (s)                           
```

`tests/data/1196175296_mwa_ord/adjusted_+1/1196175296_20171201145440_gpubox01_00.fits`

```txt                        
NAXIS1  =                66048 / length of data axis 1                          
NAXIS2  =                    2 / length of data axis 2                          
TIME    =           1512140081 / Unix time (seconds)                            
MILLITIM=                  500 / Milliseconds since TIME                        
INTTIME =                  0.5 / Integration time (s)                           
```

then we flag it with

```bash
cotter \
  -m tests/data/1196175296_mwa_ord/1196175296_cotter-friendly.metafits \
  -o "tests/data/1196175296_mwa_ord/adjusted_+1/FlagfileCotterMWA%%.mwaf" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-2ch-unitary.txt \
  -nostats \
  -sbcount 2 \
  -sbstart 1 \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  tests/data/1196175296_mwa_ord/adjusted_+1/1196175296_20171201145440_gpubox01_00.fits \
  tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox02_00.fits \
  tests/data/1196175296_mwa_ord/adjusted_+1/1196175296_20171201145540_gpubox01_01.fits \
  tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox02_01.fits \
  | tee cotter-1196175296-mwa_+1.log
```

```txt
Observation covers 200.32-1.41671e+20 MHz.
Output resolution: 0.5 s / 7680 kHz (time avg: 1x, freq avg: 1x).
The first 0 samples (0 s), last 0 samples (0 s) and 0 edge channels will be flagged.
Read subband passband, using 2 gains to correct for 2 subbands.
Using per-input subband gains. Average gains: 1.42542,1.44653
Subband order: 1,0
Observation's bandwidth is contiguous.
Only flags will be outputted.
All 4 scans fit in memory; no partitioning necessary.
=== Processing chunk 1 of 1 ===
There are 3 HDUs in file tests/data/1196175296_mwa_ord/1196175296_20171201145440_gpubox02_00.fits
There are 3 HDUs in file tests/data/1196175296_mwa_ord/adjusted_+1/1196175296_20171201145440_gpubox01_00.fits
Will stop on HDU 3.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
WARNING: start time according to raw files is 2017-12-01 14:54:40,
but meta files say 2017-12-01 14:54:38 !
Will use start time from raw file, which should be most accurate.
There are 3 HDUs in file tests/data/1196175296_mwa_ord/1196175296_20171201145540_gpubox02_01.fits
There are 3 HDUs in file tests/data/1196175296_mwa_ord/adjusted_+1/1196175296_20171201145540_gpubox01_01.fits
Will stop on HDU 3.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Wall-clock time in reading: 00:00:00.056873 processing: 00:00:00.108873 writing: 00:00:00.030254
```

*things to note:*

1512140080.000

the INTTIME is 0.5 and the start times are 1512140080.000 and 1512140080.500. 
Cotter seems to ignore MILLITIME when calculating the time difference, and think the difference is 0.
It does not correct for the offset at all.

## 1247842824_vis offset 01_00 by -2

```bash
python3 tests/data/adjust_gpufits.py \
  --in-file=/mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits \
  --out-file=/mnt/data/1247842824_vis/adjusted_+2/1247842824_20190722150008_gpubox01_00.fits \
  --corr-type=MWA_ORD --timestep-offset=-2

python3 tests/data/dump_metafits.py \
    /mnt/data/1247842824_vis/1247842824.metafits \
    | tee /mnt/data/1247842824_vis/1247842824.metafits.txt
python3 tests/data/dump_gpufits.py \
    /mnt/data/1247842824_vis/adjusted_-2/1247842824_20190722150008_gpubox01_00.fits \
    --corr-type=MWA_ORD \
    | tee /mnt/data/1247842824_vis/adjusted_-2/1247842824_20190722150008_gpubox01_00.fits.txt
python3 tests/data/dump_gpufits.py \
    /mnt/data/1247842824_vis/adjusted_+2/1247842824_20190722150008_gpubox01_00.fits \
    --corr-type=MWA_ORD \
    | tee /mnt/data/1247842824_vis/adjusted_+2/1247842824_20190722150008_gpubox01_00.fits.txt
```

```bash
cotter \
  -m /mnt/data/1247842824_vis/1247842824.metafits \
  -o "/mnt/data/1247842824_vis/FlagfileCotterMWA%%.mwaf" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-128ch-unitary.txt \
  -nostats \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits \
  | tee cotter-1247842824_vis_mwa.log
```

```txt
Running Cotter MWA preprocessing pipeline, version 4.5 (2020-08-10).
Flagging is performed by AOFlagger 3.1 (2021-03-03).
Input filenames succesfully parsed: using 24 files covering 1 timeranges from 24 GPU boxes.
Detected 62.8 GB of system memory.
Ignored keyword: ATTEN_DB
Ignored keyword: CALIBSRC
Ignored keyword: CHANSEL
Ignored keyword: INSTRUME
Ignored keyword: QUACKTIM
Ignored keyword: GOODTIME
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: HISTORY
Ignored keyword: HISTORY
Ignored keyword: HISTORY
Observation covers 132.48-163.19 MHz.
Output resolution: 1 s / 10 kHz (time avg: 1x, freq avg: 1x).
The first 0 samples (0 s), last 0 samples (0 s) and 0 edge channels will be flagged.
Read subband passband, using 128 gains to correct for 24 subbands.
Using per-input subband gains. Average gains: 1.21216,1.18396,1.16772,1.14526,1.14258,1.13733,1.13586,1.1344,1.12866,1.11157,1.08911,1.0708,1.04919,1.03931,1.02917,1.03406,1.03662,1.03528,1.0332,1.02271,1.01282,1.00232,0.997559,1
Subband order: 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23
Observation's bandwidth is contiguous.
Only flags will be outputted.
Observation does not fit fully in memory, will partition data in 2 chunks of at least 60 scans.
=== Processing chunk 1 of 2 ===
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits
Will stop on HDU 61.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
WARNING: start time according to raw files is 2019-07-22 15:00:07,
but meta files say 2019-07-22 15:00:06 !
Will use start time from raw file, which should be most accurate.
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
=== Processing chunk 2 of 2 ===
Warning: header specifies 120 scans, but there are only 60 in the data.
Last 60 scan(s) will be flagged.
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Wall-clock time in reading: 00:08:21.249435 processing: 00:02:59.046599 writing: 00:00:41.928586
```

dump flags

```bash
python3 tests/data/dump_mwaf.py \
    --timestep-limit=0 --baseline-limit=3 \
    /mnt/data/1247842824_vis/FlagfileCotterMWA_2ch01.mwaf \
    | tee /mnt/data/1247842824_vis/FlagfileCotterMWA_2ch01.mwaf.txt
```

```txt

Filename: /mnt/data/1247842824_vis/FlagfileCotterMWA_2ch01.mwaf
No.    Name      Ver    Type      Cards   Dimensions   Format
  0  PRIMARY       1 PrimaryHDU      15   ()      
  1                1 BinTableHDU     10   990720R x 1C   [128X]   

HEADER

SIMPLE  =                    T / file does conform to FITS standard             
BITPIX  =                    8 / number of bits per data pixel                  
NAXIS   =                    0 / number of data axes                            
EXTEND  =                    T / FITS dataset may contain extensions            
COMMENT   FITS (Flexible Image Transport System) format is defined in 'Astronomy
COMMENT   and Astrophysics', volume 376, page 359; bibcode: 2001A&A...376..359H 
VERSION = '1.0     '                                                            
GPSTIME =           1247842824                                                  
NCHANS  =                  128                                                  
NANTENNA=                  128                                                  
NSCANS  =                  120                                                  
NPOLS   =                    1                                                  
GPUBOXNO=                    1                                                  
COTVER  = '4.5     '                                                            
COTVDATE= '2020-08-10'                                                          
 -> num baselines: 8256

FLAG DATA

XTENSION= 'BINTABLE'           / binary table extension                         
BITPIX  =                    8 / 8-bit bytes                                    
NAXIS   =                    2 / 2-dimensional binary table                     
NAXIS1  =                   16 / width of table in bytes                        
NAXIS2  =               990720 / number of rows in table                        
PCOUNT  =                    0 / size of special data area                      
GCOUNT  =                    1 / one data group (required keyword)              
TFIELDS =                    1 / number of fields in each row                   
TTYPE1  = 'FLAGS   '           / label for field   1                            
TFORM1  = '128X    '           / data format of field: BIT                      
-> limits: baseline=3, timestep=120
-> bl 0000:
 --> ts 0000: ................................................................................................................................
 --> ts 0001: ................................................................................................................................
 --> ts 0002: ................................................................................................................................
 --> ts 0003: ................................................................................................................................
 --> ts 0004: ................................................................................................................................
 --> ts 0005: ................................................................................................................................
 --> ts 0006: ................................................................................................................................
 --> ts 0007: ................................................................................................................................
 --> ts 0008: ................................................................................................................................
 --> ts 0009: ................................................................................................................................
 --> ts 0010: ................................................................................................................................
 --> ts 0011: ................................................................................................................................
 --> ts 0012: ................................................................................................................................
 --> ts 0013: ................................................................................................................................
 --> ts 0014: ................................................................................................................................
 --> ts 0015: ................................................................................................................................
 --> ts 0016: ................................................................................................................................
 --> ts 0017: ................................................................................................................................
 --> ts 0018: ................................................................................................................................
 --> ts 0019: ................................................................................................................................
 --> ts 0020: ................................................................................................................................
 --> ts 0021: ................................................................................................................................
 --> ts 0022: ................................................................................................................................
 --> ts 0023: ................................................................................................................................
 --> ts 0024: ................................................................................................................................
 --> ts 0025: ................................................................................................................................
 --> ts 0026: ................................................................................................................................
 --> ts 0027: ................................................................................................................................
 --> ts 0028: ................................................................................................................................
 --> ts 0029: ................................................................................................................................
 --> ts 0030: ................................................................................................................................
 --> ts 0031: ................................................................................................................................
 --> ts 0032: ................................................................................................................................
 --> ts 0033: ................................................................................................................................
 --> ts 0034: ................................................................................................................................
 --> ts 0035: ................................................................................................................................
 --> ts 0036: ................................................................................................................................
 --> ts 0037: ................................................................................................................................
 --> ts 0038: ................................................................................................................................
 --> ts 0039: ................................................................................................................................
 --> ts 0040: ................................................................................................................................
 --> ts 0041: ................................................................................................................................
 --> ts 0042: ................................................................................................................................
 --> ts 0043: ................................................................................................................................
 --> ts 0044: ................................................................................................................................
 --> ts 0045: ................................................................................................................................
 --> ts 0046: ................................................................................................................................
 --> ts 0047: ................................................................................................................................
 --> ts 0048: ................................................................................................................................
 --> ts 0049: ................................................................................................................................
 --> ts 0050: ................................................................................................................................
 --> ts 0051: ................................................................................................................................
 --> ts 0052: ................................................................................................................................
 --> ts 0053: ................................................................................................................................
 --> ts 0054: ................................................................................................................................
 --> ts 0055: ................................................................................................................................
 --> ts 0056: ................................................................................................................................
 --> ts 0057: ................................................................................................................................
 --> ts 0058: ................................................................................................................................
 --> ts 0059: ................................................................................................................................
 --> ts 0060: ################################################################################################################################
 --> ts 0061: ################################################################################################################################
 --> ts 0062: ################################################################################################################################
 --> ts 0063: ################################################################################################################################
 --> ts 0064: ################################################################################################################################
 --> ts 0065: ################################################################################################################################
 --> ts 0066: ################################################################################################################################
 --> ts 0067: ################################################################################################################################
 --> ts 0068: ################################################################################################################################
 --> ts 0069: ################################################################################################################################
 --> ts 0070: ################################################################################################################################
 --> ts 0071: ################################################################################################################################
 --> ts 0072: ################################################################################################################################
 --> ts 0073: ################################################################################################################################
 --> ts 0074: ################################################################################################################################
 --> ts 0075: ################################################################################################################################
 --> ts 0076: ################################################################################################################################
 --> ts 0077: ################################################################################################################################
 --> ts 0078: ################################################################################################################################
 --> ts 0079: ################################################################################################################################
 --> ts 0080: ################################################################################################################################
 --> ts 0081: ################################################################################################################################
 --> ts 0082: ################################################################################################################################
 --> ts 0083: ################################################################################################################################
 --> ts 0084: ################################################################################################################################
 --> ts 0085: ################################################################################################################################
 --> ts 0086: ################################################################################################################################
 --> ts 0087: ################################################################################################################################
 --> ts 0088: ################################################################################################################################
 --> ts 0089: ################################################################################################################################
 --> ts 0090: ################################################################################################################################
 --> ts 0091: ################################################################################################################################
 --> ts 0092: ################################################################################################################################
 --> ts 0093: ################################################################################################################################
 --> ts 0094: ################################################################################################################################
 --> ts 0095: ################################################################################################################################
 --> ts 0096: ################################################################################################################################
 --> ts 0097: ################################################################################################################################
 --> ts 0098: ################################################################################################################################
 --> ts 0099: ################################################################################################################################
 --> ts 0100: ################################################################################################################################
 --> ts 0101: ################################################################################################################################
 --> ts 0102: ################################################################################################################################
 --> ts 0103: ################################################################################################################################
 --> ts 0104: ################################################################################################################################
 --> ts 0105: ################################################################################################################################
 --> ts 0106: ################################################################################################################################
 --> ts 0107: ################################################################################################################################
 --> ts 0108: ################################################################################################################################
 --> ts 0109: ################################################################################################################################
 --> ts 0110: ################################################################################################################################
 --> ts 0111: ################################################################################################################################
 --> ts 0112: ################################################################################################################################
 --> ts 0113: ################################################################################################################################
 --> ts 0114: ################################################################################################################################
 --> ts 0115: ################################################################################################################################
 --> ts 0116: ################################################################################################################################
 --> ts 0117: ################################################################################################################################
 --> ts 0118: ################################################################################################################################
 --> ts 0119: ################################################################################################################################
-> bl 0001:
 --> ts 0000: .....................................#..........................................................................................
 --> ts 0001: ............................................................................##..................................................
 --> ts 0002: .......................................#........................................................................................
 --> ts 0003: ......................#.................................................................#.......................................
 --> ts 0004: ...................................................................................................#............................
 --> ts 0005: .............................##....................................................................#............................
 --> ts 0006: ................................................................................................................................
 --> ts 0007: ...........................#....................#...............................................................................
 --> ts 0008: ................................................................................................................................
 --> ts 0009: ................................................................................................................................
 --> ts 0010: ................................#...............................................................................................
 --> ts 0011: ................................#....................................#.#........................................................
 --> ts 0012: .....................................................................#..........................................................
 --> ts 0013: .............................................................................................#...........#......................
 --> ts 0014: ................................................................#............................#..................................
 --> ts 0015: ..........................................................................................#.....................................
 --> ts 0016: ...........................................................#...#..........................#..............#......................
 --> ts 0017: ...............................................................#.....................#..........................................
 --> ts 0018: ....#..................................#........................................................................................
 --> ts 0019: ....#........................................##.................#...............................................................
 --> ts 0020: ....#........................................##..........................#......................................................
 --> ts 0021: ....#......................#..................#..........................#......................................................
 --> ts 0022: ..............................................#.................................................................................
 --> ts 0023: ..............................................#................##...............................................................
 --> ts 0024: ..............................................#.................................................................................
 --> ts 0025: ................................................................................................................................
 --> ts 0026: ................................................................................................................................
 --> ts 0027: ....#......................................#....................................................................................
 --> ts 0028: ....#...............................................#..........#................................................................
 --> ts 0029: ....#.................#.................................................................................#.......................
 --> ts 0030: ....#...................................................................................................#.......................
 --> ts 0031: ....#........................................................................................#..................................
 --> ts 0032: ....#...........................................................................................................................
 --> ts 0033: .....................#...................##..................................##.................................................
 --> ts 0034: ................................................................................................................................
 --> ts 0035: ................................................................................................................................
 --> ts 0036: .........................................................................................................#......................
 --> ts 0037: ................................................................................................................................
 --> ts 0038: ....#...........................................................................................................................
 --> ts 0039: ....#.......................................#...................................................................................
 --> ts 0040: ....#....................................................#......................................................................
 --> ts 0041: ....#..................................................................................................##.......................
 --> ts 0042: ....#...........................................................................................................................
 --> ts 0043: ....#......................................................#......................................#.............................
 --> ts 0044: ....#....................................##................................................##...................................
 --> ts 0045: ........................................#.......................................................................................
 --> ts 0046: ................................................#...............................................................................
 --> ts 0047: ................................................................................................................................
 --> ts 0048: .....................................................#..........................................................................
 --> ts 0049: .............................................................#..................................................................
 --> ts 0050: .............................................................#..#.................................#.............................
 --> ts 0051: ................................................................#.........................................##....................
 --> ts 0052: ................................................................................................................................
 --> ts 0053: ................................................................................................................#...............
 --> ts 0054: ................................................................................................................................
 --> ts 0055: ................................................................................................................................
 --> ts 0056: ............................................................................................................##..................
 --> ts 0057: .......................................................#........................#...............................................
 --> ts 0058: ................................................................................................................................
 --> ts 0059: ...................................................................................#............................................
 --> ts 0060: ################################################################################################################################
 --> ts 0061: ################################################################################################################################
 --> ts 0062: ################################################################################################################################
 --> ts 0063: ################################################################################################################################
 --> ts 0064: ################################################################################################################################
 --> ts 0065: ################################################################################################################################
 --> ts 0066: ################################################################################################################################
 --> ts 0067: ################################################################################################################################
 --> ts 0068: ################################################################################################################################
 --> ts 0069: ################################################################################################################################
 --> ts 0070: ################################################################################################################################
 --> ts 0071: ################################################################################################################################
 --> ts 0072: ################################################################################################################################
 --> ts 0073: ################################################################################################################################
 --> ts 0074: ################################################################################################################################
 --> ts 0075: ################################################################################################################################
 --> ts 0076: ################################################################################################################################
 --> ts 0077: ################################################################################################################################
 --> ts 0078: ################################################################################################################################
 --> ts 0079: ################################################################################################################################
 --> ts 0080: ################################################################################################################################
 --> ts 0081: ################################################################################################################################
 --> ts 0082: ################################################################################################################################
 --> ts 0083: ################################################################################################################################
 --> ts 0084: ################################################################################################################################
 --> ts 0085: ################################################################################################################################
 --> ts 0086: ################################################################################################################################
 --> ts 0087: ################################################################################################################################
 --> ts 0088: ################################################################################################################################
 --> ts 0089: ################################################################################################################################
 --> ts 0090: ################################################################################################################################
 --> ts 0091: ################################################################################################################################
 --> ts 0092: ################################################################################################################################
 --> ts 0093: ################################################################################################################################
 --> ts 0094: ################################################################################################################################
 --> ts 0095: ################################################################################################################################
 --> ts 0096: ################################################################################################################################
 --> ts 0097: ################################################################################################################################
 --> ts 0098: ################################################################################################################################
 --> ts 0099: ################################################################################################################################
 --> ts 0100: ################################################################################################################################
 --> ts 0101: ################################################################################################################################
 --> ts 0102: ################################################################################################################################
 --> ts 0103: ################################################################################################################################
 --> ts 0104: ################################################################################################################################
 --> ts 0105: ################################################################################################################################
 --> ts 0106: ################################################################################################################################
 --> ts 0107: ################################################################################################################################
 --> ts 0108: ################################################################################################################################
 --> ts 0109: ################################################################################################################################
 --> ts 0110: ################################################################################################################################
 --> ts 0111: ################################################################################################################################
 --> ts 0112: ################################################################################################################################
 --> ts 0113: ################################################################################################################################
 --> ts 0114: ################################################################################################################################
 --> ts 0115: ################################################################################################################################
 --> ts 0116: ################################################################################################################################
 --> ts 0117: ################################################################################################################################
 --> ts 0118: ################################################################################################################################
 --> ts 0119: ################################################################################################################################
```


```bash
python3 tests/data/dump_mwaf.py \
    --timestep-limit=0 --baseline-limit=3 \
    /mnt/data/1247842824_vis/FlagfileCotterMWA_2ch02.mwaf \
    | tee /mnt/data/1247842824_vis/FlagfileCotterMWA_2ch02.mwaf.txt
```

```txt
-> args {'file': '/mnt/data/1247842824_vis/FlagfileCotterMWA_2ch02.mwaf', 'timestep_limit': 12, 'baseline_limit': 12}
-> hdus.info():
Filename: /mnt/data/1247842824_vis/FlagfileCotterMWA_2ch02.mwaf
No.    Name      Ver    Type      Cards   Dimensions   Format
  0  PRIMARY       1 PrimaryHDU      15   ()      
  1                1 BinTableHDU     10   990720R x 1C   [128X]   

HEADER

SIMPLE  =                    T / file does conform to FITS standard             
BITPIX  =                    8 / number of bits per data pixel                  
NAXIS   =                    0 / number of data axes                            
EXTEND  =                    T / FITS dataset may contain extensions            
COMMENT   FITS (Flexible Image Transport System) format is defined in 'Astronomy
COMMENT   and Astrophysics', volume 376, page 359; bibcode: 2001A&A...376..359H 
VERSION = '1.0     '                                                            
GPSTIME =           1247842824                                                  
NCHANS  =                  128                                                  
NANTENNA=                  128                                                  
NSCANS  =                  120                                                  
NPOLS   =                    1                                                  
GPUBOXNO=                    2                                                  
COTVER  = '4.5     '                                                            
COTVDATE= '2020-08-10'                                                          
 -> num baselines: 8256

FLAG DATA

XTENSION= 'BINTABLE'           / binary table extension                         
BITPIX  =                    8 / 8-bit bytes                                    
NAXIS   =                    2 / 2-dimensional binary table                     
NAXIS1  =                   16 / width of table in bytes                        
NAXIS2  =               990720 / number of rows in table                        
PCOUNT  =                    0 / size of special data area                      
GCOUNT  =                    1 / one data group (required keyword)              
TFIELDS =                    1 / number of fields in each row                   
TTYPE1  = 'FLAGS   '           / label for field   1                            
TFORM1  = '128X    '           / data format of field: BIT                      
flags shape (990720,)
-> limits: baseline=3, timestep=120
-> bl 0000:
 --> ts 0000: ................................................................................................................................
 --> ts 0001: ................................................................................................................................
 --> ts 0002: ................................................................................................................................
 --> ts 0003: ................................................................................................................................
 --> ts 0004: ................................................................................................................................
 --> ts 0005: ................................................................................................................................
 --> ts 0006: ................................................................................................................................
 --> ts 0007: ................................................................................................................................
 --> ts 0008: ................................................................................................................................
 --> ts 0009: ................................................................................................................................
 --> ts 0010: ................................................................................................................................
 --> ts 0011: ................................................................................................................................
 --> ts 0012: ................................................................................................................................
 --> ts 0013: ................................................................................................................................
 --> ts 0014: ................................................................................................................................
 --> ts 0015: ................................................................................................................................
 --> ts 0016: ................................................................................................................................
 --> ts 0017: ................................................................................................................................
 --> ts 0018: ................................................................................................................................
 --> ts 0019: ................................................................................................................................
 --> ts 0020: ................................................................................................................................
 --> ts 0021: ................................................................................................................................
 --> ts 0022: ................................................................................................................................
 --> ts 0023: ................................................................................................................................
 --> ts 0024: ................................................................................................................................
 --> ts 0025: ................................................................................................................................
 --> ts 0026: ................................................................................................................................
 --> ts 0027: ................................................................................................................................
 --> ts 0028: ................................................................................................................................
 --> ts 0029: ................................................................................................................................
 --> ts 0030: ................................................................................................................................
 --> ts 0031: ................................................................................................................................
 --> ts 0032: ................................................................................................................................
 --> ts 0033: ................................................................................................................................
 --> ts 0034: ................................................................................................................................
 --> ts 0035: ................................................................................................................................
 --> ts 0036: ................................................................................................................................
 --> ts 0037: ................................................................................................................................
 --> ts 0038: ................................................................................................................................
 --> ts 0039: ................................................................................................................................
 --> ts 0040: ................................................................................................................................
 --> ts 0041: ................................................................................................................................
 --> ts 0042: ................................................................................................................................
 --> ts 0043: ................................................................................................................................
 --> ts 0044: ................................................................................................................................
 --> ts 0045: ................................................................................................................................
 --> ts 0046: ................................................................................................................................
 --> ts 0047: ................................................................................................................................
 --> ts 0048: ................................................................................................................................
 --> ts 0049: ................................................................................................................................
 --> ts 0050: ................................................................................................................................
 --> ts 0051: ................................................................................................................................
 --> ts 0052: ................................................................................................................................
 --> ts 0053: ................................................................................................................................
 --> ts 0054: ................................................................................................................................
 --> ts 0055: ................................................................................................................................
 --> ts 0056: ................................................................................................................................
 --> ts 0057: ................................................................................................................................
 --> ts 0058: ................................................................................................................................
 --> ts 0059: ................................................................................................................................
 --> ts 0060: ################################################################################################################################
 --> ts 0061: ################################################################################################################################
 --> ts 0062: ################################################################################################################################
 --> ts 0063: ################################################################################################################################
 --> ts 0064: ################################################################################################################################
 --> ts 0065: ################################################################################################################################
 --> ts 0066: ################################################################################################################################
 --> ts 0067: ################################################################################################################################
 --> ts 0068: ################################################################################################################################
 --> ts 0069: ################################################################################################################################
 --> ts 0070: ################################################################################################################################
 --> ts 0071: ################################################################################################################################
 --> ts 0072: ################################################################################################################################
 --> ts 0073: ################################################################################################################################
 --> ts 0074: ################################################################################################################################
 --> ts 0075: ################################################################################################################################
 --> ts 0076: ################################################################################################################################
 --> ts 0077: ################################################################################################################################
 --> ts 0078: ################################################################################################################################
 --> ts 0079: ################################################################################################################################
 --> ts 0080: ################################################################################################################################
 --> ts 0081: ################################################################################################################################
 --> ts 0082: ################################################################################################################################
 --> ts 0083: ################################################################################################################################
 --> ts 0084: ################################################################################################################################
 --> ts 0085: ################################################################################################################################
 --> ts 0086: ################################################################################################################################
 --> ts 0087: ################################################################################################################################
 --> ts 0088: ################################################################################################################################
 --> ts 0089: ################################################################################################################################
 --> ts 0090: ################################################################################################################################
 --> ts 0091: ################################################################################################################################
 --> ts 0092: ################################################################################################################################
 --> ts 0093: ################################################################################################################################
 --> ts 0094: ################################################################################################################################
 --> ts 0095: ################################################################################################################################
 --> ts 0096: ################################################################################################################################
 --> ts 0097: ################################################################################################################################
 --> ts 0098: ################################################################################################################################
 --> ts 0099: ################################################################################################################################
 --> ts 0100: ################################################################################################################################
 --> ts 0101: ################################################################################################################################
 --> ts 0102: ################################################################################################################################
 --> ts 0103: ################################################################################################################################
 --> ts 0104: ################################################################################################################################
 --> ts 0105: ################################################################################################################################
 --> ts 0106: ################################################################################################################################
 --> ts 0107: ################################################################################################################################
 --> ts 0108: ################################################################################################################################
 --> ts 0109: ################################################################################################################################
 --> ts 0110: ################################################################################################################################
 --> ts 0111: ################################################################################################################################
 --> ts 0112: ################################################################################################################################
 --> ts 0113: ################################################################################################################################
 --> ts 0114: ################################################################################################################################
 --> ts 0115: ################################################################################################################################
 --> ts 0116: ################################################################################################################################
 --> ts 0117: ################################################################################################################################
 --> ts 0118: ################################################################################################################################
 --> ts 0119: ################################################################################################################################
-> bl 0001:
 --> ts 0000: ............................##...................#..............................................................................
 --> ts 0001: ............................................................#...................................................................
 --> ts 0002: .............................................#..................................................................................
 --> ts 0003: .....................#...............................................................................#..........................
 --> ts 0004: .....................#..............................................................................#...........................
 --> ts 0005: ...............................................##.#.................................................#...........................
 --> ts 0006: ................................................................................................................................
 --> ts 0007: .....................#..........................................................................................................
 --> ts 0008: .....................#.........................#................#...............................................................
 --> ts 0009: ...............................................#...........#....................................................................
 --> ts 0010: ...............................................#................#...............................................................
 --> ts 0011: ...............................................#.....##......#..................................................................
 --> ts 0012: .............................................#.#.............#..................................................................
 --> ts 0013: ...............................................#................................................................................
 --> ts 0014: .............................#.................#......................................................##........................
 --> ts 0015: ...............................................#.........................................................#......................
 --> ts 0016: ......................#........................#.........................................................#......................
 --> ts 0017: ...............................................#...............#..........................#.....................................
 --> ts 0018: ....#..........................................#................................................................................
 --> ts 0019: ....#..........................................#................................................##..............................
 --> ts 0020: ....#..........................................#................................................................................
 --> ts 0021: ....#..........................................#................................................................................
 --> ts 0022: ...............................................#................................................................................
 --> ts 0023: ...............................................#..#.............................................................................
 --> ts 0024: ...............................................#................................................................................
 --> ts 0025: ...............................................#................................................................................
 --> ts 0026: ...............................................#................#...............................................................
 --> ts 0027: ....#..........................................#................#...............................................................
 --> ts 0028: ....#..........................................#................#...............................................................
 --> ts 0029: ....#....................................##....#................#......................................#........................
 --> ts 0030: ....#...........................................................#...............................................................
 --> ts 0031: ....#...............................................##..........#...............................................................
 --> ts 0032: ....#...........................................................#...............................................................
 --> ts 0033: ...............................................................##...............................................................
 --> ts 0034: ................................................................#...............................................................
 --> ts 0035: ................................................................#...............................................................
 --> ts 0036: ................................................................#...............................................................
 --> ts 0037: ................................................................#...............................................................
 --> ts 0038: ....#.......................................................................#...................................................
 --> ts 0039: ....#...........................................................................................................................
 --> ts 0040: ....#............................................#..............................................................................
 --> ts 0041: ....#........................................................................##.................................................
 --> ts 0042: ....#...........................................................................................................................
 --> ts 0043: ....#........................................................##.................................................................
 --> ts 0044: ....#...........................................................................................................................
 --> ts 0045: ................................................................................................................................
 --> ts 0046: .................................#.........................................................................##...................
 --> ts 0047: ................................................................................................................................
 --> ts 0048: .......................................................#..........##......#.....................................................
 --> ts 0049: ..........................................................................#.....................................................
 --> ts 0050: .................#................#............................................................................#................
 --> ts 0051: ................................................................................................................................
 --> ts 0052: ................................................................................##..............................................
 --> ts 0053: ............................................#.......................................................#...........................
 --> ts 0054: ....................................................................................................#...........................
 --> ts 0055: ....................................................................................................#...........................
 --> ts 0056: ....................................................................................................#.#.........................
 --> ts 0057: ....................................................................................................#...........................
 --> ts 0058: .........................#.............#............................................................#...........................
 --> ts 0059: ....................................................................................................#...........................
 --> ts 0060: ################################################################################################################################
 --> ts 0061: ################################################################################################################################
 --> ts 0062: ################################################################################################################################
 --> ts 0063: ################################################################################################################################
 --> ts 0064: ################################################################################################################################
 --> ts 0065: ################################################################################################################################
 --> ts 0066: ################################################################################################################################
 --> ts 0067: ################################################################################################################################
 --> ts 0068: ################################################################################################################################
 --> ts 0069: ################################################################################################################################
 --> ts 0070: ################################################################################################################################
 --> ts 0071: ################################################################################################################################
 --> ts 0072: ################################################################################################################################
 --> ts 0073: ################################################################################################################################
 --> ts 0074: ################################################################################################################################
 --> ts 0075: ################################################################################################################################
 --> ts 0076: ################################################################################################################################
 --> ts 0077: ################################################################################################################################
 --> ts 0078: ################################################################################################################################
 --> ts 0079: ################################################################################################################################
 --> ts 0080: ################################################################################################################################
 --> ts 0081: ################################################################################################################################
 --> ts 0082: ################################################################################################################################
 --> ts 0083: ################################################################################################################################
 --> ts 0084: ################################################################################################################################
 --> ts 0085: ################################################################################################################################
 --> ts 0086: ################################################################################################################################
 --> ts 0087: ################################################################################################################################
 --> ts 0088: ################################################################################################################################
 --> ts 0089: ################################################################################################################################
 --> ts 0090: ################################################################################################################################
 --> ts 0091: ################################################################################################################################
 --> ts 0092: ################################################################################################################################
 --> ts 0093: ################################################################################################################################
 --> ts 0094: ################################################################################################################################
 --> ts 0095: ################################################################################################################################
 --> ts 0096: ################################################################################################################################
 --> ts 0097: ################################################################################################################################
 --> ts 0098: ################################################################################################################################
 --> ts 0099: ################################################################################################################################
 --> ts 0100: ################################################################################################################################
 --> ts 0101: ################################################################################################################################
 --> ts 0102: ################################################################################################################################
 --> ts 0103: ################################################################################################################################
 --> ts 0104: ################################################################################################################################
 --> ts 0105: ################################################################################################################################
 --> ts 0106: ################################################################################################################################
 --> ts 0107: ################################################################################################################################
 --> ts 0108: ################################################################################################################################
 --> ts 0109: ################################################################################################################################
 --> ts 0110: ################################################################################################################################
 --> ts 0111: ################################################################################################################################
 --> ts 0112: ################################################################################################################################
 --> ts 0113: ################################################################################################################################
 --> ts 0114: ################################################################################################################################
 --> ts 0115: ################################################################################################################################
 --> ts 0116: ################################################################################################################################
 --> ts 0117: ################################################################################################################################
 --> ts 0118: ################################################################################################################################
 --> ts 0119: ################################################################################################################################
-> bl 0002:
 --> ts 0000: ................................................................#...............................................................
 --> ts 0001: .......................................................#........#...............................................................
 --> ts 0002: .......................................................#........#.....................#............#............................
 --> ts 0003: .......................................................#........#.....................#................#........................
 --> ts 0004: .....................................................#.#........#...............................................................
 --> ts 0005: .....................................................#..........#...............................................................
 --> ts 0006: .....................................................#..........#.............................................#.................
 --> ts 0007: .....................................................#..........#.............................................#.................
 --> ts 0008: .....................................................#..........#...............................................................
 --> ts 0009: .....................................................#..........#........................................#......................
 --> ts 0010: ................................................................#........................................#......................
 --> ts 0011: ................................................................#.....................####......................................
 --> ts 0012: .......................####.....................................#...............................................................
 --> ts 0013: ................................................................#...............#...............................................
 --> ts 0014: ...............................#....#.......#...................#...............................................................
 --> ts 0015: ....................................#.......#...................#...............................................................
 --> ts 0016: ................................................................#...............................................................
 --> ts 0017: ..................................................####..........#...............................................................
 --> ts 0018: ....#...........................................................#...............................................................
 --> ts 0019: ....#...........................................................#...............................................................
 --> ts 0020: ....#...........................................................#...............................................................
 --> ts 0021: ....#.................#.........................................#...............................................................
 --> ts 0022: ................................................................#...............................................................
 --> ts 0023: ................................................................#..........................................#....................
 --> ts 0024: ................................................................#...............................................................
 --> ts 0025: ............................#...................................#...............................................................
 --> ts 0026: ................................................................#...............................................................
 --> ts 0027: ....#.................................#...........#.............#...............................................................
 --> ts 0028: ....#......................#....................................#...............................................................
 --> ts 0029: ....#......................#..............#.....................#...............................................................
 --> ts 0030: ....#......................#..............#.....................#....................#..........................................
 --> ts 0031: ....#......................#..............#.#...................#....................#..#.......................................
 --> ts 0032: ....#......................#..............#..#..................#...............................................................
 --> ts 0033: ...........................#......#.......#.....................#...............................................................
 --> ts 0034: ..........................................#.....................#...............................................................
 --> ts 0035: ................................................................#.........................................##....................
 --> ts 0036: ................................................................#...............................................................
 --> ts 0037: ................................................................#...............................................................
 --> ts 0038: ....#...........................................................#...............................................................
 --> ts 0039: ....#...........................................................#...............................................................
 --> ts 0040: ....#...........................................................#...............................................................
 --> ts 0041: ....#...........................................................#...................#...........................................
 --> ts 0042: ....#...........................................................#...........##......#...........................................
 --> ts 0043: ....#...........................................................#...............................................................
 --> ts 0044: ....#...........................................................#...............................................................
 --> ts 0045: ................................................................#...............................................................
 --> ts 0046: ................................................................#........................................#......................
 --> ts 0047: ....................................#...........................#...............................................................
 --> ts 0048: ......................#.......##................................#...............................................................
 --> ts 0049: ................................................................#.......................#.......................................
 --> ts 0050: ........................................................#.......#...............................................................
 --> ts 0051: ........................................................#.......#...............................................................
 --> ts 0052: ................................................................#...............................................................
 --> ts 0053: ................................................................#..#............................................................
 --> ts 0054: .....................................#...............#..........#...............................................................
 --> ts 0055: ........................#............#...............#..........#...............................................................
 --> ts 0056: ........................#.......................................#...............................................................
 --> ts 0057: ....................................................#...........##..............................................................
 --> ts 0058: ................................................................#...............................................................
 --> ts 0059: .......................................#........................#...............................................................
 --> ts 0060: ################################################################################################################################
 --> ts 0061: ################################################################################################################################
 --> ts 0062: ################################################################################################################################
 --> ts 0063: ################################################################################################################################
 --> ts 0064: ################################################################################################################################
 --> ts 0065: ################################################################################################################################
 --> ts 0066: ################################################################################################################################
 --> ts 0067: ################################################################################################################################
 --> ts 0068: ################################################################################################################################
 --> ts 0069: ################################################################################################################################
 --> ts 0070: ################################################################################################################################
 --> ts 0071: ################################################################################################################################
 --> ts 0072: ################################################################################################################################
 --> ts 0073: ################################################################################################################################
 --> ts 0074: ################################################################################################################################
 --> ts 0075: ################################################################################################################################
 --> ts 0076: ################################################################################################################################
 --> ts 0077: ################################################################################################################################
 --> ts 0078: ################################################################################################################################
 --> ts 0079: ################################################################################################################################
 --> ts 0080: ################################################################################################################################
 --> ts 0081: ################################################################################################################################
 --> ts 0082: ################################################################################################################################
 --> ts 0083: ################################################################################################################################
 --> ts 0084: ################################################################################################################################
 --> ts 0085: ################################################################################################################################
 --> ts 0086: ################################################################################################################################
 --> ts 0087: ################################################################################################################################
 --> ts 0088: ################################################################################################################################
 --> ts 0089: ################################################################################################################################
 --> ts 0090: ################################################################################################################################
 --> ts 0091: ################################################################################################################################
 --> ts 0092: ################################################################################################################################
 --> ts 0093: ################################################################################################################################
 --> ts 0094: ################################################################################################################################
 --> ts 0095: ################################################################################################################################
 --> ts 0096: ################################################################################################################################
 --> ts 0097: ################################################################################################################################
 --> ts 0098: ################################################################################################################################
 --> ts 0099: ################################################################################################################################
 --> ts 0100: ################################################################################################################################
 --> ts 0101: ################################################################################################################################
 --> ts 0102: ################################################################################################################################
 --> ts 0103: ################################################################################################################################
 --> ts 0104: ################################################################################################################################
 --> ts 0105: ################################################################################################################################
 --> ts 0106: ################################################################################################################################
 --> ts 0107: ################################################################################################################################
 --> ts 0108: ################################################################################################################################
 --> ts 0109: ################################################################################################################################
 --> ts 0110: ################################################################################################################################
 --> ts 0111: ################################################################################################################################
 --> ts 0112: ################################################################################################################################
 --> ts 0113: ################################################################################################################################
 --> ts 0114: ################################################################################################################################
 --> ts 0115: ################################################################################################################################
 --> ts 0116: ################################################################################################################################
 --> ts 0117: ################################################################################################################################
 --> ts 0118: ################################################################################################################################
 --> ts 0119: ################################################################################################################################
```

adjust 01_00 by -2 * 1.0s

```bash
python3 tests/data/adjust_gpufits.py \
  --in-file=/mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits \
  --out-file=/mnt/data/1247842824_vis/adjusted_-2/1247842824_20190722150008_gpubox01_00.fits \
  --corr-type=MWA_ORD --timestep-offset=-2
```

```bash
cotter \
  -m /mnt/data/1247842824_vis/1247842824.metafits \
  -o "/mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA%%.mwaf" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-128ch-unitary.txt \
  -nostats \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  /mnt/data/1247842824_vis/adjusted_-2/1247842824_20190722150008_gpubox01_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits \
  | tee cotter-1247842824_vis_mwa_-2.log
```

```txt
Running Cotter MWA preprocessing pipeline, version 4.5 (2020-08-10).
Flagging is performed by AOFlagger 3.1 (2021-03-03).
Input filenames succesfully parsed: using 24 files covering 1 timeranges from 24 GPU boxes.
Detected 62.8 GB of system memory.
Ignored keyword: ATTEN_DB
Ignored keyword: CALIBSRC
Ignored keyword: CHANSEL
Ignored keyword: INSTRUME
Ignored keyword: QUACKTIM
Ignored keyword: GOODTIME
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: HISTORY
Ignored keyword: HISTORY
Ignored keyword: HISTORY
Observation covers 132.48-163.19 MHz.
Output resolution: 1 s / 10 kHz (time avg: 1x, freq avg: 1x).
The first 0 samples (0 s), last 0 samples (0 s) and 0 edge channels will be flagged.
Read subband passband, using 128 gains to correct for 24 subbands.
Using per-input subband gains. Average gains: 1.21216,1.18396,1.16772,1.14526,1.14258,1.13733,1.13586,1.1344,1.12866,1.11157,1.08911,1.0708,1.04919,1.03931,1.02917,1.03406,1.03662,1.03528,1.0332,1.02271,1.01282,1.00232,0.997559,1
Subband order: 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23
Observation's bandwidth is contiguous.
Only flags will be outputted.
Observation does not fit fully in memory, will partition data in 2 chunks of at least 60 scans.
=== Processing chunk 1 of 2 ===
There are 61 HDUs in file /mnt/data/1247842824_vis/adjusted_-2/1247842824_20190722150008_gpubox01_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits
WARNING: file number 2 of current time range has different start time!
Current file start time: 1563807607 previous file had: 1563807605.
Using start time of 1563807607 and aligning other files accordingly.
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits
HDU offsets per file: [2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
Will stop on HDU 61.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
WARNING: start time according to raw files is 2019-07-22 15:00:07,
but meta files say 2019-07-22 15:00:06 !
Will use start time from raw file, which should be most accurate.
Warning: header specifies 120 scans, but there are only 58 in the data.
Last 2 scan(s) will be flagged.
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
=== Processing chunk 2 of 2 ===
There are 61 HDUs in file /mnt/data/1247842824_vis/adjusted_-2/1247842824_20190722150008_gpubox01_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits
WARNING: file number 2 of current time range has different start time!
Current file start time: 1563807607 previous file had: 1563807605.
Using start time of 1563807607 and aligning other files accordingly.
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits
HDU offsets per file: [2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
Will stop on HDU 61.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Warning: header specifies 120 scans, but there are only 118 in the data.
Last 2 scan(s) will be flagged.
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Wall-clock time in reading: 00:13:13.406638 processing: 00:04:30.364367 writing: 00:00:48.137863
```

dump flags

```bash
python3 tests/data/dump_mwaf.py \
    --timestep-limit=0 --baseline-limit=3 \
    /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA01.mwaf \
    | tee /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA01.mwaf.txt
```

```txt
Filename: /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA01.mwaf
No.    Name      Ver    Type      Cards   Dimensions   Format
  0  PRIMARY       1 PrimaryHDU      15   ()      
  1                1 BinTableHDU     10   974208R x 1C   [128X]   

HEADER

SIMPLE  =                    T / file does conform to FITS standard             
BITPIX  =                    8 / number of bits per data pixel                  
NAXIS   =                    0 / number of data axes                            
EXTEND  =                    T / FITS dataset may contain extensions            
COMMENT   FITS (Flexible Image Transport System) format is defined in 'Astronomy
COMMENT   and Astrophysics', volume 376, page 359; bibcode: 2001A&A...376..359H 
VERSION = '1.0     '                                                            
GPSTIME =           1247842824                                                  
NCHANS  =                  128                                                  
NANTENNA=                  128                                                  
NSCANS  =                  120                                                  
NPOLS   =                    1                                                  
GPUBOXNO=                    1                                                  
COTVER  = '4.5     '                                                            
COTVDATE= '2020-08-10'                                                          
 -> num baselines: 8256

FLAG DATA

XTENSION= 'BINTABLE'           / binary table extension                         
BITPIX  =                    8 / 8-bit bytes                                    
NAXIS   =                    2 / 2-dimensional binary table                     
NAXIS1  =                   16 / width of table in bytes                        
NAXIS2  =               974208 / number of rows in table                        
PCOUNT  =                    0 / size of special data area                      
GCOUNT  =                    1 / one data group (required keyword)              
TFIELDS =                    1 / number of fields in each row                   
TTYPE1  = 'FLAGS   '           / label for field   1                            
TFORM1  = '128X    '           / data format of field: BIT                      
flags shape (974208,)
num_scans (120) * num_baselines(8256) != rows(974208)
actual num_scans: 118
-> limits: baseline=3, timestep=118
-> bl 0000:
 --> ts 0000: ................................................................................................................................
 --> ts 0001: ................................................................................................................................
 --> ts 0002: ................................................................................................................................
 --> ts 0003: ................................................................................................................................
 --> ts 0004: ................................................................................................................................
 --> ts 0005: ................................................................................................................................
 --> ts 0006: ................................................................................................................................
 --> ts 0007: ................................................................................................................................
 --> ts 0008: ................................................................................................................................
 --> ts 0009: ................................................................................................................................
 --> ts 0010: ................................................................................................................................
 --> ts 0011: ................................................................................................................................
 --> ts 0012: ................................................................................................................................
 --> ts 0013: ................................................................................................................................
 --> ts 0014: ................................................................................................................................
 --> ts 0015: ................................................................................................................................
 --> ts 0016: ................................................................................................................................
 --> ts 0017: ................................................................................................................................
 --> ts 0018: ................................................................................................................................
 --> ts 0019: ................................................................................................................................
 --> ts 0020: ................................................................................................................................
 --> ts 0021: ................................................................................................................................
 --> ts 0022: ................................................................................................................................
 --> ts 0023: ................................................................................................................................
 --> ts 0024: ................................................................................................................................
 --> ts 0025: ................................................................................................................................
 --> ts 0026: ................................................................................................................................
 --> ts 0027: ................................................................................................................................
 --> ts 0028: ................................................................................................................................
 --> ts 0029: ................................................................................................................................
 --> ts 0030: ................................................................................................................................
 --> ts 0031: ................................................................................................................................
 --> ts 0032: ................................................................................................................................
 --> ts 0033: ................................................................................................................................
 --> ts 0034: ................................................................................................................................
 --> ts 0035: ................................................................................................................................
 --> ts 0036: ................................................................................................................................
 --> ts 0037: ................................................................................................................................
 --> ts 0038: ................................................................................................................................
 --> ts 0039: ................................................................................................................................
 --> ts 0040: ................................................................................................................................
 --> ts 0041: ................................................................................................................................
 --> ts 0042: ................................................................................................................................
 --> ts 0043: ................................................................................................................................
 --> ts 0044: ................................................................................................................................
 --> ts 0045: ................................................................................................................................
 --> ts 0046: ................................................................................................................................
 --> ts 0047: ................................................................................................................................
 --> ts 0048: ................................................................................................................................
 --> ts 0049: ................................................................................................................................
 --> ts 0050: ................................................................................................................................
 --> ts 0051: ................................................................................................................................
 --> ts 0052: ................................................................................................................................
 --> ts 0053: ................................................................................................................................
 --> ts 0054: ................................................................................................................................
 --> ts 0055: ................................................................................................................................
 --> ts 0056: ################################################################################################################################
 --> ts 0057: ################################################################################################################################
 --> ts 0058: ................................................................................................................................
 --> ts 0059: ................................................................................................................................
 --> ts 0060: ................................................................................................................................
 --> ts 0061: ................................................................................................................................
 --> ts 0062: ................................................................................................................................
 --> ts 0063: ................................................................................................................................
 --> ts 0064: ................................................................................................................................
 --> ts 0065: ................................................................................................................................
 --> ts 0066: ................................................................................................................................
 --> ts 0067: ................................................................................................................................
 --> ts 0068: ................................................................................................................................
 --> ts 0069: ................................................................................................................................
 --> ts 0070: ................................................................................................................................
 --> ts 0071: ................................................................................................................................
 --> ts 0072: ................................................................................................................................
 --> ts 0073: ................................................................................................................................
 --> ts 0074: ................................................................................................................................
 --> ts 0075: ................................................................................................................................
 --> ts 0076: ................................................................................................................................
 --> ts 0077: ................................................................................................................................
 --> ts 0078: ................................................................................................................................
 --> ts 0079: ................................................................................................................................
 --> ts 0080: ................................................................................................................................
 --> ts 0081: ................................................................................................................................
 --> ts 0082: ................................................................................................................................
 --> ts 0083: ................................................................................................................................
 --> ts 0084: ................................................................................................................................
 --> ts 0085: ................................................................................................................................
 --> ts 0086: ................................................................................................................................
 --> ts 0087: ................................................................................................................................
 --> ts 0088: ................................................................................................................................
 --> ts 0089: ................................................................................................................................
 --> ts 0090: ................................................................................................................................
 --> ts 0091: ................................................................................................................................
 --> ts 0092: ................................................................................................................................
 --> ts 0093: ................................................................................................................................
 --> ts 0094: ................................................................................................................................
 --> ts 0095: ................................................................................................................................
 --> ts 0096: ................................................................................................................................
 --> ts 0097: ................................................................................................................................
 --> ts 0098: ................................................................................................................................
 --> ts 0099: ................................................................................................................................
 --> ts 0100: ................................................................................................................................
 --> ts 0101: ................................................................................................................................
 --> ts 0102: ................................................................................................................................
 --> ts 0103: ................................................................................................................................
 --> ts 0104: ................................................................................................................................
 --> ts 0105: ................................................................................................................................
 --> ts 0106: ................................................................................................................................
 --> ts 0107: ................................................................................................................................
 --> ts 0108: ................................................................................................................................
 --> ts 0109: ................................................................................................................................
 --> ts 0110: ................................................................................................................................
 --> ts 0111: ................................................................................................................................
 --> ts 0112: ................................................................................................................................
 --> ts 0113: ................................................................................................................................
 --> ts 0114: ................................................................................................................................
 --> ts 0115: ................................................................................................................................
 --> ts 0116: ################################################################################################################################
 --> ts 0117: ################################################################################################################################
-> bl 0001:
 --> ts 0000: ...................................................................................................#............................
 --> ts 0001: .............................##....................................................................#............................
 --> ts 0002: ................................................................................................................................
 --> ts 0003: ...........................#....................#...............................................................................
 --> ts 0004: ................................................................................................................................
 --> ts 0005: ................................................................................................................................
 --> ts 0006: ................................#...............................................................................................
 --> ts 0007: ................................#....................................#.#........................................................
 --> ts 0008: .....................................................................#..........................................................
 --> ts 0009: .............................................................................................#...........#......................
 --> ts 0010: ................................................................#............................#..................................
 --> ts 0011: ..........................................................................................#.....................................
 --> ts 0012: ...........................................................#...#..........................#..............#......................
 --> ts 0013: ...............................................................#.....................#..........................................
 --> ts 0014: ....#..................................#........................................................................................
 --> ts 0015: ....#........................................#..................#...............................................................
 --> ts 0016: ....#........................................##..........................#......................................................
 --> ts 0017: ....#......................#..................#..........................#......................................................
 --> ts 0018: ..............................................#.................................................................................
 --> ts 0019: ..............................................#................##...............................................................
 --> ts 0020: ................................................................................................................................
 --> ts 0021: ................................................................................................................................
 --> ts 0022: ................................................................................................................................
 --> ts 0023: ....#......................................#....................................................................................
 --> ts 0024: ....#...............................................#..........#................................................................
 --> ts 0025: ....#.................#.................................................................................#.......................
 --> ts 0026: ....#...................................................................................................#.......................
 --> ts 0027: ....#........................................................................................#..................................
 --> ts 0028: ....#...........................................................................................................................
 --> ts 0029: .....................#...................##..................................##.................................................
 --> ts 0030: ................................................................................................................................
 --> ts 0031: ................................................................................................................................
 --> ts 0032: .........................................................................................................#......................
 --> ts 0033: ................................................................................................................................
 --> ts 0034: ....#...........................................................................................................................
 --> ts 0035: ....#.......................................#...................................................................................
 --> ts 0036: ....#....................................................#......................................................................
 --> ts 0037: ....#..................................................................................................##.......................
 --> ts 0038: ....#...........................................................................................................................
 --> ts 0039: ....#......................................................#......................................#.............................
 --> ts 0040: ....#....................................##................................................##...................................
 --> ts 0041: ........................................#.......................................................................................
 --> ts 0042: ................................................#...............................................................................
 --> ts 0043: ................................................................................................................................
 --> ts 0044: .....................................................#..........................................................................
 --> ts 0045: .............................................................#..................................................................
 --> ts 0046: .............................................................#..#.................................#.............................
 --> ts 0047: ................................................................#.........................................##....................
 --> ts 0048: ................................................................................................................................
 --> ts 0049: ................................................................................................................#...............
 --> ts 0050: ................................................................................................................................
 --> ts 0051: ................................................................................................................................
 --> ts 0052: ............................................................................................................##..................
 --> ts 0053: .......................................................#........................#...............................................
 --> ts 0054: ................................................................................................................................
 --> ts 0055: ...................................................................................#............................................
 --> ts 0056: ################################################################################################################################
 --> ts 0057: ################################################################################################################################
 --> ts 0058: .......................................#..........................................................................#.............
 --> ts 0059: ......................#.................................................................#.......................................
 --> ts 0060: ...................................................................................................#............................
 --> ts 0061: .............................##....................................................................#............................
 --> ts 0062: ................................................................................................................................
 --> ts 0063: ...........................#....................#...............................................................................
 --> ts 0064: ................................................................................................................................
 --> ts 0065: ................................................................................................................................
 --> ts 0066: ................................#...............................................................................................
 --> ts 0067: ................................#....................................#.#........................................................
 --> ts 0068: .....................................................................#..........................................................
 --> ts 0069: .............................................................................................#...........#......................
 --> ts 0070: ................................................................#............................#..................................
 --> ts 0071: ..........................................................................................#.....................................
 --> ts 0072: ...........................................................#...#..........................#..............#......................
 --> ts 0073: ...............................................................#.....................#..........................................
 --> ts 0074: ....#..................................#........................................................................................
 --> ts 0075: ....#........................................#..................#...............................................................
 --> ts 0076: ....#........................................##..........................#......................................................
 --> ts 0077: ....#......................#..................#..........................#......................................................
 --> ts 0078: ..............................................#.................................................................................
 --> ts 0079: ..............................................#................##...............................................................
 --> ts 0080: ................................................................................................................................
 --> ts 0081: ................................................................................................................................
 --> ts 0082: ................................................................................................................................
 --> ts 0083: ....#......................................#....................................................................................
 --> ts 0084: ....#...............................................#..........#................................................................
 --> ts 0085: ....#.................#.................................................................................#.......................
 --> ts 0086: ....#...................................................................................................#.......................
 --> ts 0087: ....#........................................................................................#..................................
 --> ts 0088: ....#...........................................................................................................................
 --> ts 0089: .....................#...................##..................................##.................................................
 --> ts 0090: ................................................................................................................................
 --> ts 0091: ................................................................................................................................
 --> ts 0092: .........................................................................................................#......................
 --> ts 0093: ................................................................................................................................
 --> ts 0094: ....#...........................................................................................................................
 --> ts 0095: ....#.......................................#...................................................................................
 --> ts 0096: ....#....................................................#......................................................................
 --> ts 0097: ....#..................................................................................................##.......................
 --> ts 0098: ....#...........................................................................................................................
 --> ts 0099: ....#......................................................#......................................#.............................
 --> ts 0100: ....#....................................##................................................##...................................
 --> ts 0101: ........................................#.......................................................................................
 --> ts 0102: ................................................#...............................................................................
 --> ts 0103: ................................................................................................................................
 --> ts 0104: .....................................................#..........................................................................
 --> ts 0105: .............................................................#..................................................................
 --> ts 0106: .............................................................#..#.................................#.............................
 --> ts 0107: ................................................................#.........................................##....................
 --> ts 0108: ................................................................................................................................
 --> ts 0109: ................................................................................................................#...............
 --> ts 0110: ................................................................................................................................
 --> ts 0111: ................................................................................................................................
 --> ts 0112: ............................................................................................................##..................
 --> ts 0113: .......................................................#........................#...............................................
 --> ts 0114: ................................................................................................................................
 --> ts 0115: ...................................................................................#............................................
 --> ts 0116: ################################################################################################################################
 --> ts 0117: ################################################################################################################################
-> bl 0002:
 --> ts 0000: ..............................................................#.................................................................
 --> ts 0001: ..............................................................#.#...............................................................
 --> ts 0002: ..............................................................#.#...............................................................
 --> ts 0003: ................................................................#.....................#.........................................
 --> ts 0004: ................................................................#...............................................................
 --> ts 0005: ................................................................#...............................................................
 --> ts 0006: ................................................................#...............................................................
 --> ts 0007: ................................................................#.....................#.........................................
 --> ts 0008: ................................................................#...............................................................
 --> ts 0009: ................................................................#...............................................................
 --> ts 0010: ................................................................#...............................................................
 --> ts 0011: ................................................................#.................#.............................................
 --> ts 0012: ................................................................#...............................................................
 --> ts 0013: ..............................................................................#.................................................
 --> ts 0014: ....#.....................................................................................................#.....................
 --> ts 0015: ....#.....................##.......................................................................#............................
 --> ts 0016: ....#...........................................................................................................................
 --> ts 0017: ....#...........................................................................................................................
 --> ts 0018: .................#..............................................................................................................
 --> ts 0019: ..........................................................................................#############.........................
 --> ts 0020: ..............................#.................................#...............................................................
 --> ts 0021: ...........................................#....................................................................................
 --> ts 0022: .................#..................#.........................###...............................................................
 --> ts 0023: ....#...........................................................#.......#.......................................................
 --> ts 0024: ....#...........................................#...............#...............................................................
 --> ts 0025: ....#...........................................................#.............#.................................................
 --> ts 0026: ....#...........................................................#...............................................................
 --> ts 0027: ....#...........................................................#...............................................................
 --> ts 0028: ....#...........................................................#.........................................#.....................
 --> ts 0029: ...................#.............#..............................#...............................................................
 --> ts 0030: ................................................................#...............................................................
 --> ts 0031: ...........................................................#....#...............................................................
 --> ts 0032: ................................................................#....................................#..........................
 --> ts 0033: ......................................#.........................#...............................................................
 --> ts 0034: ....#....................................#......................#.................#.............................................
 --> ts 0035: ....#................................#..........................#...............................................................
 --> ts 0036: ....#...........................................................#...............................................................
 --> ts 0037: ....#...........................................................##..............................................................
 --> ts 0038: ....#...........................................................#...............................................................
 --> ts 0039: ....#...........................................................#...............................................................
 --> ts 0040: ....#..........................................#................#...............................................................
 --> ts 0041: ................................................................#....................................#..........................
 --> ts 0042: .......................#........................................#....................................#..........................
 --> ts 0043: .......................#.................######.................#...........................#...................................
 --> ts 0044: .......................#........................#............#..#...............................................................
 --> ts 0045: .......................#........................................#...............................................................
 --> ts 0046: .......................#........................................#...............................................................
 --> ts 0047: .......................#........................................#...............................................................
 --> ts 0048: .......................#........................................#...........................#######.............................
 --> ts 0049: .......................#........................................#...............................................................
 --> ts 0050: .......................#........................................#........................................##.....................
 --> ts 0051: .......................#........................................#...............................................................
 --> ts 0052: .......................#........................................#...............................................................
 --> ts 0053: .......................#........................................#...............................................#...............
 --> ts 0054: ................................................................#...............................................................
 --> ts 0055: ................................................................#...............................................................
 --> ts 0056: ################################################################################################################################
 --> ts 0057: ################################################################################################################################
 --> ts 0058: ..........................................................................................#.....................................
 --> ts 0059: ..........................................#...................#.................................................................
 --> ts 0060: ..............................................................#.................................................................
 --> ts 0061: ..............................................................#.#...............................................................
 --> ts 0062: ..............................................................#.#...............................................................
 --> ts 0063: ................................................................#.....................#.........................................
 --> ts 0064: ................................................................#...............................................................
 --> ts 0065: ................................................................#...............................................................
 --> ts 0066: ................................................................#...............................................................
 --> ts 0067: ................................................................#.....................#.........................................
 --> ts 0068: ................................................................#...............................................................
 --> ts 0069: ................................................................#...............................................................
 --> ts 0070: ................................................................#...............................................................
 --> ts 0071: ................................................................#.................#.............................................
 --> ts 0072: ................................................................#...............................................................
 --> ts 0073: ..............................................................................#.................................................
 --> ts 0074: ....#.....................................................................................................#.....................
 --> ts 0075: ....#.....................##.......................................................................#............................
 --> ts 0076: ....#...........................................................................................................................
 --> ts 0077: ....#...........................................................................................................................
 --> ts 0078: .................#..............................................................................................................
 --> ts 0079: ..........................................................................................#############.........................
 --> ts 0080: ..............................#.................................#...............................................................
 --> ts 0081: ...........................................#....................................................................................
 --> ts 0082: .................#..................#.........................###...............................................................
 --> ts 0083: ....#...........................................................#.......#.......................................................
 --> ts 0084: ....#...........................................#...............#...............................................................
 --> ts 0085: ....#...........................................................#.............#.................................................
 --> ts 0086: ....#...........................................................#...............................................................
 --> ts 0087: ....#...........................................................#...............................................................
 --> ts 0088: ....#...........................................................#.........................................#.....................
 --> ts 0089: ...................#.............#..............................#...............................................................
 --> ts 0090: ................................................................#...............................................................
 --> ts 0091: ...........................................................#....#...............................................................
 --> ts 0092: ................................................................#....................................#..........................
 --> ts 0093: ......................................#.........................#...............................................................
 --> ts 0094: ....#....................................#......................#.................#.............................................
 --> ts 0095: ....#................................#..........................#...............................................................
 --> ts 0096: ....#...........................................................#...............................................................
 --> ts 0097: ....#...........................................................##..............................................................
 --> ts 0098: ....#...........................................................#...............................................................
 --> ts 0099: ....#...........................................................#...............................................................
 --> ts 0100: ....#..........................................#................#...............................................................
 --> ts 0101: ................................................................#....................................#..........................
 --> ts 0102: .......................#........................................#....................................#..........................
 --> ts 0103: .......................#.................######.................#...........................#...................................
 --> ts 0104: .......................#........................#............#..#...............................................................
 --> ts 0105: .......................#........................................#...............................................................
 --> ts 0106: .......................#........................................#...............................................................
 --> ts 0107: .......................#........................................#...............................................................
 --> ts 0108: .......................#........................................#...........................#######.............................
 --> ts 0109: .......................#........................................#...............................................................
 --> ts 0110: .......................#........................................#........................................##.....................
 --> ts 0111: .......................#........................................#...............................................................
 --> ts 0112: .......................#........................................#...............................................................
 --> ts 0113: .......................#........................................#...............................................#...............
 --> ts 0114: ................................................................#...............................................................
 --> ts 0115: ................................................................#...............................................................
 --> ts 0116: ################################################################################################################################
 --> ts 0117: ################################################################################################################################
```

```bash
python3 tests/data/dump_mwaf.py \
    --timestep-limit=0 --baseline-limit=3 \
    /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA02.mwaf \
    | tee /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA02.mwaf.txt
```

```txt
python3 tests/data/dump_mwaf.py \
>     --timestep-limit=0 --baseline-limit=3 \
>     /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA02.mwaf \
>     | tee /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA02.mwaf.txt
-> args {'file': '/mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA02.mwaf', 'timestep_limit': 0, 'baseline_limit': 3}
-> hdus.info():
Filename: /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA02.mwaf
No.    Name      Ver    Type      Cards   Dimensions   Format
  0  PRIMARY       1 PrimaryHDU      15   ()      
  1                1 BinTableHDU     10   990720R x 1C   [128X]   

HEADER

SIMPLE  =                    T / file does conform to FITS standard             
BITPIX  =                    8 / number of bits per data pixel                  
NAXIS   =                    0 / number of data axes                            
EXTEND  =                    T / FITS dataset may contain extensions            
COMMENT   FITS (Flexible Image Transport System) format is defined in 'Astronomy
COMMENT   and Astrophysics', volume 376, page 359; bibcode: 2001A&A...376..359H 
VERSION = '1.0     '                                                            
GPSTIME =           1247842824                                                  
NCHANS  =                  128                                                  
NANTENNA=                  128                                                  
NSCANS  =                  120                                                  
NPOLS   =                    1                                                  
GPUBOXNO=                    2                                                  
COTVER  = '4.5     '                                                            
COTVDATE= '2020-08-10'                                                          
 -> num baselines: 8256

FLAG DATA

XTENSION= 'BINTABLE'           / binary table extension                         
BITPIX  =                    8 / 8-bit bytes                                    
NAXIS   =                    2 / 2-dimensional binary table                     
NAXIS1  =                   16 / width of table in bytes                        
NAXIS2  =               990720 / number of rows in table                        
PCOUNT  =                    0 / size of special data area                      
GCOUNT  =                    1 / one data group (required keyword)              
TFIELDS =                    1 / number of fields in each row                   
TTYPE1  = 'FLAGS   '           / label for field   1                            
TFORM1  = '128X    '           / data format of field: BIT                      
flags shape (990720,)
-> limits: baseline=3, timestep=120
-> bl 0000:
 --> ts 0000: ................................................................................................................................
 --> ts 0001: ................................................................................................................................
 --> ts 0002: ................................................................................................................................
 --> ts 0003: ................................................................................................................................
 --> ts 0004: ................................................................................................................................
 --> ts 0005: ................................................................................................................................
 --> ts 0006: ................................................................................................................................
 --> ts 0007: ................................................................................................................................
 --> ts 0008: ................................................................................................................................
 --> ts 0009: ................................................................................................................................
 --> ts 0010: ................................................................................................................................
 --> ts 0011: ................................................................................................................................
 --> ts 0012: ................................................................................................................................
 --> ts 0013: ................................................................................................................................
 --> ts 0014: ................................................................................................................................
 --> ts 0015: ................................................................................................................................
 --> ts 0016: ................................................................................................................................
 --> ts 0017: ................................................................................................................................
 --> ts 0018: ................................................................................................................................
 --> ts 0019: ................................................................................................................................
 --> ts 0020: ................................................................................................................................
 --> ts 0021: ................................................................................................................................
 --> ts 0022: ................................................................................................................................
 --> ts 0023: ................................................................................................................................
 --> ts 0024: ................................................................................................................................
 --> ts 0025: ................................................................................................................................
 --> ts 0026: ................................................................................................................................
 --> ts 0027: ................................................................................................................................
 --> ts 0028: ................................................................................................................................
 --> ts 0029: ................................................................................................................................
 --> ts 0030: ................................................................................................................................
 --> ts 0031: ................................................................................................................................
 --> ts 0032: ................................................................................................................................
 --> ts 0033: ................................................................................................................................
 --> ts 0034: ................................................................................................................................
 --> ts 0035: ................................................................................................................................
 --> ts 0036: ................................................................................................................................
 --> ts 0037: ................................................................................................................................
 --> ts 0038: ................................................................................................................................
 --> ts 0039: ................................................................................................................................
 --> ts 0040: ................................................................................................................................
 --> ts 0041: ................................................................................................................................
 --> ts 0042: ................................................................................................................................
 --> ts 0043: ................................................................................................................................
 --> ts 0044: ................................................................................................................................
 --> ts 0045: ................................................................................................................................
 --> ts 0046: ................................................................................................................................
 --> ts 0047: ................................................................................................................................
 --> ts 0048: ................................................................................................................................
 --> ts 0049: ................................................................................................................................
 --> ts 0050: ................................................................................................................................
 --> ts 0051: ................................................................................................................................
 --> ts 0052: ................................................................................................................................
 --> ts 0053: ................................................................................................................................
 --> ts 0054: ................................................................................................................................
 --> ts 0055: ................................................................................................................................
 --> ts 0056: ................................................................................................................................
 --> ts 0057: ................................................................................................................................
 --> ts 0058: ################################################################################################################################
 --> ts 0059: ################################################################################################################################
 --> ts 0060: ................................................................................................................................
 --> ts 0061: ................................................................................................................................
 --> ts 0062: ................................................................................................................................
 --> ts 0063: ................................................................................................................................
 --> ts 0064: ................................................................................................................................
 --> ts 0065: ................................................................................................................................
 --> ts 0066: ................................................................................................................................
 --> ts 0067: ................................................................................................................................
 --> ts 0068: ................................................................................................................................
 --> ts 0069: ................................................................................................................................
 --> ts 0070: ................................................................................................................................
 --> ts 0071: ................................................................................................................................
 --> ts 0072: ................................................................................................................................
 --> ts 0073: ................................................................................................................................
 --> ts 0074: ................................................................................................................................
 --> ts 0075: ................................................................................................................................
 --> ts 0076: ................................................................................................................................
 --> ts 0077: ................................................................................................................................
 --> ts 0078: ................................................................................................................................
 --> ts 0079: ................................................................................................................................
 --> ts 0080: ................................................................................................................................
 --> ts 0081: ................................................................................................................................
 --> ts 0082: ................................................................................................................................
 --> ts 0083: ................................................................................................................................
 --> ts 0084: ................................................................................................................................
 --> ts 0085: ................................................................................................................................
 --> ts 0086: ................................................................................................................................
 --> ts 0087: ................................................................................................................................
 --> ts 0088: ................................................................................................................................
 --> ts 0089: ................................................................................................................................
 --> ts 0090: ................................................................................................................................
 --> ts 0091: ................................................................................................................................
 --> ts 0092: ................................................................................................................................
 --> ts 0093: ................................................................................................................................
 --> ts 0094: ................................................................................................................................
 --> ts 0095: ................................................................................................................................
 --> ts 0096: ................................................................................................................................
 --> ts 0097: ................................................................................................................................
 --> ts 0098: ................................................................................................................................
 --> ts 0099: ................................................................................................................................
 --> ts 0100: ................................................................................................................................
 --> ts 0101: ................................................................................................................................
 --> ts 0102: ................................................................................................................................
 --> ts 0103: ................................................................................................................................
 --> ts 0104: ................................................................................................................................
 --> ts 0105: ................................................................................................................................
 --> ts 0106: ................................................................................................................................
 --> ts 0107: ................................................................................................................................
 --> ts 0108: ................................................................................................................................
 --> ts 0109: ................................................................................................................................
 --> ts 0110: ................................................................................................................................
 --> ts 0111: ................................................................................................................................
 --> ts 0112: ................................................................................................................................
 --> ts 0113: ................................................................................................................................
 --> ts 0114: ................................................................................................................................
 --> ts 0115: ................................................................................................................................
 --> ts 0116: ................................................................................................................................
 --> ts 0117: ................................................................................................................................
 --> ts 0118: ################################################################################################################################
 --> ts 0119: ################################################################################################################################
-> bl 0001:
 --> ts 0000: ............................##...................#..............................................................................
 --> ts 0001: ............................................................#...................................................................
 --> ts 0002: .............................................#..................................................................................
 --> ts 0003: .....................#...............................................................................#..........................
 --> ts 0004: .....................#..............................................................................#...........................
 --> ts 0005: ...............................................##.#.................................................#...........................
 --> ts 0006: ................................................................................................................................
 --> ts 0007: .....................#..........................................................................................................
 --> ts 0008: .....................#.........................#................#...............................................................
 --> ts 0009: ...............................................#...........#....................................................................
 --> ts 0010: ...............................................#................#...............................................................
 --> ts 0011: ...............................................#.....##......#..................................................................
 --> ts 0012: .............................................#.#.............#..................................................................
 --> ts 0013: ...............................................#................................................................................
 --> ts 0014: .............................#.................#......................................................##........................
 --> ts 0015: ...............................................#.........................................................#......................
 --> ts 0016: ......................#........................#.........................................................#......................
 --> ts 0017: ...............................................#...............#..........................#.....................................
 --> ts 0018: ....#..........................................#................................................................................
 --> ts 0019: ....#..........................................#................................................##..............................
 --> ts 0020: ....#..........................................#................................................................................
 --> ts 0021: ....#..........................................#................................................................................
 --> ts 0022: ...............................................#................................................................................
 --> ts 0023: ...............................................#..#.............................................................................
 --> ts 0024: ...............................................#................................................................................
 --> ts 0025: ...............................................#................................................................................
 --> ts 0026: ...............................................#................#...............................................................
 --> ts 0027: ....#..........................................#................#...............................................................
 --> ts 0028: ....#..........................................#................#...............................................................
 --> ts 0029: ....#....................................##....#................#......................................#........................
 --> ts 0030: ....#...........................................................#...............................................................
 --> ts 0031: ....#...............................................##..........#...............................................................
 --> ts 0032: ....#...........................................................#...............................................................
 --> ts 0033: ...............................................................##...............................................................
 --> ts 0034: ................................................................#...............................................................
 --> ts 0035: ................................................................#...............................................................
 --> ts 0036: ................................................................#...............................................................
 --> ts 0037: ................................................................#...............................................................
 --> ts 0038: ....#.......................................................................#...................................................
 --> ts 0039: ....#...........................................................................................................................
 --> ts 0040: ....#............................................#..............................................................................
 --> ts 0041: ....#........................................................................##.................................................
 --> ts 0042: ....#...........................................................................................................................
 --> ts 0043: ....#........................................................##.................................................................
 --> ts 0044: ....#...........................................................................................................................
 --> ts 0045: ................................................................................................................................
 --> ts 0046: .................................#.........................................................................##...................
 --> ts 0047: ................................................................................................................................
 --> ts 0048: .......................................................#..........##......#.....................................................
 --> ts 0049: ..........................................................................#.....................................................
 --> ts 0050: .................#................#............................................................................#................
 --> ts 0051: ................................................................................................................................
 --> ts 0052: ................................................................................##..............................................
 --> ts 0053: ............................................#.......................................................#...........................
 --> ts 0054: ....................................................................................................#...........................
 --> ts 0055: ....................................................................................................#...........................
 --> ts 0056: ....................................................................................................#.#.........................
 --> ts 0057: ....................................................................................................#...........................
 --> ts 0058: ################################################################################################################################
 --> ts 0059: ################################################################################################################################
 --> ts 0060: ............................##...................#..............................................................................
 --> ts 0061: ............................................................#...................................................................
 --> ts 0062: .............................................#..................................................................................
 --> ts 0063: .....................#...............................................................................#..........................
 --> ts 0064: .....................#..............................................................................#...........................
 --> ts 0065: ...............................................##.#.................................................#...........................
 --> ts 0066: ................................................................................................................................
 --> ts 0067: .....................#..........................................................................................................
 --> ts 0068: .....................#.........................#................#...............................................................
 --> ts 0069: ...............................................#...........#....................................................................
 --> ts 0070: ...............................................#................#...............................................................
 --> ts 0071: ...............................................#.....##......#..................................................................
 --> ts 0072: .............................................#.#.............#..................................................................
 --> ts 0073: ...............................................#................................................................................
 --> ts 0074: .............................#.................#......................................................##........................
 --> ts 0075: ...............................................#.........................................................#......................
 --> ts 0076: ......................#........................#.........................................................#......................
 --> ts 0077: ...............................................#...............#..........................#.....................................
 --> ts 0078: ....#..........................................#................................................................................
 --> ts 0079: ....#..........................................#................................................##..............................
 --> ts 0080: ....#..........................................#................................................................................
 --> ts 0081: ....#..........................................#................................................................................
 --> ts 0082: ...............................................#................................................................................
 --> ts 0083: ...............................................#..#.............................................................................
 --> ts 0084: ...............................................#................................................................................
 --> ts 0085: ...............................................#................................................................................
 --> ts 0086: ...............................................#................#...............................................................
 --> ts 0087: ....#..........................................#................#...............................................................
 --> ts 0088: ....#..........................................#................#...............................................................
 --> ts 0089: ....#....................................##....#................#......................................#........................
 --> ts 0090: ....#...........................................................#...............................................................
 --> ts 0091: ....#...............................................##..........#...............................................................
 --> ts 0092: ....#...........................................................#...............................................................
 --> ts 0093: ...............................................................##...............................................................
 --> ts 0094: ................................................................#...............................................................
 --> ts 0095: ................................................................#...............................................................
 --> ts 0096: ................................................................#...............................................................
 --> ts 0097: ................................................................#...............................................................
 --> ts 0098: ....#.......................................................................#...................................................
 --> ts 0099: ....#...........................................................................................................................
 --> ts 0100: ....#............................................#..............................................................................
 --> ts 0101: ....#........................................................................##.................................................
 --> ts 0102: ....#...........................................................................................................................
 --> ts 0103: ....#........................................................##.................................................................
 --> ts 0104: ....#...........................................................................................................................
 --> ts 0105: ................................................................................................................................
 --> ts 0106: .................................#.........................................................................##...................
 --> ts 0107: ................................................................................................................................
 --> ts 0108: .......................................................#..........##......#.....................................................
 --> ts 0109: ..........................................................................#.....................................................
 --> ts 0110: .................#................#............................................................................#................
 --> ts 0111: ................................................................................................................................
 --> ts 0112: ................................................................................##..............................................
 --> ts 0113: ............................................#.......................................................#...........................
 --> ts 0114: ....................................................................................................#...........................
 --> ts 0115: ....................................................................................................#...........................
 --> ts 0116: ....................................................................................................#.#.........................
 --> ts 0117: ....................................................................................................#...........................
 --> ts 0118: ################################################################################################################################
 --> ts 0119: ################################################################################################################################
-> bl 0002:
 --> ts 0000: ................................................................#...............................................................
 --> ts 0001: .......................................................#........#...............................................................
 --> ts 0002: .......................................................#........#.....................#............#............................
 --> ts 0003: .......................................................#........#.....................#................#........................
 --> ts 0004: .....................................................#.#........#...............................................................
 --> ts 0005: .....................................................#..........#...............................................................
 --> ts 0006: .....................................................#..........#.............................................#.................
 --> ts 0007: .....................................................#..........#.............................................#.................
 --> ts 0008: .....................................................#..........#...............................................................
 --> ts 0009: .....................................................#..........#........................................#......................
 --> ts 0010: ................................................................#........................................#......................
 --> ts 0011: ................................................................#.....................####......................................
 --> ts 0012: .......................####.....................................#...............................................................
 --> ts 0013: ................................................................#...............#...............................................
 --> ts 0014: ...............................#....#.......#...................#...............................................................
 --> ts 0015: ....................................#.......#...................#...............................................................
 --> ts 0016: ................................................................#...............................................................
 --> ts 0017: ..................................................####..........#...............................................................
 --> ts 0018: ....#...........................................................#...............................................................
 --> ts 0019: ....#...........................................................#...............................................................
 --> ts 0020: ....#...........................................................#...............................................................
 --> ts 0021: ....#.................#.........................................#...............................................................
 --> ts 0022: ................................................................#............####...............................................
 --> ts 0023: ................................................................#..........................................#....................
 --> ts 0024: ................................................................#...............................................................
 --> ts 0025: ............................#...................................#...............................................................
 --> ts 0026: ................................................................#...............................................................
 --> ts 0027: ....#.................................#...........#.............#...............................................................
 --> ts 0028: ....#......................#....................................#...............................................................
 --> ts 0029: ....#......................#..............#.....................#...............................................................
 --> ts 0030: ....#......................#..............#.....................#....................#..........................................
 --> ts 0031: ....#......................#..............#.#...................#....................#..#.......................................
 --> ts 0032: ....#......................#..............#..#..................#...............................................................
 --> ts 0033: ...........................#......#.......#.....................#...............................................................
 --> ts 0034: ..........................................#.....................#...............................................................
 --> ts 0035: ................................................................#.........................................##....................
 --> ts 0036: ................................................................#...............................................................
 --> ts 0037: ................................................................#...............................................................
 --> ts 0038: ....#...........................................................#...............................................................
 --> ts 0039: ....#...........................................................#...............................................................
 --> ts 0040: ....#...........................................................#...............................................................
 --> ts 0041: ....#...........................................................#...................#...........................................
 --> ts 0042: ....#...........................................................#...........##......#...........................................
 --> ts 0043: ....#...........................................................#...............................................................
 --> ts 0044: ....#...........................................................#...............................................................
 --> ts 0045: ................................................................#...............................................................
 --> ts 0046: ................................................................#........................................#......................
 --> ts 0047: ....................................#...........................#...............................................................
 --> ts 0048: ......................#.......##................................#...............................................................
 --> ts 0049: ................................................................#.......................#.......................................
 --> ts 0050: ........................................................#.......#...............................................................
 --> ts 0051: ........................................................#.......#...............................................................
 --> ts 0052: ................................................................#...............................................................
 --> ts 0053: ................................................................#..#............................................................
 --> ts 0054: .....................................#...............#..........#...............................................................
 --> ts 0055: .....................................#...............#..........#...............................................................
 --> ts 0056: ....................................................#...........#...............................................................
 --> ts 0057: ....................................................#...........##..............................................................
 --> ts 0058: ################################################################################################################################
 --> ts 0059: ################################################################################################################################
 --> ts 0060: ................................................................#...............................................................
 --> ts 0061: .......................................................#........#...............................................................
 --> ts 0062: .......................................................#........#.....................#............#............................
 --> ts 0063: .......................................................#........#.....................#................#........................
 --> ts 0064: .....................................................#.#........#...............................................................
 --> ts 0065: .....................................................#..........#...............................................................
 --> ts 0066: .....................................................#..........#.............................................#.................
 --> ts 0067: .....................................................#..........#.............................................#.................
 --> ts 0068: .....................................................#..........#...............................................................
 --> ts 0069: .....................................................#..........#........................................#......................
 --> ts 0070: ................................................................#........................................#......................
 --> ts 0071: ................................................................#.....................####......................................
 --> ts 0072: .......................####.....................................#...............................................................
 --> ts 0073: ................................................................#...............#...............................................
 --> ts 0074: ...............................#....#.......#...................#...............................................................
 --> ts 0075: ....................................#.......#...................#...............................................................
 --> ts 0076: ................................................................#...............................................................
 --> ts 0077: ..................................................####..........#...............................................................
 --> ts 0078: ....#...........................................................#...............................................................
 --> ts 0079: ....#...........................................................#...............................................................
 --> ts 0080: ....#...........................................................#...............................................................
 --> ts 0081: ....#.................#.........................................#...............................................................
 --> ts 0082: ................................................................#............####...............................................
 --> ts 0083: ................................................................#..........................................#....................
 --> ts 0084: ................................................................#...............................................................
 --> ts 0085: ............................#...................................#...............................................................
 --> ts 0086: ................................................................#...............................................................
 --> ts 0087: ....#.................................#...........#.............#...............................................................
 --> ts 0088: ....#......................#....................................#...............................................................
 --> ts 0089: ....#......................#..............#.....................#...............................................................
 --> ts 0090: ....#......................#..............#.....................#....................#..........................................
 --> ts 0091: ....#......................#..............#.#...................#....................#..#.......................................
 --> ts 0092: ....#......................#..............#..#..................#...............................................................
 --> ts 0093: ...........................#......#.......#.....................#...............................................................
 --> ts 0094: ..........................................#.....................#...............................................................
 --> ts 0095: ................................................................#.........................................##....................
 --> ts 0096: ................................................................#...............................................................
 --> ts 0097: ................................................................#...............................................................
 --> ts 0098: ....#...........................................................#...............................................................
 --> ts 0099: ....#...........................................................#...............................................................
 --> ts 0100: ....#...........................................................#...............................................................
 --> ts 0101: ....#...........................................................#...................#...........................................
 --> ts 0102: ....#...........................................................#...........##......#...........................................
 --> ts 0103: ....#...........................................................#...............................................................
 --> ts 0104: ....#...........................................................#...............................................................
 --> ts 0105: ................................................................#...............................................................
 --> ts 0106: ................................................................#........................................#......................
 --> ts 0107: ....................................#...........................#...............................................................
 --> ts 0108: ......................#.......##................................#...............................................................
 --> ts 0109: ................................................................#.......................#.......................................
 --> ts 0110: ........................................................#.......#...............................................................
 --> ts 0111: ........................................................#.......#...............................................................
 --> ts 0112: ................................................................#...............................................................
 --> ts 0113: ................................................................#..#............................................................
 --> ts 0114: .....................................#...............#..........#...............................................................
 --> ts 0115: .....................................#...............#..........#...............................................................
 --> ts 0116: ....................................................#...........#...............................................................
 --> ts 0117: ....................................................#...........##..............................................................
 --> ts 0118: ################################################################################################################################
 --> ts 0119: ################################################################################################################################
```

*things to note:*

The observations has an INTTIME of 1.000s, and 2 batches of 60 scans.
We are only ever giving Cotter the first batch.
With all timesteps lined up, the flags are as you would expect, 120 scans, with 
the first 60 timesteps filled with normal looking flags, then the next 60 fully 
flagged.

However if we take that same observation, and move gpubox01 back 2*1.000 s, 
then the result for the altered gpubox is a flag buffer with length 118, and:

- the first 56 scans look similar to the original scans offset by 4 timesteps 
- the next 2 scans are fully flagged
- the next 58 scans look similar to the original scans offset by 2 timesteps
- the next 2 scans are fully flagged

The unaltered gpuboxes are the same, show a similar pattern, with 120 scans, and:

- the first 60 scans look similar to the original scans, but with the last 2 scans fully flagged
- the next 60 scans are a repeat of the first 60