//! Possible choices for polyphase filter bank gains for the MWA.

/// These gains are derived from `MWARX_RRI_PrototypeFilter_512x8.dat` using the method described
/// in this wiki page <https://wiki.mwatelescope.org/display/MP/RRI+Receiver+PFB+Filter>
///
/// ```bash
/// python compute_pfb_aliased_bandpass_MWAX.py 0.2
/// ```
pub const PFB_JAKE_2022_200HZ: &[f64] = &[
    5.00035573710785e-01,
    5.00036511286166e-01,
    5.00039324449532e-01,
    5.00044013172841e-01,
    5.00050577409347e-01,
    5.00059017093598e-01,
    5.00069332141441e-01,
    5.00081522450018e-01,
    5.00095587897773e-01,
    5.00111528344452e-01,
    5.00129343631103e-01,
    5.00149033580080e-01,
    5.00170597995048e-01,
    5.00194036660982e-01,
    5.00219349344174e-01,
    5.00246535792231e-01,
    5.00275595734087e-01,
    5.00306528880000e-01,
    5.00339334921560e-01,
    5.00374013531693e-01,
    5.00410564364666e-01,
    5.00448987056091e-01,
    5.00489281222933e-01,
    5.00531446463514e-01,
    5.00575482357521e-01,
    5.00621388466009e-01,
    5.00669164331411e-01,
    5.00718809477544e-01,
    5.00770323409617e-01,
    5.00823705614236e-01,
    5.00878955559415e-01,
    5.00936072694582e-01,
    5.00995056450587e-01,
    5.01055906239716e-01,
    5.01118621455690e-01,
    5.01183201473685e-01,
    5.01249645650334e-01,
    5.01317953323740e-01,
    5.01388123813487e-01,
    5.01460156420648e-01,
    5.01534050427795e-01,
    5.01609805099014e-01,
    5.01687419679913e-01,
    5.01766893397635e-01,
    5.01848225460868e-01,
    5.01931415059861e-01,
    5.02016461366431e-01,
    5.02103363533978e-01,
    5.02192120697501e-01,
    5.02282731973607e-01,
    5.02375196460525e-01,
    5.02469513238124e-01,
    5.02565681367919e-01,
    5.02663699893095e-01,
    5.02763567838514e-01,
    5.02865284210733e-01,
    5.02968847998019e-01,
    5.03074258170365e-01,
    5.03181513679504e-01,
    5.03290613458926e-01,
    5.03401556423896e-01,
    5.03514341471466e-01,
    5.03628967480497e-01,
    5.03745433311672e-01,
    5.03863737807518e-01,
    5.03983879792416e-01,
    5.04105858072629e-01,
    5.04229671436312e-01,
    5.04355318653532e-01,
    5.04482798476293e-01,
    5.04612109638545e-01,
    5.04743250856211e-01,
    5.04876220827205e-01,
    5.05011018231448e-01,
    5.05147641730894e-01,
    5.05286089969546e-01,
    5.05426361573477e-01,
    5.05568455150855e-01,
    5.05712369291957e-01,
    5.05858102569199e-01,
    5.06005653537151e-01,
    5.06155020732561e-01,
    5.06306202674379e-01,
    5.06459197863778e-01,
    5.06614004784176e-01,
    5.06770621901261e-01,
    5.06929047663013e-01,
    5.07089280499730e-01,
    5.07251318824045e-01,
    5.07415161030961e-01,
    5.07580805497866e-01,
    5.07748250584562e-01,
    5.07917494633289e-01,
    5.08088535968750e-01,
    5.08261372898137e-01,
    5.08436003711157e-01,
    5.08612426680056e-01,
    5.08790640059649e-01,
    5.08970642087341e-01,
    5.09152430983160e-01,
    5.09336004949779e-01,
    5.09521362172546e-01,
    5.09708500819511e-01,
    5.09897419041453e-01,
    5.10088114971909e-01,
    5.10280586727202e-01,
    5.10474832406469e-01,
    5.10670850091691e-01,
    5.10868637847722e-01,
    5.11068193722315e-01,
    5.11269515746158e-01,
    5.11472601932897e-01,
    5.11677450279172e-01,
    5.11884058764643e-01,
    5.12092425352022e-01,
    5.12302547987105e-01,
    5.12514424598801e-01,
    5.12728053099166e-01,
    5.12943431383433e-01,
    5.13160557330042e-01,
    5.13379428800676e-01,
    5.13600043640290e-01,
    5.13822399677147e-01,
    5.14046494722846e-01,
    5.14272326572359e-01,
    5.14499893004066e-01,
    5.14729191779780e-01,
    5.14960220644792e-01,
    5.15192977327895e-01,
    5.15427459541428e-01,
    5.15663664981300e-01,
    5.15901591327035e-01,
    5.16141236241798e-01,
    5.16382597372437e-01,
    5.16625672349516e-01,
    5.16870458787350e-01,
    5.17116954284040e-01,
    5.17365156421514e-01,
    5.17615062765558e-01,
    5.17866670865855e-01,
    5.18119978256022e-01,
    5.18374982453649e-01,
    5.18631680960332e-01,
    5.18890071261712e-01,
    5.19150150827517e-01,
    5.19411917111594e-01,
    5.19675367551950e-01,
    5.19940499570794e-01,
    5.20207310574569e-01,
    5.20475797953994e-01,
    5.20745959084106e-01,
    5.21017791324296e-01,
    5.21291292018349e-01,
    5.21566458494484e-01,
    5.21843288065395e-01,
    5.22121778028293e-01,
    5.22401925664941e-01,
    5.22683728241700e-01,
    5.22967183009567e-01,
    5.23252287204220e-01,
    5.23539038046053e-01,
    5.23827432740223e-01,
    5.24117468476693e-01,
    5.24409142430266e-01,
    5.24702451760637e-01,
    5.24997393612428e-01,
    5.25293965115236e-01,
    5.25592163383672e-01,
    5.25891985517408e-01,
    5.26193428601216e-01,
    5.26496489705014e-01,
    5.26801165883911e-01,
    5.27107454178248e-01,
    5.27415351613643e-01,
    5.27724855201039e-01,
    5.28035961936742e-01,
    5.28348668802471e-01,
    5.28662972765402e-01,
    5.28978870778212e-01,
    5.29296359779125e-01,
    5.29615436691957e-01,
    5.29936098426162e-01,
    5.30258341876881e-01,
    5.30582163924983e-01,
    5.30907561437114e-01,
    5.31234531265746e-01,
    5.31563070249218e-01,
    5.31893175211788e-01,
    5.32224842963680e-01,
    5.32558070301127e-01,
    5.32892854006423e-01,
    5.33229190847969e-01,
    5.33567077580321e-01,
    5.33906510944239e-01,
    5.34247487666733e-01,
    5.34590004461114e-01,
    5.34934058027042e-01,
    5.35279645050575e-01,
    5.35626762204216e-01,
    5.35975406146965e-01,
    5.36325573524368e-01,
    5.36677260968566e-01,
    5.37030465098343e-01,
    5.37385182519179e-01,
    5.37741409823299e-01,
    5.38099143589723e-01,
    5.38458380384316e-01,
    5.38819116759841e-01,
    5.39181349256006e-01,
    5.39545074399519e-01,
    5.39910288704137e-01,
    5.40276988670719e-01,
    5.40645170787272e-01,
    5.41014831529012e-01,
    5.41385967358409e-01,
    5.41758574725241e-01,
    5.42132650066645e-01,
    5.42508189807172e-01,
    5.42885190358838e-01,
    5.43263648121177e-01,
    5.43643559481292e-01,
    5.44024920813911e-01,
    5.44407728481439e-01,
    5.44791978834010e-01,
    5.45177668209543e-01,
    5.45564792933794e-01,
    5.45953349320409e-01,
    5.46343333670981e-01,
    5.46734742275100e-01,
    5.47127571410412e-01,
    5.47521817342670e-01,
    5.47917476325787e-01,
    5.48314544601898e-01,
    5.48713018401406e-01,
    5.49112893943044e-01,
    5.49514167433925e-01,
    5.49916835069602e-01,
    5.50320893034118e-01,
    5.50726337500068e-01,
    5.51133164628649e-01,
    5.51541370569720e-01,
    5.51950951461856e-01,
    5.52361903432402e-01,
    5.52774222597537e-01,
    5.53187905062319e-01,
    5.53602946920753e-01,
    5.54019344255841e-01,
    5.54437093139639e-01,
    5.54856189633317e-01,
    5.55276629787213e-01,
    5.55698409640893e-01,
    5.56121525223206e-01,
    5.56545972552345e-01,
    5.56971747635899e-01,
    5.57398846470915e-01,
    5.57827265043956e-01,
    5.58256999331156e-01,
    5.58688045298282e-01,
    5.59120398900788e-01,
    5.59554056083877e-01,
    5.59989012782558e-01,
    5.60425264921704e-01,
    5.60862808416111e-01,
    5.61301639170557e-01,
    5.61741753079863e-01,
    5.62183146028948e-01,
    5.62625813892892e-01,
    5.63069752536992e-01,
    5.63514957816824e-01,
    5.63961425578300e-01,
    5.64409151657732e-01,
    5.64858131881887e-01,
    5.65308362068047e-01,
    5.65759838024073e-01,
    5.66212555548463e-01,
    5.66666510430409e-01,
    5.67121698449863e-01,
    5.67578115377590e-01,
    5.68035756975238e-01,
    5.68494618995390e-01,
    5.68954697181628e-01,
    5.69415987268594e-01,
    5.69878484982051e-01,
    5.70342186038942e-01,
    5.70807086147453e-01,
    5.71273181007073e-01,
    5.71740466308657e-01,
    5.72208937734483e-01,
    5.72678590958319e-01,
    5.73149421645480e-01,
    5.73621425452891e-01,
    5.74094598029150e-01,
    5.74568935014588e-01,
    5.75044432041329e-01,
    5.75521084733357e-01,
    5.75998888706574e-01,
    5.76477839568862e-01,
    5.76957932920147e-01,
    5.77439164352461e-01,
    5.77921529450001e-01,
    5.78405023789197e-01,
    5.78889642938768e-01,
    5.79375382459789e-01,
    5.79862237905752e-01,
    5.80350204822630e-01,
    5.80839278748936e-01,
    5.81329455215790e-01,
    5.81820729746978e-01,
    5.82313097859019e-01,
    5.82806555061223e-01,
    5.83301096855759e-01,
    5.83796718737716e-01,
    5.84293416195162e-01,
    5.84791184709214e-01,
    5.85290019754098e-01,
    5.85789916797211e-01,
    5.86290871299188e-01,
    5.86792878713960e-01,
    5.87295934488822e-01,
    5.87800034064496e-01,
    5.88305172875192e-01,
    5.88811346348674e-01,
    5.89318549906321e-01,
    5.89826778963195e-01,
    5.90336028928099e-01,
    5.90846295203647e-01,
    5.91357573186323e-01,
    5.91869858266546e-01,
    5.92383145828735e-01,
    5.92897431251373e-01,
    5.93412709907068e-01,
    5.93928977162622e-01,
    5.94446228379090e-01,
    5.94964458911849e-01,
    5.95483664110655e-01,
    5.96003839319717e-01,
    5.96524979877752e-01,
    5.97047081118053e-01,
    5.97570138368555e-01,
    5.98094146951897e-01,
    5.98619102185485e-01,
    5.99144999381560e-01,
    5.99671833847259e-01,
    6.00199600884681e-01,
    6.00728295790952e-01,
    6.01257913858287e-01,
    6.01788450374055e-01,
    6.02319900620848e-01,
    6.02852259876537e-01,
    6.03385523414344e-01,
    6.03919686502905e-01,
    6.04454744406328e-01,
    6.04990692384268e-01,
    6.05527525691983e-01,
    6.06065239580403e-01,
    6.06603829296192e-01,
    6.07143290081814e-01,
    6.07683617175598e-01,
    6.08224805811803e-01,
    6.08766851220679e-01,
    6.09309748628534e-01,
    6.09853493257799e-01,
    6.10398080327094e-01,
    6.10943505051287e-01,
    6.11489762641566e-01,
    6.12036848305496e-01,
    6.12584757247090e-01,
    6.13133484666870e-01,
    6.13683025761931e-01,
    6.14233375726009e-01,
    6.14784529749543e-01,
    6.15336483019739e-01,
    6.15889230720635e-01,
    6.16442768033168e-01,
    6.16997090135235e-01,
    6.17552192201759e-01,
    6.18108069404753e-01,
    6.18664716913386e-01,
    6.19222129894044e-01,
    6.19780303510399e-01,
    6.20339232923469e-01,
    6.20898913291687e-01,
    6.21459339770959e-01,
    6.22020507514733e-01,
    6.22582411674065e-01,
    6.23145047397678e-01,
    6.23708409832028e-01,
    6.24272494121371e-01,
    6.24837295407825e-01,
    6.25402808831432e-01,
    6.25969029530226e-01,
    6.26535952640297e-01,
    6.27103573295850e-01,
    6.27671886629274e-01,
    6.28240887771208e-01,
    6.28810571850594e-01,
    6.29380933994757e-01,
    6.29951969329453e-01,
    6.30523672978944e-01,
    6.31096040066056e-01,
    6.31669065712247e-01,
    6.32242745037666e-01,
    6.32817073161220e-01,
    6.33392045200635e-01,
    6.33967656272523e-01,
    6.34543901492444e-01,
    6.35120775974967e-01,
    6.35698274833737e-01,
    6.36276393181536e-01,
    6.36855126130349e-01,
    6.37434468791423e-01,
    6.38014416275335e-01,
    6.38594963692051e-01,
    6.39176106150992e-01,
    6.39757838761096e-01,
    6.40340156630879e-01,
    6.40923054868504e-01,
    6.41506528581835e-01,
    6.42090572878508e-01,
    6.42675182865990e-01,
    6.43260353651639e-01,
    6.43846080342773e-01,
    6.44432358046727e-01,
    6.45019181870919e-01,
    6.45606546922910e-01,
    6.46194448310467e-01,
    6.46782881141627e-01,
    6.47371840524757e-01,
    6.47961321568616e-01,
    6.48551319382419e-01,
    6.49141829075899e-01,
    6.49732845759367e-01,
    6.50324364543772e-01,
    6.50916380540770e-01,
    6.51508888862779e-01,
    6.52101884623041e-01,
    6.52695362935688e-01,
    6.53289318915799e-01,
    6.53883747679464e-01,
    6.54478644343844e-01,
    6.55074004027231e-01,
    6.55669821849113e-01,
    6.56266092930230e-01,
    6.56862812392640e-01,
    6.57459975359775e-01,
    6.58057576956506e-01,
    6.58655612309200e-01,
    6.59254076545784e-01,
    6.59852964795802e-01,
    6.60452272190478e-01,
    6.61051993862775e-01,
    6.61652124947457e-01,
    6.62252660581145e-01,
    6.62853595902383e-01,
    6.63454926051692e-01,
    6.64056646171632e-01,
    6.64658751406865e-01,
    6.65261236904209e-01,
    6.65864097812702e-01,
    6.66467329283658e-01,
    6.67070926470727e-01,
    6.67674884529959e-01,
    6.68279198619855e-01,
    6.68883863901433e-01,
    6.69488875538281e-01,
    6.70094228696621e-01,
    6.70699918545365e-01,
    6.71305940256174e-01,
    6.71912289003514e-01,
    6.72518959964720e-01,
    6.73125948320048e-01,
    6.73733249252739e-01,
    6.74340857949070e-01,
    6.74948769598420e-01,
    6.75556979393319e-01,
    6.76165482529515e-01,
    6.76774274206021e-01,
    6.77383349625182e-01,
    6.77992703992728e-01,
    6.78602332517830e-01,
    6.79212230413159e-01,
    6.79822392894942e-01,
    6.80432815183019e-01,
    6.81043492500901e-01,
    6.81654420075823e-01,
    6.82265593138805e-01,
    6.82877006924705e-01,
    6.83488656672275e-01,
    6.84100537624220e-01,
    6.84712645027249e-01,
    6.85324974132138e-01,
    6.85937520193777e-01,
    6.86550278471234e-01,
    6.87163244227802e-01,
    6.87776412731061e-01,
    6.88389779252930e-01,
    6.89003339069722e-01,
    6.89617087462200e-01,
    6.90231019715631e-01,
    6.90845131119838e-01,
    6.91459416969261e-01,
    6.92073872563004e-01,
    6.92688493204893e-01,
    6.93303274203531e-01,
    6.93918210872346e-01,
    6.94533298529654e-01,
    6.95148532498704e-01,
    6.95763908107735e-01,
    6.96379420690029e-01,
    6.96995065583965e-01,
    6.97610838133073e-01,
    6.98226733686079e-01,
    6.98842747596970e-01,
    6.99458875225036e-01,
    7.00075111934929e-01,
    7.00691453096711e-01,
    7.01307894085908e-01,
    7.01924430283563e-01,
    7.02541057076287e-01,
    7.03157769856306e-01,
    7.03774564021522e-01,
    7.04391434975555e-01,
    7.05008378127800e-01,
    7.05625388893476e-01,
    7.06242462693676e-01,
    7.06859594955418e-01,
    7.07476781111700e-01,
    7.08094016601541e-01,
    7.08711296870040e-01,
    7.09328617368423e-01,
    7.09945973554092e-01,
    7.10563360890673e-01,
    7.11180774848073e-01,
    7.11798210902518e-01,
    7.12415664536616e-01,
    7.13033131239391e-01,
    7.13650606506345e-01,
    7.14268085839498e-01,
    7.14885564747443e-01,
    7.15503038745388e-01,
    7.16120503355210e-01,
    7.16737954105499e-01,
    7.17355386531609e-01,
    7.17972796175703e-01,
    7.18590178586800e-01,
    7.19207529320830e-01,
    7.19824843940668e-01,
    7.20442118016195e-01,
    7.21059347124334e-01,
    7.21676526849101e-01,
    7.22293652781656e-01,
    7.22910720520340e-01,
    7.23527725670729e-01,
    7.24144663845676e-01,
    7.24761530665356e-01,
    7.25378321757318e-01,
    7.25995032756524e-01,
    7.26611659305394e-01,
    7.27228197053857e-01,
    7.27844641659390e-01,
    7.28460988787067e-01,
    7.29077234109600e-01,
    7.29693373307387e-01,
    7.30309402068553e-01,
    7.30925316088996e-01,
    7.31541111072430e-01,
    7.32156782730429e-01,
    7.32772326782471e-01,
    7.33387738955980e-01,
    7.34003014986370e-01,
    7.34618150617088e-01,
    7.35233141599656e-01,
    7.35847983693716e-01,
    7.36462672667068e-01,
    7.37077204295716e-01,
    7.37691574363909e-01,
    7.38305778664182e-01,
    7.38919812997398e-01,
    7.39533673172790e-01,
    7.40147355008002e-01,
    7.40760854329129e-01,
    7.41374166970759e-01,
    7.41987288776015e-01,
    7.42600215596593e-01,
    7.43212943292801e-01,
    7.43825467733606e-01,
    7.44437784796664e-01,
    7.45049890368370e-01,
    7.45661780343890e-01,
    7.46273450627202e-01,
    7.46884897131138e-01,
    7.47496115777420e-01,
    7.48107102496699e-01,
    7.48717853228597e-01,
    7.49328363921738e-01,
    7.49938630533796e-01,
    7.50548649031525e-01,
    7.51158415390799e-01,
    7.51767925596651e-01,
    7.52377175643310e-01,
    7.52986161534238e-01,
    7.53594879282164e-01,
    7.54203324909127e-01,
    7.54811494446506e-01,
    7.55419383935062e-01,
    7.56026989424970e-01,
    7.56634306975857e-01,
    7.57241332656837e-01,
    7.57848062546548e-01,
    7.58454492733185e-01,
    7.59060619314539e-01,
    7.59666438398026e-01,
    7.60271946100727e-01,
    7.60877138549422e-01,
    7.61482011880622e-01,
    7.62086562240605e-01,
    7.62690785785448e-01,
    7.63294678681063e-01,
    7.63898237103232e-01,
    7.64501457237634e-01,
    7.65104335279884e-01,
    7.65706867435567e-01,
    7.66309049920262e-01,
    7.66910878959586e-01,
    7.67512350789218e-01,
    7.68113461654935e-01,
    7.68714207812641e-01,
    7.69314585528403e-01,
    7.69914591078478e-01,
    7.70514220749349e-01,
    7.71113470837749e-01,
    7.71712337650702e-01,
    7.72310817505544e-01,
    7.72908906729959e-01,
    7.73506601662006e-01,
    7.74103898650154e-01,
    7.74700794053306e-01,
    7.75297284240832e-01,
    7.75893365592599e-01,
    7.76489034498999e-01,
    7.77084287360974e-01,
    7.77679120590054e-01,
    7.78273530608377e-01,
    7.78867513848722e-01,
    7.79461066754538e-01,
    7.80054185779965e-01,
    7.80646867389871e-01,
    7.81239108059873e-01,
    7.81830904276368e-01,
    7.82422252536558e-01,
    7.83013149348478e-01,
    7.83603591231021e-01,
    7.84193574713967e-01,
    7.84783096338008e-01,
    7.85372152654774e-01,
    7.85960740226858e-01,
    7.86548855627846e-01,
    7.87136495442336e-01,
    7.87723656265966e-01,
    7.88310334705442e-01,
    7.88896527378558e-01,
    7.89482230914223e-01,
    7.90067441952487e-01,
    7.90652157144561e-01,
    7.91236373152845e-01,
    7.91820086650948e-01,
    7.92403294323716e-01,
    7.92985992867250e-01,
    7.93568178988935e-01,
    7.94149849407459e-01,
    7.94731000852834e-01,
    7.95311630066425e-01,
    7.95891733800965e-01,
    7.96471308820583e-01,
    7.97050351900820e-01,
    7.97628859828657e-01,
    7.98206829402530e-01,
    7.98784257432359e-01,
    7.99361140739559e-01,
    7.99937476157069e-01,
    8.00513260529371e-01,
    8.01088490712505e-01,
    8.01663163574097e-01,
    8.02237275993372e-01,
    8.02810824861181e-01,
    8.03383807080012e-01,
    8.03956219564015e-01,
    8.04528059239020e-01,
    8.05099323042555e-01,
    8.05670007923867e-01,
    8.06240110843935e-01,
    8.06809628775496e-01,
    8.07378558703055e-01,
    8.07946897622908e-01,
    8.08514642543159e-01,
    8.09081790483736e-01,
    8.09648338476408e-01,
    8.10214283564804e-01,
    8.10779622804426e-01,
    8.11344353262671e-01,
    8.11908472018841e-01,
    8.12471976164165e-01,
    8.13034862801811e-01,
    8.13597129046903e-01,
    8.14158772026536e-01,
    8.14719788879792e-01,
    8.15280176757753e-01,
    8.15839932823521e-01,
    8.16399054252226e-01,
    8.16957538231043e-01,
    8.17515381959209e-01,
    8.18072582648034e-01,
    8.18629137520914e-01,
    8.19185043813348e-01,
    8.19740298772947e-01,
    8.20294899659451e-01,
    8.20848843744741e-01,
    8.21402128312850e-01,
    8.21954750659975e-01,
    8.22506708094495e-01,
    8.23057997936977e-01,
    8.23608617520188e-01,
    8.24158564189110e-01,
    8.24707835300952e-01,
    8.25256428225157e-01,
    8.25804340343416e-01,
    8.26351569049677e-01,
    8.26898111750160e-01,
    8.27443965863361e-01,
    8.27989128820068e-01,
    8.28533598063365e-01,
    8.29077371048648e-01,
    8.29620445243633e-01,
    8.30162818128362e-01,
    8.30704487195215e-01,
    8.31245449948917e-01,
    8.31785703906551e-01,
    8.32325246597563e-01,
    8.32864075563770e-01,
    8.33402188359369e-01,
    8.33939582550946e-01,
    8.34476255717484e-01,
    8.35012205450367e-01,
    8.35547429353392e-01,
    8.36081925042774e-01,
    8.36615690147150e-01,
    8.37148722307591e-01,
    8.37681019177606e-01,
    8.38212578423147e-01,
    8.38743397722619e-01,
    8.39273474766881e-01,
    8.39802807259255e-01,
    8.40331392915531e-01,
    8.40859229463970e-01,
    8.41386314645314e-01,
    8.41912646212785e-01,
    8.42438221932096e-01,
    8.42963039581447e-01,
    8.43487096951539e-01,
    8.44010391845573e-01,
    8.44532922079251e-01,
    8.45054685480787e-01,
    8.45575679890903e-01,
    8.46095903162839e-01,
    8.46615353162351e-01,
    8.47134027767716e-01,
    8.47651924869736e-01,
    8.48169042371738e-01,
    8.48685378189575e-01,
    8.49200930251636e-01,
    8.49715696498836e-01,
    8.50229674884629e-01,
    8.50742863375003e-01,
    8.51255259948482e-01,
    8.51766862596128e-01,
    8.52277669321544e-01,
    8.52787678140871e-01,
    8.53296887082791e-01,
    8.53805294188527e-01,
    8.54312897511841e-01,
    8.54819695119037e-01,
    8.55325685088960e-01,
    8.55830865512994e-01,
    8.56335234495064e-01,
    8.56838790151632e-01,
    8.57341530611699e-01,
    8.57843454016802e-01,
    8.58344558521012e-01,
    8.58844842290937e-01,
    8.59344303505713e-01,
    8.59842940357008e-01,
    8.60340751049017e-01,
    8.60837733798460e-01,
    8.61333886834583e-01,
    8.61829208399149e-01,
    8.62323696746438e-01,
    8.62817350143247e-01,
    8.63310166868883e-01,
    8.63802145215159e-01,
    8.64293283486395e-01,
    8.64783579999408e-01,
    8.65273033083514e-01,
    8.65761641080520e-01,
    8.66249402344719e-01,
    8.66736315242891e-01,
    8.67222378154290e-01,
    8.67707589470646e-01,
    8.68191947596157e-01,
    8.68675450947485e-01,
    8.69158097953749e-01,
    8.69639887056518e-01,
    8.70120816709812e-01,
    8.70600885380087e-01,
    8.71080091546234e-01,
    8.71558433699574e-01,
    8.72035910343847e-01,
    8.72512519995209e-01,
    8.72988261182221e-01,
    8.73463132445849e-01,
    8.73937132339449e-01,
    8.74410259428764e-01,
    8.74882512291916e-01,
    8.75353889519396e-01,
    8.75824389714061e-01,
    8.76294011491118e-01,
    8.76762753478124e-01,
    8.77230614314974e-01,
    8.77697592653890e-01,
    8.78163687159416e-01,
    8.78628896508408e-01,
    8.79093219390024e-01,
    8.79556654505713e-01,
    8.80019200569212e-01,
    8.80480856306529e-01,
    8.80941620455936e-01,
    8.81401491767962e-01,
    8.81860469005378e-01,
    8.82318550943189e-01,
    8.82775736368624e-01,
    8.83232024081124e-01,
    8.83687412892333e-01,
    8.84141901626085e-01,
    8.84595489118395e-01,
    8.85048174217445e-01,
    8.85499955783576e-01,
    8.85950832689272e-01,
    8.86400803819154e-01,
    8.86849868069961e-01,
    8.87298024350545e-01,
    8.87745271581854e-01,
    8.88191608696921e-01,
    8.88637034640852e-01,
    8.89081548370811e-01,
    8.89525148856012e-01,
    8.89967835077700e-01,
    8.90409606029140e-01,
    8.90850460715608e-01,
    8.91290398154369e-01,
    8.91729417374672e-01,
    8.92167517417730e-01,
    8.92604697336709e-01,
    8.93040956196711e-01,
    8.93476293074766e-01,
    8.93910707059811e-01,
    8.94344197252675e-01,
    8.94776762766072e-01,
    8.95208402724578e-01,
    8.95639116264621e-01,
    8.96068902534462e-01,
    8.96497760694181e-01,
    8.96925689915667e-01,
    8.97352689382591e-01,
    8.97778758290402e-01,
    8.98203895846303e-01,
    8.98628101269237e-01,
    8.99051373789874e-01,
    8.99473712650591e-01,
    8.99895117105456e-01,
    9.00315586420213e-01,
    9.00735119872263e-01,
    9.01153716750651e-01,
    9.01571376356042e-01,
    9.01988098000712e-01,
    9.02403881008525e-01,
    9.02818724714917e-01,
    9.03232628466879e-01,
    9.03645591622938e-01,
    9.04057613553142e-01,
    9.04468693639038e-01,
    9.04878831273655e-01,
    9.05288025861489e-01,
    9.05696276818481e-01,
    9.06103583571999e-01,
    9.06509945560819e-01,
    9.06915362235107e-01,
    9.07319833056402e-01,
    9.07723357497592e-01,
    9.08125935042900e-01,
    9.08527565187861e-01,
    9.08928247439303e-01,
    9.09327981315329e-01,
    9.09726766345296e-01,
    9.10124602069795e-01,
    9.10521488040634e-01,
    9.10917423820811e-01,
    9.11312408984501e-01,
    9.11706443117033e-01,
    9.12099525814868e-01,
    9.12491656685578e-01,
    9.12882835347830e-01,
    9.13273061431360e-01,
    9.13662334576953e-01,
    9.14050654436426e-01,
    9.14438020672601e-01,
    9.14824432959287e-01,
    9.15209890981255e-01,
    9.15594394434225e-01,
    9.15977943024833e-01,
    9.16360536470617e-01,
    9.16742174499993e-01,
    9.17122856852230e-01,
    9.17502583277433e-01,
    9.17881353536518e-01,
    9.18259167401186e-01,
    9.18636024653911e-01,
    9.19011925087904e-01,
    9.19386868507099e-01,
    9.19760854726130e-01,
    9.20133883570302e-01,
    9.20505954875576e-01,
    9.20877068488539e-01,
    9.21247224266385e-01,
    9.21616422076887e-01,
    9.21984661798381e-01,
    9.22351943319735e-01,
    9.22718266540328e-01,
    9.23083631370028e-01,
    9.23448037729164e-01,
    9.23811485548507e-01,
    9.24173974769243e-01,
    9.24535505342946e-01,
    9.24896077231560e-01,
    9.25255690407369e-01,
    9.25614344852978e-01,
    9.25972040561280e-01,
    9.26328777535440e-01,
    9.26684555788866e-01,
    9.27039375345184e-01,
    9.27393236238212e-01,
    9.27746138511938e-01,
    9.28098082220495e-01,
    9.28449067428129e-01,
    9.28799094209183e-01,
    9.29148162648064e-01,
    9.29496272839223e-01,
    9.29843424887123e-01,
    9.30189618906218e-01,
    9.30534855020929e-01,
    9.30879133365611e-01,
    9.31222454084533e-01,
    9.31564817331849e-01,
    9.31906223271574e-01,
    9.32246672077552e-01,
    9.32586163933440e-01,
    9.32924699032671e-01,
    9.33262277578432e-01,
    9.33598899783639e-01,
    9.33934565870906e-01,
    9.34269276072523e-01,
    9.34603030630425e-01,
    9.34935829796166e-01,
    9.35267673830894e-01,
    9.35598563005322e-01,
    9.35928497599701e-01,
    9.36257477903792e-01,
    9.36585504216841e-01,
    9.36912576847548e-01,
    9.37238696114042e-01,
    9.37563862343854e-01,
    9.37888075873887e-01,
    9.38211337050389e-01,
    9.38533646228926e-01,
    9.38855003774354e-01,
    9.39175410060789e-01,
    9.39494865471582e-01,
    9.39813370399288e-01,
    9.40130925245639e-01,
    9.40447530421518e-01,
    9.40763186346925e-01,
    9.41077893450955e-01,
    9.41391652171765e-01,
    9.41704462956546e-01,
    9.42016326261498e-01,
    9.42327242551798e-01,
    9.42637212301568e-01,
    9.42946235993856e-01,
    9.43254314120596e-01,
    9.43561447182588e-01,
    9.43867635689463e-01,
    9.44172880159657e-01,
    9.44477181120380e-01,
    9.44780539107588e-01,
    9.45082954665955e-01,
    9.45384428348841e-01,
    9.45684960718263e-01,
    9.45984552344868e-01,
    9.46283203807900e-01,
    9.46580915695175e-01,
    9.46877688603047e-01,
    9.47173523136378e-01,
    9.47468419908515e-01,
    9.47762379541251e-01,
    9.48055402664803e-01,
    9.48347489917777e-01,
    9.48638641947140e-01,
    9.48928859408191e-01,
    9.49218142964530e-01,
    9.49506493288025e-01,
    9.49793911058788e-01,
    9.50080396965140e-01,
    9.50365951703582e-01,
    9.50650575978766e-01,
    9.50934270503462e-01,
    9.51217035998531e-01,
    9.51498873192891e-01,
    9.51779782823491e-01,
    9.52059765635275e-01,
    9.52338822381156e-01,
    9.52616953821983e-01,
    9.52894160726511e-01,
    9.53170443871372e-01,
    9.53445804041041e-01,
    9.53720242027805e-01,
    9.53993758631740e-01,
    9.54266354660667e-01,
    9.54538030930135e-01,
    9.54808788263379e-01,
    9.55078627491295e-01,
    9.55347549452408e-01,
    9.55615554992839e-01,
    9.55882644966277e-01,
    9.56148820233945e-01,
    9.56414081664572e-01,
    9.56678430134358e-01,
    9.56941866526946e-01,
    9.57204391733388e-01,
    9.57466006652119e-01,
    9.57726712188918e-01,
    9.57986509256882e-01,
    9.58245398776394e-01,
    9.58503381675091e-01,
    9.58760458887832e-01,
    9.59016631356668e-01,
    9.59271900030808e-01,
    9.59526265866590e-01,
    9.59779729827449e-01,
    9.60032292883885e-01,
    9.60283956013432e-01,
    9.60534720200624e-01,
    9.60784586436967e-01,
    9.61033555720906e-01,
    9.61281629057792e-01,
    9.61528807459852e-01,
    9.61775091946154e-01,
    9.62020483542584e-01,
    9.62264983281802e-01,
    9.62508592203219e-01,
    9.62751311352963e-01,
    9.62993141783846e-01,
    9.63234084555333e-01,
    9.63474140733511e-01,
    9.63713311391055e-01,
    9.63951597607199e-01,
    9.64189000467701e-01,
    9.64425521064813e-01,
    9.64661160497252e-01,
    9.64895919870159e-01,
    9.65129800295078e-01,
    9.65362802889916e-01,
    9.65594928778915e-01,
    9.65826179092620e-01,
    9.66056554967845e-01,
    9.66286057547641e-01,
    9.66514687981268e-01,
    9.66742447424158e-01,
    9.66969337037886e-01,
    9.67195357990135e-01,
    9.67420511454670e-01,
    9.67644798611297e-01,
    9.67868220645841e-01,
    9.68090778750105e-01,
    9.68312474121845e-01,
    9.68533307964732e-01,
    9.68753281488324e-01,
    9.68972395908034e-01,
    9.69190652445093e-01,
    9.69408052326527e-01,
    9.69624596785115e-01,
    9.69840287059362e-01,
    9.70055124393470e-01,
    9.70269110037298e-01,
    9.70482245246337e-01,
    9.70694531281673e-01,
    9.70905969409960e-01,
    9.71116560903383e-01,
    9.71326307039629e-01,
    9.71535209101853e-01,
    9.71743268378649e-01,
    9.71950486164013e-01,
    9.72156863757318e-01,
    9.72362402463273e-01,
    9.72567103591901e-01,
    9.72770968458498e-01,
    9.72973998383605e-01,
    9.73176194692980e-01,
    9.73377558717557e-01,
    9.73578091793422e-01,
    9.73777795261776e-01,
    9.73976670468907e-01,
    9.74174718766154e-01,
    9.74371941509879e-01,
    9.74568340061432e-01,
    9.74763915787121e-01,
    9.74958670058179e-01,
    9.75152604250733e-01,
    9.75345719745770e-01,
    9.75538017929110e-01,
    9.75729500191369e-01,
    9.75920167927928e-01,
    9.76110022538904e-01,
    9.76299065429119e-01,
    9.76487298008059e-01,
    9.76674721689855e-01,
    9.76861337893244e-01,
    9.77047148041538e-01,
    9.77232153562592e-01,
    9.77416355888775e-01,
    9.77599756456936e-01,
    9.77782356708371e-01,
    9.77964158088797e-01,
    9.78145162048315e-01,
    9.78325370041377e-01,
    9.78504783526764e-01,
    9.78683403967543e-01,
    9.78861232831042e-01,
    9.79038271588817e-01,
    9.79214521716622e-01,
    9.79389984694374e-01,
    9.79564662006126e-01,
    9.79738555140032e-01,
    9.79911665588317e-01,
    9.80083994847247e-01,
    9.80255544417095e-01,
    9.80426315802112e-01,
    9.80596310510494e-01,
    9.80765530054354e-01,
    9.80933975949688e-01,
    9.81101649716340e-01,
    9.81268552877982e-01,
    9.81434686962072e-01,
    9.81600053499827e-01,
    9.81764654026194e-01,
    9.81928490079817e-01,
    9.82091563203004e-01,
    9.82253874941700e-01,
    9.82415426845455e-01,
    9.82576220467389e-01,
    9.82736257364169e-01,
    9.82895539095971e-01,
    9.83054067226452e-01,
    9.83211843322720e-01,
    9.83368868955303e-01,
    9.83525145698117e-01,
    9.83680675128438e-01,
    9.83835458826867e-01,
    9.83989498377304e-01,
    9.84142795366917e-01,
    9.84295351386106e-01,
    9.84447168028481e-01,
    9.84598246890825e-01,
    9.84748589573067e-01,
    9.84898197678251e-01,
    9.85047072812504e-01,
    9.85195216585009e-01,
    9.85342630607971e-01,
    9.85489316496591e-01,
    9.85635275869032e-01,
    9.85780510346392e-01,
    9.85925021552671e-01,
    9.86068811114746e-01,
    9.86211880662333e-01,
    9.86354231827965e-01,
    9.86495866246959e-01,
    9.86636785557386e-01,
    9.86776991400039e-01,
    9.86916485418409e-01,
    9.87055269258651e-01,
    9.87193344569554e-01,
    9.87330713002514e-01,
    9.87467376211505e-01,
    9.87603335853044e-01,
    9.87738593586168e-01,
    9.87873151072402e-01,
    9.88007009975729e-01,
    9.88140171962561e-01,
    9.88272638701712e-01,
    9.88404411864364e-01,
    9.88535493124042e-01,
    9.88665884156585e-01,
    9.88795586640115e-01,
    9.88924602255008e-01,
    9.89052932683865e-01,
    9.89180579611486e-01,
    9.89307544724836e-01,
    9.89433829713023e-01,
    9.89559436267263e-01,
    9.89684366080855e-01,
    9.89808620849147e-01,
    9.89932202269518e-01,
    9.90055112041339e-01,
    9.90177351865949e-01,
    9.90298923446627e-01,
    9.90419828488562e-01,
    9.90540068698827e-01,
    9.90659645786347e-01,
    9.90778561461874e-01,
    9.90896817437958e-01,
    9.91014415428920e-01,
    9.91131357150820e-01,
    9.91247644321434e-01,
    9.91363278660224e-01,
    9.91478261888309e-01,
    9.91592595728437e-01,
    9.91706281904962e-01,
    9.91819322143809e-01,
    9.91931718172454e-01,
    9.92043471719889e-01,
    9.92154584516601e-01,
    9.92265058294539e-01,
    9.92374894787092e-01,
    9.92484095729056e-01,
    9.92592662856614e-01,
    9.92700597907298e-01,
    9.92807902619975e-01,
    9.92914578734809e-01,
    9.93020627993240e-01,
    9.93126052137954e-01,
    9.93230852912859e-01,
    9.93335032063055e-01,
    9.93438591334808e-01,
    9.93541532475527e-01,
    9.93643857233733e-01,
    9.93745567359031e-01,
    9.93846664602091e-01,
    9.93947150714612e-01,
    9.94047027449305e-01,
    9.94146296559857e-01,
    9.94244959800916e-01,
    9.94343018928052e-01,
    9.94440475697742e-01,
    9.94537331867337e-01,
    9.94633589195039e-01,
    9.94729249439875e-01,
    9.94824314361669e-01,
    9.94918785721019e-01,
    9.95012665279270e-01,
    9.95105954798487e-01,
    9.95198656041431e-01,
    9.95290770771535e-01,
    9.95382300752874e-01,
    9.95473247750142e-01,
    9.95563613528629e-01,
    9.95653399854193e-01,
    9.95742608493234e-01,
    9.95831241212671e-01,
    9.95919299779917e-01,
    9.96006785962850e-01,
    9.96093701529795e-01,
    9.96180048249495e-01,
    9.96265827891081e-01,
    9.96351042224061e-01,
    9.96435693018280e-01,
    9.96519782043906e-01,
    9.96603311071402e-01,
    9.96686281871501e-01,
    9.96768696215180e-01,
    9.96850555873642e-01,
    9.96931862618283e-01,
    9.97012618220677e-01,
    9.97092824452543e-01,
    9.97172483085728e-01,
    9.97251595892180e-01,
    9.97330164643923e-01,
    9.97408191113035e-01,
    9.97485677071625e-01,
    9.97562624291808e-01,
    9.97639034545679e-01,
    9.97714909605297e-01,
    9.97790251242650e-01,
    9.97865061229644e-01,
    9.97939341338072e-01,
    9.98013093339590e-01,
    9.98086319005701e-01,
    9.98159020107724e-01,
    9.98231198416775e-01,
    9.98302855703745e-01,
    9.98373993739273e-01,
    9.98444614293728e-01,
    9.98514719137184e-01,
    9.98584310039394e-01,
    9.98653388769775e-01,
    9.98721957097378e-01,
    9.98790016790872e-01,
    9.98857569618515e-01,
    9.98924617348139e-01,
    9.98991161747120e-01,
    9.99057204582363e-01,
    9.99122747620275e-01,
    9.99187792626746e-01,
    9.99252341367125e-01,
    9.99316395606199e-01,
    9.99379957108172e-01,
    9.99443027636643e-01,
    9.99505608954582e-01,
    9.99567702824314e-01,
    9.99629311007491e-01,
    9.99690435265074e-01,
    9.99751077357313e-01,
    9.99811239043723e-01,
    9.99870922083064e-01,
    9.99930128233320e-01,
    9.99988859251679e-01,
    1.00004711689451e+00,
    1.00010490291734e+00,
    1.00016221907484e+00,
    1.00021906712081e+00,
    1.00027544880813e+00,
    1.00033136588877e+00,
    1.00038682011376e+00,
    1.00044181323316e+00,
    1.00049634699605e+00,
    1.00055042315052e+00,
    1.00060404344361e+00,
    1.00065720962133e+00,
    1.00070992342865e+00,
    1.00076218660943e+00,
    1.00081400090642e+00,
    1.00086536806127e+00,
    1.00091628981449e+00,
    1.00096676790540e+00,
    1.00101680407216e+00,
    1.00106640005174e+00,
    1.00111555757986e+00,
    1.00116427839101e+00,
    1.00121256421845e+00,
    1.00126041679411e+00,
    1.00130783784868e+00,
    1.00135482911149e+00,
    1.00140139231055e+00,
    1.00144752917253e+00,
    1.00149324142271e+00,
    1.00153853078498e+00,
    1.00158339898183e+00,
    1.00162784773431e+00,
    1.00167187876204e+00,
    1.00171549378316e+00,
    1.00175869451433e+00,
    1.00180148267072e+00,
    1.00184385996596e+00,
    1.00188582811217e+00,
    1.00192738881988e+00,
    1.00196854379807e+00,
    1.00200929475413e+00,
    1.00204964339384e+00,
    1.00208959142133e+00,
    1.00212914053912e+00,
    1.00216829244805e+00,
    1.00220704884727e+00,
    1.00224541143427e+00,
    1.00228338190479e+00,
    1.00232096195286e+00,
    1.00235815327074e+00,
    1.00239495754896e+00,
    1.00243137647624e+00,
    1.00246741173951e+00,
    1.00250306502388e+00,
    1.00253833801264e+00,
    1.00257323238722e+00,
    1.00260774982719e+00,
    1.00264189201024e+00,
    1.00267566061215e+00,
    1.00270905730680e+00,
    1.00274208376613e+00,
    1.00277474166014e+00,
    1.00280703265686e+00,
    1.00283895842235e+00,
    1.00287052062067e+00,
    1.00290172091386e+00,
    1.00293256096196e+00,
    1.00296304242293e+00,
    1.00299316695271e+00,
    1.00302293620515e+00,
    1.00305235183201e+00,
    1.00308141548294e+00,
    1.00311012880548e+00,
    1.00313849344505e+00,
    1.00316651104488e+00,
    1.00319418324609e+00,
    1.00322151168757e+00,
    1.00324849800604e+00,
    1.00327514383601e+00,
    1.00330145080976e+00,
    1.00332742055734e+00,
    1.00335305470654e+00,
    1.00337835488289e+00,
    1.00340332270962e+00,
    1.00342795980768e+00,
    1.00345226779570e+00,
    1.00347624829001e+00,
    1.00349990290456e+00,
    1.00352323325098e+00,
    1.00354624093852e+00,
    1.00356892757405e+00,
    1.00359129476204e+00,
    1.00361334410456e+00,
    1.00363507720127e+00,
    1.00365649564936e+00,
    1.00367760104361e+00,
    1.00369839497631e+00,
    1.00371887903728e+00,
    1.00373905481387e+00,
    1.00375892389090e+00,
    1.00377848785069e+00,
    1.00379774827304e+00,
    1.00381670673518e+00,
    1.00383536481183e+00,
    1.00385372407509e+00,
    1.00387178609454e+00,
    1.00388955243711e+00,
    1.00390702466717e+00,
    1.00392420434644e+00,
    1.00394109303404e+00,
    1.00395769228643e+00,
    1.00397400365743e+00,
    1.00399002869816e+00,
    1.00400576895711e+00,
    1.00402122598005e+00,
    1.00403640131005e+00,
    1.00405129648747e+00,
    1.00406591304994e+00,
    1.00408025253237e+00,
    1.00409431646690e+00,
    1.00410810638292e+00,
    1.00412162380705e+00,
    1.00413487026310e+00,
    1.00414784727214e+00,
    1.00416055635237e+00,
    1.00417299901922e+00,
    1.00418517678528e+00,
    1.00419709116028e+00,
    1.00420874365113e+00,
    1.00422013576186e+00,
    1.00423126899363e+00,
    1.00424214484472e+00,
    1.00425276481053e+00,
    1.00426313038352e+00,
    1.00427324305328e+00,
    1.00428310430645e+00,
    1.00429271562673e+00,
    1.00430207849489e+00,
    1.00431119438874e+00,
    1.00432006478312e+00,
    1.00432869114990e+00,
    1.00433707495796e+00,
    1.00434521767318e+00,
    1.00435312075845e+00,
    1.00436078567363e+00,
    1.00436821387556e+00,
    1.00437540681805e+00,
    1.00438236595186e+00,
    1.00438909272470e+00,
    1.00439558858122e+00,
    1.00440185496299e+00,
    1.00440789330850e+00,
    1.00441370505315e+00,
    1.00441929162926e+00,
    1.00442465446601e+00,
    1.00442979498949e+00,
    1.00443471462263e+00,
    1.00443941478527e+00,
    1.00444389689406e+00,
    1.00444816236254e+00,
    1.00445221260106e+00,
    1.00445604901680e+00,
    1.00445967301379e+00,
    1.00446308599284e+00,
    1.00446628935158e+00,
    1.00446928448445e+00,
    1.00447207278266e+00,
    1.00447465563420e+00,
    1.00447703442384e+00,
    1.00447921053313e+00,
    1.00448118534036e+00,
    1.00448296022056e+00,
    1.00448453654552e+00,
    1.00448591568375e+00,
    1.00448709900051e+00,
    1.00448808785775e+00,
    1.00448888361414e+00,
    1.00448948762508e+00,
    1.00448990124262e+00,
    1.00449012581554e+00,
    1.00449016268929e+00,
    1.00449001320598e+00,
    1.00448967870440e+00,
    1.00448916052002e+00,
    1.00448845998493e+00,
    1.00448757842789e+00,
    1.00448651717430e+00,
    1.00448527754618e+00,
    1.00448386086219e+00,
    1.00448226843761e+00,
    1.00448050158434e+00,
    1.00447856161087e+00,
    1.00447644982231e+00,
    1.00447416752035e+00,
    1.00447171600329e+00,
    1.00446909656600e+00,
    1.00446631049992e+00,
    1.00446335909307e+00,
    1.00446024363005e+00,
    1.00445696539200e+00,
    1.00445352565660e+00,
    1.00444992569812e+00,
    1.00444616678734e+00,
    1.00444225019159e+00,
    1.00443817717472e+00,
    1.00443394899711e+00,
    1.00442956691567e+00,
    1.00442503218382e+00,
    1.00442034605148e+00,
    1.00441550976509e+00,
    1.00441052456758e+00,
    1.00440539169837e+00,
    1.00440011239339e+00,
    1.00439468788502e+00,
    1.00438911940215e+00,
    1.00438340817014e+00,
    1.00437755541080e+00,
    1.00437156234243e+00,
    1.00436543017978e+00,
    1.00435916013405e+00,
    1.00435275341290e+00,
    1.00434621122044e+00,
    1.00433953475722e+00,
    1.00433272522022e+00,
    1.00432578380286e+00,
    1.00431871169500e+00,
    1.00431151008291e+00,
    1.00430418014929e+00,
    1.00429672307327e+00,
    1.00428914003037e+00,
    1.00428143219253e+00,
    1.00427360072811e+00,
    1.00426564680185e+00,
    1.00425757157491e+00,
    1.00424937620483e+00,
    1.00424106184555e+00,
    1.00423262964740e+00,
    1.00422408075709e+00,
    1.00421541631771e+00,
    1.00420663746874e+00,
    1.00419774534602e+00,
    1.00418874108178e+00,
    1.00417962580459e+00,
    1.00417040063942e+00,
    1.00416106670758e+00,
    1.00415162512675e+00,
    1.00414207701097e+00,
    1.00413242347061e+00,
    1.00412266561242e+00,
    1.00411280453949e+00,
    1.00410284135126e+00,
    1.00409277714350e+00,
    1.00408261300832e+00,
    1.00407235003420e+00,
    1.00406198930591e+00,
    1.00405153190460e+00,
    1.00404097890772e+00,
    1.00403033138905e+00,
    1.00401959041871e+00,
    1.00400875706315e+00,
    1.00399783238513e+00,
    1.00398681744373e+00,
    1.00397571329435e+00,
    1.00396452098873e+00,
    1.00395324157488e+00,
    1.00394187609717e+00,
    1.00393042559625e+00,
    1.00391889110910e+00,
    1.00390727366900e+00,
    1.00389557430553e+00,
    1.00388379404459e+00,
    1.00387193390837e+00,
    1.00385999491538e+00,
    1.00384797808041e+00,
    1.00383588441457e+00,
    1.00382371492526e+00,
    1.00381147061618e+00,
    1.00379915248731e+00,
    1.00378676153496e+00,
    1.00377429875171e+00,
    1.00376176512643e+00,
    1.00374916164430e+00,
    1.00373648928678e+00,
    1.00372374903163e+00,
    1.00371094185290e+00,
    1.00369806872091e+00,
    1.00368513060230e+00,
    1.00367212845997e+00,
    1.00365906325313e+00,
    1.00364593593727e+00,
    1.00363274746417e+00,
    1.00361949878188e+00,
    1.00360619083476e+00,
    1.00359282456344e+00,
    1.00357940090486e+00,
    1.00356592079221e+00,
    1.00355238515499e+00,
    1.00353879491898e+00,
    1.00352515100626e+00,
    1.00351145433516e+00,
    1.00349770582034e+00,
    1.00348390637271e+00,
    1.00347005689949e+00,
    1.00345615830418e+00,
    1.00344221148655e+00,
    1.00342821734269e+00,
    1.00341417676496e+00,
    1.00340009064200e+00,
    1.00338595985875e+00,
    1.00337178529644e+00,
    1.00335756783258e+00,
    1.00334330834099e+00,
    1.00332900769177e+00,
    1.00331466675130e+00,
    1.00330028638226e+00,
    1.00328586744365e+00,
    1.00327141079073e+00,
    1.00325691727506e+00,
    1.00324238774452e+00,
    1.00322782304327e+00,
    1.00321322401176e+00,
    1.00319859148676e+00,
    1.00318392630134e+00,
    1.00316922928485e+00,
    1.00315450126297e+00,
    1.00313974305767e+00,
    1.00312495548723e+00,
    1.00311013936624e+00,
    1.00309529550559e+00,
    1.00308042471250e+00,
    1.00306552779047e+00,
    1.00305060553936e+00,
    1.00303565875529e+00,
    1.00302068823076e+00,
    1.00300569475453e+00,
    1.00299067911171e+00,
    1.00297564208374e+00,
    1.00296058444837e+00,
    1.00294550697967e+00,
    1.00293041044806e+00,
    1.00291529562028e+00,
    1.00290016325939e+00,
    1.00288501412481e+00,
    1.00286984897227e+00,
    1.00285466855385e+00,
    1.00283947361799e+00,
    1.00282426490944e+00,
    1.00280904316932e+00,
    1.00279380913508e+00,
    1.00277856354054e+00,
    1.00276330711586e+00,
    1.00274804058756e+00,
    1.00273276467851e+00,
    1.00271748010795e+00,
    1.00270218759148e+00,
    1.00268688784106e+00,
    1.00267158156504e+00,
    1.00265626946811e+00,
    1.00264095225135e+00,
    1.00262563061222e+00,
    1.00261030524455e+00,
    1.00259497683856e+00,
    1.00257964608086e+00,
    1.00256431365444e+00,
    1.00254898023867e+00,
    1.00253364650934e+00,
    1.00251831313861e+00,
    1.00250298079508e+00,
    1.00248765014371e+00,
    1.00247232184589e+00,
    1.00245699655942e+00,
    1.00244167493851e+00,
    1.00242635763379e+00,
    1.00241104529230e+00,
    1.00239573855752e+00,
    1.00238043806935e+00,
    1.00236514446411e+00,
    1.00234985837457e+00,
    1.00233458042993e+00,
    1.00231931125583e+00,
    1.00230405147437e+00,
    1.00228880170407e+00,
    1.00227356255993e+00,
    1.00225833465340e+00,
    1.00224311859237e+00,
    1.00222791498122e+00,
    1.00221272442078e+00,
    1.00219754750836e+00,
    1.00218238483775e+00,
    1.00216723699920e+00,
    1.00215210457947e+00,
    1.00213698816179e+00,
    1.00212188832588e+00,
    1.00210680564797e+00,
    1.00209174070077e+00,
    1.00207669405351e+00,
    1.00206166627193e+00,
    1.00204665791826e+00,
    1.00203166955127e+00,
    1.00201670172625e+00,
    1.00200175499500e+00,
    1.00198682990586e+00,
    1.00197192700371e+00,
    1.00195704682995e+00,
    1.00194218992254e+00,
    1.00192735681598e+00,
    1.00191254804133e+00,
    1.00189776412619e+00,
    1.00188300559474e+00,
    1.00186827296772e+00,
    1.00185356676244e+00,
    1.00183888749278e+00,
    1.00182423566921e+00,
    1.00180961179877e+00,
    1.00179501638512e+00,
    1.00178044992847e+00,
    1.00176591292568e+00,
    1.00175140587017e+00,
    1.00173692925199e+00,
    1.00172248355782e+00,
    1.00170806927092e+00,
    1.00169368687121e+00,
    1.00167933683522e+00,
    1.00166501963612e+00,
    1.00165073574373e+00,
    1.00163648562450e+00,
    1.00162226974153e+00,
    1.00160808855460e+00,
    1.00159394252010e+00,
    1.00157983209115e+00,
    1.00156575771749e+00,
    1.00155171984555e+00,
    1.00153771891847e+00,
    1.00152375537603e+00,
    1.00150982965474e+00,
    1.00149594218780e+00,
    1.00148209340509e+00,
    1.00146828373324e+00,
    1.00145451359556e+00,
    1.00144078341209e+00,
    1.00142709359961e+00,
    1.00141344457161e+00,
    1.00139983673833e+00,
    1.00138627050676e+00,
    1.00137274628062e+00,
    1.00135926446039e+00,
    1.00134582544332e+00,
    1.00133242962341e+00,
    1.00131907739145e+00,
    1.00130576913500e+00,
    1.00129250523839e+00,
    1.00127928608276e+00,
    1.00126611204603e+00,
    1.00125298350294e+00,
    1.00123990082500e+00,
    1.00122686438058e+00,
    1.00121387453484e+00,
    1.00120093164976e+00,
    1.00118803608418e+00,
    1.00117518819375e+00,
    1.00116238833098e+00,
    1.00114963684521e+00,
    1.00113693408267e+00,
    1.00112428038641e+00,
    1.00111167609638e+00,
    1.00109912154940e+00,
    1.00108661707916e+00,
    1.00107416301623e+00,
    1.00106175968810e+00,
    1.00104940741914e+00,
    1.00103710653064e+00,
    1.00102485734077e+00,
    1.00101266016467e+00,
    1.00100051531437e+00,
    1.00098842309883e+00,
    1.00097638382396e+00,
    1.00096439779263e+00,
    1.00095246530462e+00,
    1.00094058665672e+00,
    1.00092876214263e+00,
    1.00091699205307e+00,
    1.00090527667570e+00,
    1.00089361629520e+00,
    1.00088201119320e+00,
    1.00087046164836e+00,
    1.00085896793633e+00,
    1.00084753032979e+00,
    1.00083614909840e+00,
    1.00082482450888e+00,
    1.00081355682498e+00,
    1.00080234630746e+00,
    1.00079119321415e+00,
    1.00078009779992e+00,
    1.00076906031672e+00,
    1.00075808101353e+00,
    1.00074716013644e+00,
    1.00073629792859e+00,
    1.00072549463022e+00,
    1.00071475047867e+00,
    1.00070406570838e+00,
    1.00069344055087e+00,
    1.00068287523481e+00,
    1.00067236998598e+00,
    1.00066192502728e+00,
    1.00065154057876e+00,
    1.00064121685760e+00,
    1.00063095407813e+00,
    1.00062075245185e+00,
    1.00061061218742e+00,
    1.00060053349067e+00,
    1.00059051656461e+00,
    1.00058056160943e+00,
    1.00057066882251e+00,
    1.00056083839846e+00,
    1.00055107052906e+00,
    1.00054136540332e+00,
    1.00053172320749e+00,
    1.00052214412503e+00,
    1.00051262833664e+00,
    1.00050317602026e+00,
    1.00049378735109e+00,
    1.00048446250160e+00,
    1.00047520164150e+00,
    1.00046600493781e+00,
    1.00045687255478e+00,
    1.00044780465401e+00,
    1.00043880139435e+00,
    1.00042986293198e+00,
    1.00042098942037e+00,
    1.00041218101034e+00,
    1.00040343785000e+00,
    1.00039476008483e+00,
    1.00038614785762e+00,
    1.00037760130853e+00,
    1.00036912057508e+00,
    1.00036070579214e+00,
    1.00035235709196e+00,
    1.00034407460417e+00,
    1.00033585845578e+00,
    1.00032770877121e+00,
    1.00031962567227e+00,
    1.00031160927819e+00,
    1.00030365970562e+00,
    1.00029577706861e+00,
    1.00028796147869e+00,
    1.00028021304479e+00,
    1.00027253187332e+00,
    1.00026491806812e+00,
    1.00025737173051e+00,
    1.00024989295929e+00,
    1.00024248185073e+00,
    1.00023513849859e+00,
    1.00022786299413e+00,
    1.00022065542612e+00,
    1.00021351588082e+00,
    1.00020644444203e+00,
    1.00019944119107e+00,
    1.00019250620681e+00,
    1.00018563956565e+00,
    1.00017884134154e+00,
    1.00017211160600e+00,
    1.00016545042811e+00,
    1.00015885787453e+00,
    1.00015233400950e+00,
    1.00014587889486e+00,
    1.00013949259004e+00,
    1.00013317515209e+00,
    1.00012692663566e+00,
    1.00012074709304e+00,
    1.00011463657413e+00,
    1.00010859512650e+00,
    1.00010262279535e+00,
    1.00009671962354e+00,
    1.00009088565158e+00,
    1.00008512091768e+00,
    1.00007942545772e+00,
    1.00007379930526e+00,
    1.00006824249156e+00,
    1.00006275504559e+00,
    1.00005733699403e+00,
    1.00005198836129e+00,
    1.00004670916950e+00,
    1.00004149943852e+00,
    1.00003635918597e+00,
    1.00003128842723e+00,
    1.00002628717543e+00,
    1.00002135544146e+00,
    1.00001649323402e+00,
    1.00001170055957e+00,
    1.00000697742238e+00,
    1.00000232382452e+00,
    9.99997739765872e-01,
    9.99993225244129e-01,
    9.99988780254824e-01,
    9.99984404791326e-01,
    9.99980098844846e-01,
    9.99975862404452e-01,
    9.99971695457067e-01,
    9.99967597987491e-01,
    9.99963569978400e-01,
    9.99959611410356e-01,
    9.99955722261818e-01,
    9.99951902509146e-01,
    9.99948152126615e-01,
    9.99944471086417e-01,
    9.99940859358675e-01,
    9.99937316911448e-01,
    9.99933843710741e-01,
    9.99930439720514e-01,
    9.99927104902686e-01,
    9.99923839217149e-01,
    9.99920642621773e-01,
    9.99917515072417e-01,
    9.99914456522935e-01,
    9.99911466925186e-01,
    9.99908546229039e-01,
    9.99905694382387e-01,
    9.99902911331153e-01,
    9.99900197019297e-01,
    9.99897551388826e-01,
    9.99894974379801e-01,
    9.99892465930348e-01,
    9.99890025976665e-01,
    9.99887654453029e-01,
    9.99885351291808e-01,
    9.99883116423465e-01,
    9.99880949776573e-01,
    9.99878851277815e-01,
    9.99876820852000e-01,
    9.99874858422068e-01,
    9.99872963909096e-01,
    9.99871137232315e-01,
    9.99869378309110e-01,
    9.99867687055029e-01,
    9.99866063383800e-01,
    9.99864507207328e-01,
    9.99863018435713e-01,
    9.99861596977254e-01,
    9.99860242738456e-01,
    9.99858955624044e-01,
    9.99857735536966e-01,
    9.99856582378405e-01,
    9.99855496047787e-01,
    9.99854476442786e-01,
    9.99853523459340e-01,
    9.99852636991652e-01,
    9.99851816932203e-01,
    9.99851063171759e-01,
    9.99850375599380e-01,
    9.99849754102427e-01,
    9.99849198566574e-01,
    9.99848708875814e-01,
    9.99848284912466e-01,
    9.99847926557191e-01,
    9.99847633688989e-01,
    9.99847406185217e-01,
    9.99847243921596e-01,
    9.99847146772215e-01,
    9.99847114609544e-01,
    9.99847147304440e-01,
    9.99847244726160e-01,
    9.99847406742363e-01,
    9.99847633219123e-01,
    9.99847924020938e-01,
    9.99848279010734e-01,
    9.99848698049881e-01,
    9.99849180998193e-01,
    9.99849727713944e-01,
    9.99850338053872e-01,
    9.99851011873190e-01,
    9.99851749025593e-01,
    9.99852549363268e-01,
    9.99853412736901e-01,
    9.99854338995687e-01,
    9.99855327987338e-01,
    9.99856379558091e-01,
    9.99857493552719e-01,
    9.99858669814536e-01,
    9.99859908185407e-01,
    9.99861208505760e-01,
    9.99862570614589e-01,
    9.99863994349465e-01,
    9.99865479546547e-01,
    9.99867026040585e-01,
    9.99868633664936e-01,
    9.99870302251564e-01,
    9.99872031631057e-01,
    9.99873821632630e-01,
    9.99875672084134e-01,
    9.99877582812068e-01,
    9.99879553641583e-01,
    9.99881584396496e-01,
    9.99883674899293e-01,
    9.99885824971140e-01,
    9.99888034431894e-01,
    9.99890303100106e-01,
    9.99892630793034e-01,
    9.99895017326652e-01,
    9.99897462515655e-01,
    9.99899966173468e-01,
    9.99902528112260e-01,
    9.99905148142944e-01,
    9.99907826075194e-01,
    9.99910561717446e-01,
    9.99913354876913e-01,
    9.99916205359587e-01,
    9.99919112970255e-01,
    9.99922077512502e-01,
    9.99925098788720e-01,
    9.99928176600119e-01,
    9.99931310746734e-01,
    9.99934501027434e-01,
    9.99937747239929e-01,
    9.99941049180781e-01,
    9.99944406645409e-01,
    9.99947819428103e-01,
    9.99951287322026e-01,
    9.99954810119226e-01,
    9.99958387610648e-01,
    9.99962019586132e-01,
    9.99965705834433e-01,
    9.99969446143224e-01,
    9.99973240299101e-01,
    9.99977088087601e-01,
    9.99980989293201e-01,
    9.99984943699330e-01,
    9.99988951088381e-01,
    9.99993011241712e-01,
    9.99997123939662e-01,
    1.00000128896155e+00,
    1.00000550608570e+00,
    1.00000977508943e+00,
    1.00001409574908e+00,
    1.00001846783999e+00,
    1.00002289113654e+00,
    1.00002736541215e+00,
    1.00003189043928e+00,
    1.00003646598944e+00,
    1.00004109183321e+00,
    1.00004576774022e+00,
    1.00005049347922e+00,
    1.00005526881799e+00,
    1.00006009352346e+00,
    1.00006496736161e+00,
    1.00006989009758e+00,
    1.00007486149560e+00,
    1.00007988131904e+00,
    1.00008494933040e+00,
    1.00009006529132e+00,
    1.00009522896261e+00,
    1.00010044010423e+00,
    1.00010569847531e+00,
    1.00011100383416e+00,
    1.00011635593826e+00,
    1.00012175454432e+00,
    1.00012719940823e+00,
    1.00013269028508e+00,
    1.00013822692919e+00,
    1.00014380909412e+00,
    1.00014943653264e+00,
    1.00015510899679e+00,
    1.00016082623784e+00,
    1.00016658800633e+00,
    1.00017239405207e+00,
    1.00017824412413e+00,
    1.00018413797090e+00,
    1.00019007534002e+00,
    1.00019605597846e+00,
    1.00020207963249e+00,
    1.00020814604769e+00,
    1.00021425496897e+00,
    1.00022040614058e+00,
    1.00022659930610e+00,
    1.00023283420847e+00,
    1.00023911058998e+00,
    1.00024542819229e+00,
    1.00025178675642e+00,
    1.00025818602279e+00,
    1.00026462573120e+00,
    1.00027110562084e+00,
    1.00027762543034e+00,
    1.00028418489769e+00,
    1.00029078376034e+00,
    1.00029742175517e+00,
    1.00030409861847e+00,
    1.00031081408600e+00,
    1.00031756789297e+00,
    1.00032435977403e+00,
    1.00033118946334e+00,
    1.00033805669449e+00,
    1.00034496120058e+00,
    1.00035190271422e+00,
    1.00035888096748e+00,
    1.00036589569198e+00,
    1.00037294661882e+00,
    1.00038003347865e+00,
    1.00038715600163e+00,
    1.00039431391750e+00,
    1.00040150695549e+00,
    1.00040873484444e+00,
    1.00041599731272e+00,
    1.00042329408829e+00,
    1.00043062489866e+00,
    1.00043798947097e+00,
    1.00044538753192e+00,
    1.00045281880783e+00,
    1.00046028302461e+00,
    1.00046777990781e+00,
    1.00047530918260e+00,
    1.00048287057378e+00,
    1.00049046380578e+00,
    1.00049808860270e+00,
    1.00050574468827e+00,
    1.00051343178591e+00,
    1.00052114961869e+00,
    1.00052889790938e+00,
    1.00053667638041e+00,
    1.00054448475393e+00,
    1.00055232275176e+00,
    1.00056019009547e+00,
    1.00056808650632e+00,
    1.00057601170528e+00,
    1.00058396541310e+00,
    1.00059194735022e+00,
    1.00059995723685e+00,
    1.00060799479295e+00,
    1.00061605973824e+00,
    1.00062415179222e+00,
    1.00063227067415e+00,
    1.00064041610307e+00,
    1.00064858779784e+00,
    1.00065678547710e+00,
    1.00066500885928e+00,
    1.00067325766265e+00,
    1.00068153160529e+00,
    1.00068983040510e+00,
    1.00069815377984e+00,
    1.00070650144708e+00,
    1.00071487312426e+00,
    1.00072326852868e+00,
    1.00073168737748e+00,
    1.00074012938770e+00,
    1.00074859427625e+00,
    1.00075708175992e+00,
    1.00076559155540e+00,
    1.00077412337926e+00,
    1.00078267694801e+00,
    1.00079125197806e+00,
    1.00079984818574e+00,
    1.00080846528729e+00,
    1.00081710299893e+00,
    1.00082576103679e+00,
    1.00083443911696e+00,
    1.00084313695548e+00,
    1.00085185426836e+00,
    1.00086059077159e+00,
    1.00086934618113e+00,
    1.00087812021291e+00,
    1.00088691258288e+00,
    1.00089572300698e+00,
    1.00090455120114e+00,
    1.00091339688132e+00,
    1.00092225976349e+00,
    1.00093113956367e+00,
    1.00094003599788e+00,
    1.00094894878219e+00,
    1.00095787763275e+00,
    1.00096682226571e+00,
    1.00097578239732e+00,
    1.00098475774389e+00,
    1.00099374802179e+00,
    1.00100275294750e+00,
    1.00101177223756e+00,
    1.00102080560861e+00,
    1.00102985277741e+00,
    1.00103891346080e+00,
    1.00104798737576e+00,
    1.00105707423938e+00,
    1.00106617376888e+00,
    1.00107528568161e+00,
    1.00108440969506e+00,
    1.00109354552689e+00,
    1.00110269289488e+00,
    1.00111185151700e+00,
    1.00112102111138e+00,
    1.00113020139630e+00,
    1.00113939209026e+00,
    1.00114859291192e+00,
    1.00115780358015e+00,
    1.00116702381400e+00,
    1.00117625333274e+00,
    1.00118549185585e+00,
    1.00119473910303e+00,
    1.00120399479420e+00,
    1.00121325864953e+00,
    1.00122253038940e+00,
    1.00123180973446e+00,
    1.00124109640559e+00,
    1.00125039012395e+00,
    1.00125969061093e+00,
    1.00126899758822e+00,
    1.00127831077778e+00,
    1.00128762990183e+00,
    1.00129695468292e+00,
    1.00130628484385e+00,
    1.00131562010774e+00,
    1.00132496019802e+00,
    1.00133430483843e+00,
    1.00134365375302e+00,
    1.00135300666618e+00,
    1.00136236330262e+00,
    1.00137172338739e+00,
    1.00138108664587e+00,
    1.00139045280381e+00,
    1.00139982158730e+00,
    1.00140919272281e+00,
    1.00141856593714e+00,
    1.00142794095750e+00,
    1.00143731751145e+00,
    1.00144669532696e+00,
    1.00145607413237e+00,
    1.00146545365643e+00,
    1.00147483362827e+00,
    1.00148421377745e+00,
    1.00149359383393e+00,
    1.00150297352811e+00,
    1.00151235259077e+00,
    1.00152173075317e+00,
    1.00153110774698e+00,
    1.00154048330431e+00,
    1.00154985715773e+00,
    1.00155922904025e+00,
    1.00156859868535e+00,
    1.00157796582697e+00,
    1.00158733019951e+00,
    1.00159669153786e+00,
    1.00160604957738e+00,
    1.00161540405392e+00,
    1.00162475470383e+00,
    1.00163410126394e+00,
    1.00164344347159e+00,
    1.00165278106463e+00,
    1.00166211378143e+00,
    1.00167144136086e+00,
    1.00168076354233e+00,
    1.00169008006578e+00,
    1.00169939067167e+00,
    1.00170869510101e+00,
    1.00171799309535e+00,
    1.00172728439680e+00,
    1.00173656874802e+00,
    1.00174584589223e+00,
    1.00175511557322e+00,
    1.00176437753533e+00,
    1.00177363152351e+00,
    1.00178287728327e+00,
    1.00179211456071e+00,
    1.00180134310252e+00,
    1.00181056265600e+00,
    1.00181977296902e+00,
    1.00182897379010e+00,
    1.00183816486833e+00,
    1.00184734595344e+00,
    1.00185651679578e+00,
    1.00186567714632e+00,
    1.00187482675666e+00,
    1.00188396537905e+00,
    1.00189309276635e+00,
    1.00190220867211e+00,
    1.00191131285048e+00,
    1.00192040505631e+00,
    1.00192948504509e+00,
    1.00193855257297e+00,
    1.00194760739677e+00,
    1.00195664927400e+00,
    1.00196567796283e+00,
    1.00197469322213e+00,
    1.00198369481144e+00,
    1.00199268249100e+00,
    1.00200165602176e+00,
    1.00201061516535e+00,
    1.00201955968412e+00,
    1.00202848934112e+00,
    1.00203740390014e+00,
    1.00204630312565e+00,
    1.00205518678288e+00,
    1.00206405463777e+00,
    1.00207290645699e+00,
    1.00208174200797e+00,
    1.00209056105885e+00,
    1.00209936337854e+00,
    1.00210814873669e+00,
    1.00211691690370e+00,
    1.00212566765073e+00,
    1.00213440074972e+00,
    1.00214311597336e+00,
    1.00215181309511e+00,
    1.00216049188922e+00,
    1.00216915213070e+00,
    1.00217779359535e+00,
    1.00218641605977e+00,
    1.00219501930134e+00,
    1.00220360309824e+00,
    1.00221216722945e+00,
    1.00222071147474e+00,
    1.00222923561470e+00,
    1.00223773943074e+00,
    1.00224622270508e+00,
    1.00225468522074e+00,
    1.00226312676159e+00,
    1.00227154711231e+00,
    1.00227994605842e+00,
    1.00228832338627e+00,
    1.00229667888306e+00,
    1.00230501233680e+00,
    1.00231332353638e+00,
    1.00232161227153e+00,
    1.00232987833283e+00,
    1.00233812151171e+00,
    1.00234634160048e+00,
    1.00235453839229e+00,
    1.00236271168117e+00,
    1.00237086126203e+00,
    1.00237898693064e+00,
    1.00238708848366e+00,
    1.00239516571862e+00,
    1.00240321843395e+00,
    1.00241124642894e+00,
    1.00241924950381e+00,
    1.00242722745966e+00,
    1.00243518009847e+00,
    1.00244310722314e+00,
    1.00245100863748e+00,
    1.00245888414621e+00,
    1.00246673355494e+00,
    1.00247455667021e+00,
    1.00248235329948e+00,
    1.00249012325114e+00,
    1.00249786633448e+00,
    1.00250558235974e+00,
    1.00251327113808e+00,
    1.00252093248159e+00,
    1.00252856620331e+00,
    1.00253617211722e+00,
    1.00254375003823e+00,
    1.00255129978220e+00,
    1.00255882116595e+00,
    1.00256631400724e+00,
    1.00257377812480e+00,
    1.00258121333829e+00,
    1.00258861946836e+00,
    1.00259599633661e+00,
    1.00260334376560e+00,
    1.00261066157888e+00,
    1.00261794960095e+00,
    1.00262520765730e+00,
    1.00263243557439e+00,
    1.00263963317966e+00,
    1.00264680030152e+00,
    1.00265393676941e+00,
    1.00266104241370e+00,
    1.00266811706579e+00,
    1.00267516055806e+00,
    1.00268217272388e+00,
    1.00268915339764e+00,
    1.00269610241470e+00,
    1.00270301961144e+00,
    1.00270990482526e+00,
    1.00271675789454e+00,
    1.00272357865868e+00,
    1.00273036695810e+00,
    1.00273712263424e+00,
    1.00274384552953e+00,
    1.00275053548745e+00,
    1.00275719235249e+00,
    1.00276381597015e+00,
    1.00277040618699e+00,
    1.00277696285057e+00,
    1.00278348580949e+00,
    1.00278997491338e+00,
    1.00279643001292e+00,
    1.00280285095980e+00,
    1.00280923760677e+00,
    1.00281558980762e+00,
    1.00282190741717e+00,
    1.00282819029130e+00,
    1.00283443828693e+00,
    1.00284065126203e+00,
    1.00284682907563e+00,
    1.00285297158779e+00,
    1.00285907865965e+00,
    1.00286515015339e+00,
    1.00287118593226e+00,
    1.00287718586056e+00,
    1.00288314980366e+00,
    1.00288907762799e+00,
    1.00289496920104e+00,
    1.00290082439139e+00,
    1.00290664306865e+00,
    1.00291242510355e+00,
    1.00291817036784e+00,
    1.00292387873438e+00,
    1.00292955007709e+00,
    1.00293518427097e+00,
    1.00294078119211e+00,
    1.00294634071766e+00,
    1.00295186272586e+00,
    1.00295734709603e+00,
    1.00296279370859e+00,
    1.00296820244502e+00,
    1.00297357318791e+00,
    1.00297890582092e+00,
    1.00298420022881e+00,
    1.00298945629742e+00,
    1.00299467391371e+00,
    1.00299985296570e+00,
    1.00300499334253e+00,
    1.00301009493441e+00,
    1.00301515763266e+00,
    1.00302018132972e+00,
    1.00302516591908e+00,
    1.00303011129539e+00,
    1.00303501735435e+00,
    1.00303988399278e+00,
    1.00304471110863e+00,
    1.00304949860090e+00,
    1.00305424636975e+00,
    1.00305895431641e+00,
    1.00306362234323e+00,
    1.00306825035368e+00,
    1.00307283825231e+00,
    1.00307738594481e+00,
    1.00308189333796e+00,
    1.00308636033966e+00,
    1.00309078685893e+00,
    1.00309517280588e+00,
    1.00309951809176e+00,
    1.00310382262892e+00,
    1.00310808633082e+00,
    1.00311230911206e+00,
    1.00311649088832e+00,
    1.00312063157644e+00,
    1.00312473109433e+00,
    1.00312878936106e+00,
    1.00313280629679e+00,
    1.00313678182282e+00,
    1.00314071586156e+00,
    1.00314460833653e+00,
    1.00314845917239e+00,
    1.00315226829491e+00,
    1.00315603563099e+00,
    1.00315976110863e+00,
    1.00316344465697e+00,
    1.00316708620628e+00,
    1.00317068568794e+00,
    1.00317424303444e+00,
    1.00317775817942e+00,
    1.00318123105763e+00,
    1.00318466160494e+00,
    1.00318804975836e+00,
    1.00319139545600e+00,
    1.00319469863711e+00,
    1.00319795924206e+00,
    1.00320117721234e+00,
    1.00320435249057e+00,
    1.00320748502050e+00,
    1.00321057474699e+00,
    1.00321362161604e+00,
    1.00321662557474e+00,
    1.00321958657136e+00,
    1.00322250455524e+00,
    1.00322537947688e+00,
    1.00322821128789e+00,
    1.00323099994099e+00,
    1.00323374539005e+00,
    1.00323644759004e+00,
    1.00323910649707e+00,
    1.00324172206837e+00,
    1.00324429426228e+00,
    1.00324682303827e+00,
    1.00324930835693e+00,
    1.00325175017998e+00,
    1.00325414847025e+00,
    1.00325650319169e+00,
    1.00325881430938e+00,
    1.00326108178951e+00,
    1.00326330559939e+00,
    1.00326548570746e+00,
    1.00326762208327e+00,
    1.00326971469747e+00,
    1.00327176352187e+00,
    1.00327376852935e+00,
    1.00327572969394e+00,
    1.00327764699076e+00,
    1.00327952039607e+00,
    1.00328134988722e+00,
    1.00328313544268e+00,
    1.00328487704205e+00,
    1.00328657466602e+00,
    1.00328822829640e+00,
    1.00328983791611e+00,
    1.00329140350917e+00,
    1.00329292506072e+00,
    1.00329440255701e+00,
    1.00329583598539e+00,
    1.00329722533431e+00,
    1.00329857059334e+00,
    1.00329987175314e+00,
    1.00330112880548e+00,
    1.00330234174323e+00,
    1.00330351056036e+00,
    1.00330463525194e+00,
    1.00330571581415e+00,
    1.00330675224426e+00,
    1.00330774454062e+00,
    1.00330869270269e+00,
    1.00330959673104e+00,
    1.00331045662732e+00,
    1.00331127239425e+00,
    1.00331204403568e+00,
    1.00331277155652e+00,
    1.00331345496278e+00,
    1.00331409426156e+00,
    1.00331468946104e+00,
    1.00331524057049e+00,
    1.00331574760025e+00,
    1.00331621056177e+00,
    1.00331662946754e+00,
    1.00331700433116e+00,
    1.00331733516730e+00,
    1.00331762199171e+00,
    1.00331786482119e+00,
    1.00331806367365e+00,
    1.00331821856805e+00,
    1.00331832952442e+00,
    1.00331839656386e+00,
    1.00331841970855e+00,
    1.00331839898171e+00,
    1.00331833440764e+00,
    1.00331822601172e+00,
    1.00331807382035e+00,
    1.00331787786101e+00,
    1.00331763816225e+00,
    1.00331735475365e+00,
    1.00331702766586e+00,
    1.00331665693058e+00,
    1.00331624258056e+00,
    1.00331578464958e+00,
    1.00331528317250e+00,
    1.00331473818520e+00,
    1.00331414972461e+00,
    1.00331351782870e+00,
    1.00331284253647e+00,
    1.00331212388798e+00,
    1.00331136192431e+00,
    1.00331055668757e+00,
    1.00330970822091e+00,
    1.00330881656850e+00,
    1.00330788177554e+00,
    1.00330690388826e+00,
    1.00330588295392e+00,
    1.00330481902077e+00,
    1.00330371213812e+00,
    1.00330256235626e+00,
    1.00330136972653e+00,
    1.00330013430124e+00,
    1.00329885613376e+00,
    1.00329753527842e+00,
    1.00329617179059e+00,
    1.00329476572663e+00,
    1.00329331714390e+00,
    1.00329182610076e+00,
    1.00329029265657e+00,
    1.00328871687169e+00,
    1.00328709880745e+00,
    1.00328543852621e+00,
    1.00328373609127e+00,
    1.00328199156694e+00,
    1.00328020501852e+00,
    1.00327837651228e+00,
    1.00327650611546e+00,
    1.00327459389630e+00,
    1.00327263992397e+00,
    1.00327064426867e+00,
    1.00326860700151e+00,
    1.00326652819460e+00,
    1.00326440792100e+00,
    1.00326224625474e+00,
    1.00326004327079e+00,
    1.00325779904510e+00,
    1.00325551365455e+00,
    1.00325318717699e+00,
    1.00325081969119e+00,
    1.00324841127689e+00,
    1.00324596201476e+00,
    1.00324347198642e+00,
    1.00324094127440e+00,
    1.00323836996219e+00,
    1.00323575813421e+00,
    1.00323310587580e+00,
    1.00323041327322e+00,
    1.00322768041365e+00,
    1.00322490738522e+00,
    1.00322209427694e+00,
    1.00321924117875e+00,
    1.00321634818150e+00,
    1.00321341537696e+00,
    1.00321044285779e+00,
    1.00320743071755e+00,
    1.00320437905072e+00,
    1.00320128795265e+00,
    1.00319815751959e+00,
    1.00319498784871e+00,
    1.00319177903803e+00,
    1.00318853118647e+00,
    1.00318524439384e+00,
    1.00318191876081e+00,
    1.00317855438894e+00,
    1.00317515138066e+00,
    1.00317170983926e+00,
    1.00316822986891e+00,
    1.00316471157464e+00,
    1.00316115506232e+00,
    1.00315756043871e+00,
    1.00315392781140e+00,
    1.00315025728884e+00,
    1.00314654898032e+00,
    1.00314280299598e+00,
    1.00313901944680e+00,
    1.00313519844460e+00,
    1.00313134010203e+00,
    1.00312744453257e+00,
    1.00312351185054e+00,
    1.00311954217106e+00,
    1.00311553561009e+00,
    1.00311149228440e+00,
    1.00310741231159e+00,
    1.00310329581005e+00,
    1.00309914289899e+00,
    1.00309495369843e+00,
    1.00309072832916e+00,
    1.00308646691281e+00,
    1.00308216957177e+00,
    1.00307783642924e+00,
    1.00307346760921e+00,
    1.00306906323643e+00,
    1.00306462343645e+00,
    1.00306014833560e+00,
    1.00305563806098e+00,
    1.00305109274043e+00,
    1.00304651250261e+00,
    1.00304189747690e+00,
    1.00303724779345e+00,
    1.00303256358318e+00,
    1.00302784497775e+00,
    1.00302309210956e+00,
    1.00301830511176e+00,
    1.00301348411827e+00,
    1.00300862926369e+00,
    1.00300374068341e+00,
    1.00299881851352e+00,
    1.00299386289084e+00,
    1.00298887395292e+00,
    1.00298385183802e+00,
    1.00297879668513e+00,
    1.00297370863393e+00,
    1.00296858782482e+00,
    1.00296343439892e+00,
    1.00295824849802e+00,
    1.00295303026462e+00,
    1.00294777984192e+00,
    1.00294249737381e+00,
    1.00293718300485e+00,
    1.00293183688029e+00,
    1.00292645914607e+00,
    1.00292104994877e+00,
    1.00291560943568e+00,
    1.00291013775473e+00,
    1.00290463505453e+00,
    1.00289910148432e+00,
    1.00289353719403e+00,
    1.00288794233422e+00,
    1.00288231705610e+00,
    1.00287666151153e+00,
    1.00287097585299e+00,
    1.00286526023361e+00,
    1.00285951480715e+00,
    1.00285373972800e+00,
    1.00284793515117e+00,
    1.00284210123228e+00,
    1.00283623812758e+00,
    1.00283034599392e+00,
    1.00282442498876e+00,
    1.00281847527017e+00,
    1.00281249699680e+00,
    1.00280649032792e+00,
    1.00280045542338e+00,
    1.00279439244361e+00,
    1.00278830154964e+00,
    1.00278218290305e+00,
    1.00277603666603e+00,
    1.00276986300131e+00,
    1.00276366207221e+00,
    1.00275743404260e+00,
    1.00275117907691e+00,
    1.00274489734012e+00,
    1.00273858899778e+00,
    1.00273225421595e+00,
    1.00272589316127e+00,
    1.00271950600089e+00,
    1.00271309290251e+00,
    1.00270665403435e+00,
    1.00270018956516e+00,
    1.00269369966421e+00,
    1.00268718450128e+00,
    1.00268064424668e+00,
    1.00267407907121e+00,
    1.00266748914618e+00,
    1.00266087464341e+00,
    1.00265423573519e+00,
    1.00264757259434e+00,
    1.00264088539413e+00,
    1.00263417430833e+00,
    1.00262743951120e+00,
    1.00262068117744e+00,
    1.00261389948226e+00,
    1.00260709460131e+00,
    1.00260026671071e+00,
    1.00259341598703e+00,
    1.00258654260731e+00,
    1.00257964674903e+00,
    1.00257272859011e+00,
    1.00256578830890e+00,
    1.00255882608422e+00,
    1.00255184209528e+00,
    1.00254483652176e+00,
    1.00253780954371e+00,
    1.00253076134166e+00,
    1.00252369209650e+00,
    1.00251660198956e+00,
    1.00250949120257e+00,
    1.00250235991765e+00,
    1.00249520831734e+00,
    1.00248803658454e+00,
    1.00248084490257e+00,
    1.00247363345511e+00,
    1.00246640242624e+00,
    1.00245915200039e+00,
    1.00245188236237e+00,
    1.00244459369737e+00,
    1.00243728619093e+00,
    1.00242996002895e+00,
    1.00242261539767e+00,
    1.00241525248369e+00,
    1.00240787147396e+00,
    1.00240047255575e+00,
    1.00239305591670e+00,
    1.00238562174473e+00,
    1.00237817022813e+00,
    1.00237070155549e+00,
    1.00236321591573e+00,
    1.00235571349806e+00,
    1.00234819449203e+00,
    1.00234065908747e+00,
    1.00233310747451e+00,
    1.00232553984359e+00,
    1.00231795638543e+00,
    1.00231035729104e+00,
    1.00230274275171e+00,
    1.00229511295901e+00,
    1.00228746810477e+00,
    1.00227980838110e+00,
    1.00227213398038e+00,
    1.00226444509523e+00,
    1.00225674191854e+00,
    1.00224902464344e+00,
    1.00224129346332e+00,
    1.00223354857179e+00,
    1.00222579016272e+00,
    1.00221801843020e+00,
    1.00221023356854e+00,
    1.00220243577229e+00,
    1.00219462523620e+00,
    1.00218680215526e+00,
    1.00217896672465e+00,
    1.00217111913975e+00,
    1.00216325959616e+00,
    1.00215538828966e+00,
    1.00214750541623e+00,
    1.00213961117203e+00,
    1.00213170575343e+00,
    1.00212378935693e+00,
    1.00211586217924e+00,
    1.00210792441723e+00,
    1.00209997626794e+00,
    1.00209201792855e+00,
    1.00208404959641e+00,
    1.00207607146903e+00,
    1.00206808374405e+00,
    1.00206008661926e+00,
    1.00205208029259e+00,
    1.00204406496209e+00,
    1.00203604082596e+00,
    1.00202800808250e+00,
    1.00201996693015e+00,
    1.00201191756745e+00,
    1.00200386019306e+00,
    1.00199579500575e+00,
    1.00198772220437e+00,
    1.00197964198788e+00,
    1.00197155455535e+00,
    1.00196346010590e+00,
    1.00195535883877e+00,
    1.00194725095326e+00,
    1.00193913664875e+00,
    1.00193101612468e+00,
    1.00192288958057e+00,
    1.00191475721599e+00,
    1.00190661923057e+00,
    1.00189847582399e+00,
    1.00189032719599e+00,
    1.00188217354633e+00,
    1.00187401507483e+00,
    1.00186585198133e+00,
    1.00185768446570e+00,
    1.00184951272785e+00,
    1.00184133696769e+00,
    1.00183315738516e+00,
    1.00182497418021e+00,
    1.00181678755279e+00,
    1.00180859770285e+00,
    1.00180040483035e+00,
    1.00179220913525e+00,
    1.00178401081746e+00,
    1.00177581007693e+00,
    1.00176760711355e+00,
    1.00175940212720e+00,
    1.00175119531772e+00,
    1.00174298688494e+00,
    1.00173477702863e+00,
    1.00172656594852e+00,
    1.00171835384432e+00,
    1.00171014091566e+00,
    1.00170192736211e+00,
    1.00169371338321e+00,
    1.00168549917842e+00,
    1.00167728494712e+00,
    1.00166907088864e+00,
    1.00166085720221e+00,
    1.00165264408700e+00,
    1.00164443174207e+00,
    1.00163622036641e+00,
    1.00162801015891e+00,
    1.00161980131835e+00,
    1.00161159404342e+00,
    1.00160338853269e+00,
    1.00159518498462e+00,
    1.00158698359756e+00,
    1.00157878456974e+00,
    1.00157058809925e+00,
    1.00156239438407e+00,
    1.00155420362202e+00,
    1.00154601601080e+00,
    1.00153783174797e+00,
    1.00152965103093e+00,
    1.00152147405694e+00,
    1.00151330102308e+00,
    1.00150513212630e+00,
    1.00149696756338e+00,
    1.00148880753090e+00,
    1.00148065222531e+00,
    1.00147250184286e+00,
    1.00146435657961e+00,
    1.00145621663145e+00,
    1.00144808219407e+00,
    1.00143995346297e+00,
    1.00143183063346e+00,
    1.00142371390063e+00,
    1.00141560345936e+00,
    1.00140749950434e+00,
    1.00139940223003e+00,
    1.00139131183066e+00,
    1.00138322850026e+00,
    1.00137515243261e+00,
    1.00136708382127e+00,
    1.00135902285955e+00,
    1.00135096974054e+00,
    1.00134292465706e+00,
    1.00133488780169e+00,
    1.00132685936677e+00,
    1.00131883954435e+00,
    1.00131082852626e+00,
    1.00130282650403e+00,
    1.00129483366893e+00,
    1.00128685021195e+00,
    1.00127887632382e+00,
    1.00127091219497e+00,
    1.00126295801555e+00,
    1.00125501397540e+00,
    1.00124708026411e+00,
    1.00123915707091e+00,
    1.00123124458478e+00,
    1.00122334299437e+00,
    1.00121545248801e+00,
    1.00120757325372e+00,
    1.00119970547923e+00,
    1.00119184935189e+00,
    1.00118400505877e+00,
    1.00117617278658e+00,
    1.00116835272172e+00,
    1.00116054505023e+00,
    1.00115274995781e+00,
    1.00114496762982e+00,
    1.00113719825125e+00,
    1.00112944200675e+00,
    1.00112169908062e+00,
    1.00111396965678e+00,
    1.00110625391877e+00,
    1.00109855204980e+00,
    1.00109086423266e+00,
    1.00108319064978e+00,
    1.00107553148322e+00,
    1.00106788691463e+00,
    1.00106025712529e+00,
    1.00105264229605e+00,
    1.00104504260742e+00,
    1.00103745823944e+00,
    1.00102988937180e+00,
    1.00102233618374e+00,
    1.00101479885411e+00,
    1.00100727756133e+00,
    1.00099977248341e+00,
    1.00099228379792e+00,
    1.00098481168201e+00,
    1.00097735631240e+00,
    1.00096991786535e+00,
    1.00096249651672e+00,
    1.00095509244189e+00,
    1.00094770581581e+00,
    1.00094033681297e+00,
    1.00093298560741e+00,
    1.00092565237270e+00,
    1.00091833728197e+00,
    1.00091104050786e+00,
    1.00090376222256e+00,
    1.00089650259776e+00,
    1.00088926180470e+00,
    1.00088204001412e+00,
    1.00087483739629e+00,
    1.00086765412097e+00,
    1.00086049035745e+00,
    1.00085334627453e+00,
    1.00084622204047e+00,
    1.00083911782308e+00,
    1.00083203378962e+00,
    1.00082497010687e+00,
    1.00081792694108e+00,
    1.00081090445799e+00,
    1.00080390282282e+00,
    1.00079692220027e+00,
    1.00078996275449e+00,
    1.00078302464914e+00,
    1.00077610804731e+00,
    1.00076921311157e+00,
    1.00076234000393e+00,
    1.00075548888589e+00,
    1.00074865991837e+00,
    1.00074185326176e+00,
    1.00073506907587e+00,
    1.00072830751999e+00,
    1.00072156875281e+00,
    1.00071485293248e+00,
    1.00070816021657e+00,
    1.00070149076208e+00,
    1.00069484472545e+00,
    1.00068822226253e+00,
    1.00068162352858e+00,
    1.00067504867828e+00,
    1.00066849786575e+00,
    1.00066197124447e+00,
    1.00065546896738e+00,
    1.00064899118677e+00,
    1.00064253805437e+00,
    1.00063610972128e+00,
    1.00062970633801e+00,
    1.00062332805446e+00,
    1.00061697501991e+00,
    1.00061064738301e+00,
    1.00060434529182e+00,
    1.00059806889375e+00,
    1.00059181833561e+00,
    1.00058559376357e+00,
    1.00057939532315e+00,
    1.00057322315926e+00,
    1.00056707741617e+00,
    1.00056095823750e+00,
    1.00055486576623e+00,
    1.00054880014469e+00,
    1.00054276151457e+00,
    1.00053675001689e+00,
    1.00053076579203e+00,
    1.00052480897971e+00,
    1.00051887971898e+00,
    1.00051297814822e+00,
    1.00050710440518e+00,
    1.00050125862688e+00,
    1.00049544094973e+00,
    1.00048965150941e+00,
    1.00048389044096e+00,
    1.00047815787872e+00,
    1.00047245395635e+00,
    1.00046677880681e+00,
    1.00046113256240e+00,
    1.00045551535470e+00,
    1.00044992731461e+00,
    1.00044436857232e+00,
    1.00043883925733e+00,
    1.00043333949843e+00,
    1.00042786942371e+00,
    1.00042242916054e+00,
    1.00041701883559e+00,
    1.00041163857481e+00,
    1.00040628850344e+00,
    1.00040096874599e+00,
    1.00039567942626e+00,
    1.00039042066731e+00,
    1.00038519259148e+00,
    1.00037999532040e+00,
    1.00037482897493e+00,
    1.00036969367523e+00,
    1.00036458954071e+00,
    1.00035951669003e+00,
    1.00035447524112e+00,
    1.00034946531117e+00,
    1.00034448701661e+00,
    1.00033954047312e+00,
    1.00033462579565e+00,
    1.00032974309837e+00,
    1.00032489249471e+00,
    1.00032007409733e+00,
    1.00031528801814e+00,
    1.00031053436828e+00,
    1.00030581325813e+00,
    1.00030112479729e+00,
    1.00029646909459e+00,
    1.00029184625812e+00,
    1.00028725639514e+00,
    1.00028269961218e+00,
    1.00027817601498e+00,
    1.00027368570847e+00,
    1.00026922879684e+00,
    1.00026480538347e+00,
    1.00026041557094e+00,
    1.00025605946107e+00,
    1.00025173715487e+00,
    1.00024744875256e+00,
    1.00024319435355e+00,
    1.00023897405649e+00,
    1.00023478795918e+00,
    1.00023063615866e+00,
    1.00022651875113e+00,
    1.00022243583202e+00,
    1.00021838749592e+00,
    1.00021437383664e+00,
    1.00021039494714e+00,
    1.00020645091959e+00,
    1.00020254184535e+00,
    1.00019866781496e+00,
    1.00019482891811e+00,
    1.00019102524371e+00,
    1.00018725687982e+00,
    1.00018352391369e+00,
    1.00017982643174e+00,
    1.00017616451954e+00,
    1.00017253826186e+00,
    1.00016894774262e+00,
    1.00016539304491e+00,
    1.00016187425099e+00,
    1.00015839144228e+00,
    1.00015494469935e+00,
    1.00015153410194e+00,
    1.00014815972894e+00,
    1.00014482165842e+00,
    1.00014151996756e+00,
    1.00013825473274e+00,
    1.00013502602946e+00,
    1.00013183393237e+00,
    1.00012867851530e+00,
    1.00012555985119e+00,
    1.00012247801214e+00,
    1.00011943306940e+00,
    1.00011642509334e+00,
    1.00011345415350e+00,
    1.00011052031854e+00,
    1.00010762365627e+00,
    1.00010476423362e+00,
    1.00010194211666e+00,
    1.00009915737062e+00,
    1.00009641005982e+00,
    1.00009370024774e+00,
    1.00009102799698e+00,
    1.00008839336927e+00,
    1.00008579642548e+00,
    1.00008323722557e+00,
    1.00008071582867e+00,
    1.00007823229300e+00,
    1.00007578667593e+00,
    1.00007337903391e+00,
    1.00007100942256e+00,
    1.00006867789657e+00,
    1.00006638450980e+00,
    1.00006412931518e+00,
    1.00006191236479e+00,
    1.00005973370979e+00,
    1.00005759340048e+00,
    1.00005549148628e+00,
    1.00005342801568e+00,
    1.00005140303633e+00,
    1.00004941659496e+00,
    1.00004746873740e+00,
    1.00004555950863e+00,
    1.00004368895268e+00,
    1.00004185711274e+00,
    1.00004006403107e+00,
    1.00003830974904e+00,
    1.00003659430712e+00,
    1.00003491774491e+00,
    1.00003328010108e+00,
    1.00003168141341e+00,
    1.00003012171878e+00,
    1.00002860105317e+00,
    1.00002711945167e+00,
    1.00002567694844e+00,
    1.00002427357677e+00,
    1.00002290936903e+00,
    1.00002158435667e+00,
    1.00002029857026e+00,
    1.00001905203945e+00,
    1.00001784479300e+00,
    1.00001667685875e+00,
    1.00001554826363e+00,
    1.00001445903366e+00,
    1.00001340919398e+00,
    1.00001239876878e+00,
    1.00001142778137e+00,
    1.00001049625413e+00,
    1.00000960420856e+00,
    1.00000875166521e+00,
    1.00000793864375e+00,
    1.00000716516292e+00,
    1.00000643124055e+00,
    1.00000573689357e+00,
    1.00000508213799e+00,
    1.00000446698890e+00,
    1.00000389146048e+00,
    1.00000335556601e+00,
    1.00000285931784e+00,
    1.00000240272742e+00,
    1.00000198580525e+00,
    1.00000160856097e+00,
    1.00000127100326e+00,
    1.00000097313992e+00,
    1.00000071497779e+00,
    1.00000049652285e+00,
    1.00000031778012e+00,
    1.00000017875372e+00,
    1.00000007944686e+00,
    1.00000001986183e+00,
    1.00000000000000e+00,
    1.00000001986182e+00,
    1.00000007944686e+00,
    1.00000017875372e+00,
    1.00000031778011e+00,
    1.00000049652285e+00,
    1.00000071497779e+00,
    1.00000097313992e+00,
    1.00000127100326e+00,
    1.00000160856097e+00,
    1.00000198580525e+00,
    1.00000240272741e+00,
    1.00000285931784e+00,
    1.00000335556601e+00,
    1.00000389146048e+00,
    1.00000446698890e+00,
    1.00000508213799e+00,
    1.00000573689357e+00,
    1.00000643124055e+00,
    1.00000716516292e+00,
    1.00000793864375e+00,
    1.00000875166521e+00,
    1.00000960420856e+00,
    1.00001049625413e+00,
    1.00001142778137e+00,
    1.00001239876878e+00,
    1.00001340919398e+00,
    1.00001445903366e+00,
    1.00001554826363e+00,
    1.00001667685875e+00,
    1.00001784479300e+00,
    1.00001905203945e+00,
    1.00002029857026e+00,
    1.00002158435667e+00,
    1.00002290936902e+00,
    1.00002427357677e+00,
    1.00002567694844e+00,
    1.00002711945167e+00,
    1.00002860105317e+00,
    1.00003012171878e+00,
    1.00003168141341e+00,
    1.00003328010108e+00,
    1.00003491774491e+00,
    1.00003659430712e+00,
    1.00003830974904e+00,
    1.00004006403107e+00,
    1.00004185711274e+00,
    1.00004368895268e+00,
    1.00004555950863e+00,
    1.00004746873740e+00,
    1.00004941659496e+00,
    1.00005140303633e+00,
    1.00005342801568e+00,
    1.00005549148628e+00,
    1.00005759340048e+00,
    1.00005973370979e+00,
    1.00006191236479e+00,
    1.00006412931518e+00,
    1.00006638450980e+00,
    1.00006867789657e+00,
    1.00007100942256e+00,
    1.00007337903391e+00,
    1.00007578667593e+00,
    1.00007823229300e+00,
    1.00008071582867e+00,
    1.00008323722557e+00,
    1.00008579642548e+00,
    1.00008839336927e+00,
    1.00009102799698e+00,
    1.00009370024774e+00,
    1.00009641005982e+00,
    1.00009915737062e+00,
    1.00010194211666e+00,
    1.00010476423362e+00,
    1.00010762365627e+00,
    1.00011052031854e+00,
    1.00011345415350e+00,
    1.00011642509334e+00,
    1.00011943306940e+00,
    1.00012247801214e+00,
    1.00012555985119e+00,
    1.00012867851530e+00,
    1.00013183393237e+00,
    1.00013502602946e+00,
    1.00013825473274e+00,
    1.00014151996756e+00,
    1.00014482165842e+00,
    1.00014815972894e+00,
    1.00015153410194e+00,
    1.00015494469935e+00,
    1.00015839144228e+00,
    1.00016187425099e+00,
    1.00016539304491e+00,
    1.00016894774262e+00,
    1.00017253826186e+00,
    1.00017616451954e+00,
    1.00017982643174e+00,
    1.00018352391369e+00,
    1.00018725687982e+00,
    1.00019102524371e+00,
    1.00019482891811e+00,
    1.00019866781496e+00,
    1.00020254184535e+00,
    1.00020645091959e+00,
    1.00021039494714e+00,
    1.00021437383664e+00,
    1.00021838749592e+00,
    1.00022243583202e+00,
    1.00022651875113e+00,
    1.00023063615866e+00,
    1.00023478795918e+00,
    1.00023897405649e+00,
    1.00024319435355e+00,
    1.00024744875256e+00,
    1.00025173715487e+00,
    1.00025605946107e+00,
    1.00026041557094e+00,
    1.00026480538347e+00,
    1.00026922879684e+00,
    1.00027368570847e+00,
    1.00027817601498e+00,
    1.00028269961218e+00,
    1.00028725639514e+00,
    1.00029184625812e+00,
    1.00029646909459e+00,
    1.00030112479729e+00,
    1.00030581325813e+00,
    1.00031053436828e+00,
    1.00031528801814e+00,
    1.00032007409733e+00,
    1.00032489249471e+00,
    1.00032974309837e+00,
    1.00033462579565e+00,
    1.00033954047312e+00,
    1.00034448701661e+00,
    1.00034946531117e+00,
    1.00035447524112e+00,
    1.00035951669003e+00,
    1.00036458954071e+00,
    1.00036969367523e+00,
    1.00037482897493e+00,
    1.00037999532040e+00,
    1.00038519259148e+00,
    1.00039042066731e+00,
    1.00039567942626e+00,
    1.00040096874599e+00,
    1.00040628850344e+00,
    1.00041163857481e+00,
    1.00041701883559e+00,
    1.00042242916054e+00,
    1.00042786942371e+00,
    1.00043333949843e+00,
    1.00043883925733e+00,
    1.00044436857232e+00,
    1.00044992731461e+00,
    1.00045551535470e+00,
    1.00046113256240e+00,
    1.00046677880681e+00,
    1.00047245395635e+00,
    1.00047815787872e+00,
    1.00048389044096e+00,
    1.00048965150941e+00,
    1.00049544094973e+00,
    1.00050125862688e+00,
    1.00050710440518e+00,
    1.00051297814822e+00,
    1.00051887971898e+00,
    1.00052480897971e+00,
    1.00053076579203e+00,
    1.00053675001689e+00,
    1.00054276151457e+00,
    1.00054880014469e+00,
    1.00055486576623e+00,
    1.00056095823750e+00,
    1.00056707741617e+00,
    1.00057322315926e+00,
    1.00057939532315e+00,
    1.00058559376356e+00,
    1.00059181833561e+00,
    1.00059806889375e+00,
    1.00060434529182e+00,
    1.00061064738301e+00,
    1.00061697501991e+00,
    1.00062332805446e+00,
    1.00062970633801e+00,
    1.00063610972128e+00,
    1.00064253805437e+00,
    1.00064899118677e+00,
    1.00065546896738e+00,
    1.00066197124447e+00,
    1.00066849786575e+00,
    1.00067504867828e+00,
    1.00068162352858e+00,
    1.00068822226253e+00,
    1.00069484472545e+00,
    1.00070149076208e+00,
    1.00070816021657e+00,
    1.00071485293248e+00,
    1.00072156875281e+00,
    1.00072830751999e+00,
    1.00073506907587e+00,
    1.00074185326176e+00,
    1.00074865991837e+00,
    1.00075548888589e+00,
    1.00076234000393e+00,
    1.00076921311157e+00,
    1.00077610804731e+00,
    1.00078302464914e+00,
    1.00078996275449e+00,
    1.00079692220027e+00,
    1.00080390282282e+00,
    1.00081090445799e+00,
    1.00081792694108e+00,
    1.00082497010687e+00,
    1.00083203378962e+00,
    1.00083911782308e+00,
    1.00084622204047e+00,
    1.00085334627453e+00,
    1.00086049035745e+00,
    1.00086765412097e+00,
    1.00087483739629e+00,
    1.00088204001412e+00,
    1.00088926180470e+00,
    1.00089650259776e+00,
    1.00090376222256e+00,
    1.00091104050786e+00,
    1.00091833728197e+00,
    1.00092565237270e+00,
    1.00093298560741e+00,
    1.00094033681297e+00,
    1.00094770581581e+00,
    1.00095509244189e+00,
    1.00096249651672e+00,
    1.00096991786535e+00,
    1.00097735631240e+00,
    1.00098481168201e+00,
    1.00099228379792e+00,
    1.00099977248341e+00,
    1.00100727756133e+00,
    1.00101479885411e+00,
    1.00102233618374e+00,
    1.00102988937180e+00,
    1.00103745823944e+00,
    1.00104504260742e+00,
    1.00105264229606e+00,
    1.00106025712529e+00,
    1.00106788691463e+00,
    1.00107553148322e+00,
    1.00108319064978e+00,
    1.00109086423266e+00,
    1.00109855204980e+00,
    1.00110625391877e+00,
    1.00111396965678e+00,
    1.00112169908062e+00,
    1.00112944200675e+00,
    1.00113719825125e+00,
    1.00114496762982e+00,
    1.00115274995781e+00,
    1.00116054505023e+00,
    1.00116835272172e+00,
    1.00117617278658e+00,
    1.00118400505877e+00,
    1.00119184935189e+00,
    1.00119970547922e+00,
    1.00120757325372e+00,
    1.00121545248801e+00,
    1.00122334299437e+00,
    1.00123124458478e+00,
    1.00123915707091e+00,
    1.00124708026411e+00,
    1.00125501397540e+00,
    1.00126295801555e+00,
    1.00127091219497e+00,
    1.00127887632382e+00,
    1.00128685021195e+00,
    1.00129483366893e+00,
    1.00130282650403e+00,
    1.00131082852626e+00,
    1.00131883954435e+00,
    1.00132685936677e+00,
    1.00133488780169e+00,
    1.00134292465706e+00,
    1.00135096974054e+00,
    1.00135902285955e+00,
    1.00136708382127e+00,
    1.00137515243261e+00,
    1.00138322850026e+00,
    1.00139131183066e+00,
    1.00139940223003e+00,
    1.00140749950434e+00,
    1.00141560345936e+00,
    1.00142371390063e+00,
    1.00143183063346e+00,
    1.00143995346297e+00,
    1.00144808219407e+00,
    1.00145621663145e+00,
    1.00146435657961e+00,
    1.00147250184286e+00,
    1.00148065222531e+00,
    1.00148880753090e+00,
    1.00149696756338e+00,
    1.00150513212630e+00,
    1.00151330102308e+00,
    1.00152147405694e+00,
    1.00152965103093e+00,
    1.00153783174797e+00,
    1.00154601601080e+00,
    1.00155420362202e+00,
    1.00156239438407e+00,
    1.00157058809925e+00,
    1.00157878456974e+00,
    1.00158698359756e+00,
    1.00159518498462e+00,
    1.00160338853269e+00,
    1.00161159404342e+00,
    1.00161980131835e+00,
    1.00162801015891e+00,
    1.00163622036641e+00,
    1.00164443174207e+00,
    1.00165264408700e+00,
    1.00166085720221e+00,
    1.00166907088864e+00,
    1.00167728494712e+00,
    1.00168549917842e+00,
    1.00169371338321e+00,
    1.00170192736211e+00,
    1.00171014091565e+00,
    1.00171835384432e+00,
    1.00172656594852e+00,
    1.00173477702863e+00,
    1.00174298688494e+00,
    1.00175119531772e+00,
    1.00175940212720e+00,
    1.00176760711355e+00,
    1.00177581007693e+00,
    1.00178401081746e+00,
    1.00179220913525e+00,
    1.00180040483035e+00,
    1.00180859770285e+00,
    1.00181678755279e+00,
    1.00182497418021e+00,
    1.00183315738516e+00,
    1.00184133696769e+00,
    1.00184951272785e+00,
    1.00185768446570e+00,
    1.00186585198133e+00,
    1.00187401507483e+00,
    1.00188217354633e+00,
    1.00189032719599e+00,
    1.00189847582399e+00,
    1.00190661923057e+00,
    1.00191475721599e+00,
    1.00192288958057e+00,
    1.00193101612468e+00,
    1.00193913664875e+00,
    1.00194725095326e+00,
    1.00195535883877e+00,
    1.00196346010590e+00,
    1.00197155455535e+00,
    1.00197964198788e+00,
    1.00198772220437e+00,
    1.00199579500575e+00,
    1.00200386019306e+00,
    1.00201191756745e+00,
    1.00201996693015e+00,
    1.00202800808250e+00,
    1.00203604082596e+00,
    1.00204406496209e+00,
    1.00205208029259e+00,
    1.00206008661926e+00,
    1.00206808374405e+00,
    1.00207607146903e+00,
    1.00208404959641e+00,
    1.00209201792855e+00,
    1.00209997626794e+00,
    1.00210792441723e+00,
    1.00211586217924e+00,
    1.00212378935693e+00,
    1.00213170575343e+00,
    1.00213961117204e+00,
    1.00214750541623e+00,
    1.00215538828966e+00,
    1.00216325959616e+00,
    1.00217111913975e+00,
    1.00217896672465e+00,
    1.00218680215526e+00,
    1.00219462523620e+00,
    1.00220243577229e+00,
    1.00221023356854e+00,
    1.00221801843020e+00,
    1.00222579016272e+00,
    1.00223354857179e+00,
    1.00224129346332e+00,
    1.00224902464344e+00,
    1.00225674191854e+00,
    1.00226444509523e+00,
    1.00227213398038e+00,
    1.00227980838110e+00,
    1.00228746810477e+00,
    1.00229511295901e+00,
    1.00230274275171e+00,
    1.00231035729104e+00,
    1.00231795638543e+00,
    1.00232553984359e+00,
    1.00233310747451e+00,
    1.00234065908747e+00,
    1.00234819449203e+00,
    1.00235571349806e+00,
    1.00236321591573e+00,
    1.00237070155549e+00,
    1.00237817022813e+00,
    1.00238562174473e+00,
    1.00239305591670e+00,
    1.00240047255575e+00,
    1.00240787147396e+00,
    1.00241525248369e+00,
    1.00242261539767e+00,
    1.00242996002895e+00,
    1.00243728619093e+00,
    1.00244459369737e+00,
    1.00245188236237e+00,
    1.00245915200039e+00,
    1.00246640242624e+00,
    1.00247363345511e+00,
    1.00248084490257e+00,
    1.00248803658454e+00,
    1.00249520831734e+00,
    1.00250235991765e+00,
    1.00250949120257e+00,
    1.00251660198956e+00,
    1.00252369209650e+00,
    1.00253076134166e+00,
    1.00253780954371e+00,
    1.00254483652176e+00,
    1.00255184209528e+00,
    1.00255882608422e+00,
    1.00256578830890e+00,
    1.00257272859011e+00,
    1.00257964674903e+00,
    1.00258654260731e+00,
    1.00259341598703e+00,
    1.00260026671071e+00,
    1.00260709460131e+00,
    1.00261389948226e+00,
    1.00262068117744e+00,
    1.00262743951120e+00,
    1.00263417430833e+00,
    1.00264088539413e+00,
    1.00264757259434e+00,
    1.00265423573519e+00,
    1.00266087464341e+00,
    1.00266748914618e+00,
    1.00267407907121e+00,
    1.00268064424668e+00,
    1.00268718450128e+00,
    1.00269369966421e+00,
    1.00270018956516e+00,
    1.00270665403435e+00,
    1.00271309290251e+00,
    1.00271950600089e+00,
    1.00272589316127e+00,
    1.00273225421595e+00,
    1.00273858899778e+00,
    1.00274489734012e+00,
    1.00275117907691e+00,
    1.00275743404260e+00,
    1.00276366207221e+00,
    1.00276986300131e+00,
    1.00277603666603e+00,
    1.00278218290305e+00,
    1.00278830154964e+00,
    1.00279439244361e+00,
    1.00280045542338e+00,
    1.00280649032792e+00,
    1.00281249699680e+00,
    1.00281847527017e+00,
    1.00282442498876e+00,
    1.00283034599392e+00,
    1.00283623812758e+00,
    1.00284210123228e+00,
    1.00284793515117e+00,
    1.00285373972800e+00,
    1.00285951480715e+00,
    1.00286526023361e+00,
    1.00287097585299e+00,
    1.00287666151153e+00,
    1.00288231705610e+00,
    1.00288794233422e+00,
    1.00289353719403e+00,
    1.00289910148432e+00,
    1.00290463505453e+00,
    1.00291013775473e+00,
    1.00291560943568e+00,
    1.00292104994877e+00,
    1.00292645914607e+00,
    1.00293183688029e+00,
    1.00293718300485e+00,
    1.00294249737381e+00,
    1.00294777984192e+00,
    1.00295303026462e+00,
    1.00295824849802e+00,
    1.00296343439892e+00,
    1.00296858782482e+00,
    1.00297370863393e+00,
    1.00297879668513e+00,
    1.00298385183802e+00,
    1.00298887395292e+00,
    1.00299386289084e+00,
    1.00299881851352e+00,
    1.00300374068341e+00,
    1.00300862926369e+00,
    1.00301348411826e+00,
    1.00301830511176e+00,
    1.00302309210956e+00,
    1.00302784497775e+00,
    1.00303256358318e+00,
    1.00303724779345e+00,
    1.00304189747690e+00,
    1.00304651250261e+00,
    1.00305109274043e+00,
    1.00305563806098e+00,
    1.00306014833560e+00,
    1.00306462343645e+00,
    1.00306906323643e+00,
    1.00307346760921e+00,
    1.00307783642924e+00,
    1.00308216957177e+00,
    1.00308646691281e+00,
    1.00309072832916e+00,
    1.00309495369843e+00,
    1.00309914289899e+00,
    1.00310329581005e+00,
    1.00310741231159e+00,
    1.00311149228440e+00,
    1.00311553561009e+00,
    1.00311954217105e+00,
    1.00312351185054e+00,
    1.00312744453257e+00,
    1.00313134010203e+00,
    1.00313519844460e+00,
    1.00313901944680e+00,
    1.00314280299598e+00,
    1.00314654898032e+00,
    1.00315025728884e+00,
    1.00315392781140e+00,
    1.00315756043871e+00,
    1.00316115506232e+00,
    1.00316471157464e+00,
    1.00316822986891e+00,
    1.00317170983926e+00,
    1.00317515138066e+00,
    1.00317855438894e+00,
    1.00318191876081e+00,
    1.00318524439384e+00,
    1.00318853118647e+00,
    1.00319177903803e+00,
    1.00319498784871e+00,
    1.00319815751959e+00,
    1.00320128795264e+00,
    1.00320437905072e+00,
    1.00320743071755e+00,
    1.00321044285779e+00,
    1.00321341537696e+00,
    1.00321634818150e+00,
    1.00321924117875e+00,
    1.00322209427694e+00,
    1.00322490738522e+00,
    1.00322768041365e+00,
    1.00323041327322e+00,
    1.00323310587580e+00,
    1.00323575813421e+00,
    1.00323836996219e+00,
    1.00324094127440e+00,
    1.00324347198642e+00,
    1.00324596201476e+00,
    1.00324841127689e+00,
    1.00325081969119e+00,
    1.00325318717699e+00,
    1.00325551365455e+00,
    1.00325779904510e+00,
    1.00326004327079e+00,
    1.00326224625474e+00,
    1.00326440792100e+00,
    1.00326652819460e+00,
    1.00326860700151e+00,
    1.00327064426867e+00,
    1.00327263992397e+00,
    1.00327459389630e+00,
    1.00327650611546e+00,
    1.00327837651228e+00,
    1.00328020501852e+00,
    1.00328199156694e+00,
    1.00328373609127e+00,
    1.00328543852621e+00,
    1.00328709880745e+00,
    1.00328871687169e+00,
    1.00329029265657e+00,
    1.00329182610076e+00,
    1.00329331714390e+00,
    1.00329476572663e+00,
    1.00329617179059e+00,
    1.00329753527842e+00,
    1.00329885613376e+00,
    1.00330013430124e+00,
    1.00330136972653e+00,
    1.00330256235626e+00,
    1.00330371213812e+00,
    1.00330481902077e+00,
    1.00330588295392e+00,
    1.00330690388826e+00,
    1.00330788177554e+00,
    1.00330881656850e+00,
    1.00330970822091e+00,
    1.00331055668757e+00,
    1.00331136192431e+00,
    1.00331212388798e+00,
    1.00331284253647e+00,
    1.00331351782870e+00,
    1.00331414972461e+00,
    1.00331473818520e+00,
    1.00331528317250e+00,
    1.00331578464958e+00,
    1.00331624258056e+00,
    1.00331665693058e+00,
    1.00331702766586e+00,
    1.00331735475365e+00,
    1.00331763816225e+00,
    1.00331787786101e+00,
    1.00331807382035e+00,
    1.00331822601172e+00,
    1.00331833440764e+00,
    1.00331839898171e+00,
    1.00331841970855e+00,
    1.00331839656386e+00,
    1.00331832952442e+00,
    1.00331821856805e+00,
    1.00331806367365e+00,
    1.00331786482119e+00,
    1.00331762199171e+00,
    1.00331733516730e+00,
    1.00331700433116e+00,
    1.00331662946754e+00,
    1.00331621056177e+00,
    1.00331574760025e+00,
    1.00331524057049e+00,
    1.00331468946104e+00,
    1.00331409426156e+00,
    1.00331345496278e+00,
    1.00331277155652e+00,
    1.00331204403568e+00,
    1.00331127239425e+00,
    1.00331045662732e+00,
    1.00330959673104e+00,
    1.00330869270269e+00,
    1.00330774454062e+00,
    1.00330675224426e+00,
    1.00330571581415e+00,
    1.00330463525194e+00,
    1.00330351056036e+00,
    1.00330234174323e+00,
    1.00330112880548e+00,
    1.00329987175314e+00,
    1.00329857059334e+00,
    1.00329722533431e+00,
    1.00329583598539e+00,
    1.00329440255701e+00,
    1.00329292506072e+00,
    1.00329140350917e+00,
    1.00328983791611e+00,
    1.00328822829640e+00,
    1.00328657466602e+00,
    1.00328487704205e+00,
    1.00328313544268e+00,
    1.00328134988722e+00,
    1.00327952039607e+00,
    1.00327764699076e+00,
    1.00327572969394e+00,
    1.00327376852935e+00,
    1.00327176352187e+00,
    1.00326971469747e+00,
    1.00326762208327e+00,
    1.00326548570746e+00,
    1.00326330559939e+00,
    1.00326108178951e+00,
    1.00325881430938e+00,
    1.00325650319169e+00,
    1.00325414847025e+00,
    1.00325175017998e+00,
    1.00324930835693e+00,
    1.00324682303827e+00,
    1.00324429426228e+00,
    1.00324172206837e+00,
    1.00323910649707e+00,
    1.00323644759004e+00,
    1.00323374539004e+00,
    1.00323099994099e+00,
    1.00322821128788e+00,
    1.00322537947688e+00,
    1.00322250455524e+00,
    1.00321958657136e+00,
    1.00321662557474e+00,
    1.00321362161604e+00,
    1.00321057474699e+00,
    1.00320748502050e+00,
    1.00320435249057e+00,
    1.00320117721234e+00,
    1.00319795924206e+00,
    1.00319469863711e+00,
    1.00319139545600e+00,
    1.00318804975836e+00,
    1.00318466160494e+00,
    1.00318123105763e+00,
    1.00317775817942e+00,
    1.00317424303444e+00,
    1.00317068568794e+00,
    1.00316708620628e+00,
    1.00316344465697e+00,
    1.00315976110863e+00,
    1.00315603563099e+00,
    1.00315226829491e+00,
    1.00314845917239e+00,
    1.00314460833653e+00,
    1.00314071586156e+00,
    1.00313678182282e+00,
    1.00313280629679e+00,
    1.00312878936106e+00,
    1.00312473109433e+00,
    1.00312063157644e+00,
    1.00311649088832e+00,
    1.00311230911206e+00,
    1.00310808633082e+00,
    1.00310382262892e+00,
    1.00309951809176e+00,
    1.00309517280588e+00,
    1.00309078685893e+00,
    1.00308636033966e+00,
    1.00308189333796e+00,
    1.00307738594481e+00,
    1.00307283825231e+00,
    1.00306825035368e+00,
    1.00306362234323e+00,
    1.00305895431641e+00,
    1.00305424636975e+00,
    1.00304949860090e+00,
    1.00304471110863e+00,
    1.00303988399278e+00,
    1.00303501735435e+00,
    1.00303011129539e+00,
    1.00302516591908e+00,
    1.00302018132972e+00,
    1.00301515763266e+00,
    1.00301009493441e+00,
    1.00300499334253e+00,
    1.00299985296570e+00,
    1.00299467391371e+00,
    1.00298945629742e+00,
    1.00298420022881e+00,
    1.00297890582092e+00,
    1.00297357318791e+00,
    1.00296820244502e+00,
    1.00296279370859e+00,
    1.00295734709603e+00,
    1.00295186272586e+00,
    1.00294634071766e+00,
    1.00294078119211e+00,
    1.00293518427097e+00,
    1.00292955007709e+00,
    1.00292387873437e+00,
    1.00291817036784e+00,
    1.00291242510355e+00,
    1.00290664306865e+00,
    1.00290082439139e+00,
    1.00289496920104e+00,
    1.00288907762799e+00,
    1.00288314980366e+00,
    1.00287718586056e+00,
    1.00287118593226e+00,
    1.00286515015339e+00,
    1.00285907865965e+00,
    1.00285297158779e+00,
    1.00284682907563e+00,
    1.00284065126203e+00,
    1.00283443828693e+00,
    1.00282819029130e+00,
    1.00282190741717e+00,
    1.00281558980762e+00,
    1.00280923760677e+00,
    1.00280285095980e+00,
    1.00279643001292e+00,
    1.00278997491338e+00,
    1.00278348580949e+00,
    1.00277696285057e+00,
    1.00277040618699e+00,
    1.00276381597015e+00,
    1.00275719235248e+00,
    1.00275053548745e+00,
    1.00274384552953e+00,
    1.00273712263424e+00,
    1.00273036695810e+00,
    1.00272357865868e+00,
    1.00271675789454e+00,
    1.00270990482526e+00,
    1.00270301961144e+00,
    1.00269610241470e+00,
    1.00268915339764e+00,
    1.00268217272388e+00,
    1.00267516055806e+00,
    1.00266811706579e+00,
    1.00266104241370e+00,
    1.00265393676941e+00,
    1.00264680030152e+00,
    1.00263963317966e+00,
    1.00263243557439e+00,
    1.00262520765730e+00,
    1.00261794960095e+00,
    1.00261066157888e+00,
    1.00260334376560e+00,
    1.00259599633661e+00,
    1.00258861946836e+00,
    1.00258121333829e+00,
    1.00257377812480e+00,
    1.00256631400724e+00,
    1.00255882116595e+00,
    1.00255129978220e+00,
    1.00254375003823e+00,
    1.00253617211722e+00,
    1.00252856620331e+00,
    1.00252093248159e+00,
    1.00251327113808e+00,
    1.00250558235974e+00,
    1.00249786633448e+00,
    1.00249012325114e+00,
    1.00248235329948e+00,
    1.00247455667021e+00,
    1.00246673355494e+00,
    1.00245888414621e+00,
    1.00245100863748e+00,
    1.00244310722314e+00,
    1.00243518009847e+00,
    1.00242722745966e+00,
    1.00241924950381e+00,
    1.00241124642894e+00,
    1.00240321843395e+00,
    1.00239516571862e+00,
    1.00238708848366e+00,
    1.00237898693064e+00,
    1.00237086126203e+00,
    1.00236271168117e+00,
    1.00235453839228e+00,
    1.00234634160047e+00,
    1.00233812151171e+00,
    1.00232987833283e+00,
    1.00232161227153e+00,
    1.00231332353638e+00,
    1.00230501233680e+00,
    1.00229667888306e+00,
    1.00228832338627e+00,
    1.00227994605842e+00,
    1.00227154711231e+00,
    1.00226312676159e+00,
    1.00225468522074e+00,
    1.00224622270508e+00,
    1.00223773943074e+00,
    1.00222923561470e+00,
    1.00222071147474e+00,
    1.00221216722945e+00,
    1.00220360309824e+00,
    1.00219501930134e+00,
    1.00218641605977e+00,
    1.00217779359535e+00,
    1.00216915213070e+00,
    1.00216049188922e+00,
    1.00215181309511e+00,
    1.00214311597336e+00,
    1.00213440074972e+00,
    1.00212566765073e+00,
    1.00211691690370e+00,
    1.00210814873669e+00,
    1.00209936337854e+00,
    1.00209056105885e+00,
    1.00208174200797e+00,
    1.00207290645699e+00,
    1.00206405463777e+00,
    1.00205518678288e+00,
    1.00204630312565e+00,
    1.00203740390014e+00,
    1.00202848934112e+00,
    1.00201955968412e+00,
    1.00201061516535e+00,
    1.00200165602176e+00,
    1.00199268249100e+00,
    1.00198369481144e+00,
    1.00197469322213e+00,
    1.00196567796283e+00,
    1.00195664927400e+00,
    1.00194760739677e+00,
    1.00193855257297e+00,
    1.00192948504509e+00,
    1.00192040505631e+00,
    1.00191131285048e+00,
    1.00190220867211e+00,
    1.00189309276635e+00,
    1.00188396537905e+00,
    1.00187482675666e+00,
    1.00186567714632e+00,
    1.00185651679578e+00,
    1.00184734595344e+00,
    1.00183816486833e+00,
    1.00182897379010e+00,
    1.00181977296902e+00,
    1.00181056265600e+00,
    1.00180134310252e+00,
    1.00179211456071e+00,
    1.00178287728327e+00,
    1.00177363152351e+00,
    1.00176437753533e+00,
    1.00175511557322e+00,
    1.00174584589223e+00,
    1.00173656874802e+00,
    1.00172728439680e+00,
    1.00171799309535e+00,
    1.00170869510101e+00,
    1.00169939067167e+00,
    1.00169008006578e+00,
    1.00168076354233e+00,
    1.00167144136086e+00,
    1.00166211378143e+00,
    1.00165278106463e+00,
    1.00164344347159e+00,
    1.00163410126394e+00,
    1.00162475470383e+00,
    1.00161540405392e+00,
    1.00160604957738e+00,
    1.00159669153786e+00,
    1.00158733019951e+00,
    1.00157796582697e+00,
    1.00156859868535e+00,
    1.00155922904025e+00,
    1.00154985715773e+00,
    1.00154048330431e+00,
    1.00153110774698e+00,
    1.00152173075317e+00,
    1.00151235259077e+00,
    1.00150297352811e+00,
    1.00149359383393e+00,
    1.00148421377745e+00,
    1.00147483362827e+00,
    1.00146545365643e+00,
    1.00145607413237e+00,
    1.00144669532696e+00,
    1.00143731751145e+00,
    1.00142794095750e+00,
    1.00141856593714e+00,
    1.00140919272281e+00,
    1.00139982158730e+00,
    1.00139045280381e+00,
    1.00138108664587e+00,
    1.00137172338739e+00,
    1.00136236330262e+00,
    1.00135300666618e+00,
    1.00134365375302e+00,
    1.00133430483843e+00,
    1.00132496019802e+00,
    1.00131562010774e+00,
    1.00130628484385e+00,
    1.00129695468292e+00,
    1.00128762990183e+00,
    1.00127831077778e+00,
    1.00126899758822e+00,
    1.00125969061093e+00,
    1.00125039012394e+00,
    1.00124109640559e+00,
    1.00123180973446e+00,
    1.00122253038940e+00,
    1.00121325864953e+00,
    1.00120399479420e+00,
    1.00119473910303e+00,
    1.00118549185585e+00,
    1.00117625333274e+00,
    1.00116702381400e+00,
    1.00115780358015e+00,
    1.00114859291192e+00,
    1.00113939209026e+00,
    1.00113020139630e+00,
    1.00112102111138e+00,
    1.00111185151700e+00,
    1.00110269289488e+00,
    1.00109354552689e+00,
    1.00108440969506e+00,
    1.00107528568161e+00,
    1.00106617376888e+00,
    1.00105707423938e+00,
    1.00104798737576e+00,
    1.00103891346080e+00,
    1.00102985277741e+00,
    1.00102080560861e+00,
    1.00101177223756e+00,
    1.00100275294750e+00,
    1.00099374802179e+00,
    1.00098475774389e+00,
    1.00097578239732e+00,
    1.00096682226571e+00,
    1.00095787763274e+00,
    1.00094894878219e+00,
    1.00094003599788e+00,
    1.00093113956367e+00,
    1.00092225976349e+00,
    1.00091339688132e+00,
    1.00090455120114e+00,
    1.00089572300698e+00,
    1.00088691258288e+00,
    1.00087812021291e+00,
    1.00086934618113e+00,
    1.00086059077159e+00,
    1.00085185426836e+00,
    1.00084313695548e+00,
    1.00083443911696e+00,
    1.00082576103679e+00,
    1.00081710299893e+00,
    1.00080846528729e+00,
    1.00079984818573e+00,
    1.00079125197806e+00,
    1.00078267694801e+00,
    1.00077412337926e+00,
    1.00076559155540e+00,
    1.00075708175992e+00,
    1.00074859427625e+00,
    1.00074012938770e+00,
    1.00073168737748e+00,
    1.00072326852868e+00,
    1.00071487312426e+00,
    1.00070650144708e+00,
    1.00069815377984e+00,
    1.00068983040510e+00,
    1.00068153160529e+00,
    1.00067325766265e+00,
    1.00066500885928e+00,
    1.00065678547710e+00,
    1.00064858779784e+00,
    1.00064041610307e+00,
    1.00063227067415e+00,
    1.00062415179222e+00,
    1.00061605973824e+00,
    1.00060799479295e+00,
    1.00059995723685e+00,
    1.00059194735022e+00,
    1.00058396541310e+00,
    1.00057601170528e+00,
    1.00056808650632e+00,
    1.00056019009547e+00,
    1.00055232275176e+00,
    1.00054448475393e+00,
    1.00053667638041e+00,
    1.00052889790938e+00,
    1.00052114961869e+00,
    1.00051343178591e+00,
    1.00050574468827e+00,
    1.00049808860270e+00,
    1.00049046380578e+00,
    1.00048287057378e+00,
    1.00047530918260e+00,
    1.00046777990781e+00,
    1.00046028302461e+00,
    1.00045281880783e+00,
    1.00044538753192e+00,
    1.00043798947097e+00,
    1.00043062489866e+00,
    1.00042329408829e+00,
    1.00041599731272e+00,
    1.00040873484444e+00,
    1.00040150695549e+00,
    1.00039431391750e+00,
    1.00038715600163e+00,
    1.00038003347865e+00,
    1.00037294661882e+00,
    1.00036589569198e+00,
    1.00035888096748e+00,
    1.00035190271422e+00,
    1.00034496120058e+00,
    1.00033805669449e+00,
    1.00033118946334e+00,
    1.00032435977403e+00,
    1.00031756789297e+00,
    1.00031081408600e+00,
    1.00030409861847e+00,
    1.00029742175517e+00,
    1.00029078376034e+00,
    1.00028418489769e+00,
    1.00027762543034e+00,
    1.00027110562084e+00,
    1.00026462573120e+00,
    1.00025818602279e+00,
    1.00025178675642e+00,
    1.00024542819229e+00,
    1.00023911058998e+00,
    1.00023283420847e+00,
    1.00022659930610e+00,
    1.00022040614058e+00,
    1.00021425496897e+00,
    1.00020814604769e+00,
    1.00020207963249e+00,
    1.00019605597846e+00,
    1.00019007534002e+00,
    1.00018413797090e+00,
    1.00017824412413e+00,
    1.00017239405207e+00,
    1.00016658800633e+00,
    1.00016082623784e+00,
    1.00015510899679e+00,
    1.00014943653264e+00,
    1.00014380909411e+00,
    1.00013822692919e+00,
    1.00013269028508e+00,
    1.00012719940823e+00,
    1.00012175454432e+00,
    1.00011635593826e+00,
    1.00011100383416e+00,
    1.00010569847531e+00,
    1.00010044010423e+00,
    1.00009522896261e+00,
    1.00009006529132e+00,
    1.00008494933040e+00,
    1.00007988131904e+00,
    1.00007486149560e+00,
    1.00006989009758e+00,
    1.00006496736161e+00,
    1.00006009352346e+00,
    1.00005526881799e+00,
    1.00005049347922e+00,
    1.00004576774022e+00,
    1.00004109183321e+00,
    1.00003646598944e+00,
    1.00003189043928e+00,
    1.00002736541215e+00,
    1.00002289113654e+00,
    1.00001846783999e+00,
    1.00001409574908e+00,
    1.00000977508943e+00,
    1.00000550608570e+00,
    1.00000128896155e+00,
    9.99997123939662e-01,
    9.99993011241712e-01,
    9.99988951088380e-01,
    9.99984943699330e-01,
    9.99980989293200e-01,
    9.99977088087601e-01,
    9.99973240299101e-01,
    9.99969446143224e-01,
    9.99965705834433e-01,
    9.99962019586132e-01,
    9.99958387610648e-01,
    9.99954810119226e-01,
    9.99951287322025e-01,
    9.99947819428103e-01,
    9.99944406645409e-01,
    9.99941049180781e-01,
    9.99937747239929e-01,
    9.99934501027434e-01,
    9.99931310746734e-01,
    9.99928176600119e-01,
    9.99925098788720e-01,
    9.99922077512502e-01,
    9.99919112970255e-01,
    9.99916205359587e-01,
    9.99913354876913e-01,
    9.99910561717446e-01,
    9.99907826075194e-01,
    9.99905148142944e-01,
    9.99902528112260e-01,
    9.99899966173468e-01,
    9.99897462515655e-01,
    9.99895017326652e-01,
    9.99892630793034e-01,
    9.99890303100106e-01,
    9.99888034431894e-01,
    9.99885824971140e-01,
    9.99883674899292e-01,
    9.99881584396496e-01,
    9.99879553641583e-01,
    9.99877582812067e-01,
    9.99875672084134e-01,
    9.99873821632630e-01,
    9.99872031631057e-01,
    9.99870302251564e-01,
    9.99868633664936e-01,
    9.99867026040585e-01,
    9.99865479546547e-01,
    9.99863994349465e-01,
    9.99862570614589e-01,
    9.99861208505760e-01,
    9.99859908185407e-01,
    9.99858669814535e-01,
    9.99857493552718e-01,
    9.99856379558091e-01,
    9.99855327987338e-01,
    9.99854338995687e-01,
    9.99853412736901e-01,
    9.99852549363268e-01,
    9.99851749025593e-01,
    9.99851011873190e-01,
    9.99850338053872e-01,
    9.99849727713943e-01,
    9.99849180998193e-01,
    9.99848698049880e-01,
    9.99848279010734e-01,
    9.99847924020938e-01,
    9.99847633219123e-01,
    9.99847406742363e-01,
    9.99847244726160e-01,
    9.99847147304441e-01,
    9.99847114609543e-01,
    9.99847146772215e-01,
    9.99847243921596e-01,
    9.99847406185217e-01,
    9.99847633688989e-01,
    9.99847926557190e-01,
    9.99848284912466e-01,
    9.99848708875814e-01,
    9.99849198566573e-01,
    9.99849754102426e-01,
    9.99850375599379e-01,
    9.99851063171759e-01,
    9.99851816932203e-01,
    9.99852636991652e-01,
    9.99853523459340e-01,
    9.99854476442786e-01,
    9.99855496047787e-01,
    9.99856582378405e-01,
    9.99857735536966e-01,
    9.99858955624044e-01,
    9.99860242738456e-01,
    9.99861596977254e-01,
    9.99863018435713e-01,
    9.99864507207328e-01,
    9.99866063383799e-01,
    9.99867687055029e-01,
    9.99869378309109e-01,
    9.99871137232315e-01,
    9.99872963909096e-01,
    9.99874858422068e-01,
    9.99876820852000e-01,
    9.99878851277815e-01,
    9.99880949776573e-01,
    9.99883116423465e-01,
    9.99885351291807e-01,
    9.99887654453028e-01,
    9.99890025976664e-01,
    9.99892465930348e-01,
    9.99894974379801e-01,
    9.99897551388826e-01,
    9.99900197019297e-01,
    9.99902911331153e-01,
    9.99905694382387e-01,
    9.99908546229039e-01,
    9.99911466925186e-01,
    9.99914456522935e-01,
    9.99917515072417e-01,
    9.99920642621773e-01,
    9.99923839217149e-01,
    9.99927104902686e-01,
    9.99930439720514e-01,
    9.99933843710742e-01,
    9.99937316911448e-01,
    9.99940859358674e-01,
    9.99944471086416e-01,
    9.99948152126614e-01,
    9.99951902509146e-01,
    9.99955722261818e-01,
    9.99959611410356e-01,
    9.99963569978400e-01,
    9.99967597987491e-01,
    9.99971695457067e-01,
    9.99975862404451e-01,
    9.99980098844846e-01,
    9.99984404791326e-01,
    9.99988780254824e-01,
    9.99993225244129e-01,
    9.99997739765873e-01,
    1.00000232382452e+00,
    1.00000697742238e+00,
    1.00001170055957e+00,
    1.00001649323402e+00,
    1.00002135544146e+00,
    1.00002628717543e+00,
    1.00003128842723e+00,
    1.00003635918597e+00,
    1.00004149943852e+00,
    1.00004670916950e+00,
    1.00005198836129e+00,
    1.00005733699403e+00,
    1.00006275504559e+00,
    1.00006824249156e+00,
    1.00007379930526e+00,
    1.00007942545772e+00,
    1.00008512091768e+00,
    1.00009088565158e+00,
    1.00009671962354e+00,
    1.00010262279535e+00,
    1.00010859512650e+00,
    1.00011463657413e+00,
    1.00012074709304e+00,
    1.00012692663566e+00,
    1.00013317515209e+00,
    1.00013949259004e+00,
    1.00014587889486e+00,
    1.00015233400950e+00,
    1.00015885787453e+00,
    1.00016545042811e+00,
    1.00017211160600e+00,
    1.00017884134154e+00,
    1.00018563956565e+00,
    1.00019250620681e+00,
    1.00019944119107e+00,
    1.00020644444203e+00,
    1.00021351588082e+00,
    1.00022065542612e+00,
    1.00022786299413e+00,
    1.00023513849859e+00,
    1.00024248185073e+00,
    1.00024989295929e+00,
    1.00025737173051e+00,
    1.00026491806811e+00,
    1.00027253187332e+00,
    1.00028021304479e+00,
    1.00028796147869e+00,
    1.00029577706861e+00,
    1.00030365970562e+00,
    1.00031160927819e+00,
    1.00031962567227e+00,
    1.00032770877121e+00,
    1.00033585845578e+00,
    1.00034407460417e+00,
    1.00035235709196e+00,
    1.00036070579214e+00,
    1.00036912057508e+00,
    1.00037760130853e+00,
    1.00038614785762e+00,
    1.00039476008482e+00,
    1.00040343785000e+00,
    1.00041218101034e+00,
    1.00042098942037e+00,
    1.00042986293198e+00,
    1.00043880139435e+00,
    1.00044780465401e+00,
    1.00045687255478e+00,
    1.00046600493781e+00,
    1.00047520164150e+00,
    1.00048446250160e+00,
    1.00049378735109e+00,
    1.00050317602026e+00,
    1.00051262833664e+00,
    1.00052214412503e+00,
    1.00053172320749e+00,
    1.00054136540332e+00,
    1.00055107052906e+00,
    1.00056083839846e+00,
    1.00057066882251e+00,
    1.00058056160943e+00,
    1.00059051656461e+00,
    1.00060053349067e+00,
    1.00061061218742e+00,
    1.00062075245185e+00,
    1.00063095407813e+00,
    1.00064121685760e+00,
    1.00065154057876e+00,
    1.00066192502728e+00,
    1.00067236998598e+00,
    1.00068287523481e+00,
    1.00069344055087e+00,
    1.00070406570838e+00,
    1.00071475047867e+00,
    1.00072549463022e+00,
    1.00073629792859e+00,
    1.00074716013644e+00,
    1.00075808101353e+00,
    1.00076906031672e+00,
    1.00078009779992e+00,
    1.00079119321415e+00,
    1.00080234630746e+00,
    1.00081355682498e+00,
    1.00082482450888e+00,
    1.00083614909840e+00,
    1.00084753032979e+00,
    1.00085896793633e+00,
    1.00087046164836e+00,
    1.00088201119320e+00,
    1.00089361629520e+00,
    1.00090527667570e+00,
    1.00091699205307e+00,
    1.00092876214263e+00,
    1.00094058665672e+00,
    1.00095246530462e+00,
    1.00096439779263e+00,
    1.00097638382396e+00,
    1.00098842309883e+00,
    1.00100051531437e+00,
    1.00101266016467e+00,
    1.00102485734078e+00,
    1.00103710653064e+00,
    1.00104940741914e+00,
    1.00106175968810e+00,
    1.00107416301623e+00,
    1.00108661707915e+00,
    1.00109912154940e+00,
    1.00111167609638e+00,
    1.00112428038641e+00,
    1.00113693408267e+00,
    1.00114963684521e+00,
    1.00116238833098e+00,
    1.00117518819375e+00,
    1.00118803608418e+00,
    1.00120093164976e+00,
    1.00121387453484e+00,
    1.00122686438058e+00,
    1.00123990082500e+00,
    1.00125298350294e+00,
    1.00126611204603e+00,
    1.00127928608276e+00,
    1.00129250523839e+00,
    1.00130576913500e+00,
    1.00131907739145e+00,
    1.00133242962341e+00,
    1.00134582544332e+00,
    1.00135926446039e+00,
    1.00137274628062e+00,
    1.00138627050676e+00,
    1.00139983673833e+00,
    1.00141344457161e+00,
    1.00142709359961e+00,
    1.00144078341209e+00,
    1.00145451359556e+00,
    1.00146828373324e+00,
    1.00148209340509e+00,
    1.00149594218780e+00,
    1.00150982965474e+00,
    1.00152375537603e+00,
    1.00153771891847e+00,
    1.00155171984555e+00,
    1.00156575771749e+00,
    1.00157983209115e+00,
    1.00159394252010e+00,
    1.00160808855459e+00,
    1.00162226974153e+00,
    1.00163648562450e+00,
    1.00165073574373e+00,
    1.00166501963612e+00,
    1.00167933683522e+00,
    1.00169368687121e+00,
    1.00170806927092e+00,
    1.00172248355782e+00,
    1.00173692925199e+00,
    1.00175140587017e+00,
    1.00176591292568e+00,
    1.00178044992847e+00,
    1.00179501638512e+00,
    1.00180961179877e+00,
    1.00182423566921e+00,
    1.00183888749278e+00,
    1.00185356676244e+00,
    1.00186827296772e+00,
    1.00188300559474e+00,
    1.00189776412619e+00,
    1.00191254804132e+00,
    1.00192735681598e+00,
    1.00194218992254e+00,
    1.00195704682995e+00,
    1.00197192700371e+00,
    1.00198682990586e+00,
    1.00200175499500e+00,
    1.00201670172625e+00,
    1.00203166955127e+00,
    1.00204665791826e+00,
    1.00206166627193e+00,
    1.00207669405351e+00,
    1.00209174070077e+00,
    1.00210680564797e+00,
    1.00212188832588e+00,
    1.00213698816179e+00,
    1.00215210457947e+00,
    1.00216723699920e+00,
    1.00218238483775e+00,
    1.00219754750836e+00,
    1.00221272442078e+00,
    1.00222791498122e+00,
    1.00224311859237e+00,
    1.00225833465340e+00,
    1.00227356255993e+00,
    1.00228880170407e+00,
    1.00230405147437e+00,
    1.00231931125583e+00,
    1.00233458042993e+00,
    1.00234985837457e+00,
    1.00236514446411e+00,
    1.00238043806935e+00,
    1.00239573855752e+00,
    1.00241104529230e+00,
    1.00242635763379e+00,
    1.00244167493851e+00,
    1.00245699655942e+00,
    1.00247232184589e+00,
    1.00248765014371e+00,
    1.00250298079508e+00,
    1.00251831313861e+00,
    1.00253364650933e+00,
    1.00254898023867e+00,
    1.00256431365444e+00,
    1.00257964608086e+00,
    1.00259497683856e+00,
    1.00261030524455e+00,
    1.00262563061222e+00,
    1.00264095225135e+00,
    1.00265626946811e+00,
    1.00267158156504e+00,
    1.00268688784106e+00,
    1.00270218759148e+00,
    1.00271748010795e+00,
    1.00273276467851e+00,
    1.00274804058756e+00,
    1.00276330711586e+00,
    1.00277856354054e+00,
    1.00279380913508e+00,
    1.00280904316932e+00,
    1.00282426490944e+00,
    1.00283947361799e+00,
    1.00285466855385e+00,
    1.00286984897227e+00,
    1.00288501412481e+00,
    1.00290016325939e+00,
    1.00291529562028e+00,
    1.00293041044806e+00,
    1.00294550697967e+00,
    1.00296058444837e+00,
    1.00297564208374e+00,
    1.00299067911171e+00,
    1.00300569475453e+00,
    1.00302068823076e+00,
    1.00303565875529e+00,
    1.00305060553936e+00,
    1.00306552779047e+00,
    1.00308042471250e+00,
    1.00309529550559e+00,
    1.00311013936624e+00,
    1.00312495548723e+00,
    1.00313974305767e+00,
    1.00315450126297e+00,
    1.00316922928485e+00,
    1.00318392630134e+00,
    1.00319859148676e+00,
    1.00321322401176e+00,
    1.00322782304327e+00,
    1.00324238774452e+00,
    1.00325691727506e+00,
    1.00327141079073e+00,
    1.00328586744365e+00,
    1.00330028638226e+00,
    1.00331466675130e+00,
    1.00332900769177e+00,
    1.00334330834099e+00,
    1.00335756783258e+00,
    1.00337178529644e+00,
    1.00338595985875e+00,
    1.00340009064200e+00,
    1.00341417676496e+00,
    1.00342821734269e+00,
    1.00344221148655e+00,
    1.00345615830418e+00,
    1.00347005689949e+00,
    1.00348390637271e+00,
    1.00349770582034e+00,
    1.00351145433516e+00,
    1.00352515100626e+00,
    1.00353879491898e+00,
    1.00355238515499e+00,
    1.00356592079221e+00,
    1.00357940090486e+00,
    1.00359282456344e+00,
    1.00360619083476e+00,
    1.00361949878188e+00,
    1.00363274746416e+00,
    1.00364593593727e+00,
    1.00365906325313e+00,
    1.00367212845997e+00,
    1.00368513060230e+00,
    1.00369806872091e+00,
    1.00371094185290e+00,
    1.00372374903163e+00,
    1.00373648928678e+00,
    1.00374916164430e+00,
    1.00376176512643e+00,
    1.00377429875171e+00,
    1.00378676153496e+00,
    1.00379915248731e+00,
    1.00381147061618e+00,
    1.00382371492526e+00,
    1.00383588441457e+00,
    1.00384797808041e+00,
    1.00385999491538e+00,
    1.00387193390837e+00,
    1.00388379404459e+00,
    1.00389557430553e+00,
    1.00390727366900e+00,
    1.00391889110910e+00,
    1.00393042559625e+00,
    1.00394187609717e+00,
    1.00395324157488e+00,
    1.00396452098873e+00,
    1.00397571329435e+00,
    1.00398681744373e+00,
    1.00399783238513e+00,
    1.00400875706315e+00,
    1.00401959041871e+00,
    1.00403033138905e+00,
    1.00404097890772e+00,
    1.00405153190460e+00,
    1.00406198930591e+00,
    1.00407235003420e+00,
    1.00408261300832e+00,
    1.00409277714350e+00,
    1.00410284135126e+00,
    1.00411280453949e+00,
    1.00412266561242e+00,
    1.00413242347061e+00,
    1.00414207701097e+00,
    1.00415162512675e+00,
    1.00416106670758e+00,
    1.00417040063942e+00,
    1.00417962580459e+00,
    1.00418874108178e+00,
    1.00419774534602e+00,
    1.00420663746874e+00,
    1.00421541631771e+00,
    1.00422408075709e+00,
    1.00423262964740e+00,
    1.00424106184555e+00,
    1.00424937620483e+00,
    1.00425757157491e+00,
    1.00426564680185e+00,
    1.00427360072811e+00,
    1.00428143219253e+00,
    1.00428914003037e+00,
    1.00429672307327e+00,
    1.00430418014929e+00,
    1.00431151008291e+00,
    1.00431871169500e+00,
    1.00432578380286e+00,
    1.00433272522022e+00,
    1.00433953475722e+00,
    1.00434621122044e+00,
    1.00435275341290e+00,
    1.00435916013405e+00,
    1.00436543017978e+00,
    1.00437156234243e+00,
    1.00437755541080e+00,
    1.00438340817014e+00,
    1.00438911940215e+00,
    1.00439468788502e+00,
    1.00440011239339e+00,
    1.00440539169837e+00,
    1.00441052456758e+00,
    1.00441550976509e+00,
    1.00442034605148e+00,
    1.00442503218382e+00,
    1.00442956691567e+00,
    1.00443394899711e+00,
    1.00443817717472e+00,
    1.00444225019159e+00,
    1.00444616678734e+00,
    1.00444992569812e+00,
    1.00445352565660e+00,
    1.00445696539200e+00,
    1.00446024363005e+00,
    1.00446335909307e+00,
    1.00446631049992e+00,
    1.00446909656600e+00,
    1.00447171600329e+00,
    1.00447416752035e+00,
    1.00447644982231e+00,
    1.00447856161087e+00,
    1.00448050158434e+00,
    1.00448226843761e+00,
    1.00448386086219e+00,
    1.00448527754618e+00,
    1.00448651717430e+00,
    1.00448757842789e+00,
    1.00448845998493e+00,
    1.00448916052002e+00,
    1.00448967870440e+00,
    1.00449001320598e+00,
    1.00449016268929e+00,
    1.00449012581554e+00,
    1.00448990124262e+00,
    1.00448948762508e+00,
    1.00448888361414e+00,
    1.00448808785775e+00,
    1.00448709900051e+00,
    1.00448591568375e+00,
    1.00448453654552e+00,
    1.00448296022056e+00,
    1.00448118534036e+00,
    1.00447921053313e+00,
    1.00447703442384e+00,
    1.00447465563420e+00,
    1.00447207278266e+00,
    1.00446928448445e+00,
    1.00446628935158e+00,
    1.00446308599284e+00,
    1.00445967301379e+00,
    1.00445604901680e+00,
    1.00445221260106e+00,
    1.00444816236254e+00,
    1.00444389689406e+00,
    1.00443941478527e+00,
    1.00443471462263e+00,
    1.00442979498949e+00,
    1.00442465446601e+00,
    1.00441929162926e+00,
    1.00441370505315e+00,
    1.00440789330850e+00,
    1.00440185496299e+00,
    1.00439558858122e+00,
    1.00438909272470e+00,
    1.00438236595186e+00,
    1.00437540681805e+00,
    1.00436821387556e+00,
    1.00436078567363e+00,
    1.00435312075845e+00,
    1.00434521767318e+00,
    1.00433707495796e+00,
    1.00432869114990e+00,
    1.00432006478312e+00,
    1.00431119438874e+00,
    1.00430207849489e+00,
    1.00429271562673e+00,
    1.00428310430645e+00,
    1.00427324305328e+00,
    1.00426313038352e+00,
    1.00425276481053e+00,
    1.00424214484472e+00,
    1.00423126899363e+00,
    1.00422013576186e+00,
    1.00420874365113e+00,
    1.00419709116028e+00,
    1.00418517678528e+00,
    1.00417299901922e+00,
    1.00416055635237e+00,
    1.00414784727214e+00,
    1.00413487026310e+00,
    1.00412162380705e+00,
    1.00410810638292e+00,
    1.00409431646690e+00,
    1.00408025253237e+00,
    1.00406591304994e+00,
    1.00405129648747e+00,
    1.00403640131005e+00,
    1.00402122598005e+00,
    1.00400576895711e+00,
    1.00399002869816e+00,
    1.00397400365743e+00,
    1.00395769228643e+00,
    1.00394109303404e+00,
    1.00392420434644e+00,
    1.00390702466717e+00,
    1.00388955243711e+00,
    1.00387178609454e+00,
    1.00385372407509e+00,
    1.00383536481183e+00,
    1.00381670673518e+00,
    1.00379774827304e+00,
    1.00377848785069e+00,
    1.00375892389090e+00,
    1.00373905481387e+00,
    1.00371887903728e+00,
    1.00369839497631e+00,
    1.00367760104361e+00,
    1.00365649564936e+00,
    1.00363507720127e+00,
    1.00361334410456e+00,
    1.00359129476204e+00,
    1.00356892757405e+00,
    1.00354624093852e+00,
    1.00352323325098e+00,
    1.00349990290456e+00,
    1.00347624829001e+00,
    1.00345226779570e+00,
    1.00342795980768e+00,
    1.00340332270962e+00,
    1.00337835488289e+00,
    1.00335305470654e+00,
    1.00332742055734e+00,
    1.00330145080976e+00,
    1.00327514383601e+00,
    1.00324849800604e+00,
    1.00322151168757e+00,
    1.00319418324609e+00,
    1.00316651104488e+00,
    1.00313849344505e+00,
    1.00311012880548e+00,
    1.00308141548294e+00,
    1.00305235183201e+00,
    1.00302293620515e+00,
    1.00299316695271e+00,
    1.00296304242293e+00,
    1.00293256096196e+00,
    1.00290172091386e+00,
    1.00287052062067e+00,
    1.00283895842235e+00,
    1.00280703265686e+00,
    1.00277474166014e+00,
    1.00274208376613e+00,
    1.00270905730680e+00,
    1.00267566061215e+00,
    1.00264189201024e+00,
    1.00260774982719e+00,
    1.00257323238722e+00,
    1.00253833801264e+00,
    1.00250306502388e+00,
    1.00246741173951e+00,
    1.00243137647624e+00,
    1.00239495754896e+00,
    1.00235815327074e+00,
    1.00232096195286e+00,
    1.00228338190479e+00,
    1.00224541143427e+00,
    1.00220704884727e+00,
    1.00216829244805e+00,
    1.00212914053912e+00,
    1.00208959142133e+00,
    1.00204964339384e+00,
    1.00200929475413e+00,
    1.00196854379807e+00,
    1.00192738881988e+00,
    1.00188582811217e+00,
    1.00184385996596e+00,
    1.00180148267072e+00,
    1.00175869451433e+00,
    1.00171549378316e+00,
    1.00167187876204e+00,
    1.00162784773431e+00,
    1.00158339898183e+00,
    1.00153853078498e+00,
    1.00149324142271e+00,
    1.00144752917253e+00,
    1.00140139231055e+00,
    1.00135482911149e+00,
    1.00130783784868e+00,
    1.00126041679411e+00,
    1.00121256421845e+00,
    1.00116427839101e+00,
    1.00111555757986e+00,
    1.00106640005174e+00,
    1.00101680407216e+00,
    1.00096676790540e+00,
    1.00091628981449e+00,
    1.00086536806127e+00,
    1.00081400090642e+00,
    1.00076218660943e+00,
    1.00070992342865e+00,
    1.00065720962133e+00,
    1.00060404344361e+00,
    1.00055042315052e+00,
    1.00049634699605e+00,
    1.00044181323316e+00,
    1.00038682011376e+00,
    1.00033136588877e+00,
    1.00027544880813e+00,
    1.00021906712081e+00,
    1.00016221907484e+00,
    1.00010490291734e+00,
    1.00004711689450e+00,
    9.99988859251679e-01,
    9.99930128233320e-01,
    9.99870922083064e-01,
    9.99811239043723e-01,
    9.99751077357313e-01,
    9.99690435265074e-01,
    9.99629311007491e-01,
    9.99567702824314e-01,
    9.99505608954582e-01,
    9.99443027636642e-01,
    9.99379957108172e-01,
    9.99316395606199e-01,
    9.99252341367125e-01,
    9.99187792626746e-01,
    9.99122747620275e-01,
    9.99057204582363e-01,
    9.98991161747120e-01,
    9.98924617348139e-01,
    9.98857569618515e-01,
    9.98790016790872e-01,
    9.98721957097378e-01,
    9.98653388769774e-01,
    9.98584310039394e-01,
    9.98514719137183e-01,
    9.98444614293728e-01,
    9.98373993739273e-01,
    9.98302855703745e-01,
    9.98231198416775e-01,
    9.98159020107724e-01,
    9.98086319005701e-01,
    9.98013093339590e-01,
    9.97939341338072e-01,
    9.97865061229644e-01,
    9.97790251242650e-01,
    9.97714909605297e-01,
    9.97639034545679e-01,
    9.97562624291808e-01,
    9.97485677071625e-01,
    9.97408191113035e-01,
    9.97330164643923e-01,
    9.97251595892180e-01,
    9.97172483085728e-01,
    9.97092824452543e-01,
    9.97012618220677e-01,
    9.96931862618283e-01,
    9.96850555873642e-01,
    9.96768696215180e-01,
    9.96686281871500e-01,
    9.96603311071402e-01,
    9.96519782043906e-01,
    9.96435693018280e-01,
    9.96351042224060e-01,
    9.96265827891081e-01,
    9.96180048249494e-01,
    9.96093701529796e-01,
    9.96006785962850e-01,
    9.95919299779916e-01,
    9.95831241212671e-01,
    9.95742608493234e-01,
    9.95653399854193e-01,
    9.95563613528629e-01,
    9.95473247750142e-01,
    9.95382300752873e-01,
    9.95290770771535e-01,
    9.95198656041431e-01,
    9.95105954798487e-01,
    9.95012665279270e-01,
    9.94918785721019e-01,
    9.94824314361669e-01,
    9.94729249439875e-01,
    9.94633589195038e-01,
    9.94537331867337e-01,
    9.94440475697742e-01,
    9.94343018928052e-01,
    9.94244959800916e-01,
    9.94146296559858e-01,
    9.94047027449305e-01,
    9.93947150714612e-01,
    9.93846664602090e-01,
    9.93745567359031e-01,
    9.93643857233733e-01,
    9.93541532475527e-01,
    9.93438591334808e-01,
    9.93335032063054e-01,
    9.93230852912859e-01,
    9.93126052137954e-01,
    9.93020627993240e-01,
    9.92914578734809e-01,
    9.92807902619975e-01,
    9.92700597907298e-01,
    9.92592662856613e-01,
    9.92484095729056e-01,
    9.92374894787092e-01,
    9.92265058294539e-01,
    9.92154584516601e-01,
    9.92043471719889e-01,
    9.91931718172454e-01,
    9.91819322143809e-01,
    9.91706281904962e-01,
    9.91592595728437e-01,
    9.91478261888308e-01,
    9.91363278660224e-01,
    9.91247644321434e-01,
    9.91131357150820e-01,
    9.91014415428920e-01,
    9.90896817437958e-01,
    9.90778561461873e-01,
    9.90659645786346e-01,
    9.90540068698827e-01,
    9.90419828488562e-01,
    9.90298923446627e-01,
    9.90177351865949e-01,
    9.90055112041339e-01,
    9.89932202269518e-01,
    9.89808620849147e-01,
    9.89684366080854e-01,
    9.89559436267263e-01,
    9.89433829713023e-01,
    9.89307544724836e-01,
    9.89180579611485e-01,
    9.89052932683865e-01,
    9.88924602255008e-01,
    9.88795586640115e-01,
    9.88665884156585e-01,
    9.88535493124042e-01,
    9.88404411864364e-01,
    9.88272638701712e-01,
    9.88140171962561e-01,
    9.88007009975729e-01,
    9.87873151072402e-01,
    9.87738593586168e-01,
    9.87603335853044e-01,
    9.87467376211505e-01,
    9.87330713002514e-01,
    9.87193344569554e-01,
    9.87055269258651e-01,
    9.86916485418409e-01,
    9.86776991400039e-01,
    9.86636785557386e-01,
    9.86495866246959e-01,
    9.86354231827965e-01,
    9.86211880662333e-01,
    9.86068811114746e-01,
    9.85925021552671e-01,
    9.85780510346392e-01,
    9.85635275869032e-01,
    9.85489316496591e-01,
    9.85342630607971e-01,
    9.85195216585008e-01,
    9.85047072812504e-01,
    9.84898197678251e-01,
    9.84748589573067e-01,
    9.84598246890825e-01,
    9.84447168028481e-01,
    9.84295351386106e-01,
    9.84142795366917e-01,
    9.83989498377304e-01,
    9.83835458826867e-01,
    9.83680675128438e-01,
    9.83525145698117e-01,
    9.83368868955303e-01,
    9.83211843322720e-01,
    9.83054067226452e-01,
    9.82895539095970e-01,
    9.82736257364169e-01,
    9.82576220467389e-01,
    9.82415426845455e-01,
    9.82253874941700e-01,
    9.82091563203004e-01,
    9.81928490079817e-01,
    9.81764654026194e-01,
    9.81600053499827e-01,
    9.81434686962071e-01,
    9.81268552877982e-01,
    9.81101649716340e-01,
    9.80933975949688e-01,
    9.80765530054354e-01,
    9.80596310510494e-01,
    9.80426315802112e-01,
    9.80255544417095e-01,
    9.80083994847247e-01,
    9.79911665588317e-01,
    9.79738555140032e-01,
    9.79564662006126e-01,
    9.79389984694374e-01,
    9.79214521716622e-01,
    9.79038271588817e-01,
    9.78861232831042e-01,
    9.78683403967543e-01,
    9.78504783526764e-01,
    9.78325370041377e-01,
    9.78145162048315e-01,
    9.77964158088797e-01,
    9.77782356708371e-01,
    9.77599756456935e-01,
    9.77416355888775e-01,
    9.77232153562592e-01,
    9.77047148041537e-01,
    9.76861337893244e-01,
    9.76674721689855e-01,
    9.76487298008059e-01,
    9.76299065429118e-01,
    9.76110022538904e-01,
    9.75920167927928e-01,
    9.75729500191369e-01,
    9.75538017929110e-01,
    9.75345719745770e-01,
    9.75152604250732e-01,
    9.74958670058179e-01,
    9.74763915787121e-01,
    9.74568340061432e-01,
    9.74371941509879e-01,
    9.74174718766154e-01,
    9.73976670468907e-01,
    9.73777795261776e-01,
    9.73578091793422e-01,
    9.73377558717557e-01,
    9.73176194692980e-01,
    9.72973998383605e-01,
    9.72770968458498e-01,
    9.72567103591901e-01,
    9.72362402463273e-01,
    9.72156863757318e-01,
    9.71950486164013e-01,
    9.71743268378649e-01,
    9.71535209101853e-01,
    9.71326307039629e-01,
    9.71116560903383e-01,
    9.70905969409960e-01,
    9.70694531281673e-01,
    9.70482245246337e-01,
    9.70269110037298e-01,
    9.70055124393470e-01,
    9.69840287059363e-01,
    9.69624596785115e-01,
    9.69408052326527e-01,
    9.69190652445093e-01,
    9.68972395908034e-01,
    9.68753281488324e-01,
    9.68533307964732e-01,
    9.68312474121845e-01,
    9.68090778750105e-01,
    9.67868220645841e-01,
    9.67644798611297e-01,
    9.67420511454669e-01,
    9.67195357990135e-01,
    9.66969337037886e-01,
    9.66742447424158e-01,
    9.66514687981268e-01,
    9.66286057547641e-01,
    9.66056554967845e-01,
    9.65826179092620e-01,
    9.65594928778915e-01,
    9.65362802889916e-01,
    9.65129800295078e-01,
    9.64895919870159e-01,
    9.64661160497252e-01,
    9.64425521064813e-01,
    9.64189000467701e-01,
    9.63951597607199e-01,
    9.63713311391055e-01,
    9.63474140733511e-01,
    9.63234084555333e-01,
    9.62993141783845e-01,
    9.62751311352963e-01,
    9.62508592203219e-01,
    9.62264983281802e-01,
    9.62020483542584e-01,
    9.61775091946154e-01,
    9.61528807459852e-01,
    9.61281629057792e-01,
    9.61033555720906e-01,
    9.60784586436967e-01,
    9.60534720200624e-01,
    9.60283956013432e-01,
    9.60032292883885e-01,
    9.59779729827449e-01,
    9.59526265866590e-01,
    9.59271900030808e-01,
    9.59016631356668e-01,
    9.58760458887832e-01,
    9.58503381675091e-01,
    9.58245398776394e-01,
    9.57986509256882e-01,
    9.57726712188918e-01,
    9.57466006652119e-01,
    9.57204391733388e-01,
    9.56941866526946e-01,
    9.56678430134358e-01,
    9.56414081664572e-01,
    9.56148820233945e-01,
    9.55882644966277e-01,
    9.55615554992839e-01,
    9.55347549452408e-01,
    9.55078627491295e-01,
    9.54808788263379e-01,
    9.54538030930135e-01,
    9.54266354660667e-01,
    9.53993758631740e-01,
    9.53720242027805e-01,
    9.53445804041040e-01,
    9.53170443871372e-01,
    9.52894160726511e-01,
    9.52616953821983e-01,
    9.52338822381156e-01,
    9.52059765635275e-01,
    9.51779782823491e-01,
    9.51498873192891e-01,
    9.51217035998531e-01,
    9.50934270503462e-01,
    9.50650575978766e-01,
    9.50365951703582e-01,
    9.50080396965140e-01,
    9.49793911058788e-01,
    9.49506493288025e-01,
    9.49218142964529e-01,
    9.48928859408191e-01,
    9.48638641947140e-01,
    9.48347489917776e-01,
    9.48055402664802e-01,
    9.47762379541251e-01,
    9.47468419908514e-01,
    9.47173523136378e-01,
    9.46877688603046e-01,
    9.46580915695175e-01,
    9.46283203807900e-01,
    9.45984552344868e-01,
    9.45684960718263e-01,
    9.45384428348841e-01,
    9.45082954665955e-01,
    9.44780539107588e-01,
    9.44477181120380e-01,
    9.44172880159657e-01,
    9.43867635689463e-01,
    9.43561447182588e-01,
    9.43254314120596e-01,
    9.42946235993856e-01,
    9.42637212301568e-01,
    9.42327242551797e-01,
    9.42016326261498e-01,
    9.41704462956546e-01,
    9.41391652171765e-01,
    9.41077893450955e-01,
    9.40763186346925e-01,
    9.40447530421518e-01,
    9.40130925245639e-01,
    9.39813370399288e-01,
    9.39494865471582e-01,
    9.39175410060789e-01,
    9.38855003774354e-01,
    9.38533646228926e-01,
    9.38211337050389e-01,
    9.37888075873887e-01,
    9.37563862343854e-01,
    9.37238696114041e-01,
    9.36912576847547e-01,
    9.36585504216841e-01,
    9.36257477903792e-01,
    9.35928497599701e-01,
    9.35598563005322e-01,
    9.35267673830894e-01,
    9.34935829796166e-01,
    9.34603030630425e-01,
    9.34269276072523e-01,
    9.33934565870906e-01,
    9.33598899783638e-01,
    9.33262277578432e-01,
    9.32924699032671e-01,
    9.32586163933440e-01,
    9.32246672077552e-01,
    9.31906223271573e-01,
    9.31564817331849e-01,
    9.31222454084533e-01,
    9.30879133365611e-01,
    9.30534855020929e-01,
    9.30189618906218e-01,
    9.29843424887122e-01,
    9.29496272839223e-01,
    9.29148162648064e-01,
    9.28799094209183e-01,
    9.28449067428129e-01,
    9.28098082220495e-01,
    9.27746138511938e-01,
    9.27393236238211e-01,
    9.27039375345183e-01,
    9.26684555788866e-01,
    9.26328777535440e-01,
    9.25972040561280e-01,
    9.25614344852978e-01,
    9.25255690407369e-01,
    9.24896077231560e-01,
    9.24535505342946e-01,
    9.24173974769242e-01,
    9.23811485548507e-01,
    9.23448037729164e-01,
    9.23083631370027e-01,
    9.22718266540328e-01,
    9.22351943319735e-01,
    9.21984661798381e-01,
    9.21616422076887e-01,
    9.21247224266385e-01,
    9.20877068488540e-01,
    9.20505954875576e-01,
    9.20133883570302e-01,
    9.19760854726129e-01,
    9.19386868507099e-01,
    9.19011925087903e-01,
    9.18636024653911e-01,
    9.18259167401186e-01,
    9.17881353536518e-01,
    9.17502583277433e-01,
    9.17122856852230e-01,
    9.16742174499993e-01,
    9.16360536470617e-01,
    9.15977943024833e-01,
    9.15594394434225e-01,
    9.15209890981255e-01,
    9.14824432959286e-01,
    9.14438020672601e-01,
    9.14050654436426e-01,
    9.13662334576953e-01,
    9.13273061431359e-01,
    9.12882835347830e-01,
    9.12491656685578e-01,
    9.12099525814868e-01,
    9.11706443117033e-01,
    9.11312408984501e-01,
    9.10917423820811e-01,
    9.10521488040633e-01,
    9.10124602069795e-01,
    9.09726766345295e-01,
    9.09327981315328e-01,
    9.08928247439303e-01,
    9.08527565187861e-01,
    9.08125935042900e-01,
    9.07723357497592e-01,
    9.07319833056402e-01,
    9.06915362235107e-01,
    9.06509945560818e-01,
    9.06103583571999e-01,
    9.05696276818481e-01,
    9.05288025861490e-01,
    9.04878831273655e-01,
    9.04468693639037e-01,
    9.04057613553142e-01,
    9.03645591622938e-01,
    9.03232628466879e-01,
    9.02818724714917e-01,
    9.02403881008525e-01,
    9.01988098000712e-01,
    9.01571376356042e-01,
    9.01153716750651e-01,
    9.00735119872263e-01,
    9.00315586420213e-01,
    8.99895117105456e-01,
    8.99473712650591e-01,
    8.99051373789874e-01,
    8.98628101269237e-01,
    8.98203895846303e-01,
    8.97778758290402e-01,
    8.97352689382591e-01,
    8.96925689915666e-01,
    8.96497760694181e-01,
    8.96068902534461e-01,
    8.95639116264620e-01,
    8.95208402724578e-01,
    8.94776762766072e-01,
    8.94344197252675e-01,
    8.93910707059811e-01,
    8.93476293074766e-01,
    8.93040956196711e-01,
    8.92604697336709e-01,
    8.92167517417730e-01,
    8.91729417374672e-01,
    8.91290398154369e-01,
    8.90850460715607e-01,
    8.90409606029140e-01,
    8.89967835077700e-01,
    8.89525148856012e-01,
    8.89081548370812e-01,
    8.88637034640852e-01,
    8.88191608696921e-01,
    8.87745271581854e-01,
    8.87298024350545e-01,
    8.86849868069961e-01,
    8.86400803819153e-01,
    8.85950832689272e-01,
    8.85499955783576e-01,
    8.85048174217445e-01,
    8.84595489118395e-01,
    8.84141901626085e-01,
    8.83687412892333e-01,
    8.83232024081124e-01,
    8.82775736368624e-01,
    8.82318550943189e-01,
    8.81860469005378e-01,
    8.81401491767963e-01,
    8.80941620455936e-01,
    8.80480856306528e-01,
    8.80019200569212e-01,
    8.79556654505713e-01,
    8.79093219390023e-01,
    8.78628896508408e-01,
    8.78163687159416e-01,
    8.77697592653890e-01,
    8.77230614314974e-01,
    8.76762753478124e-01,
    8.76294011491118e-01,
    8.75824389714060e-01,
    8.75353889519396e-01,
    8.74882512291916e-01,
    8.74410259428764e-01,
    8.73937132339449e-01,
    8.73463132445849e-01,
    8.72988261182222e-01,
    8.72512519995209e-01,
    8.72035910343847e-01,
    8.71558433699574e-01,
    8.71080091546234e-01,
    8.70600885380087e-01,
    8.70120816709812e-01,
    8.69639887056518e-01,
    8.69158097953748e-01,
    8.68675450947485e-01,
    8.68191947596157e-01,
    8.67707589470646e-01,
    8.67222378154290e-01,
    8.66736315242890e-01,
    8.66249402344719e-01,
    8.65761641080520e-01,
    8.65273033083514e-01,
    8.64783579999408e-01,
    8.64293283486395e-01,
    8.63802145215159e-01,
    8.63310166868883e-01,
    8.62817350143247e-01,
    8.62323696746438e-01,
    8.61829208399148e-01,
    8.61333886834583e-01,
    8.60837733798460e-01,
    8.60340751049016e-01,
    8.59842940357008e-01,
    8.59344303505713e-01,
    8.58844842290937e-01,
    8.58344558521012e-01,
    8.57843454016801e-01,
    8.57341530611699e-01,
    8.56838790151632e-01,
    8.56335234495064e-01,
    8.55830865512994e-01,
    8.55325685088960e-01,
    8.54819695119037e-01,
    8.54312897511841e-01,
    8.53805294188526e-01,
    8.53296887082791e-01,
    8.52787678140871e-01,
    8.52277669321544e-01,
    8.51766862596128e-01,
    8.51255259948481e-01,
    8.50742863375003e-01,
    8.50229674884629e-01,
    8.49715696498836e-01,
    8.49200930251636e-01,
    8.48685378189575e-01,
    8.48169042371737e-01,
    8.47651924869736e-01,
    8.47134027767716e-01,
    8.46615353162351e-01,
    8.46095903162840e-01,
    8.45575679890903e-01,
    8.45054685480787e-01,
    8.44532922079251e-01,
    8.44010391845573e-01,
    8.43487096951539e-01,
    8.42963039581447e-01,
    8.42438221932095e-01,
    8.41912646212785e-01,
    8.41386314645314e-01,
    8.40859229463970e-01,
    8.40331392915531e-01,
    8.39802807259255e-01,
    8.39273474766881e-01,
    8.38743397722619e-01,
    8.38212578423147e-01,
    8.37681019177606e-01,
    8.37148722307590e-01,
    8.36615690147150e-01,
    8.36081925042773e-01,
    8.35547429353392e-01,
    8.35012205450367e-01,
    8.34476255717484e-01,
    8.33939582550946e-01,
    8.33402188359369e-01,
    8.32864075563770e-01,
    8.32325246597563e-01,
    8.31785703906551e-01,
    8.31245449948917e-01,
    8.30704487195215e-01,
    8.30162818128362e-01,
    8.29620445243633e-01,
    8.29077371048648e-01,
    8.28533598063365e-01,
    8.27989128820067e-01,
    8.27443965863361e-01,
    8.26898111750160e-01,
    8.26351569049677e-01,
    8.25804340343416e-01,
    8.25256428225157e-01,
    8.24707835300952e-01,
    8.24158564189110e-01,
    8.23608617520188e-01,
    8.23057997936977e-01,
    8.22506708094495e-01,
    8.21954750659976e-01,
    8.21402128312850e-01,
    8.20848843744741e-01,
    8.20294899659451e-01,
    8.19740298772947e-01,
    8.19185043813347e-01,
    8.18629137520914e-01,
    8.18072582648033e-01,
    8.17515381959209e-01,
    8.16957538231043e-01,
    8.16399054252225e-01,
    8.15839932823521e-01,
    8.15280176757754e-01,
    8.14719788879792e-01,
    8.14158772026536e-01,
    8.13597129046903e-01,
    8.13034862801811e-01,
    8.12471976164165e-01,
    8.11908472018841e-01,
    8.11344353262670e-01,
    8.10779622804426e-01,
    8.10214283564803e-01,
    8.09648338476408e-01,
    8.09081790483736e-01,
    8.08514642543159e-01,
    8.07946897622908e-01,
    8.07378558703055e-01,
    8.06809628775496e-01,
    8.06240110843935e-01,
    8.05670007923867e-01,
    8.05099323042555e-01,
    8.04528059239020e-01,
    8.03956219564015e-01,
    8.03383807080012e-01,
    8.02810824861181e-01,
    8.02237275993372e-01,
    8.01663163574097e-01,
    8.01088490712505e-01,
    8.00513260529370e-01,
    7.99937476157069e-01,
    7.99361140739559e-01,
    7.98784257432359e-01,
    7.98206829402530e-01,
    7.97628859828657e-01,
    7.97050351900820e-01,
    7.96471308820583e-01,
    7.95891733800965e-01,
    7.95311630066425e-01,
    7.94731000852834e-01,
    7.94149849407459e-01,
    7.93568178988935e-01,
    7.92985992867250e-01,
    7.92403294323716e-01,
    7.91820086650948e-01,
    7.91236373152845e-01,
    7.90652157144561e-01,
    7.90067441952487e-01,
    7.89482230914223e-01,
    7.88896527378558e-01,
    7.88310334705442e-01,
    7.87723656265966e-01,
    7.87136495442336e-01,
    7.86548855627846e-01,
    7.85960740226858e-01,
    7.85372152654774e-01,
    7.84783096338007e-01,
    7.84193574713967e-01,
    7.83603591231021e-01,
    7.83013149348478e-01,
    7.82422252536558e-01,
    7.81830904276368e-01,
    7.81239108059873e-01,
    7.80646867389871e-01,
    7.80054185779965e-01,
    7.79461066754538e-01,
    7.78867513848722e-01,
    7.78273530608377e-01,
    7.77679120590054e-01,
    7.77084287360974e-01,
    7.76489034498999e-01,
    7.75893365592600e-01,
    7.75297284240832e-01,
    7.74700794053306e-01,
    7.74103898650153e-01,
    7.73506601662006e-01,
    7.72908906729958e-01,
    7.72310817505544e-01,
    7.71712337650702e-01,
    7.71113470837749e-01,
    7.70514220749349e-01,
    7.69914591078478e-01,
    7.69314585528403e-01,
    7.68714207812641e-01,
    7.68113461654935e-01,
    7.67512350789218e-01,
    7.66910878959586e-01,
    7.66309049920262e-01,
    7.65706867435567e-01,
    7.65104335279884e-01,
    7.64501457237634e-01,
    7.63898237103232e-01,
    7.63294678681063e-01,
    7.62690785785448e-01,
    7.62086562240605e-01,
    7.61482011880622e-01,
    7.60877138549422e-01,
    7.60271946100727e-01,
    7.59666438398026e-01,
    7.59060619314539e-01,
    7.58454492733185e-01,
    7.57848062546548e-01,
    7.57241332656837e-01,
    7.56634306975857e-01,
    7.56026989424970e-01,
    7.55419383935062e-01,
    7.54811494446506e-01,
    7.54203324909127e-01,
    7.53594879282164e-01,
    7.52986161534238e-01,
    7.52377175643310e-01,
    7.51767925596651e-01,
    7.51158415390799e-01,
    7.50548649031525e-01,
    7.49938630533796e-01,
    7.49328363921738e-01,
    7.48717853228597e-01,
    7.48107102496699e-01,
    7.47496115777420e-01,
    7.46884897131138e-01,
    7.46273450627202e-01,
    7.45661780343890e-01,
    7.45049890368370e-01,
    7.44437784796664e-01,
    7.43825467733606e-01,
    7.43212943292801e-01,
    7.42600215596593e-01,
    7.41987288776015e-01,
    7.41374166970759e-01,
    7.40760854329129e-01,
    7.40147355008002e-01,
    7.39533673172790e-01,
    7.38919812997398e-01,
    7.38305778664182e-01,
    7.37691574363909e-01,
    7.37077204295716e-01,
    7.36462672667068e-01,
    7.35847983693716e-01,
    7.35233141599656e-01,
    7.34618150617088e-01,
    7.34003014986370e-01,
    7.33387738955980e-01,
    7.32772326782471e-01,
    7.32156782730429e-01,
    7.31541111072430e-01,
    7.30925316088996e-01,
    7.30309402068553e-01,
    7.29693373307387e-01,
    7.29077234109600e-01,
    7.28460988787067e-01,
    7.27844641659390e-01,
    7.27228197053857e-01,
    7.26611659305394e-01,
    7.25995032756524e-01,
    7.25378321757318e-01,
    7.24761530665356e-01,
    7.24144663845676e-01,
    7.23527725670729e-01,
    7.22910720520340e-01,
    7.22293652781656e-01,
    7.21676526849101e-01,
    7.21059347124333e-01,
    7.20442118016195e-01,
    7.19824843940668e-01,
    7.19207529320830e-01,
    7.18590178586800e-01,
    7.17972796175703e-01,
    7.17355386531609e-01,
    7.16737954105499e-01,
    7.16120503355210e-01,
    7.15503038745388e-01,
    7.14885564747443e-01,
    7.14268085839498e-01,
    7.13650606506344e-01,
    7.13033131239391e-01,
    7.12415664536615e-01,
    7.11798210902519e-01,
    7.11180774848072e-01,
    7.10563360890673e-01,
    7.09945973554092e-01,
    7.09328617368423e-01,
    7.08711296870040e-01,
    7.08094016601541e-01,
    7.07476781111700e-01,
    7.06859594955418e-01,
    7.06242462693675e-01,
    7.05625388893476e-01,
    7.05008378127800e-01,
    7.04391434975555e-01,
    7.03774564021522e-01,
    7.03157769856306e-01,
    7.02541057076287e-01,
    7.01924430283563e-01,
    7.01307894085908e-01,
    7.00691453096710e-01,
    7.00075111934929e-01,
    6.99458875225036e-01,
    6.98842747596970e-01,
    6.98226733686079e-01,
    6.97610838133072e-01,
    6.96995065583965e-01,
    6.96379420690029e-01,
    6.95763908107734e-01,
    6.95148532498704e-01,
    6.94533298529654e-01,
    6.93918210872346e-01,
    6.93303274203531e-01,
    6.92688493204893e-01,
    6.92073872563004e-01,
    6.91459416969261e-01,
    6.90845131119838e-01,
    6.90231019715631e-01,
    6.89617087462200e-01,
    6.89003339069722e-01,
    6.88389779252930e-01,
    6.87776412731061e-01,
    6.87163244227802e-01,
    6.86550278471234e-01,
    6.85937520193777e-01,
    6.85324974132138e-01,
    6.84712645027249e-01,
    6.84100537624219e-01,
    6.83488656672275e-01,
    6.82877006924705e-01,
    6.82265593138805e-01,
    6.81654420075823e-01,
    6.81043492500901e-01,
    6.80432815183019e-01,
    6.79822392894942e-01,
    6.79212230413159e-01,
    6.78602332517830e-01,
    6.77992703992728e-01,
    6.77383349625182e-01,
    6.76774274206021e-01,
    6.76165482529514e-01,
    6.75556979393319e-01,
    6.74948769598420e-01,
    6.74340857949070e-01,
    6.73733249252739e-01,
    6.73125948320048e-01,
    6.72518959964719e-01,
    6.71912289003514e-01,
    6.71305940256173e-01,
    6.70699918545365e-01,
    6.70094228696621e-01,
    6.69488875538281e-01,
    6.68883863901433e-01,
    6.68279198619855e-01,
    6.67674884529959e-01,
    6.67070926470727e-01,
    6.66467329283657e-01,
    6.65864097812702e-01,
    6.65261236904209e-01,
    6.64658751406865e-01,
    6.64056646171632e-01,
    6.63454926051691e-01,
    6.62853595902383e-01,
    6.62252660581145e-01,
    6.61652124947457e-01,
    6.61051993862775e-01,
    6.60452272190478e-01,
    6.59852964795802e-01,
    6.59254076545784e-01,
    6.58655612309200e-01,
    6.58057576956506e-01,
    6.57459975359775e-01,
    6.56862812392640e-01,
    6.56266092930230e-01,
    6.55669821849113e-01,
    6.55074004027231e-01,
    6.54478644343844e-01,
    6.53883747679464e-01,
    6.53289318915799e-01,
    6.52695362935688e-01,
    6.52101884623041e-01,
    6.51508888862779e-01,
    6.50916380540771e-01,
    6.50324364543772e-01,
    6.49732845759367e-01,
    6.49141829075899e-01,
    6.48551319382419e-01,
    6.47961321568616e-01,
    6.47371840524757e-01,
    6.46782881141627e-01,
    6.46194448310467e-01,
    6.45606546922910e-01,
    6.45019181870919e-01,
    6.44432358046727e-01,
    6.43846080342773e-01,
    6.43260353651639e-01,
    6.42675182865990e-01,
    6.42090572878508e-01,
    6.41506528581835e-01,
    6.40923054868504e-01,
    6.40340156630879e-01,
    6.39757838761095e-01,
    6.39176106150992e-01,
    6.38594963692051e-01,
    6.38014416275335e-01,
    6.37434468791423e-01,
    6.36855126130349e-01,
    6.36276393181536e-01,
    6.35698274833737e-01,
    6.35120775974967e-01,
    6.34543901492444e-01,
    6.33967656272523e-01,
    6.33392045200635e-01,
    6.32817073161220e-01,
    6.32242745037666e-01,
    6.31669065712247e-01,
    6.31096040066056e-01,
    6.30523672978944e-01,
    6.29951969329453e-01,
    6.29380933994756e-01,
    6.28810571850594e-01,
    6.28240887771207e-01,
    6.27671886629274e-01,
    6.27103573295849e-01,
    6.26535952640297e-01,
    6.25969029530226e-01,
    6.25402808831432e-01,
    6.24837295407825e-01,
    6.24272494121371e-01,
    6.23708409832028e-01,
    6.23145047397678e-01,
    6.22582411674065e-01,
    6.22020507514733e-01,
    6.21459339770958e-01,
    6.20898913291687e-01,
    6.20339232923469e-01,
    6.19780303510399e-01,
    6.19222129894044e-01,
    6.18664716913385e-01,
    6.18108069404753e-01,
    6.17552192201759e-01,
    6.16997090135235e-01,
    6.16442768033168e-01,
    6.15889230720635e-01,
    6.15336483019739e-01,
    6.14784529749543e-01,
    6.14233375726009e-01,
    6.13683025761931e-01,
    6.13133484666870e-01,
    6.12584757247090e-01,
    6.12036848305496e-01,
    6.11489762641566e-01,
    6.10943505051287e-01,
    6.10398080327094e-01,
    6.09853493257799e-01,
    6.09309748628534e-01,
    6.08766851220679e-01,
    6.08224805811803e-01,
    6.07683617175598e-01,
    6.07143290081814e-01,
    6.06603829296191e-01,
    6.06065239580402e-01,
    6.05527525691983e-01,
    6.04990692384268e-01,
    6.04454744406328e-01,
    6.03919686502904e-01,
    6.03385523414344e-01,
    6.02852259876537e-01,
    6.02319900620848e-01,
    6.01788450374055e-01,
    6.01257913858287e-01,
    6.00728295790952e-01,
    6.00199600884681e-01,
    5.99671833847259e-01,
    5.99144999381560e-01,
    5.98619102185485e-01,
    5.98094146951897e-01,
    5.97570138368555e-01,
    5.97047081118053e-01,
    5.96524979877752e-01,
    5.96003839319717e-01,
    5.95483664110655e-01,
    5.94964458911849e-01,
    5.94446228379090e-01,
    5.93928977162622e-01,
    5.93412709907068e-01,
    5.92897431251373e-01,
    5.92383145828735e-01,
    5.91869858266546e-01,
    5.91357573186323e-01,
    5.90846295203647e-01,
    5.90336028928099e-01,
    5.89826778963194e-01,
    5.89318549906321e-01,
    5.88811346348674e-01,
    5.88305172875192e-01,
    5.87800034064496e-01,
    5.87295934488822e-01,
    5.86792878713959e-01,
    5.86290871299188e-01,
    5.85789916797211e-01,
    5.85290019754098e-01,
    5.84791184709214e-01,
    5.84293416195161e-01,
    5.83796718737715e-01,
    5.83301096855759e-01,
    5.82806555061223e-01,
    5.82313097859018e-01,
    5.81820729746978e-01,
    5.81329455215789e-01,
    5.80839278748936e-01,
    5.80350204822630e-01,
    5.79862237905752e-01,
    5.79375382459789e-01,
    5.78889642938768e-01,
    5.78405023789197e-01,
    5.77921529450002e-01,
    5.77439164352461e-01,
    5.76957932920147e-01,
    5.76477839568862e-01,
    5.75998888706574e-01,
    5.75521084733357e-01,
    5.75044432041329e-01,
    5.74568935014588e-01,
    5.74094598029150e-01,
    5.73621425452891e-01,
    5.73149421645480e-01,
    5.72678590958319e-01,
    5.72208937734483e-01,
    5.71740466308657e-01,
    5.71273181007073e-01,
    5.70807086147453e-01,
    5.70342186038942e-01,
    5.69878484982051e-01,
    5.69415987268594e-01,
    5.68954697181628e-01,
    5.68494618995390e-01,
    5.68035756975238e-01,
    5.67578115377590e-01,
    5.67121698449863e-01,
    5.66666510430409e-01,
    5.66212555548463e-01,
    5.65759838024074e-01,
    5.65308362068047e-01,
    5.64858131881886e-01,
    5.64409151657732e-01,
    5.63961425578300e-01,
    5.63514957816824e-01,
    5.63069752536992e-01,
    5.62625813892892e-01,
    5.62183146028948e-01,
    5.61741753079863e-01,
    5.61301639170557e-01,
    5.60862808416111e-01,
    5.60425264921704e-01,
    5.59989012782558e-01,
    5.59554056083877e-01,
    5.59120398900788e-01,
    5.58688045298282e-01,
    5.58256999331156e-01,
    5.57827265043955e-01,
    5.57398846470915e-01,
    5.56971747635899e-01,
    5.56545972552345e-01,
    5.56121525223207e-01,
    5.55698409640893e-01,
    5.55276629787213e-01,
    5.54856189633317e-01,
    5.54437093139639e-01,
    5.54019344255841e-01,
    5.53602946920753e-01,
    5.53187905062319e-01,
    5.52774222597536e-01,
    5.52361903432402e-01,
    5.51950951461856e-01,
    5.51541370569720e-01,
    5.51133164628649e-01,
    5.50726337500068e-01,
    5.50320893034118e-01,
    5.49916835069602e-01,
    5.49514167433926e-01,
    5.49112893943044e-01,
    5.48713018401406e-01,
    5.48314544601898e-01,
    5.47917476325787e-01,
    5.47521817342670e-01,
    5.47127571410412e-01,
    5.46734742275100e-01,
    5.46343333670981e-01,
    5.45953349320409e-01,
    5.45564792933794e-01,
    5.45177668209543e-01,
    5.44791978834010e-01,
    5.44407728481439e-01,
    5.44024920813911e-01,
    5.43643559481292e-01,
    5.43263648121177e-01,
    5.42885190358838e-01,
    5.42508189807172e-01,
    5.42132650066645e-01,
    5.41758574725241e-01,
    5.41385967358409e-01,
    5.41014831529012e-01,
    5.40645170787272e-01,
    5.40276988670718e-01,
    5.39910288704137e-01,
    5.39545074399519e-01,
    5.39181349256006e-01,
    5.38819116759840e-01,
    5.38458380384316e-01,
    5.38099143589723e-01,
    5.37741409823299e-01,
    5.37385182519179e-01,
    5.37030465098343e-01,
    5.36677260968566e-01,
    5.36325573524368e-01,
    5.35975406146965e-01,
    5.35626762204216e-01,
    5.35279645050575e-01,
    5.34934058027042e-01,
    5.34590004461114e-01,
    5.34247487666733e-01,
    5.33906510944239e-01,
    5.33567077580321e-01,
    5.33229190847969e-01,
    5.32892854006423e-01,
    5.32558070301127e-01,
    5.32224842963680e-01,
    5.31893175211788e-01,
    5.31563070249218e-01,
    5.31234531265746e-01,
    5.30907561437114e-01,
    5.30582163924983e-01,
    5.30258341876881e-01,
    5.29936098426162e-01,
    5.29615436691957e-01,
    5.29296359779125e-01,
    5.28978870778212e-01,
    5.28662972765402e-01,
    5.28348668802471e-01,
    5.28035961936742e-01,
    5.27724855201039e-01,
    5.27415351613643e-01,
    5.27107454178248e-01,
    5.26801165883911e-01,
    5.26496489705014e-01,
    5.26193428601216e-01,
    5.25891985517408e-01,
    5.25592163383672e-01,
    5.25293965115236e-01,
    5.24997393612428e-01,
    5.24702451760637e-01,
    5.24409142430266e-01,
    5.24117468476693e-01,
    5.23827432740224e-01,
    5.23539038046053e-01,
    5.23252287204219e-01,
    5.22967183009567e-01,
    5.22683728241700e-01,
    5.22401925664941e-01,
    5.22121778028293e-01,
    5.21843288065395e-01,
    5.21566458494484e-01,
    5.21291292018349e-01,
    5.21017791324296e-01,
    5.20745959084106e-01,
    5.20475797953994e-01,
    5.20207310574569e-01,
    5.19940499570794e-01,
    5.19675367551950e-01,
    5.19411917111594e-01,
    5.19150150827517e-01,
    5.18890071261712e-01,
    5.18631680960332e-01,
    5.18374982453649e-01,
    5.18119978256022e-01,
    5.17866670865855e-01,
    5.17615062765558e-01,
    5.17365156421514e-01,
    5.17116954284040e-01,
    5.16870458787350e-01,
    5.16625672349516e-01,
    5.16382597372437e-01,
    5.16141236241798e-01,
    5.15901591327035e-01,
    5.15663664981300e-01,
    5.15427459541428e-01,
    5.15192977327895e-01,
    5.14960220644791e-01,
    5.14729191779780e-01,
    5.14499893004066e-01,
    5.14272326572360e-01,
    5.14046494722846e-01,
    5.13822399677147e-01,
    5.13600043640290e-01,
    5.13379428800676e-01,
    5.13160557330042e-01,
    5.12943431383433e-01,
    5.12728053099166e-01,
    5.12514424598801e-01,
    5.12302547987105e-01,
    5.12092425352022e-01,
    5.11884058764643e-01,
    5.11677450279172e-01,
    5.11472601932897e-01,
    5.11269515746158e-01,
    5.11068193722315e-01,
    5.10868637847722e-01,
    5.10670850091691e-01,
    5.10474832406469e-01,
    5.10280586727202e-01,
    5.10088114971909e-01,
    5.09897419041453e-01,
    5.09708500819511e-01,
    5.09521362172546e-01,
    5.09336004949779e-01,
    5.09152430983160e-01,
    5.08970642087341e-01,
    5.08790640059649e-01,
    5.08612426680056e-01,
    5.08436003711157e-01,
    5.08261372898137e-01,
    5.08088535968750e-01,
    5.07917494633289e-01,
    5.07748250584562e-01,
    5.07580805497866e-01,
    5.07415161030961e-01,
    5.07251318824045e-01,
    5.07089280499729e-01,
    5.06929047663013e-01,
    5.06770621901261e-01,
    5.06614004784176e-01,
    5.06459197863778e-01,
    5.06306202674380e-01,
    5.06155020732561e-01,
    5.06005653537151e-01,
    5.05858102569200e-01,
    5.05712369291957e-01,
    5.05568455150855e-01,
    5.05426361573477e-01,
    5.05286089969546e-01,
    5.05147641730894e-01,
    5.05011018231448e-01,
    5.04876220827205e-01,
    5.04743250856211e-01,
    5.04612109638545e-01,
    5.04482798476293e-01,
    5.04355318653533e-01,
    5.04229671436312e-01,
    5.04105858072629e-01,
    5.03983879792416e-01,
    5.03863737807518e-01,
    5.03745433311672e-01,
    5.03628967480497e-01,
    5.03514341471466e-01,
    5.03401556423896e-01,
    5.03290613458926e-01,
    5.03181513679504e-01,
    5.03074258170365e-01,
    5.02968847998019e-01,
    5.02865284210733e-01,
    5.02763567838514e-01,
    5.02663699893095e-01,
    5.02565681367920e-01,
    5.02469513238124e-01,
    5.02375196460525e-01,
    5.02282731973607e-01,
    5.02192120697501e-01,
    5.02103363533978e-01,
    5.02016461366430e-01,
    5.01931415059861e-01,
    5.01848225460869e-01,
    5.01766893397635e-01,
    5.01687419679913e-01,
    5.01609805099014e-01,
    5.01534050427795e-01,
    5.01460156420648e-01,
    5.01388123813487e-01,
    5.01317953323740e-01,
    5.01249645650334e-01,
    5.01183201473685e-01,
    5.01118621455690e-01,
    5.01055906239716e-01,
    5.00995056450588e-01,
    5.00936072694582e-01,
    5.00878955559415e-01,
    5.00823705614236e-01,
    5.00770323409617e-01,
    5.00718809477544e-01,
    5.00669164331411e-01,
    5.00621388466009e-01,
    5.00575482357521e-01,
    5.00531446463514e-01,
    5.00489281222933e-01,
    5.00448987056091e-01,
    5.00410564364666e-01,
    5.00374013531693e-01,
    5.00339334921560e-01,
    5.00306528880000e-01,
    5.00275595734087e-01,
    5.00246535792231e-01,
    5.00219349344174e-01,
    5.00194036660982e-01,
    5.00170597995048e-01,
    5.00149033580080e-01,
    5.00129343631103e-01,
    5.00111528344452e-01,
    5.00095587897773e-01,
    5.00081522450018e-01,
    5.00069332141441e-01,
    5.00059017093599e-01,
    5.00050577409347e-01,
    5.00044013172841e-01,
    5.00039324449532e-01,
    5.00036511286166e-01,
];

/// From https://github.com/MWATelescope/cotter/blob/0f99a09cb21721666d2ba328ab2257484b4cd183/subbandpassband.cpp#L58
///
/// "These are subband values coming from an old Levine MWA memo, where they
/// are derived from the poly phase filter coefficients. Nichole Barry mailed
/// me these values: she tested them against the '2013' values above.
/// Initially, these were mirrored, because the 64th sample was unity, instead
/// of the 65th."
#[allow(clippy::excessive_precision)]
pub const PFB_COTTER_2014_10KHZ: &[f64] = &[
    0.5002092286,
    0.5025463233,
    0.5095006003,
    0.5209000511,
    0.5364655027,
    0.5558210624,
    0.578507908,
    0.6040009198,
    0.6317276705,
    0.6610877352,
    0.6914726388,
    0.7222853397,
    0.7529582567,
    0.7829676164,
    0.811847953,
    0.8392006276,
    0.8647014754,
    0.8881031286,
    0.9092359525,
    0.9280049655,
    0.9443854775,
    0.9584152159,
    0.9701859925,
    0.9798348905,
    0.9875338705,
    0.9934801632,
    0.9978861616,
    1.0009717022,
    1.0029560443,
    1.0040506,
    1.0044541097,
    1.0043486497,
    1.0038957138,
    1.0032352887,
    1.0024841158,
    1.0017360425,
    1.0010627468,
    1.0005145298,
    1.0001227353,
    0.9999016844,
    0.9998508036,
    0.9999576333,
    1.0002001147,
    1.0005493174,
    1.0009719327,
    1.0014325423,
    1.0018965935,
    1.0023317792,
    1.0027098934,
    1.003007776,
    1.0032087236,
    1.003302975,
    1.0032879588,
    1.003166914,
    1.0029505018,
    1.0026535597,
    1.0022962373,
    1.0019012075,
    1.001492497,
    1.0010952483,
    1.0007327206,
    1.0004265297,
    1.0001941268,
    1.0000490463,
    1.0,
    1.0000490463,
    1.0001941268,
    1.0004265297,
    1.0007327206,
    1.0010952483,
    1.001492497,
    1.0019012075,
    1.0022962373,
    1.0026535597,
    1.0029505018,
    1.003166914,
    1.0032879588,
    1.003302975,
    1.0032087236,
    1.003007776,
    1.0027098934,
    1.0023317792,
    1.0018965935,
    1.0014325423,
    1.0009719327,
    1.0005493174,
    1.0002001147,
    0.9999576333,
    0.9998508036,
    0.9999016844,
    1.0001227353,
    1.0005145298,
    1.0010627468,
    1.0017360425,
    1.0024841158,
    1.0032352887,
    1.0038957138,
    1.0043486497,
    1.0044541097,
    1.0040506,
    1.0029560443,
    1.0009717022,
    0.9978861616,
    0.9934801632,
    0.9875338705,
    0.9798348905,
    0.9701859925,
    0.9584152159,
    0.9443854775,
    0.9280049655,
    0.9092359525,
    0.8881031286,
    0.8647014754,
    0.8392006276,
    0.811847953,
    0.7829676164,
    0.7529582567,
    0.7222853397,
    0.6914726388,
    0.6610877352,
    0.6317276705,
    0.6040009198,
    0.578507908,
    0.5558210624,
    0.5364655027,
    0.5209000511,
    0.5095006003,
    0.5025463233,
];
