

## Generate non-averaged uvfits and mwaf

```bash
cotter \
  -m /mnt/data/1247842824_vis/1247842824.metafits \
  -o "/mnt/data/1247842824_vis/1247842824.uvfits" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-128ch-unitary.txt \
  -nostats \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits \
  | tee cotter-1247842824_uvfits_mwa.log

cotter \
  -m /mnt/data/1247842824_vis/1247842824.metafits \
  -o "/mnt/data/1247842824_vis/1247842824.mwaf" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-128ch-unitary.txt \
  -nostats \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits \
  | tee cotter-1247842824_uvfits_mwa.log
```

run dump_uvfits and dump_flags (on cc1 only)

```bash
python3 tests/data/dump_uvfits.py /mnt/data/1247842824_vis/1247842824.uvfits \
    --timestep-limit=60 --baseline-limit=3 --chan-limit=128 --dump-mode=weight-only \
    --dump-csv=/mnt/data/1247842824_vis/1247842824.uvfits.weight.csv
python3 tests/data/dump_mwaf.py /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA01.mwaf \
    --timestep-limit=60 --baseline-limit=3 \
    | tee /mnt/data/1247842824_vis/adjusted_-2/FlagfileCotterMWA01.mwaf.txt
```

compare baseline 002:

```txt
-> bl 0001:
 --> ts 0000: ...................................................................................................#............................
 --> ts 0001: .............................##....................................................................#............................
 --> ts 0002: ................................................................................................................................
 --> ts 0003: ...........................#....................#...............................................................................
 --> ts 0004: ................................................................................................................................
 --> ts 0005: ................................................................................................................................
 --> ts 0006: ................................#...............................................................................................
 --> ts 0007: ................................#....................................#.#........................................................
 --> ts 0008: .....................................................................#..........................................................
 --> ts 0009: .............................................................................................#...........#......................
 --> ts 0010: ................................................................#............................#..................................
 --> ts 0011: ..........................................................................................#.....................................
 --> ts 0012: ...........................................................#...#..........................#..............#......................
 --> ts 0013: ...............................................................#.....................#..........................................
 --> ts 0014: ....#..................................#........................................................................................
 --> ts 0015: ....#........................................#..................#...............................................................
 --> ts 0016: ....#........................................##..........................#......................................................
 --> ts 0017: ....#......................#..................#..........................#......................................................
 --> ts 0018: ..............................................#.................................................................................
 --> ts 0019: ..............................................#................##...............................................................
 --> ts 0020: ................................................................................................................................
 --> ts 0021: ................................................................................................................................
 --> ts 0022: ................................................................................................................................
 --> ts 0023: ....#......................................#....................................................................................
 --> ts 0024: ....#...............................................#..........#................................................................
 --> ts 0025: ....#.................#.................................................................................#.......................
 --> ts 0026: ....#...................................................................................................#.......................
 --> ts 0027: ....#........................................................................................#..................................
 --> ts 0028: ....#...........................................................................................................................
 --> ts 0029: .....................#...................##..................................##.................................................
 --> ts 0030: ................................................................................................................................
 --> ts 0031: ................................................................................................................................
 --> ts 0032: .........................................................................................................#......................
 --> ts 0033: ................................................................................................................................
 --> ts 0034: ....#...........................................................................................................................
 --> ts 0035: ....#.......................................#...................................................................................
 --> ts 0036: ....#....................................................#......................................................................
 --> ts 0037: ....#..................................................................................................##.......................
 --> ts 0038: ....#...........................................................................................................................
 --> ts 0039: ....#......................................................#......................................#.............................
 --> ts 0040: ....#....................................##................................................##...................................
 --> ts 0041: ........................................#.......................................................................................
 --> ts 0042: ................................................#...............................................................................
 --> ts 0043: ................................................................................................................................
 --> ts 0044: .....................................................#..........................................................................
 --> ts 0045: .............................................................#..................................................................
 --> ts 0046: .............................................................#..#.................................#.............................
 --> ts 0047: ................................................................#.........................................##....................
 --> ts 0048: ................................................................................................................................
 --> ts 0049: ................................................................................................................#...............
 --> ts 0050: ................................................................................................................................
 --> ts 0051: ................................................................................................................................
 --> ts 0052: ............................................................................................................##..................
 --> ts 0053: .......................................................#........................#...............................................
 --> ts 0054: ................................................................................................................................
 --> ts 0055: ...................................................................................#............................................
```

```
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.125,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
2458687.126,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

```

now do some averaging

```bash
cotter \
  -m /mnt/data/1247842824_vis/1247842824.metafits \
  -o "/mnt/data/1247842824_vis/1247842824_avg_2s_20kHz.uvfits" \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-128ch-unitary.txt \
  -nostats \
  -timeres 2 \
  -freqres 20 \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits
```

```txt
Running Cotter MWA preprocessing pipeline, version 4.5 (2020-08-10).
Flagging is performed by AOFlagger 3.1 (2021-03-03).
Input filenames succesfully parsed: using 24 files covering 1 timeranges from 24 GPU boxes.
Detected 62.8 GB of system memory.
Ignored keyword: ATTEN_DB
Ignored keyword: CALIBSRC
Ignored keyword: CHANSEL
Ignored keyword: INSTRUME
Ignored keyword: QUACKTIM
Ignored keyword: GOODTIME
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: HISTORY
Ignored keyword: HISTORY
Ignored keyword: HISTORY
Observation covers 132.48-163.19 MHz.
Output resolution: 2 s / 20 kHz (time avg: 2x, freq avg: 2x).
The first 0 samples (0 s), last 0 samples (0 s) and 0 edge channels will be flagged.
Read subband passband, using 128 gains to correct for 24 subbands.
Using per-input subband gains. Average gains: 1.21216,1.18396,1.16772,1.14526,1.14258,1.13733,1.13586,1.1344,1.12866,1.11157,1.08911,1.0708,1.04919,1.03931,1.02917,1.03406,1.03662,1.03528,1.0332,1.02271,1.01282,1.00232,0.997559,1
Subband order: 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23
Observation's bandwidth is contiguous.
Antenna positions are written in LOCAL MERIDIAN
Observation does not fit fully in memory, will partition data in 2 chunks of at least 60 scans.
=== Processing chunk 1 of 2 ===
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits
Will stop on HDU 61.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
WARNING: start time according to raw files is 2019-07-22 15:00:07,
but meta files say 2019-07-22 15:00:06 !
Will use start time from raw file, which should be most accurate.
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
=== Processing chunk 2 of 2 ===
Warning: header specifies 120 scans, but there are only 60 in the data.
Last 60 scan(s) will be flagged.
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing MWA fields to UVFits file...
Wall-clock time in reading: 00:09:36.921397 processing: 00:03:01.096009 writing: 00:05:44.881402
```

dump with

```bash
python3 tests/data/dump_uvfits.py /mnt/data/1247842824_vis/1247842824_avg_2_20.uvfits \
    --timestep-limit=30 --baseline-limit=3 --chan-limit=64  --dump-mode=weight-only \
    --dump-csv=/mnt/data/1247842824_vis/1247842824_avg_2s_20kHz.uvfits.weight.csv
```

```csv
timestep, baseline, pol, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63
2458687.125092596, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125115752, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125138879, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125162035, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1251851916, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1252083182, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1252314746, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125254631, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1252777874, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125300914, 258.0, xx, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1253240705, 258.0, xx, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125347227, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1253703833, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.12539351, 258.0, xx, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1254166663, 258.0, xx, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1254398227, 258.0, xx, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1254629493, 258.0, xx, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1254861057, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125509262, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1255324185, 258.0, xx, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125555545, 258.0, xx, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1255787015, 258.0, xx, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125601858, 258.0, xx, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 2.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1256250143, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125648141, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1256712973, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1256944537, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1257175803, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.1257407367, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
2458687.125763893, 258.0, xx, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0
```

what if we flag some stuff ourselves

```bash
cotter \
  -m /mnt/data/1247842824_vis/1247842824.metafits \
  -o "/mnt/data/1247842824_vis/1247842824_avg_2s_20kHz_flags.uvfits" \
  -allowmissing \
  -noantennapruning \
  -nocablelength \
  -nogeom \
  -sbpassband tests/data/subband-passband-128ch-unitary.txt \
  -nostats \
  -timeres 2 \
  -freqres 20 \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits \
  /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits
```

```txt
Running Cotter MWA preprocessing pipeline, version 4.5 (2020-08-10).
Flagging is performed by AOFlagger 3.1 (2021-03-03).
Input filenames succesfully parsed: using 24 files covering 1 timeranges from 24 GPU boxes.
Detected 62.8 GB of system memory.
Ignored keyword: ATTEN_DB
Ignored keyword: CALIBSRC
Ignored keyword: CHANSEL
Ignored keyword: INSTRUME
Ignored keyword: QUACKTIM
Ignored keyword: GOODTIME
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: COMMENT
Ignored keyword: HISTORY
Ignored keyword: HISTORY
Ignored keyword: HISTORY
Observation covers 132.48-163.19 MHz.
Output resolution: 2 s / 20 kHz (time avg: 2x, freq avg: 2x).
The first 4 samples (4 s), last 0 samples (0 s) and 8 edge channels will be flagged.
Read subband passband, using 128 gains to correct for 24 subbands.
Using per-input subband gains. Average gains: 1.21216,1.18396,1.16772,1.14526,1.14258,1.13733,1.13586,1.1344,1.12866,1.11157,1.08911,1.0708,1.04919,1.03931,1.02917,1.03406,1.03662,1.03528,1.0332,1.02271,1.01282,1.00232,0.997559,1
Subband order: 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23
Observation's bandwidth is contiguous.
Antenna positions are written in LOCAL MERIDIAN
Observation does not fit fully in memory, will partition data in 2 chunks of at least 60 scans.
=== Processing chunk 1 of 2 ===
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox01_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox02_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox03_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox04_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox05_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox06_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox07_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox08_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox09_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox10_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox11_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox12_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox13_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox14_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox15_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox16_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox17_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox18_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox19_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox20_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox21_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox22_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox23_00.fits
There are 61 HDUs in file /mnt/data/1247842824_vis/1247842824_20190722150008_gpubox24_00.fits
Will stop on HDU 61.
Reading GPU files: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
WARNING: start time according to raw files is 2019-07-22 15:00:07,
but meta files say 2019-07-22 15:00:06 !
Will use start time from raw file, which should be most accurate.
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
=== Processing chunk 2 of 2 ===
Warning: header specifies 120 scans, but there are only 60 in the data.
Last 60 scan(s) will be flagged.
RFI detection, conjugations, subband ordering and cable length corrections:
 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing: 0%....10%....20%....30%....40%....50%....60%....70%....80%....90%....100%
Writing MWA fields to UVFits file...
Wall-clock time in reading: 00:10:40.689162 processing: 00:02:41.851846 writing: 00:05:48.890638
```

dump with

```bash
python3 tests/data/dump_uvfits.py /mnt/data/1247842824_vis/1247842824_avg_2s_20kHz_flags.uvfits \
    --timestep-limit=30 --baseline-limit=3 --chan-limit=64  --dump-mode=weight-only \
    --dump-csv=/mnt/data/1247842824_vis/1247842824_avg_2s_20kHz_flags.uvfits.weight.csv
```

cotter on 1196

```bash
cotter \
  -m tests/data/1196175296_mwa_ord/1196175296_cotter-friendly.metafits \
  -o tests/data/1196175296_mwa_ord/1196175296_2s.uvfits \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -sbpassband tests/data/subband-passband-2ch-unitary.txt \
  -nostats \
  -sbcount 2 \
  -sbstart 1 \
  -timeres 2 \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  tests/data/1196175296_mwa_ord/1196175296_*gpubox*.fits \
  | tee cotter-1196175296-uvfits.log
```

```bash
python3 tests/data/dump_uvfits.py tests/data/1196175296_mwa_ord/1196175296_2s.uvfits \
    --timestep-limit=30 --baseline-limit=24 --dump-mode=vis-weight \
    --dump-csv=tests/data/1196175296_mwa_ord/1196175296_2s.uvfits.weight.csv

```







## Analysis of synthetic data


```bash
RUST_LOG=trace cargo run aoflagger \
  tests/data/1196175296_mwa_ord/1196175296*gpubox*.fits -m tests/data/1196175296_mwa_ord/1196175296.metafits --no-cable-delay -u tests/data/1196175296_mwa_ord/1196175296.birli.uvfits
python3 tests/data/dump_uvfits.py \
  tests/data/1196175296_mwa_ord/1196175296.birli.uvfits \
  --dump-mode=vis-only \
  --dump-csv=tests/data/1196175296_mwa_ord/1196175296.birli.uvfits.vis.csv \
  | tee tests/data/1196175296_mwa_ord/1196175296.birli.uvfits.txt

cotter \
  -m tests/data/1196175296_mwa_ord/1196175296cotter-friendly.metafits \
  -o tests/data/1196175296_mwa_ord/1196175296.cotter.uvfits \
  -allowmissing \
  -edgewidth 0 \
  -endflag 0 \
  -initflag 0 \
  -noantennapruning \
  -nocablelength \
  -noflagautos \
  -noflagdcchannels \
  -nogeom \
  -nosbgains \
  -sbpassband tests/data/subband-passband-2ch-unitary.txt \
  -sbstart 1 \
  -sbcount 2 \
  -nostats \
  -flag-strategy /usr/local/share/aoflagger/strategies/mwa-default.lua \
  tests/data/1196175296_mwa_ord/1196175296_*gpubox*.fits \
  | tee cotter-1196175296-uvfits.log
python3 tests/data/dump_uvfits.py \
  tests/data/1196175296_mwa_ord/1196175296.cotter.uvfits \
  --dump-mode=vis-only \
  --dump-csv=tests/data/1196175296_mwa_ord/1196175296.cotter.uvfits.vis.csv \
  | tee tests/data/1196175296_mwa_ord/1196175296.cotter.uvfits.txt

```

## Analysis of 1254670392 (highly averaged obs)

```bash
RUST_LOG=trace cargo run aoflagger /mnt/data/1254670392_vis/1254670392*gpubox*.fits -m /mnt/data/1254670392_vis/1254670392.metafits --no-cable-delay -u /mnt/data/1254670392_vis/1254670392.birli.uvfits
```

## Analysis of generated test data

```bash
python3 tests/data/dump_uvfits.py \
  tests/data/test_ants3.uvfits \
  --dump-mode=vis-only \
  --dump-csv=tests/data/test_ants3.uvfits.vis.csv \
  | tee tests/data/test_ants3.uvfits.txt
```