//! Flags and standard Samtools tags

use super::*;

/// Flags In Order: read paired: 1, read mapped in proper pair: 2, read unmapped: 4, mate unmapped: 8, read reverse strand: 16, mate reverse strand: 32, first in pair: 64, second in pair: 128, not primary alignment: 256, read fails quality checks: 512, read is PCR or optical duplicate: 1024, supplementary alignment: 2048
pub const FLAG_U16: [u16; 12] = [1,2,4,8,16,32,64,128,256,512,1024,2048];
lazy_static! {
    /// Common alignment explanations with their associated bit
    pub static ref FLAG_HASHMAP: HashMap<u16, &'static str,> = vec![(FLAG_U16[0], "is_paired"), (FLAG_U16[1], "is_proper_pair"), (FLAG_U16[2], "reads unmapped"), (FLAG_U16[3], "mate unmapped"), (FLAG_U16[4], "read reverse strand"), (FLAG_U16[5], "mate reverse strand"), (FLAG_U16[6], "first in pair"), (FLAG_U16[7], "second in pair"), (FLAG_U16[8], "not primary alignment"), (FLAG_U16[9], "read fails quality checks"), (FLAG_U16[10], "read is PCR or optical duplicate"), (FLAG_U16[11], "supplementary alignment")].into_iter().collect();
}

// Predefined standard tags are listed in the following table and described in greater detail in later subsections. Optional fields are usually displayed as TAG:TYPE:VALUE; the type may be one of A (character), B (general array), f (real number), H (hexadecimal array), i (integer), or Z (string).
pub const TAG: [&[u8]; 63] = [b"AM", b"AS", b"BC", b"BQ", b"BZ", b"CB", b"CC", b"CG", b"CM", b"CO", b"CP", b"CQ", b"CR", b"CS", b"CT", b"CY", b"E2", b"FI", b"FS", b"FZ", b"GZ", b"GQ", b"GS", b"H0", b"H1", b"H2", b"HI", b"IH", b"LB", b"MC", b"MD", b"MF", b"MI", b"MQ", b"NH", b"NM", b"OA", b"OC", b"OP", b"OQ", b"OX", b"PG", b"PQ", b"PT", b"PU", b"Q2", b"QT", b"QX", b"R2", b"RG", b"RT", b"RX", b"S2", b"SA", b"SM", b"SQ", b"TC", b"TS", b"U2", b"UQ", b"X?", b"Y?", b"Z?"];
pub const TAG_EXPLANATION: [&str; 63] = [r#"The smallest template-independent mapping quality in the template"#, r#"Alignment score generated by aligner"#, r#"Barcode sequence identifying the sample"#, r#"Offset to base alignment quality (BAQ)"#, r#"Phred quality of the unique molecular barcode bases in the OX tag"#, r#"Cell identifier"#, r#"Reference name of the next hit"#, r#"CIGAR in BAM’s binary encoding if (and only if) it consists of >65535 operators"#, r#"Edit distance between the color sequence and the color reference (see also NM)"#, r#"Free-text comments"#, r#"Leftmost coordinate of the next hit"#, r#"Color read base qualities"#, r#"Cellular barcode sequence bases (uncorrected)"#, r#"Color read sequence"#, r#"Complete read annotation tag, used for consensus annotation dummy features"#, r#"Phred quality of the cellular barcode sequence in the CR tag"#, r#"The 2nd most likely base calls"#, r#"The index of segment in the template"#, r#"Segment suffix"#, r#"Flow signal intensities"#, r#"Reserved for backwards compatibility reasons"#, r#"Reserved for backwards compatibility reasons"#, r#"Reserved for backwards compatibility reasons"#, r#"Number of perfect hits"#, r#"Number of 1-difference hits (see also NM)"#, r#"Number of 2-difference hits"#, r#"Query hit index"#, r#"Query hit total count"#, r#"Library"#, r#"CIGAR string for mate/next segment"#, r#"String encoding mismatched and deleted reference bases"#, r#"Reserved for backwards compatibility reasons"#, r#"Molecular identifier; a string that uniquely identifies the molecule from which the record was derived"#, r#"Mapping quality of the mate/next segment"#, r#"Number of reported alignments that contain the query in the current record"#, r#"Edit distance to the reference"#, r#"Original alignment"#, r#"Original CIGAR (deprecated; use OA instead)"#, r#"Original mapping position (deprecated; use OA instead)"#, r#"Original base quality"#, r#"Original unique molecular barcode bases"#, r#"Program"#, r#"Phred likelihood of the template"#, r#"Read annotations for parts of the padded read sequence"#, r#"Platform unit"#, r#"Phred quality of the mate/next segment sequence in the R2 tag"#, r#"Phred quality of the sample barcode sequence in the BC tag"#, r#"Quality score of the unique molecular identifier in the RX tag"#, r#"Sequence of the mate/next segment in the template"#, r#"Read group"#, r#"Reserved for backwards compatibility reasons"#, r#"Sequence bases of the (possibly corrected) unique molecular identifier"#, r#"Reserved for backwards compatibility reasons"#, r#"Other canonical alignments in a chimeric alignment"#, r#"Template-independent mapping quality"#, r#"Reserved for backwards compatibility reasons"#, r#"The number of segments in the template"#, r#"Transcript strand"#, r#"Phred probability of the 2nd call being wrong conditional on the best being wrong"#, r#"Phred likelihood of the segment, conditional on the mapping being correct"#, r#"Reserved for end users"#, r#"Reserved for end users"#, r#"Reserved for end users"# ];

lazy_static! {
pub static ref TAG_HASHMAP: HashMap<&'static [u8], &'static str> = vec![
    (TAG[0], TAG_EXPLANATION[0]), (TAG[1], TAG_EXPLANATION[1]), (TAG[2], TAG_EXPLANATION[2]), (TAG[3], TAG_EXPLANATION[3]), (TAG[4], TAG_EXPLANATION[4]), (TAG[5], TAG_EXPLANATION[5]), (TAG[6], TAG_EXPLANATION[6]), (TAG[7], TAG_EXPLANATION[7]), (TAG[8], TAG_EXPLANATION[8]), (TAG[9], TAG_EXPLANATION[9]), (TAG[10], TAG_EXPLANATION[10]), (TAG[11], TAG_EXPLANATION[11]), (TAG[12], TAG_EXPLANATION[12]), (TAG[13], TAG_EXPLANATION[13]), (TAG[14], TAG_EXPLANATION[14]), (TAG[15], TAG_EXPLANATION[15]), (TAG[16], TAG_EXPLANATION[16]), (TAG[17], TAG_EXPLANATION[17]), (TAG[18], TAG_EXPLANATION[18]), (TAG[19], TAG_EXPLANATION[19]), (TAG[20], TAG_EXPLANATION[20]), (TAG[21], TAG_EXPLANATION[21]), (TAG[22], TAG_EXPLANATION[22]), (TAG[23], TAG_EXPLANATION[23]), (TAG[24], TAG_EXPLANATION[24]), (TAG[25], TAG_EXPLANATION[25]), (TAG[26], TAG_EXPLANATION[26]), (TAG[27], TAG_EXPLANATION[27]), (TAG[28], TAG_EXPLANATION[28]), (TAG[29], TAG_EXPLANATION[29]), (TAG[30], TAG_EXPLANATION[30]), (TAG[31], TAG_EXPLANATION[31]), (TAG[32], TAG_EXPLANATION[32]), (TAG[33], TAG_EXPLANATION[33]), (TAG[34], TAG_EXPLANATION[34]), (TAG[35], TAG_EXPLANATION[35]), (TAG[36], TAG_EXPLANATION[36]), (TAG[37], TAG_EXPLANATION[37]), (TAG[38], TAG_EXPLANATION[38]), (TAG[39], TAG_EXPLANATION[39]), (TAG[40], TAG_EXPLANATION[40]), (TAG[41], TAG_EXPLANATION[41]), (TAG[42], TAG_EXPLANATION[42]), (TAG[43], TAG_EXPLANATION[43]), (TAG[44], TAG_EXPLANATION[44]), (TAG[45], TAG_EXPLANATION[45]), (TAG[46], TAG_EXPLANATION[46]), (TAG[47], TAG_EXPLANATION[47]), (TAG[48], TAG_EXPLANATION[48]), (TAG[49], TAG_EXPLANATION[49]), (TAG[50], TAG_EXPLANATION[50]), (TAG[51], TAG_EXPLANATION[51]), (TAG[52], TAG_EXPLANATION[52]), (TAG[53], TAG_EXPLANATION[53]), (TAG[54], TAG_EXPLANATION[54]), (TAG[55], TAG_EXPLANATION[55]), (TAG[56], TAG_EXPLANATION[56]), (TAG[57], TAG_EXPLANATION[57]), (TAG[58], TAG_EXPLANATION[58]), (TAG[59], TAG_EXPLANATION[59]), (TAG[60], TAG_EXPLANATION[60]), (TAG[61], TAG_EXPLANATION[61]), (TAG[62], TAG_EXPLANATION[62])
    ].into_iter().collect();
}

// AM i AS i BC Z BQ Z BZ Z CB Z CC Z CG B,I 
// CM i CO Z CP i CQ Z CR Z CS Z CT Z CY Z E2 Z 
// FI i FS Z FZ B,S GC ? GQ ? GS ? H0 i H1 i 
// H2 i HI i IH i LB Z MC Z MD Z MF ? MI Z 
// MQ i NH i NM i OA Z OC Z OP i OQ Z OX Z PG Z 
// PQ i PT Z PU Z Q2 Z QT Z QX Z R2 Z RG Z RT ? 
// RX Z S2 ? SA Z SM i SQ ? 
// TC i TS A U2 Z UQ i X? ? Y? ? Z? ? 
